import random
import myutils
random.seed(8446)

for newSetup in [False, True]:
    for dataset in myutils.relTreebanks:
        for dropout in [.4, .2, .3]:
            for cut_frac in [.1,.2, .3]:
                for decay in [.35, .38, .5]:
                    lang = dataset.split('_')[1].split('-')[0]
                    for dropout in [.4, .2, .3]:
                        name = '.'.join([str(x).replace('.','') for x in [dropout, cut_frac, decay]])
                        if newSetup == False:
                            name += '.oldSetup'
                        model = myutils.getModel(dataset + '.' + name)
                        if model == '':
                            print('MODEL NOT FOUND', name)
                        else:
                            goldFile = '../newsplits-v2.7/' + dataset + '/dev.conllu'
                            outFile = '../preds/' + dataset + '.' + name
                            cmd = 'python3 predict.py ' + model[4:] + ' ' + goldFile + ' ' + outFile + ' > ' + outFile + '.eval'
                            print(cmd)
                        #base.to_file('configs/params.' + name + '.json')
                        #cmd = 'python3 train.py --name ' + dataset + '.' + name 
                        #cmd += ' --dataset_config ../configs/' + dataset + '.json'
                        #cmd += ' --parameters_config ../configs/params.' + name + '.json'
                        #cmd += ' --seed ' + seed
                        #cmds.append(cmd)
    


