from abc import ABCMeta, abstractmethod
from typing import Dict
from state import State


class Action(metaclass=ABCMeta):
    """The abstract base class definition of Action.
    
    An Action consists of two functions, 
    one is can_do(), which determines if the current state can perform the action, 
    and the other is do(), which performs the action on the current state.
    
    Extends:
        metaclass=ABCMeta
    """
    @abstractmethod
    def can_do(self, state: State):
        pass

    @abstractmethod
    def do(self, state: State):
        pass