from abc import ABCMeta

from coli.bilexical_base import graph_utils, tree_utils
from coli.parser_tools.parser_base import DependencyParserBase


class GraphParserBase(DependencyParserBase, metaclass=ABCMeta):
    available_data_formats = {"sdp2014": graph_utils.Graph, "sdp2015": graph_utils.Graph2015}
    default_data_format_name = "sdp2014"


class TreeParserBase(DependencyParserBase, metaclass=ABCMeta):
    available_data_formats = {"conllu": tree_utils.Sentence}
    default_data_format_name = "conllu"