/*
 * Decompiled with CFR 0.152.
 */
package sdp.graph;

import sdp.graph.DFS;
import sdp.graph.Edge;
import sdp.graph.Graph;
import sdp.graph.Node;

public class InspectedGraph {
    private final Graph graph;
    private final int nNonWallNodes;
    private final DFS directedDFS;
    private final DFS undirectedDFS;
    private final boolean[] isSingleton;
    private final int nSingletons;

    public InspectedGraph(Graph graph) {
        this.graph = graph;
        int nNodes = graph.getNNodes();
        this.nNonWallNodes = nNodes - 1;
        this.isSingleton = new boolean[nNodes];
        this.nSingletons = this.computeSingletons();
        this.directedDFS = new DFS(graph);
        this.undirectedDFS = new DFS(graph, true);
    }

    public int getNNonWallNodes() {
        return this.nNonWallNodes;
    }

    public int getNComponents() {
        return this.undirectedDFS.getNRuns();
    }

    public boolean isCyclic() {
        return this.directedDFS.isCyclic();
    }

    private int computeSingletons() {
        int n = 0;
        for (Node node : this.graph.getNodes()) {
            if (node.id == 0 || node.hasIncomingEdges() || node.hasOutgoingEdges() || node.isTop) continue;
            this.isSingleton[node.id] = true;
            ++n;
        }
        return n;
    }

    public boolean isSingleton(int id) {
        return this.isSingleton[id];
    }

    public int getNSingletons() {
        return this.nSingletons;
    }

    public int getMaximalIndegree() {
        int max = 0;
        for (Node node : this.graph.getNodes()) {
            max = Math.max(max, node.getNIncomingEdges());
        }
        return max;
    }

    public int getMaximalOutdegree() {
        int max = 0;
        for (Node node : this.graph.getNodes()) {
            max = Math.max(max, node.getNOutgoingEdges());
        }
        return max;
    }

    public int getNRootNodes() {
        int nRootNodes = 0;
        for (Node node : this.graph.getNodes()) {
            nRootNodes += node.hasIncomingEdges() ? 0 : 1;
        }
        return nRootNodes - 1;
    }

    public int getNLeafNodes() {
        int nLeafNodes = 0;
        for (Node node : this.graph.getNodes()) {
            nLeafNodes += node.hasOutgoingEdges() ? 0 : 1;
        }
        return nLeafNodes - 1;
    }

    public boolean isForest() {
        return !this.isCyclic() && this.getMaximalIndegree() <= 1;
    }

    public boolean isTree() {
        return this.isForest() && this.getNRootNodes() == 1;
    }

    public boolean isProjective() {
        for (Edge edge1 : this.graph.getEdges()) {
            int min1 = Math.min(edge1.source, edge1.target);
            int max1 = Math.max(edge1.source, edge1.target);
            for (Edge edge2 : this.graph.getEdges()) {
                int max2;
                int min2 = Math.min(edge2.source, edge2.target);
                if (!InspectedGraph.overlap(min1, max1, min2, max2 = Math.max(edge2.source, edge2.target))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean overlap(int min1, int max1, int min2, int max2) {
        return min1 < min2 && min2 < max1 && max1 < max2 || min2 < min1 && min1 < max2 && max2 < max1;
    }
}

