/*
 * Decompiled with CFR 0.152.
 */
package sdp.graph;

import sdp.graph.Edge;
import sdp.graph.Graph;
import sdp.graph.Node;

public class DFS {
    private final boolean undirected;
    private final Graph graph;
    private final int[] run;
    private int nRuns;
    private final int[] enter;
    private final int[] leave;

    public DFS(Graph graph, boolean undirected) {
        this.undirected = undirected;
        this.graph = graph;
        int nNodes = graph.getNNodes();
        this.run = new int[nNodes];
        this.enter = new int[nNodes];
        this.leave = new int[nNodes];
        this.computeTimestamps();
    }

    public DFS(Graph graph) {
        this(graph, false);
    }

    private void computeTimestamps() {
        for (Node node : this.graph.getNodes()) {
            this.enter[node.id] = -1;
        }
        Timer timer = new Timer();
        for (Node node : this.graph.getNodes()) {
            if (this.enter[node.id] != -1) continue;
            this.computeTimestamps(node, timer);
            ++this.nRuns;
        }
    }

    private void computeTimestamps(Node node, Timer timer) {
        this.run[node.id] = this.nRuns;
        this.enter[node.id] = timer.tick();
        for (Edge outgoingEdge : node.getOutgoingEdges()) {
            if (this.enter[outgoingEdge.target] != -1) continue;
            this.computeTimestamps(this.graph.getNode(outgoingEdge.target), timer);
        }
        if (this.undirected) {
            for (Edge incomingEdge : node.getIncomingEdges()) {
                if (this.enter[incomingEdge.source] != -1) continue;
                this.computeTimestamps(this.graph.getNode(incomingEdge.source), timer);
            }
        }
        this.leave[node.id] = timer.tick();
    }

    public int getNRuns() {
        return this.nRuns;
    }

    public boolean isSelfLoop(Edge edge) {
        return edge.source == edge.target;
    }

    public boolean isBackEdge(Edge edge) {
        return this.enter[edge.target] < this.enter[edge.source] && this.leave[edge.source] < this.leave[edge.target];
    }

    public boolean isCyclic() {
        for (Edge edge : this.graph.getEdges()) {
            if (!this.isSelfLoop(edge) && !this.isBackEdge(edge)) continue;
            return true;
        }
        return false;
    }

    private static final class Timer {
        private int time;

        private Timer() {
        }

        public int tick() {
            return this.time++;
        }
    }
}

