def buildMainTrival(tokens):
    seqLen = len(tokens)
    node2seq = [i for i in range(seqLen)]
    seq2node = [i for i in range(seqLen)]
    edges = [[], []]
    for i in range(seqLen):
        if i > 0:
            edges[0].append([seq2node[i-1], seq2node[i], 1])
        if i < seqLen - 1:
            edges[1].append([seq2node[i], seq2node[i+1], 1])
    return seqLen, node2seq, seq2node, edges


def buildMainUnigram(tokens):
    seqLen = len(tokens)
    unigrams = []
    node2seq = []
    seq2node = []
    edges = [[], []]
    for i in range(seqLen):
        if not tokens[i].text in unigrams:
            unigrams.append(tokens[i].text)
            seq2node.append(len(node2seq))
            node2seq.append(i)
        else:
            currentNode = unigrams.index(tokens[i].text)
            seq2node.append(currentNode)
    for i in range(seqLen):
        if i > 0:
            edges[0].append([seq2node[i-1], seq2node[i], 1])
        if i < seqLen - 1:
            edges[1].append([seq2node[i], seq2node[i+1], 1])
    return len(node2seq), node2seq, seq2node, edges


def buildDictWithWord(startNode, seq2node, matches):
    node2idx = []
    edges = [[], []]
    countMode = False
    if len(seq2node) == 0:
        countMode = True
    for match in matches:
        if match[2] in node2idx:
            dicNode = startNode + node2idx.index(match[2])
        else:
            dicNode = startNode + len(node2idx)
            node2idx.append(match[2])
        if not countMode:
            edges[0].append([dicNode, seq2node[match[0]], 1])
            edges[1].append([seq2node[match[0]], dicNode, 1])
            edges[0].append([seq2node[match[1] - 1], dicNode, 1])
            edges[1].append([dicNode, seq2node[match[1] - 1], 1])
        for i in range(match[0], match[1]):
            if i < match[1] - 1 and not countMode:
                edges[0].append([seq2node[i], seq2node[i + 1], 1])
            if i > match[0] and not countMode:
                edges[1].append([seq2node[i], seq2node[i - 1], 1])
    if len(node2idx) == 0:
        node2idx = [0]
    return len(node2idx), node2idx, edges


def buildDictWithAbstractNode(startNode, seq2node, matches):
    node2idx = [2, 3]
    edges = [[], []]
    countMode = False
    if len(seq2node) == 0:
        countMode = True
    for match in matches:
        if not countMode:
            edges[0].append([startNode, seq2node[match[0]], 1])
            edges[1].append([seq2node[match[0]], startNode, 1])
            edges[0].append([seq2node[match[1]], startNode + 1, 1])
            edges[1].append([startNode + 1, seq2node[match[1]], 1])
        for i in range(match[0], match[1]):
            if i < match[1] - 1 and not countMode:
                edges[0].append([seq2node[i], seq2node[i + 1], 1])
            if i > match[0] and not countMode:
                edges[1].append([seq2node[i], seq2node[i - 1], 1])
    return 2, node2idx, edges

def buildKnowledge1Hop(startNode, seq2node, matches):
    """
    :param startNode:
    :param seq2node:
    :param matches: [[wordStartPos, wordEndPos, entityId, rels]]
                    rels: list
                    rel: [relId, objectId]
    :return:
    """
    node2idx = []
    edges = [[]]
    countMode = False
    if len(seq2node) == 0:
        countMode = True
    for match in matches:
        wordStartPos, wordEndPos, entityId, rels = match
        if entityId in node2idx:
            kid = startNode + node2idx.index(entityId)
        else:
            kid = startNode + len(node2idx)
            node2idx.append(entityId)
        if not countMode:
            edges[0].append([seq2node[wordStartPos], kid, 1])
        for rel in rels:
            if rel[1] in node2idx:
                oid = startNode + node2idx.index(rel[1])
            else:
                oid = startNode + len(node2idx)
                node2idx.append(rel[1])
            if not countMode:
                edges[0].append([kid, oid, 1])
    if len(node2idx) == 0:
        node2idx = [0]
    return len(node2idx), node2idx, edges


def buildKnowledge1HopReduce(startNode, seq2node, matches):
    """
    :param startNode:
    :param seq2node:
    :param matches: [[wordStartPos, wordEndPos, entityId, rels]]
                    rels: list
                    rel: [relId, objectId]
    :return:
    """
    rawNode2idx = []
    nodeOccCount = {}
    node2idx = []
    edges = [[]]
    countMode = False
    if len(seq2node) == 0:
        countMode = True
    for match in matches:
        wordStartPos, wordEndPos, entityId, rels = match
        if entityId in node2idx:
            nodeOccCount[entityId] += 1
        else:
            rawNode2idx.append(entityId)
            nodeOccCount[entityId] = 0
        for rel in rels:
            if rel[1] in node2idx:
                nodeOccCount[rel[1]] += 1
            else:
                rawNode2idx.append(rel[1])
                nodeOccCount[rel[1]] = 0

    for match in matches:
        wordStartPos, wordEndPos, entityId, rels = match
        if entityId in node2idx:
            kid = startNode + node2idx.index(entityId)
        else:
            kid = startNode + len(node2idx)
            node2idx.append(entityId)
        if not countMode:
            edges[0].append([seq2node[wordStartPos], kid, 1])
        for rel in rels:
            if nodeOccCount[rel[1]] == 0:
                continue
            if rel[1] in node2idx:
                oid = startNode + node2idx.index(rel[1])
            else:
                oid = startNode + len(node2idx)
                node2idx.append(rel[1])
            if not countMode:
                edges[0].append([kid, oid, 1])
    if len(node2idx) == 0:
        node2idx = [0]
    return len(node2idx), node2idx, edges
