///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <fstream>
#include <sstream>
#include <getopt.h>

#include "nl-randvar.h"
#include "nl-dtree.h"
#include "nl-iomacros.h"
#include "nl-refrv.h"
//#include "nl-modelfile.h"

//char psX[]="";
//char psUscUscUsc[]="___";

//#define NOISY 1

#define THRESHOLD 0.0

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

#include "TextObsVars.h"
#include "PCFGLangModel-md.h"
#include "TextObsModel-svs.h"

////////////////////////////////////////////////////////////////////////////////
//
//  helper classes, functions
//
////////////////////////////////////////////////////////////////////////////////

bool NOISY = false;

class ChartCell {
 private:
  typedef UDLCI G;
  static const ChartCell ccDummy;
  bool             bRooted;
  G                g;
  int              k;
  const ChartCell* pcc1;
  const ChartCell* pcc2;
  LogProb          pr; // max
 public:
  ChartCell ( )                                                                              : bRooted(false), g(),   k(0),  pcc1(NULL),  pcc2(NULL), pr()    { }
  ChartCell ( const G& gA,                                                     LogProb prA ) : bRooted(false), g(gA), k(0),  pcc1(NULL),  pcc2(NULL), pr(prA) { }
  ChartCell ( const G& gA,         const ChartCell& cc1,                       LogProb prA ) : bRooted(false), g(gA), k(0),  pcc1(&cc1),  pcc2(NULL), pr(prA) { }
  ChartCell ( const G& gA, int kA, const ChartCell& cc1, const ChartCell& cc2, LogProb prA ) : bRooted(false), g(gA), k(kA), pcc1(&cc1),  pcc2(&cc2), pr(prA) { }
  void setRooted ( )       { bRooted=true; }
  bool getRooted ( ) const { return bRooted; }
  bool operator!= ( const ChartCell& cc ) const { return (g!=cc.g || k!=cc.k || pcc1!=cc.pcc1 || pcc2!=cc.pcc2 || pr!=cc.pr); }
  const G&         getG    ( ) const { return g;  }
  int              getK    ( ) const { return k;  }
  const ChartCell& getCC1  ( ) const { return (pcc1!=NULL) ? *pcc1 : ccDummy; }
  const ChartCell& getCC2  ( ) const { return (pcc2!=NULL) ? *pcc2 : ccDummy; }
  LogProb          maxProb ( ) const { return pr; }
  void prune      ( ) { /*???*/ }
  void writeBest  ( FILE* pf, List<X>& lx ) const { 
    fprintf(pf," (%s:%s{%s}",g.first.second.first.getString().c_str(),g.first.second.second.getString().c_str(),g.second.getString().c_str());
    if(pcc1)pcc1->writeBest(pf,lx);
    if(pcc2)pcc2->writeBest(pf,lx);
    if(!pcc1 && !pcc2){fprintf(pf," ");fprintf(pf,"%s",lx.getFirst()->getString().c_str());lx.pop();}
    fprintf(pf,")"); }
};
const ChartCell ChartCell::ccDummy;

////////////////////////////////////////////////////////////////////////////////

typedef SimpleHash<UDLCI,ChartCell> RefCell;
//std::map<G2Cell,G2Cell> domCell;
//typedef RefRV<G2Cell,domCell> RefCell;
//typedef SafePtr<G2Cell> RefCell;
//typedef pair<G,ChartCell> GCell;
//std::map<GCell,GCell> domCell;
//typedef RefRV<GCell,domCell> RefCell;


////////////////////////////////////////////////////////////////////////////////

/*
void tryUnary ( SafeArray2D<Id<int>,Id<int>,RefCell>& accChart, int i, int j, const ChartCell& ccG, const GuModel& modGgivG ) {
  G gP;
//  for ( bool bgp=gP.setFirst(); bgp; bgp=gP.setNext() ) {
  for ( GuModel::const_iterator iter = modGgivG.begin(); iter!=modGgivG.end(); iter++ ) {
    G          gP = iter->first.getX1();
    G          gg = ccG.getG();
    ChartCell& ccP = accChart.set(i,j).set(gP);
    LogProb    pr = ccG.maxProb()*modGgivG.getProb(gg,gP);
    if ( pr>ccP.maxProb() ) {
      ccP = ChartCell(gP,ccG,pr);
      if ( NOISY )
        cout << "unary match! " << i << " " << j << " " << gP << " -> " << gg << " -> " << pr.toInt() << endl;
      tryUnary ( accChart, i, j, ccP, modGgivG );
    }
  }
}
*/

////////////////////////////////////////////////////////////////////////////////
//
//  Main Function (pipe data input)
//
////////////////////////////////////////////////////////////////////////////////

static struct option long_options[] = {
  {"forest", optional_argument, 0, 'f'},
  {"help", no_argument, 0, 'h'},
  {"verbose", no_argument, 0, 'v'},
  {0, 0, 0, 0} };

void printUsage(char* progname) {
  fprintf(stderr,"Usage: cat <RAW_FILE> | %s [OPTIONS]... [MODEL_FILE1] [MODEL_FILE2] ...\n",progname);
  fprintf(stderr,"Runs the speech recognition system on RAW_FILE using the models in MODEL_FILE1, 2, etc.\n");
  fprintf(stderr," System variable Settings:\n");
  fprintf(stderr,"  -f, --forest=TRUE\n");
  fprintf(stderr,"  -h, --help\t\tPrint this message\n");
  fprintf(stderr,"  -v, --verbose=TRUE\n");
}

int main (int nArgs, char* argv[]) {

  //modGgivG.NOISY_READ = true;

  bool FOREST = false;

  //GGModel modGGgivG;
  MModel  modM;
  LModel  modL;
  //GuModel modGgivG;
  GrModel modGr;
  //LCModel  modLC;
  //HWModel modHW;
  XModel  modX;

  // Parse command-line options
  char* progname = strdup(argv[0]);
  int option_index = 0;
  char opt;
  while( (opt = getopt_long(nArgs, argv, "fhv", long_options, &option_index)) != -1 ) {
    switch(opt) {
    case 'f': FOREST=true; break;
    case 'h': printUsage(progname); exit(0);
    case 'v': NOISY=true; break;
    default: break;
    }
  }

  for ( int a=optind; a<nArgs; a++ ) {
    FILE* pf = fopen(argv[a],"r"); assert(pf);                                // READ MODEL FILE
    cerr << "Loading model \'" << argv[a] << "\'...\n";
    int c=' '; int i=0; int line=1; Array<char*> aps(100); String sBuff(1000);   // Lookahead/ctrs/buffers
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
    while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
      CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
      String sBuff2(sBuff); StringInput si(sBuff2.c_array());
      //sBuff.split(aps," :=");                                                  //   Split into fields
      //cerr<<si.c_str()<<endl;
      if ( !( sBuff[0]=='#' ||                                                   //   Accept comments/fields
              //si>>mH>>"\0"!=NULL ||
              si>>modX>>"\0"!=NULL ||
	      //si>>"LC ">>modLC>>"\0"!=NULL || 
	      si>>"Gr ">>modGr>>"\0"!=NULL || 
	      //si>>"Gu ">>modGgivG>>"\0"!=NULL || 
	      //si>>"GG ">>modGGgivG>>"\0"!=NULL ) )
	      //si>>"HW ">>modHW>>"\0"!=NULL || 
	      si>>"M ">>modM>>"\0"!=NULL || 
	      si>>"L ">>modL>>"\0"!=NULL ) )
	      //si>>"Pc ">>modPgivCvar>>"\0"!=NULL ||
	      //si>>"Pw ">>modPgivWs>>"\0"!=NULL ||
	      //si>>"PwDT ">>modPgivWdt>>"\0"!=NULL ||
	      //si>>"P ">>modP>>"\0"!=NULL ) )
	      ////mH.readFields(aps) || mO.readFields(aps)*/ ) )
	//	cerr<<"\nERROR: "<<aps.size()<<"-arg "<<((aps.size()>0)?aps[0]:"??")<<" in line "<<line<<"\n\n";
	cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
      CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
      if ( line%100000==0 ) cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
    }
    cerr << "Model \'" << argv[a] << "\' loaded.\n";
  }
//   for ( int i=optind; i<nArgs; i++ ) {
//     cerr << "Loading model \'" << argv[i] << "\'\n";
//     FILE* pf = fopen(argv[i],"r"); 
//     assert(pf);
//     processModelFilePtr ( pf, readFields );
//     cerr << "Model \'" << argv[i] << "\' loaded.\n";
//   }

  ifstream fin;
  List<X>  lx;
  string   sLine;
  int ctr=0;

//  if (nArgs>2) fin.open(argv[2]);

  // Read in each line...
//  while ( (nArgs>2) ? getline(fin,sLine) : getline(cin,sLine) ) {
  while ( getline(cin,sLine) ) {
    ctr++;
    cerr << ctr ;

    // Read in each word...
    stringstream ss(stringstream::in|stringstream::out);
    lx=List<X>();
    ss<<sLine;
    for (string s; ss>>s; ) {
      cerr << " " << s;
      lx.add() = X(s.c_str()); //.read(s);
    }

    cerr << endl;

    // Allocate chart...
    SafeArray2D<Id<int>,Id<int>,RefCell> accChart;
    int n = lx.getCard();
    accChart.init ( n+1, n+2 );

    // Initialize chart with terminals (POSs)...
    int i=0;
    Listed(X)* px;
    foreach(px,lx) {

      X& x = *px;
      if ( NOISY )
        cerr << "word " << px->getString() << endl;

      for ( MModel::const_iterator iudlcilclc = modM.begin(); iudlcilclc!=modM.end(); iudlcilclc++ ) {
        const UDLCI& udlci = iudlcilclc->first.getX1();
        MModel::IterVal lclc;
        for ( bool blclc = modM.setFirst(lclc,udlci); blclc; blclc = modM.setNext(lclc,udlci) ) {
          if ( LCLC_BOT == lclc ) {
            LogProb pr  = modM.getProb(lclc,udlci) * modX.getProb(x,udlci.first.second.second,udlci.second);

            if ( pr != LogProb() ) {
              ChartCell* pcc = &accChart.set(i,i+1).set(udlci);
              *pcc = ChartCell ( udlci, pr );
              if ( NOISY )
                cerr << "pos match! " << i << " " << i+1 << " " << udlci << " -> " << px->getString()
                     << "=" << pcc->maxProb().toInt() << endl;

              // if ( FOREST )
              //    fprintf ( stdout, "%d %s:%s{%s} %d : %d %s %d = %d\n",
              //              i, g.second.first.getString().c_str(), g.second.second.getString().c_str(), g.second.third.getString().c_str(), i+1,
              //              i, px->getString().c_str(), i+1, x.getProb(g.second.second,g.second.third).toInt() );
            }
          }
        }
      }
      i++;
    }

    // Fill chart with nonterminals...
    for ( int di=1; di<=n; di++ ) {
      cerr << "  " << di << endl;
      for ( int i=0; i<=n-di; i++ ) {
        int j=i+di;

	    /*** SWU 2/8/10: commented out to switch to m = udlce -> lc lc
	    // Calculate the factored probabilities all at once -- unaccessed after first run
	    MModel::IterVal ilclc;
	    LModel::IterVal ieLeft;
	    LModel::IterVal ieRight;
	    if ( !modGGgivG.contains(gP) ) {
	      //cerr<<" entering loop w/ gParent = "<<gP<<"\n";
	      for ( bool bg=modM.setFirst(ilclc,grP); bg; bg=modM.setNext(ilclc,grP) ) {
		L lLeft  = ilclc.first.first;
		L lRight = ilclc.second.first;
		//cerr<<"  iter over lc lc = "<<lLeft<<":"<<ilclc.first.second<<" "<<lRight<<":"<<ilclc.second.second<<endl;

		E  eP = gP.third;
		D  dL = (gP.first.first==U_R) ? D(gP.first.second.toInt()+1) : D(gP.first.second.toInt());
		UD udL( U_L, dL );
		UD udR( U_R, gP.first.second );

		for ( bool ble=modL.setFirst(ieLeft,lLeft,eP); ble; ble=modL.setNext(ieLeft,lLeft,eP) ) {
		  //cerr<<"   iter over eLeft = "<<ieLeft<<endl;
		  for ( bool ble=modL.setFirst(ieRight,lRight,eP); ble; ble=modL.setNext(ieRight,lRight,eP) ) {
		    //cerr<<"   iter over eRight = "<<ieRight<<endl;
		    GG gg = GG( G(udL,ilclc.first.second,ieLeft), G(udR,ilclc.second.second,ieRight) );
		    Prob pOld = modGGgivG.getProb(gg,gP);
		    modGGgivG.setProb(gg,gP) = 
		      pOld //modGGgivG.getProb(gg,gP).toDouble()
		      + modM.getProb(ilclc,grP)*modL.getProb(ieLeft,lLeft,eP)*modL.getProb(ieRight,lRight,eP);
		    //cerr<<" trying to calc "<<" "<<gP<<" -> "<<ilclc<<" ("<<modM.getProb(ilclc,gP)<<")"<<",    "
		    //<<lLeft<<" "<<eP<<" -> "<<ieLeft<<" ("<<modL.getProb(ieLeft,lLeft,eP)<<")"<<",    "
		    //<<lRight<<" "<<eP<<" -> "<<ieRight<<" ("<<modL.getProb(ieRight,lRight,eP)<<")     "
		    //<<pOld.toDouble()<<" = "<<modGGgivG.getProb(gg,gP).toDouble()<<" = "
		    //<<LogProb(modGGgivG.getProb(gg,gP)).toInt()<<endl;
		  }
		}
	      }
	    }
	    ***/

	    //// Check/fill the chart
            //GGModel::IterVal gg;
            //for ( bool bgg=modGGgivG.setFirst(gg,gP); bgg; bgg=modGGgivG.setNext(gg,gP) ) {
	    //if ( LogProb(modGGgivG.getProb(gg,gP))>LogProb(THRESHOLD) ) {

        for ( MModel::const_iterator iudlcilclc = modM.begin(); iudlcilclc!=modM.end(); iudlcilclc++ ) {
          UDLCI udlci = iudlcilclc->first.getX1();
          MModel::IterVal lclc;
          for ( bool blclc = modM.setFirst(lclc,udlci); blclc; blclc = modM.setNext(lclc,udlci) ) {
            I     iP    = udlci.second;
            L     l0    = lclc.first.first;
            L     l1    = lclc.second.first;

	    D     dL    = (udlci.first.first.first==U_R) ? D(udlci.first.first.second.toInt()+1) : D(udlci.first.first.second.toInt());
	    UD    udL   ( U_L, dL );
	    UD    udR   ( U_R, udlci.first.first.second );

            UDLC  udlc0 = UDLC(udL,lclc.first);
            UDLC  udlc1 = UDLC(udR,lclc.second);

            LModel::IterVal i0;
            for ( bool b0 = modL.setFirst(i0,l0,iP); b0; b0 = modL.setNext(i0,l0,iP) ) {
              LModel::IterVal i1;
              for ( bool b1 = modL.setFirst(i1,l1,iP); b1; b1 = modL.setNext(i1,l1,iP) ) {
                UDLCI udlci0 = UDLCI(udlc0,i0);
                UDLCI udlci1 = UDLCI(udlc1,i1);

                for ( int k=i+1; k<=j-1; k++ ) {

                  const ChartCell& cc0 = accChart.get(i,k).get(udlci0);
                  const ChartCell& cc1 = accChart.get(k,j).get(udlci1);
                  if ( cc0!=ChartCell() && cc1!=ChartCell() ) {
                    ChartCell& cc = accChart.set(i,j).set(udlci);
                    LogProb    pr = modM.getProb(lclc,udlci) * modL.getProb(i0,l0,iP) * cc0.maxProb() * modL.getProb(i1,l1,iP) * cc1.maxProb();

                    if ( NOISY )
                      cerr << "      binary match! " << i << " " << k << " " << j << " " << udlci
                           << " -> " << udlci0 << " " << udlci1 << " "
                           << iudlcilclc->second << "*"
                           << modL.getProb(i0,l0,iP).toInt() << "*" << cc0.maxProb().toInt() << "*"
                           << modL.getProb(i1,l1,iP).toInt() << "*" << cc1.maxProb().toInt() << "*" 
                           << "=" << pr.toInt() << endl;
                    if ( pr>cc.maxProb() )
                      cc = ChartCell(udlci,k,cc0,cc1,pr);
                  }
                }
              }
            }
          }
        }
      }
    }


// 	    MModel::IterVal ilclc;
// 	    LModel::IterVal ieLeft;
// 	    LModel::IterVal ieRight;

// 	    for ( bool blclc=modM.setFirst(ilclc,gP); blclc; blclc=modM.setNext(ilclc,gP) ) {

// 	      L lLeft  = ilclc.first.first;
// 	      L lRight = ilclc.second.first;

// 	      for ( bool ble=modL.setFirst(ieLeft,lLeft,eP); ble; ble=modL.setNext(ieLeft,lLeft,eP) ) {
// 		//cerr<<"   iter over eLeft = "<<ieLeft<<endl;
// 		for ( bool ble=modL.setFirst(ieRight,lRight,eP); ble; ble=modL.setNext(ieRight,lRight,eP) ) {
// 		  //cerr<<"   iter over eRight = "<<ieRight<<endl;
		  
// 		  G g1 = G(udL,LCE(ilclc.first.first,ilclc.first.second,ieLeft));
// 		  G g2 = G(udR,LCE(ilclc.second.first,ilclc.second.second,ieRight));
		
// 		  //cerr  << i << "," << k << "," << j << " found M rule "<< gP << " -> " << ilclc << endl;
// 		  const ChartCell& cc1 = accChart.get(i,k).get(g1);
// 		  const ChartCell& cc2 = accChart.get(k,j).get(g2);
// 		  if ( cc1!=ChartCell() && cc2!=ChartCell() ) {
// 		    ChartCell& cc = accChart.set(i,j).set(gP);
// 		    LogProb pr = cc1.maxProb() * cc2.maxProb()
// 		      * LogProb(modM.getProb(ilclc,gP)) * LogProb(modL.getProb(ieLeft,lLeft,eP)) * LogProb(modL.getProb(ieRight,lRight,eP));
// 		    if ( NOISY )
// 		      cerr << "      binary match! " << i << " " << k << " " << j << " " << gP
// 			   << " -> " << g1 << " " << g2 << " "
// 			   << cc1.maxProb().toInt() << "*" << cc2.maxProb().toInt() << "*" 
// 			   << LogProb(modM.getProb(ilclc,gP)) 
// 			   << "*" << LogProb(modL.getProb(ieLeft,lLeft,eP)) << "*" << LogProb(modL.getProb(ieRight,lRight,eP))
// 			   << "=" << pr.toInt() << endl;
// 		    //if ( FOREST )
// 		    //  fprintf ( stdout, "%d %s %d : %d %s %d %s %d = %d\n",
// 		    //            i, gP.getString().c_str(), j,
// 		    //            i, g1.getString().c_str(), k, g2.getString().c_str(), j, pr.toInt() );
// 		    if ( pr>cc.maxProb() ) {
// 		      cc = ChartCell(gP,k,cc1,cc2,pr);
// 		      //tryUnary ( accChart, i, j, cc, modGgivG );
// 		    }
// 		  }
//                 }
//               }
//             }
//           }
//         }
//       }
//     }

//     if ( FOREST ) {

//       //ModeledC c;
//       GModel::IterVal gr;
//       for ( bool bgr=modGr.setFirst(gr); bgr; bgr=modGr.setNext(gr) )
//         if ( accChart.get(0,n).get(gr).getProb()*modGr.getProb(gr) != LogProb() ) {
//           accChart.set(0,n).set(gr).setRooted();
//         }

//       for ( int di=n; di>=1; di-- ) {
//         //cerr << "  " << di << endl;
//         for ( int i=0; i<=n-di; i++ ) {
//           int j=i+di;
// 	  for ( MModel::const_iterator iudlcilclc = modM.begin(); iudlcilclc!=modM.end(); iudlcilclc++ ) {
// 	    G gP = iudlcilclc->first.getCC1();

//             const ChartCell& cc  = accChart.get(i,j).get(gP);
//             if ( cc.getRooted() ) {
//               for ( int k=i+1; k<=j-1; k++ ) {
// 		E eP = E(gP.second.third);
		
// 		D  dL = (gP.first.first==U_R) ? D(gP.first.second.toInt()+1) : D(gP.first.second.toInt());
// 		UD udL( U_L, dL );
// 		UD udR( U_R, gP.first.second );
		
// 		MModel::IterVal ilclc;
// 		LModel::IterVal ieLeft;
// 		LModel::IterVal ieRight;
		
// 		for ( bool bg=modM.setFirst(ilclc,gP); bg; bg=modM.setNext(ilclc,gP) ) {
		  
// 		  L lLeft  = ilclc.first.first;
// 		  L lRight = ilclc.second.first;
		  
// 		  for ( bool ble=modL.setFirst(ieLeft,lLeft,eP); ble; ble=modL.setNext(ieLeft,lLeft,eP) ) {
// 		    //cerr<<"   iter over eLeft = "<<ieLeft<<endl;
// 		    for ( bool ble=modL.setFirst(ieRight,lRight,eP); ble; ble=modL.setNext(ieRight,lRight,eP) ) {
// 		      //cerr<<"   iter over eRight = "<<ieRight<<endl;
		      
// 		      G g1 = G(udL,LCE(ilclc.first.first,ilclc.first.second,ieLeft));
// 		      G g2 = G(udR,LCE(ilclc.second.first,ilclc.second.second,ieRight));
		      
// 		      //cerr  << i << "," << k << "," << j << " found GG rule "<< gP << " -> " << gg<< endl;
// 		      ChartCell& cc1 = accChart.set(i,k).set(g1);
// 		      ChartCell& cc2 = accChart.set(k,j).set(g2);
// 		      if ( cc1!=ChartCell() && cc2!=ChartCell() ) {
// 			cc1.setRooted();
// 			cc2.setRooted();
// 			LogProb pr = cc1.getProb() * cc2.getProb()
// 			  * LogProb(modM.getProb(ilclc,gP)) * LogProb(modL.getProb(ieLeft,lLeft,eP)) * LogProb(modL.getProb(ieRight,lRight,eP));
// 			fprintf ( stdout, "%d %s:%s{%s} %d : %d %s:%s{%s} %d %s:%s{%s} %d = %d\n",
// 				  i, gP.second.first.getString().c_str(),gP.second.second.getString().c_str(), gP.second.third.getString().c_str(), j,
// 				  i, g1.second.first.getString().c_str(),g1.second.second.getString().c_str(), g1.second.third.getString().c_str(), 
// 				  k, g2.second.first.getString().c_str(),g2.second.second.getString().c_str(), g2.second.third.getString().c_str(), j, pr.toInt() );
// 		      }
// 		    }
// 		  }
// 		}
// 	      }
// 	    }
// 	  }
// 	}
//       }
      /*
      //ModeledC c;
      GModel::IterVal gr;
      for ( bool bgr=modGr.setFirst(gr); bgr; bgr=modGr.setNext(gr) )
        if ( accChart.get(0,n).get(gr).getProb()*modGr.getProb(gr) != LogProb() ) {
          accChart.set(0,n).set(gr).setRooted();
        }

      for ( int di=n; di>=1; di-- ) {
        cerr << "  " << di << endl;
        for ( int i=0; i<=n-di; i++ ) {
          int j=i+di;
          for ( GGModel::const_iterator iter = modGGgivG.begin(); iter!=modGGgivG.end(); iter++ ) {
            G                gP = iter->first.getCC1();
            const ChartCell& cc  = accChart.get(i,j).get(gP);
            if ( cc.getRooted() ) {
              for ( int k=i+1; k<=j-1; k++ ) {
                GGModel::IterVal gg;
                for ( bool bgg=modGGgivG.setFirst(gg,gP); bgg; bgg=modGGgivG.setNext(gg,gP) ) {
                  if ( LogProb(modGGgivG.getProb(gg,gP))>LogProb(THRESHOLD) ) {
                    const G& g1 = gg.first;  ChartCell& cc1 = accChart.set(i,k).set(g1);
                    const G& g2 = gg.second; ChartCell& cc2 = accChart.set(k,j).set(g2);
                    if ( cc1!=ChartCell() && cc2!=ChartCell() ) {
                      cc1.setRooted();
                      cc2.setRooted();
                      LogProb pr = cc1.getProb()*cc2.getProb()*LogProb(modGGgivG.getProb(gg,gP));
                      fprintf ( stdout, "%d %s{%s} %d : %d %s{%s} %d %s{%s} %d = %d\n",
                                i, gP.second.getString().c_str(), gP.third.getString().c_str(), j,
                                i, g1.second.getString().c_str(), g1.third.getString().c_str(), 
				k, g2.second.getString().c_str(), g2.third.getString().c_str(), j, pr.toInt() );
                    }
                  }
                }
              }
            }
          }
        }
      }
      */
      //cout << "-" << endl;

//    } else {
    // Print best...
    LogProb         prBest=LogProb();
    UDLCI           udlciBest;

    //for (SimpleHash<G,ChartCell>::const_iterator it=accChart.get(0,n).begin(); !(it==accChart.get(0,n).end()); it++) {
    //cerr<< "at top P("<<G(it->first)<<")="<<accChart.get(0,n).get(it->first).getProb()<<endl;
    //}

    GrModel::IterVal udlci;
    for ( bool budlci=modGr.setFirst(udlci); budlci; budlci=modGr.setNext(udlci) ) {
      //cerr<<" Gr="<<G(gr)<<", P(gr)=";
      //cerr<<accChart.get(0,n).get(gr).getProb()<<" * "<<modGr.getProb(gr);
      //cerr<<endl;;
      if ( LogProb()==prBest || accChart.get(0,n).get(udlci).maxProb()*modGr.getProb(udlci)>prBest ) {
        udlciBest = udlci;
        prBest    = accChart.get(0,n).get(udlci).maxProb()*modGr.getProb(udlci);
      }
      //err<<endl;
    }
    if ( prBest>LogProb() ) {
      accChart.get(0,n).get(udlciBest).writeBest(stdout,lx);
      //if (NOISY)
      //cout << "      Probability="<<prBest<<endl;
    }
    else
      cout << "[ERROR failed]";
    cout << endl;
  }


  //if (nArgs>2) fin.close();
  //if (NOISY) {
  //  cerr << " trying to dump modGGgivG\n";
  //  modGGgivG.dump(cerr,"GG");
  //}


}

