###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


use Getopt::Std;

getopts("d");

$DEBUG = 0;
if ($opt_d) {
  $DEBUG = 1;
}

sub debug {
  if ($DEBUG) {
    $msg = $_[1];
    print stderr $_[0] , " " , $msg, "\n";
  }
}

$SRL = "\w+\!ldelim\!";

## for each tree...
while ( <> ) {
  ## translate to parens...
  s/\[/\(/g;
  s/\]/\)/g;


  ########## dashes are unwelcome!
  s/\([^ ]+ \-\-(:[^\)]*)?\)/\(\-\- \-\-\1\)/g;
  s/\([^ ]+ \-(:[^\)]*)?\)/\(\-\- \-\-\1\)/g;
  s/\-\-/\!dash\!/g;
  s/-L.B-/\!LRB\!/g;
  s/-R.B-/\!RRB\!/g;


  ## for each constituent...
  while ( $_ =~ /\([^\(\)]*\)/ ) {
    ## convert outer parens to braces...
    $_ =~ s/\(([^\(\)]*)\)/{\1}/;
    #################### ADD SED RULES HERE: apply rules to angles (children) within braces (consituent)...
    debug($step++, "   $_");


    #### EOS PUNCT
    # kick eos punct up out of constit (should have been annotated this way!)
    s/{(?![^ ]*-me)([^ ]*) +(.*) +(<[\.\!\?] [\.\!\?]>)}(?=.*\))/{\1 \2} \3/;
    # kick eos punct + right quote up out of constit (should have been annotated this way -- quote delimits can be obtained from left, but punct is needed at root)
    s/{(?![^ ]*-me)(?![^ ]*-rq)([^ ]*) +(.*)(<``? ``?>)(.*) +(<[\.\!\?] [\.\!\?]> +<''? ''?>)}(?=.*\))/{\1-rq-mq \2\3\4} \5/;
    # kick eos punct + right quote up out of constit (should have been annotated this way -- quote delimits can be obtained from left, but punct is needed at root)
    s/{(?![^ ]*-me)(?![^ ]*-rq)([^ ]*) +(.*) +(<[\.\!\?] [\.\!\?]> +<''? ''?>)}(?=.*\))/{\1-rq \2} \3/;
#    # isolate period + quote after S
#    s/{(?![^ ]*-me)([^ ]*) +(.*<.*) +(<[\.\!\?] [^>]*>) +(<''? ''?>) *}/\(\1-me \(\1-rq-me \{\1 \2\} \3\4\)/;
    # isolate quote + ... + period + quote (allows other junk after, like rest of line in case of embedded quote)
    s/{(?![^ ]*-me)([^ ]*) +(<``? ``?>) +(<.*) +(<[\.\!\?] [^>]*>) +(<''? ''?>.*)}/\(\1-me-mq \(\1-rq-me-mq-h \2 \{\1-h \3\} \4\) \5\)/;
    # isolate ... + period + quote (allows other junk after, like rest of line in case of embedded quote)
    s/{(?![^ ]*-me)([^ ]*) +(<.*) +(<[\.\!\?] [^>]*>) +(<''? ''?>.*)}/\(\1-me \(\1-rq-me-h \{\1-h \2\} \3\) \4\)/;
    # isolate period after S (allows other junk after period, like quotes or rest of line in case of embedded quote)
    s/{(?![^ ]*-me)([^ ]*) +(<.*) +(<[\.\!\?] [^>]*>)(.*)}/\(\1-me \{\1-h \2\} \3\4\)/;
#    # isolate period after S
#    s/{(?![^ ]*-me)([^ ]*) +(.*<.*) +(<[\.\!\?] [^>]*>) *}/\(\1-me \{\1 \2\} \3\)/;
#    # isolate period quote after S
#    s/{([^ ]*) +(.*<.*<.*) +<(\. [^>]*)> +<('' [^>]*)> *}/\(\1 \(\1-rq \{\1-rq-re \2\} <\3>\) <\4>\)/;
#    # isolate period after S
#    s/{([^ ]*) +(.*<.*<.*) +<(\. [^>]*)> *}/\(\1 \{\1-re \2\} <\3>\)/;
    ## # grab punct after S
    ## s/{([^ ]*) +(.*)<(S[^ ]*) ([^>]*)> *<(, [^>]*)>(.*)}/\(\1 \2\{\3 <\3 \4> <\5>\}\6\)/;


    #### TIME NPS
    # substitute NP-tmp
    s/{NP[^ ]*-TMP[^ \-\=]*[^ ]* (.*)}/\(PP-t \{NP \1\}\)/g;


    #### CONJUNCTION
    # grab XP ; conj XP as LISTXP-semi
    s/{([^ ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([- ][^>]*)> *<(;[^>]*)> *<(CC[^>]*)> *<\3([- ][^>]*)>(.*)}/\(\1 \2\{LIST\3-semi <\3-h\4> <;CC\3-h \[\5\] \[CC\3-h \[\6\] \[\3-h\7\]\]>\}\8\)/;
    # grab XP ; XP ; XP as LISTXP-semi at end of constit
    s/{([^ ]*) +(.*)<(NP[^- ]*)([- ][^>]*)> *<(;[^>]*)> *<\3([- ][^>]*)> *<(;[^>]*)> *<\3([- ][^>]*)>( *)}/\(\1 \2\{LIST\3-semi <\3-h\4> <;LIST\3-semi-h \[\5\] \[LIST\3-semi-h \[\3-h\6\] \[;\3-h \[\7\] \[\3-h\8\]\]\]>\}\9\)/;
    # grab XP ; LISTXP-semi as LISTXP-semi
    s/{(?!LIST)([^ ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([- ][^>]*)> *<(;[^>]*)> *<LIST\3-semi([^>]*)>(.*)}/\(\1 \2\{LIST\3-semi <\3-h\4> <;LIST\3-semi-h \[\5\] \[LIST\3-semi-h \6\]>\}\7\)/;
    # grab XP , conj XP as LISTXP
    s/{([^ ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([- ][^>]*)> *<(,[^>]*)> *<(CC[^>]*)> *<\3([- ][^>]*)>(.*)}/\(\1 \2\{LIST\3 <\3-h\4> <,CC\3-h \[\5\] \[CC\3-h \[\6\] \[\3-h\7\]\]>\}\8\)/;
    # grab XP , XP conj XP as XP , LISTXP
    s/{([^ ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([- ][^>]*)> *<(,[^>]*)> *<\3([- ][^>]*)> *<(CC[^>]*)> *<\3([- ][^>]*)>(.*)}/\(\1 \2<\3\4> <\5> \{LIST\3 <\3-h\6> <CC\3-h \[\7\] \[\3-h\8\]>\}\9\)/;
    # grab XP , XP , XP as LISTXP at end of constit
    s/{([^ ]*) +(.*)<(NP[^- ]*)([- ][^>]*)> *<(,[^>]*)> *<\3([- ][^>]*)> *<(,[^>]*)> *<\3([- ][^>]*)>( *)}/\(\1 \2\{LIST\3 <\3-h\4> <,LIST\3-h \[\5\] \[LIST\3-h \[\3-h\6\] \[,\3-h \[\7\] \[\3-h\8\]\]\]>\}\9\)/;
    # grab XP , LISTXP as LISTXP
#    while ( s/{(?!LIST)([^- ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([^>]*)> *<(,[^>]*)> *<LIST\3([^>]*)>(.*)}/\{\1 \2<LIST\3 \[\3\4\] \[\5\] \[LIST\3\6\]>\7\}/ ){}
    s/{(?!LIST)([^ ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([- ][^>]*)> *<(,[^>]*)> *<LIST\3([- ][^>]*)>(.*)}/\(\1 \2\{LIST\3 <\3-h\4> <,LIST\3-h \[\5\] \[LIST\3-h\6\]>\}\7\)/;
    # grab XP XP conj XP as XP LISTXP
    s/{(SBAR|SQ|SINV|S|NP|VP|PP|ADJP|ADVP|CD)([^ ]*) +(.*)<\1([^ ]*)([- ][^>]*)> *<\1\4([- ][^>]*)> *<(CC[^>]*)> *<\1\4([- ][^>]*)>(.*)}/\(\1\4 \3<\1\4\5> \{LIST\1\4 <\1\4-h\6> <CC\1\4-h \[\7\] \[\1\4-h\8\]>\}\9\)/;
    ##s/{([^ ]*) +(.*)<(S|NP|VP|PP|ADJP|ADVP|CD)([^ ]*)([- ][^>]*)> *<\3\4([- ][^>]*)> *<(CC[^>]*)> *<\3\4([- ][^>]*)>(.*)}/\(\1\4 \2<\3\4 \5> \{LIST\3\4 <\3\4 \6> <\7> <\3\4 \8>\}\9\)/;
    ##s/{([^ ]*) +(.*)<(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*)([- ][^>]*)> *<\3([- ][^>]*)> *<(CC[^>]*)> *<\3([- ][^>]*)>(.*)}/\(\1 \2<\3 \4> \{LIST\3 <\3 \5> <\6> <\3 \7>\}\8\)/;
    # grab XP XP XP as LISTXP at end of constit
    s/{([^ ]*) +(.*)<(NP[^- ]*)([- ][^>]*)> *<\3([- ][^>]*)> *<\3([- ][^>]*)>( *)}/\(\1 \2<\3\4> \{LIST\3 <\3-h\5> <\3-h\6>\}\7\)/;
    # grab XP XP LISTXP as XP LISTXP
    s/{(?!LIST)([^ ]*) +(.*)<(S[^- ]*|NP[^- ]*|VP[^- ]*|PP[^- ]*|ADJP[^- ]*|ADVP[^- ]*|CD[^- ]*)([- ][^>]*)> *<\3([- ][^>]*)> *<LIST\3([^>]*)>(.*)}/\(\1 \2<\3\4> \{LIST\3 <\3-h\5> <LIST\3-h\6>\}\7\)/;
    # grab X conj X as X  ####(do generic conj first, as more specific one will appear beside it and ultimately replace it via "undo unary identity projection")
    s/{([^ ]*) +(.*)<([^- ]*)([- ][^>]*)> *<(CC)([^>]*)> *<\3([- ][^>]*)>(.*)}/\(\1 \2\{\3 <\3-h\4> <\5\3-h \[\5\6\] \[\3-h\7\]>\}\8\)/;
#    # make sure there's still a head
#    if ( ! m/{.*<[^_]]-h.*>.*}/ ) { s/{(.*)<([^_]*]LIST[^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/; }


    #### BRACKETS / PARENS
    # 1a. introduce, from matched brackets / parens at edges of constituent, delimited tag
    s/{(?![^ ]*-mb)([^ ]*) +(<\!LRB\! \!LRB\!> .* <\!RRB\! \!RRB\!>) *}/{\1-mb \2}/;
    # 1b. introduce, from matched brackets / parens inside constituent, delimited tag on new constituent
    s/{(?![^ ]*-mb)(.*) (<\!LRB\! \!LRB\!>) +<(?!')([^ ]*?)(-[lr]b)?([^ ]*) ([^>]*)> +(<\!RRB\! \!RRB\!>)(.*)}/\(\1 \2 \{\3\5-lb-mb <\3\4\5-h \6> \7\}\8\)/;
    # 2a. introduce, from beginning of sentence to bracket / paren at end of constituent, delimited tag
    s/^([^\)>\]]*){(?![^ ]*-mb)([^ ]*) +(<(?![^ ]*-rb)(?!')[^>]*> +<\!RRB\! \!RRB\!>) *}/\1\{\2-lb-mb \3\}/;
    # 2b. introduce, from beginning of sentence to bracket / paren at end of constituent, delimited tag on new constituent
    s/^([^\)>\]]*){(?![^ ]*-mb)([^ ]*) +<(?![^ ]*-rb)(?!')(?!NP)([^ ]*?)(-lb)?([^ ]*) ([^>]*)> +(<\!RRB\! \!RRB\!>)(.*)}/\1\(\2 \{\3\5-lb-mb <\3\4\5-h \6> \7\}\8\)/;
    # 3a. introduce, from external punct to bracket / paren at end of constituent, delimited tag
    s/([,`'\!\.\?][ \)>\]]+[^\)>\]]*){(?![^ ]*-mb)([^ ]*) +(<(?![^ ]*-rb)(?!')[^>]*> +<\!RRB\! \!RRB\!>) *}/\1\{\2-lb-mb \3\}/;
    # 3b. introduce, from external punct to bracket / paren at end of constituent, delimited tag on new constituent
    s/([,`'\!\.\?][ \)>\]]+[^\)>\]]*){(?![^ ]*-mb)([^ ]*) +<(?![^ ]*-rb)(?!')(?!NP)([^ ]*?)(-lb)?([^ ]*) ([^>]*)> +(<\!RRB\! \!RRB\!>)(.*)}/\1\(\2 \{\3\5-lb-mb <\3\4\5-h \6> \7\}\8\)/;
    # 4a. introduce, from bracket / paren at edge of constituent to external punct, delimited tag
    s/{(?![^ ]*-mb)([^ ]*) +(<\!LRB\! \!LRB\!> +<(?![^ ]*-lb)(?!')[^>]*>) *}([ \)>\]]*[^\)>\]]*[,`'\!\.\?])/\{\1-rb-mb \2\}\3/;
    # 4b. introduce, from bracket / paren within the constituent to external punct, delimited tag on new constituent
    s/{(?![^ ]*-mb)(.*) +(<\!LRB\! \!LRB\!>) +<(?![^ ]*-lb)(?!')([^ ]*?)(-rb)?([^ ]*) ([^>]*)> *}([ \)>\]]*[^\)>\]]*[,`'\!\.\?])/\(\1 \{\3\5-rb-mb \2 <\3\4\5-h \6>\}\)\7/;

    #### QUOTES
#    # 1a. introduce, from matched quotes at edges of constituent, delimited tag
#    s/{(?![^ ]*-mq)([^ ]*) +(<``? ``?> *<(?![^ ]*-mq).* (<, ,> +)?<''? ''?>) *}/{\1-mq \2}/;
#    # 1b. introduce, from matched quotes inside constituent, delimited tag on new constituent
#    s/{(?![^ ]*-mq)(.*) (<``? ``?>) +<(?![^ ]*-mq)([^ ]*?)(-q[lr])?([^ ]*) ([^>]*)> +((<, ,> +)?<''? ''?>)(.*)}/\(\1 \{\3\5-mq \2 <\3\4\5 \6> \7\}\9\)/;
#    # 2a. introduce incompletely quoted constituent at left
#    s/{(?![^ ]*-mq)(?![^ ]*-q[lr])([^ ]*) ((?!.*``? ``?.*''? ''?).* *<(?![^ ]*-rq)[^>]*> *<''? ''?>.*)}/{\1-lq \2}/;
#    # 2b. introduce incompletely quoted constituent at right
#    s/{(?![^ ]*-mq)([^ ]*) (.*<``? ``?> *<(?![^ ]*-lq)[^>]*>(?!.*''? ''?.*\}).*)}/{\1-rq \2}/;
    # grab complete quote
    s/{(?![^ ]*-mq)(.*) (<``? ``?>) +<(?![^ ]*-mq)([^ ]*?)(-[lr]q)?([^ ]*) ([^>]*)> +((<, ,> +)?<''? ''?>)(.*)}/\(\1 \2 \{\3\5-lq-mq <\3\4\5-h \6> \7\}\9\)/;
    # grab incomplete quote: `` + X as X-rq-rc-mq
    s/{([^ ]*) (.*)(<`` ``>) +<([^ ]*) ([^>]*)> *}/\(\1 \2\{\4-rq-rc-mq \3 <\4-h \5\>\}\)/;
    # tag incomplete quote: ... + `` + ... as -rq-rc
    s/{(?![^ ]*-mq)([^ ]*) (.*<`` ``>((?!'' '').)*)}/{\1-rq-rc \2}/;
    # grab incomplete quote: X + '' as X-lq-mq
    s/{([^ ]*) +<([^ ]*) ([^>]*)> (<'' ''>)(.*) *}/\(\1 \{\2-lq-mq <\2-h \3> \4\}\5\)/;
    # tag incomplete quote: ... + '' + ... as -rq
    s/{(?![^ ]*-mq)([^ ]*) (((?!`` ``).)*<'' ''>.*)}/{\1-rq \2}/;
#    # 2a. introduce, from beginning of sentence to quote at end of constituent, delimited tag
#    s/^([^\)>\]]*){(?![^ ]*-mq)([^ ]*) +(<(?![^ ]*-rq)[^>]*> +(<, ,> +)?<''? ''?>) *}/\1\{\2-lq-mq \3\}/;
#    # 2b. introduce, from beginning of sentence to quote at end of constituent, delimited tag on new constituent
#    s/^([^\)>\]]*){(?![^ ]*-mq)([^ ]*) +<(?![^ ]*-rq)([^ ]*?)(-lq)?([^ ]*) ([^>]*)> +((<, ,> +)?<''? ''?>)(.*)}/\1\(\2 \{\3\5-lq-mq <\3\4\5 \6> \7\}\9\)/;
#    # 3a. introduce, from external punct to quote at end of constituent, delimited tag
#    s/([,`'\!\.\?][ \)>\]]+[^\)>\]]*){(?![^ ]*-mq)([^ ]*) +(<(?![^ ]*-rq)[^>]*> +(<, ,> +)?<''? ''?>) *}/\1\{\2-lq-mq \3\}/;
#    # 3b. introduce, from external punct to quote at end of constituent, delimited tag on new constituent
#    s/([,`'\!\.\?][ \)>\]]+[^\)>\]]*){(?![^ ]*-mq)([^ ]*) +<(?![^ ]*-rq)([^ ]*?)(-lq)?([^ ]*) ([^>]*)> +((<, ,> +)?<''? ''?>)(.*)}/\1\(\2 \{\3\5-lq-mq <\3\4\5 \6> \7\}\9\)/;
#    # 4a. introduce, from quote at edge of constituent to external punct, delimited tag
#    s/{(?![^ ]*-mq)([^ ]*) +(<``? ``?> +<(?![^ ]*-lq)[^>]*>) *}([ \)>\]]*[^\)>\]]*[,`'\!\.\?])/\{\1-rq-mq \2\}\3/;
#    # 4b. introduce, from quote within the constituent to external punct, delimited tag on new constituent
#    s/{(?![^ ]*-mq)(.*) +(<``? ``?>) +<(?![^ ]*-lq)([^ ]*?)(-rq)?([^ ]*) ([^>]*)> *}([ \)>\]]*[^\)>\]]*[,`'\!\.\?])/\(\1 \{\3\5-rq-mq \2 <\3\4\5 \6>\}\)\7/;

    #### DASHES
    # 1a. introduce, from matched dashes at edges of constituent, delimited tag
    s/{(?![^ ]*-md)([^ ]*) +(<\!dash\! \!dash\!> .* <\!dash\! \!dash\!>) *}/{\1-md \2}/;
    # 1b. introduce, from matched dashes inside constituent, delimited tag on new constituent
    s/{(?![^ ]*-md)(.*) (<\!dash\! \!dash\!>) +<(?!')([^ ]*?)(-[lr]d)?([^ ]*) ([^>]*)> +(<\!dash\! \!dash\!>)(.*)}/\(\1 \2 \{\3\5-ld-md <\3\4\5-h \6> \7\}\8\)/;
    # 2a. introduce, from beginning of sentence to dash at end of constituent, delimited tag
    s/^([^\)>\]]*){(?![^ ]*-md)([^ ]*) +(<(?![^ ]*-rd)(?!')[^>]*> +<\!dash\! \!dash\!>) *}/\1\{\2-ld-md \3\}/;
    # 2b. introduce, from beginning of sentence to dash at end of constituent, delimited tag on new constituent
    s/^([^\)>\]]*){(?![^ ]*-md)([^ ]*) +<(?![^ ]*-rd)(?!')(?!NP)([^ ]*?)(-ld)?([^ ]*) ([^>]*)> +(<\!dash\! \!dash\!>)(.*)}/\1\(\2 \{\3\5-ld-md <\3\4\5-h \6> \7\}\8\)/;
    # 3a. introduce, from external punct to dash at end of constituent, delimited tag
    s/([,`'\!\.\?][ \)>\]]+[^\)>\]]*){(?![^ ]*-md)([^ ]*) +(<(?![^ ]*-rd)(?!')[^>]*> +<\!dash\! \!dash\!>) *}/\1\{\2-ld-md \3\}/;
    # 3b. introduce, from external punct to dash at end of constituent, delimited tag on new constituent
    s/([,`'\!\.\?][ \)>\]]+[^\)>\]]*){(?![^ ]*-md)([^ ]*) +<(?![^ ]*-rd)(?!')(?!NP)([^ ]*?)(-ld)?([^ ]*) ([^>]*)> +(<\!dash\! \!dash\!>)(.*)}/\1\(\2 \{\3\5-ld-md <\3\4\5-h \6> \7\}\8\)/;
    # 4a. introduce, from dash at edge of constituent to external punct, delimited tag
    s/{(?![^ ]*-md)([^ ]*) +(<\!dash\! \!dash\!> +<(?![^ ]*-ld)(?!')[^>]*>) *}([ \)>\]]*[^\)>\]]*[,`'\!\.\?])/\{\1-rd-md \2\}\3/;
    # 4b. introduce, from dash within the constituent to external punct, delimited tag on new constituent
    s/{(?![^ ]*-md)(.*) +(<\!dash\! \!dash\!>) +<(?![^ ]*-ld)(?!')([^ ]*?)(-rd)?([^ ]*) ([^>]*)> *}([ \)>\]]*[^\)>\]]*[,`'\!\.\?])/\(\1 \{\3\5-rd-md \2 <\3\4\5-h \6>\}\)\7/;

    #### COMMAS
    # 1a. introduce, from matched dashes at edges of constituent, delimited tag
    s/{(?![^ ]*-mc)([^ ]*) +(<, ,> .* <, ,>) *}/{\1-mc \2}/;

#    # make sure punct tags precede everything else
#    while ( s/{([^ ]*)(?!-[rl][a-z])(-[^- ]+)(-[rl][a-z])/{\1\3\2/g ){}
#    #while ( s/<([^ ]*)(?!-[rl][a-z])(-[^- ]+)(-[rl][a-z])/<\1\3\2/g ){}
#    # delete redundant tags
#    #while ( s/{([^ ]*)(?!-[rl][a-z])(-[^- ]+)(-[rl][a-z])/{\1\3\2/g ){}
#    while ( s/<([^ ]*)(-[^- ]+)([^ ]*)\1/<\1\2\3/g ){}


    ## this faithfully implements the magerman-black head rules
    if ( m/{.*<[^ ]*-h.*>.*}/ ) { }   # if already head-marked, ignore
    elsif ( m/{ADJP[-= ]/ ) {
      if ( !( s/{(.*)<(\%)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(QP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(\$)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(DT)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<((?!RB)(?=[A-Z])[^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(RBR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(RBS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(RB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{ADVP[-= ]/ ) {
      if ( !( s/{(.*?)<(RBR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(RB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(RBS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(ADVP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(CD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<((?!JJ)(?=[A-Z])[^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(JJR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(JJS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{CONJP[-= ]/ ) {
      if ( !( s/{(.*?)<(CC)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(RB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(IN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{FRAG[-= ]/ ) {
      if ( !( s/{(.*?)<([A-Z][^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{INTJ[-= ]/ ) {
      if ( !( s/{(.*)<([A-Z][^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{LST[-= ]/ ) {
      if ( !( s/{(.*?)<(LS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(:)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{NAC[-= ]/ ) {
      if ( !( s/{(.*)<(NN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NNS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NNP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NNPS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NAC)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(EX)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(\$)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(CD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(QP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(PRP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SYM)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{(NP[-= ]|NX)/ ) {
      if ( !( s/{(.*)<(N[A-Z]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(EX)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(\$)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(CD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(QP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(PRP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(DT)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(RB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SYM)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(PRP\$)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{NP\$[-= ]/ ) {
      if ( !( s/{(.*)<(NN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NNS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NNP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NNPS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NAC)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(EX)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(\$)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(CD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(QP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(PRP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SYM)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{PNP[-= ]/ ) {
      if ( !( s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{PP[-= ]/ ) {
      if ( !( s/{(.*?)<(IN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(TO)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{PRN[-= ]/ ) {
      if ( !( s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||      # WS: i added this
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{PRT[-= ]/ ) {
      if ( !( s/{(.*?)<(RP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{QP[-= ]/ ) {
      if ( !( s/{(.*)<(CD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NCD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(\%)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(QP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(JJS)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(DT)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{RRC[-= ]/ ) {
      if ( !( s/{(.*?)<(VP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(NP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(ADVP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(PP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{S[-= ]/ ) {
      if ( !( s/{(.*)<(VP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SBAR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(UCP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{SBAR[-= ]/ ) {
      if ( !( s/{(.*)<(S)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SQ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SINV)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SBAR)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(FRAG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(X)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{SBARQ[-= ]/ ) {
      if ( !( s/{(.*)<(SQ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(S)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SINV)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SBARQ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(FRAG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(X)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{SINV[-= ]/ ) {
      if ( !( s/{(.*)<(S)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBZ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SINV)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(NP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{SQ[-= ]/ ) {
      if ( !( s/{(.*)<(VP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBZ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VBD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ABP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(VB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(MD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(SQ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{UCP[-= ]/ ) {
      if ( !( s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{VP[-= ]/ ) {
      if ( !( s/{(.*?)<(VBD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(VBN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(MD)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(VBZ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(TO)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(VB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(VP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(VBG)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(VBP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(NP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{WHADJP[-= ]/ ) {
      if ( !( s/{(.*)<(JJ)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(ADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{WHADVP[-= ]/ ) {
      if ( !( s/{(.*?)<(WRB)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{WHNP[-= ]/ ) {
      if ( !( s/{(.*)<(WDT)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(WP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(WP\$)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(WHADJP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(WHPP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<(WHNP)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{WHPP[-= ]/ ) {
      if ( !( s/{(.*?)<(IN)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(TO)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<(FW)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ ||
              s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{X[-= ]/ ) {
      if ( !( s/{(.*?)<([A-Z][^ ]*)([-= ][^>]*)>(.*)}/{\1<\2-h\3>\4}/ || m/{[^ ]* *<-NONE-[^>]*> *}/ ) ) { print stderr "NO HEAD: $_\n"; } }

    elsif ( m/{[^ ]* +[^ <>]*}/ ) { }  # don't complain about terminals

    else { print stderr "NO HEAD MATCH: $_\n"; }


    s/-NONE--h/-NONE-/g;   # WS: undo head annotation for trace


    ####################
    ## convert inner angles (if any) to bracks...
    while ( s/({[^{}]*)<([^<>]*)>/\1\[\2\]/ ){}
    ## convert outer braces to angles...
    $_ =~ s/{(.*)}/<\1>/;
  }
  ## finish up...
  $_ =~ s/</[/;
  $_ =~ s/>/]/;
  ## translate to parens again...
  $_ =~ s/\[/\(/g;
  $_ =~ s/\]/\)/g;
  ## output...
  print $_;
}
