###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# trees2dat-gf
# This script implements a tree to model version of the HHMM parser
# (rc trees mapped to operations in the HHMM).  See Schuler 2009 (NAACL)
# for model architecture.
#
# Author: Tim Miller
# Author: William Schuler
#
######################################################################

require "scripts/umnlp.rb"

$error = false
$line = ""

class Tree
  def toDat ( depth, qParent, numSibs=1 )

    if @children.size==0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + "\nLine=#{$line}\n"
      return
    end
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size!=0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + " child:"+@children[0].head + " granch:"+@children[0].children[0].head + "\n"
      return
    end

    ## terminal case, left child post-transform
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size==0
      pos = @children[0].children[0].head.gsub(/([^\#]*)\#.*/,'\1')
      word = @children[0].children[0].head.gsub(/[^\#]*\#(.*)/,'\1')
      gParentAct = qParent.gsub(/(.*)\/.*/,'\1')
      gParentAwa = qParent.gsub(/.*\/(.*)/,'\1')
      if depth<5
        print "Ge " + depth.to_s + " " + gParentAwa + " : " + @children[0].head + "\n"
        ##print "Ge " + (depth+1).to_s + " " + @children[0].head + " : -\n"
        print "Pc " + @children[0].head + " : " + pos + "\n"
        if word =~ /\^/
            if word =~ /(.*)\^(.*)^(.*)/
              pos2 = $2.upcase
              word2 = $3
              print "Pc intj : #{pos2}\n"
            end
        end
        print "Fr " + depth.to_s + " " + @children[0].head + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : 1\n"
        print "Gtp " + depth.to_s + " " + @children[0].head + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : " + @head.gsub(/(.*)\/.*/,'\1') + "\n"
        print "Gtq " + depth.to_s + " " + @head.gsub(/(.*)\/.*/,'\1') + " " + @children[0].head + " : " + @head.gsub(/.*\/(.*)/,'\1') + "\n"
      end
      ## if beyond max depth...
      if depth>=5
        $stderr.print "ERROR: TREE TOO BIG!!!\n"
      end
      #word = @children[0].children[0].head.gsub(/.*\#(.*)/,'\1')
      #print "Pw " + word + " : " + pos + "\n"
      #if word == ""
      #  $error = true
      #end
      return

    ## terminal case, right child post-transform
    elsif @children.size==1 && @children[0].children.size==0
      ## make sure head label equal to pos...
      pos = @children[0].head.gsub(/([^\#]*)\#.*/,'\1')
      word = @children[0].head.gsub(/([^\#]*)\#(.*)/,'\2')
      #if depth<5
      print "Ge " + depth.to_s + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : " + @head + "\n"
        print "Pc " + @head + " : " + pos + "\n"
      if parent != nil and parent.head =~ /\//
        if word =~ /(.*)\^(.*)\^(.*)/
          pos2 = $2.upcase
          word2 = $3
          print "Pc intj : #{pos2}\n"
        end
        print "Fr " + depth.to_s + " " + @head + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : " + @head + "\n"
      end
      #elsif depth==5
      #  print "Ge5 " + " " + qParent + " : " + @head + "\n"
      #  print "Pg " + @head + " : " + pos + "\n"
      #end

      #word = @children[0].head.gsub(/.*\#(.*)/,'\1')
      #print "Pw " + word + " : " + pos + "\n"
      #if word == ""
      #  $error = true
      #end
      return

    ## unary case
    elsif @children.size==1
      ## recurse to unary child...
      @children[0].toDat(depth,qParent,0)
      print "Fr " + depth.to_s + " " + @children[0].children[0].head.gsub(/(.*)\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : 1\n"
      print "Gtp " + depth.to_s + " " + @children[0].children[0].head.gsub(/(.*)\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : " + @head.gsub(/(.*)\/.*/,'\1') + "\n"
      print "Gtq " + depth.to_s + " " + @head.gsub(/(.*)\/.*/,'\1') + " " + @children[0].children[0].head.gsub(/(.*)\/.*/,'\1') + " : " + @head.gsub(/.*\/(.*)/,'\1') + "\n"
      return

    ## binary case remaining incomplete
    elsif @children.size==2 && @head=~/\//
      ## recurse to left child...
      @children[0].toDat(depth,qParent)
      ## recurse to right child...
      @children[1].toDat(depth+1,@children[0].head)
      #print "Fr " + depth.to_s + " " + @children[0].head.gsub(/(.*)\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : 0\n"
      print "Gtm " + depth.to_s + " " + @children[1].head + " " + @children[0].head.gsub(/.*\/(.*)/,'\1') + " : " + @head.gsub(/.*\/(.*)/,'\1') + "\n"
      return

    ## binary case becoming complete
    elsif @children.size==2 && @head!~/\//
      ## recurse to left child...
      @children[0].toDat(depth,qParent)
      ## recurse to right child...
      @children[1].toDat(depth+1,@children[0].head)
      if numSibs > 0
        print "Fr " + depth.to_s + " " + @children[0].head.gsub(/(.*)\/.*/,'\1') + " " + qParent.gsub(/.*\/(.*)/,'\1') + " : " + @head + "\n"
      end
      return
    end

    $stderr.print "ERROR: N-ARY BRANCH IN RCTREE!!!\n"
    return

  end

end

while($line = gets)
  t = Tree.new($line)
#  begin
  ##(composL,continL) = 
  t.toDat(1,"ROOT/REST")
  if $error
    $stderr.puts "\nWARNING: This tree generated a word-less Pw: #{t}\n"
    $error = false
  end
  if t.getNumLeafs == 1
    print "Fr 1 #{t.head} REST : #{t.head}\n"
  end

  ## top node was final...
  #print "Fr 1 S : 1\n"
  #print "Fr 1 " + t.children[0].head + " : " + t.head + "\n"

#   for d in 1..4
#     print "Qe " + d.to_s + " -/- : -/-\n"
#     print "Fr " + d.to_s + " -/- : -\n"
#   end

#  rescue Exception
#    $stderr.puts "Skipping sentence: #{$line}"
#  end
  #print "F  1 S END/END|END : 1\n"
  #for d in 1..4
  #  print "F  " + d.to_s + " END END/END|END : 1\n"
  #end
end
