###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


$D = 4;

while ( <> ) {
  chomp;
  if ( ($ht,$hr,$hw,$hs) = ($_=~/HYPOTH +([^ ]*) +([^ ]*) +([^ ]*) +(.*)/) ) {
    $T=int $ht;

    $hp=$hs;
    #$hp=~s/([^;]+)\|//g;
    $hp=~s/[^;]+\///g;
    @P=split(/;/,$hp);

    #$hs=~s/\|([^;]+)//g;
    $hs=~s/[^;]+\|//g;
    @R=split(/;/,$hr);
    @S=split(/;/,$hs);
    $S[4]=$S[4]."/".$S[4];

    ## encode the semantic role label into the word
    #$H[$D+1][$T]=$hw.":".$S[6];
    #shift one more place from 6 to 7 for the cluster
    $H[$D+1][$T]=$hw.":".$S[7];

    ## fill in F and Q tables...
    foreach $d (0..$D) {
      $F[$d][$T] = $R[$d];  if ($F[$d][$T]ne"0" && $F[$d][$T]ne"1") { $F[$d][$T]="1+"; }
      $Q[$d][$T] = $S[$d];
      $QP[$d][$T] = $P[$d];
    }
    $F[$D+1][$T] = "1+";
  }

  ## if at end of hypoths, construct tree...
  if ( $_ =~ "----------" ) {
    if ( $T>0 ) {

      ## fill in tree constructor array...
      foreach $t (1..$T-1) {
        for ($d=$D; $d>=0; $d--) {

          ## case: 1+ 0/1 1+ -- must be terminal: copy from bottom (d=D+1)
          if    ( $F[$d][$t]eq"1+" && $F[$d][$t+1]ne"1+" && $F[$d+1][$t+1]eq"1+" ) {
	    $Q[$d][$t+1]=~s/.*=//;
	      $H[$d][$t] = "[$Q[$d][$t+1] [$Q[$d][$t] $H[$D+1][$t]]]";
          }
          ## case: 1+ 1+ 1+ -- must be terminal: copy from bottom (d=D+1)
          elsif ( $F[$d][$t]eq"1+" && $F[$d][$t+1]eq"1+" && $F[$d+1][$t+1]eq"1+" ) {
            $pos = $Q[$d][$t];   # $QP[$d-1][$t];  # $Q[$d][$t]
            $H[$d][$t] = "[$pos $H[$D+1][$t]]";
          }
          ## case: 0/1 1 1+ -- must be reduction to finalized category: merge previous and below using finalize cat
          elsif ( $F[$d][$t]ne"1+" && $F[$d][$t+1]eq"1" && $F[$d+1][$t+1]eq"1+" ) {
            $fincat = $Q[$d][$t];
            $fincat =~ s/\/.*//;
            $H[$d][$t] = "[$Q[$d][$t+1] [$fincat $H[$d][$t-1] $H[$d+1][$t]]]"
          }
          ## case: 0/1 1+ 1+ -- must be reduction to finalized category: merge previous and below using finalize cat
          elsif ( $F[$d][$t]ne"1+" && $F[$d][$t+1]eq"1+" && $F[$d+1][$t+1]eq"1+" ) {
            $fincat = $Q[$d][$t];
            $fincat =~ s/\/.*//;
            $H[$d][$t] = "[$fincat $H[$d][$t-1] $H[$d+1][$t]]"
          }
          ## case: 0/1 0 1+ -- must be reduction continuing at same level: merge previous and below to new node using next cat
          elsif ( $F[$d][$t]ne"1+" && $F[$d][$t+1]eq"0" && $F[$d+1][$t+1]eq"1+" ) {
	    if ( $Q[$d][$t+1]=~/^(.*)=(.*)$/ ) {
              $actcat = $2;
              $fincat = $Q[$d][$t];
              $fincat =~ s/\/.*//;
	      $H[$d][$t] = "[$actcat [$fincat $H[$d][$t-1] $H[$d+1][$t]]]";
	      $Q[$d][$t+1]=~s/.*=//;
	    }
	    else {
	      $H[$d][$t] = "[$Q[$d][$t+1] $H[$d][$t-1] $H[$d+1][$t]]";
	    }
          }
          ## case: 0/1 - 0/1 -- must be inert part of stack: copy from previous time
          elsif ( $F[$d][$t]ne"1+" && $F[$d+1][$t+1]ne"1+" ) {
            $H[$d][$t] = $H[$d][$t-1];
          }
          else {
            $H[$d][$t] = "";
          }

          ####print stderr "F[$d][$t]=$F[$d][$t] Q[$d][$t]=$Q[$d][$t] H[$d][$t]=$H[$d][$t]\n";
        }
      }

      ## remove slash copy from preterminal category...
      $H[0][$T-1] =~ s/\[([^ ]*)\/([^ ]*) +([^ ]*)\]/\[\1 \3\]/g;

      $H[0][$T-1] =~ s/^\[- ([^\]]*)\]$/[S1 \1]/g; 

      $H[0][$T-1] =~ s/\[/(/g;
      $H[0][$T-1] =~ s/\]/)/g;
      
      ## decode the semantic role label from the word
      $H[0][$T-1] =~ s/([^ ]*):([^\)]*)/\(\1 \2\)/g;

      ## print tree...
      print "$H[0][$T-1]\n";

      $T=0;
    }
    else {
      print "[ERROR [PARSE failed]]\n";
    }
  }
}



