#!/bin/bash


# Sanitize user input
# 
# The second argument to this script should be a number.
# If it's not, the following will set the value to zero
ngram_order=$(( 0 + $2 ))


# Build the command
command="ngram-count \
    -read $1.ngram-count \
    -order $2 \
    -lm $1.lm \
    -unk \
    -interpolate "

counter=1
while [ $counter -le $ngram_order ]
do
  command="$command -kndiscount$counter"
  counter=$(( $counter + 1 ))
done



# Print out the command
echo $command

# Run the command
$command
