Le dernier numéro de Moucharraf ?
Le Général Moucharraf est apparu sur la scène nationale le 12 octobre 1999, lorsqu'il a forcé le gouvernement élu à démissionner et annoncé son projet ambitieux de « construction d'une nation ».
Bon nombre de Pakistanais -- qui avaient perdu toute illusion sur la classe politique du pays -- sont restés silencieux, pensant qu'il tiendrait ses promesses.
Le 11 septembre 2001, les attaques terroristes sur l'Amérique ont placé Moucharraf sur le devant de la scène internationale, alors qu'il décidait de soutenir les Etats-Unis dans la guerre contre la terreur, plutôt que les Talibans.
Moucharraf a pris des mesures contre des militants religieux au Pakistan et contre ceux qui luttent contre les forces indiennes au Cachemire.
Le Pakistan a donc été récompensé par l'assistance et les armes des États-Unis.
Pour mieux redistribuer ses cartes, Moucharraf a envoyé l'armée pakistanaise dans les zones ethniques qui longent l'Afghanistan, pour la première fois depuis l'indépendance du Pakistan.
Les opérations contre les forces des Talibans et d'Al‑Qaeda ont obtenu des résultats mitigés.
Si les Etats-Unis voient Moucharraf comme un agent de changement, ce dernier n'est jamais parvenu à avoir une légitimité dans son propre pays, où ses politiques ont toujours été considérées comme un tissu de contradictions.
Par exemple, il a conclu des alliances avec des forces politiques islamistes (qui en 2004 ont voté pour des changements constitutionnels légitimant sa position et ses actions) ; parallèlement, il remplaçait les dirigeants des partis politiques traditionnels modérés, tout en affirmant défendre la « modération éclairée ».
Une série d'opérations militaires mal planifiées dans les zones ethniques ont davantage compliqué la situation dans une région frontalière instable.
En mars dernier, Moucharraf a fait l'avancée la plus éhontée en destituant Iftikhar Chaudhry, président de la Cour suprême.
A la surprise générale, la communauté judiciaire du pays a organisé un mouvement à l'échelle nationale pour que le président réintègre son poste.
Des centaines de milliers de gens ordinaires ont exigé l'État de droit et la suprématie de la constitution, enhardissant le corps judiciaire et changeant la dynamique politique du pays.
Dans un arrêt historique que Moucharraf n'a pas eu d'autre choix que d'accepter, la Cour suprême a elle‑même réintégré son président en juillet.
Ragaillardis, les magistrats ont donc continué à donner tort aux décisions du gouvernement et à embarrasser celui-ci -- en particulier ses services des renseignements.
Les fonctionnaires ont été tenus pour responsables d'actions hors‑la-loi, allant du passage à tabac de journalistes, à des détentions illégales pour des raisons de « sécurité nationale ».
Moucharraf -- et ses alliés politiques -- a tenté de s'adapter à cette nouvelle réalité, mais a perdu patience lorsque la Cour suprême a protesté contre sa décision de briguer la présidence.
Selon la constitution (promulguée à l'origine en 1973 par un parlement élu), un militaire en activité ne peut être mandataire élu.
Moucharraf n'était pas disposé à abandonner ses fonctions militaires, mais voulait aussi être président civil.
Tandis qu'il annonçait la démission de son poste militaire « s'il » était élu président, son passé lourd de promesses non tenues a échaudé le corps judiciaire.
Ces dernières semaines, les procédures de la Cour ont rendu Moucharraf nerveux : les onze magistrats du siège auraient pu facilement se prononcer contre lui.
Se trouvant dans une impasse juridique, il a décidé d'abandonner la constitutionnalité, démis les hauts magistrats de leurs fonctions à la Cour suprême et aux juridictions supérieures régionales et imposé des restrictions aux médias.
Des avocats, des défenseurs des droits de l'homme et des dirigeants politiques ont depuis lors été arrêtés.
Ces mesures font l'objet d'un ressentiment généralisé parmi la population.
Plutôt que d'assumer la responsabilité d'avoir dégradé la situation en matière de sécurité (comme en témoignent les attentats suicides répétés) et la « talibanisation » croissante des zones ethniques, Moucharraf a accusé le corps judiciaire et les médias.
Dans certains cas, le militantisme judiciaire était certes évident (bien que dans le cadre du droit constitutionnel) et les medias ont aussi fait des erreurs. Pourtant, même en faisant travailler notre imagination, on ne peut assimiler ces faits à de l'extrémisme religieux ou à un soutien à la lutte armée.
Il est peu probable que la dernière tactique de Moucharraf porte ses fruits, étant donné que le soutien public est au plus bas.
Les forces armées du Pakistan -- cibles répétées d'attentats suicide -- sont démoralisées.
Il est difficile de les imaginer se tenir aux côtés de Moucharraf en cas de conflit civil.
On ne peut pas non plus s'attendre à ce qu'un Moucharraf affaibli, assailli et désorienté combatte efficacement les partisans islamiques de la lutte armée, ni instaure la stabilité politique au Pakistan.
Les partis politiques de l'opposition se rapprochent les uns des autres, et l'ancien Premier Ministre Benazir Bhutto, malgré l'avancement des négociations pour partager le pouvoir avec Moucharraf, a vivement condamné ses actions.
On s'attend à ce que les entités des droits de l'homme, les associations de médias et d'avocats ne tiennent pas compte de l'urgence, ce qui les opposera aux forces de sécurité.
Les terroristes tireront probablement profit de la situation en attaquant l'armée préoccupée et les forces politiques de Moucharraf.
Si les protestations et les menaces de violences perdurent, il n'est pas impossible que les hauts responsables militaires décident de renvoyer Moucharraf chez lui -- décision qui ne serait pas sans précédent dans l'histoire pakistanaise d'une turbulence chronique.
Récit d'un meurtre au Pakistan
La politicienne a payé de sa vie pour avoir bravé les extrémistes de toutes tendances -- d'Al‑Qaida et des Talibans aux partis religieux et aux militaires purs et durs.
Héritière de Zulfikar Ali Bhutto, légendaire leader démocratique pendu par le gouvernement du général Muhammad Zia-ul-Haq en 1979, Benazir est devenue à un jeune âge symbole de résistance -- languissant en prison et s'exilant dans les années 1980.
Son père a contribué à autonomiser les défavorisés et à renforcer les droits des citoyens dans un contexte politique féodal et de gouvernement militaire.
Plutôt que de s'incliner devant la junte militaire, il a choisi la potence.
Quelques heures avant sa pendaison, Benazir a été autorisée à le voir pour la dernière fois. Dans son autobiographie, elle écrit : « dans sa cellule de condamné à mort, je lui ai promis de poursuivre son œuvre ».
A n'en pas douter, elle a tenu sa promesse.
Son premier mandat de premier ministre (1988-90) fut bref et désorganisé.
Le Lieutenant Général Hamid Gul, ancien chef de la Direction des renseignements inter-services (Inter‑Services Intelligence), a confirmé avoir soutenu une alliance de partis politiques de droite pour l'empêcher d'obtenir la majorité parlementaire.
Les informations sur le programme nucléaire du Pakistan et les opérations de l'ISI en Afghanistan étaient hors de sa portée.
Son deuxième mandat (1993-96) dura plus longtemps et fut meilleur. Pourtant, une fois de plus, son gouvernement succomba prématurément à la suite d'accusations de mauvaise gestion et de corruption.
En réalité, les machinations des services des renseignements y sont pour quelque chose.
L'armée a développé une méfiance vivace à son égard, au vu de sa prise de position pour la paix en Inde et de son rôle de chef de file pro-occidental bénéficiant du soutien populaire.
Après l'exile que Benazir Bhutto s'était imposé durant près d'une décennie, son retour au Pakistan en octobre a marqué un nouveau départ politique.
Le Pakistan a changé : la dictature militaire et l'extrémisme religieux au nord chamboulent le tissu social.
Une tentative d'entente avec Musharraf, soutenue par l'Occident -- notamment le Royaume-Uni et les États-Unis -- , a facilité un retour salué par des centaines de milliers de personnes malgré l'accueil des terroristes et leur série d'attentats suicide.
Si ses contacts avec le gouvernement militaire ont attiré les critiques, Benazir Bhutto est restée catégorique sur le fait que la démocratie n'était possible que si Musharraf abandonnait son poste militaire, devenait un chef d'État civil et organisait des élections libres et justes.
A la consternation de forces démocratiques, Benazir Bhutto a tenu bon même après que Musharraf a imposé la loi martiale le 3 novembre et démis les grands juges de leurs fonctions pour assurer sa réélection.
Benazir Bhutto a même convaincu d'autres dirigeants de participer aux élections prévues le 8 janvier, qu'elle voyait comme une occasion de s'opposer aux extrémistes religieux sur la place publique.
En dépit de menaces de mort, elle a saisi sa chance et s'est rendue dans l'ensemble du pays pour défendre la cause d'un Pakistan démocratique et pluraliste.
On peut comprendre que des extrémistes religieux comme Al-Qaida et les Talibans la prenne pour cible, et que le gouvernement juge impossible de la défendre contre une attaque suicide.
Cependant, Benazir Bhutto aurait été assassinée par un tireur isolé avant que le terroriste ne se suicide.
Pour le peuple pakistanais, en particulier les partisans de la politicienne, ce sont les services des renseignements, seuls ou en collaboration avec les extrémistes, qui auraient finalement décidé de l'éliminer.
Que le gouvernement soit ou non impliqué, le fait est que le Pakistan a perdu un leader dont il a cruellement besoin.
L'avenir du Pakistan étant en jeu, l'aide et le soutien de l'Occident joueront un rôle crucial. Mais il faudra alors admettre que Musharraf n'est pas le seul dirigeant capable de résoudre les nombreux problèmes du pays ni de remporter la guerre contre la terreur.
Bien au contraire, en entretenant le climat actuel d'instabilité et d'incertitude, Musharraf est l'un des plus grands problèmes du Pakistan.
Exorciser le fantôme de Musharraf
Contrairement à l'Irak et à L'Afghanistan, le Pakistan, qui fête ses soixante ans d'existence, n'est pas une démocratie récente. Mais les clivages ethniques, des institutions faibles et l'extrémisme dans le nord du pays entretiennent l'instabilité.
Et alors que le nouveau gouvernement prend ses marques et définit ses priorités, l'Occident, et les Etats-Unis en particulier, doivent réévaluer l'impact de leurs liens avec le Pakistan.
Le nouveau Premier ministre pakistanais, Yousaf Gilani, est un politicien chevronné et, peut-être plus important, est issu d'une famille d'origine soufie, ce qui, compte tenu de la tradition de tolérance soufie, ne peut être qu'un bon présage.
Gilani a déclaré sans équivoque lors de son discours d'investiture que la lutte contre le terrorisme était une priorité absolue, et sa première décision a été d'ordonner la libération des juges assignés à résidence par Musharraf.
Le répit observé dans l'horrible vague d'attentats suicide depuis la formation du nouveau gouvernement est également encourageant.
Mais la lune de miel tire à sa fin.
À Multan, la ville natale de Gilani, des émeutiers s'en sont déjà pris à des bureaux du gouvernement et à des banques pour protester contre les coupures d'électricité.
Deux politiciens connus de l'opposition, un ministre et un membre du cabinet fédéral de l'ancien gouvernement Musharraf, ont été molestés en public, mettant en question le contrôle gouvernemental sur la loi et l'ordre dans le pays.
Musharraf semble jusqu'à présent avoir accepté tranquillement son changement de statut -- même s'il n'a guère le choix.
La nouvelle direction politique, que ce soit au Parlement ou ailleurs, a tout fait pour éviter une collision frontale avec l'ancien président.
Il est intéressant de noter qu'en pleine période de transition politique, Musharraf a effectué une visite d'une semaine en Chine pour défendre le projet de construction d'un pipe-line de pétrole et de gaz entre la Chine et le Golfe persique qui traverserait le Pakistan.
La question qui sous-tend cette visite est de savoir si Musharraf cherchait à faire comprendre aux Etats-Unis que les priorités du Pakistan étaient en train de changer.
Il est très probable que le renouveau de la démocratie au Pakistan aura une incidence sur les relations avec les Etats-Unis.
D'un autre côté, les liens de l'armée pakistanaise avec l'administration américaine semblent être stables et l'alliance stratégique avec les Etats-Unis devrait être reconduite, avec peut-être quelques nuances sur la manière de mener la « guerre contre le terrorisme ».
Mais les politiciens pakistanais seront sans doute influencés par leur opinion publique, qui est généralement très critique des choix politiques américains.
Il n'en reste pas moins que les intérêts à long terme des Etats-Unis dans la région seront mieux servis par la consolidation des forces démocratiques au Pakistan.
La proposition d'augmenter l'aide au développement et à l'éducation au Pakistan, récemment présentée au Sénat américain, pourrait permettre aux Etats-Unis de regagner leur capital de sympathie.
Dans le même temps, le président George W. Bush a déclaré que « si un autre attentat, similaire à celui de 11 septembre, était en cours de préparation, il l'était probablement au Pakistan et pas en Afghanistan ».
Il reste à savoir si cette évaluation des services des renseignements américains est basée sur des informations crédibles ou pas.
Il est également possible que cette affirmation soit motivée par des raisons électorales.
Mais il est significatif que Bush ait choisi de faire cette remarque au moment de la période de transition politique au Pakistan.
Le Pakistan doit toutefois prendre cette remarque au sérieux, quelles que soient les motivations de Bush.
Le nouveau gouvernement doit rapidement définir une politique pour contrer le terrorisme.
Les derniers mois avaient été entachés par des dizaines d'attentats suicide et autres activités terroristes -- le prix à payer pour les erreurs passées du Pakistan, et de l'Occident.
L'Afghanistan est en est un parfait exemple, tout comme l'incapacité à résoudre l'épineuse question du Cachemire avec l'Inde.
Ces deux échecs ont renforcé les groupes terroristes pakistanais.
Le gouvernement pakistanais semble prêt à discuter avec certains des extrémistes dans les régions tribales, pour introduire des réformes politiques et redoubler les efforts de développement.
Mais l'idée de « discussions » met l'Occident mal à l'aise.
L'administration américaine a assimilé cette stratégie à des négociations avec des terroristes, et a fait remarquer qu'une précédente série de négociations n'avait en rien contribué à mettre fin aux violences.
Mais le nouveau gouvernement souhaite faire la différence, au Pakistan, entre les membres d'al-Qaïda d'une part et les conservateurs religieux et les jeunes Pashtouns désillusionnés de l'autre. La victoire de l'Awami National Party (ANP), un parti laïc, dans la province frontière du Nord-Est est après tout un signe clair que ses habitants rejettent les forces politiques religieuses et la violence.
Cette ouverture pourrait être élargie par le dialogue et la réconciliation avec ceux qui sont prêts à renoncer à l'extrémisme et au militantisme.
Le nouveau gouvernement pakistanais devra expliquer cette situation aux pays occidentaux pour préserver leur soutien.
Dans l'intervalle, les Etats-Unis doivent mettre fin aux frappes militaires directes dans la région, même si elles sont menées à la connaissance et avec la coopération des forces armées pakistanaises.
L'usage de la force n'a jamais donné de résultats avec les tribus pashtounes, et rien n'indique que cela ait changé.
Il y a par contre des signes manifestes que le nouveau gouvernement est considéré comme un partenaire crédible dans les zones tribales.
Il faut à présent lui donner le temps de trouver une sortie au cycle sans fin de la violence.
Les longs adieux de Pervez Musharraf
Les allégations sont graves : conspiration pour déstabiliser le gouvernement élu en février dernier, destitution illégale des juges de la Cour suprême en novembre 2007 et incapacité à protéger Benazir Bhutto avant son assassinat en décembre 2007.
L'alliance avec le gouvernement Bush a creusé son impopularité, notamment à la suite des attaques de missiles américains dans les zones tribales du Pakistan.
Malgré des différends sur la façon de traiter avec Musharraf, les grands partis politiques sont désormais unis contre lui.
Les querelles entre le Parti populaire du Pakistan, mené par Asif Ali Zardari, veuf de Benazir Bhutto, et la Ligue musulmane du Pakistan (N), menée par l'ex-premier ministre Nawaz Sharif, ont permis à Musharraf de reprendre son souffle après la défaite de ses alliés aux élections de février.
Les réticences des Etats-Unis à abandonner Musharraf -- et les coupures d'électricité prolongées, dont le nouveau gouvernement « incompétent » était tenu pour responsable --  lui avaient donné de faux espoirs.
Musharraf pourrait compter sur l'armée, son premier soutien, pour le sortir de cette crise.
Pourtant, même si cet appui demeure une possibilité, il est peu probable que les dirigeants militaires aillent si loin.
Bien qu'il soit un protégé du président, le Général Ashfaq Kayani, chef d'état-major, est un professionnel pour qui les intérêts institutionnels de l'armée sont plus importants que les intérêts politiques de son ancien patron.
A plusieurs reprises, Kayani a déclaré que l'armée n'interférerait pas dans les affaires politiques et que le parlement et la constitution primaient sur tout le reste.
L'armée est peut-être tentée d'intervenir au nom de Musharraf, cependant, elle s'est assagie avec les événements politiques de l'année passée.
L'ensemble du corps judiciaire s'est levé pour demander la restauration des juges et la consolidation de l'État de droit.
La demande générale d'élections libres et la création d'un gouvernement démocratique ont forcé les militaires à accepter la volonté citoyenne.
L'armée a aussi payé le prix fort pour la position de Musharraf dans la guerre contre la terreur : des bombardiers suicide ont frappé plusieurs fois les installations militaires et le personnel autour du quartier général de Rawalpindi.
De plus, la fréquence des attaques mortelles sur les convois militaires dans les zones tribales du Pakistan et de l'Afghanistan a éloigné l'armée du président.
Si l'armé a tiré des profits financiers inattendus de l'aide militaire américaine, et pris pour cible nombre de militants étrangers alliés à Al-Qaida dans la région, ses performances contre les partisans pakistanais ont été, au mieux, mitigées.
Le prestige des Talibans et d'autres groupes activistes de la région s'est donc consolidé.
Dans ce contexte, l'armée, qui cherche à éviter la seule responsabilité d'un retour en arrière, veut un gouvernement suffisamment populaire pour prendre en charge la politique -- or, ce gouvernement ne peut voir le jour si les partis élus perdent leurs sièges.
On note des signes de désaccord entre le gouvernement et l'armée sur des questions importantes.
Les militaires ont récemment contré une manœuvre gouvernementale visant à placer les renseignements pakistanais, tristement célèbres, sous le contrôle du ministère de l'intérieur plutôt que du premier ministre.
Musharraf a soutenu l'opposition militaire à cette réforme, et reçu la gratitude des commandants militaires.
Lors de la récente visite du premier ministre Youssef Raza Gilani aux Etats-Unis, le président Bush a répété que son gouvernement soutenait la démocratie au Pakistan, politique reprise depuis par la Secrétaire d'État Condoleezza Rice.
Cette position laisse entendre que les Etats-Unis n'épauleront Musharraf dans aucune confrontation entre lui et les forces démocratiques du Pakistan -- ce que souhaitent la plupart des Pakistanais.
Il importe que Musharraf s'interroge sur les conséquences de ses actes.
Plutôt que d'essayer de confondre les mises en accusation et de faire durer la crise, il devrait reconnaître que le Pakistan ne peut se permettre plus d'instabilité et qu'un abandon honorable de sa part inciterait le respect.
En effet, même si Musharraf nie les accusations et échappe à la destitution par un coup de chance, son avenir s'annonce sombre.
En mars 2009, la coalition actuellement au pouvoir obtiendra davantage de sièges au Sénat et le gouvernement tentera certainement de mettre le président en cause à nouveau.
Qui plus est, toute tentative de Musharraf de déloger le gouvernement en se servant de son autorité constitutionnelle entraînerait une autre élection -- et les résultats ne seraient pas différents de ceux de février.
Il est temps que ses alliés occidentaux insistent pour qu'il se rende utile une dernière fois pour son pays en évitant la confrontation avec les forces démocratiques et en démissionnant.
L'Asie du Sud en guerre
Les conflits régionaux - ils incluent tous les pays de la région et un nombre croissant d'acteurs non-étatiques - ont conduit à l'apparition d'un grand nombre de combattants entraînés, n'attendant qu'un appel pour la gloire.
Tant en Inde qu'au Pakistan, les disparités économiques et les injustices sociales sont un terreau fertile pour alimenter des conflits.
Le recours à la ferveur religieuse et à son abus - qu'il s'agisse de djihad musulman ou de fondamentalisme hindou - ébranle les  bases de l'harmonie sociale à travers l'Asie du Sud.
Beaucoup des problèmes actuels trouvent leur source en Afghanistan, un pays dont l'Histoire tragique n'est jamais restée confinée à l'intérieur des frontières du pays.
La dynamique de la région a changé quand les combattants afghans de la liberté des années 1980 se sont reconvertis en moudjahidin dans le cadre d'un projet criminel soutenu non sans enthousiasme tout à la fois par l'Occident et le monde musulman.
Le Pakistan, toujours méfiant à l'égard de l'Inde, devint le centre de cette mutation.
L'Occident croyait en avoir fini après la chute de l'empire soviétique, mais la région - et de plus en plus la communauté internationale - continuent à payer le prix fort pour ce sinistre projet.
Les maux de deux décennies en Asie du Sud peuvent être attribués aux années du djihad afghan : la montée des talibans, la domination des fanatiques religieux soutenus par le Pakistan dans le mouvement de libération du Cachemire et finalement l'extension des conflits sectaires à l'intérieur même du Pakistan.
En Afghanistan, l'armée et les services de renseignement pakistanais ont cherché une &quot;profondeur stratégique&quot; contre l'Inde.
Ils voulaient également lui faire payer le prix de son soutien aux révoltes des années 1960 et 1970 qui ont conduit à ce que le Bangladesh se détache du Pakistan pour devenir indépendant.
L'Inde n'est pas sans reproche dans cette affaire.
Elle poursuivait une double stratégie : d'une part elle prétendait qu'il n'y avait pas de problème au Cachemire (un mensonge flagrant), d'autre part elle encourageait la confrontation ethnique au Pakistan.
Une guerre brutale entre les services de renseignement pakistanais (l'ISI, Inter-Services Intelligence) et indiens (RAW, Research and Analysis Wing) a éclaté en Asie du Sud.
Le LET ( Lashkar-e-Taiba , l'Armée des purs), un mouvement activiste basé au Pakistan qui soutient l'insurrection dans la partie indienne du Cachemire, est le produit de ces années.
Selon les enquêteurs indiens, ce groupe est impliqué dans les événements de Bombay.
La répression du Pakistan contre cette organisation à travers tout le pays tend à confirmer cette accusation, même si le Pakistan demande publiquement davantage de preuves.
Le LET était le bras armé de l'organisation Ahle-Hadith, une version d'Asie du Sud du fondamentalisme de type saoudien, dont le but est de s'en prendre aux forces indiennes au Cachemire.
L'ancien président pakistanais Pervez Moucharraf a dissous ce groupe après le 11 septembre, mais certains de ses militants sont passés dans la clandestinité ou ont rejoint le JuD ( Jamaat-ud-Dawa , le parti du prosélytisme), une organisation qui gère des centres d'éducation religieuse et organise des actions caritatives.
Etant donné ses liens avec les services de renseignement pakistanais, ce groupe n'a jamais été réellement inquiété.
Après le tremblement de terre dévastateur de 2005, il a même participé aux secours du coté pakistanais du Cachemire.
Mais les stratèges militaires pakistanais n'ont pas réalisé que des mouvements comme le LET et le JuD avaient aussi un objectif au Pakistan même : faire de ce pays une théocratie.
Hafiz Saeed, le fondateur du LET et responsable actuel du JuD, a déclaré fièrement : &quot;Nous croyons dans le choc des civilisations et nous allons continuer le djihad jusqu'à ce que l'islam devienne la religion dominante&quot;.
Le JuD avec de nombreux autres groupes dans la même mouvance a radicalisé des milliers de jeunes Pakistanais.
Avec ses publications et avec Internet il contestait régulièrement l'enseignement des mystiques soufis qui ont importé l'islam en Asie du Sud en favorisant le pluralisme et l'amour de l'humanité.
Tout en demandant au Pakistan de réagir vigoureusement contre le JuD, l'Inde doit reconnaître que le Pakistan est lui aussi victime de la terreur.
Toute confrontation militaire avec ce pays va renforcer les radicaux pakistanais.
L'Inde doit aussi se remettre en question, car la violence anti-musulmane au Gujarat et l'activité des fondamentalistes hindous ont virtuellement fourni des occasions de recrutement aux extrémistes musulmans indiens.
Une résolution à l'amiable du conflit du Cachemire améliorerait les perspectives de paix en Asie du Sud.
Le Pakistan doit engager un effort de grande envergure et de longue durée contre les groupes extrémistes opérant sur son territoire.
Les activistes de toutes obédiences doivent être mis hors d'état de nuire, ceci dans la transparence.
Le Pakistan doit étendre et améliorer le système d'éducatif et les services publics afin que les groupes radicaux ne puissent attirer les jeunes dans leurs écoles et leurs réseaux d'aide sociale.
Sinon, le statu-quo pourrait être une grave menace pour l'avenir du Pakistan et de toute l'Asie du Sud.
Le combat pour l'âme du Pakistan
Les talibans semblent pour l'instant en déroute; certains se sont même rasé la barbe ou se cachent sous une burqa pour éviter d'être reconnus et roués de coups.
La raison est simple: le peuple apporte un soutien croissant à son armée.
Ce soutien persiste malgré un coût humanitaire conséquent,  plus de 1,5 million de réfugiés intérieurs.
Ces combats font suite à une trêve négociée, alors que le gouvernement tentait d'étouffer les militants dans les zones tribales du Pakistan en tentant de parvenir à un accord avec le chef des talibans, Sufi Mohammad.
Cet accord, qui a mis en place une sorte de loi islamique (sharia) dans la région en échange de l'engagement des militants à déposer leurs armes, a reçu le soutien du Parti National Awami, comparativement plus libéral et qui gouverne la province de la Frontière-du-Nord-Ouest, où se trouve Swat.
Mais les soi-disant garanties du taliban à faire profil bas ont été entâchées par deux incidents qui ont permis de mettre en lumière son vrai visage.
Tout d'abord, des chaînes de télévisions privées ont diffusé à travers le pays une vidéo enregistrée sur un téléphone portable et montrant la flagellation d'une jeune fille du Swat de 17 ans.
Le public a pu se rendre compte de manière assez crue ce que représentait vraiment la justice pour les talibans.
Puis, Mohammad a expliqué sa vision politique dans le cadre d'une interview sur GEO TV.
Selon lui, la démocratie est non-islamique, de même que la Constitution et l'appareil judiciaire pakistanais, et l'Islam interdit aux femmes l'accès à l'éducation et le droit de sortir de chez elles, excepté pour effectuer le Hajj à la Mecque.
Les conservateurs religieux ont été très étonnés.
Les chefs des partis religieux ont rapidement exprimé leur désaccord avec les idées de Mohammad.
Les médias Pakistanais ont exploité sous une nouvelle forme un commentaire bien connu de Mohammad Iqbal, le poète philosophe qui évoquait l'idée d'un état musulman indépendant au Pakistan.
"La religion des Mollahs c'est l'anarchie au nom d'Allah" a-t-il déclaré.
Mais rien n'est encore joué. Et à court terme, beaucoup de choses reposent sur la capacité de l'Etat à garder le contrôle du Swat et à y rétablir des institutions civiles.
Et, même si l'état y parvient, préserver le contrôle sur le Swat ne sera que la première étape.
Les talibans sont répandus sur toute la NWFP et la région de la Fédération des Zones Tribales.
Des militants "Talibans du Punjab" qui ont combattus au Cachemire contre l'Inde continuent de circuler entre le Punjab et les Territoires-du-Nord-Ouest, ce qui représente un autre défi à l'autorité du gouvernement.
En fait, l'important à long terme est de savoir si les musulmans de l'Asie du sud-est seront véritablement capables de freiner la ‘talibanisation' croissante.
La réponse à cette question est à trouver non seulement au Pakistan, mais aussi au sein des différentes communautés musulmanes de la région,
Des élections doivent avoir lieu en Afghanistan avant la fin de l'année.
Des élections transparentes seraient une réelle occasion pour asseoir la crédibilité du gouvernement afghan.
Au Pakistan, après des années de pouvoir militaire, la transition démocratique n'est toujours pas terminée.
Il y a beaucoup d'espoir malgré tout dans le dynamisme des médias pakistanais et dans l'énergie déployée par la communauté juridique en mars dernier pour redonner son siège de Président de la Cour Suprême à Iftikhar Mohammad Chaudhry.
Puis il y a aussi l'armée pakistanaise, sorte de ‘super parti politique' du pays.
Les relations du Pakistan avec l'Inde, l'Afghanistan et les Etats Unis reposent en grande partie sur les militaires.
Le Commandant en Chef Ashfaq Kiyani n'a démontré aucun intérêt à prendre le pouvoir comme l'avait fait son prédécesseur, le Général Pervez Musharraf.
Mais l'armée doit se soumettre au leadership politique du Pakistan.
Il faut que l'armée admette que ses interventions répétées ne servent pas toujours le pays.
De façon plus significative, malgré la loi martiale et les assassinats politiques, les pakistanais n'ont toujours pas abandonné leur rêve de démocratie.
A l'image de Afzal Lala, homme politique Pashtun associé au Parti National Awami, et qui, malgré toutes les menaces du sanguinaire Tehrik-e-Taliban Pakistan, est resté dans le Swat pendant les récents combats.
La démocratie est essentielle car elle est génératrice d'investissements dans les domaines de l'éducation, de la santé et de l'économie, permettant au citoyen lambda d'améliorer son quotidien et constituant une forme de remerciement pour sa participation citoyenne.
La talibanisation gagne du terrain lorsque les gens perdent foi en la capacité d'un état moderne à améliorer leur quotidien.
Il faut bien sur s'atteler à faire respecter la loi, mais le contre-terrorisme n'est jamais uniquement une affaire militaire.
Les promesses d'une aide financière des Etats-Unis et du consortium ‘les amis du Pakistan' (l'Union Européenne, la Chine, et le Japon) sont importantes ; mais lorsqu'il s'agit d'investir avec sagesse dans des projets de développement, le Pakistan n'a pas de quoi être vraiment fier de son bilan.
Il faudra impérativement que les contributeurs et le secteur privé pakistanais supervisent ces investissements.
Une seule condition doit être imposée au Pakistan : les premiers fonds doivent impérativement servir à reconstruire les écoles de filles de la vallée du Swat - et si nécessaire, sous la surveillance permanente de l'armée.
Un berceau de contradictions
L'invasion de l'Irak menée par les Américains était censée initier un processus de transformation dans tout le Moyen-Orient.
Le poète et analyste politique syrien Ammar Abdulhamid évoque un dégel en Syrie, dégel qui ne constitue peut-être pas un changement radical, mais tout au moins son signe précurseur.
La vie en Syrie n'a jamais été simple.
Les réalités, méticuleusement masquées sous un vernis d'homogénéité, ont toujours été trop complexes, même pour le plus sagace des spécialistes.
La coexistence pacifique des innombrables groupes ethniques, religieux et tribaux du pays résulte d'un amalgame complexe de concessions, de compromis, d'accords tacites et d'autres arrangements pragmatiques perfectionnés au fil des siècles.
Au cours des derniers mois, la vie est devenue encore plus complexe, les partisans de l'élite dirigeante du pays et de la société civile semblant plus perplexes que jamais sur l'avenir du pays.
Chaque groupe vise à assurer ses propres privilèges tout en préservant l'intégrité territoriale et l'unité nationale d'un pays de plus en plus turbulent et fragile.
Ces développements découlent bien évidemment de l'invasion de l'Irak par les Américains, qui a transformé une menace vague et distante en un voisin imposant dont les intentions envers le régime baathiste de Syrie sont tout sauf amicales.
Par conséquent, la nécessité d'un changement radical au niveau de la structure et du style d'un régime précédemment affaibli par les réalités a finalement commencé à être assimilée.
Les divers centres de pouvoir politique de Syrie se sont ainsi lancés dans une quête désespérée pour une vision annonciatrice de changement, tout en laissant l'ordre existant subsister.
Etant donné que les dirigeants de la Syrie ne possèdent ni la capacité ni le savoir-faire requis pour créer cette vision, la société civile a bénéficié d'une certaine marge de manoeuvre pour passer à l'action.
Il est évident que cette expansion de l'arène opérationnelle de la société civile risque de se transformer en opposition ouverte à l'encontre des dirigeants de la Syrie.
Le but est de créer un débat dans l'espoir de produire la vision du changement, une vision plus que nécessaire.
Le monde extérieur aura ainsi l'impression que des changements sérieux se produisent et que le régime doit disposer de suffisamment de temps pour les mener à bonne fin.
Les répressions, les détentions et les procès illégaux coexistent côte à côte avec une tolérance grandissante envers des initiatives créatives.
Plus de vingt ONG ont été mises en place au cours de ces derniers mois.
Beaucoup sont des associations caritatives et incluent souvent dans leur commission consultative un ou deux membres ayant clairement des liens avec le gouvernement (la fille d'un ministre ou d'un général ou, dans certains exemples notables, la femme du président).
Même ainsi, ce développement reste conséquent selon les normes syriennes, les initiatives indépendantes étant traditionnellement désapprouvées.
Le service de presse All4Syria (www.all4syria.org), créé par l'ingénieur syrien Ayman Abdul Nour, a une réelle importance ici.
Ce service comprend un bulletin électronique qui renferme des rapports et des articles relatifs à la Syrie rassemblés auprès de diverses sources, et qui inclut souvent des commentaires des membres de l'opposition sur le territoire national et à l'étranger.
A sa manière, All4Syria a instauré un canal de dialogue indirect entre le gouvernement et l'opposition, qui n'aurait peut-être pas pu être mis en place autrement.
Bien que le site Internet de All4Syria ait été récemment bloqué pour des raisons non précisées, le bulletin continue d'être diffusé et Mr. Abdul Nour évolue dans ses cercles habituels sans être importuné.
J'ai participé au lancement d'une autre initiative, le projet Tharwa (www.tharwaproject.com), que j'ai longtemps considéré comme un moyen pour la région arabe de traiter ses problèmes avec les minorités religieuses et ethniques.
Bien qu'ayant une portée régionale et étant doté d'une commission consultative internationale originale, le projet Tharwa (Tharwa signifie richesse en arabe) est basé à Damascus et sera mis en oeuvre depuis cette ville.
Le lancement du projet Tharwa un mois auparavant a par inadvertance coïncidé avec les émeutes kurdes qui ont ébranlé le nord de la Syrie.
Ceci, associé à l'importance de la commission consultative (qui comprend le célèbre sociologue égyptien Saad Eddin Ibrahim, l'expert français de l'Islam politique Gilles Kepel, et Flynt Leverett, un membre de l'institution Brookings) et à la sensibilité des droits des minorités en général, se sont combinés pour donner au projet une portée nationale, régionale et internationale.
Jusqu'à présent, les autorités de la Syrie n'ont pas réagi au projet Tharwa.
Il est probablement trop tôt pour cela.
Mais le projet semble incarner le type d'activité susceptible de contribuer à produire des visions de changement.
Certains membres du gouvernement syrien en sont sans doute conscients.
Néanmoins, quatorze militants de la société civile qui ont tenté d'organiser une réunion spéciale pour traiter les réalités du problème kurde en Syrie ont récemment été condamnés à diverses reprises pour avoir tenté d'ébranler l'unité nationale.
Les autorités souhaitent manifestement contrôler l'ampleur du dégel de la culture politique de la Syrie.
Mais même si de telles répressions se poursuivent, un nombre croissant d'initiatives indépendantes privées bouillonnent à la surface.
Mes collègues et moi-même devons désormais travailler dur et sans discontinuer pour étendre la portée de la participation populaire dans le pays et dans la région.
Nous ne pouvons pas nous prononcer à ce stade sur la tournure que prennent les événements.
Tout et rien semblent possibles.
Il est quand même tentant de penser que la Syrie connaît un nouveau début, et la fin d'une ère dont nous supportons tous les péchés.
Le dialogue avec l'Iran et la Syrie est-il vain ?
Les partisans de la guerre en Irak ne comprennent pas les complexités d'une guerre efficace dont le but serait de libérer et de démocratiser.
En conséquence, leurs politiques n'ont pour résultat que d'éliminer les deux grands rivaux, les Talibans et le régime de Saddam Hussein, laissant à l'Iran une chance en or de dominer la région -- et il est peu probable que les dirigeants iraniens ne sautent pas sur l'occasion.
Ceux qui se prononcent en faveur du dialogue avec les Iraniens et leurs alliés syriens, comme l'ancien secrétaire d'État américain James Baker, s'imaginent parvenir à une entente qui permettrait aux Etats-Unis de sortir d'Irak avec élégance et de stabiliser un pays déchiré.
Cette idée illusoire repose sur deux suppositions erronées : d'une part, les Iraniens et les Syriens pourraient réussir là où les Américains ont échoué ; d'autre part, la communauté internationale aurait les moyens de garantir leur coopération.
Il est vrai que la Syrie et l'Iran soutiennent fortement les insurgés irakiens et que la Syrie continue à encourager le trafic d'armes et de guerriers du djihad à travers ses frontières avec l'Irak.
Il est pourtant naïf de croire que ces activités peuvent être interrompues à tout moment.
Tout d'abord, les intérêts des communautés chiites en Irak et en Iran ne sont pas les mêmes.
Les Chiites irakiens n'ont jamais accepté les ordres iraniens et la plupart ont pris part à la guerre de Saddam contre l'Iran dans les années 80.
Après tout, les Chiites irakiens sont Arabes et s'ils sont désormais disposés à coordonner leurs activités avec leurs équivalents perses, leur objectif principal sera toujours de s'assurer une voie indépendante le plus tôt possible, alors qu'ils poursuivent une lutte fratricide en Irak.
L'Iran n'est pas mieux placé que les Etats-Unis pour les convaincre de régler leurs différends.
Le président syrien, Bachar el-Assad, se trouve face à un dilemme similaire.
Même s'il a ouvert les frontières de la Syrie aux guerriers du djihad et a permis aux adeptes de Saddam d'opérer en toute liberté, ce choix n'est peut-être pas totalement le sien.
L'aide de la Syrie à Saddam pour détourner le programme « pétrole contre nourriture » des Nations Unies a profité financièrement aux frontaliers, qui ont toujours été plus proches -- en termes de coutumes, de dialecte et de vision des choses -- de leurs voisins irakiens que de leurs compatriotes syriens.
En l'absence d'investissements publics, les fidèles locaux se sont tournés vers le parti Baas irakien qui les a aidés à améliorer leur condition.
Effectivement, même les dispositifs de sécurité locaux ne se plient pas aux ordres d'Assad et de sa clique de fermer les frontières.
Dans ces conditions, ni la Syrie ni l'Iran ne semblent pouvoir faire autre chose que de semer la pagaille en Irak.
Mais alors, le dialogue proposé entre les Etats-Unis et ces États ne servira-t-il qu'à donner davantage de pouvoir aux régimes corrompus et ambitieux ?
L'histoire se complique avec l'enquête des Nations Unies sur l'assassinat de l'ancien Premier ministre libanais, Rafiq Hariri.
Assad ne souhaite qu'une chose : que cette affaire tombe aux oubliettes -- et les partisans du dialogue pensent pouvoir lui donner satisfaction, dans l'espoir de briser l'alliance entre la Syrie et l'Iran.
Mais il s'agit simplement d'une autre supposition erronée (pour ne pas dire amorale).
Cette alliance vieille de vingt ans a été ouvertement réaffirmée par les deux régimes dominants, pas plus tard qu'en janvier 2005.
Le récent refus d'Assad d'assister à un sommet à Téhéran avec ses homologues iraniens et irakiens n'était qu'une tactique pour lancer un appel aux partisans du dialogue.
En effet, l'Iran a investi des centaines de millions de dollars en Syrie et les transactions bilatérales dépassent le milliard de dollars chaque année.
L'Iran a influence grandissante sur le dispositif de sécurité syrien et finance la mise en place de milices syriennes chiites pour compenser le soutien défaillant de l'armée et de la communauté minoritaire alawite à Assad.
Le président syrien ne tournera pas le dos à tout cela.
Aucun accord ne sera assez satisfaisant, pas même avec la restitution du plateau du Golan.
Pour Assad et ses partisans, la survie est plus importante que la souveraineté.
Pourtant, les célèbres analystes et décideurs politiques qui préconisent d'engager le combat avec la Syrie et/ou l'Iran reflètent bien l'incohérence et les limites des puissances occidentales à l'égard des réalités de la région la plus turbulente du monde.
Et c'est, semble-t-il, le prix de leur arrogance.
Soutenir la « Campagne pour la liberté » de l'Amérique
Peu de temps après la conférence d'Annapolis, qui a rassemblé les représentants de tous les États arabes  -- dont la Syrie  -- et Israël, bon nombre d'observateurs ont considéré notre rencontre comme un signe de refus du gouvernement Bush de normaliser les relations bilatérales avec la Syrie ou de conclure tout accord ou marché avec son régime.
Ce point de vue ne semble pas très éloigné de la vérité.
En effet, lorsqu'il s'adressait à nous, Bush ne cachait pas son dédain pour les dirigeants syriens et rejetait la possibilité de négociations directes ou de toute amélioration des relations.
En tant que tel, le « langage corporel positif » qu'Emad Moustapha, ambassadeur de Syrie aux Etats-Unis, dit avoir détecté durant sa brève rencontre avec la Secrétaire d'État Condoleezza Rice à l'occasion de la conférence d'Annapolis a été écrasé par le langage verbal négatif de Bush lors de notre réunion.
Et nous savons tous qui hérite des responsabilités.
Pour notre part, nous avons mis l'accent sur la dégradation des droits de l'homme en Syrie.
Dès la fin de notre réunion, jour où l'on célébrait la Journée internationale des droits de l'homme dans le monde, le régime syrien lançait une campagne d'intimidation et d'arrestations massives à l'encontre de certains des plus importants dissidents.
Si bon nombre d'entre eux ont été libérés au bout de quelques heures, certains sont restés en prison.
Cet épisode montre la nécessité de poursuivre le combat pour les droits de l'homme et la démocratie.
Quelle que soit la cause de ces faiblesses, il importe que les responsables politiques américains et européens tirent la leçon suivante : même s'il est nécessaire de changer de tactique, l'objectif de faciliter la démocratisation et la modernisation demeure valable.
Enfances étouffées, choix cruciaux.
Ayman travaille très dur à l'école.
Il rêve d'un avenir, d'un métier.
Mais avec 47 élèves entassés dans sa classe, des classes qui fonctionnent en double roulement, apprendre dans ces conditions est très difficile et stressant. La maison n'est pas non plus un refuge: la récente incursion militaire à Jabalia s'est produite à 200 mètres de l'endroit où Ayman vit.
Les fusillades et les bombardements ont tellement terrorisé sa petite sœur de 5 ans qu'elle continue à se réveiller la nuit en hurlant.
L'expérience d'Ayman n'est malheureusement que trop fréquente dans les voisinages surpeuplés et étouffant de Gaza, où ce sont les moins responsables de cette situation qui souffrent le plus. Pourtant, parmi les 840,000 enfants de Gaza- 555,000 d'entre eux sont des réfugiés- Ayman semble avoir plus de chance que beaucoup d'autres.
Depuis le récent regain de violence le mois dernier, 33 filles et garçons palestiniens au moins ont été tués, et de nombreux autres ont été blessés ou mutilés - tous se sont retrouvés piégés par des tirs croisés, tués dans leur propre maison ou emportés par des explosions qui les ont surpris alors qu'ils jouaient dans leur propre jardin. Le 28 février, quatre enfants qui jouaient au football ont été touchés par un missile qui a déchiqueté leurs corps, leurs propres familles n'ont pu les identifier.
Ayman, ses frères et sœurs, comme tous les enfants de Gaza, voient leur espace de vie se réduire comme peau de chagrin au fil des jours, impuissants face à ce lent  étouffement de leur esprit et de leurs rêves.
Au lieu d'espérer s'épanouir,  ils sont piégés dans une prison virtuelle, et tout ce qui devrait aller de soi, tout ce qui devrait être normal pour un enfant, ne leur est pas accordé, comme si le droit de jouer, d'aller à l'école, d'avoir suffisamment à manger, d'avoir de la lumière pour faire ses devoirs à la nuit tombée, le droit de se sentir en sécurité à la maison, n'étaient pas fait pour eux.
Le poids de l'un des plus longs conflits mondiaux repose sur leurs frêles épaules, détruisant leur enfance et leur infligeant des cicatrices psychologiques que, souvent, ils porteront à vie.
Les Palestiniens ont longtemps été considérés comme étant parmi les plus éduqués au Moyen Orient.
Aujourd'hui après des années de violence, de bouclage, de pauvreté, l'éducation et l'excellence d'un système éducatif qui faisait leur fierté, a été anéanti.
Environ 2,000 enfants à Gaza ont abandonné les bancs de l'école au cours des cinq derniers mois.
Ceux qui restent doivent se partager des livres en lambeaux et doivent se débrouiller sans les ressources élémentaires. Les examens semestriels qui ont eu lieu au mois de janvier dans les écoles de l'UNRWA  (Office de secours et de travaux des Nations Unies pour les réfugiés de Palestine dans le Proche-Orient) ont révélé un taux d'échec de 60 pour cent des élèves en mathématiques et de 40 pour cent en arabe, langue maternelle des enfants.
Pourtant, malgré cela, Ayman persiste : « je veux être instruit.
Je veux être ingénieur et construire mon pays »
Rappelons au monde que la crise qui sévit à Gaza est un désastre engendré par l'homme. Rappelons au monde que la situation aujourd'hui est la pire depuis que l'occupation a commencé.
Soixante dix neuf pourcent des foyers de Gaza vivent dans la pauvreté ; huit sur dix dépendent de l'assistance alimentaire. Presque la moitié de la population en âge de travailler est sans emploi ; l'industrie locale s'est totalement effondrée.
Les systèmes de distribution de l'eau et le traitement des eaux usées sont défaillants ; les ordures s'entassent dans les rues.
L'UNICEF travaille d'arrache pied  pour  redonner à la jeunesse de Gaza un sentiment de normalité, notamment en développant des ateliers de rattrapage pour que les enfants continuent leur scolarité, en mettant en place des programmes de sports et de loisirs dans les écoles et en travaillant avec les communautés pour créer des terrains de jeux où les enfants peuvent être des enfants, tout simplement, en sécurité.
L'UNICEF travaille avec des partenaires pour approvisionner en eau, en hygiène et en fournitures médicales, les familles, ainsi que les centres de santé .
Et partout où le besoin se fait sentir, des équipes de soutien psychologique, formées par l'UNICEF, viennent en aide aux parents et aux  enfants palestiniens, pour leur permettre de faire face au fardeau du stress.
Mais si l'UNICEF fait son possible pour venir en aide à ceux qui sont au coeur de la tourmente de Gaza, les dirigeants politiques sont les seuls à pouvoir mettre un terme à cet abominable cauchemar. Le siège doit être levé.
L'assassinat de civils doit prendre fin des deux côtés.
Les enfants israéliens et palestiniens méritent de grandir en paix. Et les leaders des deux côtés, soutenus par la communauté internationale, doivent pouvoir trouver le langage d'un dialogue honnête, seul chemin vers la paix durable.
D'un ton très calme, le père d'Ayman a dit, « mes enfants sont mon espoir. » Les enfants de Gaza sont une lumière dans l'obscurité. Ils méritent d'avoir la chance de briller.
La seconde chance de l'Europe dans les Balkans
Si la décision concernant le Kosovo n'implique pas forcément la reprise d'un conflit à grande échelle, elle soulève toutefois de sérieuses questions sur les relations de l'Europe avec la Russie et les États‑Unis, ainsi que sur la stabilité dans la région des Balkans.
Les États‑Unis ont un enjeu majeur dans cette situation, mais les intérêts des pays européens sont manifestement plus importants. Qui sait, ces derniers seront-ils peut-être à la hauteur du rôle de leader ?
Durant les deux prochains mois ou plus, le Conseil de sécurité de l'ONU débattra d'une proposition pour l'avenir du Kosovo, élaborée non sans peine au cours d'une année de « négociations » entre Belgrade et Pristina, par l'envoyé de l'ONU et Martti Ahtisaari, ancien président finlandais.
Ce projet prévoit « l'indépendance surveillée » du Kosovo, une protection maximale pour les Serbes et d'autres minorités, et un rôle de supervision pour l'Union européenne.
La proposition d'Ahtisaari reconnaît qu'aucun accord entre les parties n'est possible et qu'il n'existe pas d'alternative constructive à l'indépendance du Kosovo.
Les Etats-Unis et l'ensemble de l'Union européenne se sont ralliés à la proposition d'Ahtisaari.
Pourtant, à titre individuel, plusieurs pays européens -- l'Espagne, la Grèce, l'Italie, Chypre, la Roumanie, la Slovaquie, et l'Autriche -- sont sceptiques ou pessimistes vis-à-vis de l'indépendance du Kosovo, ce qui soulève des questions de fond quant à la détermination de l'Union européenne.
Pendant ce temps, Vojislav Kostunica, Premier ministre serbe, a lancé une campagne diplomatique remarquablement efficace et infatigable dénonçant Ahtisaari et sa proposition.
Il a renforcé l'opinion de ceux en Europe et partout ailleurs qui doutent de la mise en cause de l'intégrité territoriale d'un pays où qui continuent à croire en un accord négocié.
Plus préoccupant encore, on peut se demander si l'Europe mal assurée tiendra tête à la Russie, de laquelle dépend la Serbie pour maintenir sa souveraineté sur le Kosovo.
Jusqu'à présent, le Kremlin a affirmé qu'il accepterait uniquement un accord voulu par les deux parties, appuyant dans le fond la position de la Serbie.
Tout en n'écartant pas la possibilité d'un veto, la stratégie actuelle de la Russie consiste à retarder autant que possible le vote du Conseil de sécurité en organisant rapidement une autre mission d'information au Kosovo, qui ravivera probablement la volonté de négocier un nouvel accord.
La Serbie est favorable à ce retard, dans l'espoir qu'il stimulera la violence de Kosovars frustrés, exacerbant ainsi l'opposition de l'Europe à l'indépendance et le soutien au dévouement de la Serbie pour maintenir le statu quo, ou, en dernier recourt, diviser le Kosovo.
Certains pays européens croient pouvoir maintenir un consensus européen derrière le plan d'Ahtisaari, or, ils permettent aux Russes de traîner les pieds pour la raison que ce retard n'est pas déraisonnable et que les nouvelles négociations pourraient apporter quelque chose de satisfaisant.
Mais en adoptant cette position, ils barrent la route à leur propre envoyé et risquent de stimuler une violence qu'ils prétendent abhorrer.
L'histoire ne console guère.
La façon dont l'Union européenne a géré par le passé les relations avec la Serbie n'a fait qu'affermir l'intransigeance.
Au lieu de soutenir que l'indépendance du Kosovo est une condition indispensable à l'adhésion à l'Union européenne -- si importante pour la modernisation de la Serbie et la stabilité des Balkans -- , les dirigeants européens comme Javier Solana prennent Kostunica pour un grand leader démocratique.
Ils ont implacablement, mais sans succès, fait pression sur les dirigeants du Monténégro pour qu'ils restent dans une union dysfonctionnelle avec la Serbie, toléré le référendum douteux de 2006 de Kostunica sur un projet de constitution faisant du Kosovo une partie de la Serbie, et affaibli les demandes pour que la Serbie coopère au Tribunal pénal international de La Haye.
La mise en oeuvre de la proposition d'Ahtisaari dépendra de la solidarité et de la persévérance européenne, et du soutien solide des Américains, pour surmonter les vicissitudes du débat de l'ONU, faire pression sur les membres non permanents du Conseil de sécurité qui demeurent sceptiques, comme l'Indonésie et l'Afrique du Sud, et persuader la Russie de ne pas exercer son droit de veto.
Nombreux sont ceux qui croient que la Russie ne mettra pas en danger ses relations avec l'Europe et les États-Unis, et reviendra au bout du compte sur sa position si les pays occidentaux restent fermes.
Pourtant, la Russie semble d'humeur gaulliste, alors que d'autres questions en souffrance causent des frictions avec les États-Unis et l'Europe.
La Russie de Poutine n'est pas celle d'Eltsine -- une époque où l'Occident pouvait simplement expédier les préoccupations russes.
L'Europe est vulnérable sur de nombreux fronts, notamment au vu de sa dépendance à l'énergie russe, tandis que le pouvoir présidentiel américain affaibli a réduit l'influence des États-Unis sur la Russie.
Si la Russie oppose son veto au plan d'Ahtisaari, la façade unie de l'Europe se fissurera probablement : bon nombre de pays refuseront soit de se ranger du côté des États-Unis pour reconnaître un Kosovo indépendant sans la bénédiction de l'ONU, soit d'envoyer une mission de surveillance sur place.
Cette situation marquerait le début d'une nouvelle période tumultueuse dans les Balkans, avec bien davantage que le Kosovo en jeu.
En fait, compte tenu de la confusion de l'ONU et de l'alliance occidentale, la région risquerait de subir davantage de troubles politiques russes.
Putin's Balkan Mischief
La Russie n'a jamais manqué une occasion d'entraver les efforts des pays occidentaux pour faciliter l'indépendance du Kosovo. Après une année de négociations entre la Serbie et le Kosovo, le Kremlin du président Vladimir Poutine a rejeté le rapport du médiateur de l'Onu qui recommandait une indépendance surveillée, empêché le conseil de sécurité d'accepter ce rapport, et a insisté pour que les négociations entre la Serbie et le Kosovo soient prolongées de trois mois -- même après que tout compromis était devenu impossible.
Il y a trois semaines, lors du conseil de sécurité de l'Onu, la Russie a insisté pour que tout accord obtienne l'approbation à la fois de la Serbie et du Kosovo, et sur la nécessité de nouvelles négociations.
Elle sait pourtant que de telles négociations seront stériles, mais croit qu'un nouvel appel, apparemment innocent, à parlementer ébranlera l'unité de l'UE, ce qui semble constituer pour Poutine un objectif vital.
Un nouveau retard est aussi susceptible de provoquer des violences au Kosovo et de saper le soutien international à la cause de l'indépendance.
La haine qu'éprouve Poutine à l'égard des relations de "soumission" de l'époque d'Eltsine alimente son opposition.
Mais c'est le retard de l'Occident à résoudre le problème du statut du Kosovo qui a permis à cette opposition de gagner du terrain.
En effet, l'Occident n'a pas cessé de mal interpréter les intentions de la Russie au sujet du Kosovo.
Beaucoup proclamaient que le Kremlin avait beau repousser l'inévitable, au final il n'empêcherait pas l'indépendance.
Aujourd'hui, à la onzième heure, la Russie s'accroche à sa position obstructionniste, et ses élections présidentielles de mars ne feront sans doute que consolider toute position anti-européenne.
Que fera donc Poutine lorsque les États-Unis et la majorité des membres de l'Union européenne reconnaîtront l'indépendance du Kosovo dans les prochains mois, sans la bénédiction de l'Onu, comme ils l'envisagent aujourd'hui ?
Il est fort peu probable que le Kremlin tentera une nouvelle intervention militaire au Kosovo (sa tentative en 1999 de faire atterrir des soldats à l'aéroport de Pristina s'est soldée par un échec), mais il dispose de toute une gamme de possibilité susceptibles de faire réfléchir l'Occident.
Le soutien du Kremlin a rendu efficace l'intransigeance nationaliste de la Serbie au sujet du Kosovo.
La Russie a certes déclaré qu'elle ne donnerait pas un blanc seing à la Serbie, mais elle soutiendra sans doute les tentatives gouvernementales serbes d'isoler et de déstabiliser un Kosovo indépendant.
Alors que la Serbie a résisté à la partition du Kosovo, la Russie soutiendrait également une proposition serbe d'une partition du nord du pays, peuplé de Serbes, tentative qui ouvrirait la boîte de Pandore d'une possible partition de la Serbie, de la Bosnie et de la Macédoine.
Cette proposition pourrait être soutenue par certains en Europe et ailleurs, comme étant un compromis apparemment approprié, même s'il déstabiliserait une fois de plus les Balkans.
La Russie va certainement poursuivre ses efforts diplomatiques pour convaincre le monde que les négociations constituent l'unique moyen de régler le problème, et qu'il ne peut être résolu en dehors de l'Onu.
De nombreux membres de l'Onu se rallieront à ce point de vue, notamment ceux qui comptent de conséquentes minorités ethniques mécontentes.
La Russie pourrait aussi réagir au-delà des Balkans, sûrement dans le Caucase, avec ses régions séparées, tout particulièrement en Géorgie.
Une déclaration d'indépendance du Kosovo provoquerait sûrement une déclaration du même type de la région sécessionniste géorgienne d'Abkhazie, que la Russie pourrait bien reconnaître.
Si la Géorgie prend des initiatives militaires pour l'en empêcher, l'armée russe pourrait réagir avec violence, créant une situation potentiellement incontrôlable.
Certes les États-Unis et l'UE ne veulent pas aggraver l'état de leurs relations avec la Russie, mais ils ne peuvent pas non plus céder à l'obstination russe ; la sécurité européenne est en jeu.
Ils doivent pourtant continuer d'essayer d'éviter une confrontation avec la Russie sur tous les fronts.
L'Occident doit montrer clairement à la Serbie qu'il réagira avec force à toute tentative d'encourager la violence ou de diviser le Kosovo.
Envoyer de nouvelles troupes de l'Otan, en plus de la mission de l'UE prévue, pour surveiller l'indépendance du Kosovo, s'avérerait utile.
La Russie de Poutine, qui fait peu de cas de l'état de droit, enrobe ses tentatives diplomatiques d'une apparence de respect du droit international, et en particulier de la résolution 1244 du conseil de sécurité de l'Onu, qui a mis fin à la guerre du Kosovo en 1999.
Une offensive diplomatique, nécessaire depuis longtemps, doit impérativement être lancée, afin de saper les arguments de la Russie et de rappeler au monde ce qui s'est passé au Kosovo.
La résolution 1244 ne dit pas que le Kosovo doit rester sous souveraineté serbe, contrairement à ce que persistent à dire la Russie et la Serbie, et elle n'empêche pas non plus l'indépendance.
En fait, toute lecture raisonnable de la résolution, surtout dans le contexte des conflits qui ravagent les Balkans depuis vingt ans, admet que l'indépendance répond à ses intentions et justifie les huit dernières années de supervision de la province par l'Onu.
Dans le cas de l'Abkhazie, l'Occident doit rappeler la nature sui generis du Kosovo et souligner les immenses efforts qu'il y a déployés depuis 1999.
Le monde doit faire clairement comprendre qu'un engagement militaire russe en Abkhazie est inacceptable, tout en empêchant aussi le gouvernement de Géorgie de réagir militairement à toute provocation.
La manière dont la Russie réagira au soutien apporté par l'Occident à la déclaration prochaine de l'indépendance du Kosovo montrera à quel point nous avons progressé depuis la Guerre froide.
En gérant avec soin le processus d'indépendance du Kosovo, et en restant attentifs à toutes les opportunités d'améliorer les relations avec la Russie, l'Occident pourra atténuer les pires conséquences de cette confrontation.
Une nouvelle Guerre froide pourrait bien s'avérer glaçante.
La Guerre des générations palestiniennes
Yasser Arafat peut être mort, ses stratégies machiavéliques restent.
Ayant toujours protégé sa position de leader unique du peuple palestinien, M. Arafat a toujours cherché à bloquer par tous les moyens possibles l'émergence d'un rival crédible à même de le défier.
En protégeant ainsi sa position, M. Arafat a empêché la nomination d'un successeur avant sa disparition.
Durant la semaine qui suivit la disparation de M. Arafat, cela ne semblait pas important.
Mahmoud Abbas, collaborateur de longue date de M. Arafat et architecte des Accords d'Oslo, s'est rapidement assuré le soutient du Fatah, la composante principale de l'OLP.
Une transition sans heurt semblait alors possible.
Toutefois, aujourd'hui, Marouane Barghouti, le leader du Fatah en Cisjordanie lors de l'actuelle Intifada, a décidé de se présenter contre M. Abbas pour la présidence de l'Autorité palestienne (AP), depuis sa cellule de prison israélienne.
Face à la stagnation économique et ce que Ahmed Qoreï, le Premier ministre de l'Autorité palestinienne, appelle " l'anarchie des armes ", la guerre de succession est bien la dernière chose dont les Palestiniens avaient besoin.
Tout nouveau leader devra relancer l'économie, faire respecter la primauté du droit, combattre la corruption, unifier les organismes de sécurité de l'AP, préserver l'ordre public, et réaliser tout cela rapidement sous peine de perdre son autorité.
M. Abbas, aussi connu sous le nom d'Abou Mazen, représente la veille garde de la classe politique palestinienne.
Mais la jeune garde, ceux qui menèrent la première Intifada entre 1987 et 1993, ainsi que ceux qui se sont fait un nom dans l'actuelle Intifada, réclame sa part de pouvoir.
M. Abbas aura ainsi besoin de rassembler le soutien de la génération montante des leaders nationalistes s'il veut l'emporter.
Résoudre cette guerre des générations de manière pacifique nécessitera l'organisation d'élections démocratiques au sein du Fatah pour l'appartenance au Conseil révolutionnaire et au Comité central.
Le sixième congrès du Fatah, le premier depuis seize ans, se déroulera en août 2005 et cherchera à réconcilier la vieille et la jeune garde.
Contrairement à M. Arafat et à ses camarades en exil, M. Barghouti, le leader le plus en vue de la jeune garde, a grandi sous l'occupation israélienne et fut arrêté et emprisonné plusieurs fois.
La popularité de M. Barghouti vient également de son refus, dès les débuts, de prendre des responsabilités au sein de l'AP et de ses institutions corrompues et sous la coupe de M. Arafat.
Bien qu'il ait été élu en 1996 au Conseil législatif palestinien, la réputation de M. Barghouti a pris son envol au commencement de l'actuelle Intifada en semptembre 2000.
Son soutien des attaques contre les soldats israéliens et les colons dans les Territoires occupés, dont il défend la légitimité dans le cadre du droit international, lui a valu une immense popularité chez les Palestiniens ainsi que cinq condamnations à vie et une peine de 40 ans dans les prisons israéliennes.
Sa libération évenutelle est maintenant source de spéculations intenses.
Néanmoins, M. Barghouti a commencé à s'exprimer sur la situation politique depuis le fond de sa cellule, et sa présence se fait sentir de plus en plus.
Sa décision de s'opposer à M. Abbas implique que les forces " laïques " du mouvement palestinien sont peut-être divisées au moment où des rivaux avec des intérêts islamistes puissants, le Hamas et la Djihad islamique principalement, s'opposent à elles.
Le Hamas et la Djihad islamique sont des organisations hautement disciplinées qui font régner un contrôle serré sur leurs ailes politiques et militaires.
Bien que le Hamas ait été affaibli par les assassinats israéliens ciblés sur les personnes du Cheik Hamad Yassine et d'Abdel-Aziz Rantisi, il garde des capacités militaires fortes et un soutien populaire de 25 à 30 %, ce qui en fait la deuxième faction la plus puissante en Cisjordanie et à Gaza.
Le Hamas a déclaré qu'il nomemrait son propre candidat à la présidence de l'AP.
Hassan Youssouf, le leader du Hamas qu ia récemment été libéré de sa prison israélienne après 28 mois de détentino administrative, expliquait à Al Jazira que " si le Hamas endossait la direction à ce stade, il serait vilipendé et isolé par la communauté internationale, en conséquence de quoi le peuple souffrirait. "
Même si le Hamas boycotte les élections, de nombreux sympatisants du Hamas voteront pour le candidat le plus engagé dans la défense des exigences principales des Palestiniens.
Les membres du Hamas ne font que réitérer ici les positions de M. Arafat, ce qui s'imposera comme une limitation des concessions que tout nouveau leader pourra faire.
M. Arafat avait préparé un plan détaillé pour un État palestinien indépendant qui comprendrait la Cisjordanie et la bande de Gaza, sa capitale se situant alors à Jérusalem Est, et une solution équitable au problème des réfugiés.
Les changements de dirigeants ne modifieront pas ces conditions pour un plan de paix.
Reste donc la vraie question : qui, de M. Abbas ou de M. Barghouti, sera le mieux à même de faire progresser ce plan aux yeux des Palestiniens et en aprticulier aux yeux des sympatisants du Hamas ?
La réponse à cette question déterminera le plus sûrement qui sera le prochain dirigeant de l'AP.
Éventuellement, Israël devra aussi faire un choix, parce que la paix ne peut s'établir uniquement sur les compromis palestiniens, sans concessions israéliennes.
Israël doit geler ses activités de colonisation en Cisjordanie et stopper la construction de la barrière de sécurité sur les territoires palestiniens.
Israël doit également libérer les prisonniers palestiniens, supprimer les points de passage entre les villes et les villages palestiniens et redéployer ses forces sur les positions tenues à la date du 28 septembre 2000 selon les dispositions de la phase I de la feuille de route pour la paix.
MM. Abbas et Barghouti feraiennt certainement preuve de bonne volonté de leur côté si la preuve en était également faite de l'autre côté.
Le Hamas attendra
La date du 17 juillet fixée initialement pour les élections avait mis le Fatah dans une position difficile.
Le Fatah considère le congrès du 4 août comme une occasion de s'unifier en vue de la campagne électorale, et de redorer son image publique ternie par les luttes intestines et par la corruption.
Le Hamas, conscient de la désorganisation du Fatah, accuse Abbas de repousser les élections législatives pour des raisons partisanes, et non nationales. 
La popularité du Fatah parmi les Palestiniens a chuté depuis le début, en 2000, de la seconde Intifada.
Longtemps colonne vertébrale du mouvement national palestinien, le Fatah est la faction dominante de l'OLP.
Soutenu par la signature des accords d'Oslo et l'établissement de l'autorité palestinienne en 1994, il a vu sa popularité diminuer au cours des dix dernières années, sous des accusations de corruption et d'incompétence.
Le Hamas n'est apparu que récemment dans la politique électorale, en remportant d'impressionnantes victoires sur ses rivaux du Fatah dans de nombreuses municipalités, particulièrement dans la bande de Gaza.
Les dirigeants du Fatah sont donc inquiets : s'ils se lancent dans des élections nationales, vu leur impopularité et leur division actuelles, ils essuieront une sérieuse défaite.
Rien de tout cela n'a été reconnu lors de l'annonce du report des élections.
Abbas a affirmé que cet ajournement répondait à la requête de la Commission électorale palestinienne, après que celle-ci a déclaré que les élections ne pourraient se tenir, car la loi électorale n'était pas encore approuvée.
La Commission a déclaré qu'il lui faudrait au moins deux mois après la ratification pour organiser le scrutin.
La loi électorale a été votée en troisième lecture par le Parlement palestinien, mais elle a été rejetée par Abbas, une décision qui fait partie de ses prérogatives présidentielles.
Abbas veut que tous les candidats soient inclus sur des listes nationales, ce qui permettrait la représentation proportionnelle des principales factions et groupes palestiniens dans le corps législatif.
L'Heure du Hamas
M. Abbas et d'autres responsables de l'Autorité palestinienne (AP) insistent sur le besoin d'instituer « un régime, un système législatif et le pluralisme politique ».
M. Abbas souhaite également que seule l'Autorité palestinienne soit autorisée à porter des armes.
Il a réussi à persuader les militants palestiniens à cesser le feu et à montrer aux Israéliens et au monde entier que l'abandon des colonies n'implique pas nécessairement de violence entre Israéliens et Palestiniens.
Pourra-t-il cependant traduire cette réussite jusqu'à un cesser le feu étendu, des élections pacifiques et une présence consolidée de l'AP dans la bande de Gaza et en Cisjordanie ?  Un échec ne mènerait qu'à une nouvelle défaite dans une course légitime pour les Palestiniens pour mettre en place un État viable.
On ne peut à peine exagérer la difficulté de la tâche à accomplir.
Le Hamas a lancé une campagne médiatique intensive pour s'approprier le retrait israélien comme une victoire remportée grâce à sa « lutte armée ».
La campagne et ses thèmes reflètent les luttes internes pour la prise de contrôle de la bande de Gaza et d'autres territoires sous gestion de l'AP et mettent l'accent sur la détermination du Hamas à ne pas déposer les armes et à continuer la « lutte armée » en Cisjordanie.
Le Hamas a également révélé deux « secrets militaires » lors de l'évacuation.
Le premier est un nouveau missile, appelé Sajil, qui a une portée de 15 kilomètres et peut atteindre un plus grand nombre de villes israéliennes.
Le second est l'existence du « Quassamits », un groupe de jeunes femmes engagées dans la formation au combat.
Le Hamas a programmé ces révélations avec le retrait des colonies pour créer l'impression que l'intensification de sa stratégie militaire lui a permis de l'emporter.
Selon l'un des slogans du Hamas dans les rues de Gaza lors du retrait israélien, « quatre ans de sacrifices pèsent plus que dix ans de négociations ».
De même, Mohamed Deif, le dirigeant de la faction armée du Hamas, déclarait récemment dans une vidéo que la leçon de Gaza est que Israël peut être repoussé de Cisjordanie, de Jérusalem et de Haïfa par la force.
Tout cela ne sert qu'à renforcer un point : le retrait de Gaza est une victoire qui appartient au Hamas.
Une étude publiée sur un site Web associé au Hamas s'accréditait 54 % des Israéliens tués des suites de la lutte armée palestinienne et ce décompte représente en fait le cri de victoire du Hamas.
Dans de telles circonstances, qui gérera les zones évacuées jusqu'aux élections ?
Comment seront distribués les revenus fiscaux entre ceux qui réclament le pouvoir du fait de leur résistance et ceux qui réclament le pouvoir du fait de leur légitimité à gouverner ?
Ces problèmes doivent être résolus sans tarder.  Quelqu'un doit décider rapidement, par exemple, comment diviser les terres et les appartements à construire dans la future ville qu'on appelle déjà « Khalifa ben Zaïd », située sur une ancienne colonie israélienne de la bande de Gaza.
Aucune de ces questions n'a encore reçu de réponse.
Là où le Hamas a demandé l'établissement d'une administration palestinienne pour superviser les zones libérées par Israël, M. Abbas a rejeté la proposition, n'acceptant au mieux qu'un « comité de surveillance » au sein duquel les représentants du Hamas peuvent siéger.
En tout cas, il n'y aura aucune « division de zones » jusqu'à ce qu'Israël soit complètement retiré et que les ruines soient dégagées.
Alors les dissensions politiques aigries pourront commencer dans la préparation aux élections.
Quoi qu'il advienne après le retrait israélien final de la bande de Gaza, on ne peut échapper au fait que les options militaires du Hamas ont été grandement réduites.
La construction du mur de séparation en Cisjordanie rend quasi impossible l'entrée des combattants du Hamas en Israël.
En outre, après la nouvelle occupation des villes de Cisjordanie en avril 2002, Israël avait arrêté à peu près 7 000 Palestiniens qu'on suppose associés au Hamas, au Fatah et à d'autres groupes palestiniens.
Il ne sera pas facile au Hamas de poursuivre la lutte armée.
Le Hamas en a conscience et porte de ce fait toute son attention sur le retrait de la bande de Gaza, cherchant à exploiter cette victoire en exigeant sa part de responsabilité dans le nouvel ordre institué après le retrait.
Il a accepté de participer pour la première fois aux élections législatives palestiniennes, qui doivent se dérouler ne janvier 2006, et on s'attend à ce qu'il remporte un grand nombre de sièges.
Cela cimenterait évidemment son rôle central dans le monde politique palestinien et ne ferait qu'exacerber le défi que doit relever M. Abbas.
Le séisme Hamas
Le Hamas a remporté 76 des 132 sièges au Conseil législatif palestinien et peut compter sur le soutien de quatre députés indépendants.
Cela représente 60 % des sièges au Parlement, gagnés dans presque tous les districts de la Rive ouest et de Gaza.
Le Hamas n'est apparu que très récemment sur la scène électorale, mais cette victoire massive aux législatives ne fait que renforcer le large succès remporté aux élections municipales.
L'heure de la politique vient donc de sonner pour le Hamas.
Selon la loi palestinienne, Mahmoud Abbas, le Président, doit maintenant demander au Hamas de former un nouveau gouvernement.
Les responsables du Fatah semblent, quant à eux, refuser de se joindre à un gouvernement dirigé par le Hamas.
Même si les Islamistes prétendent rechercher une telle coalition, l'humiliante défaite du Fatah lui a fait perdre toute crédibilité en tant que partenaire de gouvernement.
Jusqu'à maintenant, les plus hauts responsables du Fatah ont déclaré qu'ils agiraient en opposants loyaux au Parlement, laissant ainsi la responsabilité gouvernementale au Hamas.
Ils vont devoir s'atteler, en revanche, à la reconstruction et à la renaissance de leur parti.
Le Hamas est bien conscient du choc produit par sa victoire.
Si le Fatah refuse de rejoindre la coalition, le Hamas pourrait choisir de former un gouvernement d'indépendants et de technocrates.
Il est, en revanche, peu probable qu'il décide de former un gouvernement composé d'extrémistes.
La situation politique, sécuritaire et économique des Palestiniens nécessite un gouvernement axé principalement sur la résolution des problèmes et non sur la pureté idéologique.
Le défi le plus urgent auquel le nouveau gouvernement doit faire face est l'anarchie permanente et le non-respect des lois au sein de la société palestinienne.
Les meurtres, les enlèvements, les vols ont atteint des records exceptionnels.
Des individus armés n'hésitent pas à recourir aux kidnapping pour obtenir des emplois, libérer de prison des membres de leurs familles et réclamer vengeance.
Souvent, les personnes impliquées dans ces crimes appartiennent à des gangs locaux, voire à des milices de clans très importants.
Dans l'opposition, le Hamas avait catégoriquement refusé de collecter les armes illégales.
Désormais, il va devoir gérer une société palestinienne armée jusqu'aux dents, souffrant d'un taux de pauvreté de 70 % et d'un taux de chômage de 35 %.
Tirant profit de l'écrasant rejet politique du Fatah, le Hamas doit maintenant être jugé sur l'utilisation de son nouveau pouvoir.
Le compte à rebours politique vient de commencer pour le Hamas.
Les hauts responsables du parti ont bien conscience du défi qui les attend. Ils ont d'ailleurs promis une refonte complète de l'administration et des services publics palestiniens.
Plus que toute autre chose, la réussite du Hamas sera mesurée dans les prochains mois à l'aune de leurs réponses à ces questions.
Le Hamas sera-t-il capable d'éradiquer la corruption et l'incompétence et d'offrir des services équitables et efficaces ?
Dans quelle mesure son élection peut-elle affecter les flux de capitaux étrangers qui sont la composante essentielle du budget national ?
Les premières réactions internationales face à la victoire du Hamas ont été sévères.
L'administration Bush a déclaré qu'elle ne traitera pas avec le gouvernement du Hamas, car celui-ci reste engagé dans la destruction d'Israël.
Tel est, en effet, le langage officiel du Hamas depuis 1988.
Fait intéressant cependant, la plate-forme électorale du Hamas combinait différentes approches concernant la question de l'État palestinien.
D'un côté, elle approuvait pour la première fois l'établissement d'un État palestinien comprenant la Rive ouest et Gaza et dont Jérusalem-Est serait la capitale et d'un autre côté, elle répétait le refus du Hamas de renoncer à une once de la Palestine historique.
Actuellement, il est impossible de savoir si le Hamas va se transformer en une organisation plus modérée.
Mais, il est clair que le Hamas est désormais vulnérable à l'opinion publique. En outre, en tant que parti au pouvoir, il devra faire face aux réactions internationales entraînées par sa victoire.
Immédiatement après les élections, un haut responsable du Hamas, Mahmoud al-Zahar, a annoncé que son parti maintiendrait le cessez-le-feu avec Israël établi en février dernier, si Israël en fait autant.
Il se pourrait que ses responsabilités gouvernementales poussent le Hamas à ouvrir des discussions avec les États-Unis et la communauté internationale.
Quoiqu'il en soit, en dépit des résultats aux élections et de l'absence du Fatah au gouvernement, Abbas reste responsable des négociations avec Israël.
Il a très rapidement appelé à une réouverture des pourparlers de paix, malgré le refus d'Israël et des États-Unis de traiter avec le Hamas.
Les Palestiniens sont désormais en terrain inconnu.
Ils ont voté en masse à une élection décrite par l'ancien Président américain, Jimmy Carter, comme honnête, juste et non marquée par la violence.
Ils ont choisi un parti qui appelait à la « réforme et au changement » en réponse à une décennie de violence et d'anarchie.
Et les Palestiniens ont approuvé l'avis du Hamas selon lequel toute négociation basée sur les accords d'Oslo ne parviendra jamais à réaliser les droits et les ambitions politiques du peuple palestinien.
Maintenant que la victoire est obtenue, le Hamas est responsable des Palestiniens dans le conflit avec Israël.
L'avenir de son peuple entre les mains, -- sans parler de celui d'Israël et du Moyen-Orient -- , comment le Hamas va-t-il assumer sa tâche ? Nul ne peut actuellement le dire.
Le Hamas et le Fatah sont à la croisée des chemins
Depuis sa création au début des années 80, le Hamas refuse d'être sous la direction de l'Organisation de Libération de la Palestine (OLP).
La victoire du Hamas aux élections législatives en début de cet année -- véritable tournant démocratique -- est la preuve que ce parti a atteint la maturité politique.
Pour la première fois dans l'histoire palestinienne, un parti religieux domine le pays.
Mais le Fatah n'accepte pas la défaite et, de son côté, le Hamas est convaincu que des éléments au sein du Fatah s'associent à des plans israéliens et américains visant à renverser son gouvernement.
Abbas est toujours président de la Palestine et, selon la Constitution, commandeur de toutes les forces de sécurité palestiniennes.
Cependant, alors que la plupart des forces armées officielles lui restent fidèles, le Hamas a récemment créé une structure alternative de sécurité autour d'une « force opérationnelle » de 4.000 membres.
Qui plus est, le Hamas a annoncé qu'il recruterait 1.500 agents de sécurité supplémentaires pour la Cisjordanie, fief du Fatah.
Ces dernières semaines, les deux camps se sont affrontés à plusieurs reprises dans la Bande de Gaza, ce qui n'a fait qu'exacerber les tensions.
Les confrontations se produisent au moment où Abbas tente de convaincre le Hamas de modérer sa position anti-israélienne et de s'allier au Fatah dans un gouvernement d'unité nationale.
Le président est d'avis que le seul moyen de mettre fin aux sanctions internationales qui anéantissent la société palestinienne est que le Hamas accepte les négociations avec Israël.
Malgré cela, les deux camps consolident leurs forces armées.
Selon des rapports des Renseignements, le Hamas fait passer des armes et des explosifs en fraude, du Sinaï vers la Bande de Gaza, à un rythme accéléré.
Les Etats-Unis, Israël et certains gouvernements arabes prévoient d'armer et de former des troupes de partisans d'Abbas, notamment sa garde présidentielle, et de les préparer en vue d'une confrontation à Gaza -- qui leur semble inévitable -- avec le Hamas.
Israël étudie la demande d'Abbas de faire venir des armes et des munitions d'Egypte et de Jordanie pour renforcer ses fidèles.
En outre, les Américains proposent d'envoyer la brigade Badr -- aile de l'Armée de libération de la Palestine actuellement stationnée en Jordanie -- vers les territoires palestiniens, comme force de riposte rapide à Gaza pour anticiper la guerre civile redoutée.
La brigade Badr compte plusieurs milliers de Palestiniens, pour la plupart militants de l'OLP de longue date.
Tandis que les manœuvres se poursuivent, Israël et l'Egypte se voient travailler de concert pour soutenir Abbas et le Fatah.
La Bande de Gaza étant non loin de ses frontières, l'Egypte a servi à plusieurs reprises de médiateur entre le Hamas et le Fatah et s'efforce, en vain jusqu'ici, de négocier un échange de prisonniers avec Israël, suite à l'enlèvement par le Hamas de Gilad Shalit, soldat israélien.
Le gouvernement égyptien est néanmoins furieux contre le Hamas et son opposition à la formation d'une coalition gouvernementale.
En effet, le rapt de Gilad Shalit a creusé le fossé entre le Hamas et le Fatah, ce dernier étant convaincu que l'enlèvement n'a pour objet que de saboter les pourparlers au sujet d'un gouvernement d'unité nationale.
D'une manière plus générale, l'Egypte craint que Gaza n'adopte une politique radicale et ne devienne une sorte de « Hamastan ».
En effet, une évolution dans ce sens ne ferait qu'encourager les radicaux islamiques égyptiens contre lesquels le gouvernement se bat depuis des années.
L'Egypte redoute également une éventuelle guerre civile entre les partisans du Fatah et ceux du Hamas.
Même si ce dernier exclut cette possibilité, il n'a pas hésité à sortir l'artillerie lourde contre ses opposants.
D'après Mahmoud Al-Zahar, ministre palestinien des Affaires étrangères, toute dissolution du gouvernement ou toute anticipation des élections par Abbas mènerait droit à la guerre civile.
La crainte d'un combat majeur a déjà poussé de nombreux Palestiniens à s'exiler en Egypte, ce qui a entraîné le déploiement de troupes égyptiennes à la frontière pour contrôler tout exode massif.
Pendant ce temps, Israël s'inquiète de voir le Hamas resserrer sa prise militaire sur Gaza par le biais de fortifications et de réseaux permettant de lancer des roquettes Qassam sur les villes israéliennes voisines.
Israël n'attendra probablement pas l'intervention d'Abbas et de ses partisans, mais entreprendra plutôt une action de grande envergure pour affaiblir le Hamas.
Le Hamas et le Fatah sont-ils capables de mettre de côté leurs différends pour former un gouvernement d'unité nationale ?
Abbas a annoncé que s'il n'est pas possible de s'entendre sur la création d'une coalition dans les deux prochaines semaines, il se verra contraint de dissoudre le gouvernement actuellement en place, ce que le Hamas ne pourra tolérer.
Mais l'éventuelle coalition apaisera-t-elle pour autant les tensions entre les deux partis ?
De nouvelles confrontations verront le jour dès que le nouveau gouvernement sera formé.
L'ironie, c'est que le moyen le plus plausible d'éviter une confrontation à grande échelle entre le Fatah et le Hamas serait qu'Israël fasse incursion dans Gaza.
S'ils devaient faire face aux Israéliens ensemble, les groupes rivaux palestiniens n'auraient d'autre choix que de reporter leur sanglant affrontement.
La maison palestinienne divisée
La confrontation Hamas/Fatah marque un virage radical de la politique palestinienne, dont les priorités premières étaient jusqu'ici de mettre fin à l'occupation israélienne et d'établir un État indépendant.
Elle complique aussi énormément les négociations de paix, qui, tant pour les Palestiniens que pour le "Quartet" (États-Unis, Union européenne, Nations Unies et Russie), reposaient sur la définition de Gaza et de la Cisjordanie en tant que seul et même territoire.
Ironie du sort, c'est par la victoire d'Israël lors de la guerre de 1967 que ces territoires furent réunis après 19 années de séparation.
Auparavant, l'Égypte régnait sur Gaza et la Jordanie avait annexé la Cisjordanie.
Sous l'occupation israélienne, puis avec l'établissement de l'Autorité palestinienne en 1994, les territoires sont restés séparés géographiquement, mais pas politiquement.
La prise de Gaza par le Hamas a -- au moins pour l'instant -- mis un terme à cette unification politique.
Le président palestinien Mahmoud Abbas a désormais posé ses conditions au dialogue.
Le Hamas doit retirer ses hommes en armes de tous les bâtiments de sécurité qu'ils occupent, rendre le pouvoir à l'autorité légitime et présenter ses excuses au peuple palestinien.
Bien que la division interne nuise à l'intérêt national palestinien, il est peu probable, au milieu des accusations mutuelles et des provocations, que le dialogue entre le Fatah et le Hamas reprenne rapidement.
Mais ce que craignent surtout Abbas et le Fatah, c'est que le conflit avec le Hamas s'étende à la Cisjordanie.
Pour éviter un tel scénario, Abbas a interdit tous les groupes militaires et toutes les milices en Cisjordanie, y compris les Brigades des martyres d'al-Aqsa, rattachées au Fatah.
Abbas a réussi à convaincre Israël d'accorder l'amnistie à de nombreux fugitifs du Fatah en Cisjordanie, qui vont rejoindre son appareil sécuritaire.
Il a également demandé à Israël d'autoriser la Brigade Badr de l'OLP, actuellement stationnée en Jordanie, à entrer en Cisjordanie.
Cela fournirait à Abbas un supplément militaire de 3 000 hommes bien équipés et entraînés.
Suite à l'intervention du roi Abdallah II de Jordanie, Israël semble avoir donné son accord au transfert de la Brigade Badr avec toutes ses armes et munitions.
Si le Fatah doit devenir un partenaire viable pour la paix et regagner le soutien de sa base, il lui faudra se réformer et en finir avec la corruption généralisée qui a mis à mal sa réputation.
Abbas doit également partager le pouvoir avec de jeunes leaders plus disciplinés.
Israël peut l'aider en relâchant Marouane Barghouti, éminent dirigeant du Fatah, qui purge actuellement cinq peines d'incarcération à perpétuité dans une prison israélienne.
En raison de la grande influence de Barghouti sur les milices du Fatah, sa libération pourrait aider Abbas et la direction discréditée du parti, tout en encourageant l'émergence d'une nouvelle génération de dirigeants au Fatah.
Israël est divisée sur la méthode à employer avec le Hamas, ce qui compliquera également le départ des négociations de paix.
Certains Israéliens pensent qu'il faudrait encourager le Hamas à rétablir l'ordre à Gaza et à donner des garanties à ses voisins.
Si le Hamas peut rétablir l'ordre à Gaza, prévenir les violences contre Israël et arrêter les attaques de missiles contre les villes et villages israéliens, cela pourrait éviter une intervention militaire israélienne.
Toutefois, la pensée dominante en Israël est que le Hamas constitue une menace directe, qu'il est réticent à stopper les attaques sur Israël.
Pour l'État juif, les combats de l'été dernier contre le Hezbollah au Liban ont prouvé qu'il y a un risque à autoriser le renforcement d'islamistes radicaux aux frontières d'Israël.
Tôt ou tard, il est probable qu'Israël se confronte militairement au Hamas, peut-être même en réoccupant Gaza.
Les pays voisins pourraient prendre part aux négociations de paix notamment parce que l'Égypte et la Jordanie craignent que le Hamas puisse commencer à soutenir activement les groupes d'opposition islamistes présents sur leur propre territoire.
En outre, l'Égypte, la Jordanie et l'Arabie Saoudite -- les trois principaux régimes sunnites -- sont conscients que Gaza pourrait servir de base à l'Iran chiite, leur ennemi régional non arabe.
Leur crainte est fondée sur le soutien apporté par l'Iran aux groupes islamistes -- sunnites et chiites -- en Irak, au Liban et en Palestine, ainsi que sur les relations qu'il entretient avec la Syrie.
Si le schisme Hamas-Fatah entraîne une nouvelle partition territoriale, les aspirations nationales palestiniennes connaîtront leur plus grave recul de ces cinquante dernières années.
Bien que l'écrasante majorité des Palestiniens soit contre l'usage de la force pour régler cette lutte de pouvoir, beaucoup apprécient le changement opéré à Gaza, où le Hamas a débarrassé les rues des milices armées et restauré la loi et l'ordre.
Les Palestiniens sont confrontés à un problème épineux.
Quelle que soit l'action qui sera prise contre le Hamas, elle nuira au projet national palestinien.
Une maison divisée ne peut pas tenir, avait dit Abraham Lincoln.
Une Palestine divisée ne pourra pas plus assurer son indépendance.
Le Hamas s'en prend aux radicaux
Comme la bande de Gaza est contrôlée depuis plus deux ans par le Hamas, cette zone est considérée comme nettement plus traditionnelle et conservatrice que la Cisjordanie.
Pourtant, dans les cercles politiques à Gaza, le Hamas est un groupe islamique modéré à l'opposé de l'extrémisme du type Al-Qaïda.
Or, des groupuscules extrémistes islamiques remportent de plus en plus de soutien à Gaza, ce que le Hamas a remarqué.
L'affrontement dans la mosquée montre que le Hamas n'aura aucune pitié pour eux.
Voilà des années que divers groupes extrémistes salafistes opèrent à Gaza.
Les salafistes, dont le nom provient de l'expression arabe « Salaf al-Salih » [pieux ancêtres], insistent pour un retour à ce qu'ils considèrent comme les pratiques puristes des origines.
Le Hamas a, dans le passé, coopéré avec quelques salafistes, présumant qu'ils soutiendraient leurs dirigeants.
L'armée de l'Islam a rejoint le raid consistant à l'enlèvement du soldat israélien Gilad Shalit en juin 2006.
Ce groupe est également responsable de l'enlèvement à Gaza en 2007 d'Alan Johnston, correspondant de la BBC libéré plus tard suite à des négociations menées par le Hamas.
Les « Soldats des partisans de Dieu » est l'un des nombreux groupuscules radicaux inspirés d'Al-Qaïda apparus dans la bande de Gaza ces derniers mois. Il a retenu l'attention du public pour la première fois en juin en revendiquant une attaque à cheval manquée sur des israéliens depuis Gaza.
Son site Internet présente des photos, une langue et de la musique semblables à celles d'Al-Qaïda et d'autres groupes djihadistes.
Ce groupe s'est récemment déclaré en faveur des leaders d'Al-Qaïda Osama ben Laden et Ayman al-Zawahiri.
Les Soldats des partisans de Dieu exige une pratique pure de l'islam pour la bande de Gaza dans sa totalité, y compris l'application de la Sharia et le rejet de la démocratie.
En effet, la confrontation à la mosquée est survenue suite à une déclaration d'un califat islamique à Gaza, rejetant clairement l'autorité du Hamas.
A Gaza, de plus en plus de jeunes hommes se radicalisent.
Le style vestimentaire pakistanais est monnaie courante, tout comme le port des cheveux longs supposé rappeler le style du prophète Mohammed.
Parallèlement, la violence à l'encontre des « hors la loi » augmente. Des cafés Internet ont été bombardés, des institutions affiliées au christianisme mises à feu, des écoles étrangères et des mariages attaqués.
Le Hamas et les salafistes de Gaza affiliés à Al-Qaïda diffèrent fondamentalement sur le plan idéologique.
En tant que parti dirigeant, le Hamas a insisté sur le fait que le peuple palestinien est son unique souci, et non une révolution islamique mondiale.
Le Hamas n'a d'ailleurs pas imposé d'« émirat » islamique dans la bande de Gaza.
Les groupes salafistes en revanche semblent de plus en plus influencés par la montée des groupes extrémistes radicaux tels qu'Al-Qaïda au Pakistan, en Irak et en Afghanistan.
A l'inverse des mouvements salafistes traditionnels, éloignés de la politique, les jeunes voient dans l'activisme et la violence, le meilleur moyen d'atteindre leurs objectifs.
Mais l'échec du Hamas à établir et mettre en œuvre une loi islamique n'est pas la seule pilule qui ne passe pas.
L'une des raisons de l'attrait croissant de ces groupes est le cessez-le-feu immédiat entre Israël et le Hamas. Le Hamas a par conséquent été accusé de « force de résistance neutralisée ».
La fermeture de la frontière avec Israël et le blocus remontant à plus de deux ans ont provoqué une hausse de la pauvreté, du chômage et du désespoir, ce qui fait que les jeunes hommes s'intéressent de plus en plus au djihad mondial qui rejoint justement Gaza.
Il se trouve en effet que la confrontation entre le Hamas et les groupes salafistes survient au moment où Israël allègue que des dizaines de terroristes étrangers sont entrés à Gaza par le Désert du Sinaï pour rejoindre le chaos sous-jacent.
La répression du Hamas traduit donc son souhait de continuer à contrôler le conflit avec Israël.
La menace que l'extrémisme salafiste fait peser sur Gaza est loin de disparaître.
Les salafistes ont menacé de se venger contre le Hamas, notamment les brigades de sécurité qui ont mené la contre-attaque à la mosquée.
Un nouveau groupuscule salafiste nommé « la Brigade des épées de la vertu » a déclaré son allégeance aux Soldats des partisans de Dieu et a mis en garde les Gazaouis de rester à l'écart des bâtiments gouvernementaux, des quartiers généraux de sécurité, des mosquées fréquentées par les dirigeants du Hamas et autres bâtiments officiels.
Le groupe réfléchit désormais à ces cibles légitimes.
Au vu de la centaine de tunnels reliant la bande de Gaza et le Sinaï, il est très difficile de contrôler les mouvement d'armes et de munitions, tout comme les combattants étrangers.
Le combat du Hamas contre ces radicaux, qui revendiquent des attentats suicide à la bombe et ont tué six policiers du Hamas lors de l'affrontement dans la mosquée n'est qu'un début.
Les résidents craignent que Gaza deviennent un second Irak, avec des attaques à la bombe et des tueries en masse au quotidien.
Le Hamas usera de tous les moyens nécessaires pour protéger son pouvoir et anéantir les groupes djihadistes qui pullulent à Gaza en ce moment.
Ce faisant, le Hamas espère obtenir la légitimité internationale qu'il a longtemps recherché.
Combattre la maladie maintenant
Il est possible pour un enfant qui naîtrait dans dix ans de vivre dans un monde où le sida, la tuberculose et la malaria seraient sur le déclin.
Mais cela pourra uniquement se produire avec un investissement considérable.
Aujourd'hui.
Sinon, le sombre tableau d'aujourd'hui ne fera que s'aggraver.
Chaque jour, ces maladies tuent 16 000 personnes, dévastant des communautés entières et renvoyant certains pays au plus profond de la pauvreté.
Seul un enjeu plus élevé peut renverser la situation.
Les succès récents du Brésil dans la lutte contre le sida, au Mozambique contre la malaria et en Chine contre la tuberculose montrent ce qui peut être accompli sur une échelle mondiale avec des ressources plus importantes.
Il existe de nouvelles manières de diriger l'aide là où elle est le plus nécessaire.
Un instrument essentiel de cette lutte est le Fonds mondial de la lutte contre le sida, la tuberculose et la malaria.
Créé en 2002 sous la forme d'un partenariat entre les gouvernements et la société civile, le Fonds mondial est unique en ce qu'il entreprend pour acheminer l'aide nécessaire.
Répondant à de véritables besoins sur le terrain, les projets sont conçus et mis en place par ceux qui en bénéficient et leurs procédures et opérations sont transparentes.
Dernièrement, on parle beaucoup d'intensifier les efforts pour l'éradication de la pauvreté.
Avant le sommet du G8 en Écosse en juillet, une coalition d'organisations non gouvernementales a lancé « l'Appel mondial pour une action contre la pauvreté » et notre hôte britannique a fait de l'Afrique sa priorité absolue.
S'appuyant sur cet élan, les campagnes pour le soulagement de la dette, la réforme des échanges commerciaux et l'accroissement de l'aide aux pays pauvres y ont gagné en prise.
Pourtant, alors que les promesses d'augmenter l'aide au développement se sont envolées, le financement à court terme reste tristement inadéquat.
Toute stratégie pour relever les niveaux de vie doit inclure des mesures d'urgence pour s'attaquer au sida, à la tuberculose et à la malaria.
Enrayer l'avance de ce trio infernal de maladies est l'étape principale dans cette lutte mondiale contre la pauvreté.
Si elles ne sont pas contrôlées, ces maladies saboteront non seulement les économies nationales mais mettront également en danger la paix et la sécurité.
Les enseignants et le personnel soignant meurent, la police et les forces de sécurité sont durement touchées et 14 millions d'enfants ont déjà perdu leurs parents à cause du sida.
Nous risquons maintenant de ne pas atteindre les objectifs de développement du Millenium déterminés par les Nations unies visant à renverser les progrès du sida, de la tuberculose et de la malaria pour 2015.Cet échec handicapera d'autant les possibilités d'atteindre les autres objectifs du Millenium dans la lutte contre la pauvreté.
Une réponse globale doit être apportée au sida, à la tuberculose et à la malaria.
Agir maintenant permettra de dépenser moins dans le long terme.
Des investissements dans la prévention, le traitement et la recherche efficaces en 2005 et 2006 épargneront des millions de vie, réduiront l'impact économique de ces maladies dans les pays pauvres et supprimeront le besoin de dépenser toujours plus pour circonvenir ces maladies chroniques à l'avenir.
Le Fonds mondial joue un rôle important dans cet environnement de financement, offrant près de 66 % de tous les fonds externes disponibles dans la lutte contre la tuberculose, 45 % des fonds engagés dans la lutte contre la malaria et 20 % des fonds engagés dans le soutien externe de la lutte contre le sida.
Depuis la création du Fonds mondial il y a trois ans, ses réussites sont impressionnantes : l'octroi de 310 subvention pour un montant de 3,1 milliards USD dans 127 pays et des dépenses qui s'élèvent à 920 millions USD depuis 2002.
Malgré la portée de sa mission, sa bureaucratie est minime, ce qui lui permet d'être flexible dans sa réponse à des besoins en pleine évolution.
Le Fonds mondial n'est pas parfait : comme pour toutes les nouvelles organisations, il traverse des difficultés de croissance. Pourtant, les questions de politiques d'approvisionnement, les compromis entre efficacité et propriété et l'équilibre entre les organisations gouvernementales et les organisations non gouvernementales comme partenaires dans les mises en œuvre sont étudiées via les systèmes de gouvernance ouverte et universelle.
Si le Fonds doit se montrer à la hauteur de son potentiel, il a besoin de 2,3 milliards USD pour poursuivre son œuvre de manière efficace en 2005.
La première de deux conférences de renflouement pour le Fonds mondial se tiendra cette semaine à Stockholm, avec pour but de garantir des promesses financières pour couvrir les engagements de subventions pour 2006-2007, tout comme pour combler le fossé creusé cette année. Les donateurs ont toujours prêché l'importance d'un mode de financement tel que le Fonds mondial : basé sur les besoins, s'appuyant sur les possibilités locales et faisant la promotion de la coordination des dons.
Ils ont maintenant une chance de pratiquer ce qu'ils prêchent.
Avec toutes les batailles qu'il reste à mener dans la lutte contre le sida, la tuberculose et la malaria, il serait véritablement honteux de ne pas profiter de cette chance.
Inégalité de l'Europe en matière d'investissement de défense
Les débats portant sur la politique étrangère entre l'Europe, la France en particulier, et les Etats-Unis grandissent et pas seulement au sujet du massacre des Israéliens et des Palestiniens et la conduite de la guerre contre le terrorisme.
Mais les critiques de l'Europe, quelle que soit leur justesse, ne seront pas prises au sérieux par les Etats-Unis tant que le Continent continuera de s'en prendre abondamment aux défenses américaines, ce qu'elle fait depuis un demi-siècle.
Dans un monde belliqueux, être crédible dans l'arène internationale requiert une capacité militaire estimable et une technologie militaire de pointe.
L'Europe manque des deux.
L'irritation de l'Amérique envers certains de ses alliés européens - le Royaume-Uni de Tony Blair constituant la seule exception visible - est compréhensible.
Dans l'année fiscale en cours, les Etats-Unis dépenseront 50 milliards de dollars supplémentaires en matière de défense en portant leur facture de défense globale à 379 milliards de dollars, soit plus de 3 % du PNB.
Cette somme est en fait minime par rapport à celles dépensées après la Deuxième guerre mondiale.
Au moment de la Guerre du Golfe en 1991, les dépenses américaines en matière de défense se montaient à 4,8 % du PNB ; elles étaient bien plus élevées dans les années 1950 et 1960.
L'engagement de l'Europe en matière de défense raconte une autre histoire.
Les dépenses de défense se montent à 1,6 % du PNB en Allemagne, à 2 % en Italie et à 1,5 % en Espagne ; seuls la France et le Royaume-Uni atteignent les 3 %.
Mais limiter le débat à l'engagement de défense au pourcentage de PNB dépensé dans l'armée est insuffisant car il existe des économies d'échelle dans les dépenses de défense.
On s'attendrait donc à ce que les plus petits pays dépensent proportionnellement plus en matière de défense que les plus grands.
Au lieu de cela, l'Amérique à elle seule dépense aujourd'hui plus que la plupart de ses alliés de l'OTAN réunis, et il est probable que les dépenses de défense aux Etats-Unis augmentent encore plus dans les années à venir.
La sécurité et l'influence mondiale ne sont pas les seuls avantages obtenus grâce aux dépenses militaires.
Environ 10 à 15 % des dépenses militaires américaines financent une recherche de base et permettent ainsi d'accroître fortement la recherche et le développement de pointe de l'Amérique.
L'Internet, basé sur les réflexions et les dépenses engagées dans les années 1940, ainsi que la puce en silicium, développée dans les années 1970, sont tous les deux des produits de la recherche financée par le Pentagone.
La guerre en Afghanistan, qui s'est révélée réellement révolutionnaire dans la façon dont elle a été menée, démontre comment une nouvelle technologie d'information et de communication peut engendrer le succès avec un nombre minimal d'hommes sur le terrain et des pertes minimales.
Les Russes se sont battus pendant dix dures années sur le même terrain en Afghanistan.
Parce qu'ils manquaient d'une technologie comparable, ils ont perdu des dizaines de milliers d'hommes et ont finalement été battus.
Au début de la campagne afghane, beaucoup d'" experts " militaires craignaient que les Etats-Unis ne doivent affronter un destin semblable.
Comme ils se trompaient !
L'Europe a du retard sur les Etats-Unis en matière de R & D et son avarice en matière de défense contribue puissamment à une " inégalité en matière d'investissement " de pointe qui ne fait que croître.
Les données relatives aux brevets attestent de l'avantage de l'Amérique : à la fin des années 1990, 56 % de tous les brevets mondiaux dans les domaines de pointe étaient accordés aux demandeurs américains, contre seulement 11 % aux demandeurs européens.
Le lien entre la R & D et la croissance est trop évident pour douter du fait que les économies stagnantes de l'Europe résultent directement du retard européen en matière d'innovation - et que ceci, à son tour, peut refléter l'absence de dépenses militaires cruciales destinées à attirer les investissements dans la recherche et le développement.
Le débat en cours entre l'Europe et les Etats-Unis quant au choix de l'avion de transport militaire - qui servira à déployer les nouvelles forces de réaction rapide européennes fortes de 600 000 hommes - est symptomatique des problèmes de l'Europe.
L'Amérique souhaiterait que l'Europe opte pour un avion construit par Boeing et Lockheed Martin.
L'Europe est divisée : certains pays, notamment l'Italie, soutiennent les Etats-Unis ; d'autres, notamment la France et l'Allemagne, témoignent en faveur d'un avion européen construit par Airbus dans le cadre d'un projet de 15 milliards de dollars financé dans le secteur public.
C'est une question sur laquelle l'Europe doit tenir tête aux Etats-Unis.
L'Union européenne doit financer le projet Airbus et s'assurer qu'une partie importante de l'argent va dans la R & D afin d'encourager la croissance d'une industrie qui compose l'une des quelques réussites de pointe européennes.
Mais qui doit avancer les fonds nécessaires à ce lourd investissement ?
Au cours des dernières semaines, les ministres de la défense européens ont suggéré que les augmentations des dépenses militaires soient exclues des contraintes budgétaires imposées par le pacte de stabilité de l'euro.
L'idée qu'une soudaine augmentation des dépenses militaires dans un monde (avec espoir temporairement) belliqueux soit amortie avec quelques déficits correspond à une politique économique solide, mais seulement si le reste du budget reste " maigre ".
Tel est le cas en Amérique où personne ne s'inquiète réellement si l'accroissement des dépenses militaires crée un déficit temporaire.
Pas en Europe.
Une augmentation des dépenses militaires, conjointement avec l'application du pacte de stabilité, doit entraîner une baisse du budget qui n'est pas consacré à la défense : les salaires des fonctionnaires et un Etat providence qui a largement dépassé l'objectif de soutien des revenus des pauvres doivent nécessairement être fortement réduits.
Pendant un demi-siècle, l'Europe s'est reposée sur les Etats-Unis en matière de sécurité tout en dépensant son propre argent dans un Etat providence onéreux.
Une telle situation ne peut plus continuer - du moins pas si l'Union européenne envisage sérieusement de jouer un rôle de premier plan dans le monde.
Ce n'est pas un message agréable à entendre, mais ce qui s'est produit à New York et à Washington le 11 septembre et ce qui se produit actuellement au Moyen-Orient ne sont pas non plus agréables : l'Europe doit réaliser que des changements sont nécessaires et agir en conséquence.
Argentine : ouverture ou arrêt complet
« J'ai une mission politique de grande importance », déclara Eduardo Amadeo lors de sa nomination au poste d'ambassadeur argentin à Washington, « je dois expliquer notre transition ».
Mais les explications diplomatiques ne sont pas ce dont l'Argentine a le plus besoin.
Elle n'a guère besoin de dépenser ses faibles revenus en gestes diplomatiques de peu de valeur, pas quand le pays a besoin d'une institution entièrement consacrée à aider les hommes d'affaires argentins à vendre leurs biens de production à l'étranger.
En fait, les sommes que l'Argentine consacre à sa diplomatie représentent ce que la petit Irlande consacre au son agence de développement des exportations, une institution que l'Argentine ne s'est jamais souciée de mettre en place.
Au lieu de s'adresser à ses collègues diplomates, l'ambassadeur argentin auprès des États-Unis devraient s'adresser aux supermarchés américains pour convaincre leurs directeurs d'acheter les produits argentins et organiser des rencontres avec les hommes d'affaires des PME argentines.
Il n'est pas censé faire double emploi avec le président argentin et le ministre argentin des affaires étrangères, capables de mener à bien leur tâche.
La diplomatie de l'exportation est importante, mais la promotion des exportations, la visite des magasins et les rencontres avec les acheteurs sont encore plus cruciales.
Les magasins d'alimentation d'Europe sont pleins de produits importés d'Israël mais quelles quantités de boeuf ou d'autres produits argentins peut-on voir aux étalages ?
L'économie argentine s'est considérablement ouverte ces dernières années, en dépit des taux de change élevés qui mirent en difficulté les exportations.
Le total des exportations a doublé de 1991 à 2001, passant de 12 à 25 milliards de dollars, les exportations industrielles s'étant accrues de 3 à 8 milliards.
Mais les chiffres resteront faibles.
En fait, l'Argentine reste étrangement fermée pour une économie de cette taille.
Les exportations ne dépassent pas les 10% de son PIB, et les biens de consommation ne représentent qu'un tiers du total de ses exportations.
Le Brésil, un pays huit fois plus grand, exporte 12% de sa production économique, et 57% des exports brésiliens sont des biens de consommations.
Les exports chiliens représentent près de 30% de la production industrielle chilienne.
Certains petits pays européens s'approchent des 50%.
Il est donc peu étonnant donc que la crise que traverse l'Argentine aujourd'hui soit si dure : la part de son économie qui peut générer des revenus d'exportation nécessaire au remboursement de la dette est trop faible.
Quand un pays en arrive a avoir besoin de la totalité de ses exportations pour rembourser sa dette nationale et que l'importance de ses exportations reste fixe, il ne lui reste aucune ressource pour payer ses importations.
Ainsi les importations cessent et son économie s'arrête.
Plus une économie est ouverte, plus elle peut facilement éviter ce piège.
Bien sûr, tous les pays finissent toujours par surmonter les crises.
Reste à savoir comment.
L'Argentine fait maintenant face à un choix tant économique que politique.
La voie du développement qu'elle choisira au sortir de sa crise déterminera son futur pour bien des années à venir.
Il est ainsi surprenant que cette question ne soit pas au coeur des débats politiques de la campagne pour l'élection présidentielle actuellement en cours.
Il y a deux solutions au marasme actuel.
L'une relève des anciens modèles : un redressement des salaires et la reprise de la consommation.
Vu de la perspective désespérante de la crise actuelle, ce modèle ressemble à un rêve.
Mais s'il est mis en place, dans trois à cinq ans, l'Argentine ressemblera au pays que nous avons toujours connu : une économie relativement fermée qui reste dangereusement vulnérable aux chocs économiques externes.
L'alternative reste de capitaliser sur la chance exceptionnelle offerte par la dévaluation du peso mise en place cette année, permettant ainsi que son avance concurrentielle dure suffisamment longtemps pour basculer les ressources vers le secteur des exportations.
Bien sûr, cela entraînera une baisse des salaires et de la consommation puisque l'accroissement des revenus en peso sera utilisé au refinancement des investissements nécessaires à l'expansion du secteur des exportations.
Cela mènera à créer de nouvelles entreprises et à redessiner celles qui existent déjà pour les rendre compatibles avec les besoins en exportations.
Mais les gains de productivité à l'exportation de l'industrie d'exportation mieux développée finiront par permettre l'accroissement des salaires et de la consommation.
En bref, l'économie argentine doit s'ouvrir ou risquer un arrêt complet.
Les politiques économiques peuvent aider son ouverture.
En gelant les coûts des services publics, le gouvernement gagnerait sur deux fronts : l'inflation resterait sous son contrôle et l'altération des primes à l'exportation basculerait les investissements du secteur domestique vers les sociétés d'exportations.
Si l'ancien modèle permet des résultats plus rapides, les implications à long termes restent ternes car l'économie reste sanglée dans les mêmes problèmes qu'elle affronte depuis des décennies.
L'alternative reste de regarder plus en avant et de se demander quel type de pays l'Argentine veut transmettre aux générations futures.
La réponse ne doit pas faire de doute, si ce n'est dans l'esprit des politiciens qui ne parviennent à l'appréhender parce qu'ils refusent de voir au-delà de l'élection présidentielle proche.
Ainsi ne serait-il pas dû au hasard que l'Argentine ait le nombre d'étudiants en psychologie le plus élevé au monde.
Au sein d'un pays fermé et introverti, le besoin en psychologues est grand.
Le ministre de l'éducation rendrait un grand service à son pays si elle réallouait les ressources dévolues à l'enseignement de la psychologie vers des cursus destinés à former les promoteurs de l'exportation nécessaires.
Enseigner aux jeunes les fondements du marketing et les envoyer dans les ambassades argentines : ils feront des merveilles contrairement aux discours à deux sous de son excellence l'ambassadeur Amadeo aux soirées de Washington.
Le Big bang de la liberté économique
Pourquoi est-il si difficile de mettre en place la dérégulation dont toute économie a besoin pour devenir plus compétitive ?
Pourquoi tant de gouvernements essaient-ils de réaliser cet objectif et pourquoi la plupart d'entre eux n'y parviennent pas ?
Tous leurs concitoyens bénéficient de la compétitivité du marché des biens et des services, mais le plus souvent, le large consensus nécessaire au soutien de politiques de compétitivité ne se matérialise pas, le soutien politique n'existe simplement pas.
Pourquoi ?
Cette question est importante non seulement pour les économies de transition et les pays aux marchés émergeants, mais pour les pays développés également--en fait, presque partout sauf pour les États-Unis et le Royaume-Uni, qui se sont lancés depuis longtemps dans un processus de libéralisation économique radical et d'une portée considérable.
La Nouvelle-Zélande et l'Irlande ont suivi, et leurs économies se sont fortement développées depuis.
Le manque de compétitivité est habituellement le fait d'une régulation excessive.
Les services des taxis des capitales européennes sont chers car le nombre de licence est strictement contrôlé.
En bloquant l'accès au marché, les propriétaires de licence ne font face qu'à une faible concurrence pour limiter l'augmentation des prix de leurs services, et les officiels qui accordent ces licences se trouvent bien placés pour récolter des voix ou des pots-de-vin.
En bref, la régulation a tendance à dénaturer tout encouragement, stimulant ainsi ce que les économistes appellent un comportement à la recherche de rentes : le chauffeur de taxi et le fonctionnaire qui octroie les licences reçoivent des primes imméritées (rentes) simplement parce qu'ils peuvent exploiter leur position d'initié, et non pas parce qu'ils sont plus productifs.
Les notaires représentent un autre exemple de ce phénomène : dans de nombreux pays, les notaires demandent des honoraires très élevés pour des services quasiment inutiles.
Les honoraires sont élevés parce que les notaires contrôlent eux-mêmes l'accès à leur profession.
Sans réglementation gouvernementale (y compris des règlements imposant que le public achète ces services inutiles), les notaires ne seraient pas en mesure de réclamer ces rentes.
Les exemples des avantages de la libéralisation sont nombreux.
Le marché des taxis en Irlande a été libéralisé, et le prix des courses y est bon marché.
Pendant les mois qui suivirent la dérégulation des compagnies aériennes américaines, le coût d'un vol de cinq heures entre New York et Los Angeles coûtait bien moins cher que la demie-heure de vol entre Zurich et Francfort.
De tels écarts se retrouvaient entre le coût d'un appel téléphonique d'une côte à l'autre des États-Unis et d'un appel interurbain passé en France.
Tandis que les régulations créent des rentes immérités pour des minorités surprotégées (les chauffeurs de taxi, les notaires, les pilotes de ligne, les salariés des compagnies de téléphone ou d'électricité), la dérégulation réduit ces rentes et les redistribuent dans le public en général.
Mais du fait que ces minorités surprotégées jouissent d'accès privilégiés au monde politique, il n'est pas surprenant de constater que la libéralisation incite à tant d'opposition féroce et efficace.
Les services publics sont une excellente illustration de ce fait.
À chaque fois qu'un gouvernement tente de libéraliser l'industrie de l'électricité, les syndicats et les entreprises s'unissent pour s'y opposer.
Salariés et encadrement s'opposent à la dérégulation car s'ouvrir à la concurrence ferait disparaître leurs rentes imméritées.
Les salaires des employés de l'électricité sont élevés précisément parce qu'ils se sont appropriés une part de ces rentes crées sur un marché fermé à la concurrence.
Est-il possible d'affaiblir cette opposition ?
Que se passerait-il si un gouvernement essayait, au lieu de libéraliser l'industrie de l'électricité uniquement, de créer un big bang économique en essayant de libéraliser la plupart des marchés en même temps ?
Un processus analogue du « tout ou rien » fut mis en place aux États-Unis dans les années 1980 pour la fermeture des bases militaires devenues inutiles.
Depuis 1945, il n'y avait eu aucune fermeture de base.
Même si le Pentagone souhait lui-même en fermer de nombreuses pour utiliser les fonds ailleurs, aucune mesure ne parvenait à passer le vote du Congrès parce que les bases militaires sont considérées comme « pain béni », les faveurs de leur électorat aidant les hommes politiques à se faire réélire, et selon une vieille et vénérable loi informelle, aucun élu ne vote jamais contre le « pain béni » dans le district d'un collègue.
Pourtant, une proposition pour fermer de nombreuses bases fut acceptée avec une majorité écrasante quand les leaders du Congrès se mirent enfin d'accord pour présenter une liste unique de bases à fermer. Cette liste pouvait être acceptée ou rejetée, sans aucune possibilité d'être modifiée.
Le bon sens l'a emporté sur le pain béni.
La cause de la libéralisation économique serait grandement avancée si des stratégies similaires étaient adoptées.
Par exemple, les électriciens comprendraient qu'en tant que consommateurs ils gagneraient à payer moins cher certains biens de consommation, ce qui compenserait leurs pertes de rentes au sein de leur compagnie.
L'approche « big bang » permet d'intéresser les employés à la libéralisation et de ce fait faciliter la mise en place des politiques de dérégulation.
La dérégulation des marchés a d'autres avantages supplémentaires : elle facilite la libéralisation du marché du travail, ainsi que le montrent les études de l'OCDE quant à la forte corrélation positive dans plusieurs pays entre le degré de concurrence sur le marché des biens de consommation et l'importance des régulations du marché de l'emploi dans l'accroissement du pouvoir des salariés dans leurs négociations avec leurs entreprises.
Les négociations portent principalement sur la distribution des excédents de rentes entre l'entreprise et ses employés.
Dans une industrie concurrentielle où l'excédent de rente n'existe pas, il reste peu à négocier.
Dans certains cas, cependant, la régulation a des effets opposés : elle permet de maintenir artificiellement le prix des services publics à de faibles niveaux plutôt qu'à des niveaux trop élevés.
Ceci est vrai pour les chemins de fer du continent européen, puisqu'ils sont financés par les gouvernements.
Ici encore, gagner la bataille de la dérégulation nécessite de convaincre les consommateurs qu'ils y trouveront leur compte.
Le prix des déplacements en train seront plus chers mais les impôts baisseront puisque seuls ceux qui utilisent vraiment le train payeront les coûts plutôt que les contribuables qui ne voyagent pas en train.
La dérégulation des compagnies aériennes et de bus créera également une saine concurrence avec les chemins de fer et permettra d'empêcher la hausse excessive des prix.
Toute dérégulation décousue est condamnée à échouer.
Pour parvenir à créer un soutien politique suffisant pour mettre en place certaines réformes pouvant survivre à l'opposition des intérêts privés requiert une tentative de dérégulation globale de l'économie et non pas dans certains secteurs industriels seulement, les uns après les autres.
La seule façon d'éliminer les subventions inefficaces et non productives accordées à certaines minorités reste de mettre en place des réductions d'impôts pour tous.
Le défi universitaire de l'Europe
Les systèmes universitaires des Etats-Unis et de l'Europe Continentale ne pourraient pas être plus différents.
Lequel fonctionne le mieux ?
La réponse est claire : celui de l'Amérique, et de loin.
Les universités européennes sont généralement basées sur trois principes peu judicieux:
Ce système est soi-disant plus égalitaire que le système d'enseignement supérieur de l'Amérique, que beaucoup d'Européens méprisent comme étant un système élitiste.
En réalité, le système européen engendre généralement moins de chercheurs et des étudiants plus médiocres, particulièrement au niveau du doctorat, et il est probablement moins égalitaire que le système américain.
Le fait que les contributaires couvrent les coûts d'une éducation universitaire est en effet redistributif, mais dans la mauvaise direction : les bénéficiaires sont le plus souvent les enfants des familles européennes aisées.
Même en observant une attitude généreuse, le système est, au mieux, neutre dans la mesure où la redistribution est concernée, car les plus riches paient plus d'impôts et utilisent plus de services universitaires.
En plus de favoriser les « nantis » de l'Europe, ce système rend quasiment impossible pour les universités privées autofinancées de survivre.
En fait, ceci est probablement la vraie motivation du système universitaire public gratuit européen : maintenir le monopole de l'Etat sur l'enseignement supérieur.
Mais considérons plutôt le système américain : les étudiants paient pour leur éducation et, avec une partie des frais que ces étudiants versent, les universités financent les bourses pour les étudiants méritants mais pauvres.
Un tel système est au moins aussi « équitable » que le modèle européen et probablement plus qu'un système dans lequel les contribuables paient pour tous, y compris les riches.
En effet, une recherche récente comparant l'éducation aux Etats-Unis et en Italie démontre que les revenus familiaux jouent un rôle plus important pour déterminer la réussite d'un étudiant (mesurée à l'aune de son salaire) dans l'Italie « égalitaire » qu'ils ne le sont dans l'Amérique « élitiste ».
Mais la concurrence est aussi importante que le financement pour déterminer la qualité d'une université car la concurrence augmente le mérite du produit.
Ceci est vrai dans le système américain, dans lequel les universités publiques et privées coexistent harmonieusement.
L'université de Californie à Berkeley est publique.
L'université de Stanford, à une heure de route en descendant vers la côte, est privée.
Toutes les deux figurent parmi les meilleures universités d'Amérique.
La concurrence entre elles fonctionne car elle implique une lutte pour attirer les meilleurs étudiants et l'offre de bourses aux étudiants pauvres méritants.
Par contraste, le contrôle de la centralisation et de la bureaucratisation en Europe sur les universités n'engendre que médiocrité.
Les nominations dans les universités européennes sont souvent régies par des processus bureautiques complexes qui impliquent un nombre infini de « juges » choisis dans tout le pays.
Ce processus est soi-disant destiné à « garantir » que les meilleurs enseignants sont nommés.
En réalité, ces juges permettent aux initiés de nommer leurs amis plutôt que de favoriser la qualité de la recherche et de l'enseignement pour déterminer les enseignants qui sont engagés.
Certains pays, comme la France, sont en train de changer leurs systèmes en nommant quelques universitaires d'autres pays dans des comités de recrutement et d'avancement.
Tandis que cette action constitue à l'évidence un pas dans la bonne direction, elle ne produira que peu de résultats.
Les meilleures universités américaines font fonctionner leurs processus de recrutement en interne, en s'appuyant uniquement sur les étrangers pour obtenir des opinions d'expert sur la qualité de la recherche d'un professeur candidat.
Les meilleures nominations sont le fait de la menace selon laquelle des professeurs médiocres ne permettront pas d'attirer de bons étudiants et d'importantes subventions de recherche.
La tendance de l'Europe à égaliser le salaire et le traitement des professeurs et des chercheurs réduit également l'incitation à s'engager dans une recherche et un enseignement de qualité.
Si le seul facteur d'augmentation du salaire d'un professeur est le passage du temps, pourquoi ferait-il l'effort supplémentaire d'exceller ?
Bien entendu, l'amour de la recherche et de l'enseignement explique pourquoi beaucoup de personnes rejoignent les facultés universitaires en premier lieu, mais pourquoi ne pas fournir à ces nobles sentiments une main secourable avec des incitations financières appropriées ?
Les bas salaires font souvent partie d'un marché implicite : en échange d'un salaire médiocre, les administrateurs universitaires ferment les yeux sur la paresse de l'enseignement et de la recherche.
De plus, si les salaires sont bas, comment les doyens des universités peuvent-ils empêcher leurs professeurs de quitter le pays pour une activité plus lucrative ?
Ils obtiennent simplement un enseignement médiocre, une recherche de mauvaise qualité et des professeurs absents.
Les universités américaines utilisent souvent des incitations financières agressives et un traitement différentiel des professeurs afin de récompenser un enseignement et une recherche de qualité.
De plus, la nature privée des contrats entre une université américaine et ses professeurs crée une concurrence saine pour le talent et un marché flexible et efficace pour les savants.
Par conséquent, il n'est pas rare qu'un jeune professeur brillant et productif en Amérique gagne autant, si ce n'est plus, que des collègues plus âgés et moins productifs.
En Europe, les jeunes chercheurs prometteurs luttent et doivent compléter leur enseignement et leur recherche par un autre travail alors que les professeurs établis gagnent de bons salaires.
Dans ces conditions, cela ne surprendra personne que les universités américaines de nos jours soient de plus en plus composées de plusieurs des meilleurs savants européens.
Il est surprenant, face à cet exode des cerveaux, que la pression des professeurs universitaires en Europe pour bloquer les réformes soit si forte.
Une Europe âgée et vieillissante
Quand le Secrétaire à la défense américain Donald Rumsfeld évoqua dernièrement « la vieille Europe », il avait raison, mais pas comme il le pensait.
L'Europe est en effet vieille, et vieillissante.
À travers tout le continent, les enfants se font de plus en plus rares.
Le taux de natalité (le nombre d'enfants par femme dans la population) est tombé à 1,2 % en Allemagne et en Italie.
Le taux de natalité est encore plus bas en Espagne : c'est le plus faible d'Europe.
La société espagnole est une société jeune encore, mais une société sans enfant est condamnée.
En revanche, le taux de natalité des États-Unis est de 2,4 et celui du Royaume-Uni est de 2,1.
Ces différences sont extraordinaires, particulièrement à la lumière des politiques moins généreuses de congés de maternité qui ont cours aux États-Unis et au Royaume-Uni par rapport à l'Europe continentale.
La France se distingue sur le continent avec un taux de natalité de 1,8, ce qui est probablement le résultat d'années de politiques familiales généreuses envers les familles nombreuses.
L'immigration est également un facteur important dans ces différences.
Les taux de natalité plus élevés aux États-Unis, au Royaume-Uni et en France reflètent le grand nombre de familles immigrées de chaque pays.
Le taux de natalité chez les immigrés est habituellement plus élevé que chez les populations européennes ou nord-américaines.
Pourtant, l'augmentation du nombre de travailleurs immigrés n'augmente pas nécessairement le taux de natalité.
En Allemagne par exemple, il existe un grand nombre de travailleurs invités, mais ils sont peu à s'établir là avec leur famille, la plupart laisse leurs enfants dans leur pays d'origine.
La population vieillissante contribue au manque de performance économique européen.
Les vieux ne travaillent pas, et un groupe de plus en plus petit (les jeunes en voie de disparition) est imposé pour les soutenir.
En retour, les taux d'imposition élevés requis pour soutenir les populations âgées découragent les jeunes de travailler, créant un cercle vicieux : une imposition en constante augmentation pour une force de travail en voie de disparition, des taux de croissance en baisse et toujours moins de ressources disponibles pour soutenir ceux qui prennent leur retraite à 60 ans et vivent au delà de leur 90ème anniversaire.
Les effets de ce phénomène sont en partie compensés par le fait que, faisant moins d'enfants, plus de femmes entrent sur le marché du travail.
Toutefois, ces femmes prennent également leur retraite (souvent à un plus jeune âge que les hommes), venant ainsi s'ajouter à l'armée des retraités qui ne sont pas « financés ».
En comparaison avec les États-Unis, en dépit du taux de natalité élevé, la participation des femmes au marché du travail est également en hausse.
En fait, la participation des femmes au marché du travail est plus élevée aux États-Unis que dans l'Union Européenne (70 % contre 60 %).
Les taux d'épargne chez les personnes âgées en Europe indiquent qu'elles s'inquiètent du nombre déclinant de travailleurs qui peuvent être imposés pour les soutenir.
Si l'on examine le cas de l'Allemagne, n'importe quel classique économique montrerait, selon le fameux modèle du « cycle de vie », que les jeunes épargnent pour leur retraite tandis que les retraités dépensent ce qu'ils ont accumulé.
Mais en Allemagne les données semblent suggérer un fait étonnant : les retraités économisent jusqu'à leur dernier jour.
Ce sont les jeunes qui consomment.
Le fait le plus étonnant n'est pas le niveau d'épargne des retraités, mais son évolution dans le temps.
Des études allemandes récentes ont mis en évidence une petite augmentation dans leur taux d'épargne.
Pourquoi est-ce que les retraités épargneraient ?
La raison la plus probable est que nombre d'entre eux réalisent maintenant qu'ils vont vivre bien plus longtemps qu'ils ne le croyaient, passant un tiers de leur vie en retraite, et que l'État pourrait bien ne plus tenir ses promesses.
Il est peu probable, même si ce n'est pas impossible, que les retraites souffrent de cessation de paiement, mais il est probable que les remboursements des soins de santé en pâtissent alors que c'est, et de loin, le service le plus important pour les retraités.
Quand on a compris que l'on va probablement vivre au-delà de notre 80ème anniversaire et bien plus, et que la qualité des services publics de santé se dégrade, on économise plus pour pouvoir subvenir à ses propres besoins.
Alors pourquoi les Européens ont-ils de moins en moins d'enfants ?
Les temps de loisirs augmentent même pour ceux qui ont un travail, offrant ainsi de plus grandes possibilités pour élever des enfants.
Le nombre d'heures de travail en Europe est tombé de 1 713 heures par an en 1980 à environ 1 576 aujourd'hui, et ce sont les Allemands qui ont le moins d'heures de travail.
Une des explications les plus souvent mentionnées est le manque de structures telles que la prise en charge publique des enfants pour les mères qui les élèvent.
Dans ces conditions, pourquoi le taux de natalité des États-Unis est-il supérieur à celui de nombreux pays européens où l'aide publique aux femmes enceintes est plus importante ?
Le déclin des taux de natalité en Europe s'explique vraisemblablement par les coûts élevés du logement et les imperfections des marchés de prêt.
Il est plus facile pour un jeune couple américain d'emprunter pour acheter une maison que pour un jeune couple européen.
Le marché de la location est aussi plus flexible aux États-Unis.
Ainsi, un autre cercle dangereusement vicieux semble être à l'oeuvre : les taux d'imposition élevés découragent le travail, et du fait que moins d'emplois sont créés, la natalité n'est pas encouragée.
Mais avec moins d'enfants, des taux d'imposition élevés sont requis pour soutenir l'armée grandissante des retraités.
Gunther Grass a intitulé l'un de ses romans « Les Enfants par la tête ou les Allemands se meurent ».
Il ignorait combien son imagination aurait raison trois décennies plus tard.
La réforme tardive de l'Europe
La guerre et son coût démesuré, un dollar en baisse, un déficit commercial et budgétaire en hausse, les chicanes qui ont mis à mal des entreprises comme Enron et WorldCom, l'éclatement de la bulle haute technologie : le capitalisme à l'américaine est à la fois mis à rude épreuve et tombé en disgrâce.
Qu'ils soient de gauche ou de droite, un grand nombre d'intellectuels européens estiment que le jeu capitaliste tel qu'il est joué par les Etats-Unis est tombé en désuétude.
La recherche de nouveaux modèles a activement commencé.
Faisant la part belle à la rhétorique et alimentée par une vague d'anti-américanisme, cette recherche ne présente pas beaucoup de faits concrets.
Les récits de malversation d'entreprise abondent bien évidemment aux Etats-Unis.
Mais c'est chose aisée que de passer rapidement de scandales d'entreprise individuels à des conclusions générales sur la soi-disant corruption de l'économie américaine.
Un examen approfondi de la croissance de la productivité (rendement par heure travaillée) aux Etats-Unis et en Europe montre que le capitalisme américain demeure aussi indispensable que jamais.
Suivant une courbe de croissance annuelle d'à peine 1,6 % depuis le début des années 1970, la croissance annuelle de la productivité américaine dans le secteur d'activité non agricole est passée à une moyenne de 2,6 % depuis 1995, sans montrer de signe de ralentissement.
En 2002, la productivité s'est accrue de 4,8 %, un résultat extraordinaire car la productivité chute généralement lors de ralentissements économiques.
Considérons maintenant l'Europe.
La croissance annuelle de la productivité s'est en fait ralentie au cours de la deuxième moitié des années 1990, en passant de 2,5 % à tout juste 1,3 % à l'heure actuelle.
Cet écart de productivité est souvent attribué à la « Nouvelle Economie » qui a émergé à la fin des années 1990.
Il est vrai que plusieurs nouvelles technologies ont été développées et d'abord appliquées aux Etats-Unis.
Mais la technologie se répand rapidement : les mêmes programmes Windows ou SAP sont disponibles dans tous les pays, dont l'Europe.
Il doit donc exister d'autres différences.
Deux candidats se détachent du lot : les attitudes envers le travail et la gouvernance d'entreprise.
Six pays de l'OCDE obtiennent de meilleurs résultats que l'Amérique en termes de rendement par heure travaillée : la Norvège, la Belgique, la France, l'Irlande, les Pays-Bas et l'Allemagne.
Mais le classement change si vous prenez le rendement par tête (une mesure plus fiable de la santé économique d'un pays) : les Etats-Unis se retrouvent en première position, et la France et l'Allemagne chutent à la 16
La raison pour laquelle il est préférable d'examiner le rendement par personne plutôt que le rendement par heure travaillée est simple : ce qui détermine la santé d'une nation est le nombre d'heures travaillées par personne et le nombre de personnes qui travaillent.
C'est à ce niveau que les Etats-Unis devancent l'Europe : un nombre moins élevé de personnes travaillent en Europe par rapport aux Etats-Unis et les personnes qui travaillent en Europe ne travaillent pas autant.
Chaque travailleur américain travaille 1 800 heures par an, contre 1 500 en France et 1 400 en Allemagne.
Les Européens travaillent moins, entre autres, parce qu'ils paient plus d'impôts, et des impôts élevés sont indispensables pour aider ceux qui ne travaillent pas... un cercle vicieux évident.
Mais des causes plus profondes sont à l'oeuvre.
Les Européens sont sans doute parfaitement heureux de travailler moins et d'avoir davantage de temps libre (plus de vacances pendant qu'ils travaillent et moins d'années travaillées).
C'est un choix légitime, mais une fois ce choix pris, les Européens devraient cesser de chercher des boucs émissaires pour justifier le ralentissement de la croissance.
Car la source du problème n'est pas la Banque Centrale Européenne, pas plus que le Pacte de Stabilité.
L'Europe se développe moins parce qu'elle travaille moins et cela n'a rien d'étonnant si plusieurs soi-disant « pays en voie de développement » rattraperont bientôt l'Europe en termes de revenus par tête.
La disponibilité des nouvelles technologies est une condition nécessaire, mais en aucun cas suffisante, pour accroître le niveau de vie d'un pays car ce pays doit également intégrer des entreprises qui sont en mesure de les utiliser.

Au début du 20
La nouvelle économie a fait son apparition après une décennie de transformations profondes au sein des entreprises américaines.
Au cours des années 1980, une vague d'acquisitions par emprunt a transformé la culture américaine d'entreprise, rendant manifestement les patrons plus réceptifs aux innovations technologiques.
Ce n'était pas le cas en Europe, où les intérêts des employés d'une entreprise et des syndicats passaient souvent avant ceux de ses actionnaires.
En effet, dans un journal européen, les articles reçus par courrier électronique étaient saisis par des typographes : la technologie requise pour les transférer électroniquement était disponible, à l'inverse des règles de travail pour l'appliquer.
Les syndicats ne sont pas les seuls coupables.
Un grand nombre d'entreprises européennes disposent de structures de propriété complexes, avec des actionnaires majoritaires dont les intérêts s'opposent souvent à ceux de la société, ce qui ne constitue absolument pas le meilleur moyen de prendre des décisions sensées.
Ceci est particulièrement vrai dans la finance et dans le secteur bancaire.
Quelles que soient les histoires invraisemblables qui circulent sur les entreprises dans les banques américaines, il n'existe pratiquement plus aucune banque d'investissement européenne et l'Allemagne envisage sérieusement de fonder une « bad bank » appartenant à l'Etat afin de sortir d'affaire ses géants bancaires tout-puissants.
Si l'Europe souhaite travailler moins, elle doit être incroyablement productive lorsqu'elle travaille si elle souhaite se maintenir au niveau des Américains qui travaillent d'arrache-pied.
C'est la raison pour laquelle les Européens devraient espérer que la vague de restructuration et de réforme d'entreprise, jugée par plusieurs comme inévitable après la création du marché unique, commence à monter en crête sur le Continent et change le mode de gestion des entreprisescréation d'un me innévitable n et de réforme d'entreprise, que plusieurs érfondes au sein des entreprises américaines..
Il ne faut pas intervenir sur le taux de change de l'euro
En janvier 1999, lors du passage à l'euro, le cours de la monnaie européenne était de 1,17 dollar, ce qui semblait refléter le niveau des prix de part et d'autre de l'Atlantique.
Depuis, son taux de change a connu un mouvement de yoyo.
Il est maintenant pratiquement au même niveau que lors de son introduction.
Dans ces conditions, pourquoi le monde des affaires déclare-t-il qu'un euro fort est annonciateur de catastrophes ?
Blâmer l'euro est un moyen simple de détourner l'attention de la véritable cause du malaise économique de l'Europe : malgré une productivité horaire relativement élevée, la productivité par travailleur est extrêmement faible.
Cela s'explique par le très faible nombre d'heures effectuées par les Européens.
Il faut clarifier un certain nombre de points fondamentaux relatifs au taux de change de l'euro vis-à-vis du dollar. Le débat public sur cette question est faussé par des idées erronées souvent émises dans un but stratégique :
Personne ne peut expliquer les variations à court terme (entre un jour et six mois) d'un taux de change.
Un célèbre article paru dans une revue spécialisée il y a une vingtaine d'années montrait qu'une prévision au hasard des variations à court terme d'un taux de change se rapproche davantage de la réalité que celles issues de modèles mathématiques sophistiqués.
Cette conclusion reste vraie aujourd'hui.
Personne ne peut expliquer clairement pourquoi l'euro est tombé à 0,8 dollar au bout de 18 mois et personne ne peut prédire quand il va remonter.
Certains observateurs attribuent son "haut" niveau actuel (et par conséquent la faible croissance en Europe) à une politique monétaire rigide de la Banque centrale européenne (BCE).
Mais si ce sont des taux d'intérêt élevés qui sont la cause de la montée de l'euro, pourquoi le dollar s'est-il apprécié quand la Réserve fédérale américaine menait une politique agressive de baisse des taux ?
Il vaut mieux se méfier des commentateurs qui prétendent expliquer pourquoi un taux de change varie comme il le fait.
Les exportateurs qui pensent que leurs difficultés sont dues au niveau actuel de l'euro devraient voir la réalité en face ; au taux actuel, les prix des deux côtés de l'Atlantique sont voisins.
Si les exportations d'une entreprise ne sont rentables qu'avec un euro à 0,8 ou 0,9 dollar, il vaut mieux qu'elle se dépêche d'augmenter sa productivité pour assurer sa survie si la monnaie européenne se cale aux environs de 1,17 dollar.
Durant des années, l'Allemagne et le Japon ont été les plus grands exportateurs de la planète, ceci alors que le yen et le deutsche mark étaient parmi les devises les plus fortes.
C'est grâce à l'innovation et à une productivité élevée et non pas à cause d'une monnaie faible que les marchandises allemandes et japonaises ont inondé le monde.
La zone euro est aussi propice au commerce international que les USA.
Ces derniers ont connu un boom économique dans les années 1990 avec un dollar fort.
Ce qui était vrai pour le deutsche mark en Allemagne et reste vrai pour le yen au Japon, vaut aussi pour les USA. Historiquement, le dollar fort n'a pas freiné la croissance américaine.
Les pays de l'Union européenne exportant près de 50% de leur production, ils considérent le taux de change comme un paramètre important.
Mais la plupart de ces exportations se font au sein de la zone euro et ne sont donc pas affectées par le taux de change de la monnaie européenne.
Les exportations hors zone euro ne représentent que 15 ou 16% de la production et ce pourcentage baissera lorsque la Suède et la Grande-Bretagne adopteront l'euro (si elles l'adoptent).
Les commentateurs, les responsables politiques et les dirigeants d'entreprise devraient donc arrêter de réclamer à cors et à cris que la BCE réagisse face à un euro fort.
L'intervention des banques centrales sur le marché des changes a un rôle déstabilisateur et se révèle contre-productif.
La BCE a eu raison de ne pas réagir lorsque l'euro est tombé à 0,8 dollar de même qu'elle a raison de ne pas bouger aujourd'hui quand il approche de 1,2 dollar.
La plupart des économistes pensent que banques centrales ne devraient s'intéresser qu'à l'inflation, autrement dit, diminuer les taux d'intérêt seulement en cas de ralentissement économique ou de baisse de l'inflation. C'est exactement ce que fait la BCE.
Les Européens devraient moins se préoccuper du taux de change de l'euro et davantage de leurs véritables problèmes : une productivité insuffisante, des marchés trop rigides, une liberté budgétaire entravée à l'excès par le Pacte de stabilité et un système de retraite au bord du gouffre.
Les responsables de la politique économique ont déjà suffisamment de pain sur la planche, ils devraient laisser au marché des changes le soin de réguler les variations de l'euro face au dollar.
Les dangers du pouvoir gris
Avec un soutien bipartisan rare, l'administration Bush propose une augmentation substantielle des retraites pour les personnes âgées.
Les réformes proposées risquent de coûter aux contribuables américains bien plus que la réduction d'impôts massive de 2001 appliquée par le président Bush car elles impliquent une redistribution considérable de la population jeune vers ses aînés.
Mais tandis que de nombreux observateurs ont mis en exergue les risques associés aux réductions d'impôts prônées par Bush et les déficits béants qui se sont ensuivis, seuls quelques-uns d'entre eux semblaient inquiets quant aux déficits supplémentaires qui résulteront de ce don aux personnes âgées.
La situation en Amérique ne fait que souligner l'immense pouvoir exercé par les personnes âgées dans nos sociétés.
Des actions similaires sont entreprises sur l'ensemble du territoire européen, où la générosité des régimes de retraite sponsorisés par l'Etat est devenue non viable, mais il est pratiquement impossible de réformer le système, politiquement parlant.
La montée du pouvoir politique des retraités s'explique par plusieurs facteurs.
Premièrement, dans chaque société industrielle, les gens vivent plus longtemps et ont moins d'enfants.
Associez cela aux régimes de retraite généreux élaborés dans les années 1970, lorsque les enfants du baby-boom d'après-guerre allaient arriver sur le marché du travail et lorsque l'état providence semblait ne connaître aucune contrainte budgétaire, et vous obtenez un droit que personne ne souhaite abolir.
Deuxièmement, les personnes âgées sont en moyenne plus riches que les jeunes, simplement parce qu'ils ont vécu plus longtemps et qu'ils ont donc eu davantage de temps pour accumuler des biens.
Etant plus riches, ils peuvent offrir un soutien financier plus conséquent aux partis et aux politiciens qui défendront leurs intérêts que les jeunes, qui choisiront de militer pour une réforme des retraites.
Enfin, les retraités ont du temps à consacrer à l'organisation d'activités politiques dans leur propre intérêt.
Deux exemples : plusieurs dirigeants de syndicats en Italie sont des retraités et les retraités sont les membres les plus nombreux du syndicat le plus puissant et le plus militant d'Italie, le CGIL.
Aux Etats-Unis, les retraités ont tendance à voter davantage que les jeunes.
Prenons l'exemple suivant qui illustre le mieux leur pouvoir en Amérique : c'est un petit nombre d'hommes et de femmes du troisième âge en Floride qui a déterminé la dernière élection présidentielle !
Cette situation crée un cercle vicieux : plus le pouvoir politique des retraités et des anciens travailleurs augmente, plus la pression exercée sur le gouvernement afin qu'il diminue la durée de travail et augmente le montant des retraites est forte.
En conséquence de quoi, le nombre d'électeurs qui dépendent des retraites augmente, ainsi que le pouvoir des retraités.
Dans un article récent, Vincenzo Galasso et Paola Profeta, de l'université de Bocconi à Milan, montrent qu'en Italie, ce lien constitue désormais le principal obstacle à une réforme des retraites.
Au fur et à mesure que le temps passe, le soutien politique à une réforme s'amenuise, au moins jusqu'à l'explosion du système.
Autre aspect rendant les réformes difficiles, les systèmes de retraite publics redistribuent les revenus des riches vers les pauvres car ces systèmes sont généralement structurés sous forme de systèmes de « bénéfices définis ».
Les retraites sont liées aux salaires en fin de carrière plutôt qu'à la contribution réelle du travailleur sur l'ensemble de sa carrière.
La portée de cette redistribution varie d'un pays à l'autre, mais elle existe dans l'OCDE, y compris aux Etats-Unis.
Au sein de la coalition anti-réforme, les partisans de la redistribution, généralement des jeunes de gauche, rejoignent souvent les retraités et les anciens travailleurs.
Le mouvement politique qui en résulte est extrêmement puissant et couvre les partis de gauche et de droite, jeunes et personnes âgées confondus.
Les vrais perdants sont les jeunes travailleurs et les générations futures qui devront faire face aux charges fiscales élevées nécessaires pour distribuer aux retraités les bénéfices qu'on leur a promis.
La redistribution implicite dans plusieurs systèmes de retraite est souvent loin d'être « propre ».
De nombreux systèmes comportent des privilèges motivés politiquement uniquement destinés à de puissants groupes de pression.
Au Brésil, le système de retraite des travailleurs du secteur privé est légèrement excédentaire, mais celui des fonctionnaires est extrêmement déficitaire (il équivaut à 4,5 % du PNB du Brésil).
Les fonctionnaires français ont récemment paralysé le pays face à une réforme dont le principal objectif est plutôt modeste : aligner leur retraite sur celle du secteur privé.
Il est encourageant de constater que le gouvernement français a finalement eu gain de cause et intéressant de connaître la méthode employée en ce sens.
Après des semaines de grèves paralysantes, le gouvernement du premier ministre Raffarin a entamé une campagne pour convaincre les électeurs que la réforme se contentait de supprimer les privilèges d'une petite minorité.
Cette affirmation a emporté l'adhésion des électeurs et les fonctionnaires se sont retrouvés isolés.
Bien entendu, étant donné les risques politiques, les gouvernements ne doivent pas attendre la confrontation avec les retraités.
Les représentants gouvernementaux doivent prendre deux mesures évidentes en ce sens.
Premièrement, augmenter l'âge de la retraite.
Cette solution comporte deux principaux avantages : elle diminue le coût global du système en abaissant le nombre des retraités tout en affaiblissant les électeurs opposés à la réforme.
Deuxièmement, éliminer la redistribution implicite dans le système.
En effet, toute redistribution doit être transparente et avoir lieu via l'imposition et les transferts non liés aux retraites.
Bien entendu, il est facile de comprendre pourquoi ce n'est pas le cas : lorsque la redistribution est transparente, ceux qui payent pour cette transparence peuvent se plaindre.
Lorsque la redistribution a lieu via le système de retraite, elle est payée par les générations à naître et qui ne peuvent donc pas faire entendre leur voix lors des prochaines élections.
Entre-temps, nous ne pouvons que suggérer à nos grands-parents d'indemniser leurs petits-enfants en leur laissant des legs généreux avec leurs charges fiscales élevées.
Réformer l'Europe à la base
Jetez un coup d'oeil sur l'histoire de l'Europe au cours des 25 dernières années et vous verrez qu'entre la fin des années 1970 et le début des années 1990, le continent a été en proie à une instabilité macro-économique, un taux de chômage élevé, des marchés excessivement réglementés (y compris, ce qui est plus important, les marchés financiers), des monopoles non réglementés et des industries inefficaces détenues par l'Etat.
L'Europe a accompli des progrès considérables au cours de la dernière décennie en rétablissant la stabilité macro-économique, mais elle n'a pas eu autant de succès dans la promulgation de réformes au niveau micro-économique qui sont essentielles à la déréglementation des marchés et à l'amélioration de leur efficacité.
Pourquoi ?
Les pays de l'Europe Centrale et de l'Europe de l'Est doivent-ils en tirer une leçon au moment même où ils se préparent à rejoindre l'UE ?
Une inflation forte et une dette publique grandissante ont généré un sentiment de « crise » au début des années 1990 dans certains pays de l'UE : lorsqu'une maison brûle, les coûts encourus si vous n'agissez pas sont bien trop élevés pour que vous continuiez à rester là à la regarder brûler et à ne rien faire.
Par exemple, il a fallu la crise des taux de change de 1992 pour que les dirigeants italiens réalisent qu'ils devaient prendre des mesures pour résoudre l'anarchie financière publique du pays.
La peur d'être exclus de l'euro a fait le reste en créant un consensus politique en faveur de mesures adaptées et nécessaires.
Aujourd'hui, la maison économique de l'Europe n'est plus en feu.
Il est ainsi devenu plus difficile de ne pas tenir compte des intérêts spéciaux dans la course à la libéralisation des marchés et l'amélioration de l'efficience économique.
Par exemple, en juin dernier, la France a connu une série de grèves et de manifestations dans la lignée de celles de 1968 qui ont seulement entraîné l'application de réformes mineures sur les systèmes de retraite : l'élimination de quelques privilèges spéciaux détenus par les fonctionnaires.
Dans un sens, de telles réformes pusillanimes résultent du fait que l'Europe est devenue un endroit plus « normal ».
L'Europe ne pouvait tout simplement pas se permettre d'assister à l'échec du projet sur l'euro et ses dirigeants ont donc fait le nécessaire en ce sens.
Mais personne, semble-t-il, ne pourra empêcher ce riche continent de connaître une croissance lente, un taux de chômage élevé et des marchés inefficaces.
Aucune « crise » n'est associée à ce choix, juste un lent déclin.
Les critères de convergence de Maastricht qui ont entraîné la création de l'euro ont été appliqués avec succès car ils étaient imposés par un accord multinational et étaient contrôlés au niveau multinational.
Plus important, le « châtiment » pour non conformité à ces critères était clair, draconien et certain : l'exclusion de l'union monétaire.
Rien de tout cela ne menace l'Europe aujourd'hui.
Ces états membres ont-ils pour cela moins de petites motivations précieuses pour poursuivre le processus de réforme ?
Mais un processus tel que le processus de Maastricht peut-il permettre la mise en application d'une réforme structurale ?
Dans un sens, ce processus est déjà à l'oeuvre.
Un mécanisme s'est souvent révélé efficace pour contrôler les puissants intérêts spéciaux existant au sein de chaque état de l'UE et donc pour appliquer des réformes structurales : les actions de la Commission Européenne.
La France a décidé d'autoriser une ouverture relativement minime de son marché national de l'électricité à compter de la veille du début des procédures officielles engagées contre la France par la Cour Européenne de Justice pour violation d'une directive de l'UE.
L'Italie a mis fin à 70 années d'implication active de l'Etat dans l'industrie grâce à la détermination des Commissaires européens à la concurrence, Karel van Miert et son successeur, Mario Monti.
Manifestement, la Commission Européenne peut jouer un rôle positif seulement si elle adopte une position ferme en faveur de la libéralisation des marchés et ne tombe pas dans le piège de la seule coordination de la réglementation nationale sur l'ensemble du territoire de l'Union.
La réglementation des marchés a besoin d'être coordonnée, mais elle a également besoin d'être éliminée dans de nombreux cas.
Prenons les marchés financiers européens qui offrent une méthode alternative pour sortir de l'impasse réformiste.
Dans la vieille Europe dotée de marchés financiers morcelés, la demande du chancelier Gerhard Schroeder pour que Mannesmann reste une entreprise allemande face à l'offre publique d'achat de Vodaphone équivalait à exécuter un ordre donné par les actionnaires de l'entreprise, en majorité allemands.
En fin de compte, ce genre d'action ne peut plus être entrepris dans un monde au sein duquel les entreprises européennes sont soumises au contrôle des investisseurs internationaux.
Les marchés financiers européens étaient, et sont toujours, dans une certaine mesure, dominés par quelques grandes banques.
Lors du lancement de l'euro, les banques européennes représentaient environ 80 % du financement total des entreprises, par rapport à 30 % aux Etats-Unis.
Les banques sont souvent moins préparées à financer une idée sans doute lumineuse, mais risquée.
En tant que prêteurs, ils sont également moins efficaces pour contrôler les entreprises que ne le sont leurs actionnaires.
Avant l'avènement de l'euro, les marchés locaux étaient réduits et illiquides.
Le développement de marchés financiers modernes extrêmement liquides a constitué l'un des principaux avantages de l'euro : en quelques années, par exemple, les prêts bancaires en Allemagne ont chuté de 74 % à 32 % des fonds totaux contractés par de grandes entreprises allemandes.
En Italie, la part de prêts bancaires sous forme de pourcentage des fonds totaux contractés par de grandes entreprises italiennes est passée de 75 % à 50 %, la différence étant essentiellement due à des émissions d'obligations de société.
La leçon que devront retenir les nouveaux pays membres de l'Est est claire : une fois que vous avez rejoint l'Union, la pression réformiste extérieure se relâche : l'élan vers la réforme doit venir du pays même.
Les réformes visant à déréglementer les marchés financiers doivent être prioritaires.
Le secteur des services américain est en pleine renaissance et se détache clairement de ce que l'on peut voir en Europe.
Grâce à la politique européenne sévère en matière de concurrence, l'Europe a fait du chemin pour rendre son secteur industriel plus viable.
Dans le domaine des services, par comparaison, la dérégulation fut bien plus limitée, probablement du fait que les services sont bien moins exposés à la concurrence internationale, ce qui implique que des règlements obtus sont plus faciles à préserver.
Il en ressort qu'en Europe, contrairement aux États-Unis, l'augmentation de la demande de services produit des rentes plus élevées plutôt qu'un supplément d'emplois.
Prenons le cas très simple des licences de taxi : si leur nombre est fixé et que le public intensifie sa fréquentation, on observe alors au mieux une augmentation de la demande de Mercedes puissantes, voiture de prédilection des chauffeurs de taxi, sans création d'emploi.
En d'autres termes, un bon indicateur de l'état de l'économie américaine reste le nombre de personnes qui s'occupe de vos achats à la caisse du supermarché.
Dans de nombreux pays européens, il vaut mieux considérer la qualité de l'autoradio du taxi qui vous prend en charge.
La flexibilité du marché du travail américain dans le domaine des services est particulièrement remarquable.
Lors des récessions et des booms économiques, on peut ressentir le changement dans la qualité et le nombre des serveurs dans les restaurants, dans la taille des équipes de personnel dans les magasins, dans la disponibilité des services de nettoyage.
Dans les 90 rugissantes, il était quasi impossible de recruter du personnel de restauration qualifié pour remplir les postes à pourvoir.
Pendant les période de stagnation économique sous le gouvernement Bush, ces travaileurs étaient pléthore.
En Europe, on ne voit tout simplement pas de telles différences : les serveurs, les plongeurs et les cuisiniers bénéficient tous de la sécurité de l'emploi.
Une partie du problème vient du fait que les emplois temporaires ou à court terme en Europe sont associés à une mauvaise connotation.
Le fait qu'entraver l'emploi à court terme piège également l'emploi à long terme est souvent oublié.
De telles perceptions reflètent une différence profonde.
En général, les salariés et l'encadrement en Europe continentale fonctionnent encore sur les fondements traditionnels d'antagonismes de classe qui émergèrent à l'origine avec la montée de l'industrialisation au 19
Aux États-Unis, de tels sentiments sont bien moins ancrés dans la culture.
Les penseurs américains marquants du 19
Sous la surface toutefois, les choses commencent à bouger en Europe.
Subrepticement, les autorités en charge de la concurrence au sein de la Commission européenne se montrent plus tenaces avec les services professionnels (il suffit d'examiner, par exemple, la déclaration intitulée « Competition Policy and Liberal Professions », Politique concurrentielle et professions libérales, disponible sur le site web de la Commission européenne, à l'adresse suivante : www.europa.eu.int ).
Une fois les cartels douillets d'avocats et de comptables rappelés à l'ordre, d'autres industries du secteur des services semblent destinées à s'ouvrir à une concurrence plus importante et de ce fait à devenir d'importants moteurs de création d'emploi.
Malgré les syndicats européens, les emplois temporaires sont de mieux en mieux acceptés.
Le moteur de la création d'emploi à l'américaine via l'industrie des services pourrait bien avoir pris le chemin de l'Europe.
Le train du capitalisme sifflera trois fois
Le schadenfreude provoqué par Enron en Europe n'a plus de raison d'être.
Les scandales de l'année dernière (Vivendi) et de cette année (Parmalat) y ont veillé.
L'Europe, comme l'Amérique (et, en fait, comme le monde capitaliste dans son ensemble), doivent désormais se durcir en exigeant que les patrons qui ont pillés leurs sociétés soient poursuivis et punis.
Les procureurs américains penchés sur le cas d'Enron ont réalisé des progrès considérables dernièrement, en amenant des escrocs d'envergure comme Andrew Fastow à plaider coupables et à témoigner contre leurs anciens collaborateurs.
Mr. Fastow ira en prison pendant dix ans et les personnes contre lesquelles il témoigne auront une peine bien plus longue.
Les procureurs italiens mettent beaucoup d'ardeur à obtenir une peine similaire pour les patrons qui ont pillé Parmalat.
Mais ces affaires vont bien au-delà du vol de sociétés et de trahison d'actionnaires.
L'enjeu est de taille : la perception de l'équité du marché et le soutien politique universel aux politiques orientées vers le marché.
Les économies capitalistes engendrent des inégalités, et souvent conséquentes.
Jusqu'à un certain stade, et dans la mesure où les différences de revenus sont dues aux différences de capacité, d'effort, d'investissement dans l'éducation, etc., ces inégalités sont nécessaires afin d'inciter les entreprises à investir, travailler, innover et croître.
Mais plus la réputation d'équité du marché est ternie, plus les citoyens moyens considèreront les différences de revenus comme le fruit de la corruption, d'activités illicites, de liens avec des fonctionnaires, etc.
Cette situation intensifiera la demande pour une réglementation plus stricte et pour une implication massive du gouvernement dans l'économie afin de contrôler davantage les capitalistes indisciplinés et indignes de confiance.
En outre, plus cette accumulation de richesses est taxée « d'injuste » (suite à la corruption et à l'illégalité), plus la pression pour une imposition sévère des « biens mal acquis » s'intensifiera.
Si l'une de ces mesures populistes rend les marchés plus justes et améliore leur fonctionnement, nous n'aurions qu'à nous en louer.
Malheureusement, une telle réaction face à des hommes d'affaires corrompus instaure un cercle vicieux : une réglementation plus importante risquerait alors de déboucher sur une corruption plus vaste afin de pallier à cette réglementation ; des impôts plus élevés sur la richesse inciteraient à rechercher des échappatoires fiscales supplémentaires, ce qui aurait pour résultat de corrompre davantage le système.
Malheureusement, à l'heure actuelle, des éléments aussi disparates que des cadres au salaire élevé, les scandales d'Enron et de Parmalat, des fusions et des acquisitions contestées, la volatilité des actions, les « obligations pourries » et les bulles spéculatives des prix sont tous classés dans la même catégorie, sous l'appellation narquoise de « capitalisme cowboy ».
Les Européens sont tout particulièrement enclins à considérer les choses sous cet angle et à voir un gouvernement puissant jouer le rôle de shérif afin d'empêcher les cowboys de terroriser la ville en tirant des coups de feu.
Cette situation est tout particulièrement inquiétante car l'Europe a récemment commencé à déréglementer ses marchés.
Alors que le soutien politique à ces changements reste toujours incertain, l'Europe court le risque que les opposants à ces changements utilisent Parmalat, Enron, Vivendi et d'autres cas similaires comme excuse pour inverser le processus.
Dans un grand nombre de pays en voie de développement, des régulateurs faibles et une perception répandue de la corruption constituent souvent un obstacle à la mise en place de réformes favorisant le marché ; la gauche (populiste ou autre) peut soutenir, de manière tout à fait crédible, que le capitalisme est « corrompu » et que le gouvernement doit donc le prendre sous son aile.
Ceci explique en grande partie pourquoi le capitalisme de marché a eu tant de mal à s'implanter dans le monde en voie de développement.
Si les capitalistes sont corrompus, comment convaincre un pauvre paysan de croire en l'économie de marché ?
Il votera plutôt pour des politiques populistes.
En conséquence de quoi, la corruption est plus étendue et la croissance se ralentit dans une sorte de piège de la pauvreté « créé par la corruption ».
Le scandale de Parmalat peut avoir porté un coup au capitalisme, mais en Italie, on espère qu'il sonnera le glas d'un système économique traditionnellement basé davantage sur les « liens » entre les groupes privés (et entre ces groupes et le secteur public) que sur les marchés compétitifs.
Pour l'Italie, la solution évidente consiste à renforcer les institutions d'investigation et financières du pays et à améliorer la conception des organismes de réglementation, et tout particulièrement la qualité de leur personnel.
Ce changement ne se fera pas du jour au lendemain, et entre-temps, la demande pour une réglementation renforcée risque de donner naissance à une structure lourde, inefficace et, à la fin, d'entraver, plutôt que de rectifier, les tendances du marché.
Le contrôle doit être renforcé dans les entreprises italiennes par la présence d'un nombre suffisant de directeurs non cadres dans les conseils d'administration des entreprises publiques.
Un directeur indépendant unique aurait probablement suffi à dévoiler les manigances des patrons dans le scandale de Parmalat : aucun ne siégeait à son conseil d'administration.
De même, il serait utile que les cabinets comptables soient sélectionnés par les actionnaires minoritaires ou que leur salaire soit fonction des résultats de la bourse plutôt que versé par une entreprise.
Dans le cas présent, même les récents changements survenus aux Etats-Unis n'ont pas suffi : ils empêchent les cabinets comptables de jouer également le rôle de cabinets conseils auprès d'une entreprise, mais ils laissent encore la décision de la rémunération des comptables entre les mains de l'entreprise, incitant ainsi par esprit de contradiction les entreprises à mystifier la communication de l'information financière.
Il est surprenant que tandis que le gouvernement italien est occupé à revoir la structure de réglementation et de contrôle des institutions financières et des marchés financiers de son pays, aucune mention n'est faite des directeurs et des cabinets comptables indépendants.
Après tout, les bons shérifs ont besoin de réunir un groupe de citoyens actifs qui feront office de jurés.
Pour être sans tache, le capitalisme a besoin du même type d'engagement universel.
Racisme et protection sociale
Deux facteurs d'ordre démographique minent les systèmes de protection sociale d'Europe continentale.
L'un est le vieillissement de la population et l'autre l'arrivée massive d'immigrés en provenance des pays qui vont accéder prochainement à l'Union européenne et d'ailleurs.
Dans un livre récent intitulé Fighting Poverty in the US and Europe: A World of Difference que j'ai écrit avec Edward Glaeser, j'évoque la question de savoir pourquoi le système de protection sociale est tellement plus généreux en Europe qu'aux USA.
Une cause majeure en est l'hétérogénéité raciale bien plus importante aux USA qu'en Europe de l'Ouest.
Ainsi, selon une enquête de la World Value Survey [un réseau qui réalise des études sur les changements politiques et socioculturels au niveau international], 60% des Américains pensent que les pauvres sont paresseux, contre seulement 26% des Européens.
Il n'est pas surprenant que ceux qui croient cela soient peu favorables à la redistribution des revenus et à la protection sociale. Les enquêtes montrent qu'aux USA, les personnes hostiles aux minorités sont généralement aussi hostiles à la redistribution des richesses et ont moins de compassion envers les plus démunis.
Il est plus facile à la classe moyenne blanche de considérer que les pauvres ne méritent pas l'aide gouvernementale s'ils les perçoivent comme " différents ".
Pour le dire brutalement, il est plus facile d'être indifférent si l'on pense que les pauvres se trouvent essentiellement parmi les Noirs.
C'est plus difficile en Norvège où riches et pauvres sont blancs et le plus souvent grands et blonds.
Beaucoup d'expérimentations et de sondages montrent que l'on a davantage confiance et l'on établit plus facilement des liens avec des personnes de la même race.
C'est pour cette raison que les politiciens opportunistes utilisent depuis longtemps l'argument racial pour discréditer l'assistance sociale et la redistribution des revenus. On en trouve des exemples depuis l'époque de la ségrégation qui s'est terminée en 1964, jusqu'à l'odieuse stigmatisation des Noirs " profiteurs des allocations sociales au volant de Cadillac " durant les années Reagan.
Les politiciens blancs de droite, hostiles par nature à l'impôt et à la redistribution, se servent de cet argument pour s'assurer le vote des " petits Blancs " dont les voix risqueraient autrement de leur échapper pour des raisons purement économiques.
La nature des institutions politiques américaines porte fondamentalement la marque de considérations raciales.
Permettant l'élection de Noirs, la représentation proportionnelle qui existe majoritairement en Europe depuis le début du 20° siècle n'a jamais été adoptée par les USA.
En Europe occidentale, les socialistes et les communistes ont imposé des systèmes électoraux basés sur la représentation proportionnelle, précisément parce que cela permet l'élection de représentants des minorités (les communistes et les socialistes eux-mêmes).
Les quelques villes américaines qui ont adopté la proportionnelle durant la période progressiste entre 1910 et 1930 l'ont vite abandonnée - ou ont été forcées de le faire - pour mettre fin à l'élection des Noirs.
Aujourd'hui, la seule ville à avoir un système proportionnel est le bastion gauchiste de Cambridge dans le Massachusetts.
Favorisant l'expression politique des minorités, la proportionnelle est souvent considérée comme un encouragement en faveur d'une politique redistributive.
Des études montrent que plus la dose de proportionnelle est importante, plus la politique sociale est redistributive.
Autre élément, l'examen des programmes sociaux des différents Etats aux USA.
Plus la population d'un Etat est hétérogène, plus sa politique sociale est limitée.
Elle est relativement généreuse dans les Etats très majoritairement blancs du nord et du nord-ouest (par exemple l'Oregon et le Minnesota) et dans certains Etats de Nouvelle-Angleterre comme le Vermont.
Par contre, elle est nettement insuffisante dans le sud-ouest et le sud-est, bien plus hétérogènes sur le plan racial.
Avec l'arrivée de nouveaux immigrants d'Europe de l'Est et des pays pauvres, l'Europe continentale devient de plus en plus hétérogène sur le plan ethnique.
Les partis xénophobes sont de mieux en mieux implantés en Europe et parfois ils ont accédé au moins partiellement au pouvoir.
C'est le cas de Jörg Haider en Autriche, du parti de Pym Fortuyn aux Pays-Bas et dans une moindre mesure de la Ligue du Nord en Italie.
Il ne faudra pas attendre longtemps pour que les très respectables partis conservateurs ajoutent à leur rhétorique l'argument des " étrangers qui viennent chez nous pour profiter de nos impôts ".
Autrement dit, lorsque les classes moyennes européennes penseront qu'une grande partie des pauvres sont de récents immigrés, leur conviction dans les vertus de l'Etat-providence va s'effriter.
Même l'intelligentsia de gauche en Europe associe maintenant la délinquance et la misère urbaine à l'immigration.
De là à trouver trop élevée la part d'impôt dévolue à la protection sociale des immigrés, il n'y a qu'un pas.
Quand cela arrivera - je dis "quand" et non pas "si" - il y aura trois réponses politiques possibles : l'une est de fermer les frontières aux immigrés pauvres, éliminant par là toute corrélation entre immigration et pauvreté, l'autre est de restreindre la protection sociale aux " autochtones " et la troisième est de réduire la protection sociale pour tous, à cause d'un moindre soutien de l'opinion publique.


La première stratégie est à courte vue et la deuxième est simplement odieuse.
J'espère que c'est la troisième qui sera appliquée, car cela signifiera des frontières relativement ouvertes, pas de discrimination et moins d'intervention gouvernementale.
Il n'y a pas de soucis à se faire, en Europe la protection sociale restera plus généreuse qu'en Amérique où elle fonctionne au compte-gouttes, mais deviendra plus simple à gérer et moins intrusive.
Le fait que cela se produira à cause d'une animosité ethnique est triste et déprimant.
Il y a néanmoins un élément positif : il faut réduire la protection sociale en Europe !
Creuset des civilisations ou creux de la vague économique
Inquiets de l'invasion de travailleurs immigrés venant des nouveaux États membres d'Europe centrale et d'Europe de l'Est, les membres anciens de l'Union européenne ont érigé des protections importantes pour contenir l'afflux.
Malgré la rhétorique des marchés ouverts de l'Union européenne, la plupart des citoyens des nouveaux États membres vivront une réalité différente en matière de libéralisation de la mobilité de la main d'œuvre pour les sept années à venir tout au moins.
Il s'agit là d'une politique compréhensible mais déficiente.
Une des plus belles réussites de l'Union européenne reste la mobilité des biens et des intrants.
Sans cela, quelle sorte d'union représenterait l'Union européenne ?
Autrement, qu'est-ce que les nouveaux membres retirent de leur appartenance, précisément, à part les intrusions dérangeantes de la bureaucratie bruxelloise ?
Étant donné les grands espoirs placés dans l'accession à l'Union européenne et l'attitude avare de l'Union envers ses nouveaux membres, cela ne devrait surprendre personne si des réactions anti-européennes prennent bientôt ancrage dans ces pays.
Ainsi, le remède est aussi mauvais que le mal : la discrimination contre les nouveaux membres crée des problèmes politiques bien à elle au sein de l'Union.
La véritable question reste de savoir si le mal est là ou pas.
L'Europe occidentale a-t-elle réellement raison de craindre un énorme afflux de nouveaux immigrés ?
En fait, les flux potentiels de migration Est-Ouest sont relativement faibles.
Selon An agenda for a growing Europe , (Programme d'une Europe grandissante), un rapport publié par Oxford University Press (les presses universitaires) en 2004 pour la Commission européenne, 250 000 à 450 000 travailleurs passeront à l'Ouest les deux premières années, chiffre qui tombera à 100 000 à 200 000 par an ensuite.
Lors des dix premières années, le nombre cumulé des migrants s'élèvera à 1,5 à 4 millions, soit 2,4 % à 5 % de la population totale des membres anciens de l'Union - et une infime fraction de la population totale de l'Union dans son état actuel.
Les populations vieillissantes et la chute des taux de fécondité des nouveaux États membres pourraient même avoir pour résultat des flux moins importants que prévus.
La politique européenne sur les migrations a d'autres défauts moins évidents.
Comme l'exprimait récemment Mircea Geoana, le jeune et brillant ministre des affaires étrangères roumain : " si l'Union européenne met encore sept à dix ans à s'ouvrir totalement, les travailleurs qu'elle recevra de mon pays seront les moins qualifiés, les paysans et les individus à faible capital humain : à ce moment-là, les médecins, les architectes et les ingénieurs auront tous migré vers les États-Unis ".
En effet, c'est exactement ce qui s'est produit avec la Russie : les personnes les plus qualifiées sont déjà parties vers les États-Unis et l'Europe n'a pas été capable d'attirer mieux que quelques oligarques qui ont migré sur la Riviera, ainsi qu'une poignée de chanteurs de rue pittoresques.
L'Europe occidentale se peuple toujours plus de populations âgées qui ont perdu le goût et l'enthousiasme du dur labeur, de la prise de risque et de l'ambition.
Sans apport de sang neuf et d'idées nouvelles, l'avenir de l'économie du vieux continent semble bien triste.
Il suffit de considérer le cas des États-Unis : où en serait l'Amérique si elle avait érigé des barrières pour empêcher les diverses vagues d'immigration et en était restée aux colons anglo-saxons ?
Il est certain que la gestion d'un creuset de civilisation n'est pas chose aisée, et bien des problèmes sociaux que l'Amérique doit maintenant gérer sont issus des relations difficiles entre les diverses ethnies.
Mais New York et Los Angeles, les deux villes américaine les plus diverses d'un point de vue ethnique, sont également les leaders américains du monde des affaires et de l'art.
Rien ne se fait sans douleur dans ce monde : si l'Union ne peut pas gérer une société multiculturelle en Europe, alors elle doit se préparer à une stagnation permanente.
Tant que les frontières de l'Union resteront fermées, le risque de voir les investissements étrangers voler au-dessus de l'Europe occidentale pour se poser en Europe centrale et en Europe de l'Est, où les travailleurs sont prêts à passer de longues heures au travail, où les régulations des marchés sont moins pesantes et le capital humain relativement important, reste élevé puisque les écoles communistes étaient bonnes pour former les populations aux métiers techniques.
Ces pays ont ouvert leurs marchés aux investisseurs étrangers, qui répondent à l'appel avec empressement.
Étant donné le besoin grandissant de main d'œuvre en Europe occidentale pour les années à venir, la question n'est plus de savoir si l'immigration dit se produire mais bien plutôt d'où elle doit se produire.
Aurons-nous recours à une immigration légale de populations facilement assimilables en provenance d'Europe centrale et d'Europe de l'Est, ou bien une immigration illégale en provenance du Maghreb ?
L'Europe en vacances
Actuellement, le nombre moyen annuel d'heures travaillées par personne âgée de 15 à 25 ans en France et en Allemagne est inférieur d'environ 50% à celui des États-Unis.
D'autres pays européens, tels que l'Italie et l'Espagne par exemple, se placent quelque part au milieu de ces deux marqueurs.
Bien que certains Américains se plaisent à faire remarquer leur éthique professionnelle supérieure, cette disparité des heures travaillées entre les États-Unis et l'Europe n'a pas toujours existé.
En effet, jusqu'au milieu des années 70, le nombre d'heures travaillées de chaque côté de l'Atlantique était très similaire.
Depuis le milieu des années 1970, cependant, les Américains ont continué à travailler plus ou moins le même nombre d'heures, tandis que les 2uropéens de l'Ouest ont commencé à travailler de moins en moins chaque année.
Si l'Europe occidentale a besoin d'une explication à son taux de croissance économique, à la traîne des États-Unis, elle n'a pas besoin d'aller chercher bien loin.
Le nombre moyen d'heures travaillées par personne dépend d'un grand nombre de facteurs :
• le niveau de participation à la population active,
• le nombre de jours de vacances par travailleur,
• le nombre d'heures travaillées dans une semaine " normale ", soit sans jour de congé.
Toute la différence quasiment entre les États-Unis d'une part et la France et l'Allemagne de l'autre est due aux deux premiers facteurs, à poids égal chacun.
Ainsi, une participation moindre à la population active explique la moitié de la différence et les vacances plus longues de ceux qui travaillent expliquent l'autre moitie.
L'importance des vacances ne devrait surprendre quiconque a fait l'expérience des villes européennes désertées en août, des ponts d'avril et mai en France et en Italie, des heures de pointe du vendredi à 14h en Allemagne et des stations de ski noires de monde en février du fait des vacances scolaires d'hiver.
Savoir " comment " les Européens arrivent à travailler moins est une chose, il en est une autre de savoir " pourquoi " les Européens travaillent moins que les Américains.
On perçoit souvent les Américains (et ils aiment être ainsi perçus) comme des Calvinistes fous de travail, tandis que les Européens aiment à croire qu'ils savent apprécier la vie et ses plaisirs.
En ma qualité d'Européen travaillant aux États-Unis, je dois admettre que je prends plus de vacances que mes collègues américains.
Cette explication " culturelle " est ainsi peut-être vraie.
Mais pourquoi cela a-t-il commencé aux environs de l'année 73 ?
Autre argument pour rendre compte de cette différence : la différence en matière de fiscalité, qui, en fait, s'est considérablement accrue en Europe depuis les années 1970, tandis que les impôts sur le revenu aux États-Unis sont à la baisse depuis les années 1980.
Les impôts sur le revenu affectent assurément la volonté de travailler.
Ils ne modifient peut-être pas de beaucoup le nombre d'heures travaillées par le plus gros salaire du foyer (l'homme, généralement), mais ils influencent la participation des femmes à la population active.
Après tout, pourquoi travailler si le salaire net après imposition couvre à peine les frais de garderie et d'aide ménagère ?
Mais ce n'est pas là une explication satisfaisante, parce que des études montrent comment l'approvisionnement de main d'œuvre répond aux changements fiscaux et suggèrent donc que l'explication du fossé énorme qui existe entre les États-Unis et l'Europe, et plus particulièrement avec la France et l'Allemagne, doit se trouver ailleurs.
Pour les plus de 50 ans, la structure des systèmes de retraite est bien évidemment un facteur prépondérant.
C'était et cela reste bien plus rentable de prendre sa retraite à un jeune âge en Europe, par rapport aux états-unis.
Pourquoi un Français ou un Italien entamant sa soixantaine continuerait-il à travailler aujourd'hui, quand il aurait pu prendre sa retraite à 55 ans des les années 90 et toucher 80% ou plus de son dernier salaire ?
Pour les femmes, l'âge de la retraite au milieu des années 90 était même encore plus bas.
Les employés de la fonction publique avaient encore plus d'avantages sociaux.
Mais cela n'est pas tout.
Dans les années 80 et 90, de nombreux syndicats de travailleurs européens adoptèrent la politique du partage du travail pour répondre à la montée du chômage.
En d'autres termes, ils obtinrent des durées hebdomadaires de travail moins longues (et donc plus de temps libre) pour maintenir les taux d'emploi.
Le problème que cela pose vient du fait que les rémunérations globales n'ont pas baissé en proportion des heures travaillées, ce qui a mené à une augmentation du salaire horaire.
Une productivité plus faible et des coûts de main d'œuvre plus élevés ont usé la volonté d'embaucher des entreprises, laissant l'Europe avec des taux de chômage régulièrement plus élevés qu'aux États-Unis
Les discussions en cours aujourd'hui sur la croissance en Europe bourdonnent de mots à la mode tels que " la société fondée sur les savoirs ", le " progrès technologique " et les " investissements dans l'éducation ".
Les Européens ont certainement besoin de quelque chose pour compenser une activité professionnelle courte avec autant de vacances.
Mais la majeure partie de ces discussions n'est que pure correction politique : il est plus rassurant - et cela sonne mieux- de dire aux Européens que la croissance est ralentie parce que la société n'est pas assez assise sur ses savoirs plutôt que de montrer du doigt le déséquilibre de la croissance créé par les vacances.
Les Européens préfèrent en général leurs vacances à la croissance.
Personnellement, j'adore prendre toujours plus de vacances.
Mais je ne peux pas (et ne veux pas) alors me plaindre du ralentissement de la croissance de mon revenu.
L'inévitabilité de la démocratie chinoise
Quinze années auparavant, Fang Hongin manifestait sur la place Tienanmen.
Quelques années auparavant, à Beijing, il dirigeait l'une des émissions télévisées les plus populaires de Chine, testant chaque semaine les limites de l'indulgence des autorités.
Aujourd'hui, il dirige Dragon TV, la principale station de Shanghai, et des publicités le mettant en vedette sont suspendues aux gratte-ciels de la ville.
Hu Shuli appartient à la même génération : la journaliste que le magazine Economist a surnommé la " femme la plus dangereuse de Chine ", dont le premier emploi consistait à s'occuper de la presse du Parti, dirige désormais Caijng , un magazine économique qui parle de corruption, exposant les hommes d'affaires et les fonctionnaires.
Ce serait toutefois une erreur d'interpréter ces expériences de presse libre comme des signes indiquant que la démocratie en Chine va bientôt voir le jour.
Le Parti permet à Caijng d'exposer la corruption car ces actions lui permettent de mettre fin à la maladie la plus grave de la Chine. "
Le premier droit civil consiste à échapper à la pauvreté, explique Yongtu Long, l'un des négociateurs chinois à l'OMC.
En 15 ans, nous avons sorti 200 millions d'individus de la pauvreté ; 700 millions de Chinois ont aujourd'hui accès à l'électricité, un luxe inconnu 15 ans auparavant.
C'est la raison pour laquelle nous nous consacrons en priorité à la croissance : tout le reste, pour parler franchement, est de moindre importance. "
La croissance n'implique toutefois pas uniquement de sortir des individus de la pauvreté.
Vingt-cinq ans auparavant, la société chinoise était plus égalitaire que la société suédoise ; aujourd'hui, les inégalités sont immenses entre la ville et la campagne, entre les provinces occidentales et les provinces bordant l'Océan Pacifique ainsi qu'au sein des villes, qui attirent un flux constant d'anciens paysans à la recherche d'un emploi.
La répartition des revenus de la Chine à l'heure actuelle s'apparente davantage à celle du Brésil qu'à celle de la Suède.
Mais plus d'inégalités implique également plus de perspectives : il est toujours extrêmement difficile de s'enrichir en Chine à l'heure actuelle, mais ce n'est plus impossible, comme vous le constaterez si vous entrez dans l'un des pubs du centre-ville.
L'inégalité peut être acceptée, mais pas si elle est le fruit de la corruption ; elle demeure le principal problème social de la Chine, problème que le Parti s'est révélé incapable d'éradiquer, malgré les révélations de Caijng et la peine capitale.
La Chine peut-elle réellement se passer de la démocratie ?
Quelques années auparavant, Fareed Zakaria, alors rédacteur de Foreign Affairs , a argumenté contre la priorité généralement accordée à la démocratie, définie simplement comme la possibilité de choisir des dirigeants politiques par le biais d'élections libres.
Le monde est rempli de démocraties qui violent systématiquement les droits de l'homme, a-t-il affirmé. "
Les élections n'ont qu'une utilité limitée si des gouvernements démocratiquement élus restreignent la liberté de la presse et l'indépendance du pouvoir judiciaire. "
" La liberté est certainement plus grande à Shanghai qu'à Moscou, a déclaré un professeur de l'université Tsinghua à Beijing, se faisant l'écho de Zakaria.
Elle a probablement raison, bien que l'Inde nous rappelle que les élections constituent parfois un mécanisme puissant et efficace pour rectifier la politique adoptée par un pays.
L'économie de l'Inde croît pratiquement aussi rapidement que celle de la Chine, avec une augmentation similaire de l'inégalité et, dans une certaine mesure, de la corruption.
Mais les électeurs indiens se sont retournés contre ce modèle.
L'économie de l'Inde risque donc de ralentir.
Il est difficile de prédire si les conséquences de cette inégalité sont positives ou négatives.
Elles sont probablement négatives sur le court terme, mais qui peut les prévoir sur le plus long terme ?
Le fait est que des questions comme " L'inégalité que nous créons est-elle trop marquée ? " ne peuvent même pas être posées en Chine.
Par conséquent, chaque fois qu'un problème échappe à tout contrôle, le changement vient trop tard et est dramatique.
C'est la raison pour laquelle la Chine ne peut pas laisser en suspens le problème de sa transition vers la démocratie.
La démocratie n'est pas seulement un mécanisme destiné à prévenir les erreurs stratégiques.
Il existe une raison plus banale qui explique pourquoi de nombreux individus, même au sein du Parti, pensent qu'une transition démocratique est devenue inévitable : le Parti perd tout simplement le contrôle du pays.
Deng Xiaoping a été le dernier dirigeant chinois à posséder une autorité incontestée sur la politique publique.
Aujourd'hui, le bureau politique du Parti compte plus de 20 membres et chaque résolution requiert l'unanimité.
Les décisions plus importantes exigent un consensus encore plus grand, impliquant jusqu'à 3 000 personnes.
Par exemple, le Parti se concentre essentiellement, à l'heure actuelle, sur la rédaction des documents qui devront être approuvés lors du prochain congrès, prévu pour l'automne 2007.
La différence entre le rythme de l'économie et celui du Parti signifie que le pays se dirige de plus en plus tout seul.
Comme par le passé, lorsqu'une dynastie s'affaiblit, les provinces prennent leurs propres décisions.
Il est même difficile de ralentir l'économie : manquant d'un système financier efficace, la croissance des crédits doit être contrôlée directement par l'intermédiaire des banques.
Mais le directeur du bureau de Guangzhou de la Banque de Construction de Chine, la plus grande banque de Chine, consulte le dirigeant du Parti de sa province avant d'appliquer les directives qu'il reçoit du siège social de la banque à Beijing.
Tenant compte de ces difficultés, certains membres du Parti admettent " qu'il n'y a qu'un seul moyen pour aller de l'avant : confier la responsabilité à un individu, quel que soit le mode par lequel il/elle est choisi(e), même par le biais d'une élection, pourvu que la prise de décision efficace soit rétablie ".
La transition démocratique de la Chine est donc peut-être plus proche qu'on ne l'imagine.
Mais si elle survient, elle ne résultera pas d'expériences démocratiques menées par la base dans les villes et les villages ; il s'agira plutôt d'une transition amenée par l'élite, soucieuse de préserver le contrôle du gouvernement.
C'est la seule condition sous laquelle l'Armée de Libération du Peuple et la Commission militaire toute-puissante accepteront la démocratisation.
L'Union européenne est-elle en train d'imploser ?
La perspective de l'adhésion à l'Union européenne a fortement encouragé les pays de l'Est à atteindre l'équilibre budgétaire ; un effet semblable à celui du passage à l'euro pour l'Europe occidentale.
Néanmoins, dans les deux cas, après de bons débuts, les pays ont manifesté une "fatigue" politique évidente : dans la zone euro, le Pacte de stabilité a implosé, et dans toute l'Europe orientale les déficits budgétaires ont commencé à augmenter.
En République tchèque l'année dernière, le déficit budgétaire - qui a triplé depuis 1999 - a atteint 13 % du PIB.
Alourdi ponctuellement par la restructuration du secteur bancaire, il dépassera tout de même cette année 6 %.
La Pologne enregistre également un déficit proche de 6 %, contre 2,9 % en 2001.
En Hongrie, l'écart se creuse de nouveau, après un déficit de 4 % en 2001.
A Malte, le déficit représente près de 10 % du PIB, soit 4 points de plus qu'en 2001.
Seuls les pays baltes semblent en mesure de maintenir des politiques budgétaires saines.
Cette situation n'est guère surprenante : libérés des rapports de suivi annuels de l'UE, et de la menace d'exclusion, les politiciens peuvent se permettre beaucoup plus de souplesse.
En même temps, les grands pays de la zone euro - la France et l'Allemagne - sont mal placés pour critiquer les politiques budgétaires des autres, et le déficit des membres de l'Union n'est donc soumis à pratiquement aucune contrainte internationale.
En réalité, les contraintes se sont avérées totalement inutiles après adhésion, et il sera difficile d'en faire des critères pour les prochains candidats.
Ce qui surprend davantage, c'est le rejet politique des gouvernements qui ont fait entrer leur pays dans l'Union.
Là encore, la similitude avec ce qui s'est passé en Europe occidentale au moment du passage à l'euro est frappante.
Le gouvernement de Romano Prodi, qui avait réussi contre toute attente à inclure l'Italie dans l'union monétaire, a subi une défaite trois mois plus tard.
La République tchèque, la Pologne et la Hongrie ont traversé une crise gouvernementale depuis l'adhésion à l'UE.
Partout en Europe centrale et orientale, la popularité de l'Union n'est plus ce qu'elle était.
La faiblesse de la participation aux élections du Parlement européen en juin a été déconcertante dans les nouveaux Etats membres : de 17 % en Slovaquie à 38,5 % en Hongrie.
Pour le premier scrutin européen de leur histoire, ces pays ont ainsi connu un taux de participation bien inférieur à la moyenne européenne (environ 45 %), et même inférieur à la moyenne britannique.
Deux raisons à cela : d'une part, les pays candidats se sont sentis contraints à des politiques d'ajustement majeures pour être acceptés dans l'UE.
Que ce soit ou non dans leur intérêt à long terme, à court terme il y a eu un coût politique important.
D'autre part, à cette " fatigue de l'ajustement " - un terme créé dans un contexte de libéralisation économique en Amérique latine dans les années 90 - s'ajoute aujourd'hui le sentiment qu'en fin de compte l'UE n'est pas la panacée.
Notamment, les pays d'Europe occidentale sont toujours désireux de protéger leur marché du travail des migrations venues d'Europe centrale et orientale ; un sujet délicat soulevé à chaque rencontre entre politiciens de l'Est et de l'Ouest.
Il n'est donc pas surprenant que les électeurs d'Europe centrale et orientale aient l'impression d'avoir fait une mauvaise affaire : ils ont dû se serrer la ceinture et accepter des restrictions du marché du travail, sans parler du déluge de réglementation européenne.
D'où une réaction hostile envers les gouvernements qui les ont fait adhérer et un désintéressement à l'égard de l'UE.
Nous voici donc, après toutes les célébrations de l'élargissement, face à plusieurs problèmes prévisibles : une "union" de pays aux points de vue très variés (sur tout, de la politique étrangère au marché du travail) et aux intérêts économiques différents ; un désenchantement de l'électorat dans les nouveaux Etats membres ; un processus constitutionnel à l'avenir incertain ; et toutes les querelles politiques habituelles à Bruxelles, entre pays qui cherchent à obtenir le plus de pouvoir possible.
Le long déclin de l'Europe de l'Ouest ?
La période des élections approche en Allemagne, en France et en Italie, de sorte que le temps des réformes structurales est écoulé.
Paradoxalement, cette nouvelle pourrait réjouir tous ceux qui pensent que l'Europe devrait commencer à contribuer à la croissance mondiale en développant la demande nationale.
En fait, il est admis que la raison pour laquelle la France s'est récemment développée deux fois aussi rapidement que l'Allemagne est que les consommateurs français ont cessé de s'inquiéter à propos des réformes sociales.
Dès que le ministre français des Finances Nicolas Sarkozy a décidé de quitter le gouvernement et de commencer à faire campagne pour les élections présidentielles, le président en fonction Jacques Chirac a abandonné tous les plans de réforme susceptibles d'aliéner les électeurs.
Une réforme de la santé ou même une réforme partielle des retraites devra ainsi patienter quelques années.
Au même moment, un livre blanc récent rédigé par un groupe de travail dirigé par l'ancien dirigeant du FMI, Michel Camdessus, qui a été chargé de proposer le type de réformes structurales nécessaires pour la croissance, a été reçu avec le tollé habituel manifesté par les syndicats.
La majorité de ses propositions raisonnables constitueront bientôt un autre exemple de bonnes intentions tombées dans l'oubli.
Retour aux affaires, comme toujours en France.
De l'autre côté, les foyers allemands, selon un récent sondage publié dans le quotidien influent Die Welt , sont d'humeur plus modérée : la majorité projettent de réduire leurs départs en vacances ce qui, de toute évidence, n'impliquera pas qu'ils travailleront plus (ils passeront tout simplement une partie de leurs nombreuses semaines de loisirs payés chez eux), et de différer les achats importants.
La raison�?
Ils sont préoccupés par le débat sur la réforme des retraites, les changements du système de santé et les nouvelles règles d'admissibilité pour les prestations chômage.
Leur humeur pourrait très bien devenir bientôt plus gaie. Le chancelier Schröder se prépare également à sa réélection.
Il peut même espérer gagner, le SPD, son parti, remontant dans les sondages.
Par conséquent, les références à la nécessité d'inciter aux réformes ont disparu de ses discours.
Le changement très attendu en matière de consommation allemande, peu dynamique pendant une bonne partie d'une décennie, est peut-être sur le point de se produire.
En Italie, le premier ministre Berlusconi a attendu trois ans et demi avant de se décider à honorer sa principale promesse électorale de réduction des impôts.
Mais de véritables réductions d'impôts impliquent également des réductions des dépenses, mais comme les élections sont dans moins d'un an à compter d'aujourd'hui, il est désormais trop tard.
Inquiet de ce que la réduction des dépenses puisse lui faire perdre des voix, Berlusconi propose une réduction d'impôts inférieure à 0,3 % du PNB et financée en partie par d'autres impôts.
Si les Allemands sont déprimés, les Italiens sont dans le coma.
Ces expériences nous enseignent une leçon.
Les Européens ne souhaitent pas réellement des réformes et les politiciens en sont bien conscients.
Ou, pour le formuler différemment, des intérêts spéciaux sont devenus si puissants et si ancrés que toute tentative de réforme entraîne un puissant groupe de pression à son encontre.
Les politiciens en campagne promettent ainsi l'impossible : des réformes qui produiront une prospérité instantanée sans que cela ne coûte rien à personne.
Lorsque cela se révèlera impossible, de manière tout à fait surprenante, ils abandonneront la réforme.
Entre-temps, ils occasionneront des dommages sérieux car les Européens sont tellement inquiets par la possibilité de réforme que la simple possibilité que ces réformes soient promulguées les terrifie.
En fait, ce débat et une action minime ou inexistante sur les réformes structurales posent deux problèmes.
Premièrement, les consommateurs sont anxieux et la demande baisse.
Deuxièmement, les groupes de pression anti-réformes ont tout le temps de s'organiser et de prévenir toute avancée vers l'aboutissement de l'effort de réforme.
Un plan politiquement plus réussi consisterait à adopter l'approche « big bang », à savoir mettre rapidement en oeuvre une large série de réformes qui briseraient l'opposition d'intérêts spéciaux et laisseraient suffisamment de temps avant l'élection suivante pour que les électeurs ressentent les bénéfices de la réforme.
Par exemple, lorsque les consommateurs constateront les bénéfices de la déréglementation du marché, ils se sentiront peut-être dédommagés du fait qu'ils devront travailler plus longtemps pour leur retraite.
Mais aucun politicien européen à l'horizon ne semble adopter cette approche.
Cela signifie-t-il que l'Europe, du moins l'Europe de l'ouest continentale, est condamnée�?
Pas nécessairement.
L'Allemagne, la France et l'Italie sont des pays riches.
Même sans réformes, ils seront en mesure d'offrir une forme de vie civilisée pendant de nombreuses années à venir.
Ils deviendront par la suite pauvres par rapport à d'autres économies à croissance plus rapide.
Mais après tout, il a fallu presque un siècle de mauvaise gestion à l'Argentine pour passer d'un revenu par habitant optimal à sa pauvreté relative actuelle.
Réformes : en parler et ne rien faire…
Discuter ŕ longueur de temps de réformes sans jamais passer aux actes fait plus de mal que de bien.
Anticiper une réforme, par exemple celle des retraites, du systčme de santé ou des indemnités de chômage inquičte tous ceux qui se sentent concernés.
S'attendant ŕ devoir un jour ou l'autre payer des services jusqu'alors gratuits ou bénéficiant de tarifs subventionnés, ils régissent en réduisant leur consommation et en économisant.
Mais autant que les politiciens se contentent de discuter, la confiance des consommateurs s'effrite, les indicateurs économiques passent au rouge et le consensus nécessaire ŕ l'adoption des réformes disparaît.
Les discussions se prolongent néanmoins, de męme que la chute de confiance des consommateurs.
L'Allemagne offre un exemple inquiétant de ce cercle vicieux.
Depuis plus d'une décennie, la réforme du généreux systčme de protection sociale occupe la premičre page des journaux allemands.
L'index de confiance des consommateurs était légčrement positif en novembre 2000, mais il est depuis tombé ŕ -20, la chute la plus marquée de toute la zone euro.
Dans la rue, c'est le pessimisme qui l'emporte.
Depuis deux ans, le taux de croissance de la consommation des ménages (mesuré ŕ prix constants) est ŕ la baisse : -1% en 2002 et -0,5 en 2003.
Un tel recul s'observe rarement dans les pays industrialisés, car en cas de difficulté, les consommateurs utilisent généralement leur épargne pour maintenir leur niveau de consommation.
Pour l'Allemagne, il faut revenir au début des années 1980 pour retrouver un tel déclin de la consommation.
Face ŕ cette situation, plutôt que de baisser, le taux d'épargne des ménages est ŕ la hausse, passant de 9,7% du revenu disponible en 2000 ŕ 11,8% en 2003.
La baisse de la consommation et la hausse de l'épargne affectent toutes les catégories d'âge de la population, mais elle touche davantage les plus âgées.
Le seul signe de reprise de la consommation s'observe parmi les jeunes ménages d'une vingtaine d'années, qui de toute évidence espčrent que tôt ou tard les réformes seront adoptées et que leurs impôts baisseront.
Mais męme chez les ménages âgés d'une trentaine d'années, le taux d'épargne augmente au męme rythme que l'inquiétude suscitée par les réformes.
Il n'est pas surprenant que les personnes âgées réduisent davantage leur consommation.
Avec la retraite, elles ont perdu presque toute possibilité de choix : elles ne peuvent ni travailler davantage ni souscrire un contrat d'assurance maladie auprčs d'un organisme privé, car étant donné leur âge, les primes sont trop élevées.
Elles sont contraintes de compter sur leurs économies et de réduire leur consommation de maničre drastique.
Si l'on considčre ce phénomčne dans le contexte d'une population en vieillissement rapide, les conséquences sur la consommation globale sont spectaculaires.
La France est le seul pays de la zone euro dans lequel la confiance des consommateurs continue ŕ croître (passant de -24 il y a un an ŕ -13 aujourd'hui).
José Bové s'attaque aux pauvres
Les soutiens pour l'accroissement de l'aide internationale, à la réduction et à l'annulation de la dette viennent de partout.
Des stars du rock aux anti-mondialistes, des organisations religieuses aux différents défenseurs des pays en développement, jusqu'aux Nations Unies, tous ces appels en deviennent assourdissants.
Le « ligne » défendue par les mouvements en faveur de l'annulation de la dette est simple et attrayante.
Les différences globales dans les revenus par tête sont trop extrêmes ; la mondialisation accroît les inégalités de revenus ; les pauvres sont progressivement plus pauvres et nombreux sont ceux qui sont affamés par le remboursement de la dette.
Il faut donc aider plus, et annuler une plus grosse partie de la dette, parce que les riches de la planète ne deviennent riches qu'aux dépends des pauvres.
L'aide et l'annulation de la dette sortiront les pays pauvres de leur pauvreté.
Cette ligne est presque totalement fausse.
La seule chose qui soit vraie est que les différences de revenus par tête sont extrêmes.
Tout le reste est faux.
La mondialisation n'est pas la cause de la pauvreté du tiers-monde.
Ce sont les gouvernements corrompus et inefficaces des pays en voie de développement qui le sont.
Il n'existe aucune preuve démontrant qu'une plus grande ouverture commerciale accroît la pauvreté, mais les anti-mondialistes ne laissent pas les faits interférer avec leur idéologie.
L'accroissement des échanges permet d'enrichir les deux parties prenantes des transactions.
Même si la mondialisation accroissait les inégalités (un bien grand si), dans la mesure où personne ne peut le prouver de manière convaincante, elle permet malgré tout de réduire la pauvreté.
Ainsi, elle accroît le revenu des pauvres comme celui des riches qui participent aux échanges commerciaux, de manière plus importante pour les riches, bien sûr, mais pourtant, les pauvres y trouvent leur intérêt aussi.
La proposition anti-mondialiste consiste à appauvrir chaque partie prenante.
L'inégalité est peut-être réduite, mais la pauvreté reste élevée.
Qu'y a-t-il d'attrayant dans cela ?
Il est faux de dire que les pays pauvres s'appauvrissent.
Il existe de nombreux exemples de pays qui se sont sortis de la pauvreté, depuis la Corée du sud jusqu'au Costa Rica et au Botswana.
D'autres ont dilapidé l'immense richesse de leurs ressources naturelles, comme le Nigeria ou le Venezuela, ce dernier, par ailleurs, a adopté des politiques protectionnistes récemment.
Il n'existe aucune preuve démontrant que l'augmentation de l'aide internationale en direction des gouvernements des pays en développement améliore leurs performances économiques pour leur permettre de sortir définitivement de la pauvreté.
En fait, l'augmentation de l'aide internationale a probablement pour effet d'augmenter la corruption, parce que cela augmente la somme des ressources que se disputent les élites.
Il en va de même pour l'annulation de la dette : elle ne fait qu'encourager ces pays à emprunter plus, souvent au bénéfice des élites locales.
L'ouvrage récent, et abondamment cité, de William Easterly, ancien économiste de la Banque mondiale et expert en aide internationale et en développement, présente une montagne d'anecdotes choquantes à propos des élites locales dilapidant l'aide internationale.
La coalition pour l'aide internationale devrait le lire avec attention.
Ceux qui ont vraiment à coeur de réduire la pauvreté devraient faire tomber les responsabilités là où elles sont : dans les gouvernements et les bureaucraties de nombreux pays en voie de développement, particulièrement en Afrique et en Amérique latine.
Au lieu de cela, habituellement, l'aide internationale ne s'est jamais préoccupée du mérite des pays la recevant et n'a jamais fait de distinction en faveur des « bons gouvernements ».
Les pays participant à l'aide internationale ont toujours favorisé leurs anciennes colonies, sans considération quant à la nature des régimes politiques en place.
La France est l'un des coupable les plus flagrants.
Les statistiques montrent que n'importe quelle ancienne colonie qui mettrait en place les pires politiques sous des régimes dictatoriaux et insupportables recevrait bien plus d'aide de la France que n'importe quelle ancienne colonie n'ayant pas été française qui se débattrait pour essayer de mettre en place des politiques décentes.
En d'autres termes, la France soutient exclusivement ses anciennes colonies, sans considération de qualité de leurs régimes politiques.
L'aide apportée par les États-Unis est principalement influencée par la politique au Moyen-Orient, et par la guerre froide, par le passé.
Les alliances politiques, en fait, sont souvent plus importantes que la qualité des politiques des pays bénéficiaires dans la détermination des destinataires de l'aide apportée.
Les pays scandinaves, dont l'aide est la plus élevée par tête mais moindre en pourcentage du total, sont les seuls pays qui dirigent leur aide de manière raisonnable.
Une des raisons pour cela vient du fait que ces pays n'avaient pas de colonies ni d'alliances politiques à soutenir.
Avant d'augmenter l'aide internationale ou d'annuler la dette, il faut mettre en place deux conditions.
La première est la « condition d'institutionnalisation » : seuls les gouvernements faisant preuve de progrès sérieux dans la réduction de leur inefficacité, de leur pillage de la propriété publique et de la corruption peuvent recevoir une aide international.
Mesure la corruption de manière raisonnable est faisable ; nous connaissons les pays les plus corrompus.
Cet élément devrait être utilisé de manière plus agressive par les pays pourvoyeurs d'aide internationale pour établir des distinctions parmi les pays bénéficiaires.
Malheureusement, dans la plupart des cas, les pays les plus pauvres où l'aide est la plus nécessaire, sont aussi les plus corrompus.
Ainsi il faut donc une seconde condition : dans ces circonstances, l'aide internationale doit se faire en dehors des institutions publiques et doit être administrée par des groupes qui ne sont pas locaux, ni associés aux élites et aux gouvernements locaux.
Enfin, d'autres politiques des pays riches pourraient être plus efficaces que l'aide internationale.
Le changement principal serait de faire cesser le protectionnisme agricole dont bénéficient les agriculteurs des pays riches.
Les agriculteurs des pays riches sont les pires ennemis des pays pauvres.
Vaincre le lobby des agriculteurs français qui étrangle les réformes de la politique agricole commune de l'UE doit être la priorité principale de la coalition européenne en faveur des pauvres.
Au lieu de cela, les anti-mondialistes se préoccupent plus du charme des villes agricoles françaises que menace la mondialisation, et donc l'agriculture des pays pauvres essayant de survivre.
Contrairement à ce que prétendent les critiques du FMI comme Joe Stiglitz, l'abandon du consensus de Washington se retournerait contre les pauvres.
Dans l'une de ses récentes attaques au vitriol contre le FMI, Stiglitz sous-entendait que contrairement au FMI, il se préoccupe des pauvres ; mais les données le contredisent.
Les mesures qu'il préconise plus ou moins directement, telles que le creusement d'un déficit budgétaire suivi de l'utilisation de l'inflation pour résoudre les problèmes fiscaux, sont particulièrement nuisibles aux pauvres.
Les classes aisées d'Amérique latine ont l'habitude de transférer leurs richesses vers les paradis fiscaux au moindre signe d'un resserrement de la fiscalité.
Une Europe divisée
Lors des prochaines réunions du G8 (qui regroupe les pays les plus riches du monde et la Russie), les présidents de quatre de ses membres - l'Allemagne, la France, l'Italie et la Grande Bretagne - y participeront tant au titre de leur pays qu'à celui de l'Union européenne.
Mais ne vaudrait-il pas mieux que l'UE ait un représentant unique ?
Cela donnerait beaucoup plus de poids à l'UE, notamment à l'égard des USA.
C'est d'ailleurs l'une des premières raisons de l'intégration européenne.
L'Allemagne, la France, l'Italie et la Grande Bretagne ont pratiquement la même position vis-à-vis de la mondialisation.
Il serait dans doute préférable que ces pays présentent un front uni sur ce sujet.
Ils ont une politique commerciale et un marché commun, une politique antitrust commune, pour ne citer que quelques secteurs ; alors pourquoi pas un représentant unique au G8 ?
Il y a deux explications possibles.
La première consiste à dire que malgré quelques démonstrations d'unité, les pays européens sont très divisés en ce qui concerne la politique étrangère et ne veulent donc pas abandonner leurs prérogatives dans ce domaine.
Considérons par exemple les tensions qui ont marqué dernièrement les relations avec les USA.
Quant à l'Allemagne, elle a adopté récemment une position nettement plus antiaméricaine (peut-être pour des raisons électorales), mais elle commence à faire preuve d'indépendance en politique étrangère.
Une politique étrangère commune pourrait se révéler impossible ou se réduire à l'adoption d'une plate-forme minimale qui lui ôterait toute efficacité.
L'adoption d'une position commune à la majorité des votes engendrerait des tensions entre les pays membres.
L'Union européenne pourrait compter prochainement plus de 25 pays.
Adopter une politique étrangère commune sera alors beaucoup plus difficile, voire totalement irréalisable.
De 1995 à 2002, en dépit du Pacte de stabilité, le total des dépenses publiques de la zone euro (net des dépenses d'intérêt et de principal) n'a pratiquement pas varié : s'élevant à 41% du PIB de la zone euro en 1995, il s'élèvera à 40.7% du PIB cette année.
Entre temps, l'investissement public brut, déjà infime, s'est encore plus resserré passant de 2.7% à 2.4% du PIB.
Résultant du Pacte de stabilité, de faibles différences de résultat des budgets sont devenues importantes dans le débat sur la politique économique européenne : non seulement elles sont manifestement ridicules, mais elles détournent aussi l'attention des vrais problèmes budgétaires européens.
Peu sont ceux qui semblent conscients des marges d'erreur possibles quand on travaille avec de tels données.
Il n'est pas extraordinaire, par exemple, que les discussions parlementaires sur les budgets se transforment en réflexion sur les conséquence en matière de déficits budgétaires plus ou moins élevés que telle ou telle action entraînera : de 0,8 à 1,1% du PIB par exemple, se moquant allégrement que la variation de ces chiffres se place bien en dessous de la marge d'erreur statistique.
Des débats futile de ce type représentent des excuses bien utiles quand un pays veut éviter de faire face aux vrais défis fiscaux : un système de retraite ingérable, des allocations chômage qui découragent les travailleurs de chercher un travail, des salaires dans la fonction publique sans aucune mesure avec la productivité effective.
Mario Monti sur la sellette
Mario Monti, le commissaire européen à la concurrence, est souvent sous les feux de l'actualité et il bénéficie généralement d'une grande popularité.
Au cours du temps, il a remporté d'importantes victoires en limitant les subventions publiques aux entreprises, l'une des tares économiques les plus pernicieuses qui soient.
Mais aujourd'hui sa réussite est compromise par une série accablante de procès perdus.
Avec la conclusion de l'affaire du géant Microsoft - déclenchée par une question de monopole - qui paraît en vue, il a tout intérêt à retrouver rapidement son assise.
En l'espace de quelques semaines, la Cour européenne de justice (auprès de laquelle il peut être fait appel des décisions de la Commission) a annulé trois vétos pris par Mario Monti à l'encontre de fusions d'entreprises.
Même si les subventions publiques et les fusions d'entreprises sont de deux domaines distincts, ses échecs répétés dans ce dernier domaine ne sont pas sans conséquences dans l'action qu'il mène par ailleurs, notamment dans sa lutte contre le soutien de l'Etat au secteur privé.
L'annulation de ses vétos par la Cour constitue un camouflet sans précédent.
Dans l'affaire de la fusion Schneider---Legrand, elle cite plusieurs erreurs manifestes, des omissions et des contradictions dans l'analyse économique de la Commission, ainsi que des irrégularités de procédure qui constituent une atteinte aux droits de la défense.
Dans l'affaire Tetra Laval, la Cour conteste "l'analyse économique des conséquences à court terme de la fusion sur la concurrence" qui était "affectée d'une insuffisance d'éléments probants et comportait certaines erreurs d'évaluation".
Enfin, dans le cas de la fusion d'Airtours, la Cour a jugé que la Commission avait pris des décisions entachées d'erreurs sur des questions qui sont d'après elle fondamentales pour déterminer si une fusion entraîne la création d'une position dominante collective.
Elément qui aggrave encore l'injustice, dans au moins un cas, la décision de la Cour est intervenue trop tard pour que les entreprises concernées puissent poursuivre leur projet.
Ces affaires soulèvent des questions importantes quant au fond de la politique de la Commission en matière de concurrence et aux procédures utilisées.
Sur le fond, les décisions de la Cour donnent l'impression que l'Europe en fait un peu trop en ce qui concerne la concurrence.
Rendre une décision de justice sur le compromis entre l'efficacité que peut apporter une fusion et le risque de monopole est une chose délicate qui n'est pas de nature idéologique.
Dans l'affaire Airtours/First Choice, selon la Cour, la Commission n'a pas établi que l'opération de concentration "inciterait les trois grands voyagistes à ne plus se concurrencer" et elle a "estimé à tort que la concentration permettrait aux grands voyagistes de déchiffrer plus facilement leurs stratégies commerciales respectives pour ensuite les adopter".
La Cour estime également que la Commission n'a pas "clairement identifié et démontré" les mesures que pourraient prendre les membres de l'oligopole pour mettre en oeuvre une "ligne d'action commune".
Enfin, la Commission a "sous-estimé" la capacité des concurrents à réagir face à "une éventuelle tentative de limiter la capacité", que ce soit en augmentant leur offre ou en se positionnant rapidement sur le marché.
L'affaire Tetra Laval-Sidel est particulièrement intéressante, car elle montre à quel point l'équipe de Monti cherche à anticiper la politique des entreprises.
Elle est partie de l'idée que la profusion de fournisseurs dans le marché de l'emballage allait s'accentuer à moyen et long terme.
Elle en a conclu que Tetra Laval qui domine largement le marché des emballages en carton allait sans doute faire pression sur ceux de ses clients qui voulaient s'orienter vers les emballages en plastique PET pour qu'ils se tournent vers Sidel.
La Cour reconnait que la fusion pouvait entrainer ce type de manoeuvre, mais elle estime que la Commission n'a pas établi que la nouvelle entité serait incitée à la mettre en pratique.
Nous savons que les services du commissaire Monti peuvent répondre aux objections formulées par la Cour et que l'on peut discuter longuement sur le point de savoir si les fusions sont une menace telle sur la concurrence qu'il faille les empêcher.
Mais notre point de vue est différent.
Plutôt que d'examiner au microscope les fusions envisagées, le commissaire Monti devrait s'intéresser davantage à ses autres missions, limiter les subventions publiques aux entreprises privées et l'intervention de l'Etat sur le marché.
Autrement dit, il ferait sans doute mieux d'investir ses ressources qui sont limitées dans une autre direction.
Nous ne prétendons pas qu'il ne doit plus chercher à rendre le marché européen plus compétitif.
Dans la plupart des villes européennes, les chauffeurs de taxi sont protégés par la limitation du nombre de licences. De la même manière, dans de nombreux pays européens le nombre d'études notariales est limité et leur rémunération est élevée au regard du service rendu - sans grande valeur économique, mais indispensable du point de vue des procédures administratives.
Ce sont des batailles importantes qui concernent de près les citoyens.
Mais de même que la lutte contre les subventions publiques qui vise l'intervention de l'Etat, elles ne sont pas dirigées contre les entreprises privées.
La procédure elle-même touche des questions d'ordre constitutionnel.
Dans le domaine de la concurrence, au moins en première instance, la Commission est juge et partie.
Elle peut à la fois décider d'entamer une procédure contre une décision de fusion et l'interdire.
Les parties peuvent faire appel devant la Cour européenne de justice, mais cela prend du temps et si elle annule la décision de la Commission, il ne s'agit souvent plus que d'une victoire symbolique, car elle intervient trop tard, comme dans l'affaire Airtours-First Choice.
Un partage des responsabilités entre l'instance qui poursuit et celle qui juge constitue une garantie constitutionnelle fondamentale en cas de litige privé.
Aux USA, la concurrence est arbitrée selon ce principe et l'on ne peut que souhaiter que l'Europe le mette en pratique.
Il serait bon que Giscard d'Estaing et sa Convention européenne se penchent sur la question.
Menace furtive pour le commerce mondial
Les menaces qui planent sur le commerce mondial revêtent de multiples apparences.
Il est courant de soupçonner les barrières protectionnistes et les protestations militantes contre la globalisation, telles que celles qui ont fait dérailler les négociations du « Cycle du Millénaire » de l'Organisation mondiale du commerce (OMC), qui se sont tenues l'an dernier à Seattle.
Bien que ces manifestations fassent la une des journaux, une nouvelle menace pour le commerce mondial, peut-être même bien plus insidieuse, se dessine dans l'ombre depuis quelques années : le « sectorialisme » prétendument « ouvert », qui consiste à négocier l'accès aux marchés étrangers de manière sélective, industrie par industrie.
Cette pratique suppose la négociation par les pays d'une réduction des tarifs douaniers sur certains types de produits mais pas sur d'autres.
Contrairement aux apparences, le sectorialisme ouvert ne constitue pas la première étape d'un processus débouchant sur des accords commerciaux plus généraux.
Il peut en fait s'avérer une entrave à la négociation d'accords de plus grande envergure.
Car même si la négociation des accords sectoriels est couronnée de succès, ces derniers compromettent l'efficacité et la bonne marche de l'économie en protégeant les industries les moins compétitives, puisque chaque pays tente d'ouvrir le commerce dans les domaines où il est compétitif.
Aucun pays ne souhaite en effet ouvrir ses industries obsolètes à la concurrence étrangère.
Les conséquences économiques d'une telle position sont toutefois perverses.
Il suffit d'imaginer une Amérique ou une Europe qui n'aurait pas évolué depuis les années 50, dont l'économie dépendrait du charbon, de l'acier et du textile et qui ne serait pas exposée à la concurrence des producteurs meilleur marché d'Asie pour que le danger devienne évident.
Un autre danger provient du fait qu'en libéralisant le commerce uniquement pour quelques industries qui connaissent une réussite économique, le sectorialisme ouvert affaiblit plutôt qu'il ne renforce le soutien politique général dont dépendent les accords commerciaux internationaux qui profitent à la plupart des entreprises, des consommateurs et des pays.
L'Amérique est le partisan le plus fervent du sectorialisme ouvert, qu'elle a commencé à défendre au cours des négociations tarifaires du « zero to zero » qui se sont déroulées il y a plusieurs années, lors du cycle de pourparlers relatifs au commerce mondial de l'Uruguay Round.
Ces entretiens ont finalement abouti au démantèlement des barrières tarifaires dans dix secteurs clés.
Sous la pression des entreprises, les Etats-Unis ont négocié des accords dans le secteur des télécommunications, des technologies de l'information et des services financiers.
Le premier accord majeur, à savoir l'Accord sur les technologies de l'information (ATI), est entré en vigueur en 1997. Il concerne 90% des échanges de produits liés aux technologies de l'information dont la valeur s'élève à plus de 600 milliards de dollars par an.
L'Union européenne avalisa ensuite l'ATI après que son ambassadeur auprès des Etats-Unis, Hugo Paemen, y eut vu une preuve que les accords sectoriels contribuaient à contourner la résistance politique croissante à de nouvelles séries de négociations sur les échanges commerciaux.
Fort du soutien des deux acteurs les plus puissants sur la scène du commerce mondial, on a recherché depuis avec ardeur à reproduire le modèle de l'ATI dans d'autres secteurs.
Un Accord global sur les télécommunications de base a pris effet en 1998, suivi de l'entrée en application en avril 1999 d'un Accord sur les services financiers visant à libéraliser les échanges dans le secteur des opérations bancaires, de l'assurance, et des valeurs mobilières.
De tels accords, qui souvent éliminent non seulement les tarifs douaniers mais aussi d'autres barrières réglementaires, peuvent sembler inattaquables.
Mais les apparences sont trompeuses.
Etant donné que les puissants intérêts sectoriels qui ont encouragé la libéralisation lors du cycle d'Uruguay -- technologies de l'information, services financiers, télécommunications -- ont désormais leurs propres accords, le dynamisme qu'ils ont apporté par le passé à la cause d'une libéralisation du commerce plus étendue a nettement diminué.
Les Japonais estiment d'ailleurs que le soutien timide des groupes industriels américains à un nouveau cycle de négociations de l'OMC reflète la réussite des accords sectoriels antérieurs.
Aussi le Japon s'oppose-t-il désormais à la négociation d'un deuxième accord sur les technologies de l'information parce qu'il craint que celui-ci minera davantage le soutien politique à une libéralisation globale des échanges.
Les craintes sur l'avenir des négociations commerciales multisectorielles globales sont tout à fait fondées.
L'effort continu des délégués américains, par exemple, visant à cantonner la concertation aux échanges relatifs aux services et à l'agriculture, fait obstacle aux accords plus larges puisqu'il limite les arrangements possibles entre secteurs.
Par ailleurs, une approche secteur par secteur ignore immanquablement toute une série de problèmes au sein de l'OMC, tel que le règlement des différends, les pratiques antidumping et autres questions de ce genre.
L'expérience récente du forum de la Coopération économique Asie-Pacifique (APEC) souligne les limitations du sectorialisme ouvert et devrait susciter un réexamen minutieux de ce dernier.
Après l'entrée en vigueur de l'ATI, les Etats-Unis ont demandé instamment aux membres de l'APEC d'accélérer la libéralisation sur une base sectorielle afin de donner un nouveau souffle à un agenda commercial régional en perte de vitesse.
Mais les efforts pour conclure un accord destiné à libéraliser les échanges dans 15 secteurs n'ont pas tardé à faiblir : le prix de la libéralisation sélective dans les secteurs qui ne sont pas compétitifs, mais sensibles sur le plan politique, était tout simplement trop élevé pour certains gouvernements.
La leçon la plus importante qu'il faut retenir de l'échec de l'APEC consiste à reconnaître l'énorme difficulté rencontrée lors de l'élaboration d'un accord d'ensemble suffisamment général, mais politiquement acceptable, lorsque les négociations commerciales sont limitées à des bénéficiaires particuliers.
Etant donné que certaines industries ne se soucient plus des accords commerciaux internationaux puisqu'elles ont déjà tiré parti d'un accord sectoriel, les groupes qui en temps normal considèrent qu'ils ont tout à gagner d'une plus grande ouverture du commerce sont trop faibles pour contrebalancer l'influence politique des forces protectionnistes mobilisées contre la libéralisation.
Les dirigeants qui, de nos jours, sont séduits par le sectorialisme ouvert, en raison de la politique sans heurts qu'il promet, devraient prendre cette leçon à coeur.
Si l'on souhaite obtenir rapidement tous les avantages de la libéralisation du commerce, il n'y a pas d'autre solution que de reprendre les négociations globales -- et les arrangements entre industries que cette stratégie implique -- en ressuscitant le Cycle du Millénaire de l'OMC.
C'est cet agenda, plutôt que l'espoir fallacieux suscité par le sectorialisme ouvert, qui devrait être à l'avenir la première priorité des négociateurs commerciaux.
L'avenir de la Constitution européenne
L'Union européenne est aujourd'hui confrontée au défi de se recentrer sur les priorités présentes et futures.
Elle doit mieux communiquer avec ses propres citoyens afin de renouveler leur soutien en montrant que les Européens, lorsqu'ils travaillent conjointement, peuvent favoriser la croissance et l'emploi, combattre le crime mondial et garantir un environnement propre.
L'Union doit jouer un rôle plus actif dans le monde agrandi, non pour poursuivre des intérêts égoïstes, mais pour promouvoir les valeurs universelles sur lesquelles elle repose.
Surtout, l'Union agrandie a besoin d'un cadre constitutionnel et institutionnel à la mesure de ses ambitions.
Pendant trente mois, des gouvernements et des parlementaires ont travaillé sur une nouvelle Constitution pour l'Europe.
Un avant-projet exceptionnel a été préparé par la convention présidée par l'ancien président français Valéry Giscard d'Estaing.
Il appartient à présent aux gouvernements nationaux (le mien et ceux de mes collègues du Conseil européen) de terminer le travail.
Nous nous réunissons à Bruxelles cette semaine et notre priorité majeure sera de parvenir à un accord sur la Constitution.
Le consensus sur la majeure partie de l'avant-projet existe depuis un certain temps.
Tous s'accordent sur les valeurs et les objectifs de l'UE, sur l'inclusion de la Charte des droits fondamentaux et sur la simplification des processus législatifs.
Ce sont là des avancées majeures.
Mais les gouvernements nationaux manifestent inévitablement un intérêt particulier pour les pouvoirs des institutions de l'UE dans des domaines clés tels que la politique extérieure, le droit pénal et la taxation.
Telles sont les questions sur lesquelles les gouvernements doivent désormais s'entendre.
Tout au long des mois de contact et de négociations bilatéraux entre ministres, nous avons réussi à diminuer le nombre de questions en suspens jusqu'à un point rendant possible l'obtention d'un ensemble général équitable et équilibré.
Comme dans toute négociation, les ingrédients clés sont le choix du moment et la volonté politique.
Les gouvernements n'étaient tout simplement pas prêts en décembre dernier lors de la première tentative de finalisation de l'accord.
La décision du Conseil européen en mars de mettre fin aux négociations sous la présidence irlandaise a montré notre détermination inébranlable à sortir les négociations de l'impasse.
Au cours du mois dernier, j'ai rencontré tous mes collègues individuellement dans leurs capitales respectives.
Nous avons beaucoup parlé.
Je n'ai décelé aucun affaiblissement de leur détermination.
En fait, ils estiment que nous ne pouvons pas nous permettre d'échouer.
Au cours d'une période stimulante pour l'Union, cette dernière doit montrer que dans les moments difficiles, ses membres peuvent prendre des décisions collectives, bien que difficiles, dans l'intérêt commun.
Les équilibres institutionnels fondamentaux entre la Commission, le Conseil et le Parlement européen ne sont pas remis en question.
Mais les institutions de l'UE doivent être modernisées.
Une continuité et un centrage accrus seront apportés par la création d'un président à temps plein du Conseil européen et d'un ministre des affaires étrangères de l'UE, ainsi que d'une présidence d'équipe, composée de trois pays, afin de diriger les autres formations du Conseil.
Les gouvernements ont également accepté que le système de vote au sein du Conseil européen soit basé sur la double majorité de la population et des états membres.
Cette démarche est logique, transparente et représentative.
Mais les dispositions précises pour un vote à double majorité doivent être prises d'une manière qui respecte les préoccupations particulières de tous les états membres, tout en garantissant néanmoins que le nouveau système sera plus efficace que son prédécesseur.
Je pense que nous pouvons régler cette question fort difficile de manière équitable.
La Commission a pour tâche d'élaborer le programme de l'UE dans l'intérêt commun.
Un consensus se développe sur le fait que la " représentativité " et la légitimité puissent être obtenues en incluant les ressortissants de tous les états membres dans les deux Commissions suivantes, avant de passer à un nombre fixe plus petit basé sur un roulement strictement égal.
Il importe également de garantir que les citoyens de tous les états membres, grands et petits, soient suffisamment et convenablement représentés au Parlement européen.
La Constitution envisage de développer plus avant les fonctions importantes du Parlement, tant législatives que budgétaires, en partenariat avec les états membres.
En fait, pour la première fois, un rôle significatif de gardien est attribué aux parlements nationaux.
Ces dispositions préserveront la nature institutionnelle unique de l'UE (les équilibres entre ses institutions et entre les états membres) tout en offrant la perspective d'une efficacité et d'une transparence accrues.
La Constitution fera montre d'une avancée majeure supplémentaire dans l'utilisation du vote à la majorité, nécessaire dans une UE composée de 25 membres (et de bien d'autres dans les mois à venir).
Mais quelques sujets devront rester soumis à une décision unanime, de par leur nature spéciale.
Je pense que nous sommes sur le point de parvenir à un accord équilibré sur ce point.
Trop souvent, les questions complexes inhérentes à ce type de négociation sont présentées comme une bataille entre un pays et un autre, ou entre des idéologies concurrentes.
Ma longue expérience des négociations m'a appris que parler de gagnants et de perdants est non seulement inutile, mais fallacieux.
Chacun doit transiger, mais chacun doit également voir ses propres espoirs et ses propres inquiétudes reflétés dans le texte final.
Si nous réussissons cette semaine, ce succès marquera le triomphe de l'UE.
L'Europe représente la confluence de différentes traditions et histoires, et d'états souverains indépendants.
Mais nous sommes unis dans notre croyance que le partage de la souveraineté et la collaboration mutuelle constituent le meilleur (et, en effet, le seul) moyen de progresser.
L'adoption d'une Constitution implique la consolidation des divisions amères du passé et l'occasion de bâtir une Union au service de nos 450 millions de citoyens.
L'héritage de Palme: quinze ans après
STOCKHOLM: Il y a quinze ans, le 28 février, Olof Palme, Premier Ministre de la Suède, était assassiné.
Sa mort a choqué des millions de personnes dans le monde entier.
L'assassin n'a toujours pas été retrouvé, ou du moins il n'a pas été condamné.
Au-delà de Palme, ce crime visait la démocratie elle-même.
Assassiné, Palme fait maintenant partie de l'Histoire.
Mais l'Histoire doit être analysée librement et non censurée par déférence.
Aussi, lorsque nous nous remémorons le meurtre de Palme, nous devons aussi nous souvenir de ce qu'il a fait et de ce qu'il représentait.
Qu'en est-il, par exemple, de l'héritage de Palme en politique étrangère ?
Palme a été un critique puissant, éloquent des Etats-Unis et de la guerre au Viet-nam.
Il a lancé des imprécations contre l'oppression soviétique en Tchécoslovaquie et les meurtres du Général Pinochet au Chili.
A cause de ces positions, Palme a souvent été dépeint sous les traits d'un adversaire conséquent des tyrannies.
Ne "calomniez" pas l'Union Soviétique, a dit Palme, Président du Parti Social Démocrate suédois pendant 17 ans et Premier ministre de 1969 à 1976 et, de nouveau, de 1982 à 1986.
Ne vous engagez pas dans l'"agitation anti-Soviétique" ou "l'anti-soviétisme" a-t-il déclaré en 1984, une position neutre typique de la Suède de Palme.
Sans aucun doute, Palme reflétait l'esprit de son temps.
La renaissance Marxiste de l'Occident après 1968 a profondément impressionné journalistes et Socialistes, et la Suède n'a pas été en reste.
La guerre du Vietnam a changé la façon de voir le monde de beaucoup de jeunes gens.
Palme, cependant, a porté cet esprit vers l'avant longtemps après que d'autres ont aperçu la lumière libérale.
"Ni le communisme ni le capitalisme ne représentent un rêve de liberté pour les peuples d'Europe" a-t-il dit seulement quelques années avant que les peuples d'Europe de l'Est et d'Europe Centrale ne se libèrent du communisme pour embrasser la démocratie et le capitalisme.
Palme a aussi exploité des différences idéologiques diplomatiques pour blesser les autres partis démocratiques suédois.
Les conservateurs tombent dans "l'esprit de croisade, visant la libération de l'Europe de l'Est, qui a prévalu dans les quartiers conservateurs de l'Ouest pendant la Guerre Froide" a-t-il dit en 1983 à un moment de grande tension entre l'Occident et l'URSS.
Finalement, les libéraux et les conservateurs suédois sont arrivés au pouvoir en 1976, après 44 ans de férule socialiste.
Aucune des menaces pesant sur la politique étrangère de la Suède, que Palme avait prévues avec certitude, ne s'est matérialisée au cours de leurs neufs années d'exercice pendant le dernier quart de siècle.
Après avoir divisé son pays, Palme a fait son possible pour diviser l'Occident à un moment critique.
Dans les années 80, les Sociaux-Démocrates en Suède et en Allemagne développèrent une étroite coopération idéologique en politique étrangère.
La soi-disant "Commission Palme" (dont était membre l'influent Egon Bahr) suggéra une politique de "sécurité commune" entre l'Est et l'Ouest, et des zones d'exclusion d'armes nucléaires à la place de la politique de l'OTAN pour le déploiement des missiles de croisière et Pershing II dans le but de contrer l'avantage Soviétique sur le plan des armes nucléaires.
Cette collaboration entre les deux partis a mené à de sérieuses distorsions des valeurs occidentales fondamentales.
Palme et Oskar Lafontaine, qui était alors un des leaders de l'opposition en Allemagne, n'ont pas vu que la Guerre Froide était essentiellement un conflit entre la liberté et la tyrannie.
Quand Palme a visité l'Allemagne de l'Est en 1984, il n'y a jamais critiqué la répression, ni le Mur de Berlin.
Au lieu de ça, Palme a félicité le dirigeant de l'Allemagne de l'Est, Erich Honecker, en soulignant leurs buts communs et leur combat mutuel pour la paix et le développement.
Le discours principal de Palme évoquait la "détente", la "confiance" et "l'amitié" mais jamais "la liberté".
Il s'est passé à peu près la même chose quand Palme a visité Cuba.
Il a partagé un podium avec Fidel Castro lors d'un rassemblement de masse à Santiago de Cuba.
Palme a parlé sur un ton élogieux de "révolution socialiste" sans jamais mentionner la conviction de son propre parti qui était que la "révolution" devait avoir lieu seulement après des élections libres et honnêtes.
Palme, en effet, a utilisé des slogans marxistes mais n'a rien dit au sujet des droits de l'homme et de la liberté politique, donnant ainsi l'impression que la Suède et Cuba avaient des idéologies similaires.
Lors d'un communiqué commun avec Castro, Palme a affirmé que les deux hommes étaient du même avis sur tous les sujets dont ils avaient discuté.
Ils ont même confirmé leur joie de voir que les combats pour la liberté des "peuples vietnamiens et cambodgiens aient été couronnés de succès".
Cela a été dit au cours de l'été 1975, deux mois après que les Khmers Rouges cambodgiens se sont lancés dans un génocide qui a tué deux millions de personnes sur les sept millions que comptait le pays.
Est-ce qu'Olof n'avait pas conscience des massacres perpétrés par Pol Pot ?
Les journaux de presque toutes les démocraties, y compris la Suède, nous informaient des horreurs que vivait le Cambodge.
Mais Palme a trouvé plus important de montrer un front uni avec le tyran cubain que de se soucier des atrocités commises par les Communistes en Indochine.
Palme a rarement condamné l'oppression dans les pays du Tiers Monde.
Il n'a jamais critiqué la Chine de Mao, le régime le plus meurtrier de l'après Seconde Guerre Mondiale, mais a constamment condamné l'apartheid en Afrique du Sud.
Ce "deux poids, deux mesures" a été particulièrement pernicieux au Moyen- Orient, où Palme n'a jamais censuré un pays arabe, sans tenir compte de son niveau de corruption ou de cruauté.
Le seul pays qu'il y a attaqué de façon répétée était la seule démocratie de cette région, Israël.
Il a même comparé les Israéliens aux Nazis.
Quinze ans après son assassinat, la Suède et l'Ouest doivent se débattre avec ce que Palme a laissé derrière lui, son agitation anti-occidentale et son désir de voir les idéaux fondamentaux de la liberté comme de simples notions relatives.
C'est cet aspect de son prétendu moralisme qui devrait être rappelé.
L'ancien dans le nouveau anti-sémitisme
Pourquoi tant de survivants de l'Holocauste pressentent-ils les menaces anti-juives naissantes avant de les voir ?
Parce qu'ils savent comment les insinuations soi-disant « innocentes » se transforment en accusations et comment ces accusations peuvent se transformer en discrimination et bientôt après devenir lois.
C'est alors que l'hystérie est libérée.
En ce faisant, ils renforcent nos démocraties comme aucune autre personne ne le peut.
Nous écoutons les survivants afin de survivre.
Il est évident que nous avons raison de les écouter, comme le démontrent les résultats du premier tour de l'élection présidentielle française.
Mais il n'y a pas que les démagogues tels que Jean-Marie Le Pen et d'autres personnes de l'extrême droite populiste qui incitent à la discorde.
Tout au long du 20
Prenez le cas de l'ambassadeur de France en Grande-Bretagne.
Lors d'un dîner à Londres il n'y a pas si longtemps, il décrivait Israël comme « ce petit pays de merde ».
Ses commentaires vulgaires ne sont pas particulièrement effrayants.
C'est la réaction qu'ils ont suscitée qui est inquiétante.
Il n'a pas été rappelé par son gouvernement ; le gouvernement de Tony Blair n'a pas demandé son rappel ; l'opinion publique a simplement traité l'anecdote comme un scandale banal.
En effet, la presse française a considéré que l'ambassadeur était la victime de la presse tabloïde anglaise, et non de ses sentiments méprisables.
Malheureusement, l'ambassadeur de France à la cour de St. James dispose de nombreux alliés parmi les élites européennes.
Mais M. Bernard, l'ambassadeur, nous a rendu service : il nous à aidé à prendre conscience de l'ampleur de cette nouvelle forme d'antisémitisme.
Comme l'a dit en particulier un chroniqueur, Israël est devenu « l'objet d'une haine qui n'ose pas dire son nom ».
Mais nous ne devons pas seulement oser, nous sommes obligés de parler.
Nous ne devons pas rester silencieux devant les attaques quotidiennes menées en France contre les juifs et les synagogues.
C'est une honte pour l'Europe entière que de nombreux juifs français ne puissent pas envoyer leurs enfants à l'école sans s'inquiéter de leur sécurité.
On retrouve ces affronts antisémites également partout ailleurs : à Berlin et à Londres, en Suisse, en Italie, en Suède, aux Pays-Bas, et dans certains pays d'Europe de l'Est.
Nous ne devons pas rester silencieux sur le fait que la dénégation de l'Holocauste est en train de devenir une habitude ; de même que les parallèles établis par les antisémites/anti-sionistes entre Israël et le Troisième Reich.
Nous devons « affronter le nouveau fléau nazi qui niche en Israël », écrivait un journal syrien tandis que la télévision palestinienne dépeint les soldats israéliens comme des violeurs et des meurtriers impitoyables.
Le mufti de Jérusalem a déclaré que « ce n'est pas de [sa] faute si Hitler haïssait les juifs, il les haïssait où qu'ils se trouvent ».
Le sermon du vendredi de la télévision palestinienne exhortait les Musulmans « à n'avoir aucune clémence envers les juifs, peu importe où [qu'ils soient]... tuez-les... ainsi que tous ces Américains qui leur ressemblent ».
Nous ne pouvons oublier, à propos de l'antisémitisme, que bien qu'il commence toujours avec les juifs, il ne s'arrête jamais avec eux.
La haine des juifs, si elle n'est pas contenue, se développe quasiment toujours en agression sur d'autres groupes et minorités et mine en fin de compte les institutions démocratiques et la loi.
Ainsi la lutte contre l'antisémitisme unit les juifs tout autant que les non-juifs.
Mais cette lutte est désormais bien plus diffuse que jamais car l'antisémitisme actuel possède une faculté étonnante : la souplesse.
Bien que l'antisémitisme n'ait jamais changé d'objectif - attaquer les Juifs - il change de visage, de stratégie, de justification, et même de vocabulaire.
La religion juive fut jadis la cible de persécutions.
Lorsque le judaïsme ne capitulait pas, les juifs étaient expulsés ou massacrés.
Au 19
Je n'assimile pas la critique d'Israël à de l'antisémitisme.
Il est tout aussi légitime de s'opposer à certaines politiques et décisions israéliennes que d'examiner attentivement toute nation.
Mais l'anti-sionisme commence à ressembler à l'antisémitisme.
Parfois, certains anti-sionistes déclarent qu'ils ne sont pas contre les juifs, mais qu'ils sont « uniquement » contre l'État juif.
Mais supposons que quelqu'un déclare un jour : « Je suis uniquement contre l'existence de la Grande-Bretagne, je ne suis pas anti-britannique! »
Ou que quelqu'un me déclare : « J'aime les Suédois, mais la Suède doit être supprimée ».
Vous ne les croiriez pas.
Il est dur d'aimer ou de respecter un peuple et de haïr son État.
Cependant les gens prétendent que c'est le cas avec Israël.
Dans plusieurs bureaux de l'ONU, rabaisser Israël est devenu une habitude.
Cette diabolisation de la seule démocratie du Moyen-Orient occupe une place centrale dans le nouvel antisémitisme.
Lorsque Israël est décrit « comme l'ennemi du bien et le dépositaire de tout ce qui est mauvais », affirme le professeur Irwin Cotler, membre du parlement canadien, cela revient à « enseigner le mépris » au sein de l'ONU.
Cette constante distinction d'une nation en tant qu'ennemi de l'humanité est en fait une campagne dirigée contre le peuple juif.
En effet, beaucoup de manifestations antisémites dans de nombreux pays prennent racine dans les condamnations d'Israël qui exploitent la terminologie antisémite.
Les attaques contre les synagogues sont souvent déclenchées par un langage diffamatoire sur le Moyen-Orient.
Comparé aux précédentes éruptions, l'antisémitisme d'aujourd'hui constitue moins une attaque sur les Juifs en tant qu'individus qu'une attaque sur le « juif collectif », l'État d'Israël.
De telles attaques ont toutefois entraîné une réaction en chaîne d'agressions à travers l'Europe et l'Amérique latine contre les juifs et les institutions juives.
Dans le passé, les antisémites les plus dangereux étaient ceux qui cherchaient à rendre le monde Judenrein, sans juifs.
Aujourd'hui, les antisémites les plus dangereux sont ceux qui souhaitent rendre le monde Judenstaatrein , sans État juif.
Une poule mouillée peut-elle désarmer Saddam ?
chef des inspecteurs en désarmement de l'ONU et l'Irak se sont mis d'accord sur un calendrier provisoire pour la conduite des inspections, qui en théorie pourraient commencer dans deux semaines.
Mais le succès d'un tel accord dépend autant des hommes qui conduiront les inspections que des détails de lieux et de calendrier, ainsi que de la manière dont ces inspections seront menées.
Hans Blix dirige les inspections en désarmement de l'ONU qui doivent permettre de chercher, trouver et détruire les armes de destruction massive de Saddam Hussein.
Je connais M. Blix depuis plus de quarante ans.
En 1960, il m'assistait alors que je dirigeais l'Association suédoise des jeunes libéraux.
Depuis, j'ai suivi sa carrière de près.
Il fut ministre des Affaires étrangères de la Suède pendant un an avant de prendre le poste de directeur général de l'Agence Internationale de l'Énergie Atomique (AIEA) à Vienne.
Il m'est difficile de trouver les hommes politiques européens moins aptes que lui pour un face-à-face avec Saddam Hussein.
En fait, je n'en croyais pas mes yeux quand j'ai suivi le journal télévisé annonçant les négociations entre M. Blix et les hommes de confiance du dictateurs irakien.
Tout le monde sait à quoi s'en tenir quant aux faiblesses de M. Blix puisqu'il a déjà largement démontré son incapacité notoire.
Quand M. Blix dirigeait la AIEA, avant la Guerre du Golfe de 1991, il assurait avec insouciance à tout le monde, après plusieurs inspections, que la situation irakienne n'était pas alarmante.
Il produisit le rapport favorable que Saddam espérait le voir produire alors qu'il commençait à cacher ses ambitions et ses usines d'armement nucléaire.
Depuis, nous avons appris sans aucune ambiguïté possible que Saddam est obsédé par l'acquisition d'armes de destruction massive : les ogives chimiques et biologiques ainsi que les bombes atomiques et les missiles nécessaires à leur lancement.
D'anciens experts des programmes d'armement nucléaire irakiens ayant fui Bagdad pour passer à l'Ouest l'ont confirmé.
Ils ont raconté les efforts déterminés et coûteux mis en place pour l'acquisition de la puissance nucléaire.
En fait, il est maintenant clair qu'il ne fallait guère plus d'un an à Saddam pour s'approprier sa première bombe atomique quand la Guerre du Golfe fut déclenchée.
Après ce conflit, les inspecteurs de l'ONU trouvèrent et détruirent d'importants stocks d'ogives chimiques et biologiques ainsi que les installations nécessaires à la production d'armes atomiques.
En dépit de ses graves manquements en qualité de directeur de l'AIEA avant 1991, M. Blix fut une fois de plus nommé à la tête des inspecteurs en désarmement de l'ONU, accompagné cette fois d'un autre suédois, l'ambassadeur Rolf Ekéus.
M. Blix, naïf et relativement ignorant des détails techniques (c'est un spécialiste de la législation internationale), est facilement trompé.
Même après la guerre du Golfe, il ne parvint pas à déceler que les officiels irakiens qui, une fois de plus, assuraient l'ONU qu'ils n'avaient rien à cacher, n'étaient que d'éhontés menteurs.
En fait, M. Blix crut que l'Irak n'avait aucun programme d'armement nucléaire.
David Kay, peut-être l'inspecteur le plus efficace, persista à ne pas leur faire confiance.
Mais M. Blix reprochait à M. Kay son attitude.
Vous devez faire confiance aux informations officielles, sous-entendait M. Blix.
L'événement décisif se produisit quand M. Kay se lança dans des inspections de bâtiments suspects sans notifier d'avance les Irakiens de ses intentions.
Cette nouvelle stratégie d'inspection agressive eut des conséquences dramatiques : M. Kay découvrit les preuves confirmant que l'Irak n'était plus qu'à quelques mois de se lancer dans la production d'armes nucléaires.
Cette découverte historique mena à une confrontation sur un parking de Bagdad.
Les véhicules de l'ONU furent cernés par 200 soldats irakiens et toute une clique, et des représentants irakiens qui leur ordonnèrent de quitter les lieux.
Le siège se poursuivit pendant quatre jours et quatre nuits, tandis que M. Kay et ses collègues utilisaient leurs téléphones pour faxer via satellite des documents cruciaux vers l'Ouest.
M. Blix s'était opposé à ce raid.
Heureusement, l'ambassadeur, M. Ekéus l'appuya et soutint les inspecteurs pendant le siège.
J'ai rencontré un certain nombre d'experts dans le domaine des armes de destruction massive irakiennes et ils comparent souvent les deux Suédois : « M. Ekéus est brillant », disent-ils, « et M. Blix est terrible ».
Quand le groupe d'inspecteurs actuel fut mis sur pied, en 1999, MM. Ekéus et Blix faisaient tous deux partie des candidats possibles pour la direction de ce nouveau groupe d'inspecteurs.
Les sympathisants irakiens de Paris et de Moscou consultèrent Bagdad pour déterminer qui avait la préférence de Saddam.
La France et la Russie suggérèrent alors M. Blix.
Étrangement, le gouvernement Clinton accepta cette décision.
Les armes chimiques et biologiques de Saddam, et sa détermination à acquérir des armes nucléaires, représentent une menace pour le monde.
Ce dictateur pourrait utiliser ces armes lui-même ou les mettre à disposition d'organisations terroristes.
Et la question de la guerre ou de la paix dépend d'un homme qui a été maintes fois trompé par le régime irakien.
Le gouvernement Bush comprend probablement les faiblesses de M. Blix.
Il est fort probable que les États-Unis ne laisseront pas l'Irak tromper une fois de plus M. Blix et les inspecteurs qu'il dirige.
Quel que soit le déroulement de cette crise à partir d'aujourd'hui, l'ONU a négligé son devoir en demandant à une poule mouillée de diriger les inspecteurs qui sont censés affronter la brute de Bagdad.
L'Hérésie de l'ONU
Aucune autre organisation n'est autant respectée que les Nations unies.
Ceci est peut-être naturel, puisque l'ONU personnifie certains des rêves les plus nobles de l'humanité.
Pourtant, comme le montre le scandale actuel autour de la gestion onusienne du programme d'échange de vivres contre du pétrole en Irak, au moment où la communauté internationale se remémore le génocide rwandais qui se produisit il y a dix ans, le respect de l'ONU devrait être considéré comme une sorte de superstition, et le Secrétaire général, Kofi Annan, comme son faux prophète.
Depuis Dag Hammarskjöld, aucun autre leader des Nations unies n'avait été autant acclamé que Kofi Annan.
Et ceci est compréhensible, dans une certaine mesure.
Annan garde habituellement une attitude imperturbable, empreinte de dignité.
Il possède un certain charme, et selon certains un certain charisme.
Cependant, un leader doit se juger à l'aune de ses actes quand les situations en jeu sont importantes.
Les échecs d'Annan dans de telles situations sont presque toujours dissimulés.
Entre 1993 et 1996, Annan fut Sous-Secrétaire général adjoint aux opérations de maintien de la paix puis Sous-Secrétaire général.
Le massacre serbe de 7 000 personnes dans la ville bosniaque de Srebrenica est l'une des deux grandes catastrophes où sa responsabilité est largement impliquée, le pire massacre que l'Europe d'après-guerre ait jamais connu.
En 1993, il fut promis aux musulmans de Bosnie que les forces onusiennes les protégeraient.
Cet engagement représentait la condition sine qua non de leur désarmement.
Les Nations unies déclarèrent que Srebrenica était un " lieu sûr " que 600 casques bleus néerlandais allaient " protéger " au nom des Nations Unies.
En juillet 1995, les forces serbes attaquèrent et les Nations unies ne respectèrent pas leur serment.
L'administration d'Annan publia des communiqués confus et évasifs.
Inconscients, apparemment, de la gravité de la situation, elle fut incapable d'alerter la communauté internationale de manière appropriée et n'intervint pas.
Les casques bleus néerlandais ne tirèrent pas une seule fois.
La puissance aérienne de l'OTAN aurait pu arrêter les Serbes mais Annan ne demanda pas à l'OTAN d'intervenir.
Ratko Mladic, commandant serbe et criminel de guerre, déporta les femmes et les enfants sous les yeux des Nations unies tandis qu'il capturait et assassinait les hommes et les adolescents.
Personne ne devrait s'étonner de l'inaction des Nations unies, puisque l'année précédente, elles avaient fait preuve de leur totale incompétence à faire face au génocide le plus rapide de l'histoire : le massacre de 800 000 Tutsis modérés et les Hutus au Rwanda en quelque 100 jours.
Les forces des Nations unies au Rwanda en 1994 relevaient de la responsabilité d'Annan avant et pendant la crise.
Annan fut alerté quatre mois avant que les activistes Hutus n'entament leurs assassinats de masse par un fax du général canadien Roméo Dallaire, commandant des forces des Nations unies au Rwanda.
Dallaire décrivait en détail comment les Hutus préparaient " l'extermination anti-Tutsi ".
Il indiqua que sa source était " un Hutu " et que l'armement nécessaire avait été rassemblé pour le nettoyage ethnique qui se préparait.
Dallaire demanda la permission d'évacuer son informateur et de saisir les caches d'armes.
Annan rejeta ces deux demandes et proposa à Dallaire d'informer le Président rwandais, Habyarimana, un Hutu, de l'identité de son informateur bien que ce dernier ait expressément indiqué que l'entourage proche du Président était à l'origine du plan d'attaque du génocide.
Annan est resté d'une passivité extrême, même après le crash de l'avion où le Président Habyarimana trouva la mort, qui fonctionna comme déclencheur du génocide, facilité par l'indifférence des super-puissances (l'Amérique entre autres).
On pourrait penser qu'Annan s'était bien trop compromis pour le poste de Secrétaire général, mais ce n'est pas ainsi que fonctionnent les Nations unies.
Au lieu d'être obligé de démissionner après les événements du Rwanda et de Srebrenica, il fut promu Secrétaire général.
C'est la culture des Nations unies : croire les meilleurs des barbares, ne rien faire pour provoquer la controverse chez ses supérieurs et laisser à d'autres le rôle de cible pour les critiques après coup.
Même les révélations faites par la suite sur les responsabilités d'Annan dans les catastrophes rwandaises et bosniaques n'ont pas entamé sa position.
Bien au contraire, il fut réélu à l'unanimité et reçu le prix Nobel de la paix.
C'est le diplomate téflon par excellence.
Les médias font parfois grimper l'admiration pour Annan en précisant que sa femme est suédoise et une parente proche de Raoul Wallenberg.
Il nous faut donc en conclure qu'en plus de tous ses talents, Annan partagent les idéaux personnifiés pendant les derniers jours de la Deuxième guerre mondiale par le plus célèbre des Suédois des temps modernes.
Mais le nom de Wallenberg devrait nous consterner davantage quant au dossier Annan.
Wallenberg refusa d'ignorer la menace des massacres à venir et au lieu de laisser tomber ses responsabilités et de s'adonner à des tâches conventionnelles en Suède, il fit chemin jusqu'en Hongrie, scène de la dernière orgie homicide d'Hitler contre les juifs.
À Budapest, Wallenberg exploita le moindre contact disponible, ayant recours à des tours douteux, à la corruption, et à d'autres stratagèmes pour sauver de l'holocauste autant de personnes que possible.
Il ne se laissa jamais duper par la clique d'Hitler.
Peut-être ne devrait-on jamais juger le succès de quelqu'un en le comparant au succès de Wallenberg - un titan d'une force, d'un courage et d'une persévérance certains.
Le problème avec Annan est que, quand des événements similaires se sont produits, il fit véritablement défaut.
Annan ne peut pas dire qu'il craignait personnellement pour sa sécurité, tandis que Wallenberg en 1944 et 1945 était constamment en danger.
Pas plus qu'il ne peut vraiment s'excuser en décrétant qu'il ne fut pas averti ou qu'il manquait de ressources ou encore qu'il n'avait pas la position internationale nécessaire pour intervenir.
Annan avait à sa disposition tous les instruments de pouvoir et d'opinion qui manquèrent à Wallenberg.
Et pourtant quand des milliers ou des centaines de milliers de personnes furent soumises à des menaces de mort qu'il avait l'autorité et le devoir d'empêcher, de soulager ou du moins d'annoncer, il échoua misérablement.
Maintenant, en dépit des révélations récentes sur la corruption à l'œuvre au sein du programme onusien d'échanges de produits essentiels contre du pétrole en Irak, la communauté internationale s'apprête à mettre entre les mains d'Annan le futur de plus de 20 millions d'Irakiens qui ont survécu à la dictature dépravée de Saddam Hussein.
Cela est dû aussi bien à Annan et ce qu'il est qu'à ce que sont devenues les Nations unies : une institution où aucun défaut, semble-t-il, ne reste infructueux.
De l'antisémitisme à l'antiaméricanisme
L'antisémitisme, l'anti-sionisme et l'antiaméricanisme sont de plus en plus virulents et accointés les uns aux autres dans l'Europe d'aujourd'hui.
Ils trouvent leur source dans une espèce d'aveuglement combiné avec un étrange mélange d'aliénation, de sentiment de culpabilité et de peur envers Israël et les USA.
Des millions d'Européens évitent de voir en Israël un pays qui lutte pour sa survie.
Israël ne peut se permettre de perdre une seule guerre d'importance, car ce serait la fin de cet Etat juif et démocratique.
Mais beaucoup d'Européens pensent que les Israéliens font une erreur à la base : ils se refusent à tout compromis et préfèrent utiliser les moyens militaires pour résoudre des problèmes politiques.
L'attitude européenne est sensiblement la même à l'égard des USA.
"Regardez l'Europe", disent nombre d'Européens, "Nous avons éradiqué la guerre, les dangers du nationalisme et la dictature.
Nous avons crée une Union européenne pacifique.
Nous ne faisons pas de guerre, nous négocions.
Nous ne gaspillons pas nos richesses dans l'armement.
C'est la "suédisation" de l'Europe.
Il est vrai que l'existence de l'Union européenne tient du miracle sur un continent qui a donné naissance à deux totalitarismes, le communisme et le nazisme, qui sont à l'origine de gigantesques bains de sang.
Mais l'Europe oublie comment ces idéologies ont été vaincues.
Sans l'armée américaine, l'Europe de l'Ouest n'aurait pas été libérée en 1945.
Sans le plan Marshall et l'OTAN, elle n'aurait pas redémarré économiquement.
Sans la politique de confinement sous le parapluie américain, l'Armée rouge aurait étouffé le rêve de liberté en Europe de l'Est et aurait unifié l'Europe, mais sous un drapeau d'étoiles rouges.
Les Européens de l'Ouest ont aussi oublié que certaines régions du monde n'ont jamais connu la liberté.
Dans beaucoup de pays, les salles de torture sont la norme et non pas des bavures grotesques et honteuses de troupes mal encadrées.
Dans ce contexte, toute tentative de se comporter à l'européenne en négociant - sans la force militaire pour appuyer la diplomatie - est tout simplement vouée à l'échec.
Plutôt que d'aider ceux qui combattent le terrorisme international, beaucoup d'Européens rejettent la responsabilité de son accroissement sur Israël et les USA ; c'est une nouvelle illusion européenne.
Que se serait-il passé si l'Espagne et toute l'Europe avaient réagi d'une manière diamétralement opposée à l'attentat de Madrid en avril en disant : "A cause de ce massacre, nous allons redoubler d'effort dans notre engagement pour stabiliser l'Irak en envoyant deux fois plus de troupes, d'experts, d'ingénieurs, de professeurs, de policiers, de médecins, ainsi que des milliards de dollars pour aider les forces alliées et leurs partenaires irakiens."
Le triomphe des terroristes aurait été transformé en un triomphe de la guerre contre le terrorisme.
L'image que beaucoup d'Européens se font de l'Amérique et d'Israël crée un climat politique propice à de terribles préjugés.
Pour la propagande anti-sioniste moderne, Israël cherche à dominer tout le Moyen-Orient.
Ces idées se retrouvent dans les sondages qui montrent que les Européens voient dans Israël et les USA les véritables obstacles à la paix dans le monde.
L'écrivain britannique Ian Buruma estime que la rage antiaméricaine et anti-israélienne de l'Europe touche à un sentiment de culpabilité et de peur.
Les deux guerres mondiales ont conduit à de tels carnages que le "jamais plus çà" a été traduit en "bien-être chez soi et non-intervention à l'extérieur".
Le problème avec cette idée est qu'elle ne peut être appliquée que sous la protection de la puissance américaine.
L'extrémisme antiaméricain et anti-sioniste sont en train de fusionner.
Le slogan soi-disant pacifiste "Hitler a deux fils : Bush et Sharon" qui fleurit en Europe dans les manifestations contre la guerre banalise le nazisme tout en diabolisant ses victimes et ceux qui l'ont défait.
Cela vient en grande partie d'un sentiment de culpabilité sous-jacent de l'Europe qui est lié à l'Holocauste.
Les victimes de l'Holocauste - avec leurs enfants et leurs petits-enfants - feraient aux autres ce qu'on leur a fait.
En mettant sur le même plan l'assassin et sa victime, nous nous en lavons les mains.
Ce mélange d'anti-sionisme et d'antiaméricanisme revient sans cesse.
Le "méchant Israélien" et le "méchant Américain" semblent faire partie d'une même famille.
C'est la version moderne du vieux mythe qui veut que ce soient les Juifs qui gouvernent les USA.
Récemment, le rédacteur en chef de Die Zeit , Josef Joffe, a mis le doigt sur le fond du problème : comme les Juifs, les Américains seraient égoïstes et arrogants.
Comme les Juifs, ils seraient prisonniers du fondamentalisme religieux qui leur donne la conviction d'être dans leur droit et les rend dangereux.
Comme les Juifs, les Américains seraient des capitalistes avides pour lesquels l'argent est la valeur première.
"Les USA et Israël ont été fondés par des exclus, tout comme les Juifs l'ont été de tout temps", explique-t-il.
Les liens entre l'antisémitisme, l'anti-sionisme et l'antiaméricanisme sont indéniables.
A moins que les dirigeants européens condamnent sans ambiguïté cette triple alliance sinistre, elle va empoisonner la politique au Moyen-Orient et les relations transatlantiques.
Course aux armements en Europe et en Asie
Lorsque l'unification de l'Europe a été lancée, on pensait que cette " union sans cesse plus étroite " créerait une communauté capable de protéger les Européens du chantage politique.
On constate aujourd'hui -- même si la levée de l'embargo de l'UE sur les ventes d'armes à la Chine pourrait être retardée par les pressions américaines et l'agressivité chinoise - que l'Union européenne n'est plus qu'un instrument de corruption, utilisé par la France et la Chine pour des plans d'action conjoints.
La situation est d'une simplicité impitoyable : la plus grande dictature au monde se prépare à écraser et à occuper la première démocratie chinoise de l'histoire, Taiwan.
Et elle a besoin pour cela d'un arsenal beaucoup plus perfectionné que celui qu'elle possède pour le moment.
Les Etats-Unis n'exportent naturellement pas de telles armes vers la Chine, et essayent au contraire de dissuader les dirigeants chinois de lancer une attaque militaire contre les démocrates de Taiwan.
Mais si l'Union européenne proposait à la Chine des exportations importantes de systèmes militaires offensifs puissants, l'Armée populaire de libération pourrait venir à bout de la défense taiwanaise.
Plus de 600 missiles, déjà déployés sur le continent, sont orientés vers des villes et des installations militaires de l'île.
Pour le moment, le danger n'est pas très réel.
La Russie vend certaines armes à la Chine, mais évite d'exporter ses systèmes les plus perfectionnés, car le Kremlin considère la Chine comme une menace future potentielle.
Mais si des pays de l'UE commencent à se faire concurrence pour gagner des parts du marché chinois, les Russes pourraient bientôt être tentés de vendre leur meilleur matériel au régime communiste de Beijing.
Ce nouvel armement de la Chine, dans le contexte de la crise nord-coréenne, risque de pousser une demi-douzaine de pays de la région à renforcer leurs capacités militaires.
En levant l'embargo sur les ventes d'armes à la Chine, l'UE pourrait encourager une course aux armements dans l'est de l'Asie.
Comment la Chine et la France ont-elles réussi à convaincre l'UE d'envisager de participer à une telle initiative ?
Quand le gouvernement de Jacques Chirac a décidé de développer sa coopération économique avec la Chine, les armes sont devenues un élément stratégique essentiel.
Tout comme le Premier ministre Chirac avait vendu un réacteur nucléaire à Saddam Hussein dans les années 70, le Président Chirac se laisse aujourd'hui persuader de faire affaire avec une autre dictature agressive.
Pour le reste, il s'agit de chantage économique.
Les diplomates français ont bien entendu informé la Chine des réticences d'autres pays européens quant à la levée de l'embargo, imposé après le massacre de la place Tiananmen en 1989.
La Chine a alors simplement menacé d'abandonner ses accords commerciaux ou de ne plus jamais en conclure avec ces membres de l'UE.
En Allemagne, les Chinois doivent murmurer en coulisses Siemens et Volkswagen , et aux Pays-Bas, Philips .
La Chine suit les luttes de pouvoir au sein de l'UE par l'intermédiaire de ses amis français, et sait donc quels gouvernements elle doit mettre au pas.
En Suède, il a probablement suffi de chuchoter Ericsson et Volvo pour que le Premier ministre Göran Persson prenne conscience des enjeux commerciaux pour son pays.
En effet, quel pays européen oserait mettre en péril une commande chinoise de plusieurs milliards d'euros ?
Bien entendu, aucun pays de l'UE n'a évoqué Taiwan pour ne pas reprendre les exportations.
L'Union parle de " code de conduite " (ce qui ne veut pas dire grand chose, mais fait bon effet) et de " libre-échange " (euphémisme charmant pour désigner la vente d'armes à des régimes dictatoriaux).
Ce silence est du plus mauvais augure.
En pratique, l'UE fait savoir à la Chine que le problème taiwanais n'est pas le sien.
Si l'Union lève l'embargo, elle déclinera toute responsabilité dans une catastrophe éventuelle.
Comme d'habitude, c'est aux Etats-Unis qu'il incombe de venir à la rescousse d'un peuple libre pour éviter sa destruction.
Il y a soixante ans, les troupes et les armes américaines ont libéré l'Europe occidentale du joug nazi.
Bientôt, des armes européennes pourraient être utilisées par les Chinois contre des troupes américaines tentant de protéger une démocratie de 23 millions d'âmes (une population équivalente à celle de tous les pays nordiques réunis).
Comme l'a déclaré Tom Lantos, un député démocrate californien, l'Union européenne a perdu son sens moral.
Et Tom Lantos sait de quoi il parle : enfant, à Budapest, il fut sauvé de la déportation vers Auschwitz par Raoul Wallenberg.
Wallenberg était suédois.
Et pourtant la Suède fait elle aussi preuve aujourd'hui d'un manque de moralité politique.
Plusieurs de mes amis du groupe parlementaire conservateur sont engagés depuis longtemps en faveur de Taiwan.
Au cours des dix dernières années, nous avons organisé des conférences scandinaves sur Taiwan aux parlements de Copenhague, d'Oslo et de Stockholm.
Mais une intervention du Premier ministre suédois a suffi à amadouer le dirigeant du parti conservateur, Fredrik Reinfeldt.
Göran Persson n'avait pas la majorité au parlement suédois pour lever l'embargo, mais il semble être parvenu à ses fins grâce au mot magique, Ericsson .
Reinfeldt est ainsi le premier dirigeant du parti conservateur dans l'histoire de la Suède à encourager les exportations d'armes vers une dictature communiste.
Pourtant Reinfeldt, comme Chirac, a oublié quelque chose : aux prochaines élections, les libéraux pourraient bien vouloir autre chose qu'un premier ministre cynique ou un autre.
Ils préféreront peut-être un choix plus marqué.
L'ONU doit être au service de la liberté !
Pour mon pays, la Suède, l'ONU était jusqu'à présent une vache sacrée.
Mais aujourd'hui, beaucoup de Suédois, comme beaucoup d'autres peuples dans le monde, considèrent l'ONU d'un autre œil.
Trois scandales expliquent ce revirement.
Il y a d'abord eu ce qui est sans doute le génocide le plus rapide jamais perpétré, le massacre de plus de 800.000 personnes au Rwanda en moins de 100 jours en 1994.
Il est clairement établi que Kofi Annan qui était alors vice-secrétaire général de l'ONU a interdit aux forces de l'ONU d'intervenir pour protéger les victimes.
Qu'il ait ensuite pu être nommé secrétaire-général de l'ONU malgré un échec de cette ampleur reste un mystère.
Les questions que cela pose sur l'ONU et sur Kofi Annan lui-même sont confortées par le scandale en cours lié au programme Pétrole contre nourriture de l'ONU.
Même si à ce jour Kofi Annan n'a pas été impliqué directement, ses erreurs de gestion sont évidentes.
Le troisième scandale est peut-être le plus désespérant, car il touche le défaut structurel et permanent de justice et d'éthique a l'intérieur même des principaux organes de l'ONU, notamment la Commission des droits de l'homme.
Ces dictatures ennemies de la liberté se tiennent cois sur la torture, l'oppression et les massacres perpétrés par les autres dictatures, mais elles sont toujours prêtes à s'élever contre les démocraties, en particulier les Etats-Unis.
Après plus de trente ans passés à l'ONU, même Kofi Annan a fini par admettre du bout des lèvres que la Commission des droits de l'homme constitue une honte.
Est-il raisonnable de nommer un pyromane à la tête d'une caserne de pompiers ?
Evidemment pas.
Alors comment se fait-il que des tyrannies comme Cuba, la Chine, le Soudan ou le Zimbabwe soient membres de la Commission ?
La Libye, le Vietnam, le Congo et la Syrie ont récemment été admis en son sein et la Libye a même été élue à la présidence de la Commission.
Comment cela est-ce possible ?
Malheureusement, beaucoup de pays libres semblent totalement indifférents à la campagne orchestrée contre Israël.
Pour sortir de cette situation absurde, les démocraties doivent s'unir pour empêcher qu'un pays qui viole systématiquement les droits de l'homme puisse être membre de la Commission des droits de l'homme.
La démocratisation en cours dans des régions qui n'ont connu que la dictature fait pencher la balance en faveur d'au moins un organe de l'ONU qui incarnerait la liberté.
Qui doit décider si un pays est démocratique ?
Cette fonction pourrait revenir à Freedom House, un laboratoire d'idées indépendant et prestigieux dont le siège est à New-York, tout comme celui de l'ONU.
S'il y a une lecture à recommander à quiconque fait une déclaration publique sur les droits de l'homme, c'est bien celle-ci.
Les pays libres devraient se fixer pour objectif de permettre aux seuls pays libres de siéger au sein de la Commission des droits de l'homme.
Ceux qui sont arrivés au pouvoir par la fraude ou par la violence n'ont aucune légitimité et ne devraient plus jamais ternir l'image de l'ONU du fait de leur appartenance à la Commission.
Malheureusement, beaucoup de démocraties n'ont pas la volonté de modifier la composition de la Commission qui est une véritable perversion.
L'Union européenne qui représente 25 démocraties constitue souvent une incitation à la lutte pour la liberté dans des pays opprimés ; cela a été le cas en Ukraine et au Liban.
Mais il n'est pas dans les habitudes de l'UE de combattre les extrémistes au sein de l'ONU, elle fait plutôt d'étranges compromis avec eux.
En conséquence de quoi, les Etats voyous font quelques concessions aux Européens et à certains autres pays pour ensuite revendiquer une parité morale avec les démocraties.
Les peuples libres doivent se souvenir que le totalitarisme ne peut être vaincu en se montrant aimable et accommodant.
La Commission des droits de l'homme doit se débarrasser des ennemis de la liberté qui figurent parmi ses membres.
Sinon, l'unique organe de l'ONU dédié à la liberté ne sera plus qu'un instrument au service de la tyrannie.
La Chine doit aller plus loin que la simple médiation
Le désespoir est dangereux en diplomatie et les dernières actions de la Corée du nord désespèrent une grande partie de l'Asie.
Seule la Chine, longtemps peu encline à faire usage de ses dons diplomatiques, a maintenant le pouvoir de trouver une solution diplomatique au problème nucléaire de la Corée du nord.
Mais la question que tout le monde se pose, de Tokyo à Séoul en passant par Washington et Moscou, reste : la Chine interviendra-t-elle à temps ?
L'influence de la Chine sur la Corée du nord est unique.
La Chine permet à son voisin, toujours plus désespéré, de survivre en fournissant la plupart de l'aide autre que alimentaire et de l'énergie que la Corée du nord reçoit de l'étranger.
Pourtant, pour empêcher la Corée du nord de réaliser un fait accompli dans la poursuite de l'arme nucléaire, la Chine doit aller plus loin que la médiation entre la Corée du nord et les États-Unis, rôle qu'elle a joué jusqu'à présent.
Au lieu de cela, elle doit maintenant inciter la Corée du nord à arrêter le développement des ses activités nucléaires et de revenir aux négociations multilatérales avec les États-Unis, le Japon, la Chine, la Russie et la Corée du sud qui ont été interrompues ces dernières semaines.
Les développements récents indiquent que la menace nucléaire que représente la Corée du nord est toujours plus sérieuse chaque jour.
Il y a deux semaines, la Corée du nord a déclaré qu'en juin, elle avait réussi à traiter quelques 8 000 barres de combustible nucléaire et possède donc aujourd'hui la dissuasion nucléaire, qui laisse croire que le régime de Kim Jong Il est peut-être bien en train de construire des bombes nucléaires.
Non seulement la Corée du nord ne montre qu'un intérêt relatif à la tenue d'une autre session de négociations multilatérales que le gouvernement Bush et les autres participants appellent de leurs voeux, mais elle veut également empêcher maintenant la participation des japonais.
Kim Jong Il accuse le Japon d'avoir introduit des obstacles et des complications inutiles dans la résolution du problème nucléaire en soulevant la question sensible de la prise de citoyens japonais par la Corée du nord.
Pourtant, cela n'est rien d'autre qu'une diversion politique.
Il est inconcevable que des négociations multilatérales puissent résulter en un progrès quelconque vers une solution diplomatique tandis que la Corée du nord prend une part active dans la poursuite de son programme d'armement nucléaire.
Il doit être clair maintenant que Pyong Yang est déterminée à garder son programme d'armement nucléaire pour obtenir des États-Unis l'assurance crédible que son régime étrange et répressif sera autorisé à survivre.
À moins que les États-Unis ne réponde à la demande coréenne de signature d'un traité de non agression et de cessation des politiques « hostiles », le régime de Kim Jong Il conservera probablement son programme d'armement nucléaire comme la dissuasion la plus effective contre toute attaque préemptive des États-Unis, chose que le gouvernement Bush, en fait, refuse d'exclure.
La victoire militaire des États-Unis en Irak a probablement renforcé la volonté de la Corée du nord de s'appuyer sur l'option nucléaire comme moyen principal d'assurer la survie du régime.
Toutefois, cela ne devrait surprendre personne : le régime nord-coréen s'est toujours engagé à faire de son budget militaire la « priorité principale » de son budget national.
Ce qui forme un contraste étonnant avec les politiques de la Chine et du Vietnam, les deux autres puissances communistes d'Asie.
Dans ces deux pays, le gouvernement place le budget militaire à la dernière place dans ses stratégies de développement national.
Il serait difficile pour les États-Unis de modifier la priorité principale de leur propre stratégie de sécurité nationale : barrer la route au terrorisme et s'opposer à la diffusion des armes de destruction massive, particulièrement au moment où une nouvelle menace nucléaire surgit en Iran.
Tant que l'objectif d'empêcher la prolifération des armes nucléaires dans la péninsule coréenne est en cause, les États-Unis ont réussi en soutenant un ensemble de pouvoirs ad hoc jusqu'à présent avec la Chine, le Japon, la Russie et la Corée du sud.
En fait, dans leur première déclaration conjointe, la première de l'histoire, le premier ministre chinois Wen Jiabao, le premier ministre japonais Junichiro Koizumi et le président sud-coréen Roh Moo Hyun ont publié un appel en marge du sommet de l'ASEAN qui s'est tenu à Bali le 8 octobre pour une péninsule coréenne sans armes nucléaires.
Tous ont réalisé qu'un échec dans ce domaine résulterait probablement en une réaction nucléaire en chaîne avec le Japon, la Corée du sud et peut-être même Taiwan se lançant dans le développement de leur propre programme d'armement nucléaire.
Ce scénario représente le pire cauchemar de la Chine.
La question est donc de savoir ce que la Chine peut faire pour suspendre et si possible renverser le programme nucléaire de la Corée du nord.
La Chine se trouve dans une position délicate, tiraillée dans un sens par son désir d'éviter un effondrement précipité du régime nord-coréen, et dans un sens opposé par son besoin sans égal d'approfondir ses relations économiques avec les États-Unis, le Japon et la Corée du sud.
C'est pourquoi la Chine s'est opposée aux sanctions militaires ou économiques contre la Corée du nord lors de l'assemblée du conseil de sécurité des Nations unies, un pays pour lequel elle sacrifia près d'un million de soldats pendant la guerre de Corée de 1950-53.
C'est dans l'intérêt national vital de la Chine de stopper la Corée du nord dans sa quête pour devenir une nouvelle puissance nucléaire déclarée.
Un succès de la Chine dans ce domaine rehausserait son prestige international et contribuerait également à améliorer immensément la promotion de la stabilité de la région et la prospérité de toute l'Asie.
Le Retrait américain d'Asie
Le retrait prévu par les Etats-Unis des troupes américaines stationnées en Asie, que le Président George W. Bush a annoncé le 16 août, ne doit pas nuire à la paix et à la stabilité de la région en général et de la Corée en particulier.
Mais les consultations rapprochées des Etats-Unis avec ses alliés reste l'une des principales conditions à un redéploiement sans heurt des troupes américaines, ce qui n'a jamais été ben géré encore à ce jour.
L'opinion de la Corée du Sud et du Japon doit être prise en compte sérieusement si ce retrait maintenant inévitable doit se faire avec succès.
Par contre, l'annonce unilatérale du retrait des troupes - et la mise en œuvre unilatérale de ce retrait - pourrait bien faire du tort à la cause que le reste des troupes américaines en Asie est destiné à servir : représenter une force de dissuasion, la stabilité et empêcher la prolifération des armes nucléaires en Corée et en Asie.
Le retrait prévu provoque d'innombrables inquiétudes.
Au Japon, certains s'inquiètent de se voir mis sur la ligne de front du poste de commande américain en Asie, et probablement au-delà de la portée de son accord bilatéral de sécurité signé avec les Etats-Unis.
Il en résulte que la Chine n'est pas rassurée quant aux implications de tout développement du partenariat militaire américano-japonais.
Toutefois, l'impact des retraits prévus de troupes américaines se ressent âprement en Corée du Sud.
En juin, le gouvernement Bush a révélé ses projets de retrait pour quelque 12 500 des 37 000 soldats américains stationnés en Corée du Sud d'ici la fin de l'année 2005.
Cela comprend les 3 600 hommes de la 2ème Brigade de la 2ème Division d'infanterie, qui sont déjà affectés au redéploiement des troupes en Irak.
Le Département de la défense américain justifie ce changement comme faisant partie de ce qu'il appelle " la révision générale de ses positions " mise en place pour une plus grande flexibilité et mobilité du déploiement des troupes là où elles sont le plus urgemment nécessaires à travers le monde.
Mais la nature unilatérale de l'annonce, et le timing brusqué du plan, incite à l'inquiétude en Corée du Sud, et peut-être au Japon : ce retrait pourrait poser des risques sérieux pour le rôle essentiel que les forces américaines jouent dans la dissuasion pour empêcher un nouveau conflit en Corée.
Les Sud-coréens craignent véritablement que ce projet n'affaiblisse la dissuasion en envoyant comme message à la Corée du Nord - qui exige le retrait des troupes militaires américaines tout en refusant d'abandonner son arsenal nucléaire -- que l'intransigeance paie.
En effet, il ne faut pas oublier que la Corée du Nord entretient une armée de 1,1 million d'hommes.
De plus, la façon dont le gouvernement Bush a dévoilé ses projets de retrait a affaibli la crédibilité de l'alliance américano-sud-coréenne.
L'annonce unilatérale américaine a alimenté les rumeurs soutenant que le retrait à quelque chose à voir avec la marée montante de l'anti-américanisme en Corée du Sud, et plus particulièrement avec l'hésitation et les retards que le pays affiche dans le déploiement supplémentaire de 3 600 de ses propres soldats en Irak.
Le gouvernement Bush essaie de repousser ces accusations en expliquant que ce projet n'affaiblit pas les capacité de dissuasion des forces américaines puisque la présence navale et aérienne des forces américaines, bien plus puissantes, est maintenue dans la région.
De plus, les Etats-Unis prévoient de renforcer les forces sud-coréennes en leur fournissant de l'équipement électronique de pointe pour une valeur de quelque 11 milliards de dollars dans les cinq ans qui viennent.
D'un point de vue militaire, cet argument fait sens.
Politiquement et psychologiquement, cependant, la méthode, sans parler du timing et de la réalisation du retrait, soulève de nombreuses questions sur la viabilité à long terme de l'accord de sécurité américano-coréen, puisque l'alliance semble maintenant partir à la dérive, sans objectif commun et peu d'orientation de chaque côté.
Pourtant, le gouvernement Bush insiste : " les Etats-Unis considèrent la Corée du Sud comme un allié fort et stable.
Nous sommes totalement engagés dans le maintien de la sécurité de la Corée du Sud et dans notre alliance et partenariat avec Séoul. "
Si Washington s'exprime sérieusement avec ces mots, alors il faudra transformer cet engagement en alliance totale à long terme pour survivre à la marginalisation actuelle - et continue après la réunification avec la Corée du Nord - en faisant une déclaration conjointe avec le gouvernement coréen au plus haut niveau.
Pour dissiper les doutes et restaurer la confiance dans l'alliance, il faudra que les Etats-Unis et la Corée du Sud réaffirme leurs intérêts et valeurs communs dans la poursuite de la dissuasion, de la non prolifération des armes nucléaires, de la stabilité et de la démocratie dans la péninsule coréenne et en Asie.
Une fois la résolution prise de poursuivre l'alliance dans ce but, il devrait être possible pour les responsables officiels de travailler sur des principes directeurs pour une coopération concrète en matière de sécurité.
Des négociations spécifiques sur le retrait des troupes américaines de Corée ou leur redéploiement depuis la DMZ jusqu'au sud de Séoul devrait se faire selon ces principes.
Ce faisant, l'Amérique doit traiter la Corée du Sud comme un partenaire à part entière avec sa propre voix dans la prise de décisions qui affectent les intérêts de sa sécurité.
En qualité d'allié américain depuis 51 ans et de troisième plus grosse économie d'Asie de l'Est, la Corée du Sud a gagné le droit d'être consultée sur de telles décisions.
Malgré le sentiment anti-américain des Sud-Coréens, une majorité de la population du pays veut que les forces américaines restent en place comme force stabilisatrice.
Assurer que la péninsule coréenne se développe en toute sécurité et sans nucléaire, péninsule qui reste un lieu où les intérêts de la Chine, du Japon, de la Russie et de l'Amérique se croisent directement, est un des objectif de sécurité les plus importants de toute la planète.
C'est pour cette raison que l'Amérique et la Corée du Sud doivent rétablir une vision stratégique pour l'avenir.
L'UE doit entamer les négociations avec la Turquie
Une reconnaissance formelle par la Turquie de la République de Chypre, comprenant son extension à la partie nord de l'île, ne fait pas partie des conditions pour débuter les négociations.
Il s'agit là d'une question complexe liée aux efforts de négociation du secrétaire général de l'Onu Kofi Annan pour parvenir à un accord global qui mènera à la réunification de l'île.  
L'année dernière, la Turquie et la communauté chypriote turque ont accepté les propositions du secrétaire général, qui ont cependant été rejetées par les Grecs chypriotes.
Il y a toutes les raisons de penser qu'Annan reprendra bientôt ses bons offices et trouvera une solution positive au problème bien avant l'entrée possible de la Turquie dans l'UE, autour de 2015.
La question de Chypre ne devrait donc pas être interprétée comme un obstacle au début des négociations.
Cela vaut aussi pour l'intention prêtée à certains gouvernements de l'UE de voir le soi-disant concept de "partenariat privilégié" inclus de façon explicite dans le cadre de négociations en tant qu'alternative à une adhésion complète.
Cette proposition a été débattue et rejetée lors du Conseil européen de décembre dernier, et les conclusions du Conseil y font référence sous la mention "négociation ouverte."  Le choix des termes, jamais utilisés lors des élargissements précédents, a pu agacer la Turquie, mais il a finalement été accepté comme le genre d'ambiguïté constructive si souvent utilisée en diplomatie internationale.
Il est cependant évident, de par la nature même des négociations, que l'adhésion complète doit en être le but.
Sans cette perspective, aucun pays candidat ne s'infligerait la douloureuse procédure d'adoption des dizaines de milliers de lois et de règlements contenus dans l'Acquis Communautaire (ensemble des lois de l'UE).
Après tout, le but principal des négociations d'adhésion est de s'assurer que le candidat s'y plie.
En outre, il est difficile d'imaginer quels avantages pourraient être offerts à la Turquie dans le cadre d'un "partenariat privilégié" au-delà de son statut à long terme de Membre associé de l'UE.
L'union douanière conclue il y a dix ans permet le libre-échange de tous les produits hormis ceux de l'agriculture.
La Turquie est invitée à des réunions du Conseil, elle peut participer à divers programmes européens et à des manifestations de la Politique étrangère européenne commune, et, en tant que membre de l'Otan, c'est un partenaire de la coopération de sécurité entre l'Otan et l'UE.
Enfin, à l'instar de tous les pays candidats, la Turquie bénéficie d'une assistance financière et technique pour soutenir ses programmes de réforme actuels.
À part l'adhésion à part entière, la relation de la Turquie et de l'UE ne laisse plus beaucoup de place à une quelconque valeur ajoutée.
Le commissaire à l'élargissement Olli Rehn l'a énoncé avec la clarté qui s'impose : "Si, comme nous le devrions, nous nous tenons à ce que nous avons décidé au plus haut niveau politique au Conseil européen, je suis raisonnablement persuadé que les négociations débuteront le 3 octobre."
Cette déclaration est tout à l'honneur de la Commission européenne, et il n'y a pas grand-chose à y ajouter, sauf peut-être souligner qu'il revient aux gouvernements européens de traiter la Turquie avec l'équité que méritent tous les pays candidats.
Revenir sur des décisions formelles et sur des promesses, ou opposer des obstacles de dernière minute décrédibiliserait l'Union européenne.
Les négociations doivent par conséquent commencer le 3 octobre.  
L'Europe doit assumer ses responsabilités au Kosovo
Malheureusement, nous ne pouvons encore tourner la page de ce conflit pernicieux qui a conduit à tant de tragédies et qui est depuis bien trop longtemps une cause d'instabilité dans les Balkans.
Le problème ne va pas disparaître, car la Serbie persiste à rejeter la nouvelle réalité et fait tout ce quelle peut pour empêcher une normalisation.
Sur ordre du gouvernement serbe, les Serbes du Kosovo qui représentent 5% de la population refusent de coopérer avec le gouvernement du Kosovo et la mission de l'UE.
En faisant cela - c'est le paradoxe de l'histoire - ils freinent l'application rapide des nombreux droits que leur accorde le plan Ahtisaari afin de leur assurer une vie normale et la sécurité.
Avec le ferme soutien de la Russie, la Serbie essaye de bloquer l'entrée du Kosovo aux Nations unies, ainsi que son intégration aux autres organisations au niveau régional et mondial.
Il est difficile de comprendre l'objectif de la Serbie.
Personne ne nie que la perte d'une partie de son territoire est pour un pays quelque chose de douloureux, même s'il est peuplé très majoritairement d'un autre groupe ethnique.
L'histoire récente offre pourtant des exemples de séparation consensuelle.
Dans le cas du Kosovo, le comportement brutal du régime de Milosevic dans les années 1990 (répression, atteintes massives aux droits de l'homme et expulsion à grande échelle des Albanais du Kosovo) a poussé l'OTAN à intervenir, l'ONU à prendre la responsabilité de l'administration du pays et a rendu impensable un retour du régime serbe.
Les dirigeants démocrates de la Serbie d'aujourd'hui doivent comprendre que la perte du Kosovo - même si elle n'est pas de leur fait - est une réalité irréversible.
Avec leur politique de refus, la seule chose à laquelle ils peuvent aboutir est de retarder la stabilisation pourtant si nécessaire de la région après l'éclatement de la Yougoslavie et de rendre la vie difficile pour le Kosovo et sa population.
Ne serait-il pas plus sage de tendre la main à ce pays en train de naître, de transformer l'hostilité en amitié et d'assurer ainsi le maintien des Serbes au Kosovo ?
Le Kosovo est avant tout un problème européen et l'UE a la responsabilité première d'en faire un succès.
Malheureusement, l'incapacité de l'Union à s'accorder sur une politique commune non seulement affaiblit son rôle sur la scène internationale, mais constitue aussi un obstacle majeur à une action déterminée dans le pays lui-même.
Les cinq pays de l'UE qui ne reconnaissent toujours pas le Kosovo doivent réaliser que leur position encourage ceux qui rejettent toute forme de coopération avec la mission de l'UE et essayent de la gêner dans son travail.
Et pour les forces modérées de Serbie, il est de ce fait beaucoup plus difficile de s'adapter à la nouvelle situation.
Un seul élément pourrait à la longue amener la Serbie à infléchir son attitude : une position commune de l'UE et la prise de conscience par la population et le gouvernement serbe que l'entrée de leur pays dans l'UE est hors de question tant que le conflit n'est pas entièrement résolu.
Par ailleurs, le Kosovo a besoin d'une perspective européenne claire et d'une aide déterminée pour faire face à tous les problèmes auxquels il doit faire face.
Or pour l'instant, ces deux éléments font défaut.
Personne ne doit se méprendre sur le calme relatif qui règne actuellement au Kosovo.
Les récentes tragédies des Balkans montrent que les problèmes laissés en l'état se transforment tôt ou tard en conflit ouvert dont le prix est insupportable pour tous.
Le temps n'est plus à l'autosatisfaction.
Tous ceux qui se sentent concernés devraient porter attention aux paroles de Barack Obama lors de son discours inaugural : &quot;L'époque de la passivité, de la protection d'intérêts particuliers et de la remise au lendemain des décisions déplaisantes, cette époque est définitivement terminée.&quot; Martti Ahtisaari, ancien président de Finlande, est prix Nobel de la paix 2008.
Olayide Akanni et Jamillah Mwanjisi
Cet état de fait empêche les personnes qui pensent être contaminées de se faire soigner.
Dans bon nombre de régions -- et tout particulièrement dans les zones rurales -- la croyance selon laquelle les tuberculeux ont été ensorcelés, empoisonnés, ou selon un médecin nigérian : « maudits par les dieux », persiste de nos jours.
Plus d'un demi million d'Africains et deux millions de personnes dans le monde meurent chaque année de la tuberculose, qui est la première cause infectieuse de décès chez les personnes touchées par le VIH/SIDA.
Et pour ne rien arranger, la résurgence déplorable de la tuberculose est alimentée par le VIH/SIDA.
Par exemple, le nombre de cas de tuberculose a été quasiment multiplié par six entre 1983 et 2003 en Tanzanie : il est passé de 12.000 à 64.500.
Le VIH/SIDA est à l'origine d'une augmentation annuelle de 6 % des cas de tuberculose au Nigeria, qui a désormais le plus fort taux de nouveaux cas déclarés en Afrique.
Et pourtant, la tuberculose est souvent vue comme un mal appartenant au passé.
La plupart des gens -- même les plus susceptibles d'être infectés, y compris ceux qui vivent avec le VIH/SIDA -- manquent d'informations précises sur les symptômes de la maladie ou sur les endroits où les traitements sont administrés.
Même si dans une grande partie de l'Afrique subsaharienne plus de la moitié des patients sont VIH positifs, la majorité des centres de dépistage du VIH/SIDA ne proposent pas de services de diagnostic et de thérapeutique de la tuberculose.
Il est alors bien plus difficile pour ces centres d'établir un diagnostic exact sur les patients atteints des deux maladies, car les tests actuels ne détectent pas la tuberculose active chez 60 à 80 % des porteurs du VIH/SIDA.
Les responsables politiques du monde entier ont pris une série d'engagements publics pour combattre le double impact mortel de la tuberculose et du VIH/SIDA.
Il y a un an à Maputo, au Mozambique, des ministres de la santé africains ont notamment déclaré la tuberculose « urgence régionale » et se sont associés dans le cadre d'un nouveau Plan mondial « Halte à la tuberculose », qui comporte des objectifs spécifiques et des lignes directrices pour lutter contre la co-infection.
Des mesures positives ont été entreprises.
La Tanzanie a mis à l'essai des programmes de proximité consistant à envoyer des travailleurs sanitaires chez les patients souffrant de tuberculose, afin de suivre l'observance du traitement et de proposer un soutien.
Néanmoins, ces efforts n'ont pas été entrepris à grande échelle et sont insuffisants pour enrayer la résurgence inquiétante de la tuberculose provoquée par le VIH/SIDA.
La volonté politique de mettre en œuvre les engagements pris par les gouvernements fait cruellement défaut.
Les actions menées contre la maladie continuent à manquer des ressources nécessaires pour traiter le nombre croissant de malades et, qui plus est, les travailleurs sanitaires sont à la fois débordés et sous-payés. En outre, le manque d'outils plus performants pour le diagnostic et la prise en charge des cas de co-infection tuberculose/VIH demeure un sérieux problème.
Pour Fatima et des milliers d'autres personnes comme elle, les déclarations du gouvernement ne prendront un sens que lorsqu'elles se traduiront par l'amélioration des services.
Ce qui nécessite un développement rapide des centres de dépistage et de traitement de la tuberculose, afin que les patients n'aient plus à choisir entre se faire soigner et s'occuper de leurs familles.
Cela implique également une coordination rigoureuse des programmes sur la tuberculose et sur le VIH, pour que ceux qui vivent avec les deux maladies puissent être traités au même endroit.
Enfin, il importe que les pays aisés prêtent leur concours à cette lutte et s'investissent dans la recherche et dans le développement en vue de rendre le traitement de la tuberculose véritablement efficace et accessible à tous.
La recrudescence des cas de la maladie est devenue une urgence sanitaire critique et nous ne pouvons plus nous permettre de rester léthargiques lorsqu'il s'agit d'y faire face.
Selon les termes de Stephen Lewis, envoyé spécial du Secrétaire des Nations Unies sur le VIH/SIDA en Afrique : « le VIH et la tuberculose agissent l'un sur l'autre de façon mortelle -- c'est une combinaison infernale ».
Les militants de la lutte contre le VIH/SIDA et les responsables politiques doivent concentrer davantage leur attention sur la tuberculose.
Fatima et ses semblables ne méritent pas moins.
La Turquie joue la carte de l'Europe
Élu avec une majorité parlementaire presque suffisamment importante pour pouvoir changer la constitution du pays, le nouveau gouvernement islamiste turc doit faire face à de terribles défis.
Le plus urgent étant la guerre qui couve entre l'Amérique et l'Irak.
La Turquie restera-t-elle l'alliée indispensable, diplomatique et logistique des États-Unis ?
Les solidarités religieuses vont-elles changer la position de la Turquie alors que le nouveau gouvernement rejoint d'autres pays musulmans dans leur opposition à toute invasion de l'Irak ?
Évidemment, les islamistes turcs ne sont pas les seuls à se poser de sérieuses questions à propos de la guerre.
Nombreux sont les Turcs qui partagent l'idée que la guerre pourrait avoir de dures conséquences pour leur pays, aussi bien à court terme qu'à long terme.
L'économie vacillante n'a pas besoin du bouleversement qu'apporterait un conflit militaire même s'il restait bref.
Les institutions turques (l'armée aussi bien que le corps diplomatique) s'inquiètent de la possibilité que cette guerre crée en Irak une fracture qui mènerait à un gouvernement kurde indépendant à la frontière sud de la Turquie, ce qui servirait sans aucun doute à renforcer le nationalisme kurde à l'intérieur de la Turquie et poserait de nouvelles menaces sur l'unité et la stabilité de la Turquie.
Les institutions bureaucratiques turques laïques sont pro-occidentales par tradition mais teintées d'une forte dose de nationalisme.
Mis à part la question kurde, leur attention se concentre aussi maintenant sur Chypre.
La question chypriote vient d'atteindre un tournant critique, suite à la proposition de paix mise en avant par le Secrétaire général des Nations unies, Kofi Annan, et son ultimatum de la fin février, qui approche rapidement.
Au même moment, les Chypriotes grecs se sont vu offrir leur billet d'entrée dans l'UE en dépit du fait qu'il n'existe encore aucun accord sur la question chypriote.
Chypre est donc devenue maintenant une question clé sur la route de l'admission de la Turquie au sein de l'UE.
Si elle reste sans solution, cette question fournira une raison solide d'empêcher l'entrée de la Turquie dans l'UE pour ceux qui s'opposent à son admission.
Cela constitue un autre piège potentiel pour le nouveau gouvernement.
En dépit de l'importance de Chypre, c'est l'éventualité de la guerre contre l'Irak qui représente la menace la plus sévère contre le fragile équilibre qui existe aujourd'hui entre la vieille garde conservatrice de la Turquie et le camp plus libéral des réformateurs au sein du Parti pour la justice et le développement au pouvoir.
Cela pourrait-il mener à de nouvelles luttes de pouvoir au sein du Parti ?
Le fait que l'élection à la chambre des députés puis au poste de Premier ministre du dirigeant du Parti, M. Erdogan, fut empêchée pour des questions de formalité rend le maintien de cet équilibre encore plus difficile.
Toute rupture affichée affaiblira le pouvoir des réformateurs qui veulent garder des liens serrés avec l'Ouest et les États-Unis.
Bien que le Parti pour la justice et le développement n'ait pris les rênes du pouvoir que depuis peu, il donne déjà des signes clairs quant à ses choix.
Très au fait des doutes de l'Ouest à propos de son Parti, dès son élection, M. Erdogan a immédiatement entrepris de se rendre dans les capitales occidentales pour défendre ses arguments : un changement à la tête du gouvernement ne signifie pas que l'orientation fondamentale de la Turquie ait changé.
Il est parfaitement conscient du contraste de cette approche en comparaison de celle du gouvernement turc islamiste précédent.
Élu en 1996, après une campagne marquée par de fortes revendications religieuses, M. Necmettin Erbakan du Parti du bien social avait mis un point d'honneur à effectuer ses premières visites officielles en Iran, en Libye, en Indonésie et en Malaisie.
M. Erdogan a mis de nouveau l'accent sur son orientation pro-occidentale très rapidement, quelques semaines plus tard, au sommet de l'UE sur l'élargissement, qui s'est tenu à Copenhague à la mi-décembre.
La campagne agressive du nouveau gouvernement avant le sommet fut perçue sur le plan intérieur comme sur le plan international comme le signe évident de son engagement envers la cause européenne.
Rejetant les accusations lancées précédemment par M. Erbakan selon qui l'UE ne serait qu'un « club de chrétiens », M. Erdogan a ouvertement fait campagne pour une adhésion totale.
Il a reçu en cela le soutien enthousiaste du gouvernement Bush qui espère que M. Erdogan ait réussi à trouver là le moyen d'associer démocratie et islam.
Jusqu'à présent, M. Erdogan a joué la carte européenne avec adresse, rassurant les alliés occidentaux de la Turquie et encadrant l'armée turque, qui reste sceptique quant aux intentions de son parti.
En acceptant de se plier aux exigences européennes de réforme démocratique comme préalable à l'adhésion à l'UE, M. Erdogan a joué un rôle libéral, renforçant son affirmation quant à la représentation de son parti : une authentique voie démocratique pour un pays à majorité islamiste. En fait, son parti représente la version islamiste des partis chrétiens démocrates qui ont longtemps dominé le paysage politique de la droite européenne.
Il est évident que le programme politique et économique de M. Erdogan et de son parti se distingue radicalement de l'islamisme turc traditionnel.
Les mouvements islamistes se sont généralement caractérisés par leur attitude fortement opposée au libre échange et à l'occident.
Pourtant, le premier ministre, M. Gul décrit habituellement son gouvernement comme étant « favorable au monde des affaires ».
Les mois qui viennent seront essentiels.
Pour convaincre les sceptiques, le parti devra rompre avec les politiques turques classiques à l'encontre de Chypre et avec les doutes islamistes habituels à l'encontre de l'Europe.
Pour couronner le tout, la Turquie doit parvenir à un accord avec son allié le plus proche, les États-Unis, s'il décide d'agir contre l'Irak.
L'ouverture insistante de M. Erdogan vers l'Europe pourrait être la solution clé.
En insistant sur son adhésion à l'UE, il renforce l'orientation européenne dont la Turquie fait preuve depuis longtemps.
Cela lui donnera peut-être l'occasion de se distancier de la politique américaine en quelque sorte.
Après tout, en devenant plus européenne, la Turquie n'est-elle pas autorisée aussi à partager les doutes que l'Europe entretient au sujet de la guerre contre l'Irak ?
L'Inde est sur une pente dangereuse
Comme les membres de ces bas-fonds sont imperméables au patriotisme et à la moralité, les terroristes peuvent facilement les recruter, particulièrement s'ils ont des raisons d'être aigris.
A Bombay, une grande partie d'entre eux sont des musulmans exclus de l'économie formelle qui ont développé un sens profond de leur intérêt propre au cours des 50 dernières années.
On ne connaît pas encore tous les détails sur les atrocités de Bombay où des terroristes ont tué une centaine de personnes.
On sait néanmoins qu'au moins 30 hommes armés de fusils d'assaut AK47 et de grenades ont pris en otage le centre financier et le centre d'affaires de l'Inde, ciblant tout à la fois Indiens et étrangers, notamment les Américains et les Britanniques.
Il est probable que cette opération a été mise au point au Pakistan par le Lashkar-e-Taiba, une organisation terroriste qui se nourrit de la haine de l'Inde laïque, qui est soutenue dans l'ombre par des agences pakistanaises et bénéficie d'un support populaire.
Sous la pression des événements, un élément essentiel nous échappe peut-être.
Cette opération a dû demander des mois de préparation : des armes lourdes ont été employées, une véritable petite armée a été mobilisée, des cibles ont été soigneusement choisies, des moyens de transport organisés et les points faibles identifiés.
Des centaines de personnes ont dû être impliquées dans ce plan, et malgré toutes ses infrastructures, le gouvernement indien n'a rien vu venir.
Le responsable des forces anti-terroristes indiennes, Hemant Karkare qui a été tué au cours des combats de la nuit, avait reçu des menaces de mort venant de la ville voisine de Pune, mais sa propre unité, surtout engagée dans les magouilles des responsables politiques, avait décidé de ne pas s'en préoccuper.
L'autosatisfaction et la politique ont mieux protégé les terroristes que n'auraient jamais pu le faire silence et le camouflage.
Mais cette opération terroriste représente bien plus qu'un échec de la police, elle symbolise l'effondrement de la gouvernance de l'Inde, elle est la conséquence de l'incompétence de l'administration et de l'incurie des politiciens.
L'Inde est un pays dur, autant ne pas se faire d'illusion à ce sujet.
Elle combat les terroristes musulmans au Cachemire, les terroristes Sikh au Punjab, les terroristes chrétiens au Nagaland et les terroristes hindous en Assam et à travers le pays, tout en sachant que l'on ne peut blâmer toute une communauté pour les mauvaises actions de quelques-uns.
Mais avec une gouvernance inefficace, notamment lors des trois dernières années, l'Inde risque de se transformer en un pays sans colonne vertébrale.
Au lieu d'être en tête dans la guerre contre le terrorisme, elle sombre dans le rôle de la victime perpétuelle.
Elle arrive en deuxième position derrière l'Irak en termes de nombre de victimes du terrorisme.
Il y a trois ans, le Premier ministre indien, Manmohan Singh, avait déclaré d'un ton suffisant au président Bush en visite à Delhi que les musulmans d'Inde n'étaient aucunement impliqués dans le terrorisme.
Il sous-entendait ainsi qu'ils étaient parfaitement intégrés dans la société indienne et qu'ils bénéficiaient de tous les avantages de la démocratie, une conclusion que Bush s'est empressé de reprendre.
Mais les terroristes ne se sont pas laissés prendre à ses mots et ils y ont peut-être même trouvé incitation à agir.
Je suis Indien et musulman et fier de l'être.
Comme n'importe quel Indien aujourd'hui, je suis en colère, frustré et déprimé.
J'en veux aux chiens de guerre égarés qui ont envahi Bombay.
Je suis affligé par l'impuissance de mon gouvernement à Bombay et à Delhi et par sa surdité face à l'anxiété de mes compatriotes.
Je suis atterré par le dommage fait à l'image de l'Inde dans le monde.
L'arche de Putin
Je me suis derničrement rendu ŕ Moscou aprčs cinq années d'absence.
La ville, qui m'a semblé différente et étrange, m'a impressionné par son aptitude au changement.
Mes journées en Russie se sont partagées entre des réunions officielles, des heures perdues dans les embouteillages et des nuits passées avec de vieux amis qui ont essayé de me montrer le meilleur de la vie nocturne de Moscou.
Lors de ma premičre soirée libre, j'ai été invité ŕ un endroit appelé Shinok.
Le restaurant possédait nombre des caractéristiques propres aux restaurants ethniques de n'importe quel pays.
Le kitsch, cette fois-ci ukrainien, était richement représenté par divers objets.
Mais la décoration intérieure se résumait ŕ un seul ornement, un mur artificiel ŕ fenętres qui séparait une partie de l'entrée du restaurant.
Derričre ce mur se trouvait un décor de cour de village.
Une véritable vache ainsi que de véritables poulets et oies peuplaient cet ersatz de cour de ferme.
Par moments, une vieille femme en habit traditionnel apparaissait pour nourrir les animaux.
Les visiteurs dégustant le borscht et les pirogi observaient ses efforts avec satisfaction.
« Elle travaille pour le restaurant, m'a expliqué un ami.
Elle nourrit les animaux et s'assoit dans la cour pour créer l'ambiance rustique. »
Shinok n'était qu'une initiation ŕ la nouvelle vague actuelle de la culture de restaurant ŕ Moscou.
Quelques jours aprčs, j'ai visité The White Sun of the Desert, un autre lieu ethnique.
Le White Sun existait déjŕ dans l'Empire Soviétique.
A cette époque, il s'appelait l'Uzbekistan et n'était rien d'autre qu'une démonstration culinaire obligatoire de l'union soi-disant sacrée entre les quinze républiques fraternelles de l'URSS.
Bien que l'intérieur du restaurant ait complčtement changé depuis lors, ses thčmes décoratifs sont restés les męmes.
De nos jours, toutefois, l'établissement tire son nom d'un western (ou « eastern ») bortsch soviétique populaire filmé en 1969 et dont l'action se déroule en Asie Centrale lors de la Guerre civile de 1919.
Le restaurant est décoré non seulement avec des tapis orientaux, mais également avec des représentations grandeur nature des héros du film tirant avec des mitrailleuses ou assis sur des caisses de dynamite.
Cet « orientalisme » soviétique est renforcé par de jolies serveuses qui portent des tenues sexy davantage inspirées des Mille et Une Nuits que de n'importe quelle réalité d'Asie Centrale, passée ou présente.
Mais le passé soviétique, et non les motifs ethniques, domine de loin la conception du restaurant moscovite contemporain.
Le restaurant club Major Pronin est commodément situé dans le voisinage du quartier général du KGB-FSB.
Il tire son nom du héros des romans d'espionnage médiocres de l'čre soviétique, un personnage qui était également la cible de plusieurs plaisanteries sous le manteau.
L'intérieur du restaurant est décoré avec divers objets du matériel d'espionnage.
Mais le clou du décor est le stand de tir oů les clients peuvent tester leur adresse entre les plats.
Les cibles représentant des tueurs en série et des trafiquants de drogue comportent des devises telles que « Sauvez une femme » ou « Sauvez un jeune garçon ».
La partie centrale du mur accueille une cible représentant le World Trade Center de New York duquel s'approche un avion, avec l'inscription « Sauvez l'Amérique ».
Un nouveau club appelé Zone (camp de concentration en argot russe) vise ŕ reproduire la vie dans un goulag.
Des bergers allemands aboyants, des gardes sévčres et des serveurs portant des uniformes de détenus travaillent beaucoup pour recréer l'atmosphčre sinistre d'un goulag.
La littérature russe n'est pas oubliée.
Si le restaurant Pushkin sur Tverskoy Boulevard non loin du monument dédié au grand počte russe vise ŕ recréer « l'atmosphčre aristocratique » du début du dix-neuvičme sičcle, le bar-restaurant Gogol sur Stoleshnikov Lane tente de recréer une institution soviétique disparue appelée « rumochnaia ».
Une « rumka » est un verre de vodka qui ressuscite les prolétariens épuisés.
Bien entendu, la rumochnaia n'a rien en commun avec Nikolai Gogol, mais l'établissement qui a reçu le nom du célčbre écrivain comporte une patinoire qu'un homme habillé comme Gogol fréquente quotidiennement.
A mon retour ŕ Washington, je suis allé dîner avec un politicien américain qui revenait juste d'un voyage ŕ Saint-Pétersbourg.
Pour lui faire honneur, ses hôtes russes avaient organisé une excursion ŕ Strelna, le « Versailles russe », qui avait été récemment restauré alors qu'il menaçait ruine, pour devenir la résidence pétersbourgeoise du président Vladimir Putin.
Le palais n'a pas impressionné l'Américain.
La quantité de marbre utilisé pour la rénovation lui a paru excessive et son appréciation du luxe semblait correspondre aux critčres d'un Holiday Inn.
Les hôtes russes enthousiasmés de l'Américain lui demandaient constamment son opinion sur le palais.
Tout au long de la visite, l'Américain leur a répondu par des exclamations polies en employant des adjectifs tels que « exquis » ou « saisissant ».
Puis ils sont montés dans le grenier.
Enfin, l'Américain a fait preuve d'enthousiasme.
Le grenier de la résidence présidentielle s'apparentait au ventre d'un bateau du dix-septičme sičcle.
« La derničre fois que j'ai vu quelque chose de semblable, c'était dans une brasserie ŕ Hambourg dans les années 1960 », m'a avoué le politicien.
Quelle perfection, pensais-je, tout en imaginant le président de la Russie monter les escaliers menant au grenier de son palais pour endosser le rôle de Pierre le Grand.
Tout comme les clients de ce restaurant village ŕ l'ukrainienne, peut-ętre Putin trouvait-il son arche-grenier rassurante dans un coin de son inconscient.
Une vague historique dépassant son contrôle avait arraché l'ancien lieutenant colonel du KGB de l'ombre pour le hisser au faîte du pouvoir.
Mais le destin pouvait également l'emporter au loin tout aussi soudainement.
Quoi de mieux que d'avoir une arche ŕ portée de main si un jour, la chance politique tourne ?
Veuillez cliquer sur ce lien pour obtenir des photos grandeur nature :
Rushdie à la russe
Juin sera un mois douloureux dans les tribunaux russes.
Le 16 juin, l'oligarche rebelle Mikhail Khodorkovsky et son compagnon d'armes Platon Lebedev se sont finalement retrouvés confrontés aux juges du tribunal d'instance de Meshchansky.
Il ne fait aucun doute que cette affaire attirera la presse russe et internationale.
Les auditions ont commencé la veille de l'ouverture du procès de Khodorkovsky dans une autre affaire qui n'en est pas moins significative.
Mais cette affaire ne concerne pas la tentative des oligarches à interférer dans la vie politique ; elle concerne un groupe d'artistes et de conservateurs dont les activités professionnelles sont devenues, contre toute attente, une question brûlante de politique.
En janvier 2003, une bande d'activistes orthodoxes russes a détruit une exposition au Musée et au Centre public Sakharov intitulée " Attention !
Religion ".
Les organisateurs de cette exposition ont déclaré qu'ils souhaitaient attirer l'attention sur le nouveau rôle des institutions religieuses dans la vie russe.
Mais les fondamentalistes orthodoxes ont jugé les oeuvres blasphématoires et offensantes, et certains ont saccagé l'exposition.
En décembre dernier, des procureurs ont inculpé deux représentants du Musée Sakharov et trois organisateurs de l'exposition pour incitation à la haine religieuse.
Ils risquent désormais jusqu'à cinq ans de prison.
Les vandales, entre-temps, ont été acclamés par les représentants de l'Eglise comme des héros.
Toutes les accusations contre eux ont été abandonnées.
Les vandales possédaient des protecteurs influents.
Tous étaient membres de la congrégation de St. Nicholas à Pyzhi, dont l'archiprêtre, Alexander Shargunov, est un fondamentaliste radical bien connu.
En 1997, il a fondé un mouvement appelé Social Committee For the Moral Revival of the Fatherland (Comité social pour le renouveau moral de la mère-patrie).
En 2001, le site Web du Comité indiquait comment saccager des panneaux d'affichage " immoraux " en les éclaboussant de peinture.
Des disciples ont aussitôt détruit 150 panneaux d'affichage à Moscou.
Un groupe d'intellectuels nationalistes célèbres, notamment le metteur en scène Nikita Mikhalkov, l'artiste Ilya Glazunov et les écrivains Valentin Rasputin et Vasily Belov, sont intervenus avec une pétition désignant l'exposition comme " une nouvelle étape d'un satanisme conscient ".
Ils ont écrit que les ennemis de la Russie avaient pour objectif d'humilier " le peuple russe [désarmé], leurs objets de culte et leurs valeurs historiques ".
Qui, précisément, étaient ces puissants ennemis ?
Les intellectuels ne les ont pas nommés, mais le parti politique fasciste Pamyat (Memory) n'a pas eu les mêmes hésitations.
L'appel publié sur son site Web demandait aux Chrétiens orthodoxes de protéger " notre Seigneur Jésus-Christ " des " youpins dégénérés ", utilisant le terme russe le plus péjoratif pour désigner les Juifs.
Ces événements alarmants dans le monde de l'art se sont produits dans un contexte de nationalisme et d'arrogance orthodoxe montants en Russie.
L'Eglise orthodoxe a acquis une énorme influence politique au cours des dernières années et peu de politiciens prennent le risque de l'offenser.
L'exposition du Musée Sakharov a été l'objet d'une campagne médiatique injurieuse et l'affaire a été reprise quasiment immédiatement par la Douma, où des députés nationalistes ont rivalisé entre eux pour dénoncer les artistes et louer les vandales.
En février 2003, la Douma a promulgué un arrêté stipulant que l'objectif de l'exposition du musée Sakharov était d'inciter à la haine religieuse et d'insulter les croyants et l'Eglise orthodoxe.
Le procureur d'Etat a reçu l'ordre d'agir contre les organisateurs, 265 députés sur 267 approuvant la mesure.
En avril 2003, la Douma a voté pour renforcer la loi contre l'incitation à la haine religieuse en ajoutant des peines de prison allant jusqu'à cinq ans pour les coupables.
En décembre 2003, le directeur du Musée Sakharov Yuri Samodurov a été inculpé d'actions " menant à la provocation de la haine et de l'inimitié ".
S'il est jugé coupable, il pourrait être condamné à cinq ans de prison maximum.
Les représentants de l'Eglise ne demandent pas une peine aussi sévère.
En mars 2004, le Département des relations extérieures du patriarcat de Moscou a émis un communiqué qui s'est révélé une surprise pour tous.
Il affirmait en effet que les organisateurs de l'exposition du Musée Sakharov avaient commis une infraction administrative plutôt que criminelle.
La différence est que les infractions administratives sont passibles d'amendes, au plus, et non de peines de prison.
Un tel adoucissement de la position de l'Eglise résulte probablement du tollé général dans la presse libérale russe.
Toutefois, le pogrom au Musée Sakharov a provoqué une cascade d'attaques similaires sur des oeuvres d'art contemporain par des fondamentalistes orthodoxes que l'Eglise s'est révélée incapable à contrôler.
Anna Alchuk, une artiste qui a participé à l'exposition au Centre Sakaharov et qui a été inculpée par la suite, a affirmé qu'elle avait lu les 14 volumes de preuves recueillies par le procureur et que 11 volumes consistaient uniquement en des lettres émanant de " travailleurs " exprimant leur indignation face à l'exposition et exigeant que les artistes soient punis.
Quasiment aucun des auteurs de ces lettres n'avaient vu l'exposition, la majorité ayant signé des lettres circulaires. "
Les événements entourant l'exposition discréditent l'Eglise orthodoxe russe, tout comme la fatwah condamnant Salman Rushdie à mort a discrédité l'Islam ", a déclaré Elena Bonner, la veuve d'Andrei Sakharov.
Le jugement qui sera rendu suite aux auditions du tribunal est difficile à prédire, mais il déterminera si les Russes ont perdu leur libre expression artistique de la liberté, qu'ils ont gagnée après la chute du communisme.
La désillusion, avec une " démocratie à la Boris Yeltsin ", a poussé le président Vladimir Putin à rechercher une idéologie basée sur le nationalisme et la glorification de l'Etat.
Putin appelle cette idéologie du " pluralisme géré ".
Comme nous pouvons le voir aujourd'hui, le Social Committee For the Moral Revival of the Fatherland souhaite faire partie des dirigeants.
La mondialisation de la science
Par exemple, nous savons qu'une personne qui fume deux paquets de cigarettes par jour risque d'avoir de sérieux problèmes de cancer une quarantaine d'années plus tard.
La science prévoit aussi que, à moins de réduire conséquemment la consommation de pétrole et de charbon, le climat va continuer à se réchauffer, en augmentant le volume des océans et en faisant fondre de gigantesques morceaux de glace dans l'Arctique et l'Antarctique, ce qui entraînera de désastreuses élévations du niveau de la mer.
Ce ne sont là que deux exemples parmi les milliers de sujets sur lesquels il est intéressant que les politiciens consultent les scientifiques.
Pourtant, les connaissances scientifiques sont bien trop souvent négligées lorsqu'il s'agit d'enjeux importants.
Cela ne veut pas dire que les scientifiques devraient dominer le débat politique.
C'est aux politiciens, non aux scientifiques, qu'il appartient d'évaluer les avantages et les défauts relatifs des choix qu se présentent à eux, puis d'adapter leurs conclusions en conséquence.
Toutefois, ces conclusions risquent d'être bien mauvaises sans une participation scientifique efficace.
Par exemple, le gouvernement des États-Unis a à son service un organisme baptisé National Academies ("Académies nationales"), formé par trois organisations composées des plus éminents scientifiques, ingénieurs et professionnels de santé du pays (respectivement : la National Academy of Sciences, la National Academy of Engineering, l'Institute of Medicine).
Cet organisme indépendant et non gouvernemental produit chaque année plus de 200 rapports, la plupart en réponse à des demandes spécifiques du gouvernement américain.
Ces demandes vont des questions sur les risques pour la santé que posent les traces d'arsenic retrouvées dans l'eau potable à des questions sur la meilleure manière d'aider la recherche scientifique sous ses diverses formes.
À travers une procédure rigoureuse, les "Academies" insistent sur le fait que chaque rapport se limite à ce que la science peut dire sur le sujet, en se basant sur des preuves et sur la logique, sans anticiper les décisions devant être prises par d'autres.
Ainsi, par exemple, le rapport sur l'eau potable prévoyait la fréquence des cancers de la vessie qui finiraient par toucher des populations exposées à des taux d'arsenic de 5, 10 ou 20 parts par milliard.
Mais il n'indiquait pas au gouvernement la concentration maximum d'arsenic à autoriser.
Les textes complets des quelque 3 000 rapports des "Academies" sont accessibles (sur www.nap.edu) et téléchargeables gratuitement dans 146 pays. Les dangers de l'arsenic sont les mêmes dans le monde entier et le rapport américain peut donc être utile dans tous les pays.
Il existe toutefois d'autres sujets importants relevant de la science qui devraient être étudiés par des organismes internationaux afin d'être traités à grande échelle.
C'est pour cela qu'a été fondé, à Amsterdam en 2000, l'InterAcademy Council (IAC) par une organisation internationale d'académies scientifiques baptisée InterAcademy Panel (IAP).
L'IAC est dirigé par un conseil comprenant un groupe tournant de 15 présidents d'académies du monde entier, représentant des nations de niveaux économiques différents. Ses rapports présentent une perspective véritablement internationale, soutenue par les meilleurs scientifiques et ingénieurs du monde.
L'IAC prodigue des conseils sur des sujets avancés par les Nations Unies et d'autres organismes internationaux, qui sont tous disponibles gratuitement sur www.interacademycouncil.net.
Le premier rapport de l'IAC était intitulé Inventing a Better Future: A Strategy for Building Worldwide Capacities in Science and Technology ("Inventer un avenir meilleur : stratégie pour renforcer les capacités mondiales en matière de science et de technologie") . Il démontrait de manière convaincante l'importance de soutenir, dans tous les pays, les institutions scientifiques et technologiques qui s'occupent d'exploiter les connaissances scientifiques et techniques internationales afin de répondre aux besoin de leur nation.
Inventing a Better Future expliquait aussi de manière détaillée aux gouvernements et aux organismes internationaux comment mettre en place les institutions scientifiques et technologiques nécessaires aussi bien dans les pays en développement que dans les pays industrialisés.
Le dernier rapport de l'IAC, intitulé Lighting the Way: Toward a Sustainable Energy Future ("Éclairer la voie : vers un avenir aux énergies renouvelables"), présente un calendrier ambitieux et scientifique destiné à répondre à l'important problème des besoins énergétiques du monde.
Chaque rapport de l'IAC est lu attentivement par un public de choix : les 100 académies scientifiques appartenant à l'IAP. Chacune a en effet la responsabilité spéciale de transmettre les recommandations du rapport dans son propre pays, ce qui peut considérablement accroître l'efficacité de l'académie à influer sur les politiques nationales.
L'alliance de l'IAP et de l'IAC est une nouveauté importante en matière de recommandations scientifiques internationales -- une nouveauté qui commence à peine à montrer son efficacité potentielle à diffuser les bienfaits de la science et de la technologie dans le monde entier.
• Seuls les fonctionnaires ainsi que quelques dirigeants du secteur privé jouissent d'une retraite, alors que rien n'est prévu pour les pauvres dans les zones rurales.
• L'enseignement universitaire gratuit constitue une forme de redistribution de l'argent des pauvres vers les riches, car les pauvres paient des impôts qui servent à l'université mais ils y accèdent rarement.
• Les dépenses consacrées à l'enseignement primaire finissent souvent dans l'escarcelle des syndicats d'enseignants, servant à perpétuer les privilèges de leurs membres.
• Les dépenses de santé sont consacrées le plus souvent à des hôpitaux situés dans des zones urbaines relativement prospères et politiquement importantes.
• La gratuité de l'eau et de l'électricité constitue surtout une subvention en faveur des classes moyennes urbaines et des paysans aisés.
L'équilibre reste à trouver pour une Constitution européenne
Romano Prodi, le président de la Commission européenne, a proposé un plan de renforcement de l'exécutif de l'Union.
La Grande-Bretagne, la France et l'Espagne travaillent actuellement à un plan d'opposition qui vise à la consolidation du pouvoir exécutif de l'UE au sein des principaux États de l'UE.
Que doit en penser le citoyen européen ordinaire ?
Les citoyens européens comprennent difficilement les enjeux au coeur de la Convention constitutionnelle de Bruxelles.
De nombreux détails viennent obscurcir la question et les discussions nationales stériles et fallacieuses qui opposent les « Eurosceptiques » aux « Europhiles » créent une certaine agitation, mais ne clarifient rien.
La question semble si compliquée que déjà journaux et télévisions ne mentionnent plus les travaux de la Convention.
Les citoyens européens ne peuvent appréhender clairement les enjeux de la Convention qu'en s'interrogeant sur le partage des fonctions gouvernementales entre l'UE et ses États membres.
Pour répondre à cette question, il faut comprendre la mission fondamentale d'un gouvernement.
Un gouvernement est avant tout censé garantir à ses citoyens un service public : biens collectifs, législation et réglementation, application et sanctions.
Ces services peuvent être dispensés à différents niveaux de gestion: local, régional, national ou supranational, à savoir l'Union européenne.
Mais quel est aujourd'hui le niveau approprié ?
Dans certains domaines, la décentralisation fonctionne car elle reconnaît les préférences des diverses communautés locales ou nationales.
Toutefois, les décisions locales, dans notre monde interdépendant, ont tendance à avoir un impact sur les citoyens des autres communautés et des autres pays.
Certains services doivent ainsi être alloués à une unité géographique plus vaste.
Les décisions de l'Europe sur le mode d'assignation des prérogatives de gestion à différents niveaux doivent être basées sur le principe suivant : les institutions européennes doivent être seules responsables des activités qui comportent des économies d'échelle ou des coûts sociaux (à savoir, l'interdépendance des effets) et de celles où les différences d'opinion parmi les membres sont minimes.
D'autres fonctions - qui comportent de faibles coûts sociaux et où les différences sont élevées - doivent être laissées aux pouvoirs nationaux ou locaux.
Les raisons sont évidentes : de faibles interdépendances impliquent que les avantages dérivés de la centralisation seront limités ; des divergences élevées impliquent des coûts élevés d'harmonisation.
La lire ne peut plus être dévaluée pour favoriser les exportations italiennes au détriment des exportations françaises, provocant alors une réaction française, etc.
Toutefois, en matière de politique éducative, imposer le même système d'éducation publique à tous les membres ne créera aucune économie d'échelle.
Parmi les domaines de la politique publique qui comportent des économies d'échelle élevées ou des coûts sociaux, deux domaines ressortent : le marché commun et la concurrence ; la politique étrangère et la défense.
Le premier couvre la loi antitrust, le commerce et la devise commune.
Selon certains, les politiques fiscales - de la structure de l'impôt à l'aide sociale, aux disponibilités budgétaires - doivent également être harmonisées.
Mais si elles sont imposées sans discernement, elles iront à l'encontre des diverses préférences nationales et risquent d'inciter à la résistance.
D'un point de vue constitutionnel, les politiques fiscales n'ont aucune réelle raison d'être .
La constitution américaine, par exemple, ne préconise pas l'équilibre des États fédérés.
Ce n'est que dans des circonstances exceptionnelles qu'une harmonisation fiscale peut être justifiée : des interdictions, par exemple, sur des avantages fiscaux utilisés pour limiter la concurrence ou le commerce international, ou des interdictions sur la restriction des mouvements de capitaux.
Ce serait absurde qu'en Amérique, New York mette en oeuvre une politique étrangère différente de celle du Texas.
Il en va de même en Europe.
L'adhésion de nouveaux membres à l'Union implique que des différences encore plus prononcées se produiront, ce qui signifie que les politiques centralisées sont plus difficilement justifiables.
Ces considérations suggèrent une série de principes aux membres de la Convention :
1.
La constitution européenne doit établir clairement les prérogatives de l'Europe et celles des pays membres.
En cas de doute, le principe de subsidiarité suggère que les États nationaux demeurent l'autorité suprême ;
2.
Les institutions européennes doivent garantir le fonctionnement des marchés, y compris la concurrence et les politiques commerciales et monétaires ;
3.
Les activités fiscales doivent pour la plupart demeurer décentralisées, sauf rares exceptions ;
4.
La politique extérieure et la défense sont des domaines relevant de la compétence fédérale et doivent être déléguées à l'Europe au moment opportun et de manière appropriée ;
5.
La création de nouveaux domaines de compétence fédérale doit être accompagnée de mécanismes de prise de décision réels dans des démocraties véritablement représentatives.
Ainsi il ne peut y avoir « de centralisation sans représentation ».
A. Alesina, I. Angeloni & L.Schuknecht, CEPR Discussion Paper no. 3115
L'Europe se trouve face à une chance historique.
Les pères fondateurs de la constitution américaine ont rédigé un document qui, dans sa structure essentielle, a duré plus de 200 ans.
La tâche à laquelle les membres de la Convention européenne sont confrontés diffère sous plusieurs aspects et se révèle bien plus complexe.
Espérons qu'ils possèdent la même sagesse et la même clairvoyance.
Les premiers - avec en tête le Brésil, suivi par l'Argentine et le Vénézuéla - veulent construire une Communauté des Nations d'Amérique du Sud.
Les pays du Mercosur - le Brésil et l'Argentine, ainsi que le Paraguay et l'Uruguay - veulent défendre leurs intérêts nationaux respectifs et aller vers un ordre international plus juste et plus démocratique, mais ils ne cherchent pas une confrontation avec qui que ce soit.
Les seconds - les pays qui ont une relation privilégiés avec Washington - comportent deux groupes : ceux qui agissent isolément comme la Colombie, l'Equateur et le Pérou, et ceux qui agissent dans une perspective régionale, essentiellement les pays d'Amérique centrale ainsi que la République dominicaine.
Mais ils sont tous dans la ligne politique initiée par le Mexique et à un moindre degré, par le Chili.
Mais c'est le paysage idéologique de la région qui offre les contrastes les plus marqués.
Si la confrontation entre le Vénézuéla et les USA s'aggravait et si le Front sandiniste de libération nationale remportait une victoire électorale au Nicaragua, l'onde de choc pourrait affecter politiquement toute la région.
Le gouvernement Bush pourrait considérer la formation possible d'un triangle formé par Cuba, le Vénézuéla et le Nicaragua comme une menace directe vis-à-vis de la stabilité régionale, et placer l'Amérique latine dangereusement en tête de son agenda sécuritaire.
L'avenir du pétrole irakien
Depuis quelques mois, la production pétrolière de l'Irak dépasse les deux millions de barils par jour, nettement au-delà des prévisions (de même que les exportations).
Pourtant, les experts prédisaient que l'insuffisance du financement, l'absence de sécurité, les problèmes liés à la mise en place d'un gouvernement légitime et la dégradation des installations limiteraient fortement la production pétrolière irakienne.
Malgré ces difficultés, depuis l'invasion elle a atteint en mars le niveau record de 2,5 millions de barils par jour.
Plusieurs éléments ont concouru à cela.
Le plus important est sans doute l'enveloppe de 2,3 milliards de dollars que le gouvernement Bush a versé à l'Irak pour l'aider à restaurer sa production pétrolière.
Au lendemain de l'invasion, personne ne s'attendait à ce que l'Irak obtienne des prêts, et encore moins des subventions.
Pourtant, 2,3 milliards de dollars ont été investis directement dans l'industrie pétrolière irakienne.
Pour protéger les champs de pétrole et diverses installations, les Américains ont envoyé massivement des troupes et engagé des sociétés militaires privées.
C'est un niveau de protection sans précédent, même comparé au régime de Saddam.

Le gouvernement Bush a fait appel aux meilleures sociétés de service pour la remise en état des champs pétroliers, qui sont parmi les plus riches du monde et permettent d'extraire le pétrole sans trop d'effort ni d'investissement.
En fin de compte, l'évolution des cours du pétrole durant les 12 derniers mois a été une chance inespérée pour le budget irakien qui a pu ainsi financer d'autres secteurs sans léser l'industrie pétrolière.
C'est également ce qui a permis à l'Autorité provisoire de la coalition d'augmenter la participation des sociétés militaires privées pour protéger les raffineries et les pipelines.
L'apport de fonds à l'Irak pour redresser son industrie pétrolière a été l'une des meilleures décisions d'après-guerre du gouvernement Bush.
C'est ainsi que l'Irak a pu commencer à traiter les questions de sécurité, de production et les problèmes techniques du secteur pétrolier.
Mais une question reste posée : l'augmentation de la production pétrolière va-t-elle se poursuivre maintenant, après le transfert du pouvoir à un gouvernement irakien ?
Depuis l'invasion, malgré un apport massif de fonds et un niveau de sécurité sans précédent, les rebelles ont plusieurs fois réussi à stopper ou à limiter la production pétrolière et les exportations.
Les attentats contre les pipelines et les autres infrastructures pétrolières sont quasi quotidiens et jusqu'à présent le transfert du pouvoir n'a pas permis de réduire leur nombre.
Le nouveau gouvernement irakien, même avec l'appui de la puissance militaire américaine, ne pourra pas garantir un niveau de production donné, et celui-ci restera difficilement prévisible.
Il est cependant essentiel de continuer à soutenir financièrement le secteur pétrolier irakien, non seulement pour assurer sa croissance, mais sa simple survie.
L'argent permet une remise à niveau de la technologie et apporte la sécurité.
Même sous les auspices les plus favorables et un prix du baril élevé, les fonds disponibles pour maintenir et moderniser l'industrie pétrolière vont rester limités.
Si le prix du baril baisse, l'industrie pétrolière va subir le choc de plein fouet.
Cette situation met l'Arabie saoudite en position d'intervenir sur la situation de l'Irak.
Seule l'Arabie saoudite pèse suffisamment sur la production mondiale de pétrole pour laisser de la place si elle le veut à l'Irak et maintenir les cours à un niveau élevé.
Mais elle peut aussi inonder le marché et provoquer une chute des cours.
Une diminution des revenus pétroliers pourrait être désastreuse pour un gouvernement irakien qui n'en est qu'à ses débuts.
Les revenus actuels, à peine suffisants pour couvrir les dépenses de l'Etat, ne permettront pas de financer la reconstruction, le remboursement de la dette et le payement des dommages de guerre.
Même en cas de réélection du président Bush, il est improbable que les USA continuent à verser des fonds à un Irak devenu souverain.
Théoriquement, ce financement pourrait être remplacé par des prêts internationaux. Mais un gouvernement instable, et qui plus est un gouvernement dont la légitimité n'est pas entièrement établie, pourra-t-il trouver un bailleur de fonds ?
Or une privatisation est également exclue pour l'instant.
Le nouveau gouvernement sera confronté à cette situation et devra prévoir du temps pour redresser son industrie pétrolière, à l'image de ce qu'avait fait le régime de Saddam.
Néanmoins, la logique d'un soutien renouvelé de l'Amérique à l'industrie pétrolière irakienne reste très présente.
Mais un financement de type habituel n'est probablement pas imminent.
Seule une injection de capitaux américains permettrait de réduire l'imprévisibilité de la production pétrolière.
Depuis 1973, chaque pic du prix du baril a été lié à un événement concernant l'Irak.
Le régime de Saddam a été la cause principale de la volatilité des cours du pétrole lors des 30 dernières années.
On aurait pu espérer que sa disparition diminuerait la volatilité du marché et stabiliserait les prix.
Malheureusement, à cause d'une production erratique, l'Irak continuera sans doute à être une cause majeure de la cherté du pétrole.
Dans l'avenir prévisible, la grande volatilité du marché pétrolier et un prix élevé du baril resteront comme l'une des conséquences notables de l'invasion de l'Irak.
Le dangereux fantasme de l'indépendance énergétique
accroît en réalité l'insécurité de leur approvisionnement en énergie.
Les hommes politiques qui appellent à l'indépendance énergétique préféreraient sans doute qu'il en soit autrement, mais c'est le marché qui a fait du pétrole une source d'énergie de première importance.
Aussi, seraient-ils avisés de tenir compte tant des moyens à mettre en oeuvre pour parvenir à cette indépendance que de l'intérêt légitime des pays exportateurs de pétrole et de leur réaction à la rhétorique sur l'indépendance énergétique.
Les dirigeants isolationnistes ne veulent peut-être pas en compte les autres pays, mais ils devraient y réfléchir à deux fois avant de se lancer sur une voie nuisible à leur propre pays.
Les plus grandes menaces qui pèsent sur la sécurité énergétique de la planète ne sont ni les attentats terroristes ni un embargo des pays producteurs - des événements à court terme auxquels il est possible de réagir rapidement et efficacement, notamment par le recours aux réserves stratégiques de pétrole, une augmentation de la production et une diversion des circuits d'approvisionnement.
En réalité, la principale menace à long terme est le déséquilibre entre d'une part l'augmentation de la demande en énergie et d'autre part l'investissement en infrastructure et en capacité de production supplémentaire.
En réponse à la stratégie des pays importateurs pour réduire leur dépendance à l'égard du pétrole ou s'en affranchir, les principaux pays producteurs pourraient réagir d'une manière qui risque d'envenimer la situation de l'énergie au niveau international, en décidant d'une baisse relative des investissements en capacité de production.
Dans ce cas de figure, une crise de l'énergie est quasi inévitable si ceux qui en appellent à l'indépendance énergétique n'apportent pas une solution alternative applicable en temps et en heure.
Mais les solutions de remplacement ne parviendront sans doute pas à se substituer au pétrole suffisamment tôt, car n'étant pas soutenues par le marché, elles devront être fortement subventionnées.
La rhétorique hostile des dirigeants politiques incite les pays exportateurs à augmenter leur production de manière à faire tomber les prix à un niveau qui réduira à néant la faisabilité économique des projets d'énergies alternatives - une politique interventionniste logique pour contrer la politique interventionniste des pays importateurs.
Une chute des cours du pétrole serait une condamnation à mort pour nombre de technologies de remplacement et augmenterait la demande en or noir.
Même si les pays producteurs ne font pas chuter volontairement le cours du pétrole, ils pourraient à coût terme accroître au maximum la production, pendant que le pétrole a encore de la valeur.
Mais une baisse des cours, couplée avec l'attente d'une baisse de la demande conduirait les pays producteurs à diminuer leurs investissements en capacité de production ou même à suspendre les projets les plus importants, comme ils l'ont fait dans le passé, ce qui conduira à une baisse de production.
Aussi, si les sources d'énergie alternatives ne sont pas disponibles lorsque la production de pétrole baissera, la pénurie mondiale sera inévitable. Et combler le déficit en matière d'investissement prendra des années, même en cas de hausse des cours.
Mettons de coté ces scénarios et plaçons nous dans le cas de la réussite de la politique d'indépendance énergétique, plusieurs pays européens, les USA, le Japon, la Chine et l'Inde devenant autosuffisants.
Comme le pétrole aura perdu sa valeur, les principaux pays producteurs pourraient l'utiliser sur le plan intérieur pour accroître leur industrie lourde.
Au lieu d'exporter directement leur pétrole, ils produiraient et exporteraient des métaux, des produits chimiques et des produits manufacturés, notamment vers l'Europe et les USA. Leur prix défierait toute concurrence en raison de la dépendance des pays importateurs à l'égard de sources d'énergie alternatives très coûteuses.
L'indépendance énergétique conduirait alors au démantèlement d'industries entières, dans le secteur de la pétrochimie, de l'aluminium et de l'acier.
Le pétrole bon marché des pays producteurs pourrait rendre leurs nouvelles industries compétitives à l'égard de celles de la Chine, de l'Inde et de l'Asie du Sud-Est.
Il en résultera une montée du chômage et des économies affaiblies.
L'indépendance énergétique pourrait ouvrir la voie à la dépendance à l'égard de l'acier ou de la pétrochimie.
Que nous réserve l'avenir ?
Les dirigeants politiques, avec leur fascination pour &quot;l'indépendance&quot;, vont-ils essayer d'éliminer la dépendance à l'égard de différentes matières premières, les unes à la suite des autres ?
Autrement dit, la cause de &quot;l'indépendance énergétique&quot; va-t-elle renverser le cours de la mondialisation ?
Le pétrole est une ressource finie.
Seule une stratégie énergétique viable à long terme et appuyée sur le marché peut assurer la croissance à la fois dans les pays producteurs et dans les pays consommateurs.
Les politiques isolationnistes conduisent toujours à la pénurie et au mécontentement.
Quelle que soit la voie empruntée pour tenter de parvenir à l'indépendance énergétique, ce n'est jamais rien d'autre qu'un fantasme irréalisable et potentiellement dangereux.
Le paradoxe de la crise iranienne
On entend souvent dire que l'Iran, du fait de ses ressources pétrolières et de ses réserves en gaz naturel, n'a pas besoin du nucléaire.
Mais dans le contexte d'une économie fragile et des pressions politiques dont il est l'objet, le gouvernement iranien doit fournir davantage d'électricité à une population qui augmente.
Les quantités croissantes de pétrole et de gaz naturel destinées à produire de l'électricité à son propre usage menacent les exportations de ces produits, première source de revenue de l'Etat.
La consommation intérieure de pétrole augmentant plus rapidement que la production, les revenus liés aux exportations de pétrole sont déjà en baisse.
L'énergie nucléaire permettrait de mettre fin à la baisse des revenus de l'Etat, car le pétrole et le gaz ainsi économisés pourraient être exportés.
Les réserves iraniennes en gaz naturel ne sont pas un substitut à l'énergie nucléaire bon marché, car son utilisation est plus rentable dans d'autres secteurs que celui de la production d'électricité.
Le gouvernement iranien craint qu'une pénurie d'électricité, une croissance économique insuffisante et un taux de chômage élevé n'entraînent le mécontentement de la population.
Si les tensions sociales augmentent, il y aura des conséquences politiques.
L'énergie nucléaire permet d'obtenir de l'électricité bon marché et en abondance, ce qui favorise la stabilité sociale et politique.
Les experts iraniens estiment que le gouvernement iranien doit choisir entre des troubles intérieurs et des sanctions internationales, entre la sécurité intérieure et la sécurité internationale.
Les pressions intérieures pourraient abattre le régime, mais pas les pressions internationales.
L'Histoire est du coté du gouvernement iranien.
La Révolution islamique a survécu à une guerre brutale avec l'Irak, à des sanctions économiques et à des décennies de pressions internationales et d'isolation de la part des USA.
Et les dirigeants iraniens se souviennent que malgré le fort soutien international dont il disposait, le Shah a été contraint à l'exil en 1979.
S'il y a des raisons pour que dans l'avenir le gouvernement américain - quel qu'il soit - s'oppose à un programme nucléaire iranien, même civil, les décideurs américains reconnaissent aussi que l'énergie nucléaire contribuerait à stabiliser le régime iranien.
Depuis 1979, les USA et l'Iran s'affrontent par alliés interposés et le conflit qui se prolonge entre eux signifie que les combats vont continuer au Liban, en Afghanistan et dans la région de la mer Caspienne, de même que la guerre commerciale et financière.
Aussi longtemps que la Chine et la Russie ont de l'argent à investir et des armes à vendre, les sanctions de l'ONU resteront sans effet.
L'Iran menace d'utiliser l'arme du pétrole, mais c'est très improbable.
Quel que soit le scénario, il n'est pas dans son intérêt de diminuer les exportations de pétrole, et encore moins de les arrêter.
Néanmoins, la pression intérieure, un certain sens du nationalisme et la nécessité de se placer en meilleure position pour négocier avec les pays occidentaux pourraient contraindre le gouvernement iranien à réagir face à des sanctions un peu trop brutales de l'ONU ou à une frappe aérienne sur ses installations nucléaires.
Mais même dans ces circonstances extrêmes, l'Iran ne pourra se passer des revenus du pétrole.
Il pourrait décider d'un embargo ou d'une suspension symbolique de l'approvisionnement pétrolier, mais sans impact réel sur le marché mondial du pétrole.
Le gouvernement iranien dispose de moyens plus efficaces pour répondre à une attaque des USA et de ses alliés.
Ses sympathisants en Irak pourraient s'en prendre aux exportations de pétrole de Bassora - ce qui porterait un coup aux plans américains pour l'Irak tout en dopant les revenus pétroliers de l'Iran - ou restreindre l'approvisionnement en carburant des forces américaines en attaquant les routes et les ponts, notamment l'axe Koweït City-Bagdad.
La communauté internationale continuera à payer le prix fort pour cette crise qui va peser sur le marché pétrolier dans les années à venir.
Selon certains experts, elle a déjà entraîné une hausse de quelques 15 dollars du prix du baril.
Paradoxalement, le programme nucléaire civil iranien contribuerait à renforcer la sécurité énergétique des USA et du reste du monde en accroissant la quantité de pétrole et de gaz disponible sur le marché mondial.
Mais la volonté américaine de déstabiliser l'Iran et la détermination du gouvernement iranien à conserver le pouvoir rendent ce scénario improbable.
Comment le cours du dollar affecte-t-il le prix du pétrole ?
Fixer le prix du pétrole en une seule monnaie a des implications bien plus vastes que ce que l'on pourrait croire.
Par exemple, certains pays producteurs de pétrole demandent à leurs clients de payer en euros, mais cela ne veut pas dire que le prix est en euros.
Et même si les prix en dollars devaient passer en euros, les conséquences du prix fixé en une seule monnaie seraient les mêmes pour le marché du pétrole.   
Bien que les pays exportateurs de pétrole encaissent des revenus en dollars (ou en euros), ils utilisent d'autres monnaies pour importer des biens et des services.
Toute modification du taux de change du dollar affecte le pouvoir d'achat de ces pays et donc leur revenu réel. 
En outre, les sociétés pétrolières internationales vendent la majeure partie de leur pétrole en dollars, mais elles opèrent dans plusieurs pays et règlent une partie de leurs dépenses en monnaies locales.
Tout changement du cours du dollar affecte donc la structure de leurs coûts et leur rentabilité, puis touche les réinvestissements en exploration, développement et maintenance.
La relation qui existe entre le cours du dollar et le prix du pétrole est très complexe.
S'ils peuvent s'alimenter l'un l'autre dans un cercle vicieux, leur relation à court terme est différente de celle à long terme.
À court terme, la dépréciation du dollar n'affecte pas l'offre et la demande, mais a des conséquences sur la spéculation et les investissements dans le secteur pétrolier.
Lorsque le dollar chute, les produits de première nécessité -- dont le pétrole -- attirent les investisseurs.
Investir dans le secteur pétrolier devient à la fois un rempart contre la chute du dollar et un moyen de placement pouvant entraîner des profits substantiels, en particulier dans un climat de déclin de la capacité de production excédentaire, de hausse de la demande, de chute des taux d'intérêts, d'effondrement du marché de l'immobilier et de crise du secteur bancaire.
L'OPEC n'a peut-être pas tort de dire que les politiques américaines et les spéculateurs sont responsables de la hausse des prix.
Il est aussi vrai que si l'OPEP avait une capacité excédentaire, elle s'en serait déjà servie pour se débarrasser des spéculateurs et baisser les prix du pétrole.
L'OPEP peut reprendre le contrôle de deux manières : se servir de sa capacité excédentaire "prétendue" pour "inonder" les spéculateurs, ou utiliser ses excédents financiers pour les dépasser.
Le recours à cette dernière option implique que, même sans capacité excédentaire, l'OPEP peut rester aux commandes.
Sur le long terme, cependant, l'analyse statistique de plusieurs variables de l'industrie pétrolière indique qu'un dollar faible a des conséquences sur l'offre en réduisant la production, que le pétrole appartienne à, ou soit produit par, des compagnies pétrolières nationales ou internationales.
La faiblesse du dollar affecte également la demande en augmentant la consommation.
Si l'offre baisse et que la demande s'accroît, les prix augmentent.
La faiblesse du dollar réduit également le pouvoir d'achat des exportateurs de pétrole.
Si le prix nominal du pétrole reste constant tandis que le cours du dollar chute, le revenu réel des pays producteurs de pétrole diminue, entraînant une baisse des investissements en capacité additionnelle et en maintenance.
Il en va de même pour les compagnies pétrolières.
En conséquence, le prix du pétrole augmente.
En fait, les prix du pétrole ayant augmenté pendant que le dollar chutait, l'expansion de capacité des compagnies pétrolières n'a pu correspondre aux prévisions pour les pays non-membres de l'OPEP durant ces trois dernières années.
Même aux États-Unis, la production de pétrole n'a pu correspondre à la hausse des prix, car la hausse des coûts d'importation de matériel et d'équipement -- due en partie à la faiblesse du dollar, mais aussi à d'autres facteurs -- a entraîné des retards et des annulations de projets.
Bien entendu, la chute du dollar rend le pétrole moins cher en Europe, en Asie, et dans tous les pays dont les monnaies sont en appréciation.
Le prix du pétrole a atteint des sommets aux États-Unis en 2004 et 2005, mais pas Europe, ce qui explique en partie pourquoi la croissance économique n'y a pas été affectée.
Lorsque les Américains paient le baril 120 $, les Européens ne le paient que 76 € environ !
Ces dernières années, plusieurs facteurs ont empêché la hausse du prix du pétrole d'avoir des conséquences sur la demande en produits pétroliers aux États-Unis, comme l'augmentation des dépenses gouvernementales, les taux d'intérêt bas, les réductions d'impôts et une augmentation des revenus réels.
La faiblesse du dollar a, à n'en pas douter, forcé certaines familles américaines à passer leurs vacances aux États-Unis plutôt qu'en Europe.
Mais, de nombreux Américains utilisant des 4X4 très gourmands en essence pour leurs vacances, la demande en pétrole est restée élevée.
Tant que les modèles de consommation américains n'auront pas changé ou qu'une hausse du dollar n'augmentera pas la production de pétrole, les Américains paieront la majeure partie des coûts engendrés par le fait que le prix du pétrole est fixé en une seule monnaie.  
La nouvelle mission de l'Europe en Afrique
Pour certains, la puissance militaire brute est la seule véritable mesure du pouvoir.
Mais les 16 missions militaires de l'Union européenne actuellement menées dans le cadre de la PESD ont bien plus à leur avantage.
Un soutien est nécessaire dans de vastes régions d'Afrique, auxquelles l'Europe peut et doit prêter main forte.
En outre, le nouveau style d'engagement politico‑militaire de l'Union européenne n'est pas un vestige du colonialisme en Afrique.
Il est vrai que bon nombre de pays africains souffrent actuellement d'instabilité, d'échecs gouvernementaux, de conflits régionaux, de violentes luttes intestines politiques et d'autres maux connexes, y compris des massacres et une brutalité à grande échelle, des guerres civiles, des mouvements massifs de réfugiés, des bouleversements économiques et des dégâts écologiques.
Pourtant, le tableau d'ensemble n'est pas uniformément sombre.
Certains pays africains sont relativement stables et prospères, et le continent est doté d'une population jeune qui dépassera bientôt le million d'individus, d'abondantes réserves minérales et d'un dynamisme intrinsèque.
En même temps, nous, Européens, ne pouvons nous permettre d'ignorer les problèmes de l'Afrique comme s'ils n'avaient pas d'impact sur nos propres sociétés.
Le projet européen a été construit sur des valeurs que nous considérons comme universelles, et nous devons faire un réel effort pour les faire respecter : non seulement parce qu'il s'agit d'un impératif moral, mais parce que c'est aussi dans notre intérêt stratégique.
L'Union européenne est de loin le plus grand marché d'exportation de biens africains, qui plus est, elle offre un foyer à de grandes communautés issues de presque tous les pays d'Afrique.
A l'inverse, de nombreux citoyens et détachés européens sont éparpillés dans toute l'Afrique.
Aux premiers stades d'une crise, l'intervention européenne -- par l'assistance politique et financière, l'intervention diplomatique et même les actions militaires -- peut empêcher que la violence n'éclate.
De plus, lorsqu'une crise touche à sa fin et qu'il devient possible de modérer les influences, l'intervention extérieure s'avère utile pour faire régner la paix et amener les factions en conflit à la table des négociations.
Dans les pays qui ont connu les horreurs de la guerre civile, l'arrivée d'une force militaire active extérieure est généralement la bienvenue, comme c'était le cas en 2003 et 2006 pour les opérations au Congo.
Par sa simple présence, une force de ce type témoigne de la bonne volonté et de l'engagement des nations qui l'ont envoyée. En apportant un sentiment d'ordre public, elle sert de force d'appui précieuse aux négociateurs honnêtes qui s'efforcent de parvenir à un accord de paix.
Si la politique européenne à l'égard de l'Afrique n'est peut-être pas parfaite, elle a au moins le mérite d'exister et d'avoir pour but de soutenir les États africains et les organisations régionales, comme l'Union africaine, chaque fois que c'est possible, nécessaire et par-dessus tout, sollicité.
La PESD prend en compte la politique européenne dans son ensemble et vise à fournir une aide en matière d'organisation, de formation et de logistique aux missions et aux forces créées par les États ou groupes d'États africains.
Par exemple, la notion récente de « renforcement européen des capacités de l'Afrique en matière de prévention, de réaction aux crises et de résolution des conflits » (connue sous le nom de « Recamp ») invite ouvertement l'Afrique à jouer un rôle majeur dans ce processus.
L'Europe n'a jamais prétendu avoir les moyens de redresser les déséquilibres stratégiques qui existent en Afrique -- elle n'a pas non plus l'intention de le faire.
Les pays de l'Union européenne possèdent toutefois des atouts considérables, notamment la capacité militaire nécessaire pour conduire des opérations décisives.
Mais l'atout le plus précieux est culturel : des soldats disposés à et capables d'interagir avec les populations locales, prudents dans leur façon d'employer leur force létale et prêts à accepter les nombreuses tendances au sein des parties en conflit.
Cependant, les capacités militaires européennes sont limitées et exigent que les planificateurs élaborent des options « minimales », avec l'inconvénient que des engagements moindres nécessitent généralement des perspectives de long terme.
La PESD n'est pas opérationnelle depuis assez longtemps pour avoir fait ses preuves.
Néanmoins, nos modestes tentatives en cours au Congo − une mission de conseil de la police (EUPOL) et une mission de réforme de la défense (EUSEC) − et au Soudan, où 60 Européens soutiennent le personnel de la mission AMIS II de l'Union africaine au Darfour, donnent de bonnes raisons d'espérer.
Il importe avant tout que les membres de l'Union européenne reconnaissent que les problèmes de l'Afrique doivent être résolus par les Africains.
C'est tout autant une question de principe qu'un froid calcul stratégique, et c'est pour cela que la PESD a beaucoup à offrir : une vision de long terme soutenue par une économie puissante disposant des atouts nécessaires pour mener à bien les opérations humanitaires, la prévention des conflits, la gestion des crises et le maintien de la sécurité.
L'avantage essentiel de la PESD est la connaissance et la compréhension culturelle que l'Europe a de l'Afrique.
A l'heure actuelle, les anciennes puissances coloniales évoluent singulièrement, tout comme leurs anciennes colonies.
Des deux côtés de la Méditerranée, les générations ont changé et de nouveaux liens se sont formés.
La connaissance, la compréhension et le respect mutuel demeurent et doivent être les pierres angulaires sur lesquelles construire la politique européenne pour l'Afrique.
Peut-on perdre la Turquie ?
À la fois le Parti pour la justice et le développement (AKP) et ses rivaux laïques s'engagent publiquement à rechercher l'adhésion à l'UE, mais en pratique des doutes sont apparus.
L'insistance du président français Nicolas Sarkozy pour qu'un référendum soit organisé conditionnant l'adhésion de la Turquie laisse penser que des années d'ajustement douloureux aux normes européennes ne se verront jamais récompenser par l'adhésion.
De toute évidence, les États-Unis et la Turquie sont convaincus que la Turquie n'a pas d'autre issue.
Les Turcs, pensent-ils, accepteront toute rebuffade avec fatalisme.
Mais cette hypothèse pratique néglige un changement tectonique dans la position géopolitique de la Turquie.
Lorsque l'Union soviétique s'est effondrée, la Turquie a considéré les États d'Asie centrale nouvellement indépendants avec une certaine nostalgie panturque.
Ces patries ancestrales exerçaient une emprise sur les imaginations turques, mais aujourd'hui il s'agit d'opportunités de travail, de ressources énergétiques et d'autres faits pratiques plutôt que d'unité ethnique qui créent une sorte de "commonwealth" turc.
Le plus frappant est le renouveau des relations entre la Turquie et la Russie, sans porter atteinte à ses liens avec les États post-soviétiques indépendants depuis peu.
L'ancien antagonisme de la Turquie envers la Russie a brièvement ressuscité lorsque l'Union soviétique a implosé.
Au début des années 1990, des généraux turcs ont considéré l'humiliation des troupes russes en Tchétchénie comme le début d'une vengeance longuement attendue.
Mais, alors que la Russie (et l'Iran) étaient autrefois les grands rivaux géopolitiques de la Turquie, aujourd'hui ce sont des marchés pour l'exportation et des fournisseurs d'énergie.
L'énergie est la clé de la nouvelle position géopolitique de la Turquie.
Son industrie et sa population connaissent une croissance dynamique, ses demandes énergétiques produisent par conséquent une synergie géopolitique avec la Russie et l'Iran, sans qu'aucun des deux ne puisse se permettre d'interrompre le flux de pétrole et de gaz sous peine de provoquer une crise interne massive.
Pendant ce temps, alors que l'attitude de la Turquie envers ses voisins a changé, son élite au pouvoir a vu l'UE s'associer à des pays anciennement communistes aux économies de marché bien moins assurées et au passé démocratique bien plus bref.
Comme l'a souligné un général turc, "si nous avions rejoint le pacte de Varsovie plutôt que l'Otan, nous serions membre de l'UE aujourd'hui."
La réélection, l'été dernier, de l'AKP du Premier ministre Recep Tayyip Erdogan, suivie de l'élection d'Abdullah Gul comme premier président à l'épouse voilée, semblent confirmer les craintes des Européens anti-islamiques.
Pourtant, même si de nombreux activistes et d'électeurs de l'AKP sont de fervents musulmans, Erdogan et Gul restent convaincus par l'intégration européenne.
Mais il est urgent de parvenir à l'adhésion européenne s'ils veulent satisfaire leurs partisans et intimer silence à leurs détracteurs.
Le problème est que les victoires de l'AKP, ainsi que les sollicitations de l'Amérique d'Erdogan et de Gul, ont déclenché une crise de direction parmi l'élite laïque autrefois dominante et pro-occidentale de Turquie.
Même si l'AKP peut s'appuyer sur l'allégeance de millions d'électeurs et sur des myriades de nouveaux membres soucieux de rejoindre le camp des vainqueurs, les laïcistes sont profondément établis dans les institutions, les universités, les médias et le monde des affaires turques.
Mais à la fois les partisans ordinaires de l'AKP et les laïcistes déçus éprouvent aujourd'hui quelques soupçons face aux agissements de l'Amérique et à ses motifs dans la région.
Le soutien tacite par des personnalités militaires majeures du refus du Parlement turc d'adhérer à l'invasion américaine de l'Irak de mars 2003 suggère que le nationalisme turc pourrait unir la base des députés AKP avec leurs ennemis implacables du camp laïc.
Si l'UE rejette ouvertement la possibilité d'adhésion de la Turquie, ou si l'Amérique se montre trop laxiste face au problème kurde du nord de l'Irak, une grande partie des deux camps pourrait bien s'unir.
Les liens de la Turquie et d'Israël, par exemple, ont été mis à rude épreuve par l'investissement israélien au Kurdistan.
Alors que Shimon Peres a fait un geste de réconciliation en choisissant Ankara comme cadre du premier discours par un président israélien au parlement d'un pays à prédominance musulmane, les inquiétudes d'Israël au sujet de l'Iran sont bien plus sérieuses que celles de la Turquie.
Les deux pires ennemis jurés d'Israël, l'Iran et la Syrie, figurent en fait parmi les supporters les plus enthousiastes de la position radicale turque envers les Kurdes.
La conquête de l'Irak par l'Amérique a déstabilisé l'orientation occidentale de la Turquie plus que les États-Unis ne veulent bien l'admettre.
La plupart des Turcs ne veulent pas que leur pays soit exclu de l'Occident, mais si l'UE les éconduit tout en accélérant le processus d'entrée de candidats plus faibles, la Turquie pourrait se sentir suffisamment forte et amère pour choisir de changer d'orientation géopolitique.
L'arche de l'euro
Confronté à la plus grande épreuve de son histoire, l'euro est loin de voguer droit au désastre, comme l'économiste nobélisé Milton Friedman l'avait pourtant prédit il y a dix ans.
Au contraire, l'Union économique et monétaire européenne s'avère être un atout de taille en cette période de tumulte.
Les sceptiques feraient bien de se rappeler que l'euro est lui-même né d'une crise.
La monnaie unique a été conçue comme une réaction aux bouleversements de l'après-guerre -- inflation à deux chiffres, forts taux de chômage et attaques spéculatives sur la livre, la lire et le franc français.
C'est la crise du Système monétaire européen qui a conduit au lancement de l'euro, le 1er janvier 1999.
En dix courtes années, l'euro a bouleversé l'environnement économique, s'élevant au statut de deuxième monnaie mondiale et rivalisant avec le dollar comme moyen de paiement international, pour le commerce et la finance.
L'Union monétaire européenne est aujourd'hui le plus vaste marché du monde, et elle continue de grandir.
Avec l'entrée de la Slovaquie le 1er janvier, l'euro concerne désormais 16 pays et 329 millions de citoyens.
Les bénéfices d'une union monétaire basée sur un cadre économique stable et gouvernée par une banque centrale indépendante sont manifestes : la zone euro a connu une inflation et des taux d'intérêt bas pendant la majeure partie de la dernière décennie, un élan dans les domaines du commerce et de l'investissement, et une intégration rapide des marchés financiers.
En outre, 16 millions d'emplois ont été créés au cours des 10 dernières années -- record encore plus élevé qu'aux États-Unis.
Les troubles financiers et la récession économique que nous traversons ne font que souligner les avantages de l'Union monétaire de plusieurs importantes façons.
Tout d'abord, l'euro a éliminé les possibilités de turbulences de taux de change et d'attaques spéculatives sur les devises auxquelles les économies les plus vulnérables auraient pu s'attendre dans le contexte d'agitation actuelle.
En tant que devise mondiale stable et forte, l'euro limite aussi l'instabilité des taux de change internationaux.
Ensuite, la zone euro bénéficie d'une Banque centrale européenne indépendante dont les actions rapides visant à débloquer les tensions de liquidités et à coordonner la politique monétaire ont récemment contribué à éviter un effondrement financier.
Des démarches aussi rapides et coordonnées par 16 banques centrales distinctes auraient été impensables.
Enfin, le cadre macroéconomique orienté vers la stabilité de l'Union monétaire a mieux préparé les pays de la zone euro aux tempêtes économiques.
Grâce aux règles fiscales du Pacte de stabilité et de croissance, la zone euro a atteint sa position budgétaire la plus solide en 2007, amenant les déficits à leurs plus bas niveau depuis 25 ans.
Cela a permis à de nombreux pays de l'Union européenne d'aborder la crise avec une bonne marge de manœuvre.
Les bénéfices de l'Union monétaire sont tels que les coûts visibles de la non-adhésion contribuent à relancer le débat politique autour de l'adoption de l'euro dans plusieurs pays non-membres.
Certes l'euro n'est pas une panacée, et n'a pas non plus fonctionné sans heurts au cours des dix dernières années.
Les divergences entre économies de la zone euro en termes de croissance et d'inflation ont constitué un défi permanent.
Même si les différences ne sont pas plus importantes que celles que l'on trouve à l'intérieur de grandes économies comme celles de l'Allemagne ou des États-Unis, elles risquent de se voir amplifier par la crise.
C'est pourquoi il est encore plus important de continuer à perfectionner le fonctionnement de l'Union monétaire.
Cela ne demande pas simplement la consolidation des systèmes de résilience face à la crise, mais nécessite aussi d'équiper les économies de la zone euro en vue des défis à long terme que représentent la mondialisation, le vieillissement, la raréfaction des ressources et le réchauffement climatique.
Dans une économie mondiale potentiellement plus instable au XXIe siècle, il nous faut récolter des bénéfices maximum de l'intégration économique en termes de croissance et d'emplois.
La clé d'un meilleur fonctionnement de l'Union monétaire réside dans une surveillance plus rapprochée et une coordination plus approfondie des politiques économiques.
Les dirigeants doivent se montrer à la hauteur des responsabilités qui accompagnent le partage d'une monnaie.
Ils doivent reconnaître l'impact des politiques économiques nationales sur la zone euro dans son ensemble, et ainsi discuter et coordonner les programmes économiques au niveau de la zone euro.
À cet égard, le lancement du Plan de relance économique européen -- une initiative d'incitation fiscale à l'échelle de l'UE équivalant à 1,5 % de son PIB, approuvée par les chefs de gouvernements européens en décembre -- constitue un pas en avant décisif.
Il doit à présent être suivi d'un contrôle budgétaire plus rapproché, d'autant que les mesures d'incitations fiscales, la récession économique et les plans de sauvetage des banques vont ébranler les finances publiques.
Le Pacte de stabilité et de croissance doit demeurer la pierre angulaire du cadre budgétaire de l'UE, et la surveillance efficace et le soutien des pairs seront essentiels pour aider les États-membres à se diriger vers des budgets équilibrés une fois que l'économie se sera ressaisie.
Une surveillance fiscale plus approfondie doit s'accompagner d'une plus large surveillance économique, notamment parce que les déséquilibres des balances courantes se sont accentués pendant la crise.
La Commission européenne travaille aujourd'hui à étendre la cible de la surveillance au-delà de la politique fiscale pour qu'il devienne possible d'identifier les risques issus de déséquilibres macroéconomiques ou de changements de compétitivité et de s'en occuper avant qu'il ne soit trop tard.
Enfin, les pays de la zone euro doivent travailler davantage à trouver des positions communes sur les sujets internationaux afin de parler d'une seule voix dans l'arène mondiale.
C'est la seule manière de promouvoir et de défendre les intérêts économiques de l'Union monétaire face à des défis mondiaux, et, pour en venir à bout, la coopération multilatérale sera de plus en plus nécessaire.
Prenons le sommet international de novembre sur la crise financière.
Le fait d'être parvenu à un accord avant la réunion a donné à l'Europe un rôle plus conséquent.
Quand la zone euro parviendra à adopter rapidement une position commune, cela permettra de parvenir à un accord à l'intérieur de l'UE comme sur la scène internationale.
Il faut absolument que nous bâtissions sur ce succès et que nous développions une vraie stratégie internationale pour l'euro.
La monnaie unique européenne a été un grand succès, mais elle reste en chantier.
Dix ans après l'introduction de l'euro, nous devons suivre l'exemple de ses fondateurs et transformer la crise en opportunité en nous unissant dans un esprit de coopération et d'ambition -- et, ainsi, consolider les fondations de l'Union monétaire européenne.
Les droits de l'Homme survivront-ils au récent boom pétrolier en Afrique
L'économie de la région a été dopée en 2003 par la mise en service du pipeline Tchad-Cameroun, un projet de 4,2 milliards de dollars soutenu par la Banque mondiale qui est supposé stimuler l'exploration et la production pétrolière au Tchad, ainsi que celle des sites offshore de Nouvelle Guinée, et apporter des bénéfices aux régions traversées.
Ainsi, du fait que le pipeline traverse son territoire sur 890 kilomètres, le Cameroun va engranger 450 millions de dollars net par an en droit de passage et en royalties pendant 25 à 30 ans.
Tout cela a été possible grâce à ce qui a été, historiquement parlant, une période exceptionnellement longue de stabilité politique.
Au Tchad, le pétrole a été découvert en 1975 dans le sud du pays, dans la région de Doba ; 300 puits y ont été creusés.
Mais ces gisements n'ont été exploités qu'à partir de 1988, à la fin de la guerre civile qui a longuement déchiré le Tchad.
On aurait pu croire qu'avec le pétrole, la vie des Tchadiens et des Camerounais allait s'améliorer, tant au niveau individuel que local ou national.
Mais c'est la pauvreté généralisée dans un contexte de corruption endémique et de gestion calamiteuse par les autorités.
Jusqu'à présent, ni le gouvernement tchadien ni le gouvernement camerounais n'ont rendu public le bilan financier lié au projet de pipeline.
Ce manque de transparence n'a rien de surprenant.
C'est pour cela que la Banque mondiale a imposé des conditions très strictes au Tchad et au Cameroun.
Elle a exigé que ces deux pays déposent 10% des revenus pétroliers attendus sur un compte bloqué à l'étranger, ceci au bénéfice des générations futures.
Au moins 80% de ces revenus devaient être investis dans l'éducation, la santé, les infrastructures routières et électriques et l'eau potable, 5% devaient être réservés aux populations habitant dans les zones pétrolières et sur le parcours du pipeline.
Et les comptes du pétrole devaient faire l'objet d'audits périodiques.
Initialement, le Tchad et le Cameroun devaient participer au projet à hauteur de 140 millions de dollars chacun, mais ces sommes ont été entièrement versés par la Banque mondiale et la Banque européenne d'investissement.
Il est entré en service en juillet 2003, 16 mois plus tôt que prévu, avec un débit qui a culminé à hauteur de 225.000 barils de pétrole par jour à la fin de cette année là.
Aujourd'hui, soit 30 mois plus tard, la population s'agite et demande quand elle va bénéficier de la manne pétrolière.
On a beaucoup parlé des "Host Government Agreements", les accords entre le consortium ExxonMobil et les gouvernements hôtes du Tchad et du Cameroun qui régissent la construction et l'exploitation des champs pétroliers de Doba et du pipeline.
D'après ce rapport, les "Host Government Agreements" fixent un coût aux droits de l'homme en prévoyant de lourdes indemnités en cas d'interruption de l'exploitation du pipeline ou des champs pétrolifères, même si c'est pour appliquer des lois en vigueur.
Et durant cette même période, l'espérance de vie a augmenté de 11 ans.
Pourtant, cette évolution n'a pas empêché une formidable amélioration du niveau de vie des retraités.
D'ici à 2040 (on prévoit qu'à cette date il n'y aura plus que deux personnes en âge de travailler pour subvenir aux besoins d'un retraité alors qu'il y en a quatre aujourd'hui), pourquoi le scénario que nous avons connu depuis la guerre ne se reproduirait-il pas ?
La raison en est simple : les obligations en matière de solidarité ne sont plus ressenties aujourd'hui comme elles l'étaient hier.
Après la guerre, les retraites étaient notoirement faibles et leur coût modeste pour les actifs.
Dans ce contexte, la croissance économique aidant, les actifs ont accepté volontiers une progression continue de leurs charges pour les financer.
Mais aujourd'hui, dans tous les pays le revenu moyen des retraités s'est considérablement amélioré et il est même parfois supérieur, comme en France, à celui des personnes actives.
La revalorisation des retraites d'une part, l'accroissement continu des cotisations et des impôts d'autre part ont conduit à une situation dans laquelle les actifs ne sont plus disposés à à accroître leur contribution en faveur des retraites obligatoires.
Dans les années qui viennent, le développement en Europe des régimes de retraites complémentaires par capitalisation est incontournable.
Mais son essor est aussi une chance pour le développement de nos marchés financiers européens qui accusent un retard dommageable à la croissance économique et à l'emploi.
Les pays où les fonds de pension sont les plus développés (les Etats-Unis et la Grande-Bretagne) sont aussi ceux qui ont la plus forte capitalisation boursière.
Enfin il faut associer l'entreprise à la constitution de cette retraite complémentaire.
Il y a sur la table une proposition de directive de la Commission concernant les retraites professionnelles.
Mais il faut être plus ambitieux.
L'Union Européenne devrait ainsi mettre en place un cadre fiscal commun minimum adaptable à tous les produits d'épargne retraite par capitalisation quels qu'ils soient : fonds de pension, assurance vie, épargne salariale.
Concrètement les salariés qui ouvriraient ces plans dans l'organisme de leur choix, et sous la forme qui a leur préférence (fonds de pension …), pourraient déduire leur cotisation (plafonnée) de leur impôt sur le revenu ou à défaut recevoir un crédit d'impôt.
Ces versements devraient être systématiquement abondés par l'employeur à due concurrence.
Le dispositif fiscal devrait favoriser la sortie en rentes, sans exclure (moyennant le paiement d'un ticket de sortie) la possibilité d'une sortie en capital.
Certes, l'Europe ne saurait s'orienter dans cette voie sans que deux conditions préalables soient réunies : d'abord un changement d'attitude vis-à-vis de l'épargne.
Les Européens doivent cesser de battre leur coulpe au motif qu'ils ne consommeraient pas assez et qu'ils épargneraient trop.
En effet, l'Europe qui doit investir plus a en réalité besoin de plus d'épargne.
Ensuite, un infléchissement des politiques économiques, qui doivent être plus résolument orientées vers la promotion des investissements, la productivité et de la croissance.
Car si ce surcroît d'épargne ne devait servir qu'à financer les déficits publics, voire les investissements industriels Outre-atlantique (comme c'est encore trop le temps aujourd'hui), alors on pourrait s'interroger sur l'intérêt à la stimuler.
Régulièrement, l'Europe se doit d'accomplir des actes politiques fort.
Ce fut le cas avec l'euro.
Souhaitons qu'elle saisisse l'occasion qui se présente aujourd'hui avec les retraites.
L'Europe et le Président Bush
ROME : Que va-t-il advenir des relations transatlantiques ?
La question se repose avec chaque nouvelle administration américaine.
Depuis le début des années 70 on n'a cessé de se préoccuper de l'élargissement du fossé transatlantique, il est donc tentant de continuer à faire comme si les relations transatlantiques allaient garder à peu près le même ton.
Mais en fait, les Etats-Unis et l'Union Européenne sont en train d'avancer rapidement sur des chemins différents : chaque côté de l'Atlantique doit donc relever le défi en gérant une relation de plus en plus complexe.
Deux autres tentations doivent être combattues.
Du côté européen, celle d'accélérer l'émergence de l'Union en tant qu'acteur international en proclamant sans cesse autonomie ou indépendance vis-à-vis des Etats-Unis.
Un anti-américanisme sous-jacent refera inévitablement surface, et comme dans toute longue relation déséquilibrée, le partenaire le plus faible aura tendance à faire des déclarations qui donneront lieu à de fausses interprétations.
Les Européens ne devraient pas succomber à cette tentation, car la distance entre la dépendance et le partenariat ne se mesure pas en termes de rhétorique.
Les Européens doivent, au contraire, assumer une part honnête du fardeau transatlantique, mettre en place une politique étrangère européenne vraiment commune, penser et agir comme un pouvoir régional à la portée mondiale.
Si l'Euro est un succès, comme je le crois, en tant que monnaie mondiale, et si la force de réaction rapide de l'Europe devient une réalité prochainement- comme je le crois également- l'Union Européenne se sera assurée les premières conditions nécessaires à un partenariat équitable- en plaçant son argent (et ses soldats) là où elle a annoncé qu'elle les mettrait, joignant ainsi littéralement l'acte à la parole.
Du côté des Américains, la tentation est celle de jouer la carte de la "super puissance unique" en agissant de manière unilatérale.
Ce qui équivaut à déguiser un sentiment de solitude en autorité, et n'agit pas dans l'intérêt de l'Amérique.
Les intérêts nationaux ne peuvent plus être poursuivis de façon unilatérale ; les intérêts mondiaux des Etats-Unis sont mieux servis par des ensembles multilatéraux
Même si, en termes militaires, l'Amérique demeure la seule superpuissance, la force armée est d'une utilité limitée dans la conduite quotidienne de la politique étrangère.
L'Amérique profiterait autant que l'Europe d'un système efficace de direction mondiale pour atteindre ses objectifs, qu'il s'agisse de libéralisation du marché, d'un régime de non-prolifération nucléaire viable, de la maîtrise et de la prévention des conflits régionaux ou de la meilleure régulation des marchés financiers.
Dans cette optique, la maturation de l'Union Européenne en tant qu'acteur international représente pour les Etats-Unis un intérêt vital à.
Elle devrait donc se libérer de l'ambivalence traditionnelle entre l'exigence d'une Europe plus mûre et plus active d'un côté et un sentiment de malaise à ce propos de l'autre.
Il est vrai que l'Amérique est officiellement favorable à la promotion d'une politique de défense et de sécurité européenne commune.
Mais il existe des signes récurrents de nervosité de la part des Etats-Unis à propos de la nature de cette évolution.
Les Américains demandent fréquemment si elle concerne l'amélioration des moyens européens, ce qui conviendrait à l'OTAN, ou l'unification européenne (c'est à dire en vue d'à un projet politique).
Ma réponse est que cela concerne les deux sujets et que Washington devrait les soutenir tous deux.
Une simple évaluation de cette évolution me conduit à affirmer qu'une Europe plus compétente et plus unie mènera à une Alliance Atlantique plus efficace et non comme certains le croient au désengagement progressif de l'Amérique dans les questions européennes.
Le but de l'Union Européenne n'est pas de copier les structures de l'OTAN ou de créer une alternative à l'Alliance Atlantique.
L'Union Européenne se prépare à agir- soit avec les forces américaines, soit avec des forces purement européennes si l'OTAN, en tant qu'ensemble, décide de ne pas s'engager - dans des crises qui concernent l'Europe.
Plus que sa défense, dont le centre restera l'OTAN, l'Europe construit son rôle dans la sécurité en tant que modérateur régional: un rôle que renforcera l'élargissement de l'Union Européenne pour accueillir des pays candidats venant de l'Europe Centrale et Orientale.
Car, contrairement à ce que l'on entend régulièrement au Congrès américain, l'Europe assume déjà la part du lion en ce qui concerne la charge de sauvegarder la paix (sans parler de l'aide à la reconstruction) dans les Balkans.
Il va sans dire qu'il ne devrait pas y avoir de "contributions sans représentation".
Si la politique de l'Europe en matière de relations étrangères et de défense est couronnée de succès, l'OTAN devrait devenir une organisation plus européenne.
Mais Washington ne devrait pas s'inquiéter à ce propos: si les Européens considèrent l'Alliance comme une organisation plus européenne, ils investiront certainement plus (en termes de budget également) dans la poursuite de son succès.
Une logique similaire de partenariat devrait s'appliquer à un élargissement.
Le concept d'Europe n'est pas immuable, et à juste titre.
Sur la base d'une idée large de la sécurité et de la stabilité, l'élargissement de l'Union Européenne est tout aussi important que son approfondissement.
Ici, une approche transatlantique commune à propos de l'élargissement de l'Union Européenne mais aussi de l'Otan accroîtrait le degré de stabilité et d'unification dans l'Europe de l'après guerre froide - au profit de tous.
Une nouvelle division fonctionnelle du travail entre Européens et Américains est donc envisageable, à condition qu'elle soit adoptée dans le cadre d'engagements politiques communs et de partage des responsabilités.
Mais il faut éviter une division du travail rigide, verticale et artificielle, dans laquelle les Etats-Unis joueraient le rôle du dirigeant mondial solitaire (avec l'Europe dans son sillage) tandis que l'Europe poursuivrait uniquement le but d'élargir sa "maison" (les Etats-Unis se désengageant de la sécurité du Continent).
Cela serait malsain et rendrait le complexe transatlantique impossible à maintenir.
L'antidote dans ce cas est un partage véritable des choix et des décisions.
Si des décisions conflictuelles doivent être prises, un partenariat sain exige qu'elles soient discutées ouvertement et honnêtement.
Par exemple, le problème du système américain de défense antimissiles (NMD).
Quelle que soit la politique adoptée par l'administration Bush, elle devra prendre en compte les doutes et les réserves de l'Europe.
Si les Européens souhaitent exercer une influence sur ce point, ils devront jouer un rôle unitaire en encourageant, par exemple, l'Amérique à réviser le Traité ABM en accord avec Moscou.
Cela favoriserait la stabilité stratégique, permettrait de ne pas irriter Moscou (qui reste un facteur fondamental de la sécurité européenne) et d'éviter de détériorer le climat de sécurité en Asie.
Cela est vrai également pour le problème des soi-disant " Etats hors-la-loi", là encore, une meilleure combinaison des stratégies américaines et européennes pourrait aboutir à une approche plus efficace, appuyée sur une association d'engagement et de résolution.
Une nouvelle division du travail et un nouveau partage des responsabilités dépendent autant de l'économie que de la sécurité.
Un Euro stable renforce et assure une plus grande coopération: non seulement pour contrer l'instabilité financière mondiale mais aussi pour éviter le risque de conflits entre blocs de devises.
A condition que l'Administration Bush fasse pression pour plus de libre-échange, nous réussirons à renforcer l'unification du marché transatlantique, ce qui agira en faveur de nos deux économies.
Il y aura alors également des possibilités de relancer l'OMC, un fort engagement Américano-européen étant une condition préalable nécessaire, mais pas la solution complète.
Une sérieuse réévaluation de nos techniques de négociations et de nos vieilles habitudes est nécessaire.
L'OMC, mais aussi le FMI et la Banque Mondiale, doivent comprendre les besoins en cours de mutation des sociétés les plus vulnérables à l'impact de la mondialisation.
Nous devons nous ouvrir sur le reste du monde d'une manière plus directe et persuasive.
Le G-8, que l'Italie préside cette année, aidera à tester cette résolution, sur laquelle repose la légitimité de tout le processus.
Un partenariat américano-européen renouvelé et s'appuyant sur nos styles et moyens respectifs en termes de politique étrangère sera bénéfique aux deux parties.
L'Union Européenne cherche à juste titre son identité en tant qu'acteur collectif.
Alors que l'Europe change, c'est également ce que fait l'Amérique - en termes de composition sociale, de structures politiques et économiques, d'orientation géopolitique et de mentalité nationale.
Je reconnais que la diversité transatlantique risque de causer des querelles.
Mais l'interaction mutuelle et le partenariat égalitaire demeurent la seule réponse -- particulièrement s'ils se reflètent dans les réformes longtemps attendues des institutions multilatérales et dans un accroissement de la part de la direction mondiale.
Opérer à l'intérieur de cadres multilatéraux, même si cela se révèle parfois fatigant, a plus souvent servi les intérêts nationaux des Etats-Unis que le contraire, sans parler de ceux de l'Europe.
Cela ne changera pas.
Une Union Européenne plus forte est la partenaire naturelle de l'Amérique, sa concurrente occasionnelle mais certainement pas sa rivale.
Il est du devoir des gouvernements -- de chaque côté de l'Atlantique -- d'en persuader leur public.
L'Europe, petit à petit
Il est certain que l'impatience et la frustration sont depuis le début des forces motrices de l'intégration européenne.
Comme l'affirmait Robert Schuman dans sa Déclaration de 1950 : « l'Europe ne se fera pas d'un coup ».
De même, comme l'a écrit sur le tard Altiero Spinelli, autre père fondateur de l'Union européenne, sans visionnaires européens, il n'y aurait pas d'Europe ; mais sans hommes d'État pragmatiques, les visionnaires seraient allés nulle part.
Les points faibles du Traité de réforme sont évidents.
L'abandon de l'intitulé « constitution » était probablement nécessaire pour remettre les États membres en selle.
Toutefois, il n'était pas utile de faire durer les incertitudes quant à la plateforme politique commune sur laquelle la voix européenne devra compter en politique étrangère.
Qui plus est, l'espace de liberté, de sécurité et de justice exige toujours l'unanimité pour les décisions essentielles en matière de lutte contre le crime et le terrorisme -- ce qui signifie que les processus sont parfois d'une lourdeur insoutenable.
Le Traité ne suffit pas non plus pour renforcer la coordination des politiques économiques et budgétaires européennes.
Par ailleurs, des agences telles qu'Europol et Eurojust seront elles aussi soumises à un examen parlementaire approfondi ; quand à la procédure budgétaire, elle sera plus simple et démocratique.
La Charte des droits fondamentaux de l'Union européenne deviendra juridiquement contraignante et la protection judiciaire des citoyens sera améliorée grâce à un accès simplifié à la Cour européenne de justice et à l'élargissement de sa compétence.
De plus, le rôle de l'Union sur la scène mondiale sera consolidé par le fusionnement du poste de Haut représentant avec celui de Commissaire aux relations extérieures, et par la mise en place d'un service diplomatique unique.
Le Futur constitutionnel de l'Europe
La semaine dernière, le Président de la Convention européenne, M. Valéry Giscard d'Estaing, a proposé un "squelette" pour la future constitution de l'Europe.
Tous les ingrédients d'une constitution - valeurs, principes, droits des citoyens, les compétences de l'Union et ses institutions constitutifs, etc. - y sont inscrits.
Ce document existe en dépit du fait que le mandat de la Convention ne donne aucun pouvoir à ses délégués pour produire une constitution.
Selon la Déclaration de Nice, à laquelle je pris part en qualité de premier ministre participant, nous ne devions que simplifier et restructurer les traités fondamentaux de l'UE.
Selon le fonctionnement de la C onvention, notre mandat fut transformé à la suite de diverses pressions.
Ces pressions viennent des pays membres, des organisations de la société civile, et de lettres, de documents et de courriers électroniques en provenance de l'Europe toute entière.
C'est la pression populaire qui a changé notre mandat.
Quand c'est le ministre des affaires étrangères de la Grande-Bretagne, pays qui s'enorgueillit depuis des siècles de ne pas avoir de constitution écrite, qui réclame lui-même une constitution européenne écrite, alors, oui, les temps changent !
Pourtant, des chercheurs universitaires tels que Ralph Dahrendorf et Joseph Weiler suggèrent qu'une constitution européenne n'a pas de sens puisqu'une constitution démocratique nécessite un sentiment d'identité commune suprême qui manque à l'UE, où les loyautés nationales individuelles ont encore cours.
D'autres, comme Robert Dahl, soutiennent que la démocratie se fonde sur des communautés plus petites elles-mêmes fondées sur des intérêts partagés et des relations personnelles.
Pour eux, l'Europe semble être trop grande pour donner naissance à des institutions réellement démocratiques.
De telles objections théoriques doivent être examinées à la lueur de l'existence factuelle de l'Europe : en fait, des décisions qui déterminent nos vies sont prises quotidiennement à l'échelle de l'Europe.
Nous n'aimons peut-être pas cela, mais l'UE fait partie de notre système de gouvernement, comme les municipalités, les régions et les États souverains.
Ainsi la question n'est pas de savoir si l'Europe existe ou pas, mais bien plutôt de savoir si nous sommes satisfaits de son mode de fonctionnement.
Si nous ne le sommes pas, que pouvons-nous y faire, et une constitution représente-t-elle le meilleur moyen de parvenir à nos buts ?
Le premier problème ayant besoin d'une solution "constitutionnelle" à résoudre porte sur la question d'une identité européenne claire et unifiée.
Peu de gens comprennent qu'à cause du patchwork des traités qui ont donné naissance aux institutions européennes contemporaines, l'Europe n'est pas une entité unitaire. En fait, l'Union Européenne et la Communauté Européenne dénotent de deux choses différentes.
La Communauté est un ensemble d'institutions créées dans les années 50 pour établir un marché commun.
Quand on décida par la suite de mettre en place une politique étrangère commune, et de coopérer au niveau juridique et policier, nous inventâmes alors l'Union.
L'Union s'occupe de politique étrangère et la Communauté de l'intégration économique.
Une des conséquences de cet état de fait implique que tout accord avec des pays tiers qui comporte ces deux aspects de politique économique et de politique étrangère nécessite deux traités distincts : un pour l'Union, un autre pour la Communauté.
Cela confond même les diplomates étrangers aguerris dans leurs négociations avec l'Europe.
Si cela les confond, imaginons combien cela peut-être confus pour les citoyens ordinaires !
Comment le citoyen européen peut-il réellement s'identifier à l'Europe s'il n'existe aucune "Europe" unique ?
L'identité légale indistincte de l'Europe a un autre effet délétère.
Si la Communauté agit de sorte à affecter les droits d'une personne, cette personne peut engager un procès.
Mais si l'Union entame les droits d'une personne, le recours aux tribunaux est impossible puisque l'Union n'a pas valeur d'entité légale !
Le second problème à résoudre qui a encore des implications constitutionnelles concerne la nature anonyme et bureaucratique des actes législatifs européens.
La critique des institutions est aussi vitale à la démocratie que la protection des droits légaux inscrits.
Mais les institutions européennes sont difficilement critiquables puisqu'elles produisent des actes que le citoyen ordinaire ne peut définir ni comprendre.
À l'échelle nationale, les actes parlementaires s'appellent "décrets" ou "lois" et portent des noms auxquels on peut s'identifier ou que l'on peut combattre.
À l'échelle de l'UE, nous avons des "règlements" et des "directives", des "décisions" et des "directives générales", des "stratégies communes", des "actions communes", des "positions communes" : une myriade d'appellations que seuls les experts peuvent comprendre.
Quand une "directive" est formulée, personne ne sait qui en est le responsable. Au lieu de cela, on la connaît sous l'appellation "Directive 17.62" (indiquant que c'est la directive n° 17 de l'année 1962).
En Italie, il existe aujourd'hui un décret qui porte à controverse changeant les règles de procédure criminelle qui pourrait se montrer très pratique pour les personnages de la scène publique.
Le nom du sénateur Cirami est attaché à cette loi.
On peut ainsi se battre la "loi Cirami"!
En serait-il de même si la loi était intitulée "Régulation 75" ?
Puisque l'Europe tant de corps légiférant (le Conseil des ministres, le Conseil pour l'agriculture, le Conseil pour l'industrie, le Conseil pour l'environnement, etc.), on ne peut savoir qui fait quoi et pourquoi.
Nous avons besoin d'un conseil législatif unique, un parlement européen avec deux chambres, l'une où siègeraient les représentants des États membres, l'autre où siègeraient les élus européens.
Dans ce système simplifié, la législation s'appellerait législation et les décisions exécutives, comme dans la plupart des systèmes légaux, combleraient les manques de la législation principale.
C'est un système que les citoyens européens peuvent comprendre.
L'embryon de document constitutionnel introduit la semaine dernière propose quelques petits changements significatifs qui pourraient permettre aux citoyens européens de s'identifier à l'Europe et d'en faire la critique.
Il fait appel à une entité légale unique et unifiée.
Quel que soit sa dénomination, Union Européenne, États-Unis d'Europe, Europe Unie ou autre, elle permettra un système simplifié, uni d'actes nominatifs qui permettront une plus grande transparence et une plus grande responsabilisation.
La structure institutionnelle envisagée par cette proposition de Constitution européenne devra aussi refléter les aspirations les plus larges de l'Europe, qu'elle permettra ainsi de développer.
L'Europe doit représenter plus qu'un véhicule de l'intégration économique, qui de toute façon est maintenant pratiquement réalisée.
Au mieux, on s'attend à ce que l'Europe soit équitable.
Nous espérons voir notre modèle social réalisé.
Nous espérons connecter les questions économiques et sociales.
Nous espérons que l'Europe jouera un rôle positive à l'échelle internationale.
Bien sûr, bien des écueils nous attendent.
L'un deux repose sur l'impossibilité de toujours plus centraliser l'Europe.
Les gouvernements démocratiques sont trop compliqués pour cela.
Réaliser l'équilibre idéal des institutions européennes, nationales, régionales et locales reste un défi important.
Mais si l'on doit décréter une Constitution pour l'Europe, tous les liens et toutes les valeurs qui rassemblent ces entités devront être respectés par cette Constitution.
La crise de leadership de l'Europe
Sur une note nettement moins positive, les États membres de l'UE ont tardé à agir de concert.
Dans un premier temps, c'est surtout la Commission européenne qui a été critiquée pour ne pas avoir soumis de proposition pour rassembler les gouvernements et les décideurs nationaux.
Aujourd'hui, ce sont les États membres qui résistent à la nécessité urgente d'une réponse politique concertée face à une crise qui va s'aggravant.
La rapidité et la sévérité du ralentissement économique sont de loin les plus sérieuses de toutes les contractions des  dernières soixante années.
En Europe, nous avons pour l'essentiel négligé les signaux d'alerte de la crise des prêts hypothécaires à risque américains lorsqu'elle s'est produite à la fin de l'été 2007, et n'avons donc pas été préparés à l'étape suivante de la crise lorsqu'elle s'est étendue aux banques européennes.
La leçon à retenir est que l'UE doit réagir avec plus de rapidité et de détermination qu'elle ne la fait jusqu'à présent.
Dans toute l'Union européenne, les citoyens demandent, « Que fait l'Europe pour répondre à la crise ? ».
La réponse est « pas assez et de loin » et le prix politique à payer risque d'être élevé lors des élections parlementaires européennes de l'été prochain.
Les dernières semaines de 2008 seront déterminantes pour faire en sorte que l'Europe tente de reprendre l'initiative et d'atténuer les retombées de la crise, tout en s'attelant à résoudre les problèmes inhérents au programme de réformes de l'UE.
En tant qu'administrateurs des « Amis de l'Europe », nous souhaitons appeler les institutions et les dirigeants politiques européens à renouveler leurs efforts concernant à la fois le Traité et le programme communautaire de Lisbonne.
La présidence française de l'UE a grandement contribué à améliorer la coordination entre les réponses des États membres à la crise financière et la Commission européenne a de son côté commencé à assumer le rôle plus actif que les Amis de l'Europe avaient appelé de leurs vœux le 10 octobre.
L'enjeu est maintenant pour la présidence et la Commission européenne de donner un nouvel élan politique au processus de réforme, aujourd'hui bloqué, de l'UE.
La réunion du Conseil européen des 11 et 12 décembre devrait être l'occasion de préciser clairement le calendrier envisagé pour la relance du processus de ratification du Traité de Lisbonne, faute de quoi les problèmes politiques risquent de s'aggraver après les prochaines élections européennes de juin 2009.
Le Traité de Lisbonne est un pas en avant pour adapter les processus décisionnaires de l'UE au XXIème siècle et à une Union élargie à 27 membres ou plus.
La nature globale de la crise actuelle rend évident le fait que l'Europe doit pouvoir prendre des décisions rapidement et de manière cohérente, sous peine de souffrir de conséquences funestes.
Il est avéré que l'opinion publique, dans toute l'Union européenne, arrive de plus en plus à la même conclusion.
Le droit souverain du peuple irlandais à décider de son avenir ne peut être remis en cause.
Mais l'Irlande doit aussi permettre aux autres États membres de l'UE d'aller de l'avant avec le Traité de Lisbonne s'ils le désirent.
Même dans l'éventualité d'un nouveau référendum dans ce pays, le gouvernement irlandais devrait prévoir une procédure qui, quelle que soit l'issue du référendum, permette aux autres États membres d'appliquer les clauses essentielles du Traité de Lisbonne.
La Commission européenne doit maintenant agir pour garantir que les États membres redoublent d'efforts en ce qui concerne le programme de Lisbonne, destiné à rétablir la compétitivité globale de l'Europe.
Malgré l'adoption par l'UE d'un programme convenu d'objectifs de réformes sur dix ans, les États membres ont parfois manqué de volonté politique pour le mettre en œuvre.
Les perspectives de plus en plus sombres pour l'Europe rendent ces réformes plus nécessaires que jamais.
L'influence de Gazprom sur la sécurité énergétique européenne
Les préoccupations concernant la sécurité énergétique au sein de l'UE, alimentées par une dépendance croissante envers la Russie, n'ont jamais été aussi fortes. En même temps que l'expropriation de la compagnie pétrolière Ioukos par les autorités russes, les sociétés étrangères ont été évincées du secteur de l'extraction en Russie.
Sans surprise, nombreux sont ceux aujourd'hui en Europe qui doutent de la parole du Kremlin.
Mais au lieu de se retirer, l'UE doit chercher à approfondir les engagements et la réciprocité des échanges.
Elle doit encourager une plus grande intégration de Gazprom dans le marché de l'UE par une libéralisation du marché et une intégration en aval.
Elle doit toutefois exiger aussi une restructuration de Gazprom et un véritable accès au marché russe pour les sociétés occidentales, parce que la réticence de la Russie dans ce domaine est source d'insécurité énergétique pour l'Europe.
En effet, l'administration Poutine a tout un historique d'intimidation des investisseurs étrangers et de contravention aux lois, avec le soutien de procureurs, des autorités fiscales, des agences de réglementation et de tribunaux.
Dans le même temps, Gazprom s'est imposé comme le principal faiseur de marché du gaz en Europe, ridiculisant les efforts de l'UE en vue d'une plus grande coopération avec la Russie.
La stratégie de Gazprom repose sur trois tactiques : la cooptation -- en entretenant des partenariats privilégiés avec certains pays, dirigeants politiques et entreprises, pour faire valoir ses intérêts ; la préemption -- en utilisant le pouvoir en amont et la diplomatie russe pour manipuler les conditions en aval et acquérir des actifs : et la désagrégation -- en divisant l'UE au moyen d'accords bilatéraux.
La cooptation de l'Europe par Gazprom s'est principalement faite par l'entremise de l'Allemagne, où des partenariats noués avec des compagnies énergétiques et des banques ont entraîné un alignement des autorités sur les objectifs de la Russie.
Des pressions intenses, tant directes que par procuration, sont exercées pour persuader les législateurs européens de permettre des contrats d'approvisionnement à long terme -- malgré leur impact extrêmement négatif sur la concurrence.
La préemption exercée par Gazprom s'est manifestée par une multitude d'acquisitions.
Gazprom a inondé le marché en Turquie, a coupé l'approvisionnement en gaz de l'Ukraine, a menacé le Belarus de faire de même, et offert un accès préférentiel au marché à des partenaires obligeants, comme l'Italie.
Dans le Caucase, le Kremlin a empêché l'Iran de mettre en place des infrastructures qui lui auraient permis de concurrencer la Russie pour l'approvisionnement en gaz de l'Europe.
Pour barrer l'accès à l'Iran, la Russie a en fait racheté la quasi totalité du secteur gazier arménien, alors que son soutien au programme nucléaire iranien contribue à l'isolement de l'Iran et bloque les investissements occidentaux dont le pays aurait besoin pour devenir compétitif au plan des exportations de gaz.
La position dominante de Gazprom est renforcée par des mesures coordonnées par le Kremlin pour établir son influence sur des marchés comme l'Espagne et l'Italie.
En échange de contrats avec des fournisseurs concurrents, comme l'Algérie, la Russie leur propose des contrats d'armement avantageux et des taux de crédit préférentiels.
Dans d'autres cas, le Kremlin prend des mesures punitives, en coupant par exemple le gaz à la Lituanie après que le gouvernement ait vendu la raffinerie de Mazeikiu Nafta à une société polonaise, ou à l'Ukraine après que les électeurs aient voté pour le « mauvais » parti.
L'exemple type de la déségrégation est le cas du gazoduc Nord Stream, qui bénéficie à l'Allemagne tout en indisposant sérieusement la Pologne et les pays baltes.
Ce pipeline sous-marin coûtera trois fois le prix de la construction d'un nouveau gazoduc le long de tracés terrestres existants, fragilise la sécurité énergétique des pays à l'est de l'Allemagne et menace le fragile écosystème de la mer Baltique.
Mais en fournissant directement l'Allemagne, la Russie sera en position de couper le robinet de gaz de l'Ukraine, de la Pologne et des pays baltes sans que l'approvisionnement des pays de l'Ouest de l'Europe n'en souffre -- et le comportement récent de la Russie donne à penser que ce ne sont pas des menaces en l'air.
Mais Gazprom s'inquiète de ses capacités en amont, comme le prouve sa décision d'acheminer le gaz du gisement de Chtokman vers l'Europe au lieu de le liquéfier pour les marchés nord-américains.
Tant que Gazprom restera une société aussi opaque, l'Europe n'aura aucun moyen de savoir si son principal fournisseur investit suffisamment dans l'exploitation de réserves futures.
La bataille politique qu'a livrée le Kremlin pour obtenir le contrôle sans partage du secteur énergétique russe s'est traduite par une baisse substantielle du taux de croissance de la production russe de pétrole et de gaz.
Cette situation est un problème pour l'Europe.
Gazprom ne peut pas être un partenaire fiable pour l'Europe si la société n'investit pas dans ses infrastructures, tout en jouant un rôle de premier plan pour dépouiller les entreprises privées russes du secteur, en investissant 14 milliards de dollars dans des activités non centrales, comme les médias, et en étant gérée depuis le bureau de l'administration présidentielle.
Les lumières ne doivent pas pour autant s'éteindre en Europe.
Bruxelles doit exiger la transparence, la symétrie et l'état de droit de la part de Moscou, avec pour objectif une intégration révolutionnaire des marchés énergétiques russe et européen.
Dans le même temps, en diversifiant ses sources d'approvisionnement, en investissant massivement dans le gaz naturel liquéfié et en prenant fermement position en faveur du gazoduc Nabucco et pour des connexions entre les pays riverains de la Méditerranée, l'Europe se rapprochera de la sécurité énergétique.
L'accès en aval au marché européen que demande Gazprom est précisément l'atout de l'UE.
L'Union européenne doit clairement faire comprendre à Gazprom que son accès aux actifs en aval est conditionné à l'ouverture réciproque du secteur énergétique russe.
Il serait alors possible pour ses partenaires internationaux de respecter et de faire confiance à la Russie, qui trouverait naturellement sa place sur le marché énergétique européen.
Un libre-échange pour une croissance libre
Les choses ne vont guère mieux en Europe.
La France a porté un coup aux négociations du cycle de Doha de l'Organisation mondiale du commerce (OMC) en rejetant l'idée d'un accord pour l'agriculture.
José Manuel Barroso, président de la Commission européenne, estime que les pressions protectionnistes s'accentuent.
Quand le cycle commercial de Doha a été lancé, peu après le 11 septembre 2001, la bonne volonté internationale ne manquait pas.
Mais le désenchantement provoqué par la mondialisation et, dans certaines régions, la peur de l'immigration, se sont installés depuis.
Un récent sondage Financial Times/Harris aux États-Unis, en Allemagne, en France, au Royaume-Uni, en Italie et en Espagne dévoile que les gens ont trois fois plus tendance à trouver la mondialisation négative plutôt que positive.
Le libre-échange provoquerait une explosion du bien-être partout, et surtout dans les pays en voie de développement.
Savoir saisir ces bénéfices constituera peut-être l'un des plus grands défis de cette génération.
L'amplification d'un sentiment négatif pourrait avoir le pire résultat possible : non seulement l'échec de Doha, mais aussi l'édification de barrières douanières et migratoires.
Ces barrières persistent en grande partie parce que davantage de libéralisation génèrerait une redistribution des emplois, des revenus et des richesses, ce qui ferait craindre aux gouvernements une réduction de leurs chances de rester en place -- et de leurs propres richesses dans des pays où la corruption est florissante.
Le plus grand espoir consiste donc à remettre le cycle de Doha sur les rails.
Mais il y a une grande différence entre un résultat de piètre qualité et un autre plus complet.
En outre, l'impact à long terme du libre-échange est énorme.
Repensé en tant que valeur actuelle nette du flux des bénéfices futurs, un résultat réaliste de Doha pourrait augmenter le revenu mondial de plus de 3 000 milliards de dollars, dont 2 500 milliards iraient aux pays en développement.
En outre, les expériences réussies de réformateurs comme la Corée, la Chine, l'Inde et le Chili suggèrent que la libéralisation du commerce provoque une augmentation des taux de croissance économiques annuels de plusieurs points de pourcentage pour plusieurs années.
Éliminer les subventions et les barrières douanières signifierait que les ressources pourraient être utilisées de manière plus efficace, ce qui permettrait de bénéficier d'une plus grande marge de manœuvre pour réduire les inégalités et la pauvreté, les tensions sociales, la dégradation environnementale, la malnutrition et les maladies.
Il y aurait des coûts, bien sûr.
Les entreprises et les travailleurs auraient un travail d'ajustement à faire lorsque des réformes forceraient certaines industries à faire des coupes ou à fermer, et en laisseraient d'autres s'agrandir.
En outre, il faut considérer aussi les coûts sociaux.
Pourtant, les bénéfices d'un cycle de Doha fructueux sont de 45 à 440 fois supérieurs à ces coûts.
Il s'agit clairement d'un investissement extrêmement solide.
Une "alternative" à Doha, par laquelle d'autre pays à hauts revenus suivraient la proposition de l'Union européenne d'un accès hors taxes aux produits de pays moins avancés (PMA) et de petits pays d'Afrique, des Caraïbes et du Pacifique (ACP), n'impliquerait qu'une minuscule fraction des gains mondiaux provenant de la réforme du commerce.
En outre, cela pourrait bien porter préjudice à d'autres pays pauvres -- aggravant ainsi les inégalités -- en encourageant l'allocation des ressources à des activités qui perdent leur compétitivité après l'accord de l'OMC suivant.
La révolution militaire de l'Europe
BRUXELLES - La création de l'euro est une innovation révolutionnaire pour l'Union Européenne qui -- de par sa nature- évolue lentement et par palliers, et cette création a fait l'objet de débats à travers tout le continent et même au-delà.
Au contraire, les plans concernant une politique commune de défense de l'UE n'avaient pas suscité le même intérêt jusqu'à présent, mais ce n'est plus vrai aujourd'hui.
Tout en rappelant l'efficacité de l'OTAN, les Américains demandent avec de plus en plus d'insistance quelle serait l'utilité d'une politique commune de défense.
Les Européens sont souvent mal à l'aise pour répondre, en partie parce qu'il n'y a pas de réponse unique.
Pour ceux qui croient en une Europe forte, une coopération étroite dans le domaine de la défense est de toute évidence souhaitable.
Pour les pragmatiques, les membres de l'UE gagneront en efficacité à avoir une politique étrangère et de sécurité commune.
Ils soulignent que le nombre croissant des crises à l'extérieur de l'UE, dans les Balkans, au Moyen-Orient, en Afrique et ailleurs requiert une réponse concertée.
Un troisième argument est avancé par certains gaullistes français et par une partie importante de la gauche de l'UE : l'Europe a besoin d'une politique étrangère et de sécurité commune pour résister à l'hégémonie américaine.
Cet anti-américanisme reste cependant minoritaire.
Les avocats d'une politique étrangère et de sécurité commune considèrent qu'une Europe capable d'assurer elle-même sa défense constitue un meilleur partenaire pour les USA.
Aujourd'hui, doutes et confusion sont soulevés par le rôle incertain donné à la Force de Réaction Rapide, étape-clé dans la construction d'une politique étrangère et de sécurité commune.
La Force de Réaction Rapide doit, dit-on, être capable d'effectuer ce que l'on appelle "les missions de Petersberg".
Mais "le rétablissement de la paix", qui est l'une de ces missions, peut recouvrir n'importe quoi : de l'opération Alba en 1997 au cours de laquelle l'Italie a mené une force européenne de 6000 hommes en Albanie pour rétablir l'ordre, à une offensive contre les rebelles du Sierra Léone qui s'opposaient aux forces de maintien de la paix de l'ONU, en passant par des conflits du type guerre du Golfe.
Toutefois, étant donné que tous les gouvernements de l'UE savent qu'à court terme l'Europe ne peut réaliser que des opérations militaires de faible envergure, il n'est guère utile de définir pour l'instant le rôle de la Force de Réaction Rapide.
L'Amérique devrait se réjouir du sens des responsabilités accru et de l'importance croissante de l'Europe, symbolisés par la Force de Réaction Rapide.
Il est vrai que le rôle de l'Amérique au sein de l'OTAN - dispositif astucieux qui lui permet, avec la bénédiction de l'Europe, de maintenir son influence à travers tout le continent - ira sans doute en diminuant.
L'OTAN deviendra alors un cadre dans lequel deux grandes puissances, et non pas une grande puissance et 18 petits pays, coordonneront leurs politiques et les réponses apportées aux crises.
Les bénéfices l'emportent sur l'inconvénient que représente une réduction de marge de manœuvre pour l'Amérique.
Un potentiel européen plus fort permettrait à l'Amérique de se décharger sur ses alliés de la gestion des multiples foyers d'instabilité à l'intérieur de l'Europe et dans son voisinage.
De plus, si une défense commune vient s'ajouter à l'acquis déjà existant que les candidats à l'UE doivent intégrer, la pression en faveur d'un élargissement de l'OTAN ira en diminuant.
Une UE qui s'implique pour sa propre défense, même si elle n'offre pas les mêmes garanties formelles que l'OTAN, ouvre aux pays candidats la perspective d'appartenir à une véritable communauté de défense.
Plus fondamentalement, la création d'une Europe entière et libre, mais également unie, constitue le plus grand succès de l'Amérique en politique étrangère des cinquante dernières années.
Afin que cet objectif soit entièrement réalisé, l'UE doit encore devenir un acteur de la scène internationale à part entière.
Ainsi, la politique étrangère et de sécurité commune en Europe représente avant tout un défi psychologique lancé à l'Amérique.
En Europe, pourtant, ce défi est une question de volonté et de leadership politique, ce que l'on ne peut attendre d'une commission.
Nous proposons ici un certain nombre de réformes institutionnelles et politiques, dont :
· Fusionner les fonctions de Chris Patten, le Commissaire aux relations extérieures, et de Javier Solana, le Haut représentant pour la politique étrangère et de sécurité commune ; ceci pour que l'Union Européenne parle d'une seule voix.
· Renforcer le statut du nouveau Comité politique et de sécurité basé à Bruxelles de manière à rapprocher le point de vue intergouvernemental et celui de la Commission en matière de politique étrangère.
· Avoir comme objectif au niveau européen que tous les Etats membres consacrent au moins 2% de leur PIB à la défense et un quart de leur budget de défense à l'achat d'armes et à la recherche et au développement.
· Créer un budget de défense spécifique pour l'UE, de manière à financer les missions, les capacités militaires et les programmes d'armement communs.
· Constituer au sein du secrétariat du Conseil des ministres un groupe de surveillance en matière de forces militaires ; il servira à coordonner les pressions sur les gouvernements afin qu'ils améliorent leurs capacités militaires.
Le pouvoir de mettre sur pied des coalitions, de veiller à ce que les gouvernements respectent les délais impartis, d'apporter une aide ou d'assumer la responsabilité d'un échec doit venir de la source traditionnelle de l'autorité, l'Etat-Nation.
Comme aucun Etat au sein de l'UE ne peut remplir seul le rôle dominant que jouait l'Amérique au sein de l'OTAN durant la guerre froide, c'est à l'Angleterre, à la France et à l'Allemagne de remplir ce rôle en Europe.
Que l'un de ces pays s'oppose à l'action commune, et c'est la cohésion et la crédibilité des actions entreprises par l'UE qui sera détruite.
Mais si ces trois pays sont décidés à aller de l'avant, ils incarneront la volonté des autres membres de l'UE, ou en tout cas de la majorité d'entre eux.
L'appartenance à ce groupe des Trois ne confère pas le pouvoir de commander, mais la responsabilité de prendre des initiatives.
En cas de crise, si ces trois pays ne parviennent pas à s'entendre, l'Europe restera sur le bord du chemin ; mais s'ils sont unis dans l'action, c'est l'Europe toute entière qui sera impliquée.
L'Angleterre, la France et l'Allemagne doivent commencer à penser l'UE comme un tout dont ils portent la plus lourde part et dont ils assument la plupart des risques.
Leur leadership devra être informel, transparent et exhaustif.
Malheureusement, à l'heure actuelle aucun de ces pays n'est prêt à tenir ce rôle peu enviable, bien qu'inévitable.
Leur engagement dans la révolution militaire de l'Europe devrait cependant les pousser à l'assumer.
Si nous n'agissons pas maintenant, nous le payerons plus tard -- sur le plan financier comme sur le plan humanitaire.
Le recul des progrès socio-économiques que l'ensemble du continent a accompli lors de la dernière décennie nous met tous en position de perdant.
D'une part, les marchés en expansion, et les possibilités d'investissement qui les accompagnent, pourraient s'évaporer.
Toute chute d'un point du taux de croissance a des retombées sociales directes, sur la qualité de la nutrition, le taux de mortalité infantile ou la présence à l'école.
Les personnes repoussées dans la pauvreté sont autant de pas qui nous éloignent des Objectifs du millénaire pour le développement.
C'est pour toutes ces raisons que l'engagement et le soutien continus de tous les partenaires de l'Afrique, notamment des pays du G8, sont vitaux.
Comme l'indique le rapport DATA de l'organisme non gouvernemental de soutien à l'Afrique ONE, nombre de donateurs ont honoré leur promesse en dépit du ralentissement économique.
Pourquoi il faut juger Charles Taylor
Nous avons déposé un recours devant la Haute cour fédérale du Nigeria en mai dernier, pour qu'elle examine la décision du Président Olusegun Obasanjo d'accorder le statut de réfugié à l'ancien président du Liberia, Charles Taylor, inculpé en Sierra Leone pour crimes de guerre par un tribunal spécial établi en collaboration avec les Nations Unies.
Nous faisons partie des nombreuses victimes de Taylor.
Il y a sept ans, nous étions deux jeunes hommes d'affaires nigérians, faisant commerce de matériel électronique et d'équipement médical sur la côte ouest de l'Afrique.
Nous achetions nos marchandises au Nigeria et les exportions vers le Liberia et la Sierra Leone.
Pendant l'été 1997, David se trouvait à Monrovia au moment de l'investiture de Charles Taylor, devenu président du Liberia après huit années de guerre civile.
Un an plus tard, l'Onu et la Communauté économique des Etats d'Afrique de l'Ouest déployaient une force de maintien de la paix en Sierra Leone, pour faire respecter un cessez-le-feu dans ce pays voisin ravagé par un conflit de près d'une décennie, à l'initiative des rebelles du Front révolutionnaire uni (RUF, Revolutionary United Front).
A l'automne 1998, nous nous sommes rendus séparément pour affaires à Freetown, la capitale du Sierra Leone.
Lors de séjours précédents, nous avions entendu parler d'atrocités - amputations, viols et mutilations de civils - commises par les rebelles du RUF dans les campagnes.
Mais la présence de la communauté internationale nous a rassurés et nous avons pensé que nous pouvions continuer à faire affaire dans le pays en sécurité.
Notre gouvernement et nos amis sierra-léonais étaient aussi de cet avis.
Nous avons prévu de passer Noël et le Jour de l'An à Freetown avant de rentrer au Nigeria au début de l'année 1999.
Puis tout a basculé.
Peu avant Noël, des rumeurs d'une attaque imminente des rebelles ont atteint la capitale sierra-léonaise.
Des personnes déplacées ont commencé à arriver, d'abord quelques-unes, puis une multitude.
Nous avons essayé de modifier nos billets pour rentrer au Nigeria, mais tous les avions étaient complets.
Le 6 janvier, les rebelles ont pris possession de la maison où nous habitions à Freetown.
Nous étions neuf Nigérians.
Les rebelles - plus de cent, beaucoup de jeunes adolescents - ont encerclé le bâtiment, ont mis le feu, et ont ordonné à tous les Nigérians de sortir.
Leur commandant, qui parlait avec un net accent libérien, se faisait appeler Captain Goldteeth.
Quand nous avons essayé de nous échapper, les rebelles nous ont capturés.
Captain Goldteeth nous a fait amener à une gare d'autobus proche de notre résidence, où plus de 80 autres captifs étaient rassemblés.
Il a déclaré qu'il avait ordre - du Palais présidentiel de Monrovia - d'envoyer un message au Nigeria, le principal pays contributeur de troupes et de financement pour l'Ecomog, la force régionale de maintien de la paix.
Captain Goldteeth a demandé à son " officier coupeur " de séparer les Nigérians des autres.
Puis ils se sont mis à nous amputer.
Leur première victime a été le jeune frère d'Emmanuel, Benedict Egbuna.
Ils lui ont coupé les mains au-dessous du coude, et l'ont laissé se vider de son sang devant son épouse enceinte, Zainab, et nous, puis l'ont balancé derrière la maison.
Beaucoup de nos meilleurs amis ont également été mutilés et tués.
Puis est venu notre tour.
La machette a pénétré la chair et les os d'Emmanuel, mais sans trancher complètement.
Les rebelles l'ont jeté dans le cimetière, les mains ainsi suspendues à ses bras.
Ensuite, ils ont coupé les bras de David puis lui ont mis le feu.
Nous ne savons pas comment nous avons survécu à ce supplice.
Le fils de Benedict Egbuna, Benedict Jr, né cinq mois après le carnage, a aujourd'hui cinq ans. Sa présence est un réconfort pour nous et pour tous ceux qui ont connu son père.
Un jour, il se tournera vers nous pour reconstituer les souvenirs de celui qu'il ne connaîtra jamais.
Plus tard, Benedict Jr nous demandera certainement ce qui est arrivé aux responsables de la mort de son père.
Que lui dirons-nous ?
Il est de notre devoir de demander justice pour les victimes des crimes de Charles Taylor.
Le statut de réfugié est une protection humanitaire.
Le Nigeria ne doit pas permettre qu'un tyran s'en serve pour échapper à la justice.
La Turquie, l'Europe et la sécurité au Moyen-Orient
De nombreux facteurs ont contribués au rejet par les Français et les Néerlandais de la proposition de traité constitutionnel de l'Union européenne.
Un des facteurs, généralement tu, est la peur de l'entrée de la Turquie dans l'Union.
Cette envie d'appartenance a cependant déjà transformé la Turquie.
Pour se préparer à l'accession à l'Union européenne, la Turquie a entrepris de vastes et sérieuses réformes légales, politiques et économiques.
Les bureaucrates turcs, les hommes politiques et les citoyens ont travaillé à l'unisson pour répondre aux critères de Copenhague pour l'entrée dans l'Union européenne et toléré les difficultés engendrées par les programmes d'ajustement structurels réclamés par le FMI.
Le futur processus d'admission sera encore plus difficile mais le peuple turc est fermement résolu à relever le défi.
La transformation de la Turquie a déjà permis de mettre fin aux agissements sécuritaires que l'appareil d'État de type Guerre froide entreprenait depuis plus d'un demi-siècle et a modifié les cadres politiques intérieurs et extérieurs du pays.
En se modernisant et en se démocratisant de l'intérieur, la classe politique turque a gagné la confiance nécessaire à sa capacité à mener des politiques régionales réussies.
Il en résulte que les dirigeants turcs sont maintenant prêts à mettre en place une diplomatie active au Moyen-Orient dans un effort pour maîtriser les problèmes rencontrés avec les pays voisins.
Il est de première importance que la Turquie émerge comme modèle pour tous ceux qui au Moyen-Orient cherchent à se réformer et à se moderniser.
Cette influence n'implique aucunement une relation hégémonique mais plutôt une alternative à la réforme et au développement économique que d'autres pays principalement musulmans pourraient choisir.
L'Union européenne est associée avec des idéaux de paix, de démocratie et de développement économique tandis que le Moyen-Orient se caractérise par son instabilité, son autoritarisme et son retard économique.
Le processus de réforme de la Turquie montre que ces défauts ne représentent pas l'inévitable destin des pays de la région.
Dans ce sens, la Syrie et l'Iran apprécient le processus d'adhésion à l'Union européenne de la Turquie.
Ils considèrent l'appartenance européenne de la Turquie comme l'occasion de développer leurs propres relations avec l'Union européenne.
La Turquie démontre également que les prétendus clash entre la démocratie et la sécurité, et donc entre la démocratie et l'islam en fait, sont réconciliables.
D'autres États musulmans semblent comprendre ce phénomène : récemment, pour la première fois, un Turc fut élu par vote majoritaire à la fonction de Secrétaire général de l'Organisation des pays islamiques.
La seconde contribution turque d'importance vient de ses engagements diplomatiques constructifs dans la région.
Le gouvernement turc a adopté un rôle actif dans la promotion de la paix et a réaménagé ses politiques envers un certain nombre de questions régionales.
Le Premier ministre turc, Tayyip Erdogan, s'est éloigné par exemple de la traditionnelle attitude critique envers Israël et ses politiques les plus va-t-en guerre envers les territoires occupés sans pour autant rompre ses relations diplomatiques avec Israël.
Lors d'une visite officielle en Israël du ministre des affaires étrangères turc, Abdullah Gul, en janvier dernier, de sérieuses discussions ont été menées sur la possibilité pour la Turquie de jouer un rôle médiateur entre Israël et les Palestiniens ainsi que pour les futures négociations israélo-syriennes.
La Turquie ne s'est bien sûr pas jointe aux forces d'occupation de la coalition américaine en Irak mais a fait de gros efforts pour mobiliser un soutien régional pour un État irakien stable.
En effet, les politiciens turcs ont régulièrement réuni les pays frontaliers de l'Irak pour des débats sur l'avenir de la région.
Le Conseil de sécurité des Nations unies a pris ces réunions au sérieux et a demandé une coopération régionale plus prononcée sur la question irakienne.
L'engagement constructif de la Turquie avec l'Union européenne crée un certain sentiment de confiance en occident -- chez les leaders occidentaux du moins, si ce n'est le cas de la population générale -- envers ses initiatives régionales La Turquie réussit par ailleurs à maintenir des distances égales entre l'Union européenne et les États-Unis.
Ainsi, par exemple, la Turquie est plus proche de l'Union européenne dans sa politique envers l'Irak et la Palestine et pourtant suit une ligne similaire à celle des États-Unis envers les Balkans et Chypres.
L'histoire récente montre qu'une grande variété de pouvoirs régionaux sont nés au Moyen-Orient : l'Iran du Shah et l'Égypte de Nasser, par exemple.
L'arrivée de la Turquie comme puissance régionale est différente dans la mesure où sa structure démocratique en fait un acteur actif de la paix plutôt qu'un fier-à-bras local.
C'est là un rôle aussi prometteur que nécessaire pour une région qui a besoin d'une force locale dynamique poussant à la réforme, la transformation et la paix.
L'expérience turque montre qu'une véritable sécurité dans la région requiert stabilité interne et paix sociale.
Avec un peu de chance, ce modèle peut être exporté dans tout le monde musulman.
La résilience du Brésil
"La crise des subprimes n'a pas encore atteint les plages de Copacabana," a proclamé il y a peu le ministre des Finances Guido Mantega.
"Nous nous débarrassons des déséquilibres et, en fait, nous réduisons progressivement notre dépendance aux entrées de devises -- c'est capital."
En effet, le gouvernement a souligné le fait que le Brésil sera encore plus protégé puisque les efforts de réduction des dépenses diminuent la dépendance aux flux de capitaux extérieurs.
Mais la capacité du Brésil à échapper aux conséquences d'une récession aux États-Unis dépend de l'échelle de la crise.
Les hauts fonctionnaires brésiliens ont quelques raisons de se targuer que la plus grande économie d'Amérique latine est peut-être plus forte que jamais : les indicateurs macroéconomiques sont en meilleure forme, les ratios de solvabilité se sont améliorés, et l'association d'exportations, d'investissements et de demande intérieure a stimulé l'activité économique.
Au cours des dernières années d'abondance des liquidités mondiales, le real est devenu plus fort et la banque centrale a pu engranger des devises étrangères, pour constituer un coussin qui se montait environ à 185 milliards de dollars fin janvier, montant suffisant pour couvrir entièrement la dette extérieure pour la première fois de l'histoire.
Néanmoins, les hauts responsables du gouvernement admettent, en privé, que l'impact d'une future récession américaine ne serait pas insignifiant, car le Brésil n'est pas complètement isolé des événements extérieurs.
Au-delà de la crise des subprimes, les inquiétudes que suscite la stabilité du système financier des États-Unis impliquent des conséquences graves pour l'économie mondiale.
En outre, une récession ou un ralentissement aux États-Unis et en Europe frapperait les exportations brésiliennes, et réduirait considérablement l'excédent commercial du Brésil.
En fait, bien que l'importance commerciale de l'Amérique ait diminué, puisqu'elle ne représentait que 16 % des exportations brésiliennes l'année dernière, le commerce et la croissance du Brésil vont de pair avec les États-Unis et l'Europe ; on ne les a jamais vus se découpler.
En même temps, un ralentissement prolongé aux États-Unis pourrait réduire la demande étrangère des autres marchés.
Le scénario pourrait empirer si l'on assistait à une dégradation des prix des matières premières -- l'une des menaces les plus graves pesant sur le Brésil en cas de dépression économique mondiale.
La décélération en Inde et en Chine provoquerait de nouvelles réductions des prix des matières premières, affaiblissant les marchés dont la solidité est à la base de la forte performance commerciale du Brésil des dernières années.
Dans tous les cas, la banque centrale a déjà projeté la disparition de l'excédent commercial du Brésil cette année, ainsi même qu'un petit déficit.
Heureusement, la bourse brésilienne a moins pâti que celles d'autres marchés émergents des turbulences financières aux États-Unis et ailleurs.
Récemment, la bourse est devenue la première source de financement des entreprises brésiliennes, devant la Banque nationale pour le développement, détenue par l'État, qui accorde des prêts à des taux en deçà de ceux du marché.
Mais les marchés financiers du Brésil sont bien plus sensibles que le commerce aux perturbations internationales, et les flux monétaires pourraient diminuer à long terme.
En effet, si l'économie mondiale continue de se détériorer, les investissements de portefeuilles pourraient s'accélérer, réduire les financements disponibles pour les entreprises brésiliennes et finir par affecter leur capacité d'investissement.
Pour l'instant, des études internes conduites par l'Association des industries de São Paulo affirment que la confiance reste solide dans le secteur industriel, et les investissements directs à l'étranger vers l'intérieur ont atteint le record de 34,6 milliards de dollars l'année dernière.
Plein d'optimisme, les hauts responsables brésiliens pensent que le Programme gouvernemental d'accélération de la croissance servira de vaccin contre les turbulences mondiales et aidera à réduire les goulets d'étranglement dans l'économie.
Les droits de l'homme comme un tout
C'est maintenant à l'Assemblée générale des Nations Unies de prononcer l'approbation finale du Protocole. En cas d'adoption, cet instrument peut faire une réelle différence dans la vie de ceux qu'on laisse souvent languir en marge de la société et à qui l'on refuse des droits économiques, sociaux et culturels, tels que l'accès à une alimentation convenable, aux services de santé, au logement et à l'éducation.  
Il y a soixante ans, la Déclaration universelle des droits de l'homme disposait qu'il est indispensable pour avoir une vie digne de ne pas subir la terreur ni la misère. Elle associait sans équivoque l'indigence à la discrimination et à l'inégalité d'accès aux chances et aux ressources. Pour ses concepteurs, la stigmatisation sociale et culturelle entravait la participation pleine et entière à la vie publique, la capacité d'influer sur les politiques et l'obtention de la justice.
Cette vision des choses unifiée a été mise à mal au lendemain de la Seconde Guerre mondiale par la logique de blocs géopolitiques en concurrence idéologique luttant pour le pouvoir et l'influence. Les droits de l'homme ont aussi été affectés par la bipolarité de la Guerre froide. Pour les pays à l'économie planifiée, la nécessité de survie supplantait l'aspiration à la liberté ; et l'accès aux éléments essentiels compris dans l'ensemble de droits économiques, sociaux et culturels devait avoir priorité dans les politiques et la pratique.
De leur côté, les gouvernements occidentaux se méfiaient de cette perspective qui, selon eux, risquait de faire obstacle aux pratiques d'économie de marché, d'imposer des obligations financières excessivement lourdes ou les deux. Par conséquent, ils préférèrent donner la priorité aux droits civils et politiques qu'ils considéraient comme indissociables de la démocratie.
Dans ce contexte, il était impossible de s'accorder sur un instrument des droits de l'homme unique et exhaustif donnant un effet holistique aux principes de la Déclaration. Il n'est pas surprenant d'avoir attendu près de vingt ans avant que les États membres des Nations Unies n'adoptent simultanément deux traités séparés  -- le Pacte international relatif aux droits civils et politiques et le Pacte international relatif aux droits économiques, sociaux et culturels  -- qui englobent les deux ensembles distincts de droits. Toutefois, seul le premier traité a été pourvu d'un mécanisme visant à contrôler sa mise en oeuvre.
En pratique, cette divergence a créé une catégorie de droits « alpha »  -- civils et politiques  -- devenus prioritaires dans les programmes de politiques étrangère et intérieure des pays riches et influents. Les droits économiques, sociaux et culturels étaient quant à eux souvent remisés en fin de liste des tâches à accomplir aux niveaux national et international.
Pour remédier à ce déséquilibre entre les deux ensembles de droits, le nouveau protocole prévoit pour le Pacte relatif aux droits économiques, sociaux et culturels un système de signalement des violations, appelé « mécanisme de réclamation », identique à ceux créés pour d'autres traités de droits l'homme fondamentaux. Cette procédure peut sembler opaque, pourtant, en déposant une réclamation conformément aux dispositions du Protocole, les victimes peuvent désormais signaler les abus que leurs gouvernements commettent, manquent de faire cesser, ignorent ou ne corrigent pas. En somme, le Protocole permet aux individus qui seraient autrement isolés et impuissants de porter leur détresse à la connaissance de la communauté internationale.
Après son adoption par l'Assemblée générale de l'ONU, le Protocole entrera en vigueur lorsqu'un seuil nécessaire d'États membres l'aura ratifié. Cette évolution contribuera à l'élaboration de programmes axés sur les droits de l'homme et de politiques consolidant les libertés et le bien-être des individus et de leurs communautés.
Le Protocole ne sera pas adopté par tous les pays. Certains préféreront éviter tout renforcement des droits économiques, sociaux et culturels et chercheront à maintenir le statu quo. Pourtant, il serait plus judicieux et plus juste d'embrasser la conception de la Déclaration universelle des droits de l'homme et de promouvoir sans ambiguïté l'idée que la dignité humaine exige le respect de garanties tout aussi vitales et interdépendantes contre la terreur et la misère.
Démocratie en Amérique latine
Je suis un partisan convaincu du libre-échange et j'espère voir la proposition de "Zone de libre-échange des Amériques" ("Free Trade Area of the Americas") aboutir, comme prévu, en 2005.
Pourtant, je trouve déconcertant que les questions économiques aient éclipsé le débat sur le renforcement et la stabilisation de la démocratie et du éveloppement humain en Amérique latine.
Il reste beaucoup à faire dans ces domaines-là.
Si on les néglige, pauvreté et gouvernance déplorable éclipseront tout notre succès à promouvoir la croissance économique.
Dans une zone où 12% des adultes sont analphabètes et plus d'un cinquième de la population n'a pas accès à l'eau potable, mettre uniquement l'accent sur les questions économiques ne suffit plus.
Dans les pays d'Amérique centrale déchirés par les guerres des années 70 et 80, des accords de paix ont été signés et des institutions démocratiques sont maintenant en place.
Cependant, les armes utilisées pendant ces guerres sont encore entre les mains d'anciens soldats et rebelles, et elles se revendent souvent dans la rue.
Ces armes des guerres passées participent du taux de violente criminalité si épouvantable qu'aujourd'hui de nombreux habitants d'Amérique centrale craignent plus pour leur sécurité qu'à l'époque des guerres civiles et des rébellions.
Ainsi, bien que nous n'ayons assisté à aucune tentative directe de coup d'État récemment, nous vivons encore dans un relatif climat de menace et de comportement rebelle, de la part de certains militaires d'Amérique centrale, inacceptables pour des démocraties accomplies.
Ainsi en est-il des pressions exercées sur le président chilien, Ricardo Lagos, par exemple, pour lui faire dépenser des sommes d'argent scandaleuses dans l'achat d'avions de combat sophistiqués pour "moderniser" l'armée de l'air chilienne.
Tant que les chefs militaires continueront à détenir un pouvoir excessif au sein de leurs gouvernements, la priorité des dépenses ne sera pas au diapason des besoins du commun des mortels, et la démocratie sera toujours menacée par l'épée de Damoclès du coup d'État potentiel.
Tout comme la tyrannie (Caudillismo), un autre vieux fantôme continue de hanter ce continent : la pauvreté.
Bien que l'Afrique et l'Asie du sud souffrent de taux de pauvreté plus élevés, l'Amérique latine présente le terrible privilège de détenir l'inégalité économique et sociale la plus élevée au sein de chacune de ses sociétés.
Au lieu de trouver les moyens de remédier à cela, nous continuons à condamner nos enfants à la pauvreté en ne réussissant pas à leur donner une éducation décente.
De nombreux pays sont allés trop loin dans les programmes de réforme fiscale au cours des années 80 et 90, tailladant non seulement dans les dépenses publiques coûteuses mais aussi dans les dépenses d'éducation et de santé.
Sans ces éléments de base fondamentaux, il sera impossible d'assurer le partage à grande échelle des bénéfices de la croissance.
Les classes aisées d'Amérique centrale ne remplissent pas leur rôle.
Tandis que les pays européens tels que la Suède ou la France recueillent plus de 45% de leur produit intérieur brut en taxes, le Guatemala en recueille difficilement 9%.
Le principe démocratique de l'égalité a encore beaucoup de chemin à faire pour s'enraciner profondément chez nous.
L'élitisme, d'autre part, reste profondément bien ancré dans nos institutions et nos cultures.
Toute tradition n'est peut-être pas bonne à sauvegarder.
La tempête avant le calme !
Les marchés financiers ont peut-être estimé que le point de vue de la Fed sur l'inflation aux USA était représentatif de celui des autres banques centrales, d'autant que la BCE a pris la décision le 2 octobre de ne pas toucher aux taux d'intérêt.
Aujourd'hui, en matière d'inflation les USA font face au retournement de tendance le plus important qu'ils aient connu depuis 20 ans.
Certes, on sait qu'il est très difficile de prévoir l'inflation.
L'économie mondiale a connu de grands changements structurels (entre autre la mondialisation commerciale et financière) et il en a été de même au sein de chaque pays (avec le déclin des syndicats par exemple).
La politique monétaire elle-même s'est mise à accorder beaucoup plus d'importance à l'inflation.
Par ailleurs, les chocs provoqués par la hausse du prix de l'énergie et de l'alimentation peuvent être forts et essentiellement imprévisibles, tandis que les prix tendent à varier rapidement en cas de grosse secousse.
C'est pourquoi la plupart des modèles prévisionnels des banques centrales attribuent-ils une grande importance à l'inflation récente.
Cette approche est efficace, sauf lors d'un retournement de tendance, car ces modèles ne prennent pas en compte des paramètres sous-jacents majeurs ou importants à long terme.
L'inversion de tendance à laquelle sont confrontés les USA et le reste du monde est sans ambiguïté.
La production mondiale n'a probablement jamais chuté aussi rapidement depuis la Deuxième Guerre mondiale, sauf peut-être en 1974-1975.
Dans ce contexte, la capacité de production est trop importante et le prix des marchandises baisse.
Il est peu probable que la Chine ou d'autres marchés émergents parviennent à stimuler assez rapidement la consommation intérieure.
Et avec une surcapacité de production allant croissant, l'investissement dans l'appareil industriel risque de diminuer encore, avec des conséquences graves pour le PIB.
Aussi, la demande qui était conduite par la croissance des marchés émergents va chuter fortement, diminuant ainsi l'inflation mondiale.
Finalement, la baisse des prix et la baisse de l'inflation sera l'équivalent d'une énorme baisse d'impôt pour les ménages, ce qui permettra de baisser encore davantage les taux d'intérêt avec pour effet de stabiliser l'activité économique.
Paradoxalement, évitant des dommages supplémentaires à l'économie des pays industriels, maintenant plus le prix du pétrole baisse, plus courte sera la période de déflation.
Le prix du pétrole et de la nourriture étant fortement à la baisse -- une baisse qui est appelée à continuer - et le chômage à la hausse, d'après nos modèles, l'inflation des prix à la consommation, notamment aux USA, devrait baisser à un taux record au cours des prochains 6 à 12 mois.
Si certains observateurs s'inquiètent encore du risque d'inflation, d'autres craignent que le mécanisme monétaire ne fonctionne plus comme à l'habitude et qu'à l'image du Japon, les USA traversent une &quot;décennie perdue&quot;, ou encore que les pays industriels soient frappés par une crise analogue à celle des années 1930.
Le débat en cours est de savoir si la politique monétaire peut éviter l'inflation et si l'on va atteindre la limite d'un taux d'intérêt égal à zéro.
Cette limite vient de ce que les taux d'intérêt nominaux ne peuvent devenir négatifs.
Mais s'ils restent positifs alors que l'inflation est négative, les taux d'intérêt réels risquent de devenir trop élevés pour une économie en récession, ce qui aggrave et prolonge cette dernière.
Une lecture erronée de l'expérience japonaise a conduit à des mesures de protection excessives contre le risque de perte extrême ( tail risk ) lié à la déflation.
Paradoxalement, cela a alimenté le crédit et la bulle de l'immobilier dont l'éclatement a provoqué la récession actuelle qui pourrait, elle, conduire à la déflation.
Des différences de structure importantes existent entre les économies japonaises et américaines, notamment l'énorme volume de liquidité détenu par les ménages japonais qui tend à diminuer la consommation quand les taux d'intérêt baissent.
Du fait de ces différences et des leçons de la &quot;décennie perdue&quot; du Japon quant au besoin de refinancer le système bancaire, il est peu probable qu'il y ait une décennie perdue aux USA.
C'est pourquoi, à l'exception des USA et du Japon où les taux sont proches de zéro, les banques centrales peuvent sans risque en finir avec leur politique des taux d'intérêt et continuer à adopter des mesures fortes de soutien à la liquidité des marchés sans grand risque d'inflation.
Avec si peu de confiance dans le système financier et le crédit limité (en raison des préoccupations engendrées par la chute des prix dans l'immobilier) la politique des taux d'intérêt ne peut avoir les résultats habituellement escomptés.
Aussi, le consensus qui se dessine autour de la recapitalisation du système bancaire, et plus récemment sur des mesures contraires à l'orthodoxie, notamment l'achat de dettes du secteur privé était donc justifié.
Il y a deux différences majeures entre la situation des années 1930 et la situation actuelle.
Le monde industriel est aujourd'hui beaucoup plus dépendant du pétrole (essentiellement importé de l'étranger) qu'il ne l'était à cette époque.
L'explosion du prix du pétrole en termes réels a été une cause majeure de la récession actuelle, et l'inverse, la dégringolade des cours du baril sera un facteur majeur pour le redressement de l'économie.
Et il y a une autre différence cruciale : nous en savons assez aujourd'hui pour ne pas répéter les erreurs des années 1930, notamment le protectionnisme.
Le Procès de Pinochet et la dignité du Chili
La bataille juridique visant à déterminer si l'ancien dictateur chilien Augusto Pinochet était justiciable est maintenant terminée.
Après une profonde réflexion sur les rapports médicaux sur la santé de Pinochet, le juge Juan Guzmán l'a déclaré compétent pour se présenter devant le tribunal et répondre de 9 accusations de kidnapping et une accusation d'homicide.
La Cour suprême du Chili a maintenant décidé de soutenir cet acte d'accusation.
Tous ces crimes furent commis durant l'« Opération Condor », un programme qui s'étendit à toute l'Amérique latine et visant à permettre à tous les dictateurs du continent d'éliminer physiquement leurs opposants de gauche.
Le juge Guzmán a également déclaré que l'ancien dictateur n'est pas irresponsable et peut distinguer le bien du mal.
Ceci est essentiel, dans la mesure où Pinochet a tenté de nier sa compétence mentale.
Un récent « accident vasculaire » qui fut à l'origine de son admission dans un hôpital militaire où il a pu reprendre conscience et retrouver ses capacités motrices, fournira néanmoins une excuse pour demander de nouveaux examens médicaux et retarder la procédure légale entamée contre lui.
Cependant, les efforts du juge Guzmán pour traduire le dictateur en justice ne devraient pas rester isolés.
D'autres juges et d'autres corps officiels doivent continuer à faire pression sur Pinochet.
Il reste encore beaucoup à découvrir, par exemple, dans certains dossiers, notamment l'assassinat du Général Carlos Prats et de sa femme à Buenos Aires en 1974.
Ces enquêtes doivent être suivies d'actions judiciaires.
L'enquête sur la mort de l'ancien président Frei Montalva en 1980, principal opposant de la dictature, progresse mais doit être poursuivie avec plus de vigueur devant les tribunaux.
La mort de Frei implique l'appareil répressif que Pinochet et Manuel Contreras, son « bras droit », géraient chacun à leur niveau.
L'Opération Condor, l'affaire Riggs, l'affaire Frei et l'affaire Prats, et bien d'autres crimes, sont documentés dans le récent rapport sur la torture et l'emprisonnement politique préparé par la commission spéciale mise en place par le président Ricardo Lagos.
Publié 30 ans après le coup militaire qui porta Pinochet au pouvoir, ce rapport dérange les Chiliens et leur donne également un certain pouvoir.
Apparaissant invincible pendant tant d'années, la chute finale de l'ancien dictateur s'est entamée à Londres, en octobre 1998, quand des avocats espagnols, le juge espagnol Baltasar Garzón et Scotland Yard ont porté plainte contre lui.
Pinochet a répondu avec arrogance, provoquant un énorme sentiment de honte pour la jeune démocratie chilienne.
La capacité de Pinochet à échapper aux tribunaux fait du tort aux institutions militaires chiliennes et a poussé de nombreux Chiliens à s'interroger sur le degré de transition vers la démocratie réalisé par le pays.
Sans l'insistance du juge Garzón dans la poursuite de cet objectif, les poursuites contre Pinochet auraient été quasi impossibles, du fait de l'opposition puissante des Chiliens riches et au fait de l'actualité.
Les précautions excessives du gouvernement chilien, enracinées dans la peur de l'instabilité qui pourrait affecter les droits fondamentaux acquis après la dictature, ont également aidé Pinochet à échapper à la justice.
En effet, les tribunaux n'auraient pas pu rassembler le soutien public nécessaire pour se libérer de leur inertie sans l'aide apportée par M. Garzón.
Il aurait également été impossible d'attaquer Pinochet en justice sans les luttes pour les Droits de l'homme, extraordinaires d'importance, entamées par les organisations des victimes, des familles des victimes et des juristes qui, contre vents et marées, sont restés fidèles à leur cause pendant de longues années.
Peu d'organisations chiliennes ont été aussi motivées ou aussi victorieuses que celles qui se consacrent à la défense des Droits de l'homme.
Du fait de la ténacité et de la passion de Chiliens ordinaires exigeant que l'État remplisse son mandat de protection des Droits de l'homme, Pinochet s'est retrouvé devant un tribunal, et d'autres qui utilisèrent leur pouvoir pour assassiner, torturer ou exiler leurs concitoyens sont également poursuivis.
Et pourtant, nous sommes encore nombreux à nous demander si « Pinochet paiera pour ses mauvaises actions » ?
L'opinion publique internationale et l'Histoire l'ont déjà condamné.
La dignité du Chili ne tient plus qu'à un fil : à savoir si son système judiciaire parviendra à la même conclusion.
Personne ne peut être certain que Pinochet sera puni puisque le « pinochétisme » reste vivant au Chili.
De puissants défenseurs le soutiennent à l'aide de tous les moyens, pas toujours honorables, qu'ils peuvent rassembler.
Ils sont aidés en cela par le fait que certains membres du gouvernement préféreraient refermer ce chapitre de l'histoire triste des violations des Droits de l'homme plutôt que d'y apporter une conclusion.
Selon le chemin que la nation choisira de suivre, les Chiliens se réconcilieront peut-être avec leur passé.
Pour le moment, leurs opinions différentes coexistent et ils cohabitent tous de manière pacifique.
Mais les citoyens et l'État doivent regarder la vérité en face et amener devant les tribunaux les violateurs des Droits de l'homme si l'on veut que tous vivent honnêtement dans leur société et dans leur histoire.
Quand les Chiliens agiront ainsi, ils créeront les conditions d'une société plus honorable et plus digne.
Un jugement judiciaire contre Pinochet est une étape importante dans ce sens.
Pourquoi réduire les émissions de gaz à effet de serre
Stern Review Report on the Economics of Climate Change équivaut à une demande de passage à l'acte : elle explique que certains énormes coûts futurs du réchauffement climatique peuvent être évités en engageant des frais relativement modestes aujourd'hui.
Les critiques de la Stern Review ne pensent pas que des initiatives sérieuses visant à limiter les émissions de CO2 soient justifiées, car il subsiste encore de grandes incertitudes sur l'étendue des coûts du réchauffement climatique, et parce que ces coûts seront engagés dans un avenir lointain.
Cependant, je pense que la conclusion fondamentale de Stern est justifiée : il vaut bien mieux réduire les émissions de CO2 de façon substantielle que de risquer les conséquences de notre échec à agir, même si, à l'inverse de Stern, on ne tient aucun compte des incertitudes et de l'avenir.
Deux facteurs différencient le réchauffement climatique mondial des autres problèmes environnementaux.
Tout d'abord, alors que la plupart des affronts faits à la nature -- comme la pollution de l'eau, les pluies acides ou les émissions de dioxyde de souffre -- sont atténués avec une relative rapidité quand la source est nettoyée, les émissions de CO2 et de gaz traces restent dans l'atmosphère pendant des siècles.
Ainsi, la réduction des émissions aujourd'hui s'avèrera très précieuse pour l'humanité dans un avenir lointain.
Ensuite, les conséquences sont réellement à l'échelle mondiale, car les gaz à effet de serre voyagent autour du monde en quelques jours.
En conséquence, l'État-nation et ses seconds, les agents d'internalisation de ces conséquences, voient leurs capacités à y remédier limitées (cependant, étant donné que les États-Unis contribuent à hauteur de 25 % environ des émissions mondiales de CO2, leur politique pourrait faire une grande différence.)
Ainsi, le réchauffement climatique mondial est un (mauvais) bien public par excellence.
L'analyse coûts-bénéfices est un outil primordial pour décider s'il est justifié d'en changer le cours par le biais de politiques de réductions.
Deux aspects de ce calcul sont critiques.
Tout d'abord, il faut supposer que les individus préfèrent éviter le risque.
C'est-à-dire qu'une conséquence incertaine vaut moins que la moyenne des conséquences.
Comme les résultats possibles du réchauffement climatique en l'absence de réductions sont très incertains, bien que sûrement négatifs, les pertes incertaines devraient être considérées comme équivalentes à une seule perte plus importante que celle à laquelle on s'attend.
Le second aspect critique concerne la façon de traiter les conséquences futures par rapport à celles d'aujourd'hui -- une question qui a attiré l'attention de philosophes autant que d'économistes.
Dans quelle mesure les impacts futurs -- particulièrement les pertes de consommation future -- doivent-ils être ignorés aujourd'hui ?
Le taux d'escompte de la consommation doit expliquer la possibilité que, à mesure que la consommation augmente, l'unité marginale de consommation soit considérée comme ayant moins de valeur sociale.
C'est analogue à l'idée de diminuer l'utilité marginale privée de la consommation privée, et relativement peu sujet à polémique, bien que les chercheurs ne s'accordent pas sur son ampleur.
Le désaccord est encore plus grand sur la quantité d'escompte du futur simplement parce que c'est l'avenir, même si les générations futures ne sont pas mieux loties que nous.
Alors que la Stern Review suit la tradition des économistes britanniques et de nombreux philosophes contre l'idée d'escompte de l'avenir pur, la plupart des économistes estiment que la préférence temporelle pure est évidente.
Quoi qu'il en soit, les arguments en faveur d'une limitation volontaire des émissions de CO2 (pour les stabiliser par exemple à environ 550 ppm) sont suffisamment forts pour ne pas être ébranlés par cette querelle.
Considérons certains chiffres de la Stern Review concernant les futurs bénéfices de la limitation de la concentrations des gaz à effet de serre sous 550 ppm, ainsi que ce qu'il en coûtera.
Les bénéfices sont les dégâts ainsi évités, qui comprennent à la fois les dommages commerciaux et non-commerciaux, dont les impacts sanitaires et écologiques.
En suivant une politique "immobiliste", d'ici 2200, les pertes de PIB auront une valeur estimée à 13,8 %, mais avec un degré d'incertitude qui rend la perte attendue équivalente à une certaine perte d'environ 20%.
Étant donné que le taux de base de la croissance économique (avant le calcul de l'effet du réchauffement climatique) était considéré comme 1,3 % par an, une perte de 20 % en 2200 équivaut à réduire le taux de croissance annuel à 1.2 %.
En d'autres termes, les bénéfices de la réduction d'émission de gaz à effet de serre peuvent être représentés comme l'augmentation du taux de croissance annuel entre aujourd'hui et 2200 de 1,2% à 1,3%.
En ce qui concerne le coût de la stabilisation, les estimations de la Stern Review varient de 3,4 % du PIB à -3,9 % (puisque économiser l'énergie réduit les coûts énergétiques, les estimations pour ces derniers ne sont pas aussi saisissantes qu'elles paraissent).
Considérons que les coûts pour éviter l'accumulation supplémentaire de CO2 (et équivalents) reviennent à 1 % du PIB chaque année pour toujours, et, conformément à une bonne dose de preuves empiriques, que le composant du taux d'escompte attribuable à l'utilité marginale déclinante de la consommation soit égal à deux fois le taux de croissance de la consommation.
Un calcul simple montre que la réduction vaut mieux que l'immobilisme -- c'est-à-dire que la valeur actuelle des bénéfices dépasse la valeur actuelle des coûts -- pour tout taux social de préférence temporelle inférieur à 8,5%.
Aucune estimation du taux de préférence temporelle pur, même par ceux qui croient dans un escompte relativement fort de l'avenir, n'a jamais approché 8,5 %.
Ces calculs indiquent que, même avec un escompte plus élevé, les estimations des coûts et des bénéfices de la Stern Review impliquent que la réduction a un sens d'un point de vue économique. Ces calculs reposent sur les projections des profils temporels des bénéfices et sur ses estimations des coûts annuels, sur lesquels les désaccords font rage.
Pourtant, je crois qu'il ne peut y avoir que peu de graves désaccords sur l'importance d'une politique visant à éviter davantage de grandes augmentations des taux de CO2.
Kenneth J. Arrow, lauréat du prix Nobel d'économie, est professeur émérite d'économie et professeur émérite de science de gestion et d'ingénierie à l'université de Stanford.
La fin de l'exception suédoise ?
En Europe occidentale, depuis deux ans l'électorat penche à droite.
Au Danemark, en France, en Italie, en Hollande en Norvège et au Portugal, l'immigration, le chômage endémique, la lourdeur de la fiscalité et la détérioration des services publics ont alimenté cette tendance.
Mais comme le montre le résultat de ces dernières élections , les sociaux-démocrates suédois qui ont détenu le pouvoir 61 ans au cours de ces 70 dernières années restent en position de force.
Jusqu'à il y a quelques mois, les sondages leur attribuaient 44% des intentions de vote.
Avec les ex-communistes et les Verts, la gauche disposait d'une avance confortable de 12 à 15% devant les quatre partis d'opposition de centre-droite.
Pourquoi la Suède a-t-elle si bien résistée à la vague droitière qui balaye l'Europe occidentale ?
Le succès des sociaux-démocrates est dû essentiellement à la politique étrangère.
Au début de l'année dernière la Suède assurait la présidence de l'UE, donnant ainsi l'occasion à Göran Persson, le Premier ministre et l'homme fort du pays, d'occuper le devant de la scène.
D'autre part, les sociaux-démocrates ont devancé l'opposition en accordant leur soutien aux USA après les attentats du 11 septembre, ce qui leur a valu un regain de popularité.
Persson dégage une impression de compétence et d'autorité.
Il a encore renforcé son image en 1994 après sa victoire aux élections en resserrant le budget et en venant à bout d'un énorme déficit.
Mais il n'a rien accompli de très remarquable depuis sa victoire suivante en 1998.
A l'image de l'évolution du secteur des nouvelles technologies - illustrée par les difficultés d'Ericsson, le géant des télécommunications - l'économie suédoise a connu une embellie avant de chuter.
Cette année, libre de nouvelles promesses et jouant de son charisme, Persson avait des atouts dans son jeu en menant une campagne de type présidentielle.
Mais la force de caractère ne suffit pas à masquer les problèmes et une politique fluctuante.
Bien qu'à l'étranger on ait tendance à idéaliser le système de protection sociale suédois, l'économie du pays est en régression depuis 30 ans.
En 1970 la Suède arrivait en quatrième place pour son PIB par habitant, elle se retrouve aujourd'hui en 17° place au sein de l'OCDE.
Cette situation est due en partie aux prélèvements fiscaux, domaine dans lequel la Suède est championne du monde avec des dépenses publiques qui voisinent 60% du PIB.
Les conservateurs veulent diminuer les impôts, mais cette idée n'est pas populaire, près de 65% des Suédois étant fonctionnaires ou bénéficiant de transferts sociaux.
Contrairement aux autres Européens, les Suédois sont favorables à des impôts élevés, ce qui assure un large soutien à la gauche.
En dépit de cette situation, les Suédois s'inquiètent de la détérioration de leur système de protection sociale.
Les sociaux-démocrates ont su faire marche arrière sur ce point pendant cette année de campagne, mais on est allé trop loin dans le droit à la santé.
A tout moment 14% des salariés sont en arrêt-maladie, soit deux fois plus qu'il y a cinq ans.
Les sociaux-démocrates disent que cela traduit un véritable problème de santé publique, tandis que pour l'opposition c'est le système qui pose problème.
Beaucoup de Suédois en sont à croire qu'ils ont le droit de prendre un congé-maladie indépendamment de leur état de santé .
Mais il n'y a pas d'autre élément qui laisse à penser que la santé des Suédois se détériore.
La dégradation de l'enseignement public est aussi source d'inquiétude.
Stockholm, ville dirigée par les conservateurs et les libéraux, s'est lancé dans l'économie de marché avec la privatisation du métro et l'allocation de chèques-éducation permettant le libre choix d'un établissement.
Les sociaux-démocrates ont été défaits dans la capitale.
Comme lors des autres élections récentes en Europe, l'immigration a tenu une place importante, mais comme à son habitude, la Suède s'est distinguée des autres pays.
Le petit parti libéral qui a fait campagne en faveur de l'ouverture des frontières aux travailleurs étrangers a vu son audience tripler.
Il fait des propositions de bon sens : toute personne qui dispose d'un emploi devrait pouvoir obtenir un visa, mais la connaissance du suédois devrait être une condition requise pour être naturalisé et les immigrants sans emploi ne devraient avoir droit au chômage qu'au bout de cinq ans.
Le libre-échange post-soviétique
Depuis l'effondrement de l'Union soviétique, les Etats indépendants auxquels il a donné naissance essayent de clarifier leurs relations commerciales.
Les douze pays membres de la Communauté d'Etats indépendants (CEI) ont signé un accord de libre-échange en 1994, mais il ne donne guère de résultats.
Quand un pays réussit à exporter des marchandises dans un autre, ce dernier impose des quotas ou des taxes douanières prohibitives qui nuisent au développement économique.
La solution évidente consiste à utiliser un mécanisme de résolution des conflits.
L'Organisation mondiale du commerce (OMC) dispose d'une cour d'arbitrage et peut imposer des sanctions, mais seuls quatre pays de la CEI (le Kirghizstan, la Géorgie, la Moldavie et l'Arménie) adhèrent à l'OMC.
Les principales puissances économiques de la CEI (la Russie, l'Ukraine et le Kazakhstan) auraient tout intérêt à rejoindre rapidement cet organisme.
Malheureusement, au lieu d'adopter des mécanismes qui ont fait preuve de leur efficacité, divers pays de la CEI inventent des mécanismes toujours plus complexes tels que l'Union douanière des Cinq, rebaptisée Communauté économique eurasienne l'année dernière quand son échec est devenu patent.
Ce terme vague désigne trois choses : une union douanière, la coordination des candidatures à l'OMC et une union monétaire.
Mais aucun de ces éléments ne sera bénéfique aux participants.
L'union douanière au sein de la CEI a déjà échoué et elle échouera à nouveau.
Elle n'a pas facilité davantage le commerce que la zone de libre-échange de la CEI.
Il n'y a eu aucune harmonisation douanière.
La Russie refuse de reconnaître dans les faits l'indépendance des autres pays de la CEI et cherche à leur imposer sa propre politique douanière, ce qu'ils refusent.
Les quatre présidents proposent maintenant de créer une commission supranationale indépendante pour le commerce et les droits de douane, de manière à parvenir à une politique douanière commune.
Mais il n'y a aucune raison de croire que cela donnera de meilleurs résultats que l'union douanière.
En un mot, tous ces pays n'ont pas les mêmes intérêts commerciaux.
Un pays qui ne produit pas un bien n'a aucun intérêt à sa protection, contrairement à ceux qui le produisent.
Ainsi, la Russie qui possède une industrie aéronautique et automobile veut des barrières douanières importantes, alors que le Kazakhstan ne possède ni l'une ni l'autre.
Or des taxes élevées sur les voitures importées de Russie constitueraient un fardeau financier injustifié pour les Kazakhs.
La coordination des candidatures des pays de la CEI à l'OMC paraît à première vue une bonne chose, mais en pratique cela retarderait de plusieurs années leur adhésion au moment où il faut faire preuve de beaucoup de réactivité.
Avec des échanges commerciaux complexes et à grande échelle, l'adhésion de la Russie à l'OMC pose bien plus de problèmes que celle de l'Ukraine ou du Kazakhstan.
La Russie doit conclure des accords bilatéraux avec 67 pays différents, alors qu'ils ne sont que 22 pour l'Ukraine.
Ainsi, la Russie a demandé à l'Ukraine d'abroger 11 accords bilatéraux qu'elle a déjà signés dans le cadre de son entrée à l'OMC.
Les échanges commerciaux au sein de la CEI ne vont pas s'améliorer tant que la Russie, l'Ukraine et le Kazakhstan n'adhèrent pas à l'OMC.
S'ils arrêtaient de "coopérer" pour se faire concurrence dans l'adhésion à l'OMC, ces trois pays en deviendraient membres en moins d'un an.
Le pire, c'est l'idée d'une union monétaire.
Ce désastre a été essentiellement dû au fait que la Banque centrale de chacun des pays de la CEI émettait des roubles, aucun d'entre eux n'acceptant que sa politique monétaire soit entre les mains de la seule Russie.
Pourquoi répéter la même catastrophe ?
Aujourd'hui, le contexte politique n'a pas changé, aucun pays de la CEI n'est prêt à accepter le monopole de la Russie quant à l'émission d'une monnaie commune.
Or sans le monopole et la centralisation de l'émission de monnaie au sein d'un organisme unique, une union monétaire ne peut fonctionner.
- Une union monétaire suppose des économies diversifiées de taille conséquente qui reposent sur une structure financière solide.
Ce n'est pas le cas de la plupart des pays de la CEI.
- Les membres d'une union monétaire doivent avoir des structures économiques similaires ou à tout le moins des intérêts commerciaux convergents.
Etant donné la dépendance de la Russie vis-à-vis de ses exportations de pétrole et de gaz naturel et le statut d'importateur de sources d'énergie de l'Ukraine, leurs intérêts tendent à diverger.
En cas de chute du prix du pétrole, 'une dévaluation monétaire serait profitable à la Russie, tandis que l'Ukraine aurait besoin d'une réévaluation.
Lors de ces trois dernières années, le taux de croissance moyen a été de 6% pour la Russie de l'Ukraine et de 11% pour le Kazakhstan.
L'économie de ces trois pays évolue donc favorablement, mais aucun ne peut se permettre d'erreur dans le domaine du commerce extérieur.
Leur politique économique est dictée par une pensée libérale efficace sur le plan intérieur, il faudrait qu'il en soit de même en ce qui concerne leurs échanges extérieurs.
Poutine oeuvre-t-il à sa propre destruction ?
Avec l'arrestation de l'homme le plus riche du pays, le magnat du pétrole Mikhaïl Khodorkovski, la Russie se trouve plongée dans une crise politique profonde.
Sans le vouloir, le Président Vladimir Poutine a choisi de se lancer à l'assaut d'une victoire totale contre l'oligarque pétrolier.
Il n'y a pas d'autre enjeu ici que la fragile démocratie russe.
Les accusations lancées contre Khodorkovski portent sur des affaires anciennes de privatisation et d'évasion fiscale.
Toutefois, les accusations portées contre Khodorkovski sont aussi mal fondées qu'elles sont tendancieuses : l'affaire de la privatisation a été réglée à l'amiable et Khodorkovski n'a fait qu'utiliser les programmes d'évitement fiscal couramment utilisés en Russie et qui ont fait leurs preuves auprès des tribunaux.
Le vrai problème de Poutine tient à ce que Khodorkovski est bien trop puissant et indépendant pour la politique étriquée que Poutine veut mettre en place.
En quatre ans de pouvoir, Poutine a fait progresser quatre politiques principales.
Les trois premières, la réforme de l'économie de marché, le principe de légalité, et une politique étrangère pragmatique, ont été largement applaudies tandis que la quatrième, la « démocratie dirigée », n'a été tolérée qu'en vertu de la stabilité politique qu'elle permet.
Cependant, cette « démocratie dirigée » menace maintenant de défaire ses trois réussites politiques.
Khodorkovski est le quatrième homme d'affaires important à être soustrait au monde des affaires par les autorités.
Quatre chaînes de télévision indépendantes ont également été reprises en main par l'état, et aucune critique de Poutine n'est autorisée dans les médias d'importance.
Les principaux organismes de sondage sont aussi passés sous le contrôle du Kremlin.
Les élections régionales sont régulièrement manipulées, souvent par l'exclusion des candidats de l'opposition.
La tendance est évidente : nous nous dirigeons droit vers un système autoritaire.
Les oligarques russes manquent sans aucun doute de popularité et l'arrestation de Khodorkovski avait évidemment pour but de redorer l'image de Poutine pour les élections parlementaires et présidentielles à venir.
Pourtant, même si les Russes détestent les puissants et préfèrent prendre le parti des plus faibles et des martyres, aucun homme emprisonné ne peut sembler être un homme fort.
Avec l'arrestation de Khodorkovski, les autorités ont fait étalage de leur puissance arbitraire et extrajudiciaire de telle manière qu'elles ont suscité une inquiétude générale parmi les populations.
Par le passé, Poutine avait attiré le soutien d'un grand nombre de Russes.
Ayant réussi l'équilibre entre l'ex-KGB et le monde des affaires, il apparaissait comme indépendant de ces deux forces.
Aujourd'hui, il s'est mis à dos le monde des affaires, dont il refuse de rencontrer les représentants.
Soudainement, il s'est réduit à l'image d'un président du KGB, mettant en danger la stabilité politique même qu'il a tant cherché à garantir.
Poutine parle sans cesse du besoin d'établir le principe de légalité et pourtant, dans son allocution télévisée du 27 octobre, il s'est effectivement prononcé en faveur des hommes de main de la législation.
En fait, dans l'affaire Khodorkovski, toutes les obligations judiciaires ont été allégrement négligées.
Par exemple, bien que les procureurs soient à la direction des organismes appropriés, ils ne se sont pas sentis obligés d'émettre les mandats nécessaires aux perquisitions chez Ioukos et aux arrestations.
La conclusion évidente que même les citoyens russes peuvent tirer de tout cela reste que ni leur droits de propriétaires ni leur propre personne ne sont à l'abri de tels abus.
Les investissements vont probablement cesser ou se ralentir.
Ceux qui peuvent exporter leurs capitaux le feront.
Il en résultera une certaine panique qui ralentira le rythme de la croissance actuellement forte.
Les retombées de l'arrestation de Khodorkovski se ressentent à l'étranger également.
La presse du monde des affaires a condamné dans l'ensemble le comportement des autorités, particulièrement la saisie des actions Ioukos qui valent plusieurs fois ce que l'état peut réclamer, et qui a des relents d'expropriation.
Les gouvernements étrangers ont fait état de leurs craintes.
D'un seul geste, Poutine a mis en danger ses meilleures réussites.
Avec son franc parler en public, il est sorti de sa réserve passée et s'est privé de toute possibilité de démenti.
Les coupables au sein du KGB restant silencieux, le Président a dû prendre la parole plus souvent s'exposant ainsi encore plus.
Cependant, pourquoi avoir défendu cette arrestation dans une allocution télévisée ?
Pourquoi refuser de rencontrer les élites du monde des affaires russe au moment même où des rencontres sont organisées avec des banques d'investissement étrangères ?
Pourquoi saisir les actions de Ioukos ?
Deux semaines avant son arrestation, Khodorkovski me disait « ne pas comprendre comment ils pouvaient gagner, au vu des bévues qu'ils ont commises ».
Ces paroles me semblent maintenant prémonitoires.
La situation au Kremlin semble rappeler celle du printemps de 1996, quand un groupe d'hommes du KGB, emmené par le chef des gardes du corps du Président Boris Eltsine, le Général Alexander Korsakov, se sont presque emparés du pouvoir.
Toutefois, les oligarques se sont alors mobilisés pour soutenir Anatoly Chubais, qui écarta Korsakov et ses hommes dès le mois de juin.
Une fois de plus, les hommes d'affaire russes se sont rassemblé derrière Chubais.
Si Poutine veut sauver sa carrière, il devra agir rapidement et se débarrasser de ses chefs du KGB au service du Kremlin et du procureur général.
Cela vaut la peine de rappeler à tous que l'ancien Premier ministre de 1999, Yevgeny Primakov, et le maire de Moscou, Youri Luzhkov, sont donnés comme grands favoris pour l'élection présidentielle à venir.
Pourtant, ayant cherché à se faire bien voir par les médias russes, ils ne sont pas habitués aux critiques et se sont trouvés désarmés quand les critiques se sont faites sentir.
Le tabou de la critique envers Poutine est déjà sans force.
Les principaux partis libéraux, l'Union des forces de droite et Yabloko, l'attaquent férocement tandis que les petits partis qui soi-disant le soutiennent restent silencieux et perdus.
Ils sont censés être sur le point de gagner une majorité écrasante aux élections parlementaires à venir du 7 décembre et pourtant, comme Korsakov et sa clique, ils pourraient bien être défaits.
En fait, en s'aliénant le monde des affaires et en laissant son chef de cabinet, le rusé Alexandre Volochine, démissionner, Poutine s'est privé lui-même d'un soutien électoral précieux.
Son ancien conseiller politique principal l'a même accusé d'utiliser des « mesures staliniennes » et si Poutine ne correspond plus aux attentes pressantes de l'élection parlementaire à venir, ses chances de remporter les élections présidentielles du 14 mars 2004 pourraient bien être remises en question.
En arrêtant Khodorkovski, Poutine a dévoilé sa nature autoritaire au monde entier.
Il a lancé son gant au visage de la société civile et des élites du monde des affaires de la Russie.
Ils n'ont pas d'autre choix que de lui résister et leur force ne doit pas être sous-estimée : la bataille pour la démocratie russe est donc ravivée.
La Dernière bataille de Poutine
Le Président russe, Vladimir Poutine, a atteint ses objectifs avec brio lors de son premier mandat.
Il a renforcé les pouvoirs du gouvernement fédéral tout en affaiblissant le monde des affaires, la presse libre, la parti communiste, les libéraux et la société civile.
Au sein du gouvernement, il a fait pression sur les gouverneurs régionaux, les deux chambres du parlement, et même l'appareil d'Etat, et concentré tous les pouvoirs, l'exécutif, le législatif et le judiciaire, entre ses propres mains.
Au même moment, depuis l'arrivée de Poutine au pouvoir en 2000, la Russie a atteint une solide stabilité macroéconomique et une croissance annuelle régulière de 6,5 % en moyenne.
Malheureusement, la réussite de Poutine précipitera peut-être sa chute.
Il eut la chance pendant son premier mandat de savoir reconnaître les limites de son pouvoir.
Lecteur avide des sondages d'opinion, il a essayé, mystérieusement, de combler toutes les attentes de son électorat.
Maintenant, grisé par l'enchaînement de ses triomphes politiques, il semble se penser libre de toute contrainte. Toutefois, aucun homme politique ne peut bénéficier de cette chance-là.
Poutine a fait fi de bien trop de règles politiques et sa chance ne le suivra plus très longtemps.
Ainsi, se montrant trop jaloux de puissance et incapable de déléguer, voulant prendre toutes les décisions lui-même, il a remplacé un Premier ministre et un Chef de cabinet puissants par deux hommes inefficaces.
Donc, plutôt que de créer un commandement vertical fort, il a paralysé son gouvernement.
Une des raisons de cette surcentralisation poussée à l'extrême vient de son manque de confiance en quiconque.
Autre raison: son obsession pour le mystère.
Policier véritablement secret, Poutine s'appuie sur son cercle d'hommes de main du KGB de l'époque de St-Pétersbourg.
La base de son pouvoir s'amenuise toujours plus chaque jour et sa gestion de la presse indépendante le laisse de plus en plus mal informé.
Les conséquences se sont fait sentir lors du drame de la prise d'otages de Beslan en Ossétie du Nord.
Les forces de l'ordre n'ont pas su aider les populations locales.
Elles ne disposaient d'aucun renseignement pertinent.
Les forces de police ont accepté des pots-de-vin pour laisser les terroristes s'infiltrer.
Les forces spéciales russes d'élite ont été envoyées à Beslan sans aucun armement, sans aucune protection pare-balle, sans aucun plan de bataille ni commandement effectif.
L'école ne fut jamais encerclée.
Finalement, les Ossétiens ont envahi l'école avec leurs propres armes et tué plusieurs membres des forces spéciales par mépris.
Aussi incroyable que cela semble, le Directeur du Service de la sécurité fédérale (FSB) et le Ministre de l'intérieur se sont rendus sur les lieux de la prise d'otages très rapidement sans pour autant prendre aucune mesure.
Les deux gouverneurs locaux concernés refusèrent de se rendre ensemble à Beslan.
En fait, le gouvernement n'a pris aucune mesure.
Poutine et son gouvernement se sont contentés d'ignorer la crise de Beslan, en minimisant la couverture médiatique de l'événement.
Les déclarations officielles furent faites par un représentant local de moindre importance qui s'est lui-même ridiculisé en mentant de manière éhontée.
Il est difficile d'imaginer pire performance de la part des autorités gouvernementales.
En son temps, le Président soviétique Léonide Brejnev fut ridiculisé pour ne s'être intéressé qu'à taire les mauvaises nouvelles plutôt qu'à se montrer prêt à résoudre les problèmes. Poutine se comporte aujourd'hui de la même façon.
Tant de mystère, bien sûr, ne peut que faire du tort à la Russie.
Les conclusions à tirer du drame de Beslan sont évidentes.
Il faut restructurer la police tchétchène.
Les forces de sécurité doivent être purgées et reprises en main.
Les ministres et gouverneurs inefficaces doivent être limogés, et leurs bureaux doivent se voir confier plus d'autorité.
La communication doit être plus ouverte et il faut réduire la présence des forces du KGB.
Poutine, cependant, ne veut pas entendre parler de tout cela.
Il n'obéit à aucune règle élémentaire et surtout pas à celle qui conseille de se tenir coi quand on a trop parlé.
Aucun responsable n'a été limogé mais le rédacteur en chef des Izvestia a été renvoyé pour avoir manqué de précision dans ses reportages.
De même, rien n'a été fait pour traiter le problème de la corruption endémique du FSB.
Plutôt que d'accorder plus d'autorité aux gouverneurs, Poutine a exigé le pouvoir de les nommer lui-même.
Au lieu de renforcer le gouvernement, il a privé de ses forces vives, Dimitri Kozak, pour nommer à sa place encore un illustre inconnu du cercle de ses hommes de main du KGB, de l'époque de St-Pétersbourg.
Le rôle de Poutine n'est pas seulement autoritaire, il est aussi dysfonctionnel.
Il est trop rigide et centralisé pour gérer les crises.
Plutôt que de s'attaquer aux problèmes réels, Poutine ne se préoccupe que de ses propres impératifs.
Cet état de police centralisée ne s'intéresse qu'à très peu de choses en dehors de son propre pouvoir politique et économique.
Il est difficile d'échapper à l'impression que Poutine s'intéresse plus à prendre soin de ses hommes de main du KGB qu'à combattre le terrorisme.
Les réformes économiques libérales menaçant leurs intérêts, elles ont été abandonnées.
Les citoyens russes ne sont pas aveugles.
Et ils se demandent comment la nomination des gouverneurs régionaux peut servir à lutter contre le terrorisme.
Poutine érode rapidement la grande autorité qu'il s'est bâtie pendant son premier mandat.
Ce processus peut déstabiliser la Russie plus rapidement qu'on ne le croit.
La question n'est plus de savoir si Poutine lâchera vraiment le pouvoir en 2008 au terme de son mandat mais plutôt s'il sera capable de se préserver aussi longtemps.
Il le pourra certainement, mais il lui faudra faire volte-face et remettre la Russie sur le chemin de la démocratie, de la gestion régionale et de la libre expression.
Tout au moins devra-t-il limoger ses amis du KGB et son infortuné Premier ministre, Mikhaïl Fradkov.
Il lui faudra aussi régler l'affaire Youkos et modifier sa politique tchétchène.
Poutine a le pouvoir de réaliser tout cela, mais pas la volonté.
 Un espoir de démocratie en Ukraine 
La révolution orange ukrainienne va atteindre son apogée lors du scrutin du 26 décembre qui verra s'affronter à nouveau dans la course à la présidence le Premier ministre Viktor Ianoukovitch et son prédécesseur, Viktor Iouchtchenko, après l'annulation du scrutin précédent, entaché de fraudes massives, ce qui a entraîné des centaines de milliers d'Ukrainiens à descendre dans les rues de Kiev pour défendre leurs droits.
L'élection de dimanche devrait être plus régulière et se conclure par la victoire à Viktor Ianoukovitch. Mais l'Ukraine n'est pas assurée pour autant d'un futur démocratique.
L'Ukraine traverse une véritable révolution libérale, semblable à celles que l'Europe a connu en 1848 et à la Révolution de velours à Prague en 1989.
Les Ukrainiens veulent la démocratie, la liberté et le respect de la loi.
Après cinq ans de croissance économique au taux de 9% par an, il est frappant de constater l'absence de revendications à caractère économique, comme le sont toutes les revendications socialistes ou même sociales.
Même truqué, le résultat du scrutin précédent montre que le pays est divisé géographiquement et ethniquement, Viktor Iouchtchenko, le candidat de l'opposition démocratique, arrivant largement en tête dans les 17 régions de l'ouest et du centre du pays et Viktor Ianoukovitch dans les dix régions de l'est et du sud.
Mais Iouchtchenko l'a emporté dans plusieurs régions russophones, notamment à Kiev, la capitale, tandis que Ianoukovitch l'a devancé dans les régions de tradition autoritaire comme le Donetsk et le Lougansk, plus à l'est.
La plupart de ces différences régionales s'expliquent par le degré de démocratie et d'ouverture, plutôt que par des considérations ethniques.
Iouchtchenko a eu la sagesse de lancer le slogan "L'Est et l'Ouest unis", soulignant ainsi son souhait de ne pas diviser le pays.
De la même manière, les manifestants ont su rapidement convaincre de la justesse de leur cause les mineurs de l'Est conduit en autobus à Kiev pour une courte visite par leur encadrement.
Le rôle des hommes d'affaires est manifeste des deux cotés.
Une plaisanterie populaire consiste à dire qu'il s'agit d'une révolte des millionnaires contre les milliardaires.
La candidature de Ianoukovitch avait l'appui des clans à la tête des trois plus grosses entreprises du pays, tandis que le reste du monde des affaires, y compris quelques millionnaires, soutenait dans sa grande majorité Iouchtchenko.
C'est une authentique révolution bourgeoise.
C'est l'habitude du président Leonid Koutchma de diviser pour régner et de magouiller qui est à l'origine de la croissance économique et de la révolution ukrainienne.
La majorité de la population aspire au respect de la loi et à l'ordre et les hommes d'affaires veulent des règles du jeu équitables pour traiter avec les riches et les puissants.
Iouchtchenko, s'il s'en prend aux "bandits" et à la corruption, évite de critiquer les oligarques, car certains parmi les plus petits d'entre eux le soutiennent.
Rarement on a vu un pays intervenir aussi massivement dans les élections d'un autre pays que la Russie ne l'a fait.
Les partisans de Iouchtchenko disent que le Kremlin a obligé les entreprises russes à verser 300 millions de dollars pour soutenir la campagne de Ianoukovitch.
Les plateaux de télévisions de Kiev étaient envahis de conseillers politiques russes qui diffamaient Iouchtchenko bien plus que ne l'ont jamais fait ses adversaires ukrainiens.
Le président Poutine lui-même est intervenu deux fois en Ukraine en faveur de Ianoukovitch et l'a félicité par deux fois avant que le résultat truqué ne soit prononcé, ce qui l'a quelque peu ridiculisé.
Cet activisme déchaîné de la Russie est étrange.
Ianoukovitch est favorable à un véritable État oligarchique qui ressemble à celui que Poutine a démembré en Russie et il a accusé Iouchtchenko d'avoir vendu les entreprises ukrainiennes à la Russie.
L'attitude de Poutine s'explique sans doute par son aversion à l'égard de la démocratie.
Enfin, si le président ukrainien devient un paria sur la scène internationale, il lui restera à se tourner vers la Russie, à l'image du président biélorusse Alexandre Loukachenko.
Après ce spectaculaire échec de la Russie, la "démocratie contrôlée" de Poutine paraît anachronique et courre le risque de voir à ses portes une véritable démocratie faire tache d'huile.
Pour la première fois, les Ukrainiens se sont débarrassés du complexe du grand frère à l'égard de la Russie.
Avec leur confiance retrouvée, ils se rendent compte qu'ils peuvent penser par eux-mêmes et faire face à la réalité, contrairement à leurs frères russes.
L'Ukraine n'a guère d'autre choix que de se tourner vers l'Europe et vers l'Occident.
Les exportations d'acier ont stimulé l'appétit de la Chine, mais tôt ou tard ses besoins vont être comblés et l'Ukraine devra trouver de nouveaux marchés.
L'Europe est le débouché évident, alors que la Russie n'a à offrir qu'une concurrence sans merci.
Si l'Ukraine devient une démocratie, elle va sans doute acquérir rapidement la culture du respect de la loi.
Elle a déjà une économie de marché et elle se trouve incontestablement en Europe.
Aussi, accueillir l'Ukraine représente un formidable défi pour l'Union européenne.
Beaucoup de choses peuvent encore mal tourner.
Le processus électoral pourrait ne pas aboutir ou bien Iouchtchenko pourrait se voir refuser le pouvoir exécutif.
C'est ce qui est arrivé à Solidarité en Pologne en 1980-81, où le pouvoir communiste a tenu pendant encore une décennie.
Heureusement pour l'Ukraine, les entreprises ont été privatisées et les milieux d'affaires sont unanimes à estimer que le nouveau scrutin doit aboutir.
Sans cela, la déstabilisation financière menacerait les riches.
Le rôle proéminent des multimillionnaires dans la révolution constitue un autre danger.
Il est évident qu'ils voudront dominer le nouveau gouvernement. On les retrouve dans tous les partis, armés de leur remarquable capacité à diriger et de leur impressionnant savoir-faire intellectuel.
Si on les laisse agir, la redistribution des fortunes va sans doute l'emporter sur la lutte contre la corruption, et les espoirs révolutionnaires de l'Ukraine s'évanouiront.
Iouchtchenko devrait s'entourer des jeunes cadres qui n'ont pas encore été touchés par la corruption généralisée de l'ancienne administration.
L'ancien régime n'a pas disparu.
Iouchtchenko a obtenu la majorité au Parlement parce que beaucoup de partisans de l'ancien régime ont retourné leur veste par opportunisme.
Ils peuvent recommencer et il faut savoir que 300 des 450 membres du Parlement ukrainien seraient des millionnaires.
Des élections parlementaires rapprochées seraient à souhaitables, mais c'est constitutionnellement difficilement réalisable.
Iouchtchenko a été contraint d'accepter une réforme politique maladroite qui recèle de nombreuses chausse-trappes.
La menace russe est toujours présente et il ne faut pas s'attendre à une réaction de la part de l'Occident.
Heureusement, les partisans de Iouchtchenko ont conscience que le temps presse et qu'il faut agir rapidement.
Une occasion extraordinaire s'offre à l'Ukraine ; à ses dirigeants de ne pas la laisser passer !
La chance de Poutine, la malchance d'Eltsine
Les excellentes performances économiques de la Russie n'ont pas grand-chose à voir avec la politique de Poutine, mais plutôt avec les réformes adoptées par Eltsine.
En 1998, la Russie était déjà parvenue à une masse critique de marchés et d'entreprises privées, alors que la crise financière de cette année-là fonctionnait comme une catharsis, obligeant le gouvernement à abolir les subventions aux entreprises qui constituaient la base d'un déficit budgétaire dévastateur se montant à quelque 9 % du PIB.
En outre, les prix mondiaux du pétrole qui étaient tombés à 10 $US le baril commençaient à atteindre des sommets.
Toute la success-story était ainsi en place début 1999, un an avant que Poutine n'entre en scène.
Certes, on peut accorder à Poutine le crédit de réformes économiques substantielles au cours de ses trois premières années.
Un nouveau code fiscal a été adopté, avec des taxes plus réduites et moins nombreuses, notamment un impôt sur le revenu fixe à 13 %.
Le code civil a été achevé, un nouveau code douanier mis en place, et une réforme judiciaire conséquente mise en œuvre.
Dans le même temps, cependant, Poutine a systématiquement éliminé la rudimentaire démocratie mise en place par Eltsine.
Une chaîne de télévision après l'autre a été reprise par l'État sous divers prétextes, tout comme les principaux journaux.
Les candidats et les partis d'opposition se sont vus refuser d'être enregistrés à la moindre petite plainte officielle.
La falsification des élections est devenu la norme.
De nombreux Russes célèbres ont favorisé le modèle de politique autoritaire et l'économie libérale à la Pinochet.
Mais la montée de l'autoritarisme a aussi atteint le monde des affaires.
En octobre 2003, Poutine a sévi contre Mikhaïl Khodorkovsky, PDG et principal propriétaire de Ioukos, entreprise pétrolière qui a le plus de valeur en Russie.
Celui-ci a été jeté en prison sur des accusations douteuses de fraude fiscale après avoir soutenu les opposants politiques de Poutine., Les associés de Poutine convoitaient la fortune de Ioukos, confisquée par la compagnie pétrolière d'État Rosneft par le biais de taxation illégale, ruinant au passage les réformes fiscale et judiciaire de Poutine et sapant gravement les droits à la propriété.
En fait, depuis 2003, la principale politique économique de Poutine a été la renationalisation.
Des entreprises privées bien gérées ont été plus ou moins obligées de vendre leur fond à des entreprises dominées par l'État.
Gazprom achète des compagnies pétrolières (Sibneft), gazières et énergétiques à des prix très avantageux, renforçant ainsi son monopole.
Cela lui permet de dynamiser ses profits en augmentant ses tarifs, malgré une production stagnante.
En effet, maintenant que les compagnies d'État produisent un tiers du pétrole russe, la croissance de la production s'est effondrée, car les propriétaires des entreprises privées, source du dynamisme du secteur, ont maintenant peur d'investir dans de nouvelles capacités.
Parmi les investisseurs étrangers, Shell et TNK-BP sont en train d'être évincés par Gazprom dans leurs principaux gisements pétroliers en Russie.
Outre le pétrole et le gaz, l'agence russe d'exportation d'armes, Rosoboronexport, vient juste de s'emparer d'Avtovaz, le fabricant de voitures russe géant et en total dysfonctionnement, et de VSMPO-Avisma, la grande entreprise russe de titane, pendant que tous les fabricants d'avions étaient rassemblés au sein d'une unique compagnie d'État.
Le gouvernement accueille cette renationalisation avec joie, bien qu'elle ait réduit la croissance industrielle russe en la faisant passer de 8,3 % en 2004 à 4 % ces deux dernières années.
De même, des banques d'État inefficaces -- bien inférieures à des banques privées même au Kazakhstan ou en Ukraine -- dominent le secteur bancaire.
La peu rentable banque d'État Vneshtorgbank, par exemple, est prise d'une frénésie d'achats, empirant le niveau du secteur bancaire russe.
Les surplus pétroliers de la Russie poussent la croissance économique à une augmentation des investissements, ce qui dynamise la construction et la consommation, ce qui à son tour bénéficie au commerce de détail et à la finance.
Avec une forte augmentation des revenus personnels, la pauvreté est sur le déclin, et 68 % des jeunes Russes fréquentent l'université.
Pourtant, d'autres indicateurs sociaux sont médiocres.
L'espérance de vie des hommes reste bloquée à 59 ans.
Le nombre de meurtres est encore plus élevé sous Poutine que sous Eltsine, tout comme le nombre de morts sur la route.
Aucun des grands systèmes publics (éducation, santé ou armée) n'a été réformé, et le régime ne montre que peu d'intérêt à cet égard.
Le Kremlin est préoccupé à la place par la rentabilité et la valeur des entreprises dominées par l'État, qu'il contrôle.
Comme on pouvait s'y attendre, tous les indicateurs de corruption ont augmenté depuis que Poutine a succédé à Eltsine, alors qu'ils baissent dans la plupart des pays post-communistes.
Bien que la corruption soit omniprésente, aucun haut responsable n'a été poursuivi.
Poutine et ses amis du KGB de Saint Pétersbourg sont paisiblement installés sur toute cette richesse, grâce à leur gouvernance autoritaire et à leur contrôle de tous les organes de sécurité.
Un appareil d'une telle puissance ne peut aller tranquillement prendre sa retraite dans une datcha comme l'a fait Eltsine, car il faudrait tout privatiser d'abord. Cela implique que Poutine n'a pas d'autre choix que de rester à son poste, quoi qu'il dise ne pas prétendre à un troisième mandat présidentiel.
Mais s'il s'accroche au pouvoir, à l'encontre de la constitution, sa popularité pourrait très bien s'effondrer, d'autant que le succès de sa politique économique est dû à la chance et non à la réforme.
La poutinomique
Le fait le plus surprenant lors de ces élections a été de voir Poutine perdre son sang froid.
Il a multiplié les apparitions publiques, au point que cela en était agressif, tandis que ses propos manquaient de substance.
Il s'en est pris à l'Occident et au &quot;chaos&quot; des années 1990, de la même manière qu'il s'en était pris aux terroristes tchétchènes en 1999 et aux oligarches en 2003.
Le Kremlin a abandonné les procédures démocratiques, décidant des partis et des candidats autorisés à se présenter, tandis que Poutine monopolisait la couverture médiatique.
Les militants de l'opposition étaient empêchés de faire campagne et étaient souvent arrêtés, tandis que les tribunaux à la solde du Kremlin refusaient de prendre en compte leurs plaintes.
Aussi, la nouvelle Douma a-t-elle été nommée plutôt qu'élue.
Elle manque de légitimité et ses membres sont des inconnus.
Quant à la légitimité de Poutine, elle est entachée par ce trucage massif.
Son seul meeting public à Moscou n'a attiré que 5000 personnes.
Les questions clés sont maintenant de savoir jusqu'à quel point il va se montrer autoritaire et s'il va être affaibli par cette lamentable campagne.
Sa politique est facile à comprendre une fois que l'on a réalisé qu'il fait généralement le contraire de ce qu'il dit.
Lors de son premier mandat, il est apparu comme un réformateur autoritaire.
Il s'est lancé dans des réformes économiques et fiscales, introduisant par exemple un taux d'imposition sur le revenu uniforme de 13%, mais lors de son second mandat, il s'est montré seulement autoritaire, n'entreprenant aucune réforme économique ou sociale méritant d'être mentionnée.
Le démantèlement de la compagnie pétrolière Yukos, évaluée à 100 milliards de dollars, en a été l'événement phare, il a été suivi d'une vague de corruption.
Poutine a établit une dictature purement personnelle.
La Russie unie , n'est guère plus qu'un petit groupe de hauts fonctionnaires.
Il gouverne sans idéologie ni parti, par l'intermédiaire de l'administration présidentielle et de services de police secrète en concurrence les uns avec les autres.
Il a affaibli la plus grande partie du pouvoir des autres institutions.
L'autoritarisme personnel survit rarement à celui qui l'incarne.
Ayant créé un régime hyper-centralisé qui ne peut survivre sans lui, Poutine doit rester président.
La loi n'a guère d'importance car il peut toujours demander au Conseil constitutionnel d'approuver un troisième mandat.
Son régime est constitué de divers groupes formés par des entreprises d'Etat comme Gazprom, Rosneft, la Vneshtorgbank, Rosoboronexport, et les Chemins de fer russes, auxquels if faut ajouter les agences de sécurité.
Sa clique d'ex-agents du KGB, en général de St Petersbourg, contrôle ces institutions et en extorquent d'énormes dessous de table.
En même temps, il a fait ce qu'il fallait pour qu'ils se détestent entre eux, de manière à ce qu'ils aient recours à lui comme arbitre et parrain.
Dans une interview au journal russe Kommersant qui a fait sensation avant l'élection, l'un de ces anciens dirigeants du KGB, jusque là inconnu, a expliqué comment ils se servent d'extorsion de fonds par l'Etat à l'encontre de ces entreprises pour faire une &quot;renationalisation de velours&quot; au moyen de rachats par les entreprises d'Etat.
Selon la Banque européenne pour la reconstruction et le développement, la part du PIB du secteur privée est passée de 70 à 65% sous Poutine.
Les renationalisations par l'extorsion de fonds va probablement s'accélérer.
Ces renationalisations n'ont pas été justifiés idéologiquement, mais cyniquement : leur objectif est simplement de générer des pots de vin pour les hauts responsables du Kremlin.
Aucun des principaux hommes de main de Poutine n'a été inquiété.
Alors que les renationalisations gagnent du terrain, la rhétorique économique a changé pour devenir étatique.
Poutine défend maintenant le protectionnisme, l'intervention de l'Etat et les subventions.
Il est peu probable de voir des réformes structurelles engagées dans ce climat.
Jusqu'à il y a peu, la Russie poursuivait une politique macroéconomique conservatrice admirable, avec un énorme budget et un compte courant excédentaire.
Cela a permis de rembourser la dette étrangère et de constituer des réserves en devise à hauteur de 450 milliards de dollars.
Avant l'élection de la Douma, Poutine avait cependant déjà ébranlé ce dernier vestige d'une politique économique responsable.
Actuellement, la première préoccupation économique de la Russie est la pression exercée par une inflation croissante, due notamment à la hausse des prix dans le secteur alimentaire.
Cette hausse est un phénomène au niveau international, mais l'inflation russe est dopée par l'importance de l'excédent des comptes courants et l'afflux de capitaux.
Or le gouvernement russe ne cherche plus à atténuer ces facteurs et poursuit une politique inflationniste.
Il n'est donc pas étonnant que l'inflation ait fait un bond 7% au printemps dernier à 11% aujourd'hui, pour atteindre peut-être 15% au printemps.
La politique monétaire et fiscale doit donc être resserrée, mais cela risque d'être difficile autant que Poutine cherche à apaiser la population.
Il pourrait libéraliser le taux de change en le laissant flotter à la hausse, mais il ne fait même pas cela.
A la place, il a recours à une vieille tactique soviétique, le contrôle informel des prix, qui ne peut durer longtemps dans le cadre d'une économie privatisée.
La Russie poursuit sa croissance sur la lancée grâce à la libéralisation économique des années 1990 lors du premier mandat de Poutine, et au prix élevé du pétrole et du gaz.
Reste donc à savoir à quelle vitesse l'économie va sombrer lors du troisième mandat de Poutine.
Le dernier combat de Poutine
A Bucarest, deux questions prioritaires seront posées : faut-il inviter l'Albanie, la Croatie et la Macédoine à rejoindre l'OTAN ? Et faut-il proposer à l'Ukraine et à la Géorgie de lancer des « plans d'action pour l'adhésion » ?
Il importe que ces points soient traités par les membres de l'OTAN et non par des tiers.
En  février 2007, à Munich, Poutine déclarait dans une tirade antioccidentale : « Je pense qu'il est évident que l'expansion de l'OTAN n'a rien à voir avec la modernisation de l'Alliance elle-même ou avec la sécurité de l'Europe. Au contraire, elle représente une provocation sérieuse qui réduit le niveau de la confiance mutuelleJe pense qu'il est évident que l'expansion de l'OTAN n'a rien à voir avec la modernisation de l'Alliance elle-même ou avec la sécurité de l'Europe.
Au contraire, elle représente une provocation sérieuse qui réduit le niveau de la confiance mutuelle il me paraît évident que l'expansion de l'OTAN n'a aucun lien avec la modernisation de l'Alliance elle-même ni avec la sécurité en Europe. Au contraire, elle représente une grave provocation qui réduit le niveau de confiance mutuelle »
L'avis de Poutine sur l'OTAN est donc clair.
Il scandalisera le sommet en voulant intimider les anciens soviétiques présents dans l'assemblée.
Cette attitude agressive ne profite à la politique étrangère d'un pays que jusqu'à un certain point -- dépassé par Poutine il y a bien longtemps.
Au départ, le président russe jouait le rôle de diplomate et de conciliateur compétent, mais depuis son intervention à Munich, il unit l'Occident contre la Russie.
Dans son discours du 9 mai 2007, commémorant la victoire de la Russie durant la Première Guerre mondiale, Poutine comparait les Etats-Unis à l'Allemagne nazie : « Il faut rechercher les causes de toute guerre avant tout dans les erreurs du temps de paix et leurs racines dans l'idéologie de la confrontation et de l'extrémisme.
Il est encore plus important de se souvenir de cela aujourd'hui car ces menaces ne diminuent pas. Elles ne font que se transformer, changer de visage.
Et dans ces nouvelles menaces, comme à l'époque du Troisième Reich, il y a toujours le mépris de la vie humaine et les prétentions à l'exception mondiale et au diktat ».
Les hommes politiques dignes de ce nom ne s'expriment pas ainsi.
Cette diatribe rappelle celles des rares fidèles qu'il reste à Poutine  -- le Vénézuelien Hugo Chavez, l'Iranien Mahmoud Ahmadinejad et le Bélarusse Alyaksandr Lukashenka.
Les Russes prennent conscience qu'en insultant et en intimidant tout le monde, Poutine nuit à leurs intérêts.
Il isole son pays avec les autres parias du monde. Pis encore : il a réalisé peu de choses.
Au moment de sa victoire aux présidentielles, Poutine faisait de l'adhésion à l'Organisation mondiale du commerce la priorité de sa politique étrangère.
Il a échoué à force de céder à la mesquinerie des intérêts protectionnistes, en mettant l'embargo sur le bois finlandais et suédois, sur le poisson norvégien et divers embargos agricoles contre la Lituanie, l'Ukraine, la Moldova, la Georgie, etc.
La politique étrangère russe se concentre sur les intérêts de ses propres entreprises publiques, notamment de Gazprom qui a conclu des accords avec bon nombre de pays et compagnies étrangères pour un approvisionnement monopolistique.
Or, un pipeline Gazprom coûte généralement trois fois plus cher au kilomètre qu'un pipeline similaire occidental, compte tenu des « fuites » (pots-de-vin et pertes).
La politique étrangère russe a-t-elle pour objectif central d'extorquer les compagnies publiques russes au profit des responsables du Kremlin ?
Toutefois, les consommateurs n'ont pas confiance dans les fournisseurs qui coupent l'approvisionnement, augmentent leurs tarifs sans prévenir, exproprient leurs concurrents et laissent la production diminuer, comme ce fut le cas de Gazprom et d'autres entreprises publiques russes.
Les exportations de gaz vers l'Europe ont donc entamé une baisse.
Par ailleurs, il est évident que la politique étrangère de Poutine vise à stimuler le chauvinisme populiste.
En condamnant les étrangers, elle peut certes donner un coup de fouet au pouvoir autoritaire russe, mais elle aussi a un prix.
Les Etats-Unis et l'Europe, ainsi que les anciennes républiques soviétiques se sentent bien loin des tactiques agressives de Poutine.
La plupart veulent se protéger des embargos capricieux de la Russie -- par exemple, en cherchant d'autres sources d'approvisionnement énergétique.
Certes, la Russie a amélioré ses relations avec la Chine sous Poutine. Pour cela, il a fallu répondre aux demandes chinoises concernant deux grandes îles contestées pour lesquelles les deux pays se sont battus en 1969.
Le but apparent de Poutine était de garantir des fonds pour que Rosneft acquière le champ pétrolifère de Yugansk, qui faisait partie de la confiscation des actifs de Yukos.
Malgré tout, la Chine est elle aussi lasse de Poutine et envoie de puissants signaux aux dirigeants des anciennes républiques soviétiques, notamment à l'Ukrainienne Yuliya Tymoshenko.
Les nationalistes russes sont eux aussi indignés par la politique étrangère de Poutine, qui a éloigné les anciennes républiques soviétiques et affaibli les militaires russes.
Le Conseil de stratégie nationale, par nature nationaliste, a publié un rapport dévastateur sur la décadence de l'armée russe sous Poutine : les acquisitions de matériel militaire auraient chuté (par exemple, seulement trois aéronefs militaires en 2000).
Il est vrai que les coûts de l'armement ont nettement augmenté, mais seulement parce que les amis de Poutine au KGB, qui monopolisent la production d'armes, ont volé des quantité démesurées de matériel.
Malgré l'insuffisance de dépenses, Poutine semble obsédé par les gestes vains et provocateurs, comme la reprise des vols long-courriers de bombardiers au large des côtes américaines.
Au début des années 90, bon nombre d'Occidentaux et de Russes voulaient faire de la Russie un membre à part entière de l'Union européenne et de l'OTAN, à condition qu'elle devienne une véritable démocratie.
Malheureusement, l'Occident n'a jamais fait cette offre, et la démocratie s'est détournée du droit chemin.
Il faudrait donner une nouvelle chance à la Russie, mais seulement après le départ de Poutine.
L'ennemi de l'Occident n'est pas la Russie : c'est Vladimir Poutine.
L'Ukraine s'accroche au dollar
Les prix ont commencé a échappé à tout contrôle lorsque Ioulia Tymoshenko a été renommée Premier Ministre en décembre dernier.
Des observateurs malveillants ont laissé entendre qu'elle était à l'origine de dépenses sociales populistes -- ce qui est faux.
En fait, son gouvernement a resserré le budget juste avant le nouvel an.
Selon Viktor Pynzenyk, Ministre des Finances, l'État avait un excédent budgétaire de 0,6 % du PIB au premier trimestre 2008.
Cette situation n'est pas surprenante car les recettes publiques augmentent avec la hausse du coût de la vie, tandis que les dépenses sont généralement fixes.
En réalité, le gouvernement de Ioulia Tymoshenko a fait du bon travail sur le plan budgétaire.
Dans l'ensemble, les finances publiques se portent bien, avec une dette publique représentant 11 % du PIB.
D'après la Banque nationale d'Ukraine, les réserves internationales ont une croissance constante et s'élèvent désormais à 33 milliards de dollars.
La véritable cause de l'inflation ukrainienne est que le cours de sa devise, le hryvnia, est indexé sur le dollar américain.
Lorsque la valeur du dollar baisse, comme c'est le cas actuellement, l'économie très ouverte de l'Ukraine importe aussi l'inflation.
L'année dernière, le dollar a chuté de 12 % face à l'euro -- monnaie plus importante que le dollar pour le commerce extérieur du pays.
Le Fonds monétaire européen n'a cessé d'avertir l'Ukraine que son indexation sur le dollar provoquerait une crise financière compte tenu d'une sur- ou d'une sous-évaluation ; et lui demande depuis des années de libérer son taux d'échange.
Mais la Banque nationale d'Ukraine fait la sourde oreille : elle est donc le dernier pays d'Europe centrale et orientale à avoir une parité fixe avec le dollar.
Les puissants industriels ukrainiens ont fait l'éloge de la politique de faibles taux de change de la Banque nationale, pensant qu'elle rendait le pays plus compétitif.
Ils ignorent que la Banque ne peut contrôler l'appréciation nominale de la hryvnia.
En effet, les cours sont fixés par la réévaluation réelle, qui est la somme des variations du taux de change et de l'inflation.
De plus, l'ancrage au dollar a contraint la Banque nationale à poursuivre une politique monétaire laxiste.
Le taux actuel de refinancement en Ukraine est de 16 % par an, soit 10 % de moins que l'inflation, ce qui signifie que le pays a un taux d'intérêt réel négatif de 10 % par an.
Par conséquent, les disponibilités quasi monétaires ont explosé de 52 % l'année dernière -- l'inflation est en bien partie pour atteindre prochainement les 30 %.
Les dirigeants de la Banque nationale savent qu'ils doivent agir pour contenir l'inflation ; or, ils ont les mains liées par leur obstination à vouloir s'indexer sur le dollar, qui les empêche d'augmenter suffisamment les taux d'intérêt.
Ils sont revenus à des réserves obligatoires strictes par le resserrement des crédits, par conséquent, à une raréfaction des crédits internes en pleine crise financière internationale. Cette situation conduira probablement certaines banques de taille moyenne à la faillite en raison de problèmes de liquidité.
Le resserrement est toujours pire que le pire des marchés.
Pourquoi la Banque nationale ukrainienne persiste-t-elle à pratiquer cette politique néfaste ?
Si l'incompétence est l'une des explications, la politique est certainement la cause déterminante.
La Banque est subordonnée au Président Victor Ioushchenko, qui, même s'il a nommé Ioula Tymoshenko Premier Ministre, semble plus soucieux de lui nuire sur le plan politique que de juguler l'inflation.
Les défaillances de la politique de la Banque nationale sont si évidentes qu'elle sera bien obligée de libérer le taux de change, excepté qu'il sera peut-être trop tard.
Même au beau milieu d'une crise inflationniste, elle veut avancer à petits pas -- manifestement, elle n'a pas saisi la gravité de la crise.
La Banque devrait annoncer qu'elle n'a plus de taux de change cible et qu'elle cessera d'intervenir en n'achetant plus de dollars sur le marché des changes.
Si la Banque nationale laisse flotter les taux d'intérêt, il n'est pas exclu que les Ukrainiens échangent des milliards de dollars en hryvnia et provoquent une hausse de son taux d'échange.
Cette situation permettrait de contenir l'inflation puisque la Banque pourrait alors limiter la masse monétaire par des taux d'intérêts plus élevés que par le resserrement.
Le temps est compté.
Selon Rudi Dornbusch, brillant économiste, les crises financières débutent généralement plus tard que prévu, mais se développent plus rapidement qu'on l'imagine.
L'Ukraine est au bord du gouffre financier.
Ioushchenko et la Banque nationale ukrainienne peuvent encore agir. S'ils ne s'y prennent pas immédiatement, une crise financière coûteuse et inutile risque d'éclater.
En tant que Premier Ministre, Ioushchenko a sauvé son pays d'une crise financière au début de l'année 2000.
Il ne doit pas sacrifier le bien-être de l'Ukraine pour ses ambitions politiques.
Le retour des siloviki
La déclaration de Poutine est totalement inattendue.
Deux jours plus tôt, Ron Kirk, représentant américain au Commerce, et Catherine Ashton, commissaire au commerce de l'Union européenne achevaient des négociations fructueuses sur l'adhésion de la Russie à l'OMC avec Igor Shuvalov, premier adjoint de Poutine, Alexei Kudrin, ministre des Finances, et Elvira Nabiullina, ministre du développement économique.
Le 3 juin dernier, Poutine affirmait être certain que la Russie « rejoindrait vite l'OMC ».
Les dirigeants du Bélarus et du Kazakhstan semble tout aussi surpris par la déclaration de Poutine, en particulier puisque la Russie vient tout juste d'interdire la quasi-totalité des importations de produits laitiers du Bélarus, dans une manoeuvre protectionniste.
Après 16 années de négociations, la Russie semblait prête à rejoindre l'OMC dans les deux mois qui suivaient.
En fait, il ne restait plus qu'à franchir trois obstacles difficiles.
Tout d'abord, l'Ukraine demandait un protocole bilatéral sur l'accès au marché, qui aurait contraint la Russie à lever une centaine de sanctions commerciales, principalement en agriculture.
Le deuxième obstacle, essentiellement politique, concerne les contrôles de la frontière avec la Géorgie : soit l'Abkhazie et l'Ossétie du Sud sont indépendantes, comme le maintient la Russie, soit elles font partie de la Géorgie, comme le pense le reste du monde.
Enfin, l'Union européenne insiste pour que la Russie abandonne les tarifs d'exportation prohibitifs prévus pour le bois de sciage.
Seule la question géorgienne est réellement sérieuse.
L'union douanière avec le Bélarus et le Kazakhstan ne saurait être une alternative à l'adhésion de la Russie à l'OMC.
D'une part, aucun pays n'est jamais entré à l'OMC à titre collectif, d'autre part, cela n'est pas possible d'un point de vue légal selon Pascal Lamy, directeur général de l'OMC.
De plus, l'union douanière a été proclamée en 1995 et ne peut se former qu'en juillet 2011 au plus tôt, ce qui est peu probable.
Avant tout exportatrice de matières premières, la Russie a moins besoin de l'OMC qu'un pays fabricant comme la Chine.
Quand bien même, 1/5 des exportations russes se compose de métal et de produits chimiques vulnérables aux mesures antidumping.
Selon les estimations d'une série d'études de la Banque mondiale et de la Russie, la croissance économique du pays pourrait gagner un demi point à un point de pourcentage d'ici cinq ans en rejoignant l'OMC.
En outre, l'adhésion à l'OMC est importante pour la position internationale de la Russie.
C'est le seul pays du G20 non membre de l'OMC, qui représente 96 % du commerce mondial.
L'OMC est de plus un choix de stratégie économique et politique.
Avant de quitter la présidence en mai 2008, Poutine présentait son programme « Russie 2020 ».
Une « stratégie d'innovation » était au cœur de ce programme, basée sur davantage de réformes de marché et d'investissements en capital humain, devant conduire à une croissance annuelle de 6-7 %.
Dans leurs discours, le président Dmitri Medvedev et ses technocrates embrassent cette doctrine.
Or, Poutine et ses siloviki (alliés politiques dont le pouvoir se fonde dans le dispositif sécuritaire) semblent finalement préférer une « stratégie d'inertie », le pire des scénarios de Russie 2020.
Cette stratégie de capitalisme d'État revient à vivre sur les richesses énergétiques nationales et à ne rien faire pour combattre les énormes problèmes de corruption et de bureaucratie du pays.
En revenant sur les décisions relatives à l'OMC, Poutine a montré une fois de plus qu'il était maître de la Russie.
Il a fait de même l'été dernier en s'en prenant violemment au grand groupe sidérurgique Mechel et en provoquant la guerre en Géorgie.
L'hiver dernier, les mauvais choix politiques de Poutine face à la crise financière ont sapé son autorité.
Au lieu de protéger les entreprises privées russes, il a manigancé un gel des liquidités au niveau national, qui a entraîné une chute du PIB de 9,5 % au premier trimestre 2009 et ce, malgré les énormes réserves étrangères de la Russie.
Les technocrates pragmatiques ont pris la relève, mais les prix du pétrole ayant doublé -- ce qui signifie que pour l'heure l'économie russe n'est plus en danger  -- , les siloviki reprennent les commandes.
Quelle sera la prochaine étape ?
L'influent analyste militaire russe Pavel Felgenhauer insiste pour que le principal objectif soit d'achever la Géorgie et son président provocateur Mikheil Saakashvili, toujours au pouvoir.
La Géorgie n'a pas reçu de soutien militaire et demeure quasiment sans défense.
Poursuivant son offensive de propagande contre la Géorgie, le Kremlin s'est opposé au prolongement de la mission des observateurs des Nations Unies en Géorgie et en Abkhazie. « Caucase 2009 », grande opération militaire russe, est en cours.
L'invasion de la Géorgie a fait suite à la dernière opération de ce type, « Caucase 2008 ».
Durant la dernière phase de cette opération, du 6 au 8 juillet, le président américain Barack Obama est censé rencontrer le président Medvedev à Moscou.
Medvedev espère manifestement étendre et améliorer le rôle de la Russie et son propre rôle dans le monde.
De leur côté, les siloviki préfèrent être solidement installés au pouvoir, dans une Russie isolée et autoritaire.
Le Kremlin veut un nouvel accord stratégique de contrôle des armes, alors que les siloviki ne souhaitent rien de plus.
Le gouvernement Obama espérait voir aboutir les négociations de la Russie à l'OMC, mais les manœuvres de Poutine ont éliminé les chances d'un tel résultat.
Les États-Unis souhaitent également faire progresser l'intégrité territoriale des anciens États soviétiques, comme la Géorgie, mais cela est tout aussi improbable.
Poutine et ses collaborateurs semblent tout mettre en oeuvre pour faire échouer Medvedev, ce qui porte à croire que leur jalousie du pouvoir limité de Medvedev est plus forte que leur volonté de défendre des intérêts nationaux de la Russie.
Malgré tout, il reste un espoir pour que Poutine soit confronté à suffisamment de réactions négatives pour changer de position sur l'adhésion à l'OMC.
Après tout, c'est lui qui a suspendu les négociations après la guerre d'août 2008 en Géorgie, pour les reprendre au printemps suivant.
Occidentaliser la région de la mer Noire
La conclusion sanglante de la prise d'otages dans une école en Ossétie du nord et les récents affrontements en Géorgie entre les troupes du gouvernement et les forces séparatistes ont une fois encore amené la région troublée de la mer Noire à la une des journaux.
Cette violence grandissante tire la sonnette d'alarme pour l'Occident, mettant en exergue la nécessité d'une nouvelle stratégie euro-atlantique dans une région d'une importance capitale qui s'étend à la croisée de l'Europe, de l'Eurasie et du Moyen-Orient.
En effet, la région de la mer Noire représente la frontière orientale de la communauté euro-atlantique avec le Moyen-Orient étendu.
Avec l'Afghanistan, l'Irak et l'Iran en tête de la liste des défis stratégiques auxquels est confronté l'Occident, l'ancrage de la démocratie et de la sécurité dans ces nouveaux pays frontières de la communauté euro-atlantique est devenu une priorité pour les Etats-Unis et l'UE.
S'ils parviennent à une conclusion satisfaisante, ils seraient ainsi à même de faciliter le processus intimidant de réforme et de modernisation dans le Moyen-Orient étendu.
La " Révolution rose " de Géorgie en hiver dernier a démontré que la volonté de mettre en place une réforme radicale est désormais présente.
Pour la première fois, un pays de la région associe ses aspirations avec les étapes concrètes nécessaires pour devenir un candidat viable pour une éventuelle adhésion dans les institutions euro-atlantiques.
Les touristes se rendant dans la capitale de la Géorgie, Tbilisi, peuvent désormais y voir le même niveau de détermination à rejoindre l'Occident que celui qui existait une décennie auparavant dans les pays baltes.
L'Amérique et l'Europe ont un intérêt commun dans la réussite de ces efforts car elles cherchent à diversifier les approvisionnements énergétiques en plus du pétrole provenant d'Arabie Saoudite et du golfe Persique.
La mer Noire est prête à devenir une conduite essentielle pour le pétrole et le gaz naturel ne provenant pas de l'OPEC et du golfe Persique et qui alimentent les marchés européens et au-delà.
La stabilité et l'intégration à long terme de la région de la mer Noire avec l'Occident sont donc relativement importantes pour la stratégie de sécurité énergétique sur le long terme des membres de l'UE et de l'OTAN.
Ce ne sera pas chose aisée que d'ancrer ces pays dans l'Occident.
Personne ne sait si cet ancrage aura comme conséquence d'améliorer les relations ou d'intégrer complètement ces pays dans l'UE et l'OTAN.
Mais ces deux organisations doivent étendre leur portée à ces pays, un processus qui doit être considéré comme la phase suivante du processus aboutissant à la création d'une Europe étendue.
A quoi devrait ressembler la nouvelle stratégie de proximité, courageuse bien que réaliste, de l'UE et de l'OTAN pour la région de la mer Noire ?
Manifestement, les pays de la région sont plus faibles et bien moins prêts que d'anciens candidats à l'intégration occidentale.
Mais fort heureusement, l'UE et l'OTAN sont en bien meilleure position pour développer une stratégie ambitieuse qu'ils ne l'étaient vis-à-vis de l'Europe centrale et de l'est une décennie auparavant.
Si l'UE et l'OTAN décidaient de lancer une stratégie de proximité courageuse pour la région, ils seraient en mesure de tirer parti des outils, du talent conceptuel et de l'expérience pratique existants.
Par exemple, l'OTAN comprend déjà trois membres (la Bulgarie, la Roumanie et la Turquie) ayant une frontière commune avec la mer Noire.
Comme pour l'UE, les candidatures de la Roumanie et de la Bulgarie doivent avoir une conclusion positive, tout comme les aspirations de la Turquie à l'adhésion.
Une UE incluant Sofia et Bucarest, et prête à accueillir Ankara, serait bien positionnée pour étendre la région.
L'UE a également besoin de donner corps à sa nouvelle Politique de voisinage tandis que l'OTAN doit appliquer de nouveaux mécanismes destinés à renforcer les liens avec la région.
Plutôt qu'un sprint de 100 ou 200 mètres, les deux organisations doivent penser davantage en termes d'une course bien plus longue, peut-être un marathon.
Si les pays de la région adoptent l'idée, un réseau de membres actuels de l'UE et de l'OTAN pourrait avancer des projets et une assistance destinés à promouvoir une identité et une communauté de la mer Noire.
Les récents événements en Géorgie nous rappellent que la résolution des " conflits gelés " de la région, à savoir ceux qui surviennent dans les régions dissidente d'Ossétie du sud et d'Abkhazie, de Transdniestrie en Moldova, et de Nagorno-Karabakh en Azerbaïdjan, doit être une priorité.
En réalité, ces conflits ne sont pas gelés ; ils suppurent des blessures qui alimentent la corruption et le crime organisé.
Ils entravent la démocratisation et incitent à l'instabilité.
Tandis que ces conflits impliquent des griefs historiques, les acteurs extérieurs, particulièrement la Russie, contribuent à empêcher leur résolution, qui est essentielle pour la réussite des réformes.
Jusqu'à présent, ni l'Amérique ni l'Europe n'ont fait de ces conflits une priorité majeure.
La résolution de ces guerres semi-latentes requiert une implication politique intensifiée, un engagement économique et la volonté de fournir des forces et des moniteurs occidentaux de maintien de la paix si et quand ils s'avèrent nécessaires.
Mais la paix et la stabilité à long terme indispensables pour promouvoir une réforme économique et politique dans la région exigeront également un changement dans le comportement russe ou une diminution de l'influence russe.
L'expérience de la dernière décennie semble suggérer qu'une politique visant à engager profondément le Kremlin tout en protégeant les intérêts occidentaux fondamentaux pourrait constituer la meilleure solution.
Le développement d'une nouvelle stratégie euro-atlantique pour la région de la mer Noire doit commencer par la reconnaissance, par les démocraties d'Amérique du nord et d'Europe, de leur enjeu moral et politique dans le résultat.
L'introduction de la stabilité et de la sécurité dans ces pays constitue la prochaine étape logique de la construction d'une Europe " complète et libre " et de la sécurisation de la frontière orientale de la communauté euro-atlantique avec le Moyen-Orient.
Cette tâche sera aussi importante au cours de la prochaine décennie que l'intégration de l'Europe centrale et de l'est dans l'Occident dans les années 1990.
Un « New Deal vert » mondial
Loin d'accabler une économie mondiale au bout du rouleau, les investissements en faveur de l'environnement sont précisément la prescription nécessaire pour créer des emplois, remplir les livres de commande et remettre les économies de la planète sur les rails.
Les préoccupations environnementales étaient auparavant considérées comme un luxe ; aujourd'hui, elles sont incontournables, ce que certains économistes, mais de loin pas tous, ont compris.
Une proportion importante du plan de relance de 825 milliards de dollars du président Barack Obama pour les Etats-Unis est consacrée à encourager les énergies renouvelables, à rendre des millions de logement plus écologiques et à améliorer un  réseau électrique obsolète.
Il est prévu que ces investissements créent près de cinq millions d'emplois « verts », et relancent le secteur de la construction et de l'industrie d'équipement. Ils doivent également permettre aux Etats-Unis de s'atteler à la tâche non moins sérieuse qu'est la lutte contre le changement climatique et la sécurité énergétique.
La Corée du Sud, qui enregistre des pertes d'emplois pour la première fois depuis cinq ans, a également perçu le côté positif de ces temps difficiles.
Le gouvernement du président Lee Myung-Bak prévoit d'investir 38 milliards de dollars dans un projet, créateur d'emplois, d'assainissement de l'eau au moyen de construction de stations d'épuration et de l'assainissement de quatre des principaux fleuves du pays, tout en réduisant les risques naturels par l'élévation de digues.
D'autres aspects de ce programme comprennent l'aménagement de modes de transport écologiques, comme les trains à grande vitesse et des centaines de kilomètres de pistes cyclables, l'utilisation du méthane des décharges pour la production d'énergie et des investissements dans la production des véhicules hybrides.
D'autres pays, notamment la Chine, le Japon et le Royaume-Uni ont également prévu des programmes verts, créateurs d'emplois.
Ils concernent également les économies en développement en termes de création d'emplois, de lutte contre la pauvreté, et de la recherche de nouveaux débouchés à une époque où les prix des denrées de base et des exportations sont de plus en plus incertains.
En Afrique du Sud, l'initiative Working for Water lancée par le gouvernement -- et qui emploie plus de 30.000 personnes, dont des femmes, des jeunes et des handicapés -  s'appuie également sur les occasions offertes par cette époque de crise.
Le pays dépense près de 60 millions de dollars par an pour lutter contre l'infestation de plantes allogènes envahissantes qui menacent la vie sauvage indigène, les ressources en eau, les destinations touristiques importantes et les terres arables.
Cette initiative est vouée à se développer avec l'arrachage de plus de 40 millions de tonnes de plantes allogènes pour servir de combustibles pour des centrales thermiques.
Près de 500 mégawatts, ou 2 pour cent des besoins en électricité du pays, devraient ainsi être produits, avec la  création de 5000 emplois supplémentaires.
Il est donc évident que certains pays considèrent les investissements dans les infrastructures, la production d'énergie et les écosystèmes comme un pari sur l'avenir.
D'autres peuvent douter des retours sur investissement de la séquestration de carbone en forêt ou des énergies renouvelables pour les 80 pour cent d'Africains qui n'ont pas l'électricité.
D'autres ne savent peut-être simplement pas comment suivre l'exemple.
Début février, le Programme des Nations unies pour l'environnement (PNUE) organisera une réunion de certains des principaux économistes mondiaux au siège de l'Onu à New York.
Une stratégie pour un « New Deal vert » mondial, adapté aux difficultés spécifiques que rencontrent les différents pays, sera concrétisée pour aider les dirigeants mondiaux et les gouvernements à formuler des incitations fiscales qui s'attaquent aux problèmes sur plusieurs fronts.
Le nouveau « New Deal vert » mondial, l'initiative lancée par le PNUE en octobre 2008, répond au malaise économique actuel.
Allouées avec discernement, ces incitations fiscales pourraient déclencher des tendances profondes et novatrices, ouvrant la voie à une économie verte, plus durable, pour le XXIe siècle.
Les milliers de milliards de dollars mobilisés pour faire face à la crise financière actuelle, associés aux montants astronomiques que les investisseurs attendent de placer, représentent une opportunité impensable il y a 12 mois à peine : l'occasion d'adopter une direction plus efficace et intelligente en termes de ressources et qui permette de s'attaquer à tout un éventail de problèmes, des changements climatiques à la rareté des ressources naturelles, et de la pénurie d'eau potable à la disparition de biodiversité.
Injecter aveuglément les milliards de dollars prévus par les plans de relance dans des industries obsolètes et des modèles économiques épuisés serait un terrible gaspillage et hypothéquerait l'avenir de nos enfants.
Les dirigeants mondiaux doivent au contraire se saisir de cette occasion pour investir dans les innovations, promouvoir les entreprises durables et encourager de nouvelles formes d'emplois décents et à long terme.
La promesse de la nutrigénomique
Tout au long de notre vie, nous sommes exposés à un mélange complexe d'aliments.
Des processus biochimiques variés transforment ces aliments en molécules nécessaires à notre organisme et en tirent l'énergie dont nous avons besoin.
On s'aperçoit aujourd'hui que beaucoup d'ingrédients alimentaires auxquels on ne prêtait pas attention dans le passé ne sont pas sans conséquence sur notre santé.
Ainsi, le lycopène de la sauce tomate après cuisson jouerait un rôle dans la prévention du cancer de la prostate.
Chacun sait que ce que nous mangeons peut avoir des répercussions sur notre santé.
L'alimentation ne va sans doute pas nous guérir, mais un régime riche en fruits, en légumes, en céréales et en huile végétale protège contre nombre de cancers, contre les maladies cardiovasculaires et d'autres maladies associées à l'âge.
Le problème, tant pour les scientifiques que pour les consommateurs, est que l'impact varie d'une personne à l'autre.
Il faut donc chercher à comprendre comment les aliments que nous ingérons réagissent avec notre organisme, ou plus précisément avec nos gènes, pour affecter notre santé.
C'est la "nutrigénomique".
L'objectif à long terme de cette science est de comprendre comment notre organisme réagit aux aliments en utilisant ce que l'on appelle la "biologie des systèmes".
Chaque cellule de notre corps (à l'exception des globules rouges parvenus à maturité) - il y en a quelques 50.000 milliards chez un adulte - comportent dans leur noyau deux copies de molécules d'ADN qui sont enroulées l'une avec l'autre pour former 46 filaments différents appelés chromosomes.
Ils sont répartis en 22 paires dont les éléments proviennent de chacun de nos parents biologiques, plus une paire de chromosomes XY pour les hommes ou XX pour les femmes (le Y vient du père ou de la mère, tandis que le X vient toujours de la mère).
L'ADN stocke des informations qui régissent la croissance, les facultés réparatrices, le fonctionnement et la reproduction de nos cellules.
Il est constitué de deux brins (formés d'acide phosphorique et d'un sucre) reliés entre eux par des composés chimiques appelés bases.
Il y a quelques trois milliards de bases, elles sont de quatre types différents seulement, et c'est leur séquence qui constitue notre code génétique, le génome humain.
Ce code génétique se trouve dans 30.000 à 40.000 régions des chromosomes que l'on appelle les gènes.
Ce sont les gènes qui sont porteurs des caractères héréditaires, et sauf dans le cas des vrais jumeaux, leur combinaison est unique pour chaque individu.
Mais le phénotype ne dépend pas seulement du génotype.
C'est par exemple le cas du risque de rejeter une greffe ou de développer une maladie liée à l'âge.
L'ADN ne peut pas commander directement à partir du code génétique la fabrication des protéines, molécules qui jouent un rôle essentiel dans l'organisme.
L'acide ribonucléique (ARN) joue le rôle d'intermédiaire et traduit le code génétique dans un processus appelé transcription (lecture des gènes) qui aboutit à la création de protéines en trois dimensions.
Ces protéines résultent de la combinaison de 22 acides aminés essentiels (essentiels en ce sens que notre organisme ne les synthétise pas) qu'il faut trouver dans l'alimentation.
La nutrigénomique (qui associe les recherches portant sur le génome, la nutrition et la santé) est d'une telle complexité que les spécialistes en nutrition ne peuvent plus travailler seuls.
Pour progresser, il leur faut l'apport d'experts dans des domaines aussi variés que la biologie cellulaire et moléculaire, les mathématiques et les statistiques, la chimie alimentaire et les sciences sociales.
Non à la guerre des civilisations.
Il est plus juste de dire qu'il ne s'agit pas d'une nouvelle guerre.
Le terrorisme utilisé comme un instrument de la politique existe depuis longtemps au Moyen-Orient, et il n'est pas dirigé uniquement contre Israël et les Etats-Unis.
Ce sont des agents syriens qui ont assassiné en 1982 Beshir Gemayel, le président élu du Liban.
Depuis des dizaines d'années les terroristes kurdes sont actifs en Turquie, ce sont des terroristes islamistes qui ont assassiné le président Sadate en 1981 et qui ont ensuite tenté d'assassiner le président Moubarak.
Ce n'est pas un combat contre l'impérialisme occidental ou la mondialisation.
Ce n'est pas non plus une réponse à l'impasse violente dans laquelle se trouvent aujourd'hui les négociations entre Israël et les Palestiniens : certaines des actions terroristes de Oussama Ben Laden ont été perpétrées au milieu des années 1990, en pleine lune de miel entre Israéliens et Palestiniens après les accords d'Oslo en 1993.
On assiste à un phénomène bien plus profond, aussi culturel que politique et économique.
L'Islam peut tout aussi bien être une religion tolérante que triomphaliste, comme l'autre religion mondiale, le christianisme.
Mais il y a au sein de l'Islam extrémiste une faction qui considère la modernité - les idées des Lumières - comme son ennemi.
Elle voit la démocratie, l'égalité, le libéralisme politique, la séparation de l'Etat et de l'Eglise, l'égalité des sexes, la laïcité comme l'œuvre du Diable.
De la même manière que les Anabaptistes de Münster, ils se voient comme les agents de Dieu au sein d'un monde corrompu par les péchés du matérialisme et de l'incroyance.
Une vue aussi manichéenne du monde justifie le terrorisme en tant que volonté de Dieu.
Pour des gens comme Ben Laden - il semble que c'est sa version du fondamentalisme islamique qui est derrière les actes de terreur de New-York et Washington - même la monarchie d'Arabie Saoudite représente le Diable pour avoir facilité la présence américaine au Moyen-Orient.
Depuis des années le terrorisme a bénéficié de l'appui tacite de certains Etats arabes.
Quelques pays européens, pour des raisons liées à la raison d'Etat de Machiavel, ont aussi fermé les yeux lorsqu'ils ont été confrontés au terrorisme.
La Syrie, l'un des principaux Etats qui apporte son aide au terrorisme, va peut-être accéder à un siège au Conseil de Sécurité.
Mais de la même manière qu'il ne pouvait y avoir de neutralité morale face à la guerre contre le nazisme et le fascisme, la coalition que les Américains essayent de construire aujourd'hui sera basée sur l'idée que si la guerre contre le terrorisme doit être prise au sérieux, la tolérance vis à vis des régimes qui le soutiennent doit cesser.
Certains terroristes agissent pour des causes légitimes et leurs demandes sont justifiées (les Kurdes et les Palestiniens par exemple).
Mais la fin ne justifie pas les moyens.
Le terrorisme des années 1970 et 1980 (détournements d'avion, meurtre des athlètes israéliens aux Jeux olympiques de Munich en 1972) a donné naissance aux attentats kamikazes d'inspiration islamiste commis par des Palestiniens et finalement au paysage d'apocalypse que l'on voit maintenant à New-York et à Washington.
La guerre qui s'annonce va être difficile.
La guerre contre l'Irak il y a dix ans et la guerre "virtuelle" menée dans le ciel du Kosovo ne peuvent servir de précédent.
Elles nous ont amené à penser pendant trop longtemps que la guerre contre le terrorisme était une affaire de police, que des enquêtes menant à des condamnations étaient le moyen de lutter contre des terroristes fanatiques, au lieu d'une lutte armée implacable et rude.
En fin de compte ces illusions se sont dissipées brutalement avec les massacres de New-York et de Washington.
Il n'y a pour l'instant aucune stratégie clairement établie pour mener cette guerre -- on en trouvera une.
Mais il serait tragique que la lutte contre la terreur se transforme en guerre des civilisations, l'Occident contre l'Islam.
La vision de l'Islam qu'ont les terroristes en est une perversion.
Mais ceux qui soutiennent le terrorisme doivent être traités avec la même sévérité que les terroristes eux-mêmes, et ils le seront probablement.
C'est à cette condition que cette guerre pour le monde des Lumières, le monde moderne qui s'étend à travers tous les océans et embrasse toutes les fois, pourra être gagnée.
Comment cibler l'Irak
Dans le débat actuel sur la politique à observer envers l'Irak, deux alternatives extrêmes sont généralement présentées : soit étendre la campagne militaire contre le terrorisme à l'Irak, soit maintenir le statut quo précaire actuel avec ce pays.
Des discussions vaines portant sur la reprise des sanctions de l'ONU constituent une autre version de la deuxième alternative - à savoir, ne rien faire.
Les deux alternatives sont dérangeantes.
Toutefois, la préparation d'une guerre au sol contre l'Irak - l'achèvement de l'histoire inachevée de la Guerre du Golfe de 1991 - compose une stratégie à haut risque.
Les pays arabes, alliés déjà douteux dans la guerre contre leurs homologues musulmans en Afghanistan, seront encore moins dignes de confiance dans une guerre contre leurs homologues arabes.
Les Européens, sans parler des Russes, peuvent être modestes.
Les chances militaires apparaissent intimidantes.
Néanmoins, laisser le présent statut quo continuer est également problématique.
Cela signifie que le peuple iraquien continuera à souffrir - à la fois des brutalités de Saddam ainsi que des conséquences des sanctions découlant de son autorité continue.
Cette situation continuera en outre à envoyer le mauvais message aux futurs terroristes : tout vous sera pardonné.
La faiblesse perçue des USA après les bombardements de l'ambassade en Afrique Orientale et l'attaque lancée sur le destroyer USS Cole ont sans aucun doute contribué à l'audace des attaques du 11 septembre.
D'autres options existent toutefois et ces options combinées pourraient contribuer à renverser Saddam sans nécessairement conduire à une action militaire pure.
Tout d'abord, les forces locales opposées à Saddam doivent être encouragées.
Par ceci, je n'entends pas la soi-disant opposition iraquienne totalement inefficace et vantarde.
Les forces locales à encourager - encourager par des personnes des opérations spéciales et la fourniture d'armes et d'entraînements - sont les chefs des Shi'a du sud et des Kurdes du nord.
Pour ces derniers, l'infrastructure de soutien existe déjà, bien qu'elle ait été partiellement démantelée pendant l'administration Clinton.
Dans le sud des Shi'a, qui ne s'est pas encore remis de la brutale suppression de la funeste rébellion de 1991, des contacts doivent être créés et des réseaux doivent être établis.
Les voisins de l'Irak - l'Arabie Saoudite au sud et la Turquie au nord - doivent être rassurés sur le fait que la rébellion Shi'a et kurde n'entraînera pas le démantèlement de l'Irak et la modification des frontières : les deux pays ont des préoccupations légitimes sur cette question.
Avec l'actuel régime bien plus ouvert à Téhéran, Riyadh peut également être convaincu que les dangers émanant d'une entité Shi'a contrôlée par les Iraniens en Irak du sud sont moins terribles maintenant qu'ils ne l'étaient en 1991.
D'un autre côté, les relations intimes qui existent désormais entre la Jordanie et Saddam doivent être traitées, en apportant toute la sensibilité aux dilemmes de la Jordanie.
L'élite politico-militaire iraquienne doit être à la fois ciblée et approchée.
Saddam a été magistral en attribuant les positions les plus cruciales au sein de l'armée et des services de sécurité à des individus de son clan Tikriti.
Mais ces derniers sont loin de constituer un groupe monolithique : l'inimitié, la jalousie, la colère par rapport aux brutalités et aux injustices passées infligées à plusieurs membres de leurs familles peuvent rendre certains généraux et colonels ouverts aux suggestions d'un coup d'Etat.
Ces suggestions doivent être fondées sur une approche à deux niveaux : tout d'abord, les USA, avec le soutien de l'ONU, doivent créer un tribunal pour crimes de guerre pour juger Saddam et ses principaux généraux : ils doivent savoir que jusqu'au moment de rendre des comptes, ils seront traqués comme Milosevic et ses laquais.
Une mise en examen essentielle doit traiter de l'utilisation des gaz toxiques contre les rebelles kurdes à Halabja pendant la guerre Iran/Iraq.
En parallèle à cela, et à l'encouragement des insurrections dans le sud et dans le nord de l'Irak, des préparations pour une solution militaire doivent être améliorées de façon crédible.
Mais avec le bâton doit venir une carotte : avec une certaine intelligence, certains généraux et colonels iraquiens doivent être approchés avec des offres d'amnistie et de soutien s'ils décidaient de tenter de renverser Saddam.
Ils doivent être informés en termes clairs que leur inaction les exposera (comme Saddam) à une mise en examen dans un tribunal international pour crimes de guerre, une fois l'autorité de Saddam renversée.
Ils doivent également bénéficier de l'annulation des sanctions imposées à l'Irak à condition- une fois Saddam destitué - qu'ils acceptent la reprise d'un régime d'inspection de l'ONU.
Même si cette opération ne renverse pas immédiatement le régime de Saddam, et comme l'ont montré Ceausescu et Milosevic, des dictateurs nerveux commettent des erreurs fatales.
Un principe sous-tend cette ligne de pensée : imaginer qu'il existe une alternative démocratique à Saddam ou qu'une fois disparu, il se produira une transition démocratique en Irak, revient à s'engager dans de dangereuses illusions.
La seule alternative au régime de Saddam consiste en une sorte d'autorité militaire, mais moins oppressive et relativement plus ouverte.
Elle devra certainement être engagée dans une politique étrangère et nationale non basée sur le terrorisme, la violence et une quête telle que celle de Saddam pour les armes de destruction de masse.
Voici, indubitablement, une stratégie compliquée, et qui comporte certainement ses propres embûches.
Un de ses avantages principaux réside dans le fait qu'une telle approche a réellement une chance d'obtenir le soutien, quoique parfois tacite, des pays arabes -de l'Europe et de la Russie également.
Une telle approche calibrée, qui combine toutefois une compréhension distincte de la nature du régime de Saddam et de ses faiblesses, a une plus grande chance de réussir qu'un assaut direct ou que les dangers inhérents au fait de permettre à Saddam de rester au pouvoir.
Les succès obtenus en Afghanistan appellent une approche également nuancée et sophistiquée en ce qui concerne l'Irak.
Un protectorat saoudien pour les Palestiniens
De Hosni Moubarak à Ariel Sharon, les leaders politiques du Moyen-Orient se rendent à Washington pour discuter du redémarrage du processus de paix.
Le président Bush évoque un Etat palestinien et la réforme de l'Autorité palestinienne, mais il n'a pas indiqué (jusqu'à présent) la voie pour y parvenir.
Shlomo Avineri, ancien directeur général du ministère israélien des Affaires étrangères, propose ici une nouvelle approche qui permettrait de réaliser ces deux objectifs.
Le Moyen-Orient est confronté à deux exigences contradictoires.
Les Palestiniens doivent reconstruire leur infrastructure politique presque totalement détruites par les récentes incursions israéliennes sur la rive gauche du Jourdain.
Mais il est clair qu'ils sont incapables de créer un régime qui ne soutienne pas le terrorisme et qui soit affranchi d'une idéologie qui nie violemment le droit à l'existence d'Israël.
Après la signature des accords d'Oslo il y a neuf ans, tant en Israël qu'à l'étranger, les défenseurs du processus de paix, espéraient que l'OLP - un mouvement de libération nationale fortement lié au terrorisme - se transformerait en organisation politique responsable et acceptable.
C'est à cette condition qu'un Etat palestinien souverain pourrait coexister pacifiquement avec Israël.
Si l'ANC a réussi une telle transition en Afrique du Sud, pourquoi pas les Palestiniens ?
En ce qui concerne les accords d'Oslo, l'espoir que Yasser Arafat devienne un Nelson Mandela palestinien avait même vaincu le scepticisme israélien.
Cela n'a pas été le cas.
En 2000, par son refus des propositions du président Clinton et du Premier ministre israélien Ehud Barak à Camp David et ensuite en Egypte, Arafat a manqué l'occasion historique de créer un Etat palestinien.
A la place, il a lancé l'Intifada au cours de laquelle des milices palestiniennes rivalisaient dans un déchaînement terroriste et des attaques-suicide contre des civils israéliens - et ceci pas seulement dans les territoires occupés mais aussi à Jérusalem, Tel-Aviv, Haïfa, Hadera, Afula et Netanya.
Certaines de ces milices étaient sous son contrôle direct ou agissaient avec son approbation semi-officielle, tandis que d'autres lui étaient opposées.
Leur objectif commun était d'arracher par la terreur ce qui ne pouvait être obtenu par la diplomatie.
Les territoires palestiniens se sont transformés en une zone de chaos et de désordre qui n'était pas sans rappeler le Liban des années 1970-80.
Israël ne permettra pas la reconstruction de structures terroristes à ses portes, et aucun pays au monde ne l'accepterait.
Mais il ne devrait pas être permis au gouvernement d'Ariel Sharon d'utiliser comme alibi l'échec total des Palestiniens à construire un Etat pacifique pour perpétuer l'occupation.
Mais que faudrait-il faire ?
Une force internationale fera-t-elle la chasse aux auteurs d'attentats-suicide ?
Aura-t-elle les moyens voulus en renseignement et la volonté de combattre s'il en était besoin ?
Une telle force est une dangereuse absurdité.
Les institutions palestiniennes doivent être reconstruites, mais dans un contexte qui soit légitime du point de vue arabe.
Comme le Kosovo et la Bosnie, les territoires palestiniens devraient être placés sous protectorat international.
Un protectorat saoudien sur les Palestiniens serait légitime à l'intérieur du monde arabe ; il disposerait également du savoir et des techniques utilisés dans le monde arabe en terme de sécurité.
La Palestine à la croisée des chemins
L'intervention tant attendue du président George W. Bush sur la question du Moyen-Orient est un mélange d'espoir pour chaque camp et de durcissement du discours.
L'espoir est clairement énoncé : Israël doit pouvoir assurer sa sécurité et ne plus vivre dans la crainte des attentats suicides et autres actes de terrorisme ; les Palestiniens ont droit à leur dignité, à la fin de l'occupation israélienne, à leur souveraineté et à leur État.
Mais le durcissement du discours ne s'est opéré qu'à l'encontre du leader actuel des Palestiniens : sans mentionner le nom de Yasser Arafat, M. Bush a clairement lancé un appel au renouvellement de la direction palestinienne, une direction qui « ne soit pas compromise dans les affaires de terrorisme ».
La direction actuelle, selon lui, n'a pas combattu le terrorisme, mais l'a plutôt encouragé et s'y est même « engagé ».
M. Bush a condamné le rejet par l'Autorité palestinienne des propositions de paix avancées par Israël et a promis le soutien des États-Unis envers la création d'un État palestinien si la direction change, réaffirmant ainsi que « l'État palestinien ne peut émerger du terrorisme ».
On ne peut imaginer de condamnation plus sévère pour M. Arafat et la totalité de la direction palestinienne.
M. Bush suggère aujourd'hui clairement que M. Arafat n'est pas le partenaire approprié pour la paix, que les Accords d'Oslo sont, de fait, sans avenir et qu'ainsi l'Autorité palestinienne, que ces Accords ont permis de créer, n'a plus de légitimité.
En adoptant cette politique, M. Bush se place dans une position délicate entre les pressions arabes pour soutenir la création d'un État palestinien et son propre engagement à combattre le terrorisme sans céder à la pression des attentats suicides.
Son discours est un mélange très habile de carotte et de bâton.
Mais M. Bush doit maintenant relever deux défis, l'un majeur et l'autre de moindre importance, dans la mise en place de sa politique.
Le défi majeur est de définir comment répondre aux besoins de changements à la tête de la direction palestinienne.
Ainsi, organiser des élections en Palestine aujourd'hui n'a pas plus de sens que cela n'en avait sous le régime soviétique de l'URSS.
Comment le changement démocratique peut-il s'opérer dans une telle société ?
Se fera-t-il dans le chaos et la violence de la chute d'un régime comme ce fut le cas à la chute de Nicolas Ceausescu en Roumanie ?
Ou bien peut-on espérer que les Palestiniens déposent leur régime autocratique de manière pacifique, comme en Serbie, quand Slobodan Milosevic fut renversé ?
On ne peut rejeter aucune de ces deux possibilités.
Le président Bush a également mentionné les soutiens arabes dans la réalisation d'un changement à la tête des Palestiniens.
Pense-t-il à un protectorat saoudien à la tête des Palestiniens, sous l'égide de la Ligue arabe ?
Ce n'est peut-être pas une mauvaise idée.
Mais jusqu'à présent, du moins, les Palestiniens n'ont pas vraiment réussi à mettre en place des institutions qui ne se rattachent pas au terrorisme.
Et la question centrale reste de savoir comment les mettre en oeuvre, question à laquelle M. Bush doit encore apporter une réponse claire.
Le second défi est d'obtenir le soutien des Européens envers la politique de M. Bush.
Certains Européens considèrent l'approche de M. Bush comme un exemple supplémentaire de l'unilatéralisme américain, et ils ont en quelque sorte raison.
Et quand bien même ?
Le problème que présente les Européens vient de ce qu'ils se limitent à des déclarations et des discours, sans plus : une politique régionale riche de rhétorique enlevée mais peu à même, si ce n'est incapable, de mettre en place quoi que ce soit de tangible.
La feuille de route au risque de l'enlisement
Le récent élan qu'a donné le président George W. Bush à la "feuille de route" destinée à résoudre israélo-palestinien est bienvenu et son acceptation par les deux parties est de bon augure.
Mais les chances qu'elle ouvre la voie à une véritable réconciliation restent faibles.
Il y a plusieurs raisons à cela, la première étant que cette "feuille de route" n'est guère plus qu'une liste de voeux pieux de ce qu'il y faudrait faire pour aboutir à la paix entre Israël et les Palestiniens.
Ses objectifs sont nobles, mais son contenu est souvent éloigné de la réalité politique de la région.
Ainsi, la feuille de route reconnaît à juste titre que le conflit ne peut être résolu sans tenir compte de la situation sur le terrain.
Mais le "quartet" à l'origine de cette feuille de route (les USA, l'UE, la Russie et l'ONU) sait qu'il ne pourra pas convaincre Israël de faire ces concessions sans un changement radical de l'attitude du monde arabe quant à l'existence de l'Etat juif.
Pour cette raison, la feuille de route pose la normalisation des relations israélo-arabes en prémisse à la paix entre Israël et les Palestiniens.
Pourra-t-on y parvenir dans un futur prévisible ?
Est-ce que les USA - ou sur ce sujet le "quartet" - croit vraiment qu'il pourra convaincre la Syrie et la Libye de renoncer à leur attitude rigide et menaçante vis-à-vis de l'existence d'Israël ?
Dans la feuille de route ce n'est là qu'un souhait, ses concepteurs ne proposant rien pour y parvenir.
De la même manière, la feuille de route est une tentative pour relancer les accords d'Oslo signés en 1993 entre Israël et l'OLP.
Mais ces accords ne sont pas appliqués parce que Yasser Arafat a rejeté les propositions de paix du Premier ministre Ehud Barak présentées en décembre 2000 à camp David avec le soutien du président Clinton.
Cela a été un tournant décisif pour le Moyen-Orient, un changement pour le pire.
La rupture des négociations par les Palestiniens et leur refus d'accepter l'offre israélienne la plus généreuse et de plus grande ampleur faite depuis 1967 en échange d'un accord mettant fin au conflit montrait qu'ils n'étaient pas prêts à reconnaître la légitimité d'Israël.
Il y a aujourd'hui des deux cotés beaucoup plus de ressentiment, de peur et de haine que lors de l'échec des négociations de Camp David en 2000.
Le soutien direct et indirect donné par l'Autorité palestinienne aux attaques kamikazes contre les civils a laissé penser aux Israéliens que les Palestiniens considéraient toujours le terrorisme comme une arme légitime.
Les réactions parfois brutales d'Israël ont alimenté l'animosité des Palestiniens.
La mise sur la touche d'Arafat et la nomination d'Abou Mazen comme Premier ministre palestinien constituent des pas importants dans la bonne direction.
Mais les véritables pouvoirs d'Abou Mazen n'ont pas encore passé l'épreuve du feu.
Contrôle-t-il vraiment le financement opaque de l'OLP qui a contribué à élargir le pouvoir réel d'Arafat bien au-delà de celui qui lui est dévolu formellement au titre de chef de l'Autorité palestinienne ?
Abou Mazen a-t-il la volonté politique et les moyens de venir à bout - par des mesures brutales s'il le faut - des gangs terroristes qui contrôlent une grande partie de la population palestinienne ?
Beaucoup dépend de la réponse à ces questions.
Enfin, comme le reconnaissent ses concepteurs, l'application de la feuille de route prendra plusieurs années, sans doute entre deux et quatre ans.
Il y faudra un suivi constant des douze points de désaccord, ceci au plus haut niveau, celui du président américain.
Son autorité est considérable, mais le président Bush ou son successeur pourra-t-il jour après jour, pendant deux ou trois ans, s'assurer effectivement que les parties traduisent par des décisions difficiles, voire politiquement dangereuses, ce qui ne sera sans doute que l'acceptation verbale de propositions vagues ?
L'expérience du passé n'est pas encourageante.
L'attention qu'un président américain peut apporter à un problème donné connaît des limites.
Mais sans sa vigilance de tous les instants, la feuille de route s'ensablera dans les dunes du Moyen-Orient, comme tant de plans de paix avant elle.
Dans ces conditions, qu'est-il possible de réaliser ?
Peut-être comme en Bosnie et au Kosovo - personne n'y parle aujourd'hui d'une solution permanente, mais la violence a cessé - il faudrait stabiliser la situation, mettre fin du bain de sang quotidien, entamer une désescalade de la violence et établir un minimum de confiance mutuelle.
Israéliens et Palestiniens ne sont pas encore prêts à adopter les changements politiques radicaux que prévoit la feuille de route.
Ils ont besoin de passer par des étapes qui permettraient d'assurer la stabilité et de garantir la sécurité des populations civiles des deux bords.
Si la désescalade a lieu, peut-être une véritable réconciliation sera-t-elle possible ultérieurement.
C'est sans doute difficile à admettre, mais le moment n'est pas encore venu pour s'engager au-delà.
Réfugiés palestiniens et expulsés allemands
L'atmosphère ne pouvait pas être plus tranquille : un ancien château royal dans les collines de la région de Taunus près de Frankfort, où hommes d'État et politiciens tenaient leur meeting annuel sur la question du Moyen-Orient.
Des Européens et des Américains, des Israéliens et des Iraniens, des Égyptiens et des Turcs, des Palestiniens et des Tunisiens se sont côtoyés.
La nouveauté cette année venait de la présence de représentants de l'Irak de l'après-Saddam, dont des officiels du gouvernement régional kurde ainsi qu'un haut représentant Shya.
La nouvelle situation en Irak, ainsi que la feuille de route pour la paix au Moyen-Orient, était le centre de toutes les discussions.
Lors du gala d'ouverture, un ministre allemand de poids, lui-même très impliqué dans les questions du Moyen-Orient, a examiné ces deux sujets en montrant une grande sensibilité envers les inquiétudes israéliennes et palestiniennes.
La soirée s'est déroulée comme prévu jusqu'à ce qu'un intellectuel libanais soulève la question du droit des réfugiés palestiniens à rentrer en Israël.
Le ministre allemand a écouté attentivement avant de s'exprimer : « c'est une question qui nous est familière, à nous les Allemands. Puis-je demander à mes collègues allemands de l'assemblée de lever la main s'ils sont, eux ou leur famille, réfugiés d'Europe de l'Est ? »
Il y eu un moment de silence.
La question est embarrassante en Allemagne, accablée par ses mines politiques et morales.
Peu à peu, les mains se sont levées : selon moi, plus de la moitié de l'assemblée d'Allemands présents (hommes du gouvernement, journalistes, hommes d'affaire) leva la main. Leur famille ou eux-mêmes sont des Vertrieben --expulsés de leur maison ancestrale en Pologne, en Tchécoslovaquie, en Hongrie et en Yougoslavie après la Deuxième guerre mondiale.
On estime à 10 millions le nombre d'expulsés, et avec leur descendance, ils forment aujourd'hui un nombre deux fois plus important : près de 25% des Allemands.
Dans la pièce silencieuse, le ministre allemand poursuivit : lui-même est né en Europe de l'Est, et sa famille fut expulsée dans l'atmosphère anti-allemande de l'après 1945. « Mais », ajouta-t-il, « ni moi ni aucun de mes collègues avons jamais réclamé le droit de rentrer.
Et c'est précisément grâce à cela que je peux aujourd'hui rendre visite aux habitants de la maison ancestrale où je suis né--parce qu'ils ne se sentent aucunement menacés et savent que je ne tiens pas à les chasser ni à prendre leur maison. »
Le ministre expliqua alors que la paix qui existe aujourd'hui en Europe est au coeur de cette réalisation : si les pays d'Europe de l'Est avaient craint que des millions d'Allemands reviennent, « le Rideau de fer ne serait jamais tombé.»
Ce fut une réponse très chargée d'émotions qui fut faite à la question d'un universitaire libanais--une réponse que les représentants arabes ont choisi plus tard d'ignorer.
Pourtant c'était là une expression de plus du contexte dans lequel la question des 1948 réfugiés palestiniens doit être examinée.
Comme le rappelait le ministre allemand à son public, les parallèles sont nombreux dans l'histoire récente de la question des réfugiés palestiniens.
Toute personne qui soutient aujourd'hui que les 1948 réfugiés palestiniens ont le droit, par principe, de rentrer en Israël doit aussi répondre à la question suivante : les Allemands expulsés d'Europe de l'Est après 1945 ont-ils aussi les mêmes droits de retour dans leur maison perdue ?
Le ministre allemand nous a donné une réponse.
Ainsi, si le gouvernement d'Helmut Kohl avait insisté en 1990 pour que tous les Allemands expulsés de Pologne et de Tchécoslovaquie aient le droit de rentrer dans ces pays, la réunification allemande n'aurait jamais gagné le soutien international dont elle a bénéficié.
Car il serait apparu clairement que l'Allemagne de l'ouest n'avait pas en tête la réunification mais bien le renversement des conséquences de la défaite de l'Allemagne nazie de 1945.
L'exigence palestinienne du droit au retour porte un sens analogue.
L'insistance avec laquelle cette idée fut défendue en 2000 à Camp David et à Taba montre clairement aux Israéliens que les Palestiniens ont bien en tête n'est pas de défaire les conséquences de la Guerre des six jours en 1967.
Au lieu de cela, leur exigence du droit au retour ressemble à un effort pour renverser les conséquences de leur défaite en 1948, quand le monde arabe est entré en guerre pour empêcher la naissance de la nation israélienne avant même son avènement.
Il faut garder présent à l'esprit ce qu'aujourd'hui les défenseurs du droit au retour des Palestiniens préfèrent oublier : les Palestiniens arabes et quatre pays arabes membres des Nations unies sont entrés en guerre en 1948 non seulement contre Israël, mais aussi contre la légitimité internationale et le plan des Nations unies pour une solution à deux États.
Il n'existe aucun autre exemple de pays membres des Nations unies se lançant dans la guerre pour empêcher la mise en ouvre de décisions de l'ONU.
C'est ce que les pays arabes et les Palestiniens ont fait.
Il y a évidemment la question humanitaire qu'on ne peut négliger.
Le fait que le calvaire des réfugiés fut aggravé par leur manipulation comme simples pions politiques pendant plus d'un demi-siècle, c'est là la mesure du cynisme et de l'immoralité des dirigeants politiques arabes.
Néanmoins, reste la question humanitaire.
Le vieux ministre allemand l'a évoquée de manière explicite, aussi bien pour les Palestiniens que pour les Allemands réfugiés après 1945.
Mais les conséquences politiques étaient claires pour lui : le revanchisme, qui exige le retour des réfugiés, aussi bien dans le cas allemand que dans le cas palestinien, est une formule vouée à l'instabilité voire la guerre.
Les Trois Irak
Les difficultés croissantes des États-Unis dans la mise en place d'une forme cohérente de gouvernement en Irak, sans parler d'un gouvernement démocratiquement élu, nous pousse à nous demander ce que la plupart des hommes d'État pensent incroyable : serait-il possible qu'il n'existe aucun moyen de reconstituer l'Irak en un seul État et ques des options différentes doivent être envisagées, même si cela paraît très inconfortable ?
Comme bien d'autres problèmes dans la renaissance d'États mis à mal par la dictature, l'Europe de l'est est un bon exemple de cela, les difficultés irakiennes ont des racines historiques très profondes.
Accuser les Américains et leur force est bien trop simpliste et superficiel, même si leurs erreurs sont, de fait, très nombreuses.
L'Irak fut créé dans les années 20 par les Britanniques qui occupaient la région à la suite de la désintégration de l'empire ottoman, à la fin de la Première guerre mondiale.
Leurs politiques étaient dictées par les impératifs de l'empire britannique et n'accordaient aucune attention aux souhaits, intérêts ou caractéristiques des populations locales.
Tout ce que les organisateurs de l'empire britannique accomplirent fut d'assembler trois provinces disparates de l'empire ottoman et de placer à leur direction un prince d'Hedjaz (qui fait maintenant partie de l'Arabie saoudite).
Ces trois provinces, Mossoul, Bagdad, et Bassora, avaient chacune des caractères très distincts et des structures de population très différentes.
Mossoul était à majorité kurde, avec quelques minorités assyrio-chrétiennes et turkmènes, Bagdad était principalement sunnite et Bassora principalement chiite.
Jeter des groupes aussi disparates sous un seul chapeau politique condamna le pays qu'on venait d'inventer à des décennies de répression et de querelles domestiques.
L'ancien empire ottoman régnait sur ces trois provinces, tout comme il régnait sur toutes ses possessions impériales, par des moyens autocratiques historiques.
Le défi que devait relever le nouvel État irakien fut de créer un gouvernement sans despotisme et relativement représentatif dans lequel tous les segments de la population pouvait retrouver l'expression de leur volonté politique.
Cela se révéla être une mission impossible.
Pour cette raison, l'Irak, bien avant Saddam Hussein, a toujours souffert des régimes les plus répressifs du monde arabe.
Dans un pays à majorité chiite, les sunnites, le groupe historiquement hégémonique dans tous les pays arabes, se sont toujours montrés opposés à tout processus démocratique qui risquait de remettre en cause leur loi.
Un soulèvement chiites fut brutalement réprimé dans les années 1920 (avec l'aide de la Royal Air Force).
De même, les tentatives kurdes pour gagner leur autonomie avant le Deuxième guerre mondiale furent noyer dans un bain de sang lors des massacres de dizaines de milliers de civils innocents, et même la minorité des chrétiens assyriens, qui n'avait aucune ambition politique, subit des assauts meurtriers dans les années 1930.
Dans ces conditions, la minorité sunnite régnante se sentant constamment menacée, il n'est pas surprenant que la seule tentative dans le monde arabe pour établir un régime fasciste pro-nazi se produisit en Irak au début des années 1940, sous la direction de Rachid Ali El Khailani.
Les Britanniques empêchèrent cette mésaventure, mais pas avant que des centaines de juifs de Bagdad soient assassinés dans un pogrom sauvage à l'instigation de ce bref gouvernement pro-nazi.
Le régime de Saddam fut simplement la manifestation la plus extrême du fait le plus important et cruel que sa démographie et sa géographie le condamnait à régner avec une poigne de fer.
La chute de Saddam n'y a rien changé : la violence anti-américaine n'est pas uniquement une expression de colère contre l'occupation étrangère, mais aussi de la tentative sunnite de faire avorter la mise en place d'un ordre démocratique qui la mettrait, maître de l'histoire, dans une position subordonnée.
De même, on ne peut espérer que les Kurdes du nord se soumettent volontairement à un régime dominé par les Arabes à Bagdad, et encore moins un régime chiite (la plupart des Kurdes sont sunnites).
À l'ouest, on comprend mal la profondeur des divisions sunnites/chiites.
Imaginez-vous en Europe, avant 1648, quand les protestants et les catholiques se massacraient les uns les autres avec désinvolture, et vous comprendrez immédiatement l'hostilité qui règne.
Alors, que peut-on faire ?
L'exemple de la Yougoslavie montre que les pays où ethnies et religions sont multiples et profondément déchirées par les conflits, la partition et la séparations représentent parfois le seul moyen d'assurer la stabilité et la démocratisation.
Aujourd'hui, plus personne ne doute que la Serbie et la Croatie, en dépit de leurs difficultés, ont de meilleures chances d'atteindre une plus grande stabilité démocratique que si elles se battaient encore aujourd'hui pour la maîtrise entre elles au sein du lit de Procruste qu'était l'ex-Yougoslavie.
Pas plus que la fédération n'est une alternative, puisque les termes de la fédération elle-même deviennent des pommes de discorde (comme en Bosnie ou à Chypres).
Même les Tchèques et les Slovaques, pacifiques, ont trouvé plus simple de développer leur système démocratique respectif après un divorce de velours plutôt que de rester unis au sein d'un mariage impossible.
Le moment est venu de penser l'impensable et de créer un État kurde au nord, un État arabe sunnite au centre tout autour de Bagdad et un État arabe chiite dans la région de Bassora.
Répéter des incantations sur l'intégrité territoriale, la sagesse conventionnelle des relations internationales, n'est réellement productive que tant qu'elle assure la stabilité et empêche le chaos.
Une fois de plus, comme la Yougoslavie et l'ex-Union soviétique l'ont montré, quand les conflits remplacent la stabilité, l'intégrité territoriale perd son sens stratégique et sa légitimité.
Ceci n'est pas une ordonnance universelle pour la création d'États homogènes du point de vue éthnique.
Il s'agit simplement de montrer qu'il existe des moments historiques où démocratisation et création d'une nation coïncident et que dans les sociétés profondément divisées un consensus minimum est nécessaire au succès immédiat de chaque société au même moment est difficile à mettre en place.
Tout ceci peut sembler aller à l'encontre de la sagesse conventionnelle mais qui aurait bien pu croire que l'Union soviétique puisse se désintégrer ?
Nous devons adopter un mode de réflexion novateur au sujet de la question irakienne, sinon le chaos d'aujourd'hui continuera et s'aggravera.
Un référendum pour le Kurdistan ?
L'assassinat du président du Conseil gouvernant d'Irak atteste sans détours de l'incapacité des Etats-Unis à instaurer l'ordre public minimal requis pour le transfert discipliné de pouvoir qui doit avoir lieu d'ici le 30 juin.
Tout juste deux mois auparavant, la signature d'un document constitutionnel par un groupe de représentants irakiens non élus nommés par les Etats-Unis a été proclamée comme s'il s'agissait de remettre en vigueur la convention constitutionnelle de l'Amérique signée à Philadelphie en 1787.
Mais il est désormais évident que ce document est sans valeur.
Aucune constitution imposée, pour élégante qu'elle puisse être, ne pourra être d'une aide quelconque aux forces de la coalition lorsqu'elles se trouveront confrontées au genre de désordre constaté dans des villes telles que Fallujah ou Najjaf.
Dans la région kurde de l'Irak du nord, la situation est toutefois complètement différente : au cours des dix dernières années, sous la protection de la zone de non survol des Alliés, et plus particulièrement depuis le renversement de Saddam, le gouvernement régional kurde a été en mesure d'établir et de maintenir une administration relativement disciplinée.
Elle a surmonté les différences entre les tribus et les partis et a créé un gouvernement de facto , avec un record impressionnant sur des questions de développement telles que l'éducation, l'irrigation et la construction et, surtout, sans violence.
La question est de savoir pourquoi il n'est pas souhaitable que la coalition menée par les Etats-Unis, confrontée à la débâcle dans le reste de l'Irak (arabe), organise un référendum dans la région kurde afin de demander à la population comment elle souhaiterait être dirigée.
Après tout, les Kurdes ont, selon les normes internationalement acceptées, un droit à l'autodétermination.
Historiquement, les Kurdes, qui se distinguent des Arabes de par leur langue, leur culture et leur conscience historique, n'ont jamais pu plaider leur cause devant un tribunal.
Après la Première Guerre Mondiale et la chute de l'Empire ottoman, les Alliés victorieux leur ont promis leur propre état, une promesse qui a été cyniquement rompue lorsque les intérêts impériaux britanniques et français ont pris le pas.
Depuis lors, les Kurdes ont souffert sous le règne despotique de groupes ethniques rivaux.
Il existe des obstacles évidents à l'organisation de ce référendum, essentiellement parce que les Etats-Unis ne possèdent pas de mandat pour disposer de l'Irak à leur convenance.
Mais il en va de même pour le reste de l'Irak : les Etats-Unis demandent actuellement, de façon peu convaincante, une résolution de l'ONU leur donnant mandat pour un transfert de pouvoir au gouvernement irakien légitime, mais cette autorisation n'a que très peu de chances d'aboutir, pas plus qu'il n'existe en Irak d'individu auquel l'autorité pourrait être transférée.
Pourquoi la seule région, et le seul peuple, qui dirigent un gouvernement discipliné, ne sont pas impliqués dans des assassinats, des attaques sur des mosquées et des attentats suicides à la bombe d'écoliers, devraient-ils être pénalisés ?
Autre objection, l'opposition de la Turquie et, à un degré moindre, de l'Iran et de la Syrie, à l'autodétermination des Kurdes irakiens.
Mais en termes de normes universelles de droits de l'homme, quel droit a la Turquie de dicter le développement interne d'un autre pays ?
Après tout, personne n'accepte qu'Israël s'oppose, par principe, à la création d'un état palestinien sur la Rive occidentale et Gaza.
Il devrait en être de même pour la Turquie.
Si la Turquie accorde à sa propre minorité kurde des droits culturels et langagiers supplémentaires et autorise une représentation politique kurde légitime au parlement turc, l'envie des Kurdes turcs de s'opposer à Ankara diminuerait.
Au dix-neuvième siècle, les intérêts communs des empires russes, allemands et autrichiens autoritaires ont empêché la création d'une Pologne libre : de telles alliances contre nature n'ont pas leur place au vingt-et-unième siècle.
Récemment, sous l'égide de l'ONU, un référendum sur l'avenir de la Chypre a été organisé dans les communautés grecques et turques de l'île.
Les résultats étaient paradoxaux et certainement pas du goût des personnes qui l'ont mis sur pied, mais le droit des communautés à déterminer leur avenir a été accepté.
Pourquoi ne serait-ce pas le cas au Kurdistan irakien ?
Peut-être pour calmer les craintes politiques, et les considérations du droit international, tout plébiscite dans la région kurde devrait, à l'origine, avoir un statut uniquement consultatif.
Mais il légitimerait la volonté d'un peuple longtemps opprimé et garantirait sa place au soleil.
Ce type de référendum pourrait également concentrer l'attention des Sunnites et des Chiites arabes en Irak, lorsqu'ils réaliseraient que c'est leur violence qui démantèle l'Irak.
Ils décideraient peut-être que la violence va à l'encontre du but recherché et qu'elle entraîne ses propres pénalités, et ils pourraient ainsi suivre l'exemple kurde de modération de la violence, ce qui contribuerait à réunir de nouveau l'Irak sans recourir à une répression permanente.
Si ce n'est pas le cas, tout au moins l'injustice subie par le peuple kurde depuis des générations serait, enfin, rectifiée.
L'autre révolution palestinienne
L'euphorie suscitée, pendant plus d'une semaine, par l'élection de Mahmoud Abbas à la tête de l'Autorité palestinienne était peut-être justifiée.
Mais l'heure est venue d'analyser clairement les perspectives des Palestiniens, des Israéliens, et peut-être celles du monde arabe dans son ensemble.
Il faut d'abord reconnaître que les circonstances de cette élection n'étaient pas irréprochables : le Hamas et le Djihad islamique ont boycotté le scrutin, et Marwan Barghouti, membre du Fatah comme Abbas et seul adversaire sérieux, a été persuadé sans ménagements par les dirigeants du mouvement de retirer sa candidature dans un souci d'unité.
En outre, Abbas (connu aussi sous le nom d'Abou Mazen) a obtenu le contrôle de la dizaine de milices et services de sécurité palestiniens.
Il s'est ainsi assuré la victoire, mais les démonstrations d'hommes en armes lors de ses meetings ne correspondaient pas exactement aux normes démocratiques.
Néanmoins, après des décennies sous le gouvernement autocratique de Yasser Arafat, et malgré les contraintes évidentes imposées par l'occupation israélienne, les Palestiniens ont élu un dirigeant au cours d'élections relativement libres.
Pendant des années, Arafat avait évité d'organiser des élections, requises par les règles de l'Autorité palestinienne, au prétexte que c'était impossible sous l'occupation : et pourtant - ô surprise ! - le scrutin organisé deux mois après son décès est un succès retentissant.
Bien sûr, l'élection présidentielle est l'occasion d'ouvrir de nouvelles négociations, peut-être plus concluantes, avec Israël.
Mais le vote des Palestiniens aura aussi des répercussions dans le monde arabe, car ce qui vient de se passer en Cisjordanie et à Gaza est sans précédent : Abbas peut se vanter d'avoir reçu l'investiture populaire.
Or, aucun pays arabe n'a jamais connu cela.
De fait, Abbas est aujourd'hui le seul dirigeant du monde arabe arrivé au pouvoir grâce à des élections à peu près libres.
La société palestinienne est-elle si différente des autres sociétés arabes ?
Pas vraiment, mais le scrutin se déroulait dans un contexte unique.
Premièrement, une forte pression internationale : exaspérés par la sournoiserie de l'autocrate Arafat, les Etats-Unis et l'Union européenne ont fait savoir aux Palestiniens que s'ils voulaient bénéficier d'un quelconque soutien à l'avenir, ils devraient se soumettre à un processus démocratique relativement acceptable.
Deuxièmement, la plupart des Palestiniens avaient le sentiment que leur capacité à suivre ce processus démocratique serait en elle-même une étape importante de la lutte contre Israël.
Troisièmement, en près de quatre décennies de domination israélienne, les Palestiniens n'ont pas seulement été exposés aux rigueurs de l'occupation : ils ont aussi pu observer le fonctionnement d'une démocratie libérale, avec des médias libres, un pouvoir judiciaire indépendant et un système politique pluraliste.
La dialectique de l'occupation est plus complexe qu'on ne le croit, d'un côté comme de l'autre.
Des images des élections palestiniennes ont été diffusées dans tout le monde arabe sur Al-Jazeera et d'autres chaînes de télévision.
Elles ont dû en faire réfléchir plus d'un… S'il est possible en Palestine, sous occupation israélienne, de choisir ses dirigeants, pourquoi pas au Caire ou à Damas, à Riyad ou à Alger ?
Après la jubilation et les compliments bien mérités aux Palestiniens, les dirigeants et la population du monde arabe pourraient commencer à se poser des questions difficiles.
Les Palestiniens ont montré qu'une société arabe peut avancer vers des institutions représentatives.
Pourquoi ne feraient-ils pas d'émules ?
Une bombe à retardement vient-elle d'être déposée sous le trône des potentats arabes, rois, émirs et présidents ?
Alors qu'en Irak la tentative d'importer la démocratie par la force est un échec, la situation paradoxale d'une démocratie arabe sous occupation israélienne est peut-être une menace que les dirigeants arabes n'ont pas encore bien saisie.
L'Irak à recoller
Le problème ne vient pas de la constitution, mais des stéréotypes, cela en est presque une idée fixe, visant à nous persuader que l'Irak est un État-nation moderne qui n'a besoin que des institutions politiques nécessaires à son bon fonctionnement.
C'est une erreur et les responsables politiques devraient commencer à réfléchir à d'autres voies.
L'État irakien, établi dans les années 1920 par les responsables britanniques impérialistes, avec Winston Churchill à leur tête, est un étrange pastiche fait de trois provinces disparates issues de l'ancien empire ottoman : Mosoul dans le nord, à majorité kurde, Bagdad au centre, à majorité arabe sunnite et Bassora dans le sud, à majorité arabe chiite.
Pour des raisons politiques personnelles, les Britanniques mirent au pouvoir et à la tête de tout le pays les arabes sunnites, qui n'ont jamais représenté plus de 25 % de la population, parachutant même un prince arabe sunnite hachémite pour régner sur leur création.
Depuis lors, le pays n'a pu être maintenu dans son intégrité qu'avec une poigne de fer : l'histoire de l'Irak est pleine de révoltes chiites, kurdes et même assyro-chrétiennes, qui ont toutes connu une fin sanglante aux mains de la minorité sunnite au pouvoir.
À travers toute son histoire, l'Irak moderne a toujours été l'État arabe le plus répressif.
Le règne de Saddam ne représenta que le plus brutal d'une longue ligne de régimes sunnites.
C'est l'hégémonie sunnite, et pas seulement celle du régime baassiste de Saddam, qui a été renversée par les États-Unis.
Étant donné l'histoire et la représentation démographique de l'Irak, la tentative américaine pour façonner le pays sous la forme une démocratie fonctionnelle butte sur trois écueils : la montée en puissance de la majorité chiite, le refus kurde de renoncer à leur mini-État, acquis de facto et de longue lutte dans le nord et la violente campagne sunnite pour saper un système qu'ils ne contrôlent pas.
En bref, la proposition de constitution est une tentative de quadrature du cercle.
La résistance sunnite, une guérilla et une guerre terroriste qui fut bien préparée lors de la dernière année du règne de Saddam, continuera d'essayer de renverser tout semblant d'ordre représentant la coalition de la majorité chiite et kurde actuellement au pouvoir.
Les sunnites poursuivront leurs attaques meurtrières sur les chiites, les Kurdes et la coalition militaire dirigée par les États-Unis.
Ils boycotteront probablement le référendum constitutionnel et toutes les élections qui en découleront, tout comme ils ont boycotté les élections précédentes.
Après tout, étant donnée la logique brutale de leur longue hégémonie sur l'Irak, pourquoi les sunnites considéreraient-ils de se soumettre à un processus qui se fondent sur leur statut minoritaire, particulièrement quand des régions entières du pays sont sous le contrôle de fait de l'insurrection sunnite ?
De même, pourquoi les chiites, de leur côté, se soumettraient-ils à l'hégémonie sunnite au lieu de construire leurs propres structures politiques dans le sud, sur le modèle de ce que les Kurdes ont déjà établi dans le nord ?
Soyons francs : l'Irak prend le chemin de la Yougoslavie quand elle se désintégra au début des années 1990. 
Nous avons besoin de telles normes, bien sûr.
Mais une fois que l'État se désintègre, comme ce fut le cas en Yougoslavie, aucun projet de constitution ne peut le sauver.
Les constitutions fonctionnent uniquement quand les parties en jeu ont tout intérêt à opérer dans le cadre proposé, et cela n'est visiblement pas le cas en Irak.
Il n'y a rien de sacro-saint dans la pérennisation  d'États multi-ethniques et multi-religieux si les groupes qui les constituent ne souhaitent pas vivre ensemble.
Bien au contraire, il faut apprendre les leçons de l'échec de l'Union soviétique, de la Yougoslavie et même peut-être surtout de la Tchécoslovaquie, qui négocia sa séparation sans aucune violence.
Par contraste, la Bosnie Herzégovine est un autre exemple de tentative mise en échec pour conserver un semblant d'existence à une entité multi-ethnique éclatée : cela ne marche pas, et le pays n'est tenu que par le pouvoir quasi dictatorial des Haut-représentants de la communauté internationale et la présence de troupes étrangères.
Le Hamas au pouvoir
La victoire du Hamas est, surtout et avant tout, une indication de l'échec complet des leaders palestiniens historiques à créer un corps politique.
La Palestine n'est pas encore un État mais c'est déjà un État en faillite.
Depuis les accords d'Oslo en 1993, entre Israël et l'OLP, les Palestiniens jouissent d'une autonomie de transition limitée.
Il est certain que la nouvelle Autorité palestinienne (AP) a pris le pouvoir dans des circonstances difficiles, mais quel nouveau mouvement de libération n'a pas à faire face à de sérieux défis quand il arrive finalement au pouvoir ?
L'Autorité palestinienne a eu l'occasion d mettre en place les fondations institutionnelles d'un État fonctionnel.
Mais, au lieu d'offrir à la population les infrastructures nécessaires au développement économique, à l'éducation, à l'assistance sociale, à la santé, au logement et au retour des réfugiés, l'Autorité palestinienne, sous la direction de Yasser Arafat, le leader du Fatah, a dépensé plus de 70 % de son maigre budget pour financer une douzaine de services de sécurité et de renseignement rivaux et a négligé toutes les autres sphères de l'activité économique.
Cela a créé ce qu'on appelle en arabe un État Moukhabarat (services de sécurité), très semblable à ce qui règne dans la plupart des pays arabes : l'Égypte, la Syrie, l'Arabie saoudite, dans les monarchies tout comme dans les républiques.
Le vide laissé ailleurs par l'Autorité palestinienne, notamment dans la sphère sociale, a été rempli par le Hamas.
En effet, sa popularité n'est pas seulement due à son idéologie fondamentaliste et à sa détermination à détruire Israël.
La haute estime dans laquelle les Palestiniens tiennent le Hamas vient aussi de ce que le Hamas a effectivement réalisé pour eux tandis que l'Autorité palestinienne a gaspillé ses ressources.
Ce n'est pas seulement la corruption endémique de la direction officielle qui en a détourné les Palestiniens.
Le Hamas a mis en place des écoles, des maternelles, des crèches pour les mères, des centres médicaux, des services sociaux et des programmes pour les jeunes et les femmes, tout cela en plus de certaines subventions accordées aux familles des auteurs d'attentats-suicides.
Lors des élections, le Hamas a perçu les dividendes du travail que l'Autorité palestinienne, dirigée par le Fatah, n'a pas su faire.
La question reste ouverte : le Hamas au pouvoir deviendra-t-il plus pragmatique et moins engagé dans le terrorisme ? C'est assurément une possibilité et personne ne doit préjuger des résultats.
Il n'en reste pas moins incertain, par ailleurs, que les organes existants de l'Autorité palestinienne, surtout les services de sécurité à sa disposition, En fait, aucun précédent n'existe : il n'y a jamais eu de transfert de pouvoir pacifique dans aucun des 22 États membres de la Ligue arabe.
La réponse israélienne à la victoire du Hamas se compliquera du fait des élections israéliennes elles-mêmes, qui se tiendront le 28 mars, et du fait que le pays est gouverné par un premier ministre par intérim, Ehud Olmert, du fait de l'incapacité de M. Sharon à gouverner, événement intervenu quelques semaines après son départ du Likoud et sa création d'un nouveau parti, centriste, appelé Kadima (En avant).
Malgré l'absence de M. Sharon, Kadima reste en tête des sondages d'opinion, le plus récent lui accordant 44 des 120 sièges de la Knesset par rapport aux 21 du Parti travailliste et aux 14 de ce qu'il reste du Likoud, le parti de droite.
Le succès de Kadima tient à la réussite du désengagement unilatéral de la bande de Gaza, qui est la principale nouveauté introduite par M. Sharon dans la vie politique israélienne.
Ce retrait était basé sur la conviction que le fossé qui sépare les positions des Israéliens et des Palestiniens était trop profond pour permettre des négociations censées.
De ce fait, Israël doit commencer à décider unilatéralement des futures frontières du pays tout en conservant l'espoir de négociations ultérieures.
C'est également la ligne que M. Olmert a adoptée.
Mais la victoire du Hamas suggère que le fossé entre les Israéliens et les Palestiniens se creusera encore un peu plus et que les chances d'un accord négocié seront repoussées encore plus loin dans le futur.
Cela implique que d'autres décisions unilatérales de la part des Israéliens, notamment un ensemble de retraits partiels de certaines zones choisies en Cisjordanie, restent la seule option possible.
Une gestion réaliste du conflit remplacera les espoirs utopistes de résolution du conflit.
Dans une région pleine de paradoxes, la victoire du Hamas en a peut-être créé un nouveau : habituellement, quand les extrémistes se renforcent d'un côté, cela fait le jeu des extrémistes du côté opposé, ce qui produit un effet de spiral dangereux.
Dans ce cas, cependant, la victoire du parti radical du Hamas pourrait renforcer non pas les extrémistes du Likoud, mais, de manière surprenante, les centristes plus modérés de Kadima.
On ne peut être certain d'un tel résultat, évidemment, mais c'est aujourd'hui pratiquement la meilleure conséquence que l'on puisse espérer.
Le Hamas peut-il rester au pouvoir ?
L'enlèvement d'un soldat israélien dans la bande de Gaza, ainsi que l'enlèvement suivi du meurtre d'un civil israélien de 18 ans en Cisjordanie soulèvent cette question, qui hante les relation israélo-palestiniennes depuis la victoire du Hamas aux élections législatives de janvier.
La communauté internationale, menée par le "Quartet" (les États-Unis, l'Union Européenne, les Nations Unies et la Russie), a posé trois conditions au gouvernement du Hamas pour lui permettre de prétendre à une légitimité internationale et de continuer à recevoir un soutien financier.
Le Hamas doit reconnaître le droit d'Israël à exister, cesser toute action terroriste et s'atteler à mettre en œuvre tous les accords internationaux déjà signés par l'autorité palestinienne.
Ces conditions peuvent paraître raisonnables à tout observateur extérieur.
Pour le Hamas cependant, elles semblent saper sa raison d'être [1] même .
Cette organisation n'a-t-elle pas pour but après tout la destruction d'Israël (sa charte appelle à une guerre sainte contre tous les Juifs) et l'établissement d'un État islamique dans toute la Palestine historique ?
Le Hamas considère que les Juifs (ainsi que les francs-maçons et autres viles organisations comme le Rotary International et le Lions Club) sont responsables des révolutions française et bolchevique et des deux Guerres Mondiales.
Il est donc peu surprenant que le Hamas rejette les conditions du Quartet.
Dans le même temps, le président palestinien Mahmoud Abbas (Abu Mazen), qui représente le Fatah, le perdant des législatives de janvier, a essayé en vain de trouver un terrain d'entente avec le Hamas par le biais d'un texte ambigu appelé "document des prisonniers."
Ce document était supposé servir d'acceptation implicite du droit à l'existence d'Israël.
Mais rien de tel n'apparaît dans le texte tronqué approuvé par le Hamas.
Au contraire, le texte légitime les attaques continues contre les civils israéliens en Cisjordanie, le rendant inacceptable pour Israël et pour la communauté internationale.
Mais les mots ne suffiront pas à résoudre la crise actuelle.
L'un des résultats paradoxaux de la croyance presque messianique de l'Amérique convaincue que les élections constituent la panacée pour presque tous les maux du Moyen-Orient est que le Hamas, vainqueur d'élections démocratiques, a gagné un degré de légitimité dont il n'avait jamais bénéficié auparavant.
D'un autre côté, l'histoire du Hamas et son comportement actuel indiquent clairement qu'il considère les élections comme de simples outils politiques, et qu'il se désintéresse de tout engagement envers les normes et les valeurs à la base de la démocratie.
Reviennent ici à l'esprit les régimes fascistes et communistes du passé, qui suivaient le même genre d'approche instrumentaliste de la démocratie.
En soutenant Abu Mazen dans une tentative de sape du gouvernement du Hamas, les États-Unis portent ombrage à la crédibilité de leur propre engagement envers la démocratie.
La violence actuelle peut encore aller plus loin et faire tomber le gouvernement du Hamas.
D'un autre côté, les voies diplomatiques pourraient déboucher sur la libération du soldat israélien et faire cesser les tirs de missiles Qassam depuis Gaza en Israël, occurrence quotidienne qui décrédibilise le nouveau gouvernement israélien du Premier Ministre Ehud Olmert.
Mais le problème fondamental est que, jusqu'à aujourd'hui, à chaque carrefour historique, les Palestiniens ont toujours refusé le compromis et ont par conséquent échoué à bâtir une nation.
En 1947, ils ont refusé le programme de partition de l'ONU, qui prévoyait l'établissement de deux États en Palestine britannique.
En 1993, après les accords d'Oslo, l'autorité palestinienne établie sous Yasser Arafat a pris la forme d'un régime autoritaire et militarisé de plus, très semblable à la Syrie et à l'Égypte, et n'a rien fait pour alléger les souffrances des réfugiés palestiniens.
C'est cet échec qui a porté le Hamas au pouvoir.
La crise actuelle est de toute évidence le premier test sérieux pour Olmert et ses projets de futurs retraits des territoires occupés par Israël.
Mais c'est un test encore plus crucial pour les Palestiniens : des dirigeants aussi radicaux que fanatiques les mèneront-ils cette fois encore vers une nouvelle catastrophe nationale ?
Ou vont-ils enfin se rendre compte qu'un avenir d'indépendance, de souveraineté et de dignité est possible -- mais seulement s'ils accordent aux Israéliens ce qu'ils réclament à juste titre pour eux-mêmes ?
La communauté internationale peut pousser les Palestiniens à prendre une décision.
Mais cette décision, et ses coûts moraux, reste entre les mains des seuls Palestiniens.
Pour un Liban souverain
Quand Israël s'est retiré du sud Liban en 2000, il était entendu que le gouvernement libanais imposerait de nouveau son autorité dans la zone évacuée.
Le Hezbollah, chef de file de la lutte armée contre l'occupation israélienne, devait déposer les armes et devenir une force politique représentant la communauté chiite, historiquement marginalisée par les élites maronites, sunnites et druzes.
Mais les choses ne se sont pas passées comme prévu.
Au lieu de déployer des forces armées au sud Liban, le gouvernement faible de Beyrouth a laissé agir le Hezbollah, déterminé à faire de la région une base pour les attaques contre Israël.
Pendant six ans, le Hezbollah a quasiment créé un Etat dans l'Etat : sa milice est devenue la seule force militaire présente au sud Liban, avec certains avant-postes situés à quelques mètres de la frontière avec Israël.
De temps à autre, le Hezbollah bombardait Israël, tandis que son secrétaire général, Hassan Nassrallah, se répandait en invectives terrifiantes, non seulement contre Israël et le Sionisme, mais aussi contre les Juifs en général.
La Résolution 1559 du Conseil de sécurité des Nations Unies, qui demande le désarmement de toutes les milices et l'extension du contrôle gouvernemental à l'ensemble du Liban, a été ignorée.
Après la fameuse " Révolution du Cèdre " en 2005, le Hezbollah est même entré au gouvernement, tout en maintenant sa domination et la présence militaire dans le sud.
Pour sa part Israël, encore traumatisé par le conflit libanais de 1982, ne répondait pas aux attaques du Hezbollah et espérait éviter une escalade.
Mais les situations absurdes comme celle-ci finissent généralement par exploser, et c'est ce qui s'est passé avec l'enlèvement par le Hezbollah de deux soldats israéliens en Israël.
L'existence d'un Etat dans l'Etat illégitime n'est plus tolérable.
Comme la présence de l'Onu à Srebrenica pendant la guerre en Bosnie, la FINUL a contribué à la mauvaise réputation de l'Organisation : elle n'a jamais empêché aucun terroriste d'attaquer Israël, et n'a pas non plus arrêté l'invasion israélienne du Liban en 1982.
Ce qu'il faudrait, c'est une délégation militaire chargée de faire usage de la force.
La mission consisterait à assister -- par la force si nécessaire -- le déploiement de l'armée libanaise au sud Liban, à participer au désarmement du Hezbollah, et à effectuer des patrouilles le long de la frontière entre Israël et le Liban, pour éviter toute incursion d'un côté ou de l'autre.
Dernier point, il est une anomalie peu connue : la Syrie n'a jamais reconnu pleinement l'existence du Liban comme nation souveraine (dans les manuels scolaires syriens, le Liban fait partie de la Grande Syrie).
Il n'y a donc pas de relations diplomatiques normales entre les deux pays, pas d'ambassade syrienne à Beyrouth ni d'ambassade libanaise à Damas.
La survie politique d'Olmert en question
La commission, dirigée par l'ancien juge de la Cour suprême Eliahu Winograd, vient de rendre son rapport préliminaire.
Ses critiques à l'encontre d'Olmert, du ministre de la Défense Amir Peretz et du Chef d'état-major Dan Halutz -- énumérées dans un rapport détaillé et méticuleux de 117 pages -- sont dures, mais sans surprises.
La Commission Winograd met en lumière ce que la plupart des Israéliens pensaient déjà : Olmert et Peretz n'avaient ni l'expérience militaire, ni l'expérience politique pour affronter une organisation terroriste qui a lancé des raids sur Israël, tué des soldats et kidnappé deux autres, puis lancé des milliers de roquettes sur des cibles civiles pendant plus d'un mois.
De fait, l'inexpérience du Premier ministre et du ministre de la Défense sont sans précédent dans l'histoire de l'État hébreu.
Olmert, qui a succédé à Sharon à la tête du parti Kadima, était considéré comme un parlementaire compétent mais sans relief - puis maire de Jérusalem -- et mieux connu pour son goût de la polémique que pour son envergure politique.
Pour la plupart des Israéliens, même pour ceux qui l'avaient investi comme héritier de Sharon après le retrait de la bande de Gaza, Olmert reste un Premier ministre par accident.
De même Peretz, un syndicaliste provocateur mais efficace, a surpris toute le monde en remportant les primaires pour la présidence du Parti travailliste, puis en choisissant le portefeuille de la Défense plutôt que celui des Finances.
Pour beaucoup, le duo Olmert-Peretz semblait prédestiné à courir au désastre.
Les Israéliens, conscients des menaces sécuritaires qui pèsent constamment sur leur pays, ont toujours pensé que leurs dirigeants devaient être prêts à entrer en guerre pour défendre Israël -- et aussi à mettre l'armée devant ses responsabilités lorsque la diplomatie échoue.
Le 12 juillet 2006, lors de l'attaque du Hezbollah, surgie de nulle part (semblait-il en tout cas), les deux principaux dirigeants de l'État ont été clairement dépassés et se sont engagés dans une guerre à laquelle ni eux ni l'armée israélienne n'étaient préparés.
L'armée était dirigée pour la première fois de son histoire par un général de l'armée de l'air, Dan Halutz, qui estimait que la supériorité aérienne suffisait à tout résoudre, donnant ainsi lieu à un cocktail détonnant d'ignorance civile et d'arrogance militaire.
Dans un langage mesuré mais dévastateur, la commission Winograd attribue de mauvais points aux trois dirigeants.
Olmert a décidé d'engager les combats sans réfléchir et sans en mesurer les conséquences.
Peretz s'est montré incapable de mesurer les implications stratégiques de ses décisions.
Et Halutz n'a pas proposé aux dirigeants civils toute la panoplie des options dont disposait l'armée.
Halutz a démissionné il y a déjà plusieurs mois.
Mais Olmert et Peretz ont déclaré qu'en dépit des conclusions de la commission, ils ne quitteraient pas leurs fonctions: ils se sont uniquement engagés à mettre en œuvre les nombreuses recommandations du rapport concernant les processus politiques, stratégiques et décisionnaires.
Olmert et Peretz parviendront-ils à se maintenir à leur poste ?
Leur gouvernement de coalition bénéficie d'une confortable majorité parlementaire ; il ne semble pas exister non plus d'alternative parlementaire viable.
Mais l'opinion publique - volatile et courroucée -- réclame leur tête : un sondage mené après la publication du rapport de la commission indique que seuls 14 pour cent des Israéliens pensent qu'Olmert devrait demeurer à son poste tandis que moins de 11 pour cent soutiennent Peretz.
Des manifestations demandant la démission du gouvernement sont prévues cette semaine et il lui sera difficile de continuer à fonctionner normalement.
Des rumeurs de révolution de palais au sein du parti Kadima circulent, évoquant le remplacement d'Olmert par le vice-Premier ministre Shimon Peres ou par la populaire ministre des Affaires étrangères, Tzipi Livni.
Mais il ne semble pas qu'Olmert soit prêt à se laisser évincer.
En fait, le gouvernement affaibli et discrédité d'Olmert pourrait bien survivre.
S'il chute et que des élections anticipées ont lieu, tout laisse à penser que le vainqueur sera Benjamin Netanyahu, du parti de droite Likoud, décimé lors des élections de 2006 et qui attend patiemment sa revanche.
Une majorité qui veut le départ d'Olmert ne souhaite pourtant pas le retour de Netanyahu, ce qui explique peut-être aussi le soutien indirect qu'apportent les Etats-Unis au Premier ministre.
Seul un gouvernement israélien fort peut prendre les difficiles décisions nécessaires au succès des négociations avec les Palestiniens.
La perspective d'une poursuite constructive des discussions israélo-palestiniennes semble donc plus éloignée encore qu'auparavant.
En fait, le grand perdant de la guerre du Liban de 2006 n'est ni Israël ni le Hezbollah, mais, au moins pour le moment, le processus de paix.
L'Amérique impuissante ?
Il y a des raisons immédiates à cela : le gouvernement du Premier ministre israélien Ehud Ohmert est à la fois faible et impopulaire, essentiellement à  cause de la guerre maladroite contre le Hezbollah au Liban.
Quant à l'Autorité palestinienne sous la direction de Mahmoud Habas, elle s'est encore affaiblie après la violente prise de contrôle de Gaza par le Hamas l'année dernière.
Du coté palestinien, il y a un phénomène plus profond : de longue date les Palestiniens ont échoué à créer les structures institutionnelles nécessaires à la construction d'une nation.
Ainsi, durant la période 1936-39, leur révolte contre la domination britannique s'est soldée par une guerre civile sanglante au cours de laquelle les conflits intra-palestiniens ont fait plus de victimes que l'armée britannique ou les forces d'autodéfense juives.
Si l'on examine l'implication des Américains dans la région au cours des 60 dernières années, on identifie deux types d'intervention qui ont permis de parvenir à un accord entre les acteurs locaux.
Hors de ce cadre, les USA se révèlent impuissants.
Le premier type d'intervention s'applique lorsqu'une guerre menace de s'élargir au risque de déstabiliser la région et de compromettre les relations entre les grandes puissances.
A ce moment là, l'intervention résolue des Américains peut servir à mettre fin aux combats et à imposer un cessez-le-feu, si ce n'est la paix.
En 1973, à la fin de la guerre du Kippour, Israël était sur le point d'encercler toute la Troisième armée égyptienne dans le Sinaï.
Quelques messages bien sentis du président Nixon ont arrêté les Israéliens en chemin et ont permis aux Américains d'entamer un long processus de désescalade qui a conduit à plusieurs accords intérimaires.
De la même manière en 1982, lors de l'invasion du Liban, les troupes israéliennes étaient sur le point d'entrer à Beyrouth Ouest après l'assassinat par des agents syriens du président libanais élu Bachir Gemayel, un pro-israélien.
Lors de la première guerre du Golfe en 1991, les forces US ne sont pas parvenues à mettre fin aux attaques de l'Irak contre des cibles civiles à l'intérieur d'Israël (elles ont été visées par 39 tirs de missiles Scud irakiens).
Les USA ont exigé d'Israël qu'il n'intervienne pas et ce dernier a dû s'exécuter.
Chaque fois, les Américains se sont engagés rapidement et dans un but précis, réalisable au bout de quelques jours, si ce n'est de quelques heures.
C'est dans ces circonstances dramatiques que le pouvoir américain est au meilleur de lui-même.
L'intervention américaine est également utile quand les deux partis sont déjà engagés dans des pourparlers bilatéraux de paix, en ont payé le prix sur le plan intérieur et sont parvenus à un accord sur presque tous les points, tandis que ceux qui restent en suspens menacent de faire échouer l'ensemble.
Dans ce cas, l'intervention de l'Amérique, avec la carotte et le bâton, amène les deux partis à conclure un accord final.
Après la visite de Sadate à Jérusalem en 1977, Israël et l'Egypte ont négocié pendant un an pour parvenir à un accord sur la plupart des questions : la paix, les relations diplomatiques et le retrait complet des forces israéliennes du Sinaï.
C'est à ce moment là que le président Carter, initialement opposé à ce processus, a invité les deux partis à Camp David pour sceller un traité de paix.
En 1993, lors de négociations secrètes bilatérales en Norvège (sans que les Américains en soient informés), Israël et l'OLP sont parvenus à un accord sur la reconnaissance mutuelle et la création d'une Autorité palestinienne autonome provisoire.
Mais certains problèmes n'étaient pas résolus.
Le président Clinton est intervenu et a conduit les deux partis à surmonter les désaccords restant.
En dehors de ces deux types de scénarios, les initiatives américaines sont vouées à l'échec.
En l'absence d'une volonté politique locale et confronté à un projet de paix qui peut nécessiter des années, les USA sont virtuellement impuissants.
Ils sont extrêmement efficaces en tant que pompier, mais pas en tant que médecin traitant face à une maladie chronique.
Commencer par la base pour construire la Palestine
Le premier obstacle -- problème qui se tient effectivement au cœur de l'actualité -- c'est la guerre civile palestinienne. Le Hamas contrôle la bande de Gaza défiant ainsi l'autorité palestinienne d'Abou Mazen, chef du Fatah.
L'échec des Palestiniens à construire un état-nation rend tous pourparlers de paix significatifs avec Israël -- sans parler d'accord --  pratiquement impossibles pour le moment.
Si les Palestiniens sont incapables de trouver un minime consensus national, comment peuvent-ils faire la paix avec Israël ?
Le gouvernement israélien dirigé par le premier ministre Benyamin Nétanyahou n'est autre que le second obstacle. Le chef du Likoud sera nettement moins enclin -- ou disposé -- à faire de grands compromis pour évacuer les centaines de milliers d'Israéliens installés en Cisjordanie.
Dernier obstacle et pas des moindres : l'objectif fixé dans l'accord OLP-Israël de 1993 n'a pas été atteint.
Les tentatives de ressusciter les accords d'Oslo -- la "feuille de route" et les engagements d'Annapolis --  n'ont rien apporté de plus que des déclarations creuses et de stupides séances photo.
Il faut étudier les causes de ces 15 ans d'échec pour que la mission de Mitchell ne soit pas tuée dans l'œuf.  
Il est facile et juste d'imputer l'échec des accords d'Oslo aux Palestiniens et aux Israéliens confondus.
Mais une autre raison fondamentale, et non négligeable, est en cause.
Les accords d'Oslo proposaient une approche descendante pour construire l'état palestinien : créer une autorité nationale palestinienne, lui donner un territoire, lui donner de plus en plus de pouvoir, l'armer et la financer, tenir des élections, et un état palestinien apparaîtrait.
Au contraire, en ont découlé une autorité palestinienne corrompue et militarisée, aux forces de sécurité divisées  et donc incapables d'assurer une quelconque protection.
Cette autorité ne pouvait pas non plus négocier de manière crédible avec Israël ni assurer des services de base aux Palestiniens ordinaires.
Cet échec s'explique par deux raisons : la faiblesse des institutions de la société civile palestinienne, privée de l'infrastructure nécessaire pour construire un état-nation ; et l'impossibilité de gérer de front la construction d'une nation et des pourparlers de paix.
Nulle part dans le monde disposons-nous d'un exemple de double processus réussi.
Il faut changer le paradigme de base : les efforts de paix devraient mettre l'accent sur la construction d'un état du bas vers le haut. Malgré la tourmente de l'échec du modèle de construction descendante, certains signes encouragent une approche ascendante.
Ces deux dernières années, l'ex-premier ministre britannique Tony Blair et le général américain Keith Dayton ont réussi à établir des institutions efficaces dans trois secteurs cisjordaniens. Dotés d'une présence militaire restreinte, les secteurs de Djénine, Bethléem et Hébron sont devenus les plus pacifiques de Cisjordanie.
Les autorités locales ont reçu des conseils et un financement adéquat ; des chambres de commerce indépendantes sont à la base d'une classe moyenne commerçante locale, qui souhaite entretenir le pacifisme de la région, même en l'absence d'accord général ; la police locale, formée en Jordanie, agit désormais efficacement comme une force de police et non comme une milice armée ; et les relations commerciales avec les Israéliens des régions voisines ont été restaurées.
On a fait peu de cas de cette autonomisation, dont la persévérance a fait naître une gestion locale efficace. Mais ces projets fondés -- pour la première fois -- sur des détails pratiques constituent la pierre d'assise indispensable à l'établissement d'un état-nation palestinien.
Certes, temps et patience sont nécessaires à ce processus.
Mais c'est jusqu'à présent la seule approche qui réussit, là où tout échoue.
Blair a d'ailleurs récemment expliqué qu'une telle approche partant de la base pourrait aller de pair avec l'objectif de « paix économique » de Nétanyahou, même si cette approche finirait par le dépasser.
Il va sans dire que l'activité de colonisation israélienne devrait cesser totalement.
Si elle est bien ficelée, le gouvernement israélien pourrait même accepter tacitement cette proposition, en dépit de son manque d'enthousiasme.
Les accords d'Oslo ont échoué. Essayer de les ressusciter -- par exemple par le biais de l'initiative de paix arabe à Beyrouth -- suffirait à peine à mettre au jour tous les différends subsistants entre les deux camps et ne permettrait pas de surmonter l'échec de la création d'un état palestinien.
Au vu de toutes les pannes que les approches de création descendantes ont suscité, seule la bonne vieille technique de construction démodée -- en commençant par la base -- demeure viable.
Laissons les Serbes juger Milosevic
En Yougoslavie les choses bougent, et souvent de manière surprenante.
Après moult hésitations et une première tentative infructueuse, Milosevic a finalement été arrêté, sans bain de sang, mais non sans risque.
Le résultat des élections qui se sont déroulées dans le calme la semaine dernière au Monténégro laisse présager un conflit concernant l'indépendance du pays et des décisions difficiles, mais il est probable que les parties en cause trouveront une issue dans la négociation plutôt que dans la violence.
Ce sont de grands pas en avant qui montrent que malgré le lavage de cerveau auquel ont été soumis les Serbes et la complicité de beaucoup d'entre eux aux crimes du régime de Milosevic, la démocratie va s'enraciner dans ce qui reste de la Yougoslavie et la société s'ouvrir sur le monde.
Choix crucial, les nouvelles autorités serbes doivent décider si elles vont extrader Milosevic vers La Haye.
Il semble qu'il y ait un accord quasi-universel en faveur de l'extradition, et des pressions internationales s'exercent en ce sens sur le président Kostunica.
Mais la décision qui sera prise peut avoir des conséquences vitales pour l'avenir de la Serbie.
Beaucoup de ceux qui conviennent que Milosevic est un criminel de guerre sont maintenant sensibles aux voix qui s'élèvent de Belgrade pour demander qu'il soit jugé par les Serbes.
La responsabilité morale ultime des actes commis par Milosevic revient au peuple serbe.
C'est lui qui l'a mené au pouvoir, même s'il n'y est pas parvenu de manière vraiment démocratique; c'est le peuple serbe qui a soutenu Milosevic, y compris quand il l'a lancé dans un génocide et l'a conduit de défaites en défaites.
Finalement, c'est le peuple serbe qui l'a détrôné et c'est le nouveau pouvoir démocratique en place à de Belgrade qui a pris le risque de l'arrêter.
Cette arrestation aurait pu se terminer par un bain de sang susceptible de déstabiliser un gouvernement démocratique encore fragile.
On devrait laisser les nouveaux dirigeants yougoslaves agir avec Milosevic dans un sens favorable à l'avènement de la démocratie en Yougoslavie.
Ses crimes devraient être jugés par ses compatriotes et non par un tribunal international.
De cette manière, le procès gagnerait en légitimité et en crédibilité, en particulier vis à vis des nombreux Serbes qui n'ont pas encore pris conscience de l'étendue des crimes de Milosevic.
Et avant tout, en jugeant Milosevic, les Serbes qui sont nombreux à avoir soutenu son régime seront confrontés en leur âme et conscience à leurs propres actes.
Ce n'est qu'à travers ce processus que la Serbie pourra rejoindre les rangs des pays européens véritablement démocratiques.
Si le procès se tient suivant une procédure parfois opaque et assez abstraite, devant des juges étrangers et dans une lointaine capitale, beaucoup de Serbes y verront non le procès de Milosevic, mais la justice des vainqueurs appliquée à la nation serbe.
Certes, ils se tromperont ; mais les procès politiques (un procès pour crimes de guerre est toujours un procès politique) ne doivent pas servir seulement à punir, mais aussi à éduquer.
Ce sont des juges serbes qui doivent avoir cette responsabilité à l'égard du peuple serbe, ceci à l'intérieur d'un système reconnu comme légitime par la majorité des Serbes.
La clameur internationale qui s'élève pour réclamer que Milosevic soit jugé à La Haye, ceci sans prendre en compte les conséquences politiques, est compréhensible.
Cette pression est cependant déraisonnable et quelque peu hypocrite.
Après tout, les forces de maintien de la paix en Bosnie peuvent si elles le veulent arrêter Radovan Karadzic et le général Ratko Mladic, les dirigeants des Serbes de Bosnie qui sont aussi sous le coup d'une inculpation par le Tribunal de La Haye.
Elles s'en sont abstenues jusqu'à présent, et rien n'indique qu'elles vont changer d'attitude.
Pourquoi cette inaction ?
Les causes profondes en sont manifestement politiques: les gouvernements anglais, américains et français ne sont pas disposés à risquer la vie de leurs soldats pour traduire ces archi-criminels devant la justice.
Karadzic et Mladic échappent depuis des années à la justice, précisément depuis la signature des accords de paix de Dayton.
Ne faut-il pas prendre également en compte les contraintes auxquelles doit faire face le président Kostunica et la sensibilité du peuple serbe ?
Faut-il risquer de déstabiliser la jeune démocratie yougoslave pour un procès que le gouvernement yougoslave est de toute évidence capable de mener à bien lui-même ?
Le fait qu'il va y avoir maintenant une commission Vérité et Réconciliation à Belgrade suggère que les nouvelles autorités yougoslaves comprennent qu'elles doivent traiter les plaies laissées par le régime criminel de Milosevic.
Le peuple serbe devrait bénéficier de la même compassion et de la même compréhension de la part de la communauté internationale que celle dont elle fait preuve pour décider si elle va risquer la vie de ses soldats pour arrêter Karadzic et Mladic.
Les jours du dollar sont-ils comptés ?
Une année auparavant, le dollar dominait le monde comme un colosse.
Il est désormais moins orgueilleux et l'euro triomphe.
Le dollar en tant que réserve et monnaie internationale incontestées est-il destiné à disparaître ?
Ou le " triomphalisme de l'euro " est-il prématuré ?
Cette question préoccupe non seulement les spéculateurs qui suivent le déclin du dollar, mais également les hommes d'affaires qui se demandent quelle devise utiliser lorsqu'ils facturent des importations ou des exportations.
En effet, le rôle joué par les devises dans le commerce mondial en ce qui concerne la facturation n'est pas assez mis en avant.
A l'heure actuelle, le dollar américain domine toujours.
La plupart des exportations et des importations américaines sont réalisées en dollars et le dollar est massivement utilisé pour les échanges n'impliquant pas l'Amérique.
Toutefois, depuis 1980, le dollar a perdu du terrain.
Les estimations de la Commission européenne indiquent que la part du dollar dans le commerce mondial a chuté de 56 % en 1980 à 52 % en 1995 (dernière année d'établissement des statistiques).
La part du Deutsche Mark est restée relativement inchangée entre 1980 et 1995.
Le yen reste en arrière, mais possède la croissance relative la plus élevée avec une part du commerce mondial qui a plus que doublé entre 1980 (2 %) et 1995 (presque 5 %).
Citons, parmi les raisons de la dominance de longue date du dollar en tant que première devise internationale, les faibles coûts de transaction sur les marchés des changes, le rôle historique du dollar dans le commerce mondial depuis 1945 et la dimension même de l'économie américaine.
Mais le rôle de ce dernier facteur est plus complexe qu'il n'y paraît.
Le Japon représente la deuxième plus grande économie au monde, mais la part de son commerce réalisée en yen reste faible, même en comparaison avec les pays européens plus petits.
Ceci s'explique entre autres par la part importante des entreprises américaines sur les marchés où les Américains vendent leurs produits.
Pour comprendre les raisons sous-jacentes à cet état de fait, il est primordial de considérer les facteurs qui sont en jeu lorsqu'une entreprise choisit la devise qu'elle utilisera pour facturer les produits.
Dans ce cas, un exportateur se trouve confronté à deux types de risques : risque de prix et risque de concurrence.
Prenons par exemple une entreprise japonaise qui cherche à réaliser les bénéfices en yen les plus élevés qui soient sur des produits vendus en Suisse.
Si cette entreprise définit le prix en francs suisses, elle s'expose au risque de prix étant donné que le prix en yen fluctuera avec le taux d'échange entre le yen et le franc suisse.
Les exportateurs japonais ont donc tendance à préférer fixer le prix en yen.
Mais les entreprises se soucient également des préférences de leurs concurrents.
Si l'entreprise japonaise vend ses produits sur un marché suisse donné dominé par les entreprises suisses (qui facturent en francs suisses), elle préférera également fixer le prix en francs suisses.
Si le prix était fixé en yens, cette entreprise risquerait de perdre sa part de marché si le yen prenait de la valeur.
Si les entreprises japonaises dominent sur un marché suisse particulier, elles préfèrent fixer le prix en yen : une entreprise japonaise ne se soucierait donc pas de perdre une part de marché en cas de revalorisation du yen car ses concurrents devraient faire face aux mêmes pressions.
Ces arguments expliquent le rôle important joué par le dollar dans le commerce.
La grandeur du territoire américain rend plus probable la dominance des entreprises américaines sur un marché donné soit comme exportateurs, soit comme importateurs-concurrents lorsque des articles d'importation sont vendus en Amérique.
Ceci implique que les entreprises américaines, qu'elles vendent sur leur territoire ou à l'étranger, fixent le prix en dollars et que les entreprises étrangères, pour des raisons concurrentielles, fixeront également le prix en dollars lorsqu'elles exporteront vers les Etats-Unis.
Etant donné que le Japon possède la deuxième plus importante économie au monde, le yen devrait constituer une devise plus importante.
La concurrence explique en grande partie pourquoi ce n'est pas le cas.
Premièrement, les Etats-Unis représentent le plus important partenaire commercial du Japon : plus de la moitié du commerce japonais avec les pays industrialisés se fait avec les Etats-Unis.
Plus de 80 % des exportations japonaises vers les Etats-Unis sont réalisées en dollars sur les marchés où les entreprises américaines tendent à dominer.
Deuxièmement, même lorsqu'ils vendent à des pays autres que les Etats-Unis, les exportateurs japonais sont souvent confrontés à une forte concurrence américaine.
Prenons les exportations japonaises vers l'Asie du sud-est, qui sont réalisées environ pour moitié en dollars en raison de la concurrence des exportateurs américains.
Il est peu probable que ces facteurs changent rapidement et cette situation nous amène à prédire que le yen conservera un profil bas dans le commerce mondial.
Ces facteurs expliquent également pourquoi, au fil du temps, l'euro devrait peser plus lourd dans le commerce international.
Les pays de la zone euro peuvent être considérés comme un seul pays lorsqu'ils traitent de la dénomination du commerce.
Ce " pays " est plus puissant sur le marché que les pays individuels qui forment l'Union monétaire européenne.
L'euro devra donc jouer à l'avenir un rôle plus important dans le commerce international que la somme des devises qu'il a remplacées.
Cependant, ces changements ne se produiront que progressivement.
Ainsi, le " triomphalisme de l'euro " qui a salué le déclin du dollar est en fait prématuré.
Malgré ses problèmes actuels, le dollar devrait conserver sa prédominance pendant un certain temps.
La discrimination en Europe en jugement
Les derniers rapports publiés en 2006 émanant de l'Observatoire Européen des Phénomènes Racistes et Xénophobes de l'Union européenne et du Commissaire aux droits de l'homme du Conseil de l'Europe, s'ils constatent ici et là des améliorations, font état le plus souvent d'une stagnation des conditions de vie des Roms, quand ce n'est pas de leur dégradation.
Malgré les importants efforts faits localement sous l'impulsion et avec l'appui du Conseil de l'Europe, les minorités roms demeurent victimes de nombreuses discriminations.
Parmi elles, la discrimination dans le domaine de l'éducation revêt une importance singulière, en raison de ses conséquences graves quant à l'avenir des victimes.
Elle se traduit dans les cas les plus extrêmes par une ségrégation dans le système éducatif même : des écoles isolées dans des campements isolées, des classes spéciales pour enfants roms dans des écoles ordinaires ou encore une surreprésentation de ces enfants dans des classes pour enfants ayant des difficultés d'apprentissage.
La question était de savoir si les enfants avaient été victimes d'une discrimination liée à leur appartenance à une minorité nationale dans leur droit à l'instruction.
Le gouvernement tchèque a reconnu que certaines de ces écoles spéciales comptaient de 80 à 90 % d'enfants roms.
Mais si discrimination il y avait, elle n'était pas directe, car selon la loi tchèque, un placement dans un tel établissement ne peut être décidé que par le directeur de l'école, sur la base des résultats d'un test portant sur les capacités intellectuelles de l'enfant effectué dans un centre d'orientation psychopédagogique, et sous réserve du consentement des parents ou du tuteur légal de l'enfant.
Une différence de traitement n'est pas en soi nécessairement discriminatoire.
Conformément à la jurisprudence de toutes les cours suprêmes nationales et à la celle de la Cour de Strasbourg, il y discrimination lorsque sont traitées de manières différentes des personnes placées dans des situations comparables.
Or il est reconnu par la jurisprudence nationale et internationale qu'une mesure non discriminatoire en droit peut se révéler discriminatoire en fait.
Dans le cas présent, la discrimination invoquée ne provenait pas de la loi elle-même, mais de ses effets, les plaignants se fondant principalement sur les statistiques qui montraient la surreprésentation de la communauté rom dans ces écoles spéciales.
Il existait bien aussi de nombreux rapports d'ONG et même du Conseil de l'Europe sur la situation des Roms en République tchèque, mais, comme l'a rappelé la Cour à juste titre, elle doit se prononcer sur les seuls cas dont elle était saisie et n'a pas à se prononcer sur la légitimité du système éducatif tchèque.
Ces choix sont des problèmes d'opportunité qui relèvent de la compétence des Etats et peuvent donc varier selon ces Etats.
Selon elle, la loi a pour but légitime d'adapter l'enseignement aux déficiences d'une catégorie particulière d'élèves et les tests psychologiques paraissent suffisamment objectifs pour ne pas être soupçonnés de partialité raciale.
Aussi fondé que soit le raisonnement de la Cour, il demeure une sorte de sentiment de malaise.
Les statistiques font état d'une étonnante proportion d'enfants roms dans ces écoles et le soupçon d'un relent discriminatoire est difficile à évacuer.
Si les lois ont bel et bien changé, les mentalités n'ont pas toujours suivi le même rythme et l'on sait intuitivement que l'on peut tout faire dire à un test psychologique.
Par ailleurs, avant de conclure, la Chambre a éprouvé le besoin de rappeler que si, dans le cas d'espèce, elle n'avait pas conclu à la violation de la Convention, les statistiques révélaient « des chiffres inquiétants et que la situation générale en République tchèque concernant l'éducation des enfants roms rest[ait] à parfaire ».
Enfin, sans toutefois contester le bien fondé de la décision, le président de la Chambre, Jean-Paul Costa, a émis une opinion concordante et le juge Barreto a rédigé une opinion dissidente.
Il n'est d'ailleurs pas anodin que la Cour ait accepté, à la demande des parties, le renvoi de l'affaire devant la Grande chambre.
Selon le Président Costa, une infirmation du jugement de février 2006 impliquerait de contredire la jurisprudence antérieure.
Se prononcera-t-elle sur la conventionnalité du système éducatif tchèque lui-même ?
Suivra-t-elle le juge Barreto qui appelle à la reconnaissance d'une obligation de discrimination positive au bénéfice des Roms ?
Quelle que soit la formule qui sera adoptée, il est certain que les enfants roms doivent recevoir le même traitement que les autres enfants.
C'est cet impératif qui donne toute son importance à la décision à venir, car c'est l'occasion pour la Cour de réaffirmer le caractère fondamental du principe de non-discrimination qui caractérise nos sociétés démocratiques.
Les musulmans d'Afrique et l'islam
Les manifestations qui ont eu lieu au Nigéria (les plus violentes qui ont eu lieu en Afrique contre ces dessins) posent la question du rôle et de la place des musulmans africains (ou plus précisément d'Afrique sub-saharienne) dans le "monde musulman".
Plusieurs de leurs caractéristiques les distinguent des autres musulmans, en particulier de ceux du monde arabe.
Ils sont moins autoritaires et il leur est plus difficile de faire reconnaître leurs droits et de se faire admettre dans leurs pays respectifs.
Une partie du problème tient au dilemme perpétuel auquel ils sont confrontés quant à leur identité.
On parle de l'Afrique comme d'un continent qui a un triple héritage et de ce fait, les musulmans d'Afrique ont une personnalité clivée.
Un Africain de confession musulmane doit se positionner par rapport à sa religion, à sa tribu - les Haoussa par exemple - et à son pays - le Nigéria à titre d'exemple.
Même si l'islam est fortement implanté en Afrique, il incorpore fréquemment des rituels purement africains lors des mariages et des funérailles.
Ainsi, à l'ouest du Kenya, les Luhya qui sont musulmans sacrifient des animaux lors des funérailles, alors que l'islam ne le prescrit pas.
Dans beaucoup de pays d'Afrique sub-saharienne les musulmans sont minoritaires.
Ils ne constituent pas une écrasante majorité, comme au Nigéria où dans le nord, certains Etats à majorité musulmane appliquent la sharia, faisant d'eux jusqu'à un certain point des Etats musulmans.
La République fédérale du Nigéria est néanmoins un pays laïque, comme presque tous les pays d'Afrique sub-saharienne.
L'héritage colonial joue aussi un rôle dans la relative docilité des musulmans d'Afrique sub-saharienne.
Les pouvoirs coloniaux ont tracé des frontières arbitraires qui regroupent à l'intérieur d'un même pays divers groupes ethniques parfois ennemis héréditaires.
Ils ont concentré le "développement" dans les zones les plus riches, tout en négligeant les régions pauvres, souvent musulmanes.
Dans ces pays où règne souvent le clientélisme, les musulmans ont dû épouser un nationalisme ethnique étriqué pour bénéficier des "fruits de l'indépendance" et obtenir un minimum de représentation politique.
Cela a entraîné des problèmes dans les pays qui bordent l'océan indien : la désunion entre les musulmans habitant sur les côtes, plus arabisés, et ceux de l'intérieur, moins arabisés.
Il n'est pas exagéré de dire que les musulmans arabisés des côtes kenyanes et tanzaniennes (y compris l'île de Zanzibar) se considèrent comme "plus musulmans" que ceux moins arabisés de l'intérieur.
Le FMI doit veiller à la stabilité des marchés financiers mondiaux
Le FMI joue un rôle important en raison de sa perspective très large, englobant à la fois les économies avancées et celles qui sont émergentes ou en développement, qui s'intègrent de plus en plus dans le système financier mondial.
Par ailleurs, il ne se focalise pas sur les marchés financiers per se et il a une expertise unique quant aux liens entre l'économie réelle et la situation financière.
Enfin, sa perspective est universelle, ouverte sur l'ensemble des secteurs et des marchés.
Jusqu'à présent le Fond n'a pas exploité sa position unique, car il a souvent manqué d'initiative, n'a pas suffisamment donné de messages clairs et de recommandations à ses membres.
Mais la tourmente financière actuelle montre la réglementation et à la surveillance des marchés présentent des lacunes et que des interactions au niveau mondial, encore mal comprises, demandent une réponse globale.
Nous pensons que le FMI doit agir pour aider à résoudre les problèmes de stabilité financière et anticiper davantage pour éviter ou amortir de futures crises.
Il devrait collaborer étroitement avec le Forum pour la stabilité financière, la Banque pour les règlements internationaux et d'autres organismes internationaux appropriés.
Afin de renforcer son rôle en faveur de la stabilité financière, nous proposons qu'il prenne des initiatives dans trois domaines interdépendants :
- Il doit favoriser la stabilité financière au moyen d'un contrôle multilatéral.
Il doit se positionner au centre des marchés financiers internationaux et fournir une plate-forme d'analyse destinée non seulement aux banques centrales et aux ministères des Finances, mais aussi aux régulateurs des marchés, aux responsables de la réglementation et aux acteurs du marché.
Il doit en particulier améliorer sa connaissance des liens entre les structures de contrôle et la situation macroéconomique, notamment la balance des payements et l'évolution des taux de change, en mettant à profit toute l'information dont il dispose sur le plan international et l'expertise qu'il a acquise avec des missions dans ses 185 pays membres.
Il pourrait alors identifier les menaces macroéconomiques contre la stabilité et encourager l'adoption des meilleures pratiques par les contrôleurs et les régulateurs des marchés.
A partir de ses études, il pourrait contribuer davantage au débat sur les implications macroéconomiques et financières des fonds d'investissements, des fonds spéculatifs et des fonds souverains et faire des recommandations pratique pour souligner leur contribution à la stabilité financière internationale.
- Il doit favoriser la stabilité financière par un contrôle bilatéral.
Il doit repenser la manière d'assurer la stabilité financière dans le travail au jour le jour avec ses membres et intégrer entièrement l'analyse du secteur financier à ses activités de surveillance.
Il doit aussi être davantage proactif et parler avec franchise aux pays importants du point de vue de la systémique qui connaissent des insuffisances dans le contrôle financier et la gestion des crises.
Il doit aider les économies émergeantes à établir des marchés financiers intérieurs sains.
Ces mesures supposent de diversifier les membres des missions du FMI, de manière à utiliser l'expertise du secteur financier en complément des compétences macroéconomiques et budgétaires.
Le Fond doit avoir recours à un plus grand nombre d'experts financiers et moins s'appuyer sur les universitaires.
- Enfin, il doit aider ceux de ses membres qui ont des programmes précis pour libéraliser et intégrer leur économie dans le système financier mondial.
Il devrait envisager de créer les instruments de liquidité appropriés pour donner confiance aux économies de marché émergeantes qui risquent d'être touchées par une crise hors leur contrôle, plutôt que de les forcer à accumuler des réserves de plus en plus importantes ou d'avoir recours à des dispositifs inter-régionaux d'autoassurance.
Des initiatives dans ces trois domaines contribueraient à créer une institution multilatérale qui aurait l'autorité et l'expertise voulue pour conseiller les pays membres sur les problèmes de contrôle et de régulation d'importance systémique.
La tempête financière que nous traversons illustre la nécessité d'une telle institution.
Les pays membres que nous représentons -- des pays avancés et émergeants d'Asie et d'Europe  -- veulent jouer un rôle pour renforcer le rôle du FMI au cœur du système monétaire international.
Pendant trop longtemps, toutes les innovations financières ont été considérées comme bénéfiques pour le développement économique et comme un moyen de partager les risques.
Certes, il y a eu des avertissements prévenant que la prise de risque devenait excessive, mais pendant trop longtemps, l'espoir que les forces du marché allaient résoudre tous les problèmes a prévalu.
Il nous faut des mécanismes d'alerte précoce, assortis d'actions concrètes.
Cela ne signifie pas nécessairement que la bonne réponse soit contenue dans davantage de réglementation, mais ce qui importe est que les mesures soient consistantes.
Il est important d'améliorer les contrôles, mais les pays doivent aussi se préparer à coordonner leurs politiques économiques et de taux de change.
Avec leurs achats massifs de dollars, les économies émergentes ont pendant trop longtemps soutenu la culture du crédit aux États-Unis qui a fini par déboucher sur cette crise.
Il importe particulièrement que le FMI joue un rôle plus affirmé car tous ces problèmes sont interconnectés.
En effet, le FMI, grâce à la diversité de ses pays membres et à l'accumulation de son savoir-faire international, est le mieux placé pour endosser le rôle de meneur dans une approche multilatérale de la stabilité financière.
Ce rôle devrait aller au-delà de son traditionnel travail de conseiller et de prêteur de dernier recours.
Sa casquette de conseiller rend le FMI vulnérable à la critique des pays développés selon laquelle le monde industrialisé ne tient pas compte de son avis.
Étant donné que des équipes du FMI travaillent aujourd'hui dans le monde entier pour aider les gouvernements à mettre en place des programmes capables de restaurer la confiance, il est clair que son rôle de prêteur de dernier recours n'a rien d'obsolète.
Mais cela comporte un sous-entendu amer : le FMI doit à présent réparer les dégâts occasionnés dans les pays émergents par une crise financière dont les origines viennent d'ailleurs.
Au niveau mondial, le FMI peut aider à concevoir un système de réglementation global pour les marchés financiers en fournissant une plateforme aux acteurs clés.
Le Fonds peut apporter une aide analytique, identifier des failles de réglementation et indiquer les endroits où elle a besoin d'être renforcée.
Il doit surveiller les progrès, sans agir lui-même comme un régulateur.
Ce mandat reste entre les mains des contrôleurs actuels et des groupements internationaux comme le Financial Stability Forum.
Mais le FMI deviendrait le "contrôleur des contrôleurs."
Au niveau national, le FMI peut évaluer les systèmes de réglementation et faire des recommandations.
De nombreux membres du FMI l'ont volontairement demandé.
Jusqu'à présent, cependant, les États-Unis se sont abstenus de laisser le FMI s'impliquer.
Des analyses sous la supervision du Financial Sector Assessment Program du FMI doivent devenir obligatoires, et leurs résultats intégrés aux activités ordinaires de surveillance du Fonds.
Une meilleure coordination des politiques peut bénéficier de l'amélioration d'un travail analytique sur les relations entre développements financiers et économie réelle.
Le FMI devrait être autorisé à amener les décideurs d'États-membres clés à la table, et ce sur la base de son analyse indépendante.
Des consultations multilatérales peuvent contribuer à empêcher des pays de prendre des mesures économiques qui affectent négativement la stabilité financière et économique d'autres pays.
Les déséquilibres mondiaux doivent être abordés avec plus de force.
Enfin, le FMI doit mieux s'équiper pour gérer les problèmes du secteur financier.
Les programmes traditionnels du FMI, concentrés sur des politiques budgétaires ou monétaires, sont insuffisants dans cette crise financière.
Le Fonds doit établir des lignes de crédit pour les pays qui conduisent des politiques macro-économiques solides.
Dans ces cas-là, les conditions traditionnellement requises par le FMI ne seront pas nécessaires.
Le nouveau FMI
Le FMI est bien placé pour aider ses membres à venir à bout des gouffres de financement créés par la crise.
Lors de la préparation du sommet du G20, l'accès aux facilités de crédit du Fonds a été simplifié et les conditions rationalisées.
Dans un moment décisif, une nouvelle ligne de crédit non-conditionnelle a été introduite pour les pays affichant de bons résultats.
Le Mexique et la Pologne en seront les premiers bénéficiaires, et d'autres pays y prétendront.
Ces politiques de crédit plus souples reflètent une nouvelle image du FMI.
Le stigmate négatif rattaché au financement par le FMI fait dorénavant partie du passé.
Maintenant que son rôle de financeur dans cette crise est assuré, le FMI a besoin de consolider sa position de gardien d'un système financier international ouvert.
Le FMI a été créé pour éviter des crises comme celle que nous traversons actuellement, et en cela il a failli.
Il faut reconnaître que des alarmes ont été données, mais que les décisionnaires, particulièrement dans les pays avancés, n'y ont pas donné suite.
Le "nouveau" FMI doit être une institution qui communique mieux avec ses membres, équilibre équitablement les intérêts de ses membres avancés, émergents et en développement, et aligne mieux ses politiques sur les besoins du moment.
Maintenant que le FMI bénéficie d'un second souffle, il doit regagner sa position centrale dans le système financier international.
Pour ce faire, il est nécessaire de se concentrer sur trois sujets : une meilleure surveillance de la stabilité financière, une coordination internationale renforcée, et un processus de prise de décision réactualisé.
Le nouveau FMI doit s'exprimer plus clairement sur les problèmes de stabilité financière mondiale.
Il doit s'assurer qu'il n'y a pas de failles dans la surveillance des institutions financières.
Il peut aider à mettre en forme un système de supervision mondial plus robuste, qui doit être érigé afin de préserver les bénéfices des marchés financiers mondiaux.
Et il doit aider à développer la vision de ce à quoi devrait ressembler le futur paysage financier.
Dans ce but, la surveillance du FMI devrait comprendre des réactualisations régulières des organismes de surveillance dans les pays à l'importance systémique.
Des alarmes précoces, commissionnées par le G20, devront être ciblées et le FMI devra s'assurer que les décisionnaires font suivre d'effet les conseils du Fonds.
Le nouveau FMI a besoin de regarder la coordination internationale avec un œil neuf.
L'exigence d'un ordre monétaire différent, tel que le prône la Chine, prépare le cadre d'initiatives nouvelles visant à éviter les déséquilibres internationaux à l'origine de cette crise.
Premièrement, le déficit d'épargne des États-Unis devra être résolu de façon durable.
Deuxièmement, la Chine devra rendre sa monnaie convertible.
Troisièmement, la position de l'euro se renforcera avec le temps à mesure que de nouveaux pays rejoindront la zone euro.
Avec davantage de monnaies-clés en place, la perspective d'un système monétaire réellement multipolaire apparaît, accordant un rôle croissant aux DTS.
Cela diminuera le besoin ressenti par les économies émergentes de s'assurer elles-mêmes contre l'instabilité financière, en amassant de vastes réserves.
Enfin, le nouveau FMI a besoin de structures de gouvernance qui reflètent mieux les nouvelles réalités mondiales.
La perception que les pays avancés gèrent les affaires du Fonds, sans suivre ses conseils pour autant, a sapé l'autorité du FMI.
Le sommet du G20 a marqué le retour des États-Unis au multilatéralisme.
Cette acceptation d'une responsabilité collective devrait s'accompagner de l'abandon du pouvoir de veto des États-Unis en abaissant les majorités requises pour le vote, ainsi que l'abandon de la prérogative de l'Europe de nommer le directeur général du FMI.
L'une des forces de la structure actuelle de gouvernance du FMI, le système de représentation des pays, devrait être imité par le G20, afin d'assurer l'inclusivité.
La croissance rapide de la Chine, de l'Inde et d'autres pays émergents doit s'accompagner de l'intensification de leur influence, mise en place par le biais de l'augmentation des quotas, prévue en 2011.
Les pays avancés, y compris les pays européens, verront un déclin relatif de leur pouvoir de vote.
Les pays émergents, qui auront de plus en plus leur mot à dire, devront aussi endosser davantage de responsabilités internationales, notamment en termes financiers.
Aujourd'hui, les pays européens financent les prêts du FMI à hauteur de 42 %, et les prêts concessionnels de la Banque mondiale à hauteur de 62 %.
Cette tâche devra être partagée par les pays émergents avec de vastes réserves.
Ces réserves sont utilisées au mieux en aidant le FMI à maintenir un système financier ouvert et stable, et à empêcher que ne se reproduisent des crises comme celles-ci.
Pourquoi attendre l'euro ?
Bien que l'agrandissement vers l'est de l'Union européenne n'ait pas encore eu lieu, l'objet du débat se déplace déjà pour se centrer sur ce qui va suivre : à quel moment les nouveaux membres, majoritairement postcommunistes, devront-ils adopter l'euro ?
En supposant qu'ils se conforment aux provisions du Traité de Maastricht relatives à l'UEM - et qu'ils ne soient pas tenus injustement de respecter des critères plus rigoureux - la principale question sera de savoir les nouveaux membres retireront plus d'avantages à attendre ou à postuler rapidement.
Au début, il est nécessaire de souligner qu'en cherchant à adhérer plus tôt à l'UEM, un pays adopte un programme fiscal et structural plus ambitieux que si son adhésion à l'UEM était retardée.
Sinon, adhérer tôt ne servirait à rien.
J'estime qu'une adoption précoce de l'euro n'est pas seulement possible, mais qu'il est préférable de la retarder.
Par adoption précoce, j'entends le délai acceptable le plus court qui soit - deux ans - suite à la subordination par un nouveau membre de sa politique fiscale aux contraintes fiscales et monétaires du mécanisme des taux de change (MTC II).
En supposant une entrée dans l'UE et les MTC II en 2004, les nouveaux membres devraient se fixer 2006 pour entrer dans la zone euro.
Est-ce réaliste ?
Eh bien, la plupart des pays candidats ont déjà atteint un degré élevé de convergence structurale avec l'UE.
Les exportations vers l'Union sont montées en flèche depuis 1991, lorsque la chute du système d'échange COMECON de l'époque soviétique a imposé une réorientation radicale du commerce - aidée par des investissements étrangers massifs provenant de l'UE - vers les marchés de l'Ouest.
La plupart des candidats à l'accession exportent maintenant plus vers l'UE que ne le faisaient la Grèce, le Portugal et l'Espagne à leur entrée dans l'UE et l'UEM.
Le progrès sur la désinflation est, d'une façon similaire, impressionnant.
L'inflation annuelle de la plupart des pays candidats a chuté à 4-5 % - pas bien plus que dans beaucoup de pays de l'UE et moins qu'aux Pays-Bas l'année dernière.
En ce qui concerne la convergence structurale, les candidats à l'UE sont déjà comparativement plus performants que l'Espagne, le Portugal et la Grèce avant leurs débuts dans l'UEM.
Il n'existe pas beaucoup plus de risques de futures grandes oscillations correctives des prix étant donné que la quasi-majorité des prix est complètement libéralisée.
Des études théoriques suggèrent que l'inflation dans les pays candidats à l'accession restera obstinément plus élevée que ne l'autorise le Traité de Maastricht.
Le coupable de cette vision pessimiste est le soi-disant effet « Balassa-Samuelson » : la croissance rapide de la productivité dans les secteurs exportables des candidats à l'accession - la fabrication, par exemple - fait grimper les salaires réels dans toute leur économie, y compris dans les secteurs non exportables tels que les services.
Cette augmentation globale des salaires réels face à une croissance moindre de la productivité du secteur des services fait monter les prix relatifs et garde l'inflation au-dessus de la moyenne de la zone euro.
L'effet Balassa-Samuelson est toujours manifeste en Grèce, en Espagne et au Portugal.
Mais comme l'estime la recherche empirique préparée par les Banques nationales de la CCE5, sa contribution à la croissance totale des prix dans les pays candidats est de 1-2 %.
Avec un effet Balassa-Samuelson si sobre et ayant une portée limitée pour une future inflation corrective, le critère de l'UEM relatif à la stabilité des prix - de l'inflation annuelle dans les limites de 1,5 % du taux moyen pour les trois économies obtenant les meilleures performances dans l'UE - est à portée de la main.
Mais une admission précoce dans l'UEM est-elle préférable au renvoi de l'adhésion ?
Du point de vue des états membres actuels, l'admission de la Hongrie, de la Lettonie, de la Pologne ou de la Slovaquie, plus tôt que tard, affaiblirait-elle l'euro comme le redoutent beaucoup?
Les craintes qu'une extension « trop précoce » de l'UEM aux nouveaux états ébranlerait le taux des échanges externes de l'euro sont irrationnelles.
Si tous les pays candidats rejoignent l'UE environ à la même période, ils ne représenteront tous réunis que 6 % de son PBN total.
Ainsi tout impact négatif sur l'euro provenant de la rapide accession des pays candidats à l'UEM représenterait au pire à peine plus qu'une erreur d'arrondi.
Le report de l'entrée dans l'UE pourrait avoir un sens si une attente plus longue produisait plus d'informations.
Mais une attente plus longue pourrait ne donner lieu à rien, si ce n'est à brasser plus d'air.
De même, la période de transition est déjà agitée, les flux de capitaux entraînés par la convergence augmentant les taux d'échange et compliquant la politique monétaire de plusieurs pays candidats, dont la Pologne, la République tchèque et la Hongrie.
En effet, la volatilité du flux de capitaux expédierait le taux d'échange flexible proposé sous le MTC II - une plage de fluctuation de 15 % de chaque côté d'une parité centrale.
Certains soutiennent que l'adhésion au MTC II doit être considérée comme une proposition à long terme - sans doute jusqu'en 2010 - à l'avantage des candidats.
L'avantage est simple : le MTC II autorise une certaine flexibilité des taux d'échange, par opposition aux taux fixes impliqués par l'adoption de l'euro.
Il contribuerait à aider les candidats à maintenir leur rendement économique à un niveau élevé et à préserver ainsi une convergence réelle avec les niveaux de revenus moyens de l'UE.
Cet argument est exceptionnellement faible et également politiquement suspect.
Comme l'indiquent les données de la Banque centrale européenne, le PNB moyen par habitant dans les pays candidats à l'accession représente 44 % du niveau de la zone euro.
La taille de l'écart des revenus est associée aux faibles différentiels de croissance pour impliquer que le processus de la convergence réelle s'étendra même bien au-delà des dates les plus circonspectes pour l'entrée dans l'UE et l'UEM, et durera sans doute plusieurs décennies.
Plus important, la croissance économique sur le long terme ne dépend pas du type de taux d'échange - qu'il soit flexible ou fixe (UEM) - tandis qu'une accession précoce accélèrera les réformes cruciales.
Quelques années d'une flexibilité limitée du taux d'échange constituent un faible substitut à une rapide exécution des réformes structurales.
Chez presque tous les candidats, une désinflation et une croissance économique à long terme supplémentaires nécessitent une consolidation fiscale, des marchés du travail plus souples et la mise en oeuvre de la privatisation.
Le report de l'entrée dans l'UEM risque d'affaiblir les motivations de réalisation de ces réformes politiquement onéreuses, mais nécessaires.
Tout retard pris dans la mise en oeuvre de réformes ralentira en fin de compte le processus de convergence réelle que les officiels de l'UE chérissent à juste titre.
Par contraste, une adoption précoce inciterait davantage à la réalisation de ces réformes, et donc à une convergence réelle.
La réussite permettrait aux pays candidats de commencer à récolter les avantages d'une plus grande transparence des prix, de coûts de transaction réduits et d'une solide structure macroéconomique.
Cette stratégie, et non celle d'une entrée différée, est la plus prometteuse pour les membres actuels et futurs de l'UE.
Le flambeau révolutionnaire de la liberté
Durant des décennies, Milton Friedman est resté bloqué dans une traversée du désert intellectuelle : il refusait le consensus keynésien de l'après guerre voulant que les gouvernements aient recours à la politique budgétaire pour gérer la demande globale -- conception qui a inspiré les politiques économiques étatistes des années 70.
En effet, à cette période, Friedman faisait figure de véritable révolutionnaire intellectuel, associant la recherche universitaire rigoureuse aux ouvrages et articles à succès écrits avec élégance, en faveur des politiques d'économie de marché -- et revendiquant le lien entre liberté économique et liberté politique, défendu par les grands économistes, d'Adam Smith à Friedrich von Hayek.
Dans le domaine économique, Friedman a fait revivre et développé la théorie monétaire selon laquelle les résultats économiques dépendent essentiellement de la quantité d'argent en circulation.
Dans son chef d'oeuvre Histoire monétaire des Etats-Unis, 1867-1960 (écrit avec Anna Schwartz), il a attribué les récessions, y compris la Grande dépression des années 30, à une baisse de la masse monétaire.
De même, il soutient que l'excédent monétaire est responsable de l'inflation.
Dans les années 60, Friedman a montré que la gestion keynésienne de la demande par la dépense publique augmentait de façon constante la masse monétaire et accélérait la hausse des revenus et des coûts.
Avec Edmund Phelps -- lauréat du prix Nobel cette année -- il a prouvé qu'il n'existe pas de corrélation stable entre le chômage et l'inflation.
Les politiques publiques expansionnistes visant à faire baisser le chômage en deçà d'une certaine limite alimenteraient les anticipations inflationnistes et saperaient la croissance économique et l'emploi.
Cette analyse a anticipé et expliqué la conjonction entre la hausse de l'inflation et la montée du chômage des années 70, connue sous le nom de « stagflation ».
Friedman a joué un rôle catalyseur dans les nouvelles conceptions politiques économiques publiques.
La stimulation et le contrôle budgétaire ont cédé la place à un nouvel instrument de la gestion économique : les politiques monétaires menées par des banques centrales indépendantes.
L'exploitation de la demande selon Keynes a donc été supplantée par une nouvelle conception -- que nous devons largement à Friedman -- aspirant à la discipline budgétaire et à la stabilité des coûts comme garants de la viabilité macroéconomique.
Les travaux de Friedman sur le rôle de l'État dans la société ont tout autant influencé l'opinion publique.
Avec Hayek, son collègue de l'Université de Chicago, Friedman a donné un assaut intellectuel plus général au keynésianisme, en soutenant que tout gouvernement qui se permet de contrôler l'économie au nom de l'égalité menace les libertés individuelles.
Dans ses rubriques pour Newsweek publiées entre 1966 et 1983, et ses ouvrages Capitalisme et liberté , La liberté du choix et La tyrannie du statut quo (en collaboration avec sa femme Rose), Milton Friedman propose une vision de la liberté à la fois séduisante et accessible.
En effet, La liberté du choix -- à l'origine d'une émission de télévision populaire qu'il présentait -- a été publié illégalement en Pologne dans les années 80. Au cœur des années les plus sombres de la domination communiste, ce livre m'a permis, ainsi qu'à beaucoup d'autres, de rêver d'un futur libre.
Dans un style à la clarté remarquable, Friedman met en avant une philosophie politique convaincante, associées à des propositions concrètes.
Par exemple, il a lancé l'idée des bons d'études, persuadé que la compétition dans l'enseignement privé garantirait de meilleurs résultats scolaires que les systèmes publics.
Friedman est le flambeau des conservateurs économiques du monde entier.
Son influence sur le gouvernement de Margaret Thatcher a en partie transformé une Grande‑Bretagne postindustrielle sinistrée et dominée par la lutte des classes en grande puissance économique européenne.
En outre, il a largement inspiré les hauts fonctionnaires du Vietnam pour leurs réformes d'économie de marché dans les années 80.
Il est également à l'origine de la pratique désormais courante consistant à mesurer et à comparer les libertés économiques et politiques pour déterminer dans quels pays la liberté est limitée.
Mais l'anti-étatisme systématique de Friedman l'a aussi conduit à embrasser des points de vue choquant bon nombre de susceptibilités politiques conservatrices -- l'honnêteté intellectuelle est caractéristique de la carrière de Friedman.
Par exemple, il s'opposait aux mesures gouvernementales consistant à interdire ou à réguler les comportements humains, comme les lois anti-drogue et les mesures voulant que les médecins ne puissent exercer sans autorisation, ni les automobilistes conduire sans permis, car ces réglementations serviraient à subventionner le crime organisé.
De même, il s'est considérablement investi dans sa campagne contre le service militaire aux Etats‑Unis.
Même s'il n'a pas remporté toutes ses batailles intellectuelles, il est certain que Friedman est un homme de grande valeur et que les travaux qu'il laisse derrière lui auront une influence durable.
Je vis dans une Pologne désormais libre et je considère Milton Friedman comme l'un des grands architectes intellectuels de notre liberté.
UE : Comment les nouveaux membres peuvent-ils rattraper leur retard ?
8 des 10 nouveaux membres de l'UE se sont radicalement transformés à une vitesse sans précédent.
Pour les 8 pays post-communistes, quel que soit le domaine considéré - la finance, la structure de la propriété, le secteur bancaire, le commerce extérieur, la santé, l'environnement, les marchés ou l'éducation - les institutions ont été entièrement recréées.
Dans beaucoup de ces pays en transition, l'inflation qui atteignait des sommets (251% en Pologne en 1989) a été jugulée et leurs monnaies sont maintenant totalement convertibles.
Les entreprises privées tiennent le haut du pavé pour la production et l'emploi, alors qu'elles ne comptaient que pour 23,1% du PIB de la Pologne en 1989 et seulement pour 4% en République tchèque et en Slovaquie.
De la même manière, après l'effondrement du Conseil d'assistance économique mutuelle (COMECON) en 1991, ces pays ont rapidement réorienté leur commerce extérieur vers l'Ouest.
Dans l'enseignement les offres de formation se sont multipliées, la pollution de l'air et de l'eau a chuté et l'espérance de vie a augmenté jusqu'à se rapprocher du niveau des pays d'Europe de l'Ouest.
Depuis le début des années 1990, la perpective de leur admission a stimulé les réformes institutionnelles chez les nouveaux pays membres.
Leur appartenance à l'UE ne pourra que les y aider.
Leur nouvelle crédibilité politique va susciter l'arrivée de nouveaux investissements étrangers et le budget de l'UE va renforcer le processus de construction des nouvelles institutions, l'investissement dans les infrastructures et la protection de l'environnement.
Il n'y a guère de doute quant à l'impact positif des investissements étrangers.
Ils favorisent les transferts de technologie et du fait de leur complémentarité avec les firmes nationales, ils contribuent proportionnellement plus à la croissance que l'investissement intérieur.
Ainsi, le taux de croissance a augmenté en moyenne de 0,4 à 0,9% pour la Grèce, le Portugal et l'Irlande et de 0,3 à 0,5% pour l'Espagne.
L'intérêt du marché unique est évident, ne serait-ce que parce qu'il est très attractif pour les investisseurs étrangers.
Selon les sondages, 60% des entreprises qui exportent dans au moins 6 pays de l'UE ont vu leurs exportations croître, 80% des consommateurs pensent que le choix des marchandises est plus large et 67% d'entre eux que la qualité des marchandises s'est améliorée.
Les échanges transfrontaliers ont cru de 1/3 depuis la création du marché unique en 1992, ceci grâce au principe de reconnaissance mutuelle qui permet aux entreprises d'appliquer la législation de leur propre pays et aux directives de l'UE visant à harmoniser les réglementations des différents pays.
Le prix hors TVA des voitures neuves peut varier de 70% suivant les pays, essentiellement à cause de réglementations qui s'opposent à la concurrence.
Les services sont encore davantage affectés par les obstacles qui subsistent à l'intérieur du grand marché.
Ainsi, une nouvelle directive exige que les industriels puissent choisir leur fournisseur d'électricité dès juillet 2004 et leur fournisseur de gaz à partir de juillet 2007.
Mais cette directive fait l'impasse sur les particuliers qui en 2001 ne pouvaient choisir leur fournisseur d'électricité que dans 5 pays de l'UE et leur fournisseur de gaz dans seulement 3 pays.
En ce qui concerne la mobilité des citoyens de l'Union, on est loin de la théorie à la pratique.
L'intégration des marchés financiers de l'UE initiée en 1999 avec l'adoption du Plan d'action pour les services financiers (PASF) a aussi besoin d'une impulsion supplémentaire.
Selon la Commission européenne, la création d'un marché financier européen unique permettrait de réduire de 0,5% le coût des capitaux propres des entreprises de l'UE et de 0,4% le coût du financement de leur dette.
Le marché financier unique entraînerait une croissance du PIB de l'Europe des Quinze de 1,1% au cours des 10 prochaines années et ferait progresser l'emploi de 0,5%.
Mais en 2002, seules 31 des 42 mesures du PASF étaient appliquées.
Une entrée rapide dans l'Union économique et monétaire (UEM). La meilleure stratégie pour les nouveaux arrivants est de chercher à entrer aussitôt que possible dans la zone euro, ce qui les poussera à achever les réformes de structure nécessaires pour répondre aux critères de Maastricht en ce qui concerne l'inflation, le déficit budgétaire et la dette publique.
Cela présenterait des avantages évidents pour la croissance économique à long terme, de même que l'élimination des risques liés aux taux de change, du coût lié à la protection contre ces risques et du coût des transactions dans le commerce extérieur.
Les nouveaux membres sont déjà largement intégrés dans l'économie de l'UE, avec une forte convergence à caractère cyclique entre eux et les pays de l'UME.
L'approfondissement de cette intégration va probablement aligner les cycles économiques de ces pays, de la même manière que la synchronisation des chocs de l'offre et de la demande dans l'UE des années 1990.
Aussi, le coût lié à l'abandon d'une politique monétaire indépendante et d'un taux de change flexible ne devrait pas être significatif.
Dans chacun des domaines évoqués, les nouveaux arrivants ont encore un chemin difficile à parcourir avant de parvenir à une intégration totale.
Mais c'est aussi bien souvent le cas des membres de longue date de l'UE.
Leçons de l'après-Kaczyński
Certains gouvernements gâchent les périodes de prospérité économique en repoussant les réformes nécessaires à garantir un avenir prospère.
Le gouvernement à majorité PiS, élu en 2005, a h_3érité d'une économie à croissance rapide mais n'a rien fait pour renforcer cet héritage.
Il a au contraire choisi de bloquer les privatisations, tandis que les réformes fiscales et les déréglementations restaient lettres mortes.
À vrai dire, le gouvernement Kaczyński s'est lancé dans un programme de contre-réformes.
La séparation des pouvoirs (un appareil judiciaire et une banque centrale indépendants) a été oubliée au profit d'un État « fort ».
Le PiS a mis les médias au pas, la fonction de procureur général a été politisée, et avec l'aide des médias, a été transformée en un outil de propagande du parti avec pour objectif de prouver que la Pologne était la proie de forces cachées maléfiques, connues sous le terme układ , qui dupaient les Polonais et les maintenaient dans la pauvreté.
Quiconque tentait de s'opposer à ce scénario ou de critiquer les méthodes du PiS, et en particulier celles de son chef, Jarosław Kaczyński, était rapidement catalogué comme appartenant aux układ . Personne n'a été épargné.
Lech Wałęsa et Władysław Bartoszewski, le Mandela polonais, ont en particulier été attaqués sans pitié.
Contrairement à la notion communément admise, la victoire du PiS en 2005 n'avait rien à voir avec une « fatigue des réformes », puisque que peu de réformes ont été appliqu_ées entre 2000 et 2005 ((à l'exception d'une tentative ambitieuse, mais inachevée, de consolidation fiscale).
Cette explication ne tient pas non plus la route ailleurs.
En Slovaquie, le dirigeant réformiste Mikuláš Dzurinda a remporté les élections en 1998 après avoir mis en œuvre un rigoureux programme de stabilisation, et aurait pu rester au pouvoir après les élections de 2006 sans les dissensions au sein de sa coalition.
En République tchèque, un gouvernement réformiste a été élu en 2006, et en Hongrie, les divisions politiques, plus qu'une fatigue des réformes, dominent les campagnes électorales.
Bien sûr, il n'est jamais aisé pour les réformistes de gagner les élections.
Au contraire, les réformes ne sont généralement entreprises que lorsque les signes d'une crise imminente sont tellement évidents qu'il est impossible de les ignorer, ou alors une fois qu'une crise a « éduqué » les électeurs.
(Si toutefois la crise suit les réformes, des politiciens populistes peuvent l'emporter en blâmant les réformes au lieu de leur nature inachevée, comme en Argentine).
Les réformistes peuvent remporter des élections s'ils parviennent à battre les populistes sur le terrain de la communication.
Il est souvent plus facile de vendre de mauvaises politiques que les bonnes.
En Pologne en 2005, le principal enjeu était celui de la corruption.
Le PiS a sauté dans le train en marche de la lutte anti-corruption et a renforcé son attrait en lui associant le spectre des forces de l'ombre qui pervertissaient soi-disant la société et la démocratie polonaises.
Sans cela, il est très probable que le résultat des élections ait été tout autre.
Il est toujours risqué de critiquer les campagnes contre la corruption, parce que le sens des mots peut être détourné pour faire croire à l'indifférence.
Il me faut donc d'abord présenter mes références dans ce domaine : en qualité de vice-Premier ministre, j'ai été, en 1999, le premier politicien polonais à demander un audit à la Banque mondiale sur la corruption en Pologne et les moyens de l'éradiquer.
Dans le cours de mes fonctions publiques, j'ai souligné l'importance de l'abrogation des réglementations discrétionnaires -- la principale cause à la fois de l'inefficacité et de la corruption.
Mais nous ne devons pas nous leurrer sur ce qui peut se passer lorsque les démagogues détournent le propos de la lutte anti-corruption.
Il est intéressant de noter que tous les indices disponibles de la corruption réelle montraient un déclin amorcé avant l'élection des frères Kaczyński.
Par exemple, l'indice de la fréquence des pots-de-vin versés, calculé par la Banque mondiale et la BERD, était de 2,7 en 1999 et de 2,03 en 2005 (la valeur de 1 étant le minimum).
La « taxe de corruption » (le pourcentage des pots-de-vin dans les ventes) est passée de 1,22 pour cent en 2002 à 0,7 pour cent en 2005.
En Pologne, l'écart entre les taux de corruption perçus et les taux réels est aujourd'hui très important.
La corruption est perçue comme étant pire qu'en Slovaquie, qu'en République tchèque, qu'en Hongrie et qu'en Grèce, alors qu'en réalité, elle est moindre -- ou égale.
Par exemple, le pourcentage de personnes ayant admis avoir versé des pots-de-vin en 2006 était de 5 pour cent en Pologne et de 17 pour cent en République tchèque et en Grèce.
En 2005, cet indice était de 2,03 en Pologne, 2,22 en Slovaquie, 2,09 en République tchèque, et 2,37 en Grèce.
En 2005, la taxe de corruption était de 0,7 pour cent en Pologne, de 0,93 pour cent en Slovaquie et de 0,63 pour cent en Hongrie.
Il est évident que les Polonais ne doivent pas pour autant s'accommoder des taux de corruption actuels.
Il faut au contraire que la lutte contre ce fléau ait pour objectif d'en éliminer les causes profondes : l'ampleur des mesures discrétionnaires dans le secteur public et la mise sous tutelle des forces du marché.
Cette voie est la seule à promettre à la fois moins de corruption et plus de croissance économique.
Combattre la corruption en renforçant l'arsenal juridique, tout en laissant intact un secteur public surdimensionné et discrétionnaire, ne conduira qu'à la paralysie des fonctionnaires, au report de décisions importantes et à faire le jeu de démagogues cyniques et de politiciens fanatiques.
On sait que la fusion nucléaire est source d'énergie depuis l'invention de la bombe à hydrogène.
Mais sa maîtrise demeure un défi pour les chercheurs, et n'est donc pas un détail technique facilement surmontable.
Il est extrêmement difficile d'enfermer une étoile dans une boîte, et ce principalement pour trois raisons.
Premièrement, le combustible nécessaire n'est pas l'eau de mer, mais un mélange des deux isotopes lourds de l'hydrogène, le deutérium et le tritium, un élément radioactif produit en petites quantités pour les bombes à hydrogène.
Le développement de réacteurs à fusion exigerait une production industrielle de tritium par des méthodes qui n'ont pas encore été inventées.
Deuxièmement, la réaction deutérium-tritium s'amorce autour de 100 millions de degrés.
Pour atteindre cette température, il faut un champ magnétique pour piéger et accélérer un plasma, sorte de grande flamme de deutérium et de tritium.
Cela se passe en ultravide dans une grande enceinte de confinement.
ITER n'est pas conçu pour produire de l'électricité, mais pour étudier la stabilité de la flamme dans le champ magnétique.
D'autre part, les réactions de fusion produisent des particules alpha qui polluent le plasma, il faut insérer un « divertor » dans la flamme à 100 millions de degrés pour les extraire.
Troisièmement, la fusion s'accompagne d'une émission de neutrons qui produisent des bulles d'hélium à l'intérieur des matériaux de structure.
Les partisans d'ITER soutiennent que si les parois sont poreuses, les bulles peuvent s'échapper.
Or un matériau ne peut être à la fois étanche et poreux, et ITER n'est pas conçu pour étudier cette contradiction.
A l'avenir, une « couverture » devrait être placée autour du plasma, avec deux objectifs : protéger les parois et produire du tritium à partir de réactions nucléaires dans un fluide circulant contenant du lithium.
Pour fonctionner, il faudrait que la couverture soit non seulement hermétique et poreuse, mais aussi suffisamment perméable aux neutrons pour leur permettre d'atteindre les atomes de lithium.
Le problème des matériaux est à lui seul tout un domaine de recherche.
Pour l'étudier, on a prévu de construire l' International Fusion Materials Irradiation Facility (IFMIF) au Japon.
Certains scientifiques soulignent que l'irradiation de neutrons dans l'IFMIF ne sera pas la même que dans les réacteurs de fusion, mais l'IFMIF coûtera dix fois moins qu'ITER, à un milliard d'euros.
Alors pourquoi ne pas attendre les résultats de l'IFMIF avant de construire ITER ?
C'est une question de budget.
Si ITER était vraiment la solution de la crise énergétique qui menace la planète, 10 milliards d'euros ne représenteraient qu'un investissement négligeable : moins que les bénéfices nets du groupe pétrolier TOTAL (13 milliards d'euros en 2006) et l'équivalent de dix jours de guerre en Irak.
Mais si la fusion fonctionne un jour dans des centrales, ce ne sera pas avant plusieurs décennies.
Même si ITER est un succès et si l'on parvient à résoudre les problèmes de la production de tritium et des matériaux, il faudra tout tester grandeur nature avant de pouvoir construire un premier prototype de réacteur industriel.
Or il est urgent de réduire les émissions de CO2 de manière drastique, et il y a peu de chances que la fusion produise de l'énergie commercialisable avant le XXIIe siècle.
En réalité, ITER est un outil de recherche fondamentale, et son coût annuel de 500 millions d'euros est donc à comparer avec des initiatives scientifiques similaires, comme l'Organisation européenne pour la recherche nucléaire (CERN), qui coûte chaque année un milliard de francs suisses.
A mon avis, il est plus important d'étudier la structure fondamentale des particules que la stabilité d'un plasma.
En France, la contribution à ITER dépasse l'ensemble du financement disponible pour les projets de recherche de tous nos laboratoires de physique.
Le danger est donc qu'ITER absorbe le financement dont auraient pu bénéficier d'autres projets essentiels.
On a déjà le mauvais exemple de la station spatiale internationale, un gaspillage de 100 milliards de dollars qui n'a produit aucun résultat scientifique.
ITER ne résoudra pas notre problème énergétique.
Il présente un certain intérêt scientifique pour la physique des plasmas, mais les Etats participants devraient affirmer que son financement ne se fera pas au détriment d'autres domaines de recherche.
Parallèlement, la communauté internationale devrait soutenir la recherche sur les économies d'énergie et le stockage, et accélérer le développement de réacteurs nucléaires de quatrième génération, capables d'utiliser la fission de manière propre et durable.
Une Europe unie dans des valeurs communes
Parallèlement au débat sur la Constitution de l'Union européenne, un autre débat s'est ouvert sur les valeurs européennes.
Il est important non seulement pour donner un sens à la Constitution, mais aussi parce qu'il est appelé à déterminer la vitalité et l'énergie de l'EU elle-même.
L'Union européenne, fruit de plusieurs grandes traditions religieuses et philosophiques, est une communauté de valeurs.
Nous avons été forgés par les idées des Grecs et des Romains, du christianisme, du judaïsme, de l'humanisme et des Lumières.
Le dialogue avec les cultures arabes et musulmanes a également contribué à la formation de notre identité.
Nos valeurs sont une toile tissée pendant des centaines d'années.
L'Europe est le continent de Michel-Ange et de Montesquieu, mais aussi de la guillotine et des chambres à gaz.
De fait, l'expérience amère de la deuxième guerre mondiale a enseigné aux Européens l'importance fondamentale de valeurs communes.
Sur un continent appauvri et ravagé par la guerre, les Européens aspiraient à la paix, à la liberté, à la stabilité et à une nouvelle prospérité.
Les architectes de l'intégration européenne - Monnet, Schuman, Adenauer, De Gasperi et d'autres - avaient compris que ces idéaux ne pourraient être concrétisés qu'en associant les intérêts pratiques des pays européens.
Ils ont bâti leur fragile édifice de paix sur des fondations de charbon et d'acier.
Les fondateurs ont passé le flambeau à la génération de Jacques Delors, Helmut Kohl, François Mitterrand, Václav Havel ou encore Valéry Giscard d'Estaing, qui ont élargi et approfondi la coopération européenne, et permis à l'Europe d'avancer à grands pas vers ses idéaux d'après-guerre : la paix, la stabilité et la prospérité.

Nous sommes aujourd'hui au seuil d'une nouvelle étape de la coopération européenne.
A la fin du mois d'octobre, le traité constitutionnel de l'Union européenne sera signé.
Une nouvelle génération de politiciens est prête à reprendre le flambeau.
Mais la lumière de ce flambeau est-elle toujours aussi vive ?
Au début des années 50, Jean Monnet affirmait : " Il ne s'agit pas de créer une coalition d'Etats, mais d'unir des individus. "
Apparemment pas.
Alors que l'Union avance à toute allure, elle semble avoir perdu ses citoyens en cours de route.
Beaucoup d'Européens se désintéressent du projet dans son ensemble.
Ils ont du mal à reconnaître les points communs.
Ils n'ont pas le sentiment de faire partie du tout.
Même dans les nouveaux Etats membres, l'enthousiasme pour la famille des démocraties européennes est réservé.
Nous sommes parvenus à unir l'Europe sans unir les Européens.
Les générations d'aujourd'hui, qui n'ont pas connu la guerre, tiennent les grandes réalisations de l'Europe - la liberté, la paix et la prospérité - pour acquises.
L'idée européenne comme un héritage et une mission ne veut plus dire grand chose.
Pourtant, sans idéaux, les fondations de l'Europe vont s'affaiblir.
La prépondérance des intérêts particuliers accroît cette menace.
Ma génération a grandi avec l'image de l'Europe comme espace de coopération économique .
Les motivations politiques de l'intégration ont été éclipsées par le projet économique, et l'Europe est donc perçue comme un marché.
Une Europe de transactions et d'argent - non plus d'humanité et de moralité - a dominé l'entreprise.
Mais sans fondement moral, il ne peut y avoir d'économie de marché.
Aujourd'hui, nous payons chèrement de ne pas nous être suffisamment concentrés sur nos valeurs et notre mission communes . Tant que les Européens ne sauront pas exactement ce que signifie l'Europe, ce qui nous inspire et ce qui nous motive, l'Union ne sera pas en mesure de prendre des actions conjointes sur la scène internationale.
La Constitution de l'UE rendra l'Europe plus démocratique et plus transparente.
Elle garantit que les décisions seront prises au plus près des citoyens, et reconnaît l'importance des valeurs sur lesquelles l'Union repose : le respect des droits fondamentaux et de la dignité humaine, la liberté, la démocratie, l'égalité et l'Etat de droit.
Ces valeurs assurent la cohésion des gouvernements, conscients qu'il n'est plus temps de s'accrocher à des intérêts individuels lorsque des préoccupations communes exigent une réponse commune.
A quoi bon supprimer les frontières physiques si les citoyens demeurent divisés ?
Comment les Européens peuvent-ils se réjouir de la disparition du rideau de fer, si des individus et des groupes dans toute l'Union se barricadent derrière leurs propres murs ?
La peur, l'insécurité et le nationalisme refont leur apparition.
Il est important pour les Européens d'y réfléchir, au moment où ils se préparent à d'autres phases d'élargissement et envisagent d'entamer des négociations d'adhésion avec la Turquie.
Le préambule de la Constitution énonce que l'Europe est " unie dans la diversité. "
C'est peut-être la définition la plus concise qu'on puisse imaginer de ce qui caractérise l'Europe.
Mais ces mots soulèvent la question de savoir ce qui fait cette unité.

La réponse se trouve dans les valeurs sur lesquelles est fondée l'Union, et que l'on peut résumer en trois concepts : liberté, solidarité et respect mutuel. Ensemble , ces concepts permettent à l'Europe d'ouvrir ses portes à des peuples très divers, tout en continuant de s'exprimer en tant que communauté de peuples prêts à assumer des responsabilités mutuelles.
Pour concrétiser cette communauté, rien ne sert de croire que la culture européenne est meilleure que les autres.
Il faut au contraire entamer un dialogue et une profonde réflexion sur les valeurs que les Européens partagent.
Ces valeurs doivent nous mener à ce que ni les marchés ni les institutions ne peuvent obtenir : l'adhésion des citoyens européens à l'Union européenne.
Ce n'est qu'en adhérant à leurs valeurs communes que les Européens pourront éviter que l'Union ne devienne une machine sans âme.
Ensemble, ils doivent trouver leurs points communs, et y puiser un nouvel enthousiasme, un nouvel élan, qui fait cruellement défaut pour aborder les grandes questions d'aujourd'hui, auxquelles aucun pays ne peut répondre seul.
Après plus de cinquante ans, l'Europe comme communauté de valeurs est toujours aussi nécessaire.
Nouvelle Aube européenne
Aujourd'hui à Rome, les chefs d'Etat et de gouvernement des 25 Etats membres de l'Union européenne vont signer le traité pour une Constitution de l'Europe.
Nous avons fait un long chemin depuis que les six membres fondateurs formèrent la Communauté économique européenne en mars 1957, depuis Rome également.
Une fois le traité signé, il sera présenté devant les parlements nationaux pour être ratifié.
Il est donc d'importance cruciale de comprendre pourquoi le traité mérite d'être ratifié.
Brièvement, il place plus que jamais les intérêts des citoyens européens au cœur des activités de l'Union européenne.
Et il le fait de quatre manières différentes.
Tout d'abord, le traité pour la Constitution garantit que les institutions de l'Union respecteront les droits fondamentaux de toute personne au sein de l'UE.
Le " catalogue des droits fondamentaux " inclus dans la Constitution est long, centré sur le respect de la dignité humaine, la liberté et l'égalité ainsi que les principes démocratiques et la primauté du droit.
En les consacrant dans la Constitution, ces droits fondamentaux et ces principes acquièrent force de loi et les citoyens auront plus de recours pour faire appel devant la Cour de justice.
De ce point de vue, l'UE est à l'avant-garde mondiale en matière de protection des droits fondamentaux.
Ensuite, le traité démocratise l'UE et rapproche le gouvernement des citoyens européens.
L'Union n'a pas à interférer dans les affaires qui peuvent être réglées de manière satisfaisante au niveau local, régional ou national.
Les objectifs de l'UE sont précisément ceux que les pays ne peuvent réaliser par eux-mêmes, tels qu'une économie plus forte et une plus grande sécurité.
Le traité pour la Constitution comprend des garanties pour assurer que l'UE adhère à ces principes de manière stricte.
Les parlements nationaux pourront intervenir et stopper toutes les propositions de Bruxelles qui sembleront interférer inutilement.
Si un tiers des parlements nationaux le décident, alors la Commission européenne doit reconsidérer la proposition.
De plus, le traité de la Constitution donne aux citoyens le droit de demander à la Commission européenne d'agir sur une question précise.
Une initiative citoyenne de cette ampleur nécessite un million de signatures venues de pays différents.
Au même moment, le Parlement européen aura de plus grands pouvoirs.
Il aura autorité pour prendre des décisions conjointes dans plus de domaines, dont le budget.
Ainsi, les représentants élus des citoyens européens seront mieux à même d'examiner en profondeur le travail de la Commission.
Puis, le traité propose une UE plus ouverte et plus transparente.
Les citoyens veulent que les pouvoirs soient clairement définis et que les décisions soient prises de manière transparente et compréhensible.
Nombreux sont ceux qui désespèrent de trouver leur chemin dans le labyrinthe des traités européens et de leurs nombreux amendements.
Hors de Bruxelles, on trouve très peu de gens qui peuvent expliquer la structure de " pilier " et faire la distinction entre l'Union et la Communauté.
La Constitution envoie ces difficultés dans les oubliettes de l'histoire.
Elle donne aussi aux peuples un meilleur accès aux informations officielles en étendant leurs droits d'accès aux documents de toutes les institutions, les organes et les corps.
Finalement, le traité rend l'Europe plus efficace.
Ceci est essentiel si les questions qui affectent le quotidien de nos vies doivent être traitées avec succès.
Deux thèmes sont considérés comme cruciaux : une économie européenne plus forte (plus d'emplois et de croissance) et une plus grande sécurité (réduction de la criminalité transfrontalière).
Les pays européens s'appuient énormément les uns sur les autres pour traiter ces questions.
Et les gens comptent sur l'Europe pour agir.
Cependant, du fait que les décisions de l'UE doivent souvent être prises unanimement, cela est parfois très difficile.
En outre, nous manquons souvent des moyens pour travailler ensemble efficacement.
Le traité introduit des améliorations importantes dans ce domaine, nous permettant de coopérer plus efficacement pour atteindre nos objectifs.
En résumé, le traité pour la Constitution inscrit fermement les droits fondamentaux dans la législation, et démocratise également l'UE, la rendant plus transparente et plus efficace.
Cela en fait un bon traité pour tous : les peuples qui attendent une plus grande coopération et des résultats concrets de la part de l'Union, mais aussi pour ceux qui s'inquiètent des interférences excessives de l'Europe dans des questions qui sont mieux débattues au sein des Etats eux-mêmes.
L'an prochain, nous célébrerons 60 années de paix à travers une grande partie de l'Europe.
Jamais dans notre histoire avons-nous profité d'une si longue période de paix, une période qui a vu une forte croissance de la prospérité.
La démocratie s'est enracinée dans presque tous les coins d'Europe et les Européens bénéficient maintenant d'une plus grande liberté pour vivre, travailler et étudier où ils le veulent comme ils le veulent.
Ces réussites sont largement dues à la coopération européenne.
Le traité pour la Constitution est une réflexion de notre souhait de continuer dans la même direction et de continuer à travailler ensemble.
Nous voulons réaffirmer notre engagement envers un quotidien sans guerre ni injustice et envers la liberté qui nous est si chère.
Le traité pour la Constitution de l'Europe apporte les fondations solides de notre avenir commun.
La paix, la sécurité et la prospérité sont aussi vulnérables qu'elles sont importantes.
Ce traité les renforce.
Et cela nous renforce.
La cérémonie de signature sera donc un message d'espoir.
C'est un nouveau commencement.
De l'utilisation du Tribunal de La Haye
Le Tribunal International de La Haye fut établi pour servir d'épée de Damoclès aux violateurs des Droits de l'homme dans les Balkans.
À l'intérieur des Balkans, cependant, c'est devenu un outil politique que les nationalistes aussi bien que leurs opposants exploitent sans fin en un stratagème visant à diviser pour (espérer) mieux régner.
Et la Croatie représente un cas d'école exemplaire ici.
Des obstacles et des déchirures contrarient maintenant les réformes démocratiques naissantes de la Croatie.
Ce tumulte tient au fait que le Premier ministre Ivica Racan refuse de s'attaquer aux centres de pouvoir laissés en place par le régime de l'ancien président Franjo Tudjman, dont le parti à orientation nationaliste, l'Union pour la Démocratie Croate (HDZ), fut exclu du pouvoir en janvier 2001 suite au décès de Tudjman en décembre 1999.
Tudjman avait élaboré un régime autoritaire où la frontière entre le HDZ et les administrations gouvernementales était brouillée, en particulier là où l'armée et la police étaient concernées.
Cet héritage confus touche au coeur des problèmes actuels de la Croatie et de ses relations avec le Tribunal de La Haye.
En janvier 2001, le nouveau Premier ministre d'alors, Ivica Racan, dut faire face à des choix difficiles : purger rapidement les institutions gouvernementales des partisans de Tudjman ou céder aux stratagèmes obstructionnistes des partisans du HDZ.
Fidèle à son indécision instinctive, le Premier ministre tarda.
Il préféra concentrer son effort sur les réformes constitutionnelles, généralement perçues comme une tentative visant à priver le nouveau président, Stjepan Mesic (lui-même un opposant de longue date de Tudjman), des pouvoirs exécutifs puissants que Tudjman introduisit à son propre usage dans la constitution.
Pendant ce temps, le nouveau gouvernement ne put enquêter sur les nombreux crimes de guerre, les erreurs judiciaires, et la corruption de l'ère Tudjman.
Ce manquement offrit aux partisans du HDZ l'occasion de mettre à l'épreuve la détermination du gouvernement Racan.
Un de leurs ruses préférées fut de créer d'importants obstacles aux moindres tentatives de mise au pas des criminels de guerre.
En septembre 2000, suite à l'assassinat d'un témoin pour le Tribunal de La Haye et à l'arrestation d'un chef croate accusé d'avoir massacré des Serbes en 1991, douze généraux de l'armée publièrent une lettre appelant à défendre les anciens combattants croates et à cesser de "présenter de manière négative et historiquement erronée" la participation croate aux guerres des Balkans.
En un rare étalage de détermination gouvernementale, le président Mesic suspendit et mit à la retraite d'office ces douze officiers.
Plusieurs d'entre eux rejoignirent alors un nouveau parti qu'ils dirigent: Pour la Prospérité et l'Intégrité croate (HIP), un parti organisé par le fils aîné de Tudjman, l'ancien chef des services secrets croates.
Le bras de fer avec les partisans de Trudjman continua au printemps de cette année, avec l'arrestation de Mirko Norac, un des douze généraux, accusé du massacre de civiles serbes en 1991.
Plusieurs organisations d'anciens combattants organisèrent des rassemblements de masse contre le gouvernement "traître" de Mesic et Racan.
Ces pressions n'auraient pas eu d'effets aussi dévastateurs si elles n'avaient pas reçu le soutien d'une partie de la coalition au pouvoir, notamment le soutien de Drazen Budisa et de son Parti Social Libéral croate (HSLS), et de certains évêques catholiques influents.
Affaibli, le gouvernement s'est ainsi montré psychologiquement prêt à faire des concessions plus importantes.
En juillet, le Tribunal de La Haye pour l'ex-Yougoslavie mit en accusation deux généraux croates, Rahim Ademi et Ante Gotovina, pour crimes de guerre.
Au lieu de les livrer au Tribunal, Racan utilisa cette occasion pour entamer un bras de fer, en réclamant au parlement un vote de confiance pour ce qui fut considéré comme une dévalorisation des mandats du Tribunal de La Haye.
Cela provoqua la démission de Budisa de la direction du Parti Social Libéral croate, ce qui entraîna la quasi scission de ce groupe clé de la coalition, le seul parti de la coalition au pouvoir qui voulait résister au Tribunal de La Haye.
En dépit de cela, Racan a gagné son vote de confiance et s'est assuré un minimum de stabilité dans son gouvernement.
Et pourtant, les divers factions qui forment l'opposition Tudjmanienne y ont gagné l'occasion de tirer Budisa à eux, créant ainsi un nouveau centre de gravité politique en vue de la prochaine crise.
Le Tribunal de La Haye est souvent accusé d'accabler les fragiles gouvernements de réforme de la Croatie et de la Serbie avec des exigences déraisonnables qui font le jeu des politiciens nationalistes.
Ceci n'est vrai que dans la mesure où le Tribunal est insensible à l'équilibre complexe attendu de la part des officiels des pays de l'ex-Yougoslavie.
Par exemple, la libération, avant son procès, de Biljana Plavsic, une des leaders serbe bosniaque des plus coupables, en échange de son témoignage évidemment écrasant aurait une signification plus importante si le Tribunal s'était montré aussi accomodant avec des accusés moins coupables et n'appartenant pas au groupe des Serbes.
La réticence à poursuivre les criminels de guerre est un atout que les gouvernements des Balkans utilisent pour pacifier leur public nationaliste et, de fait, éviter le problème épineux d'une réforme profonde.
Racan n'aurait pas eu à traiter avec le Tribunal de La Haye s'il avait eu le courage de se lancer dans le ménage de son propre pays, et dans les enquêtes sur les petits copains de Tudjmans et les criminels de guerre que le président décédé protégeait.
Maintenant, le Premier ministre Racan tire profit de ses attermoiements vis-à-vis des acolytes de Tudjman, dans l'espoir qu'ils seront aussi généreux avec lui s'ils devaient revenir au pouvoir.
Parce qu'en Croatie, chaque nouveau gouvernement délivre une absolution totale à ses prédécesseurs.
Une petite élite est donc ainsi protégée de sérieuses remises en cause et, finalement, dégagée de toute responsabilité, même dans le cas des crimes les plus abominables.
Les " Three Mis-Represents "
Deux années se sont écoulées depuis que le Parti communiste de Chine (PCC) a dévoilé son nouveau credo idéologique, appelé " Three Represents ".
Quelle chance que la doctrine la plus sacrée, la plus englobante et la plus influente de Chine élaborée autour du triumvirat des " intérêts de la majorité populaire ", de la " culture avancée " et des " forces productives avancées " ait trouvé un parti politique pour la représenter !
Une chance, mais pour le PCC, et non pour la Chine et ses habitants.
La doctrine " Three Represents " se décline en plusieurs versions officielles, chacune d'elle comprenant les mots " toujours ", " Chine " et " représenter ".
Leur signification est claire.
De l'autre côté, la " majorité populaire ", la " culture avancée " et les " forces productives avancées " ainsi que d'autres expressions qui dominent la doctrine restent vagues, sans doute intentionnellement.
Le bon sens suggère que la " majorité populaire ", que le PCC est supposé " représenter ", inclut les ouvriers.
Mais le PCC les a abandonnés depuis longtemps.
Combien ont perdu leur travail le mois dernier ?
Combien ont été obligés de partir en préretraite ?
Combien y a-t-il eu d'accidents dans les mines ?
Combien de protestations ?
Qui a emprisonné leurs organisateurs ?
Le " représentant des Three Represents " refuse de s'exprimer.
Les ouvriers qui protestent et font grève " font une émeute ".
Celui qui signale ces événements est " anti-révolutionnaire ".
La même histoire se vérifie dans les relations du Parti avec les paysans, qui se sont engagés comme soldats et suppléants dans les armées de Mao Zedong pour mener des guerres qui duraient des décennies.
Les paysans ont suivi Mao car le PCC leur avait promis des terres.
Mais Mao a décidé de reprendre les terres aux paysans avant même qu'ils n'en bénéficient. "
L'éducation des paysans constitue un grave problème ", a-t-il dit.
Il leur a donc enseigné que toutes les terres appartenaient à l'état.
Les " représentants " des paysans sont les nouveaux propriétaires.
Dans une Chine sans démocratie, les opinions des étudiants constituent un baromètre politique essentiel.
A l'inverse des ouvriers ou des paysans, les étudiants viennent de tous les niveaux de la société et tout ce qui les mobilise représente le centre d'intérêt de la société à ce moment précis.
Du 15 avril au 4 juin 1989, les étudiants ont manifesté dans le square de Tiananmen et leurs partisans ont réalisé le sondage d'opinion le plus triste de toute l'histoire chinoise, exprimant une volonté commune de mettre fin au totalitarisme, de construire la démocratie et d'éliminer la corruption.
Ceux qui défendent la sanglante répression du Parti contre ces étudiants n'ont aucun droit de se proclamer les représentants de la majorité populaire.
Leur affirmation selon laquelle ils " représentent toujours la direction moderne d'une culture avancée " constitue une autre déclaration suffisante et vide.
La culture chinoise remonte à trois mille ans et couvrira peut-être des milliers d'années dans le futur.
Doit-elle être " toujours représentée " par un parti politique isolé ?
Je ne sais pas ce qu'est " la direction moderne d'une culture avancée ", mais la culture avancée n'a joué aucun rôle dans les campagnes inspirées par le PCC, à savoir " Décimer les mauvaises herbes vénéneuses ", le " Mouvement contre la droite " ou " Eliminer les démons et l'hérésie ".
Un tel obscurantisme crée seulement une culture d'une uniformité débilitante.
Tel un brin d'herbe sous une pierre, la culture sait comment et dans quelle direction chercher la lumière.
Elle n'a nul besoin d'être " représentée ".
Des " Three Represents ", la signification la plus claire figure dans le voeu du PCC de " toujours représenter les demandes des forces productives avancées ".
Cela implique de représenter les intérêts des da-kuan, ceux qui sont subitement devenus riches, généralement grâce à des relations haut placées au gouvernement.
L'expression ne revêt aucune autre signification plus poussée.
L'union du pouvoir et de l'argent dans la Chine d'aujourd'hui prend son origine dans l'augmentation excessive et constante de la bureaucratie.
Avant le Grand bond en avant, les communes pouvaient tout juste accueillir quelques cadres à plein temps.
Aujourd'hui, chaque commune en accueille des centaines.
Leur salaire de base est payé par le gouvernement central, mais les primes et autres avantages dépendent des contributions des " forces productives avancées " au niveau du comté et de la commune.
Tout ce que les riches demandent au PCC (baux fonciers, prêts à intérêts modiques, violation du droit du travail, normes environnementales, contrats et propriété intellectuelle) peut être considéré comme " les demandes des forces productives avancées ".
Même dans des situations moins corrompues, représenter " les forces productives les plus avancées " demeure une idée imparfaite.
Imaginez que le Comité olympique représente uniquement les intérêts des médaillés d'or ou que le Ministère de l'éducation représente uniquement les programmes post-doctoraux et ignore les écoles élémentaires.
Tandis que le secteur de haute technologie qui figure au sommet de la pyramide économique revêt une grande importance, les secteurs traditionnels au bas de la pyramide en forment toujours la base.
Qu'adviendrait-il des centaines de millions de paysans et de chômeurs dans les secteurs d'activité en déclin ?
Qui s'attaquerait à l'inégalité et aux intérêts sociaux divergents ?
Une société de plus en plus pluraliste est poussée dans une structure de type Procruste qui n'autorise qu'une seule voix, qu'un seul besoin et qu'un seul type d'intérêt : la voix, les besoins et les intérêts du parti.
Mais la théorie des " Three Represents " demeure néanmoins nécessaire car une nouvelle situation a émergé.
Lorsque le PCC a accédé au pouvoir en 1948, il a pu affirmer qu'il incarnait le socialisme, le marxisme et la mission historique du prolétariat.
Cinquante ans après, les avantages du socialisme, la vérité du marxisme et le caractère prolétarien du Parti ont tous été défiés de manière irréfutable.
Ainsi, la doctrine des Three Represents constitue un effort pour sauver le règne d'un seul parti.
Vous pouvez douter du socialisme, mais non des " forces productives avancées ".
Vous pouvez ne pas croire au marxisme, mais vous devez croire en une " culture avancée ".
Le PCC ne représente plus les ouvriers et les paysans, mais il peut représenter la " majorité populaire ", y compris les capitalistes " rouges ".
En effet, seule leur acceptation du règne d'un seul parti détermine si les membres du PCC qui sont devenus " révolutionnairement " riches restent " rouges ".
Accueillir des " capitalistes rouges " n'implique donc pas la démocratisation du pays.
Ces individus chercheront très probablement à renforcer leurs privilèges plutôt qu'à promouvoir le pluralisme et le règne de la loi.
Le totalitarisme, et non les réformes politiques, constitue leur gagne-pain.
C'est cet avant tout cet aspect que défend la théorie des Three Represents.
Souvenirs de Zhao Ziyang
Les conditions dans lesquelles Zhao Ziyang vivait au moment de sa mort, en isolation complète de la société chinoise du fait d'une incarcération à domicile, illégale et imposée depuis 16 ans, ne font pas honneur à la justice chinoise et au Parti communiste chinois (PCC).
Les persécutions à l'encontre de Zhao sont celles réservées à un leader qui s'était voué corps et âme pendant plus de dix ans à des efforts novateurs qui ont posé les fondements de la réforme de l'économie chinoise.
A la fin des années 1970, les paysans chinois avaient perdu leurs droits à leur terre depuis longtemps suite à la collectivisation et l'établissement des communes populaires.
C'est un droit qu'ils n'ont jamais reconquis.
Zhao, cependant, fut le premier à défendre le retour à l'autonomie paysanne et initia ainsi le premier test pilote d'abolition des communes populaires.
Les industries chinoises se sont transformées en filiales des organismes gouvernementaux via la nationalisation et la planification centrale.
Zhao fut le premier à proposer « une autonomie étendue des entreprises chinoises » et « la restauration d'une relation saine entre le gouvernement et l'industrie ».
L'autonomie étendue des entreprises et de la paysannerie représente des étapes essentielles dont les succès ont éventuellement mené à une réforme économique totale.
Ce sont là quelques-unes des petites victoires que Zhao remporta pour aider le peuple chinois à se libérer de la stagnation suffocante du socialisme maoïste.
En qualité de numéro 1 chinois, Zhao mit en place dix années de réforme économique qui apportèrent un progrès régulier dans lequel le peuple, particulièrement les paysans, ont bénéficié d'améliorations tangibles.
Et Zhao fut également le seul leader du PCC à proposer une réforme politique pour régler la question du système chinois de parti unique.
Le monopole inattaquable du PCC sur le pouvoir politique assurait systématiquement que toute erreur faite, telle que l'horrible décennie de la Révolution culturelle, se transforme en crise nationale prolongée.
Pour une stabilité réelle et à long terme, Zhao proposa des réformes qui à terme ont visé à légaliser et systématiser la démocratie.
Il avait souhaité établir un type de politique démocratique à même de soutenir et de favoriser une économie de marché saine.
Bien que les objectifs pratiques et à court terme des réformes politiques de Zhao étaient limités par les circonstances dans lesquels ils furent proposés, les mesures visaient toutes à limiter le pouvoir du Parti communiste et représentaient un pas définitif vers un retour pacifique au pouvoir populaire en Chine.
Les propositions de Zhao, tranchant d'avec le totalitarisme de Mao, furent approuvées par le 13ème congrès du Parti, la plus haute autorité officielle au sein du PCC.
Durant les vingt mois qu'il passa servir en qualité de Secrétaire Général du PCC, Zhao créa une culture au sein de laquelle le Bureau politique choisit de ne pas interférer avec les tribunaux, et il stoppa toute tentative de contrôle sur la littérature et les arts.
Zhao abolit la politique selon laquelle les entreprises étaient gérées par des organisations liées au Parti et le système qui faisait des fa ren (les « représentants légaux ») le cœur des entreprises.
Malheureusement, les réformes politiques de Zhao prirent fin quand il fut déchu du pouvoir.
Le terrible résultat qui s'ensuivit fut le déni sans distinction de tous les droits civiques et de tous principes démocratiques et la montée de ce que les leaders d'aujourd'hui appellent « le socialisme à caractéristiques chinoises », euphémisme amer pour décrire un pouvoir partisan et gouvernemental débridé lié aux intérêts commerciaux.
Le sort de Zhao est également un rappel glacial d'autres injustices qui reposent sur la conscience de ceux qui sont aujourd'hui au pouvoir.
La seule raison qui a permis de continuer à ainsi mal traiter Zhao fut son opposition à la répression violente des manifestations de la place Tienanmen en 1989.
Ces événements relevaient de son pouvoir de décision en qualité de Secrétaire Général, mais rien ne se produisit comme il aurait fallu à ce moment-là. Il faut se rappeler que l'ancien Secrétaire général, Hu Yaobang, forcé par Deng Xiaoping de se retirer deux ans auparavant à cause de ses prises de positions libérales, mourut en avril 1989, déclenchant des manifestations estudiantines spontanées et pacifiques à Beijing, qui se propagèrent dans tout le pays.
Un demi million d'étudiants rien qu'à Beijing se sont impliqués dans ce mouvement.
Il dura 50 jours et fut soutenu avec ardeur par les habitants de Beijing et d'autres un peu partout dans le pays, issus de tous horizons socioprofessionnels.
Zhao fit remarquer au Bureau politique que les sentiments exprimés par ces étudiants et résidents dans leur commémoration de Hu, dans leurs manifestations contre la corruption et leur désir de démocratie étaient en fait identiques à ceux qu'eux-mêmes ressentaient.
Il pensait qu'il devait être possible de résoudre la crise estudiantine tout en respectant les principes démocratiques et la primauté de la règle de droit.
Sous la direction de Zhao, le Bureau politique et son Comité permanent appelèrent au dialogue avec les étudiants.
Cette direction pleine d'espoir changea complètement, cependant, quand Deng Xiaoping montra son désir de répression violente.
Finalement, tout cela se réduisit à un combat entre cinq membres du Bureau politique et du Comité central : Li Peng et Yao Yiling, qui souhaitaient déployer l'armée.
Zhao s'y opposa.
Qiao Shi et Hu Qili qui prirent position avec Zhao dans un premier temps avant de lui retirer leur soutien et de demander alors à Deng Xiaoping de prendre une décision finale.
Ces profondes divisions mises à jour, Deng choisit de ne pas tenir compte des institutions en place et d'ignorer le Bureau politique et le Comité central du Parti, ainsi que le Congrès national du peuple et son Comité central.
Sans plus de discussions, Deng mobilisa 500 000 hommes pour entrer dans Beijing et monter à l'assaut des étudiants et civils désarmés.
Le massacre de la Place Tienanmen en 1989 fut une tragédie en Chine, une nouvelle tragédie pour le vingtième siècle.
Seize ans se sont écoulés mais la souffrance est toujours là, enfouie dans les cœurs et les esprits du peuple.
Au fil des années qui se sont écoulées, les leaders chinois furent responsables non seulement de l'emprisonnement à domicile de Zhao mais également des efforts systématiques entrepris pour effacer son nom de l'Histoire.
Pourtant, leurs tentatives pour masquer la vérité sur les événements passés ne révèlent que leur faiblesse et leur impudence.
Parce qu'une chose ne changera jamais : Zhao Ziyang nous accompagne, dans la lutte ininterrompue du peuple chinois pour ses droits et la démocratie.
Nouveau départ pour la non-prolifération
Obama s'est engagé à revitaliser un régime vacillant de non-prolifération, dont le Traité de non‑prolifération (TNP) des armes nucléaires de 1970 est la pierre angulaire.
Il n'est pas difficile d'identifier les problèmes majeurs.
Premièrement, les cinq grands Etats nucléaires n'ont pas pris au sérieux l'obligation de mesures de désarmement souscrite avec le TNP.
Au lieu de cela, ils mettent en avant le fait que les armes nucléaires sont essentielles à leur sécurité et poursuivent la modernisation de leurs arsenaux nucléaires -- ce qui les prive naturellement de l'autorité morale de convaincre les autres pays de ne pas acquérir d'armes nucléaires, toujours perçues comme source de pouvoir et d'influence, et comme police d'assurance contre d'éventuelles attaques.
Deuxièmement, comme on l'a vu avec la Corée du Nord, rien n'empêche les pays signataires de simplement déclarer que des « événements extraordinaires » ont mis en péril leurs intérêts suprêmes pour se retirer.
Troisièmement, l'Agence internationale de l'énergie atomique, censée contrôler le système de non-prolifération, dispose de si peu de fonds que c'en est scandaleux.
Pour savoir si tel ou tel pays poursuit ou non un programme clandestin d'armes nucléaires, les inspecteurs de l'AIEA ont la plupart du temps les mains liées soit parce qu'ils n'ont pas l'autorité légale nécessaire pour accéder aux lieux qu'ils jugent bon d'examiner, soit parce que les laboratoires d'analyse de l'Agence sont obsolètes, soit encore parce que l'Agence ne dispose pas d'un accès approprié à l'imagerie satellite.
Quatrièmement, les contrôles des exportations n'ont pas réussi à empêcher la diffusion d'une technologie nucléaire sensible, notamment à cause des activités très élaborées de réseaux clandestins comme celui dirigé par A.Q. Khan, scientifique nucléaire pakistanais.
Neuf pays disposent déjà d'armes nucléaires et il serait naïf de supposer que d'autres, en particulier dans les régions de conflit, ne tenteront pas de s'en procurer.
Par ailleurs, certains pays dotés de programmes d'énergie nucléaire pourraient, s'ils le souhaitaient, fabriquer des armes nucléaires en quelques mois si leur perception de la sécurité changeait, vu qu'ils maîtrisent déjà les techniques de base d'enrichissement de l'uranium et de retraitement du plutonium.
Ce choix pourrait être le talon d'Achille de la non-prolifération.
Cinquièmement, la communauté internationale, menée par le Conseil de sécurité des Nations Unies, a souvent été paralysée par des difficultés de sécurité internationale, et inefficace pour réagir aux cas suspects de prolifération nucléaire.
Certes, ces difficultés ne pourront être surmontées du jour au lendemain, il est tout de même possible de faire beaucoup en relativement peu de temps.
Les Etats-Unis et la Russie ont entamé des négociations sur d'importantes réductions de leurs arsenaux nucléaires, qui représentent 95 % des 27.000 ogives nucléaires de la planète.
Parmi les autres mesures qu'il conviendrait de prendre, citons l'entrée en vigueur du Traité d'interdiction complète des essais nucléaires, la négociation d'un traité vérifiable pour mettre fin à la production de matériel fissile destiné à l'armement ; l'amélioration radicale de la sécurité physique de matériaux nucléaires et radioactifs, essentielle pour empêcher ces derniers de tomber entre les mains de terroristes ; et la consolidation de l'AIEA.
Le mois dernier, j'ai proposé au Conseil des gouverneurs de l'AIEA une mesure clé de renforcement de la non-prolifération : la création d'une banque d'uranium faiblement enrichi de l'AIEA utilisable par les pays qui ont besoin de combustible nucléaire pour leurs réacteurs.
Cet uranium ne peut être utilisé pour construire des armes.
Un mécanisme de ce type sera indispensable dans les décennies à venir vu le nombre croissant de pays à se tourner vers l'énergie nucléaire.
Ma proposition consiste à créer une réserve physique d'uranium faiblement enrichi à disposition de l'AIEA, qu'utiliseront en dernier ressort les pays qui rencontrent des difficultés d'approvisionnement pour des raisons non commerciales.
Les pays concernés seraient rassurés de pouvoir compter sur des réserves d'énergie fiables pour faire tourner leurs centrales, et n'auraient donc pas besoin de développer leur propre capacité d'enrichissement de l'uranium ou de retraitement du plutonium.
Cela contribuerait à éviter que ne se reproduisent des expériences telles que celle de l'Iran après sa révolution de 1979, lorsque les contrats pour le combustible et la technologie prévus dans le cadre de son programme nucléaire n'étaient pas honorés.
Trente ans plus tard, on en ressent encore certaines conséquences.
L'uranium faiblement enrichi sera mis à disposition des pays dans le besoin sur la base de critère non politiques et non discriminatoires, aux prix du marché, conformément à leurs obligations de garanties nucléaires.
Aucun Etat ne serait donc contraint d'abandonner le droit de créer son propre cycle du combustible.
Les fonds nécessaires au lancement d'une banque d'uranium faiblement enrichi sont en place, principalement grâce à une organisation non gouvernementale  -- Nuclear Threat Initiative -- et au financement initial de Warren Buffett.
Cette banque ne serait qu'une première étape, qui devra être suivie d'un accord faisant passer l'ensemble des activités d'enrichissement et de retraitement du contrôle national au contrôle exclusivement multinational.
Cette idée est audacieuse, mais plus que jamais nécessaire.
Il y a soixante ans, nous manquions l'occasion de placer le cycle du combustible nucléaire sous contrôle multinational à cause de la guerre froide.
Aujourd'hui, compte tenu de la diffusion de la technologie nucléaire et du risque croissant de terrorisme nucléaire, nous n'avons pas le droit à l'erreur.
Un coin de l'Europe au désespoir
--  Trois niveaux du parlement moldave sont en ruine, calcinés.
En Moldavie, république de l'ex-URSS devenue le pays le plus pauvre d'Europe, la démocratie a subi le même sort.
Sur les 3,5 millions d'habitants à l'époque de l'indépendance, 15 % ont déjà quitté le pays à la recherche d'une vie meilleure sur d'autres terres ; et plus de 63 % des jeunes déclarent vouloir partir.
Début avril, la victoire controversée aux législatives du parti communiste à la tête du pays a déclenché une manifestation.
Des membres de l'opposition et des rebelles, jeunes sans perspective d'avenir pour la plupart, sont descendus dans la rue.
Une minorité violente a fait irruption dans le palais présidentiel et le parlement a été mis à feu.
Pour toute réponse, les communistes ont imputé la violence aux membres de l'opposition surnommés « fascistes » et à la Roumanie et ses irrédentistes vivant en Moldavie.
La police s'en est pris aux jeunes et en a placé une centaine en détention.
Plusieurs sont, semble-t-il, morts de coups.
Le président Vladimir Voronine a par la suite amnistié les détenus.
Il en reste néanmoins beaucoup en prison et Voronine continue d'accuser l'opposition et la Roumanie d'avoir fomenté un coup d'état.
Des poursuites judiciaires ont été entamées.
Il importe de restaurer la stabilité et un système démocratique équitable en Moldavie, tout d'abord car les habitants méritent d'avoir un gouvernement sur lequel s'appuyer.
Cette stabilité compte aussi beaucoup car le pays est voisin de la Roumanie, un état membre de l'Union européenne.
Ces deux pays partagent une même langue et une même culture. Et, jusqu'à ce que Staline les séparent, ils faisaient du reste partie d'un même état.
Une minorité qui se fait entendre pense que fusionner avec la Roumanie permettrait à la Moldavie d'accéder plus rapidement au statut d'état membre de l'UE, avec ses avantages financiers, et surtout ses passeports permettant de fuir une économie sans espoir pour construire une nouvelle vie ailleurs.
Il se trouve en effet que de nombreux Moldaves possèdent déjà un passeport roumain afin de voyager et travailler dans l'UE.
Un quart de la population (un million de citoyens moldaves) a déjà profité de l'octroi de passeports roumains facilité par certains officiels roumains, y compris le président Traian Basescu.
Mais toute tentative d'attirer ses citoyens à l'extérieur fait bien sûr hésiter le gouvernement moldave.
Toute action états-unienne pour aider à restaurer la stabilité en Moldavie serait bienvenue.
De concert avec l'Union européenne, les Etats-Unis peuvent assurer une investigation sur la violence post-électorale et sur les plaintes portées contre la police.
Les Etats-Unis devraient faire preuve de plus de dynamisme en exigeant que les autorités moldaves respectent l'état de droit, établissent une liste de tous les détenus, leur permette de rencontrer un avocat et les membres de leur famille et garantissent qu'ils ne sont pas molestés.
Les leaders de l'opposition et certains organismes de surveillance démocratiques avancent que, dans le fond, les élections moldaves étaient truquées.
Les médias nationaux, en particulier les chaînes de télévision, auraient accordé un temps d'antenne disproportionné aux communistes durant la campagne électorale.
Ces derniers sont de plus accusés d'avoir manipulé les voix (ajout de noms sur les listes) et d'avoir ressuscité les morts.
Sur le long terme, les Etats-Unis et l'Union européenne devraient soutenir la société civile et ses organisations en pressant le gouvernement moldave : de garantir un temps d'antenne équitable, de cesser le harcèlement policier envers les dirigeants politiques de l'opposition, les travailleurs et les journalistes, de réformer la police et de mettre fin aux abus du parti au pouvoir sur les institutions nationales, et de permettre à tous les partis politiques d'avoir une chance d'inspecter les listes électorales et de surveiller les lieux de vote.
Ils devraient insister pour établir un dialogue entre l'opposition et le parti au pouvoir.
En plaçant leur aide financière sous conditions, les Etats-Unis donneront du poids à leur requête.
L'UE a davantage de marge de manœuvre : la Moldavie en dépend encore plus que toute autre ancienne république soviétique.
Plus de la moitié de ses échanges commerciaux se font avec l'UE,  et la Moldavie reçoit un soutien financier important de sa part.
La majeure partie des émigrés moldaves travaillent dans l'Union et 75 % de la population souhaitent adhérer à l'UE.
La Roumanie aussi devrait jouer son rôle et offrir de signer un traité fondamental et un accord frontalier avec la Moldavie.
La dernière chose dont les Moldaves appauvris ont besoin est un gouvernement autocratique et irresponsable qui manque d'imagination pour faire renaître le pays.
Et la dernière chose dont l'UE a besoin est l'afflux de centaines de milliers de migrants fuyant la pauvreté, la répression politique et le désespoir en Moldavie et dans d'autres pays de l'ex-union soviétique.
Pauvre petit pays riche
Il est difficile d'éprouver de la compassion pour la Norvège : grâce à ses réserves importantes de pétrole en Mer du Nord, le pays a atteint un niveau de richesses inimaginable un peu moins d'une génération plus tôt.
Ce qui lui a permis de battre froid l'Union européenne depuis 1994. Mais les problèmes de la Norvège, bien loin d'être aussi dramatiques que ceux de l'Afrique sub-saharienne ou de l'Afghanistan, n'en sont pas moins suffisamment sérieux pour provoquer l'inquiétude, à défaut de pitié.
Quand l'abondance d'une ressource naturelle fraîchement découverte par un pays mène à une richesse inattendue, les investissements dans les autres secteurs économiques se détournent du secteur exportable (principalement des exportations de produits manufacturés) pour s'orienter vers le secteur non-exportable (principalement le secteur des services et des biens de consommations).
Ce diagnostic est commun et connu sous le nom de « syndrome hollandais ».
Quand la ressource naturelle ayant généré cette richesse inattendue (ici le pétrole et le gaz) disparaît, l'économie n'a plus assez d'industries compétitives et bien trop de librairies-cafés vides.
S'en suit alors une restructuration très coûteuse.
Jusqu'à présent, la Norvège a évité les pires pièges du syndrome hollandais en utilisant ses revenus pétroliers, très importants, pour mettre en place un système d'épargne national, le Fonds pétrolier, qui n'est autorisé à investir que dans des actifs étrangers.
Cette réglementation a permis de réguler la pression de la demande inflationniste tout en empêchant les élus politiques de dilapider la richesse nationale dans des projets politiquement satisfaisants mais économiquement peu viables.
Dans ces deux domaines, cependant, la Norvège vient de céder du terrain et se dirige droit vers les ennuis.
Les salaires sont montés en flèche dans tous les secteurs économiques, avec une hausse moyenne de 6% prévue pour cette année.
En retour, les entreprises ont monté les prix, ce qui alimente l'inflation.
Pourtant, la Banque centrale s'est engagée à maintenir l'inflation aux alentours des 2,5%, et de ce fait les taux d'intérêt norvégiens sont les plus élevés d'Europe.
Ceci a permis aux taux de change de se renforcer de 10% l'an dernier par rapport aux monnaies des principaux partenaires commerciaux de la Norvège, entraînant un plus grand manque de compétitivité de son secteur d'exportation.
Les industries locales confrontées à la concurrence étrangère commencent maintenant à mettre la clé sous la porte ou à se délocaliser à l'étranger.
Ainsi le chômage augmente dans l'un des plus riches pays au monde.
Mais le vrai problème se pose dans le secteur public.
Les dépenses gouvernementales s'accroissent de 4% par an à cause d'une nouvelle « réglementation d'action », mise en place en 2001, qui permet l'injection dans l'économie intérieure de revenus issus du Fonds pétrolier.
Pourtant, ce revenu budgétaire supplémentaire n'a que peu fait baisser les impôts tandis que les salaires et les taux d'intérêt élevés font grimper les dépenses publiques.
Il faut donc ainsi toujours plus de mannes publiques pour maintenir le niveau des services publics et le chômage à un bas niveau.
Ce cercle infernal prend aussi d'autres allures dangereuses : l'augmentation des taux d'intérêt, variation en hausse des cours d'une monnaie sur les marchés des changes, la décimation avancée du secteur des exportations, et le risque d'un chômage accru.
Si la Norvège veut éviter de succomber au syndrome hollandais, il n'y a qu'une seule solution : l'importance du marché des exportations diminuant, il faut que le secteur des biens et services accroisse sa productivité et sa production.
Il n'existe qu'une seule manière de parvenir à des gains de production et de productivité : le surplus de la demande dans le secteur public doit être reporté ailleurs.
Après tout, la demande ne disparaîtra pas d'elle-même.
Les listes d'attente pour les soins médicaux et infirmiers paraissent déjà sans fin en Norvège, et les bâtiments scolaires se dégradent, certains ayant même dû être fermés par les autorités sanitaires.
Il faudrait donc privatiser un certain nombre de services publics.
Comme toujours dans ces cas-là, ce sera un processus politique litigieux et difficile mais il fournira aussi la possibilité de réaliser le potentiel du pays grâce à une stratégie d'investissements sensés : ce à quoi était destiné le Fonds pétrolier à l'origine.
Cette stratégie devra s'accompagner d'investissements humains importants en matière d'éducation, de formation et de recherche scientifique fondamentale.
Même si les idées de génies ne nous viennent pas sur commande.
Tout effort gouvernemental pour soutenir une industrie mourante ou pour allouer des subventions en choisissant des projets « novateurs » de toutes sortes ira droit à la catastrophe économique.
Comme si souvent de par le monde, les richesses inattendues qui ont fait le bonheur de la Norvège grâce au pétrole et au gaz peuvent se révéler tout autant dangereuses que positives.
Avec des réserves estimées à 10 à 15 années de production, les Emirats arabes unis ont abandonné toute exigence particulière dans l'accord de visas aux occidentaux pour accélérer le développement d'une industrie du tourisme viable.
Le Kazakhstan lui n'en est qu'au début de cette aventure avec la découverte récente des énormes réserves de la Mer Caspienne.
Ces pays, tout comme la Norvège, ont gagné à la loterie des ressources naturelles, mais ce n'est en aucun cas la garantie qu'ils resteront riches quand elles seront épuisées.
Sortir du bourbier tibétain
Il y a un an, les intellectuels chinois et occidentaux se sont surpassés pour attribuer l'engouement du peuple pour le Tibet à une confusion puérile avec la vallée fictive Shangri-la issue d'un film de 1937 intitulé Lost Horizon .
Mais comme les manifestations tibétaines antichinoises de ces 12 derniers mois s'élèvent à plus de 150, il ne semble pas du tout fantaisiste de s'en inquiéter.
En effet, dans la catégorie facteur de stabilité régionale et souci majeur de relations internationales, le Tibet pourrait bientôt supplanter Taiwan.
Les régions peuplées par les Tibétains couvrent désormais un quart de la Chine. Une si vaste partie du territoire coupée du monde extérieur et placée sous contrôle militaire discrédite la légitimité et le statut de puissance mondiale revendiqués par le parti communiste.
Les manifestations de l'an passé au Tibet ont été les plus massives et les plus importantes depuis des décennies.
Ont pris part : des nomades, des fermiers et des étudiants, qui auraient en théorie dus être très reconnaissants à la Chine d'avoir modernisé l'économie de leur pays.
Nombre d'entre eux arboraient le drapeau du Tibet -- interdit -- montrant bien qu'ils considèrent que c'était un état à part entière dans le passé. Des bureaux officiels ont été mis à feu lors d'environ 20 incidents.
On dénombre même un cas d'agression de migrants chinois, causant la mort de 18 personnes.
Difficile de ne pas voir combien ces événements mettent le régime chinois au défi.
Le gouvernement chinois a réagi en imputant le problème à des complots extérieurs.
Il a envoyé plus de troupes, a dissimulé les détails de la mort de manifestants, a condamné à perpétuité un éducateur de prévention HIV qui avait illégalement copié des CD en provenance d'Inde et a banni, des mois durant, des journalistes et des étrangers du plateau tibétain.
En direct sur une chaîne nationale en novembre dernier, des officiels chinois ont ridiculisé les propositions de négociation d'exilés tibétains.
La Chine a même annulé un sommet avec l'Union européenne en raison d'une rencontre entre le président français Nicolas Sarkozy et le dalaï-lama et sous-entend régulièrement que les Tibétains sont des terroristes.
Le 28 mars à Lhassa, les Tibétains ont dû célébrer « la journée de l'émancipation des serfs », avalisant ainsi les arguments utilisés par la Chine pour justifier sa prise de pouvoir de 1959.
Mais cette terminologie teintée de lutte des classes rappelle la révolution culturelle. Or, comme un tel discours est aujourd'hui inimaginable à l'intérieur de la Chine, son seul effet est de singulariser davantage le Tibet.
Même si les deux camps se disent prêts à discuter, c'est un dialogue de sourds : les exilés souhaitent négocier sur la base de leurs propositions d'autonomie tandis que la Chine affirme ne vouloir aborder que le sujet du « statut personnel » du dalaï-lama -- qui vivrait à Pékin s'il devait revenir en Chine.
L'affrontement viscéral se poursuit lorsque le chef spirituel décrit la vie des Tibétains sous le joug chinois comme « un enfer sur terre ».
Sans doute faisait-il référence à leur vie sous Mao plutôt que leur vie actuelle, mais ses remarques ont permis à la Chine de déclencher davantage d'attaques médiatiques et de faire monter la température politique.
Les gouvernements occidentaux ont été taxés d'ingérence. Il est pourtant peu probable qu'aucun d'entre eux souhaite faire dérailler ses relations avec la Chine, surtout en temps de crise économique.
En octobre dernier, le Ministre britannique des affaires étrangères David Miliband était si soucieux de plaire à la Chine qu'il a failli accuser ses prédécesseurs d'avoir reconnu l'autonomie du Tibet cent ans auparavant.
A l'échelle internationale, la question du mandat de la Chine sur le Tibet est compréhensible : le Tibet est un haut plateau stratégique situé entre deux grandes puissances nucléaires asiatiques.
Bien gouverner le toit du monde est un bien public.
La Chine pourrait aider à diminuer les tensions croissantes en admettant que ces questions sont raisonnables.
Le dalaï-lama pourrait ralentir ses rencontres internationales et reconnaître que, malgré l'émasculation par la Chine de toute vie intellectuelle et religieuse au Tibet, certains aspects de la culture tibétaine (comme l'art moderne, le cinéma et la littérature) se portent plutôt bien.
Les observateurs occidentaux pourraient accorder aux exilés que leurs propositions d'autonomie sont négociables et non des facteurs trop décisifs, plutôt que de les envoyer paître avant d'entamer des pourparlers.
Les deux camps gagneraient à s'intéresser à deux officiels tibétains qui ont osé prendre la parole en Chine le mois dernier. Un gouverneur à la retraite de la préfecture de Kardze a déclaré au journal singapourien Zaobao que « le gouvernement devrait faire plus confiance à la population, et en particulier aux moines tibétains ».
Le gouverneur actuel du Tibet a reconnu que certains des manifestants de l'an dernier n'étaient pas « satisfaits par [leurs] mesures » sans pour autant les qualifier d'ennemis de l'état. La Chine concédait alors pour la première fois que les manifestations pouvaient être liées à l'impopularité de ses mesures.
Jusqu'à présent, le Parti a suivi une stratégie plus conventionnelle : il a envoyé une délégation d'officiels aux Etats-Unis la semaine dernière (la première, d'après eux, à être exclusivement composée de Tibétains, fait plutôt embarrassant à reconnaître). Le porte-parole, Shingtsa Tenzin Choedak, a expliqué aux journalistes que les Tibétains bénéficiaient de la liberté de culte.
Or, toute personne ayant récemment travaillé au Tibet le sait bien : cette déclaration est inexacte car, depuis 1996 au moins, tous les tibétains qui travaillent pour le gouvernement et tous les tibétains étudiant dans leur pays n'ont pas le droit de pratiquer le bouddhisme. Pourtant, la loi chinoise interdit d'empêcher toute personne de pratiquer une religion officielle.
Le Gouvernement chinois pourrait immédiatement améliorer la situation en se séparant des officiels responsables de telles mesures illégales, et en s'excusant auprès des Tibétains pour n'avoir pas prêté attention aux abus de ces 15 dernières années.
Il pourrait aussi commencer par réévaluer sa politique tibétaine plutôt que de renforcer contrôles et allégations.
Sans quoi, la quête de la Chine vers un respect d'envergure internationale continuera de se dérober et le Tibet demeurera sans aucun doute à l'ordre du jour des affaires internationales.
L'Europe et la crise alimentaire mondiale
Mais trouver une solution va au-delà de la simple identification des pays capables de nourrir le reste du monde.
Il est de plus en plus urgent que chaque nation soit en mesure de se nourrir elle-même.
Cela signifie que l'agriculture doit devenir une priorité internationale, avec une aide octroyée aux pays les plus pauvres pour qu'ils établissent l'indépendance et la sécurité de leur approvisionnement alimentaire.
Les pays et les organisations internationales commencent déjà se mobiliser.
L'organisation des Nations unies pour l'alimentation et l'agriculture estime que l'augmentation du prix des aliments comporte le risque d'un accroissement des conflits mondiaux.
Le Forum économique mondial de Davos a fait de l'insécurité alimentaire l'un des principaux risques mondiaux.
La Banque mondiale a vigoureusement souligné l'importance de l'agriculture pour faire démarrer l'expansion économique et briser le cercle vicieux de la pauvreté.
Ban Ki-moon, le secrétaire général des Nations unies, a mis sur pied un groupe de travail pour élaborer un plan d'action commun, et Nicolas Sarkozy, le président français, a proposé un partenariat mondial pour l'alimentation et l'agriculture.
Cette proposition de partenariat repose sur trois piliers.
Le premier est la création d'un groupe international chargé de définir une stratégie mondiale pour la sécurité alimentaire.
Le deuxième est la mise sur pied d'un groupe international de scientifiques chargé d'évaluer la situation de l'agriculture mondiale, d'alerter sur les risques de crise, et éventuellement de faciliter l'adoption par les gouvernements de mesures politiques et stratégiques pour faire face aux crises alimentaires.
Et le troisième est de mobiliser la communauté financière internationale, malgré ses problèmes actuels.
La taille et la fiabilité de la production agricole de l'Union européenne signifient qu'elle peut et doit jouer le rôle de régulateur des marchés mondiaux.
Si l'Europe réduisait sa production agricole, l'augmentation de ses importations contribuerait nettement à une hausse du prix des denrées alimentaires.
Pour cette raison, le niveau de production agricole de l'UE doit rester stable -- à la fois dans l'intérêt des Européens et des populations des pays les plus pauvres.
Mais l'Europe ne peut pas développer son agriculture au détriment des moins fortunés, et l'UE doit donc harmoniser sa politique avec les pays plus pauvres.
Aujourd'hui, les subventions à l'exportation et autres mesures de soutien représentent moins de 1 pour cent du budget agricole européen, et l'UE a entrepris de les éliminer une fois que les principaux pays exportateurs auront pris des mesures analogues.
Depuis 2001, avec le règlement dit « Tout sauf les armes », tous les produits des pays les moins avancés -- à l'exception des armes et des munitions -- peuvent accéder au marché unique de l'UE en franchise de douanes, faisant ainsi de l'UE le principal marché des produits de ces pays.
L'UE cherche parallèlement à répondre aux nouveaux défis en réformant sa politique agricole commune, comme le montre son récent abandon des jachères obligatoires.
Aujourd'hui l'UE se prépare à augmenter progressivement les quotas laitiers, et à évaluer l'impact de sa décision concernant les biocarburants sur les marchés mondiaux.
Mais le souci premier de l'Europe doit être d'encourager le développement des agricultures au plan local, le seul moyen d'améliorer la sécurité alimentaire mondiale et de réduire la pauvreté.
Cette préoccupation devrait également permettre de garantir que les prix élevés actuels des produits agricoles profitent aux agriculteurs des pays pauvres.
Cette évolution est vitale, parce que selon des estimations de la Banque mondiale, la croissance dans le secteur agricole contribue deux fois plus à réduire la pauvreté que la croissance dans d'autres secteurs de l'économie.
L'agriculture reste en effet le principal secteur productif des économies les moins avancées, employant près de 65 pour cent de la population active et contribuant à plus de 25 pour cent du PIB.
Mais au cours des vingt dernières années, le soutien au développement de l'agriculture a décliné.
Le montant alloué à l'agriculture ne s'élève qu'à 4 pour cent de l'aide au développement.
La Commission européenne et les États membres de l'UE prévoient en conséquence d'accroître le montant de l'aide, à la fois par le biais du Fonds européen de développement et en trouvant de nouvelles sources de soutien financier.
Une plus grande libéralisation du commerce agricole ne garantira pas la sécurité alimentaire.
Face à la nature erratique des marchés agricoles, une réglementation est nécessaire pour amortir la volatilité des prix des denrées alimentaires pour les pays les plus pauvres.
Cela ne signifie pas pour autant que le protectionnisme est la voie à suivre, mais seulement que prendre en compte des questions spécifiques affectant le commerce agricol international -- conditions climatiques, volatilité des prix, risques sanitaires -- peut être parfois nécessaire.
Mais dans un monde où les différences de productivité peuvent être de l'ordre du 1 pour 1000, il serait peu raisonnable de compter uniquement sur les marchés pour permettre aux pays les moins avancés de développer leur économie.
Il n'est pas non plus réaliste de s'attendre à une expansion économique résultant d'une concurrence entre distributeurs et producteurs multinationaux dans des pays où rode encore la famine.
Mais rassembler l'expertise extérieure et les compétences locales concernant la géographie et les contraintes environnementales et économiques, de manière à répartir les risques et partager la gestion des ressources et des projets, est une démarche bien plus à même d'aider les pays les plus pauvres à obtenir leur indépendance alimentaire.
C'est cette approche qui a permis, en moins de 20 ans, à l'Europe d'après-guerre d'établir sa souveraineté alimentaire.
Les pays, comme l'Inde et le Vietnam, qui ont choisi de protéger le développement de leur agriculture des aléas du marché ont obtenu une réduction substantielle de la pauvreté dans les zones rurales.
Le temps est venu de donner la priorité à l'agriculture, de manière à assurer une croissance avec un visage plus humain.
Au coeur de l'Union européenne, la France souhaite jouer son rôle dans un effort collectif qui devient rapidement un sujet de préoccupation pour nous tous.
Le capitalisme managérial se distingue par des économies où de grandes sociétés -- souvent les soi-disant « fleurons nationaux » - dominent la production et l'emploi.
Les entreprises plus petites existent également, mais ce sont en général des commerces de détail ou de services avec seulement quelques employés.
Ces sociétés grandissent en réalisant des économies d'échelle, en raffinant et en produisant en série les innovations radicales des entrepreneurs (voir plus bas).
Les économies d'Europe occidentale et du Japon sont les principaux exemples du capitalisme managérial, qui comme le capitalisme d'État, ont donné lieu à de fortes performances économiques.
Mais le capitalisme managérial a lui aussi son talon d'Achille.
Les entreprises bureaucratiques sont typiquement réticentes à prendre de gros risques -- c'est-à-dire à développer et à commercialiser les innovations radicales qui repoussent la frontière des possibilités de production, produisant des sauts de productivité importants et durables et de ce fait une croissance économique soutenue.
Les grosses entreprises ne répugnent pas seulement à prendre des risques parce qu'elles sont bureaucratiques, avec plusieurs échelons de direction nécessaires pour approuver toute innovation, mais aussi parce qu'elles hésitent à soutenir de nouveaux projets qui pourraient rendre obsolètes les produits ou les services qui sont à l'origine de leurs profits présents.
À notre avis, les limites du capitalisme managérial expliquent pourquoi l'Europe occidentale et le Japon, après avoir approché le niveau américain de revenu par personne à la fin des années 1980, n'ont pas profité comme les Etats-Unis du rebond de productivité lié aux nouvelles technologies à la fin des années 1990.
Ce qui nous amène à la quatrième forme de capitalisme : le capitalisme entrepreneurial .
Les économies dont le dynamisme tient à la création de nouvelles entreprises ont toujours commercialisé les innovations qui repoussent la frontière des possibilités de production.
Les exemples des deux derniers siècles comprennent les innovations et les produits à effet transformateur tels que les trains, les voitures et les avions ; le télégraphe, téléphone, radio et télévision ; la climatisation ; et comme mentionné plus haut, les nouvelles technologies ayant permis la révolution de l'information, que ce soit les ordinateurs portables ou les serveurs centraux, les routeurs wifi et autres matériels informatiques, et tous les logiciels qui permettent de s'en servir.ar
Il est certain qu'aucune économie ne peut réaliser tout son potentiel en n'étant qu'entrepreneuriale.
La combinaison optimale d'entreprises comprend une bonne dose de grandes sociétés, qui ont les ressources financières et humaines pour raffiner et produire en série les innovations radicales, avec une pincée de nouvelles entreprises.
Le dilemme du paracétamol
La substitution de l'aspirine par le paracétamol conduirait, d'après les recherches, à une réponse immunitaire allergique plus prononcée, augmentant de ce fait la susceptibilité à l'asthme et à d'autres allergies.
Diverses études épidémiologiques ont depuis dégagé un lien entre l'asthme et une exposition au paracétamol dans l'utérus, durant l'enfance et l'adolescence.
En fin de compte, ces études suggèrent que l'usage du paracétamol constituerait un facteur de risque important dans l'apparition de l'asthme.
Les résultats d'une étude épidémiologique d'envergure internationale sur l'asthme infantile récemment publiée dans la revue médicale The Lancet viennent corroborer cette hypothèse.
L'analyse, faite par l'International Study of Asthma and Allergies in Childhood (ISAAC, Centre d'étude international sur l'asthme et les allergies infantiles) portait sur plus de 200�000 enfants âgés de six et sept ans dans 73 centres de 31 pays.
Les parents ou tuteurs ont répondu à un questionnaire écrit sur les symptômes actuels de l'asthme, de la rhinite (rhume des foins) et de l'eczéma, et sur d'autres facteurs de risques, y compris l'usage du paracétamol pour soulager la fièvre d'un enfant de moins de 12 mois et la fréquence de la prise de paracétamol au cours des 12 derniers mois.
L'étude a mis en évidence un lien entre l'usage du paracétamol pour traiter une fièvre dans la première année de vie et la présence de symptômes de l'asthme chez les enfants de six et sept ans.
Ce lien, notable à l'échelle de toute la planète, causerait une augmentation des risques de 46�% (cette estimation prend en compte d'autres facteurs de risque.
La seconde observation porte sur la quantité de paracétamol ingéré au cours des 12�derniers mois et les symptômes de l'asthme chez les 6-7 ans.
D'autres liens entre la prise de paracétamol et la propension à de graves risques d'asthme ont aussi été démontrés.
La proportion de cas asthmatiques pouvant être dus à l'exposition au paracétamol irait de 22�% à 38�%.
De similaires observations ont été faites, associant la prise de paracétamol à la fois dans la première année de vie et chez les enfants de 6 et 7 ans avec une augmentation des risques des symptômes de la rhinite et de l'eczéma.
Ce qui laisse supposer que les éventuels effets du paracétamol ne se limitent pas aux voies respiratoires, mais peut aussi affecter divers organes.
L'étude n'identifiaient aucun mécanisme éventuel à l'origine du lien entre le paracétamol et l'asthme (et autres allergies).
Mais d'autres chercheurs ont soumis divers mécanismes plausibles, essentiellement liés aux effets négatifs du paracétamol sur la faculté du corps à résister au stress oxydant et à l'éventuelle amélioration de sa réponse immunitaire allergique.
Les auteurs insistent sur le fait qu'un lien de cause à effet ne peut être établi rétrospectivement en raison d'autres paramètres faussant l'étude. Par exemple, l'interaction entre une infection virale du système respiratoire telle que le virus respiratoire syncytial (RSV) et un risque accru d'asthme infantile tardif est notoire, donc l'analyse de la prise de paracétamol aurait été faussée dans ce type de cas. 
L'étude alimente le débat sur les avantages du traitement de la fièvre chez les enfants, une question traitée très complètement par Fiona Russel et d'autres confrères dans le Bulletin de l'Organisation mondiale pour la santé (OMS).
Ils avancent que les preuves scientifiques à disposition montrent que la fièvre est une réponse universelle, atemporelle et généralement positive, aux infections et que son traitement présente peu d'avantages tangibles, si ne n'est aucun. 
Au contraire, ils suggèrent que supprimer la fièvre pourrait parfois avoir des effets néfastes et concluent qu'il est préférable de ne pas encourager l'usage répandu de médicaments pour faire baisser la fièvre.
Pour ce qui est des enfants, ils limitent leurs recommandations d'usage à des accès de fièvre très élevée, autres désagréments visibles ou douleurs véritables.
La nécessité d'essais contrôlés aléatoires pour déterminer les effets à long terme de l'usage fréquent du paracétamol chez l'enfant fait l'unanimité.
L'élaboration de règles d'usage ne pourra se faire qu'à l'appui de ces essais.
En attendant de tels résultats, le paracétamol demeure le médicament favori pour soulager douleurs et fièvres chez l'enfant, à utiliser selon les recommandations de l'OMS qui préconisent qu'il ne soit donné aux enfants qu'en cas de fièvre supérieure ou égale à 38,5�°C.
La prise d'aspirine chez les jeunes enfants est contre-indiquée en raison du risque du syndrome de Reye, une complication rare mais grave.
Le paracétamol demeure toutefois le moyen préféré pour soulager douleurs et fièvres chez les enfants et adultes souffrant d'asthme, car l'aspirine et les autres anti-inflammatoires sans stéroïdes peuvent provoquer des crises chez les asthmatiques.
Les fausses promesses des normes mondiales de gouvernance
L'idée d'un ensemble unique de critères d'évaluation de la gouvernance des sociétés cotées en bourse est certes séduisante.
Les investisseurs et ces sociétés évoluent dans des marchés financiers mondiaux de plus en plus intégrés ; pourtant, la quête de tels critères mondiaux est peu judicieuse.
Ces dix dernières années, on a certes noté une utilisation croissante des normes mondiales de gouvernance, très développées aux Etats-Unis, pour évaluer comment pays et sociétés protègent les investisseurs minoritaires.
Or, les efforts dans ce sens n'ont pas tenu compte des différences fondamentales entre les sociétés contrôlées, qui ont un actionnaire majoritaire, et les sociétés à actionnariat dispersé, qui n'en ont pas.
Si ces dernières dominent dans les marchés financiers aux Etats-Unis et au Royaume-Uni, ce sont les sociétés contrôlées qui prévalent dans la plupart des autres pays.
Les difficultés auxquelles sont confrontées les créanciers varient considérablement selon qu'on parle de sociétés à actionnariat dispersé ou de sociétés contrôlées.
Dans le premier cas, la préoccupation majeure est l'opportunisme des administrateurs, qui exercent un contrôle de fait ; dans le deuxième, c'est l'opportunisme de l'actionnaire majoritaire, au détriment des actionnaires minoritaires.
Puisque les problèmes fondamentaux de gouvernance diffèrent nettement selon le type de société, les dispositifs en faveur des investisseurs dans les sociétés à actionnariat dispersé peuvent être inappropriés voire contre-productifs dans les sociétés contrôlées, et inversement.
En conséquence, l'application d'une norme unique pour évaluer la protection des investisseurs dans le monde entier risque d'être inefficace pour les sociétés à actionnariat dispersé, pour les sociétés contrôlées ou pour les deux types de sociétés.
Prenons l'exemple du Corporate Governance Quotient system, conçu par l'entreprise américaine RiskMetrics, société leader en matière de conseil aux actionnaires.
Utilisé par des investisseurs institutionnels dans le monde entier, ce système attache une grande importance aux dispositifs qui régissent le contrôle interne.
Ces dispositifs sont en fait importants pour les investisseurs dans les sociétés à actionnariat dispersé.
En revanche, dans les sociétés à actionnaire majoritaire, les luttes pour le contrôle entre les actionnaires ne sont pas possibles, et les conditions auxquelles elles sont soumises, hors de propos.
Les investisseurs et les autorités de pays où prévalent les sociétés contrôlées devraient cesser d'utiliser des normes de gouvernance mondiale basées sur une expérience avec des sociétés américaines à actionnariat dispersé.
Au lieu de cela, ils devraient s'efforcer d'élaborer des normes adaptées aux sociétés contrôlées.
Le plus évident, c'est que l'appréciation de sociétés contrôlées ne devrait pas donner de poids significatif aux dispositifs qui régissent le contrôle d'entreprise.
De même, les mesures qui rendent les conseils d'administration plus réceptifs aux souhaits d'une majorité d'actionnaires (comme par exemple, faciliter la tâche des actionnaires pour le remplacement d'administrateurs) peuvent servir les intérêts des investisseurs dans les sociétés à actionnariat dispersé, mais produire les effets inverses pour les créanciers de sociétés contrôlées.
Dans ces dernières, où la préoccupation est d'écarter les actionnaires minoritaires, faire en sorte que les administrateurs soient encore plus réceptifs à l'actionnaire majoritaire rendra probablement les investisseurs minoritaires encore plus vulnérables.
En outre, dans les pays qui comptent un grand nombre de sociétés contrôlées, il convient d'accorder une attention particulière aux transactions entre parties liées et aux opportunités d'affaires  -- principaux moyens d'écarter la valeur des investisseurs minoritaires dans ce type de sociétés.
Pour répondre à de telles questions, les accords qui permettent à une minorité d'actionnaires d'opposer leur veto aux transactions entre parties liées  --  non garantis dans les sociétés à actionnariat dispersé  -- pourraient s'avérer utiles.
Enfin, dans le cadre de l'appréciation de sociétés contrôlées, il importe de ne pas juger l'indépendance des administrateurs essentiellement sur leur indépendance vis-à-vis du conseil de la société où ils siègent, mais plutôt vis-à-vis de son actionnaire majoritaire.
Pour améliorer la gouvernance d'entreprise et la protection des investisseurs, les autorités et les investisseurs des pays dont les marchés financiers sont dominés par des sociétés contrôlées devraient se méfier des normes de gouvernance mondiale conçues pour les entreprises américaines.
Ils devraient se concentrer sur les problèmes propres aux sociétés contrôlées et sur les règles les plus efficaces pour protéger les investisseurs minoritaires dans ces sociétés.
Finance : des tests toxiques
Beaucoup d'observateurs en ont déduit que les banques américaines - institutions de toute première importance tant pour l'économie américaine que pour l'économie mondiale - sont sorties d'affaire.
Mais ce raisonnement est erroné.
Les tests de stress américains n'avaient pas comme objectif l'évaluation des pertes que les banques ont subies sur nombre de leurs &quot;actifs toxiques&quot; - actifs qui ont été au cœur de la crise financière.
Pourtant le modèle américain fait tache d'huile.
Lors d'une rencontre ce mois-ci, les ministres des finances du G8 ont convenu de suivre l'exemple américain et de soumettre leurs propres banques aux tests de stress.
Mais pour que ces tests soient fiables, il ne faut pas commettre la même erreur qu'aux USA.
Jusqu'à il y a peu, le gouvernement américain s'intéressait essentiellement aux actifs toxiques qui déséquilibraient le bilan des banques.
Alors que les règles comptables permettent souvent d'évaluer les actifs à leur valeur nominale, on admet généralement que la valeur réelle de beaucoup d'actifs toxiques est tombée bien en dessous de leur valeur nominale.
L'administration Obama a proposé un plan à hauteur de 1000 milliards de dollars destiné au rachat des actifs toxiques des banques, mais pour l'instant il est suspendu.
On aurait pu espérer que les responsables des tests de stress évaluent le volume des pertes que les banques ont subi à cause des actifs toxiques.
Or ils se sont contentés d'évaluer les pertes que pourraient subir les banques sur les prêts (et sur d'autres actifs) qui arriveront à maturité à la fin de l'année prochaine, ignorant délibérément les pertes qu'elles subiront après 2010.
Ainsi les tests ne prennent pas en compte une part importante des pertes supportées par les banques en raison de la crise.
Nous n'avons pas encore d'estimation de ces pertes, mais elles pourraient être importantes.
A titre d'exemple, d'après un rapport récent de la Deutsche Bank, dans le secteur de l'immobilier d'entreprise les emprunteurs auront de la difficulté à refinancer les centaines de milliards de prêts qui arriveront à maturité après 2010.
Plutôt que d'évaluer la valeur des actifs bancaires - ce que serait leur valeur sur un marché au fonctionnement optimum - et les comparer au passif, il aurait mieux valu que les tests de stress aient seulement pour objectif d'évaluer dans quelle mesure les pertes comptables des banques lors des deux prochaines années risquent de dépasser leur capital tel qu'il est inscrit dans leurs comptes.
Tant que l'on autorise les banques à fonctionner de cette manière, les responsables chargés du contrôle de l'activité bancaire parient sur la capacité des banques à se redresser - même si la valeur de leurs actifs ne dépasse pas nettement celle de leur passif.
Mais la capacité des banques à lever de nouveaux capitaux propres, indépendamment de la fiabilité des tests de stress, signifie-t-elle que les investisseurs estiment que la valeur de leur actif dépasse franchement celle de leur passif ?
Absolument pas.
Prenons le cas d'une banque supportant un passif d'un milliard de dollars.
Supposons que ses actifs qui arriveront à maturité à long terme aient une valeur nominale de 1,2 milliards de dollars mais que leur valeur actuelle ne soit que d'un milliard de dollars.
Bien que la valeur des actifs ne dépasse pas celle du passif, les déposants ne fuiront pas tant que le gouvernement garantit leurs dépôts.
Si dans deux ans les actifs de la banque ont une chance sur deux de s'apprécier à hauteur de 1,2 milliards de dollars et une chance sur deux de descendre à la valeur de 0,8 milliards de dollars, la banque pourra lever de nouveaux capitaux propres. Car dans la perspective de réaliser un bénéfice si les choses se passent bien, les nouveaux investisseurs acceptent de prendre un risque.
Un diagnostic exact de la santé financière des banques passe par l'estimation de la valeur de leurs actifs toxiques.
Les régulateurs devraient encourager les banques à vendre une partie de leurs actifs toxiques de manière à extrapoler à partir du prix qu'elles en obtiennent la valeur de la totalité de leur portefeuille d'actifs toxiques. Autre possibilité, ils pourraient estimer par eux-mêmes la valeur de ce portefeuille.  
Quelle que soit la méthode, il est indispensable d'estimer la valeur des actifs toxiques d'une banque avant de conclure que son capital est suffisant pour qu'elle puisse tenir le rôle clé qui lui est dévolu.
Le type de tests de stress utilisé par les USA, et que l'on demande à d'autres pays d'appliquer - et la capacité des banques à lever de nouveaux fonds propres - ne permettent pas de conclure quant à la santé financière d'une banque.
Que la fête recommence?
Pas avant de réformer.
La priorité politique à donner à la révision de la rémunération des cadres est l'une des leçons clés de la crise financière.
La façon, effectivement, dont les institutions financières rémunèrent leurs cadres, a contribué largement à l'excès de risques qui a précipité la crise.
En les récompensant pour leurs prises de risque, tout en leur garantissant l'impunité pour certaines des conséquences fâcheuses imputables à ce comportement, elles les ont poussés à des paris irrationnels.
Et ces prises de risque ont été d'autant plus excessives, qu'il s'agissait le plus souvent de récompenser des bénéfices à court terme, même avec un recul de ces bénéfices dans la foulée.
Le marché a eu beau perdre plus de la moitié de sa valeur boursière au cours des cinq dernières années, les cadres n'en ont pas moins touché, avant que la bourse n'implose, d'énormes dividendes et bonus.
Ces systèmes de rétribution disposaient trop les cadres à une course au profit rapide -- les incitant à se porter sur des prêts et des investissements rapportant à court terme -- en dépit du risque d'implosion qu'ils faisaient croître en agissant ainsi.
Au lendemain de la crise, le problème est apparu clairement, y compris à des managers comme le PDG de Goldman Sachs, Lloyd Blankfein.
Mais la question est encore loin d'être réglée: la récente décision, chez Goldman, d'accorder des bonus records en récompense des performances obtenues aux deux derniers trimestres, par exemple, est un pas dans la mauvaise direction.
Pour renoncer à récompenser ces performances à court terme et privilégier les résultats à long terme, il faut entreprendre une refonte du système d'attribution des primes.
En ce qui concerne le paiement des bonus en actions, les cadres ne devraient pas être autorisés à tirer profit des stock options qui leur ont été confiées, avant une échéance de cinq ans, par exemple -- c'est à dire avant le moment où elles seraient arrivées à "maturité," et où on ne doit pas pouvoir les retirer aux cadres.
L'impossibilité de tirer profit des stock options, pendant une longue durée, lierait le salaire du cadre à la valeur des actions à long terme.
La durée de cette période devrait être fixée, et ne devrait pas dépendre d'actions ou de conditions étant, au moins partiellement, du ressort des cadres.
Inversement, l'interdiction de tirer profit des stock options avant de quitter la société, pourrait inciter ceux des cadres qui auraient accumulé des stock options à forte valeur ajoutée à partir, ce qui serait contre-productif.
Il faut revoir également les bonus, de façon à ce qu'ils viennent récompenser les performances à long terme.
Il faudrait déjà cesser de distribuer des bonus pour des résultats qui n'ont qu'un an.
De plus, on ne devrait pas verser les bonus immédiatement, mais les placer sur un compte de la société pendant plusieurs années, et les ajuster à la baisse, si par la suite la société apprend que ce qui en avait motivé l'attribution est devenu caduc.
Indépendamment de l'importance excessive accordée aux résultats à court terme, on n'a pas assez pris en considération une autre source d'incitation à prendre des risques excessifs.
Les salaires des cadres du secteur financier étaient liés à des paris à fort effet de levier sur la valeur de leur société.
Pourquoi les rémunérations du secteur financier ne devraient pas être laissés à la loi du marché
Il n'est peut-être pas surprenant que de nombreux grands patrons de la finance s'opposent fermement à ces décisions.
Ils prétendent qu'ils doivent rester libres d'établir le montant des rémunérations afin de se préserver les meilleurs éléments -- ceux qui seront à même de ressusciter le système financier international.
Les gouvernements devraient-ils donc reculer et laisser les sociétés de la finance procéder eux-mêmes à ces réformes ?
La réponse est non, bien sûr.
Dans le nouvel ordre post-crise financière, les gouvernements doivent endosser le rôle de surveillance et de régulation des rétributions dans les sociétés financières ; dans le cas contraire, les motivations perverses qui ont contribué à la crise actuelle pourraient bien refaire surface.
Il est important de distinguer deux sources d'inquiétudes à propos des rémunérations pratiquées dans le secteur financier.
L'une concerne les actionnaires.
Les chiffres récemment publiés par le procureur général de l'état de New York, Andrew Cuomo, indiquent que neuf grandes institutions financières ont rétribué plus de 600 milliards de dollars à leur personnel entre 2003 et 2008, alors même que leur capitalisation boursière connaissait une baisse substantielle.
Ce genre d'évolution est à même d'éveiller quelques inquiétudes chez les actionnaires sur le fait que les grilles de rémunérations ne sont peut-être pas bien conçues pour servir leurs intérêts.
Même si certains problèmes de gouvernance dans ces sociétés font que la politique de rémunération n'est pas en phase avec les intérêts des actionnaires, de tels problèmes ne justifient pas nécessairement l'intervention du gouvernement sur la politique appliquée.
De tels problèmes sont mieux gérés par des règles qui visent à améliorer les processus internes de gouvernance et à renforcer les droits des investisseurs, tout en laissant au conseil d'administration et aux actionnaires qui le nomment la liberté de déterminer la politique de rémunération.
Mais les rémunérations pratiquées dans le secteur financier provoquent une deuxième source d'inquiétude : même si la politique de rémunérations retenue est conçue dans le respect des intérêts des actionnaires, elle peut être source d'incitations à des prises de risques excessives qui sont socialement indésirables.
En conséquence, même si les sociétés financières parviennent à trouver des solutions à leurs problèmes de gouvernance, l'intervention régulatrice du gouvernement peut malgré tout se justifier.
Supposons que les organismes régulateurs comptent sur le fait que la plupart des sociétés financières agissent dans l'intérêt des actionnaires.
Cela justifierait-il que ces sociétés soient exemptées d'appliquer des règles en vigueur qui contraignent leurs décisions en matière de prêts, d'investissements ou de réserves de capitaux ?
Non, bien sur, parce que les actionnaires ne supportent pas l'intégralité des coûts de la faillite d'une société, et, ainsi que le démontre la crise récente, la facture d'une telle débâcle doit être payée, tout au moins en partie, par les contribuables et l'économie.
Donc, des décisions trop « risquées » servent parfois les intérêts des actionnaires et il serait normal de règlementer de telles décisions, sinon nécessaire.
Encadrer les rémunérations pratiquées dans les établissements financiers découle des mêmes raisons qui ont justifié la mise en place des organismes de contrôle sur le fonctionnement de ces établissements.
Les incitations générées par les modes variables et invariables de rétribution déterminent la façon avec laquelle les managers se comportent dans le cadre autorisé par les règlementations traditionnelles directes.
Et comme les règles traditionnelles autour des décisions prises dans les affaires sont vouées à l'imperfection, encadrer la politique de rémunération peut être un outil supplémentaire pour contrôler les risques posés par le comportement des sociétés financières.
Si la politique de rémunération choisie peut avoir des incidences sur la stabilité des établissements financiers, règlementer ces choix peut aussi être utile pour préserver cette stabilité.
Les sociétés financières qui s'opposent à la réglementation des rémunérations seront probablement aussi opposées à une compensation du « micro management », s'appuyant sur l'argument que les choix de compensation devront prendre en compte des informations sur chacun des managers, informations que les régulateurs n'auront certainement pas.
Mais les règlementations sur les rémunérations peuvent améliorer la situation sans micro management en établissant des cadres standard que les établissements devront respecter mais qui leur laissera encore suffisamment de liberté pour prendre en compte les situations individuelles de chaque manager.
Par exemple, une des exigences de ces cadres standard pourrait être que les plans de rémunération excluent la possibilité pour les managers de percevoir les bénéfices des actions et options octroyées pendant une période déterminée.
Dans un tel cas, les sociétés pourraient encore rester libre de déterminer le nombre d'actions et d'options proposées à un manager, de même qu'elles pourraient modifier la période pendant laquelle toute possibilité de cession serait impossible.
Enfin, ceux qui s'opposent à une réglementation sur les rémunérations seront sûrement ceux qui nous mettront en garde contre les « conséquences fortuites ».
Mais ces mises en garde ne feront pas long feu.
Nous avons vu au cours de ces dernières années les conséquences réelles et coûteuses d'un système de compensation qui laissait les sociétés libres d'établir leur propre politique de rémunération.
Devons nous croire que ces conséquences sont préférables aux conséquences fortuites d'une réglementation en matière de rémunération ?
Les arguments spéculatifs sur d'éventuelles conséquences involontaires ne devraient pas mettre un frein aux efforts entrepris pour éviter les dysfonctionnements résultant de politiques de rémunération défectueuses.
Les établissements financiers ne devraient pas garder la liberté de créer des incitations perverses qui sont un risque pour nous tous.
Pas de bouée de sauvetage pour les détenteurs d'obligations !
On s'attend maintenant à ce que l'Etat vienne au secours de celles jugées &quot;trop grande pour couler&quot;.
Mais jusqu'à quel point doit-il intervenir ?
Ainsi les détenteurs d'obligation d'AIG, de la Bank of America, du Citigroup et de Fannie Mae ont été totalement couverts grâce à l'intervention de l'Etat en faveur de ces institutions, alors que leurs actionnaires ont subi des pertes importantes.
Cela a été la même chose au Royaume-Uni, en Europe et ailleurs.
Les détenteurs d'obligations ont été épargnés parce que l'Etat a souvent décidé d'injecter des liquidités en échange d'actions ordinaires ou privilégiées subordonnées aux créances des détenteurs d'obligations ou encore d'améliorer leur bilan en rachetant ou en garantissant la valeur de leurs actifs.
Deux éléments poussent un Etat à sauver une institution financière et à protéger ses créanciers.
D'une part les déposants et les créanciers étant libres de retirer leur capital à tout moment, le parapluie de l'Etat peut s'avérer nécessaire pour éviter une panique bancaire susceptible de s'étendre aux autres institutions.
Aussi, l'Etat aurait-il peut-être intérêt à garantir implicitement ou explicitement leurs créances.
La Censure à Hongkong
On ne voit aucune botte militaire défiler au pas dans les centres commerciaux raffinés de Hongkong, mais dans le fond de l'air, une bouffée de totalitarisme est bien perceptible.
Les expressions révélatrices sont sur toutes les lèvres : discussions sur la nécessité des lois anti-subversion, contrôle de la presse, gouvernement fort, ajustement aux nouvelles réalités de Hongkong.
Tout le monde regarde vers le grand voisin du nord pour trouver une orientation et râle contre l'opportunisme.
La majeure partie du globe a cessé de s'intéresser à Hongkong après 1997 quand l'"Anschluss" avec la Chine n'a pas produit immédiatement de grands bouleversements.
Au cours des deux dernières années, cependant, le rythme de l'intégration à la République populaire de Chine s'est intensifié de manière décisive.
La vie quotidienne du South China Morning Post , le principal quotidien de langue anglaise de Hongkong, et de ce fait un indicateur politique manifeste, offre une vue sur de qui se passe dans toutes les institutions de Hongkong.
L'atmosphère du journal a commencé à s'assombrir de manière notable quand ses journalistes-phares furent écartés, les uns après les autres.
Il serait exagéré de comparer cette situation à la façon dont les nazis s'emparèrent des institutions en Allemagne dans les années 1930, et à la façon dont tout le monde tomba d'accord à l'époque, parce que personne n'a encore été déporté en camp de concentration.
Hongkong reste une ville riche et prospère.
Et pourtant, la dictature de Beijing fait sentir sa présence, même si ce n'est que par ses intermédiaires et collaborateurs.
Avant de choisir de faire entendre ma protestation auprès du rédacteur en chef qui m'a sacqué récemment, j'étais moi aussi coupable et complice.
Je me suis tu quand le plus célèbre dessinateur du journal, Larry Feign, fut injustement renvoyé et je me suis même encore tu après le renvoi du meilleur auteur satirique du quotidien, Nury Vittachi.
Je n'ai ressenti le malaise qu'au renvoi et au remplacement du journaliste britannique, Jonathan Fenby.
" Moi, ça va ", me disais-je , " ils me laissent encore écrire ce que je veux... "
Ma position de chef du bureau de Beijing m'isolait des luttes du siège lointain de Hongkong.
De plus, travailler à Beijing est en soi un combat tenace sur le plan de la conscience et du compromis.
Les journalistes étrangers sont sous surveillance constante et prennent le risque de mettre en danger leurs contacts.
Ce qui implique qu'ils se mettent rapidement à éviter les sujets difficiles tels que la répression dont fait l'objet Falun Gong et ses partisans.
Peu à peu, on remarque aussi un changement dans le comportement des collègues de Hongkong.
Quand le gouvernement propose d'introduire des lois contre la subversion et renforce son contrôle sur la fonction publique, ils se mettent à surveiller leurs propos et se gardent bien de mentionner les pressions subies d'en haut.
Les rumeurs chuchotées sur les interférences quotidiennes de la direction ne se confirment qu'en privé.
Certains ont réagi de manière opportuniste, constatant qu'ainsi, avec la disparition de collègues talentueux, leur avancement hiérarchique devenait possible.
De fait, le rédacteur en chef de renommée internationale, Willy Lam, fut remplacé par un homme du continent, Wang Xiangwei.
Ceux qui organisèrent ce coup espéraient qu'il les mènerait à un avenir meilleur pour eux-mêmes ; ceux qui signèrent la pétition de protestation furent limogés peu de temps après.
La direction a alors commencé à propager la rumeur insidieuse des besoins du journal en hommes capables de " composer " avec les sensibilités du parti communiste.
Curieusement, certains officiels de Beijing se sont plaints des manoeuvres grossières de ceux qu'on avait envoyé gérer le bureau de Hongkong.
Il semble que l'empressement à collaborer de certains eût tôt fait de surpasser les exigences du parti.
Le ton du journal commença à évoluer, devenant de plus en plus déférent à l'égard des dirigeants chinois.
Les reportages devinrent de plus en plus insipides.
La direction invoqua les vertus de l'écriture pour permettre aux lecteurs de lire entre les lignes.
Ces bouleversements se sont accentués ces derniers mois.
Même le photographe du bureau remarqua bientôt des changements dans les choix photographiques.
Les bureaux des Affaires de Hongkong et Macao prirent en main les correspondants du journal basés sur le continent, exigeant qu'ils soient remplacés par des Chinois de souche.
Puis ils se mêlèrent d'offrir des conseils en matière de journalisme en échange de services tels que la mise en contact avec les officiels.
En dépit de la direction évidente que tout cela prenait, les réactions individuelles varièrent.
Certains continuèrent de nier les faits, s'indignant si le sujet était abordé, tandis que d'autres se dirent qu'en gardant un profil bas et en faisant des concessions, la crise se résorberait..
Une sorte d'apathie s'est abattue sur Hongkong, dans la fonction publique tout particulièrement.
Le monde des affaires reste peu touché et continue de parler de manière optimiste des possibilités créées par une intégration plus resserrée avec le continent.
Mais Hongkong abandonne ainsi la position unique et exceptionnelle qu'elle détenait dans la civilisation chinoise.
À mesure que d'autres villes chinoises se libèrent et renforcent leur confiance en elles-mêmes, Hongkong abandonne, soumise, les libertés qu'elle détenait autrefois avec fierté.
En 1997, la Chine promettait de préserver ces libertés pour les cinquante ans à venir sous l'égide de la devise du " un seul pays, deux systèmes ".
Maintenant Hongkong elle-même défait ce système.
Nombre de ses magnats (dont Robert Kuok, qui contrôle le South Morning China Post ) se débarrassent de leur autonomie au nom des affaires - même quand cela n'est pas exigé.
Ils se montrent sourds aux valeurs de ce qu'ils sacrifient.
Les impondérables de la liberté détermineront la vitalité et l'avenir de Hongkong.
Malheureusement, des telles pertes ne figurent pas dans les rapports de pertes et profits des comptables.
Des barrages sur les fleuves de Chine
Dans le Yunnan coulent trois grands fleuves asiatiques : le Mekong, le Salween (ou Nu), et le Jinsha.
Tous prennent leur source sur le grand plateau tibétain et coulent parallèlement de l'angle nord-ouest de la province jusqu'au sud-est asiatique.
Ce sont les derniers fleuves intouchés de Chine, néanmoins désignés pour être sacrifiés à l'insatiable soif de puissance du pays.
Des projets envisagent l'érection de dizaines de barrages le long de leur sinueux cours à travers les montagnes du Yunnan.
J'ai eu l'occasion de voir un de ces fleuves ainsi que le site envisagé pour l'un des barrages les plus controversés du pays, lors d'une récente randonnée à travers l'étonnante Gorge du tigre bondissant, au nord de la ville de Lijiang, dans le nord du Yunnan.
Pendant sa descente depuis le toit du monde, la rivière Jinsha, affluent du puissant Yangtze, cascade à travers cette gorge d'une quinzaine de kilomètres en direction de Shanghai et de la mer de Chine orientale.
Si, ou plutôt quand le barrage sera érigé sur la rivière, il contribuera à l'effort énergétique des villes et des usines du littoral chinois.
Le soleil était haut au-dessus des neiges de la Montagne du dragon de jade quand mon guide pointa son doigt en direction de la gorge et désigna les eaux marron qui bouillonnaient à des centaines de mètres en-dessous de nous.
"C'est là qu'ils vont construire le barrage," déclara Xiao Chun, un Naxi de 17 ans, membre d'une des 22 minorités ethniques du Yunnan.
"Ce sera très mauvais pour nous.
Il y aura beaucoup de pollution.
J'espère que ça n'arrivera pas."
Le barrage aura son utilité.
Le lac Dianchi, près de Kunming, la capitale de la province, est si diminué et pollué que la ville est confrontée à une grave pénurie d'eau.
L'eau de la Gorge du tigre bondissant sera déviée pour alimenter le lac Dianchi, sans lequel Kunming ne prospèrera pas.
Alors que la Chine cherche à maintenir son moteur économique, les barrages et l'énergie hydraulique représentent une alternative plus propre au charbon.
La Chine envisage de doubler sa capacité d'énergie hydroélectrique à plus de 120 GW d'ici 2010 et de construire plus de projets liés à l'énergie hydraulique pendant au moins encore 20 ans.
Les experts estiment que seul un quart de l'énergie hydraulique de la Chine a été canalisé.
Pourtant les coûts pourraient surpasser les bénéfices.
Le nord-ouest du Yunnan est l'une des région du monde possédant la plus grande diversité biologique ; il abrite la moitié des espèces animales de Chine et un quart de ses espèces végétales.
Les portions de ces écosystèmes qui ne seront pas noyées par le barrage seront perturbées à coup sûr, de manière potentiellement désastreuse.
Une inquiétude plus immédiate est l'immense quantité de gens qu'il faudra reloger quand les réservoirs inonderont les vallées densément peuplées de la région.
Depuis 1949, 16 millions de personnes ont été déplacées à cause de réservoirs.
Quelque 10 millions d'entre elles vivent encore dans la pauvreté.
À la Gorge du tigre bondissant, où seulement 100 000 habitants devront être déplacés, les occupants craignent qu'on leur ordonne de monter plus haut sur les flancs escarpés de la montagne pour ouvrir des terres marginales de 900 à 2 800 mètres.
Les opposants au barrage, notamment les groupes écologistes indigènes qui arrivent à se faire entendre, ont mené une bataille apparemment victorieuse pour protéger la Gorge du tigre bondissant et la Salween (ou rivière Nu).
Début 2005, trois ans après qu'une nouvelle loi sur l'évaluation de l'impact environnemental a été votée, le Bureau de protection de l'environnement d'État a ordonné l'arrêt de 30 vastes projets, dont 26 installations d'énergie hydroélectrique qui n'avaient pas fourni les évaluations de l'impact environnemental appropriées.
Parmi les projets suspendus figurait le premier barrage sur la Nu/Salween.
Ces efforts semblent avoir fait naître une grande sensibilité environnementale parmi les dirigeants du pays.
Le gouvernement a récemment appelé à un développement plus équilibré, proposant même un "indice vert" pour mesurer la croissance.
Le premier Ministre Wen Jiabao a déclaré qu'il a l'intention de voir plus de "développement scientifique" dans l'approche qu'a la Chine de ses problèmes, et a même appelé à un arrêt temporaire du barrage sur la rivière Salween (Nu).
Les écologistes ont été autorisés à participer à une audition publique sur le projet de la Gorge du tigre bondissant, une première pour la Chine.
Malheureusement, le parti communiste souffle le chaud et le froid quand il s'agit de tolérer ce genre d'activités civiques.
Le parti, alarmé par les"révolutions colorées" qui ont renversé les dirigeants post-soviétiques en Géorgie, Ukraine et au Kirghizstan, met un frein aux organisations non-gouvernementales nationales de peur qu'elles aussi ne deviennent les catalyseurs de soulèvements populaires.
Le soutien pour un "développement vert" à l'intérieur d'organisations du gouvernement central, comme le Bureau de protection de l'environnement, offre peu d'assurance d'un contrepoids efficace.
"Nous devons nous aiguiser les dents," a affirmé Pan Yue, directeur adjoint du Bureau de protection de l'environnement quand l'agence a fait arrêter les projets de barrages.
Mais la Chine a connu une décentralisation constante des pouvoirs ces dernières années, ce qui rend difficile pour le Bureau de protection de l'environnement d'exercer une influence au niveau régional et local.
En effet, les gouvernements locaux paraissent moins effrayés par les dents de Beijing qu'auparavant.
Lorsque les frontières ont été négociées pour le Parc des trois rivières parallèles, classé au patrimoine de l'humanité par l'UNESCO en 2003, les autorités locales ont gagné un combat pour en exclure la Gorge du tigre bondissant, car elles savaient qu'un barrage à cet endroit triplerait les revenus fiscaux.
Le pays a instamment besoin de maintenir un taux de croissance annuel de plus de 9% pour faire rempart contre le désordre social.
Le résultat en est que la Chine se consomme lentement elle-même, et qu'il se pourrait bien qu'aucun grand espace chinois ne demeure intouché.
Vaines proclamations
Le Sommet mondial sur le développement durable qui se tient actuellement à Johannesburg envisage comme prévu de prendre nombre d'engagements spectaculaires, mais ce n'est que vaine agitation.
Car si le terme de "développement" concerne le développement humain au sens large, le seul qui vaille est celui qui permet aux peuples de la Terre de vivre en paix dans le respect des droits fondamentaux de l'homme.
Il y a peu de chance que l'action internationale puisse faire cesser la violation de ces droits dans la majorité des pays de la planète, notamment chez ceux qui s'efforcent de faire du Sommet de la Terre une boite de résonance des critiques formulées à l'encontre des pays riches pour la faiblesse de leur engagement dans la lutte contre la pauvreté dans le monde ou pour la protection de l'environnement.
Nous pourrions au moins nous réjouir de ce que ces deux thèmes, la pauvreté et l'environnement, sont les sujets principaux de ce sommet.
C'est un progrès par rapport aux obsessions habituelles des premiers lobbies en faveur du développement durable, comme le supposé épuisement des matières premières, l'incapacité de la planète à nourrir une population croissante ou encore la biodiversité.
La majorité des commentateurs lucides ont souligné les exagérations outrancières des écologistes.
L'économie nous apprend que lorsque la demande croit les prix augmentent, ce qui entraîne - hormis les manoeuvres spéculatives à court terme - une diminution de la demande et une augmentation de l'offre (y compris l'offre de produits de substitution).
A cause de ce mécanisme, aucun des scénarios apocalyptiques des années 1960 et 70 (souvenons-nous des prévisions du Club de Rome) ne s'est réalisé.
Sur le long terme, le prix de presque toutes les ressources minières a baissé.
Le monde ne risque pas de se trouver en manque dans ce domaine.
Les prophéties de famine imminente à l'échelle de la planète étaient tout aussi dépourvues de fondement.
Les famines surviennent, mais elles surviennent rarement, sinon jamais, dans les démocraties.
De l'époque des collectivisations en URSS dans les années 30 jusqu'à la politique raciste menée aujourd'hui au Zimbabwe par le président Mugabe, les famines sont la conséquence de la guerre civile ou d'extravagances idéologiques.
Le climat peut certes aggraver la situation, mais les gouvernements démocratiques ont les moyens de faire face grâce à la mondialisation du commerce et à l'existence de surplus alimentaires dans beaucoup de régions agricoles.
Et en ce qui concerne la biodiversité, la première espèce menacée est l'espèce humaine.
L'aide internationale peut contribuer à traiter les deux problèmes voisins que sont la pauvreté et la dégradation de l'environnement.
Ainsi, les pays riches devraient diminuer leurs subventions agricoles et s'ouvrir davantage aux exportations du Tiers monde.
L'action internationale peut aussi aider à réduire les problèmes écologiques au niveau de la planète.
Il existe beaucoup d'exemples de ce type d'action, comme le protocole de Montréal relatif à la réduction de la couche d'ozone.
Il est regrettable que les USA se soient retirés du protocole de Kyoto destiné à combattre le réchauffement de la planète, plutôt que d'essayer de le faire évoluer vers une solution liée à l'économie de marché, très éloignée des mécanismes de régulation que les bureaucrates aiment tant.
Mais la lutte contre la pauvreté et la dégradation de l'environnement, par exemple l'amélioration de l'accès à l'eau potable, qui concerne des milliards de personnes dans le Tiers monde dépend d'abord de facteurs locaux.
Le respect de la loi, du droit de propriété, de la liberté d'entreprendre, de la liberté d'expression et de manifester, dépendent avant tout de la situation locale. Il en est de même pour quantité d'autres droits fondamentaux mentionnés dans les nombreuses conventions internationales signées par la presque totalité des pays participant au Sommet de la Terre, mais qu'ils bafouent au grand jour.
Le respect des droits de l'homme n'est pas seulement un moyen de lutte contre la pauvreté et la dégradation de l'environnement, c'est aussi un outil majeur, souvent le plus important, pour améliorer le bien-être et le développement des populations.
Les événements de ces douze derniers mois montrent que le premier danger qui menace l'humanité n'est pas la dégradation de l'environnement, mais les conflits qui jettent les hommes les uns contre les autres.
Malheureusement, intervient le respect dévolu aux souverainetés nationales. De ce fait, la marge de manoeuvre laissée à l'action internationale en faveur des droits de l'homme dans les nombreux pays où ils sont violés, est très limitée.
C'est pourquoi les proclamations tonitruantes qui vont sans doute couronner le Sommet de la Terre sont vouées à l'échec.
Quand la vieille Europe éternue, la nouvelle Europe s'enrhume
Deux pays -- la Hongrie et l'Ukraine -- ont déjà demandé des plans de soutien de taille.
Plusieurs autres pays vont sans doute en faire autant dans le courant du mois qui vient, si le gel des marchés du crédit se prolonge.
Et si cette situation devait durer jusqu'à la fin de l'année, ce qui n'est pas à exclure, beaucoup d'autres pays seraient en butte à des crises bancaires graves.
Au cours des vingt dernières années, l'Europe de l'Est a entrepris de vastes réformes et adopté le processus global d'intégration financière.
Les banques étrangères, notamment celles de l'Europe de l'Ouest, ont pénétré ses marchés avec une rapidité et une force sans précédent et sont progressivement allé jusqu'à tendre la main à des petites et moyennes entreprises, sujettes à risque, ainsi qu'à aider les gens à acheter leur maison et à monter leur affaire.
A présent, ces pays sont à la merci de la prospérité financière.
Jusqu'ici, les pays de l'Europe émergente ont extraordinairement bien résisté aux compressions financières internationales et sont parvenu à endiguer le ralentissement d'immenses marchés de l'exportation et la hausse des taux d'emprunt.
Mais aucune économie de marché ouverte n'est capable de survivre à la fermeture totale des marchés du crédit.
Peut-être ces pays sont-ils devenus trop tributaires du crédit à taux réduit, mais c'est une tendance dont ils n'ont pas le monopole.
Certaines des banques étrangères sont en train de retirer leurs avoirs liquides des filiales qu'ils ont en Europe de l'Est.
Selon la Banque de Russie, les banques extérieures à ce pays ont retiré plus de 10 milliards de dollars, pour le seul mois de septembre, ce que corroborent d'autres banques centrales.
Pour faire bonne mesure, Raiffeisen International a annoncé qu'elle soutenait sa filiale ukrainienne, la banque Aval, en lui allouant 180 millions d'euros de plus.
Les comportements, vis à vis de leurs filiales, des autres banques centrales mères, présentes dans la région, seront fonction de la tournure que prendra la crise en Europe occidentale.
Mais les plans de sauvetage en Europe de l'Ouest risquent d'aggraver la situation de l'Europe émergente.
La plupart des banques mères implantées dans la région sont susceptibles de profiter de ces mesures, mais il n'est pas dit qu'elles les traduisent nécessairement en soutien à leurs filiales à l'étranger.
En fait, on court le danger que ces sauvetages ne s'accomplissent au détriment de l'Europe de l'Est.
Plusieurs Etats ont déclaré que l'argent des contribuables ne servira pas à approvisionner les opérations à l'étranger.
Les Etats de l'Europe émergente auront, bien sûr, leur rôle à jouer dans la stabilisation de leurs propres systèmes financiers.
Mais à ce stade, ils n'ont plus vraiment les coudées franches.
Beaucoup n'ont pas l'assise financière suffisante pour répondre aux formidables pressions des marchés financiers.
La proposition par la Hongrie d'accorder une garantie générale des dépôts et de cautionner les fonds des marchés interbancaires, est peu crédible.
Pour surmonter cette crise, l'Europe émergente a besoin d'une aide extérieure.
D'abord et avant tout, il faut que les dirigeants d'Europe de l'Ouest veillent à ce que la crise soit éradiquée définitivement et nombre d'observateurs doutent qu'ils aient fait tout le nécessaire.
Ensuite, il faut qu'ils empêchent les mesures de crise déjà prises de léser les filiales en Europe de l'Est, qu'elles soient dans l'Union européenne ou en dehors.
Enfin, il faut qu'ils joignent leurs forces, comme en Hongrie, à celles des institutions financières internationales dans le relèvement de l'économie.
Ce qui s'est passé en Géorgie, à la suite du récent conflit avec la Russie, peut servir d'exemple.
Le FMI a déployé une ligne de crédits d'urgence pour soutenir la monnaie, la Banque mondiale a coordonné des dispositifs d'exonérations (dont beaucoup ont été financés par les Etats-Unis et l'Union européenne) et la Banque européenne pour la reconstruction et le développement a mis ses compétences en service pour conduire le redressement du système financier.
Le programme de la Géorgie n'est pas tout à fait réglé et, d'un pays à l'autre, le contexte est variable, mais manifestement, on peut aller loin avec les instruments de base.
Pourtant, il nous faudra davantage de ressources et d'instruments nouveaux.
Le cas de la Hongrie montre que l'Union européenne peut ajuster un instrument existant -- le soutien de la balance des paiements -- et s'en servir de façon créative.
Pour les pays hors Union européenne, comme la Turquie et l'Ukraine, des idées inédites sont instamment requises.
Il ne devrait y avoir aucune ambiguïté sur ce qui est en jeu.
Il a échappé à l'attention générale qu'au cours des dernières années, l'Europe de l'Est, Russie comprise, a battu les Etats-Unis et le Royaume Uni en termes de marchés à l'exportation, les siens étant les plus performants de la zone euro.
Nombre de ces marchés doivent maintenant lutter contre un ralentissement, voire une croissance négative.
De plus, les entreprises de l'Europe de l'Ouest ont fait des investissements d'une ampleur qu'on n'aurait pas imaginée auparavant.
