/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.twoplanar3T;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Oracle;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoPlanar3TArcEagerOracle
extends Oracle {
    private static final int ANY_PLANE = 0;
    private static final int FIRST_PLANE = 1;
    private static final int SECOND_PLANE = 2;
    private static final int NO_PLANE = 3;
    private Map<Edge, Integer> linksToPlanes = new IdentityHashMap<Edge, Integer>();
    private Map<Edge, List<Edge>> crossingsGraph = null;

    public TwoPlanar3TArcEagerOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        super(manager, history);
        this.setGuideName("2planar3t");
    }

    @Override
    public GuideUserAction predict(DependencyStructure gold, ParserConfiguration config) throws MaltChainedException {
        TwoPlanar3TConfig planarConfig = (TwoPlanar3TConfig)config;
        DependencyStructure dg = planarConfig.getDependencyGraph();
        DependencyNode activeStackPeek = planarConfig.getActiveStack().peek();
        DependencyNode inactiveStackPeek = planarConfig.getInactiveStack().peek();
        int activeStackPeekIndex = activeStackPeek.getIndex();
        int inactiveStackPeekIndex = inactiveStackPeek.getIndex();
        int inputPeekIndex = planarConfig.getInput().peek().getIndex();
        if (this.crossingsGraph == null) {
            this.initCrossingsGraph(gold);
        }
        if (this.checkIfNodesAreRelated(gold, activeStackPeekIndex, inputPeekIndex) && !this.checkIfNodesAreRelated(dg, activeStackPeekIndex, inputPeekIndex)) {
            if (!planarConfig.getStackActivityState()) {
                this.propagatePlaneConstraint(gold.getTokenNode(inputPeekIndex).getHeadEdge(), 1);
            } else {
                this.propagatePlaneConstraint(gold.getTokenNode(inputPeekIndex).getHeadEdge(), 2);
            }
            return this.updateActionContainers(3, this.getEdgeGraph(gold, activeStackPeekIndex, inputPeekIndex).getLabelSet());
        }
        if (this.checkIfNodesAreRelated(gold, inactiveStackPeekIndex, inputPeekIndex) && !this.checkIfNodesAreRelated(dg, inactiveStackPeekIndex, inputPeekIndex)) {
            return this.updateActionContainers(2, null);
        }
        if (this.areInputBufferRelated(gold, planarConfig.getActiveStack(), inputPeekIndex)) {
            return this.updateActionContainers(4, null);
        }
        if (this.areInputBufferRelated(gold, planarConfig.getInactiveStack(), inputPeekIndex)) {
            return this.updateActionContainers(2, null);
        }
        return this.updateActionContainers(1, null);
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areInputBufferRelated(DependencyStructure dg, Stack<DependencyNode> stack, int indexBuffer) throws MaltChainedException {
        for (DependencyNode nodo : stack) {
            if (!this.checkIfNodesAreRelated(dg, nodo.getIndex(), indexBuffer) || stack.peek().getIndex() == nodo.getIndex()) continue;
            return true;
        }
        return false;
    }

    private Edge getEdgeGraph(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() == index1 && arco.getTarget().getIndex() == index2) {
                return arco;
            }
            if (arco.getSource().getIndex() != index2 || arco.getTarget().getIndex() != index1) continue;
            return arco;
        }
        return null;
    }

    @Override
    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
        this.crossingsGraph = null;
        this.linksToPlanes.clear();
    }

    @Override
    public void terminate() throws MaltChainedException {
    }

    private static boolean cross(Edge e1, Edge e2) {
        int xSource = e1.getSource().getIndex();
        int xTarget = e1.getTarget().getIndex();
        int ySource = e2.getSource().getIndex();
        int yTarget = e2.getTarget().getIndex();
        int xMin = Math.min(xSource, xTarget);
        int xMax = Math.max(xSource, xTarget);
        int yMin = Math.min(ySource, yTarget);
        int yMax = Math.max(ySource, yTarget);
        return xMin < yMin && yMin < xMax && xMax < yMax || yMin < xMin && xMin < yMax && yMax < xMax;
    }

    private void initCrossingsGraph(DependencyStructure dg) {
        this.crossingsGraph = new IdentityHashMap<Edge, List<Edge>>();
        SortedSet<Edge> edges = dg.getEdges();
        for (Edge edge1 : edges) {
            for (Edge edge2 : edges) {
                if (edge1.getSource().getIndex() >= edge2.getSource().getIndex() || !TwoPlanar3TArcEagerOracle.cross(edge1, edge2)) continue;
                List<Edge> crossingEdge1 = this.crossingsGraph.get(edge1);
                if (crossingEdge1 == null) {
                    crossingEdge1 = new LinkedList<Edge>();
                    this.crossingsGraph.put(edge1, crossingEdge1);
                }
                crossingEdge1.add(edge2);
                List<Edge> crossingEdge2 = this.crossingsGraph.get(edge2);
                if (crossingEdge2 == null) {
                    crossingEdge2 = new LinkedList<Edge>();
                    this.crossingsGraph.put(edge2, crossingEdge2);
                }
                crossingEdge2.add(edge1);
            }
        }
    }

    private List<Edge> getCrossingEdges(Edge e) {
        return this.crossingsGraph.get(e);
    }

    private void setPlaneConstraint(Edge e, int requiredPlane) {
        this.linksToPlanes.put(e, requiredPlane);
    }

    private int getPlaneConstraint(Edge e) {
        Integer constr = this.linksToPlanes.get(e);
        if (constr == null) {
            this.setPlaneConstraint(e, 0);
            return 0;
        }
        return constr;
    }

    private void propagatePlaneConstraint(Edge e, int requiredPlane) {
        List<Edge> crossingEdges;
        this.setPlaneConstraint(e, requiredPlane);
        if ((requiredPlane == 1 || requiredPlane == 2) && (crossingEdges = this.getCrossingEdges(e)) != null) {
            for (Edge crossingEdge : crossingEdges) {
                assert (requiredPlane == 1 || requiredPlane == 2);
                int crossingEdgeConstraint = this.getPlaneConstraint(crossingEdge);
                if (crossingEdgeConstraint == 0) {
                    if (requiredPlane == 1) {
                        this.propagatePlaneConstraint(crossingEdge, 2);
                        continue;
                    }
                    if (requiredPlane != 2) continue;
                    this.propagatePlaneConstraint(crossingEdge, 1);
                    continue;
                }
                if (crossingEdgeConstraint == 3) continue;
                if (crossingEdgeConstraint == 1) {
                    if (requiredPlane != 1) continue;
                    this.propagatePlaneConstraint(crossingEdge, 3);
                    continue;
                }
                if (crossingEdgeConstraint != 2 || requiredPlane != 2) continue;
                this.propagatePlaneConstraint(crossingEdge, 3);
            }
        }
    }
}

