/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.Vector;

public class ParenthesesBlockPenn {
    private static final char L_PAREN = '(';
    private static final char R_PAREN = ')';
    public String label;
    public Vector<ParenthesesBlockPenn> subBlocks;
    int index;

    public static ParenthesesBlockPenn getParenthesesBlocks(String s) throws WongParenthesesBlockException {
        if ((s = s.trim()).charAt(0) != '(') {
            throw new WongParenthesesBlockException("Expression should start with '('");
        }
        return new ParenthesesBlockPenn(s.toCharArray(), 1);
    }

    public ParenthesesBlockPenn() {
    }

    public ParenthesesBlockPenn(char[] s, int i) throws WongParenthesesBlockException {
        this.subBlocks = new Vector();
        this.index = i;
        block5: while (true) {
            char c = s[this.index];
            switch (c) {
                case ' ': {
                    ++this.index;
                    continue block5;
                }
                case '(': {
                    this.addNewBlock(s);
                    continue block5;
                }
                case ')': {
                    if (this.subBlocks.isEmpty()) {
                        this.subBlocks = null;
                    }
                    return;
                }
            }
            if (this.label == null) {
                this.acquireLabel(s, c);
                continue;
            }
            this.acquireTerminal(s, c);
        }
    }

    private void addNewBlock(char[] s) throws WongParenthesesBlockException {
        ParenthesesBlockPenn SB = new ParenthesesBlockPenn(s, ++this.index);
        this.subBlocks.add(SB);
        this.index = SB.index + 1;
    }

    private void acquireLabel(char[] s, char c) {
        this.label = "";
        do {
            this.label = String.valueOf(this.label) + c;
        } while ((c = s[++this.index]) != ' ' && c != '(' && c != ')');
    }

    private void acquireTerminal(char[] s, char c) {
        ParenthesesBlockPenn term = new ParenthesesBlockPenn();
        term.label = "";
        do {
            term.label = String.valueOf(term.label) + c;
        } while ((c = s[++this.index]) != ' ' && c != '(' && c != ')');
        this.subBlocks.add(term);
    }

    public boolean isTerminal() {
        return this.subBlocks == null;
    }

    public String toString() {
        if (this.subBlocks == null) {
            return this.label;
        }
        StringBuilder result = new StringBuilder(String.valueOf('(') + this.label + " ");
        int size = this.subBlocks.size();
        int i = 0;
        for (ParenthesesBlockPenn p : this.subBlocks) {
            result.append(p.toString());
            if (++i == size) continue;
            result.append(" ");
        }
        result.append(')');
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        String p = "(S (NP-SBJ (NP (NNP Pierre) (NNP Vinken) ) (, ,) (ADJP (NP (CD 61) (NNS years) ) (JJ old) ) (, ,) ) (VP (MD will) (VP (VB join) (NP (DT the) (NN board) ) (PP-CLR (IN as) (NP (DT a) (JJ nonexecutive) (NN director) )) (NP-TMP (NNP Nov.) (CD 29) ))) (. .) )";
        ParenthesesBlockPenn pb = ParenthesesBlockPenn.getParenthesesBlocks(p);
        System.out.println(p);
        System.out.println(pb);
        System.out.println(pb.toString().equals(p));
    }

    public static class WongParenthesesBlockException
    extends Exception {
        public WongParenthesesBlockException(String message) {
            super(message);
        }
    }
}

