/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;
import tsg.CFSG;
import tsg.LTSG.LTSG;
import tsg.LTSG.LTSG_EM;
import tsg.LTSG.LTSG_EM_nBest;
import tsg.LTSG.LTSG_Entropy;
import tsg.LTSG.LTSG_Greedy;
import tsg.LTSG.LTSG_Naive;
import tsg.corpora.ConstCorpus;
import tsg.corpora.Wsj;
import tsg.dop.DOP_MaxDepth;
import util.FileUtil;

public class Parameters {
    public static final boolean imFedeMBP = new File("/.imFedeMBP").exists();
    public static final boolean imInSara = new File("/home/sangati/.imInSara").exists();
    public static final String homePath = String.valueOf(System.getProperty("user.home")) + "/";
    public static final String scratchPath = "/scratch/fsangati/";
    public static final String softwarePath = String.valueOf(homePath) + (imFedeMBP ? "Work/SOFTWARE/" : "SOFTWARE/");
    public static final String corpusPath = "/scratch/fsangati/CORPUS/";
    public static final String resultsPath = "/scratch/fsangati/RESULTS/";
    public static final File globalResults = new File("/scratch/fsangati/RESULTS/TSG/Trace_Results.txt");
    public static boolean writeGlobalResults = true;
    public static String bitparApp;
    public static String codeBase;
    public static String outputPath;
    public static String grammarType;
    public static File trainingProcessed;
    public static File testGold;
    public static File testGoldCovered;
    public static File testFlat;
    public static File testExtrWords;
    public static String corpusName;
    public static int lengthLimitTraining;
    public static int lengthLimitTest;
    public static boolean traces;
    public static boolean removePunctStartEnd;
    public static boolean removeNonNecessaryLables;
    public static boolean removeRedundantRules;
    public static boolean raisePunctuation;
    public static int ukLimit;
    public static boolean semanticTags;
    public static boolean replaceNumbers;
    public static String[] internalLabels;
    public static String[] posTagLabels;
    public static Hashtable<String, Integer> lexiconTable;
    public static boolean toNormalForm;
    public static int maxDepth;
    public static int maxTreesInDepth;
    public static String LTSGtype;
    public static boolean cutTopRecursion;
    public static boolean delexicalize;
    public static int removeTreesLimit;
    public static boolean smoothing;
    public static int smoothingFactor;
    public static boolean spineConversion;
    public static boolean removeRedundencyInSpine;
    public static boolean posTagConversion;
    public static boolean jollyConversion;
    public static boolean jollyInclusion;
    public static String[] jollyLabels;
    public static int naive_iterations;
    public static boolean greedy_punctuation;
    public static int greedy_ambiguityChoice;
    private static String[] ambiguityChoice;
    public static String startingHeads;
    public static int orderOfChange;
    public static int maxNumberOfChanges;
    public static int maxEntropyCycles;
    public static double entropy_delta_threshold;
    public static int EM_nBest;
    public static double EM_deltaThreshold;
    public static int EM_maxCycle;
    public static String EM_initialization;
    public static String parserName;
    public static int nBest;
    public static boolean cachingActive;
    public static boolean markHeadsInPostprocessing;
    public static boolean makeCoveredStatistics;
    public static boolean makeOracleStatistics;
    public static File paramFile;
    public static File logFile;
    public static PrintWriter logPW;
    public static ConstCorpus trainingCorpus;
    public static ConstCorpus testCorpus;

    static {
        String string = imFedeMBP ? "/Users/fedja/Work/SOFTWARE/BitPar_Web/bitpar" : (bitparApp = imInSara ? "/home/sangati/SOFTWARE/BitPar_Web/bitpar" : "/home/fsangati/SOFTWARE/BitPar_Web/bitpar");
        codeBase = imFedeMBP ? "/Users/fedja/Work/Code/TreeGrammars/" : (imInSara ? "/home/sangati/Code/TreeGrammars/" : "/home/fsangati/Code/TreeGrammars/");
        ambiguityChoice = new String[]{"random", "left", "right", "backoff to lexicon"};
    }

    public static void openLogFile(File lf) {
        logFile = lf;
        logPW = FileUtil.getPrintWriter(logFile);
    }

    public static void closeLogFile() {
        if (logPW != null) {
            logPW.close();
        }
    }

    public static void reportString(String lineLog) {
        if (logPW != null) {
            logPW.print(lineLog);
        }
        System.out.print(lineLog);
    }

    public static void reportStringFlush(String lineLog) {
        if (logPW != null) {
            logPW.print(lineLog);
            logPW.flush();
        }
        System.out.print(lineLog);
    }

    public static void reportLine(String lineLog) {
        if (logPW != null) {
            logPW.println(lineLog);
        }
        System.out.println(lineLog);
    }

    public static void reportLineFlush(String lineLog) {
        if (logPW != null) {
            logPW.println(lineLog);
            logPW.flush();
        }
        System.out.println(lineLog);
    }

    public static void reportError(String lineLog) {
        if (logPW != null) {
            logPW.println(lineLog);
            logPW.flush();
        }
        System.err.println(lineLog);
    }

    public static void logPrintln(String lineLog) {
        if (logPW != null) {
            logPW.println(lineLog);
        }
    }

    public static void logStdOutPrintln(String lineLog) {
        if (logPW != null) {
            logPW.println(lineLog);
        }
        System.out.println(lineLog);
    }

    public static void appendReturnInLogFile(String lineLog) {
        if (logFile != null) {
            FileUtil.appendReturn(lineLog, logFile);
        }
    }

    public static void appendInLogFile(String lineLog) {
        if (logFile != null) {
            FileUtil.append(lineLog, logFile);
        }
    }

    public static void newRun(Object grammar) {
        Parameters.buildDirectory();
        if (corpusName.equals("Wsj")) {
            Wsj.retriveTrainingAndTestCorpus();
        } else if (!(corpusName.equals("Parc") || corpusName.equals("Negra") || corpusName.equals("Tiger") || corpusName.equals("noProcess"))) {
            System.err.println("Corpus name not yet implemented");
            System.exit(-1);
        }
        Parameters.writeParam(grammar);
        FileUtil.appendReturn("Read corpus. Total # of sentences: " + trainingCorpus.size(), logFile);
    }

    public static void buildDirectory() {
        if (!outputPath.endsWith("/")) {
            outputPath = String.valueOf(outputPath) + "/";
        }
        outputPath = String.valueOf(outputPath) + FileUtil.dateTimeString() + "/";
        File f = new File(outputPath);
        f.mkdirs();
        paramFile = new File(String.valueOf(outputPath) + "Parameters");
        logFile = new File(String.valueOf(outputPath) + "Log");
        trainingProcessed = new File(String.valueOf(outputPath) + "TrainingCorpus.processed");
        testGold = new File(String.valueOf(outputPath) + "TestCorpus.gold");
        testGoldCovered = new File(String.valueOf(outputPath) + "TestCorpus.gold.covered");
        testFlat = new File(String.valueOf(outputPath) + "TestCorpus.flat");
        testExtrWords = new File(String.valueOf(outputPath) + "TestCorpus.extrWords");
        System.out.println("Output folder: " + outputPath);
    }

    private static void writeParam(Object grammar) {
        String param = grammarType = grammar.getClass().getName();
        if (CFSG.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\nTraining Length Limit: " + lengthLimitTraining;
            param = String.valueOf(param) + "\nTesting Length Limit: " + lengthLimitTest;
            param = String.valueOf(param) + "\nUnknown Threshold (<=): " + ukLimit;
            param = String.valueOf(param) + "\nSemantic Tags: " + semanticTags;
            param = String.valueOf(param) + "\nReplace numbers with unique tag: " + replaceNumbers;
            param = String.valueOf(param) + "\nTraces are present (-NONE-, NP-2): " + traces;
            param = String.valueOf(param) + "\nRemove non-necessary labels (" + Arrays.toString(Wsj.nonNecessaryLabels) + "): " + removeNonNecessaryLables;
            param = String.valueOf(param) + "\nRemove punctuation at the start and end of each sentence: " + removePunctStartEnd;
            param = String.valueOf(param) + "\nRemove redundant rules (S -> S): " + removeRedundantRules;
            param = String.valueOf(param) + "\nRaise punctuation: " + raisePunctuation;
            if (corpusName.equals("Wsj")) {
                param = String.valueOf(param) + Wsj.writeParam();
            }
        }
        if (CFSG.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\nConvert CFG rules to normal form: " + toNormalForm;
        }
        if (DOP_MaxDepth.class.isAssignableFrom(grammar.getClass())) {
            grammarType = String.valueOf(grammarType) + "_depth" + maxDepth;
            param = String.valueOf(param) + "\n\nMax Depth: " + maxDepth;
            param = String.valueOf(param) + "\nMax Trees for depth > 1: " + maxTreesInDepth;
        }
        if (LTSG.class.isAssignableFrom(grammar.getClass())) {
            grammarType = String.valueOf(grammarType) + "_" + LTSGtype;
            param = String.valueOf(param) + "\n\nLTSG type " + LTSGtype;
            param = String.valueOf(param) + "\n\nCut top recursions: " + cutTopRecursion;
            param = String.valueOf(param) + "\nDelexicalization: " + delexicalize;
            param = String.valueOf(param) + "\nRemove trees occurring <= " + removeTreesLimit;
            param = String.valueOf(param) + "\nSmoothing: " + smoothing + (smoothing ? "\t(Smoothing Factor: " + smoothingFactor + " )" : "");
            if (!smoothing) {
                smoothingFactor = 1;
            }
            param = String.valueOf(param) + "\nConversion to spine: " + spineConversion;
            param = String.valueOf(param) + "\nRemove redundency in spine: " + removeRedundencyInSpine;
            param = String.valueOf(param) + "\nConversion to posTags: " + posTagConversion;
            param = String.valueOf(param) + "\nJolly Conversion: " + jollyConversion;
            if (jollyConversion) {
                param = String.valueOf(param) + (jollyInclusion ? " (inclusion)" : " (exclusion)");
                param = String.valueOf(param) + "\n\tJolly labels: " + Arrays.toString(jollyLabels);
            }
        }
        if (LTSG_Naive.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\nIterations: " + naive_iterations;
        }
        if (LTSG_EM.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\nEM_nBest: " + EM_nBest;
            param = String.valueOf(param) + "\nEM_deltaThreshold: " + EM_deltaThreshold;
            param = String.valueOf(param) + "\nEM_maxCycle: " + EM_maxCycle;
            param = String.valueOf(param) + "\nEM_initialization: " + EM_initialization;
        }
        if (LTSG_Greedy.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\n\tPunctuation: " + greedy_punctuation;
            param = String.valueOf(param) + "\n\tAmbiguity Choice: " + ambiguityChoice[greedy_ambiguityChoice];
        }
        if (LTSG_Entropy.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\nStarting from Heads: " + startingHeads;
            param = String.valueOf(param) + "\nOrder of change: " + LTSG_Entropy.OrderOfChangeTypes[orderOfChange];
            param = String.valueOf(param) + "\nNumber of changes per tree per cylces: " + maxNumberOfChanges;
            param = String.valueOf(param) + "\nMaximum number of cycles: " + maxEntropyCycles;
            param = String.valueOf(param) + "\nDelta threshold: " + entropy_delta_threshold;
        }
        if (LTSG_EM_nBest.class.isAssignableFrom(grammar.getClass())) {
            param = String.valueOf(param) + "\n\nEM n best: " + EM_nBest;
            param = String.valueOf(param) + "\nEM delta threshold: " + EM_deltaThreshold;
            param = String.valueOf(param) + "\nEM max cycles: " + EM_maxCycle;
        }
        param = String.valueOf(param) + "\n\nParser name: " + parserName;
        param = String.valueOf(param) + "\nnBest: " + nBest;
        param = String.valueOf(param) + "\nCaching Active: " + cachingActive;
        param = String.valueOf(param) + "\nMark heads in postprocessing: " + markHeadsInPostprocessing;
        param = String.valueOf(param) + "\nMake statistics for covered sentences: " + makeCoveredStatistics;
        param = String.valueOf(param) + "\nMake oracle statistics: " + makeOracleStatistics;
        FileUtil.appendReturn(param, paramFile);
    }

    public static void printTrainingCorpusToFile() {
        trainingCorpus.toFile_Complete(trainingProcessed, true);
    }

    public static void printTestCorpusToFile() {
        testCorpus.toFile_Complete(testGold, false);
        testCorpus.toFile_Flat(testFlat);
        testCorpus.toFile_ExtractWords(testExtrWords);
    }

    public static void printTrainingAndTest() {
        Parameters.printTrainingCorpusToFile();
        Parameters.printTestCorpusToFile();
    }

    public static void setDefaultParam() {
        corpusName = "Wsj";
        lengthLimitTraining = 20;
        lengthLimitTest = 20;
        Wsj.initialHeads = 0;
        traces = false;
        Wsj.testSet = "22";
        Wsj.skip120TrainingSentences = false;
        removeNonNecessaryLables = true;
        removePunctStartEnd = true;
        raisePunctuation = true;
        removeRedundantRules = true;
        toNormalForm = false;
        Wsj.transformNPbasal = true;
        Wsj.transformSG = false;
        semanticTags = true;
        replaceNumbers = true;
        ukLimit = 1;
        cutTopRecursion = false;
        delexicalize = false;
        removeTreesLimit = -1;
        smoothing = true;
        smoothingFactor = 100;
        parserName = "bitPar";
        nBest = 1;
        markHeadsInPostprocessing = true;
        makeCoveredStatistics = !smoothing;
        makeOracleStatistics = nBest > 1;
    }

    public static void main(String[] args) {
    }
}

