import os
import openai
import json
from u_utils import excel_utils


class AzureApiConfig:
    def __init__(self):
        self.api_key = 'your_api_key'
        self.api_base = 'your_api_base'
        self.api_type = "azure"
        self.api_version = "2023-03-15-preview"


class Prompt:
    def __init__(self):
        self.template = ""
        self.instruction = ""
        self.input_content = ""
        self.examples = ""

    def build_prompt_obj(self, instruction, input_content, examples=None):
        if not instruction or not input_content:
            print("Please enter an instruction and an input_content")
            return None
        self.instruction = instruction
        self.input_content = input_content
        self.examples = examples

    def build_prompt_obj_from_files(self, instruction_file, input_content_file, examples_file=None):
        instruction = excel_utils.read_txt_from_file(instruction_file)
        input_content = excel_utils.read_txt_from_file(input_content_file)
        if examples_file:
            examples = excel_utils.read_txt_from_file(examples_file)
        else:
            examples = None
        return self.build_prompt_obj(instruction, input_content, examples)

    def build_prompt_from_template(self, template, instruction, input_content, examples=None):
        res = ""
        self.template = template
        self.instruction = instruction
        self.input_content = input_content
        self.examples = examples
        return res


class AzureCaller:
    @classmethod
    def __init__(cls, azure_api_config):
        openai.api_type = azure_api_config.api_type
        openai.api_key = azure_api_config.api_key
        openai.api_base = azure_api_config.api_base
        openai.api_version = azure_api_config.api_version

    @classmethod
    def chat_completion(cls, prompt):
        instruction = prompt.instruction
        if prompt.examples:
            instruction = instruction + prompt.examples
        messages = [{"role": "system", "content": instruction},
                    {"role": "user", "content": prompt.input_content}]
        response = openai.ChatCompletion.create(
            engine="ChatGPT",
            # engine="gpt-3.5-turbo",
            messages=messages,
            temperature=0.2,
            max_tokens=1600,
            top_p=0.95,
            frequency_penalty=0,
            presence_penalty=0,
            timeout=15,
            stop=None)
        return response




















