from .serpapi import Searcher as SerpAPISearcher
from .bing_search import Searcher as BingSearcher
from .searcher import SearchResult, SearcherInterface

def create_searcher(name):
    """
    根据名称创建搜索器对象，目前支持'serpapi'和'bing'两种搜索器。其他的搜索器将会引发NotImplementedError异常。
    
    Args:
        name (str): 搜索器的名称，可以是'serpapi'或者'bing'中的任意一个。
    
    Returns:
        Searcher: 返回一个Searcher对象，该对象实现了Searcher接口。如果传入的名称不在支持列表中，则会引发NotImplementedError异常。
    
    Raises:
        NotImplementedError: 当传入的名称不在支持列表中时会引发此异常。
    """
    if name == "serpapi":
        return SerpAPISearcher()
    elif name == "bing":
        return BingSearcher()
    else:
        raise NotImplementedError()