/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.fusesource.lmdbjni.DirectBuffer;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.NativeObject;
import org.fusesource.lmdbjni.Unsafe;
import org.fusesource.lmdbjni.Util;

public class Transaction
extends NativeObject
implements Closeable {
    private DirectBuffer buffer;
    private boolean readOnly;

    Transaction(long self, boolean readOnly) {
        super(self);
        this.readOnly = readOnly;
    }

    public long getId() {
        return JNI.mdb_txn_id(this.pointer());
    }

    public void renew() {
        Util.checkErrorCode(JNI.mdb_txn_renew(this.pointer()));
    }

    public void commit() {
        if (this.self != 0L) {
            Util.checkErrorCode(JNI.mdb_txn_commit(this.self));
            this.self = 0L;
        }
    }

    public void reset() {
        this.checkAllocated();
        JNI.mdb_txn_reset(this.pointer());
    }

    public void abort() {
        if (this.self != 0L) {
            JNI.mdb_txn_abort(this.self);
            this.self = 0L;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    long getBufferAddress() {
        if (this.buffer == null) {
            this.buffer = new DirectBuffer(ByteBuffer.allocateDirect(Unsafe.ADDRESS_SIZE * 4));
        }
        return this.buffer.addressOffset();
    }

    @Override
    public void close() {
        this.abort();
    }
}

