/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.graph;

import edu.stanford.nlp.graph.Graph;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DijkstraShortestPath {
    private DijkstraShortestPath() {
    }

    public static <V, E> List<V> getShortestPath(Graph<V, E> graph, V node1, V node2, boolean directionSensitive) {
        if (node1.equals(node2)) {
            return Collections.singletonList(node2);
        }
        Set visited = Generics.newHashSet();
        Map previous = Generics.newHashMap();
        BinaryHeapPriorityQueue<V> unsettledNodes = new BinaryHeapPriorityQueue<V>();
        unsettledNodes.add(node1, 0.0);
        while (unsettledNodes.size() > 0) {
            double distance = unsettledNodes.getPriority();
            Object u = unsettledNodes.removeFirst();
            visited.add(u);
            if (u.equals(node2)) break;
            unsettledNodes.remove(u);
            Set<V> candidates = directionSensitive ? graph.getChildren(u) : graph.getNeighbors(u);
            Iterator<V> i$ = candidates.iterator();
            while (i$.hasNext()) {
                double alt = distance - 1.0;
                V candidate = i$.next();
                if (!(alt > unsettledNodes.getPriority(candidate)) || visited.contains(candidate)) continue;
                unsettledNodes.relaxPriority(candidate, alt);
                previous.put(candidate, u);
            }
        }
        if (!previous.containsKey(node2)) {
            return null;
        }
        ArrayList path = new ArrayList();
        path.add(node2);
        V n = node2;
        while (previous.containsKey(n)) {
            path.add(previous.get(n));
            n = previous.get(n);
        }
        Collections.reverse(path);
        return path;
    }
}

