import pickle
from config import large_datasets_only

with open('dataset_info_dict_20240223.pkl', 'rb') as f:
    dataset_info_dict = pickle.load(f)


duplicates = [
    'davanstrien__test_imdb_embedd2_default',
    'davanstrien__test_imdb_embedd_default',
    'davanstrien__test1_default',
    'shunk031__JGLUE_JSTS'
]

for ds in duplicates:
    del dataset_info_dict[ds]

dataset_info_dict['imdb_plain_text']['splits']['validation'] = 'test'

dataset_info_dict['tweet_eval_emotion']['splits']['validation'] = 'validation'
dataset_info_dict['tweet_eval_sentiment']['splits']['validation'] = 'validation'

dataset_info_dict['rotten_tomatoes_default']['splits']['validation'] = 'validation'

dataset_info_dict['llm-book__JGLUE_JSTS']['splits']['validation'] = 'validation'
dataset_info_dict['google_wellformed_query_default']['splits']['validation'] = 'validation'
dataset_info_dict['paws-x_en']['splits']['validation'] = 'validation'
dataset_info_dict['md_gender_bias_convai2_inferred']['splits']['validation'] = 'validation'
dataset_info_dict['google__civil_comments_default']['splits']['validation'] = 'validation'


if not large_datasets_only:
    dataset_info_dict.update({

        'snli': {'name': 'snli', 'subset': None, 'input': ('premise', 'hypothesis'), 'label': 'label',
                 'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                 'filter': lambda example: example['label'] != -1,
                 'metric': 'accuracy',
                 'task_type': 'classification'},

        'glue_mnli': {'name': 'glue', 'subset': 'mnli', 'input': ('premise', 'hypothesis'), 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation_matched', 'test': 'test_matched'},
                      'metric': 'accuracy',
                 'task_type': 'classification'},
                      # 'filter': lambda example: example['label'] != -1},

        'glue_qqp': {'name': 'glue', 'subset': 'qqp', 'input': ('question1', 'question2'), 'label': 'label',
                     'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                     # 'metric': 'f1'},
                     'metric': ('accuracy', 'f1'),
                 'task_type': 'classification'},
                     # 'filter': lambda example: example['label'] != -1},

        'glue_qnli': {'name': 'glue', 'subset': 'qnli', 'input': ('question', 'sentence'), 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                      'metric': 'accuracy',
                 'task_type': 'classification'},

        'glue_sst2': {'name': 'glue', 'subset': 'sst2', 'input': 'sentence', 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                      'metric': 'accuracy',
                 'task_type': 'classification'},

        'glue_cola': {'name': 'glue', 'subset': 'cola', 'input': 'sentence', 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                      # 'metric': 'accuracy'},
                      'metric': 'matthews_corr',
                 'task_type': 'classification'},

        'glue_stsb': {'name': 'glue', 'subset': 'stsb', 'input': ('sentence1', 'sentence2'), 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                      'metric': ('pearson_corr', 'spearman_corr'),
                 'task_type': 'regression'},

        'glue_mrpc': {'name': 'glue', 'subset': 'mrpc', 'input': ('sentence1', 'sentence2'), 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                      # 'metric': 'f1'},
                      'metric': ('accuracy', 'f1'),
                 'task_type': 'classification'},

    'glue_rte': {'name': 'glue', 'subset': 'rte', 'input': ('sentence1', 'sentence2'), 'label': 'label',
                     'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                     'metric': 'accuracy',
                 'task_type': 'classification'},

        'glue_wnli': {'name': 'glue', 'subset': 'wnli', 'input': ('sentence1', 'sentence2'), 'label': 'label',
                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                      'metric': 'accuracy',
                 'task_type': 'classification'},

        'scitail': {'name': 'scitail', 'subset': 'tsv_format', 'input': ('premise', 'hypothesis'), 'label': 'label',
                    'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'},
                    'metric': 'accuracy',
                 'task_type': 'classification'},

        'imdb': {'name': 'imdb', 'subset': None, 'input': 'text', 'label': 'label',
                 'splits': {'train': 'train', 'validation': None, 'test': 'test'}},

        'dbpedia_14': {'name': 'dbpedia_14', 'subset': None, 'input': ('title', 'content'), 'label': 'label',
                       'splits': {'train': 'train', 'validation': None, 'test': 'test'}},

        'ag_news': {'name': 'ag_news', 'subset': None, 'input': 'text', 'label': 'label',
                    'splits': {'train': 'train', 'validation': None, 'test': 'test'}},

        'trec_coarse': {'name': 'trec', 'subset': None, 'input': 'text', 'label': 'label-coarse',
                        'splits': {'train': 'train', 'validation': None, 'test': 'test'}},

        'trec_fine': {'name': 'trec', 'subset': None, 'input': 'text', 'label': 'label-fine',
                      'splits': {'train': 'train', 'validation': None, 'test': 'test'}},

        'tweet_eval_emoji': {'name': 'tweet_eval', 'subset': 'emoji', 'input': 'text', 'label': 'label',
                             'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_emotion': {'name': 'tweet_eval', 'subset': 'emotion', 'input': 'text', 'label': 'label',
                               'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_hate': {'name': 'tweet_eval', 'subset': 'hate', 'input': 'text', 'label': 'label',
                            'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_irony': {'name': 'tweet_eval', 'subset': 'irony', 'input': 'text', 'label': 'label',
                             'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_offensive': {'name': 'tweet_eval', 'subset': 'offensive', 'input': 'text', 'label': 'label',
                                 'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_sentiment': {'name': 'tweet_eval', 'subset': 'sentiment', 'input': 'text', 'label': 'label',
                                 'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_stance_abortion': {'name': 'tweet_eval', 'subset': 'stance_abortion', 'input': 'text', 'label': 'label',
                                       'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_stance_atheism': {'name': 'tweet_eval', 'subset': 'stance_atheism', 'input': 'text', 'label': 'label',
                                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_stance_climate': {'name': 'tweet_eval', 'subset': 'stance_climate', 'input': 'text', 'label': 'label',
                                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_stance_feminist': {'name': 'tweet_eval', 'subset': 'stance_feminist', 'input': 'text', 'label': 'label',
                                       'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'tweet_eval_stance_hillary': {'name': 'tweet_eval', 'subset': 'stance_hillary', 'input': 'text', 'label': 'label',
                                      'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'yelp_review_full': {'name': 'yelp_review_full', 'subset': None, 'input': 'text', 'label': 'label',
                             'splits': {'train': 'train', 'validation': None, 'test': 'test'}},

        'amazon_reviews_multi_stars': {'name': 'amazon_reviews_multi', 'subset': 'en',
                                       'input': ('review_body', 'review_title'), 'label': 'stars',
                                       'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'amazon_reviews_multi_product_category': {'name': 'amazon_reviews_multi', 'subset': 'en',
                                                  'input': ('review_body', 'review_title'), 'label': 'product_category',
                                                  'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},  #STRING

        'emotion': {'name': 'emotion', 'subset': 'split', 'input': 'text', 'label': 'label',
                    'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'hate_speech18': {'name': 'hate_speech18', 'subset': None, 'input': 'text', 'label': 'label',
                          'splits': 'train'},

        'go_emotions': {'name': 'go_emotions', 'subset': 'simplified', 'input': 'text', 'label': 'labels',
                        'splits': {'train': 'train', 'validation': 'validation', 'test': 'test'}},

        'app_reviews': {'name': 'app_reviews', 'subset': None, 'input': 'review', 'label': 'star',
                        'splits': 'train'}
    })
