from sentence_transformers import SentenceTransformer
import torch

model = SentenceTransformer("sentence-transformers/paraphrase-TinyBERT-L6-v2")

def sentencebert_encode(input_text):
    embedding = model.encode(input_text)

    embedding = torch.tensor(embedding)

    embedding = torch.unsqueeze(embedding, dim=1)

    assert embedding.shape == (len(input_text), 1, 768)

    return embedding
