theory question_52_5

imports Main

begin

typedecl entity
typedecl event

consts
  AdultSponges :: "entity ⇒ bool"
  Gametes :: "entity ⇒ bool"
  Eggs :: "entity ⇒ bool"
  Sperm :: "entity ⇒ bool"
  Produce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Adult sponges produce gametes, which are either eggs or sperm, and the gametes are the patients of the production events. *)
axiomatization where
  explanation_1: "∀x e y. AdultSponges x ⟶ (Gametes y ∧ (Eggs y ∨ Sperm y) ∧ Produce e ∧ Agent e x ∧ Patient e y)"

theorem hypothesis:
  assumes asm: "AdultSponges x"
  (* Hypothesis: Adult sponges produce gametes. *)
  shows "∃e y. Produce e ∧ Agent e x ∧ Gametes y ∧ Patient e y"
proof -
  from asm have "AdultSponges x" by simp
  then obtain e y where e: "Produce e ∧ Agent e x ∧ Gametes y ∧ Patient e y" using explanation_1 by blast
  show ?thesis using e by blast
qed

end
