theory question_27_3

imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  OldMan :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  Dirty :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"

(* Explanation 1: The man is on a dirty sidewalk. Sidewalks are found outdoors, therefore, the man is outside *)
axiomatization where
  explanation_1: "∃x y. Man x ∧ Sidewalk y ∧ Dirty y ∧ Outdoors y ∧ On x y ⟶ Outside x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "OldMan x ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "OldMan x ∧ Sidewalk z ∧ Dirty z ∧ On x z" by blast
  then have "Man x ∧ Sidewalk z ∧ Dirty z ∧ Outdoors z ∧ On x z" using OldMan by blast
  then have "Man x ∧ Outside x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
