theory question_42_0

imports Main

begin

typedecl entity
typedecl event

consts
  BipedalDinosaurs :: "entity ⇒ bool"
  Theropods :: "entity ⇒ bool"
  Birds :: "entity ⇒ bool"
  Evolved :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Dromaeosaurs :: "entity ⇒ bool"

(* Explanation 1: Birds evolved from a group of bipedal dinosaurs called theropods. *)
axiomatization where
  explanation_1: "∀x y e. BipedalDinosaurs x ∧ Theropods x ∧ Birds y ∧ Evolved e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Dromaeosaurs are part of the theropod group of dinosaurs. *)
axiomatization where
  explanation_2: "∀x. Dromaeosaurs x ⟶ Theropods x"  

theorem hypothesis:
  assumes asm: "BipedalDinosaurs x ∧ Dromaeosaurs x"
  (* Hypothesis: The group of bipedal dinosaurs that included Dromaeosaurs eventually evolved into birds. *)
  shows "∃x y e. BipedalDinosaurs x ∧ Dromaeosaurs x ∧ Birds y ∧ Evolved e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BipedalDinosaurs x ∧ Dromaeosaurs x" by simp
  then have "Theropods x" using explanation_2 by blast
  then obtain y e where "Birds y ∧ Evolved e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm `Birds y` `Evolved e` `Agent e x` `Patient e y` by blast
qed

end
