import sys

import pandas as pd

permutation = pd.read_csv(sys.argv[2], names=["input", "permuted"])
equivalence = pd.read_csv("equivalence.csv", names=["input", "equivalent", "relation"])

# read character by character from a file on stdin
def permute_str(input):
    permuted_str = ""
    skipcount = 0
    for char, next in zip(input, input[1:] + " "):
        relation = None
        lowered = False
        # find the equivalent character
        if skipcount > 0:
            skipcount -= 1
            continue

        if char.lower() != char:
            lowered = True
        char = char.lower()

        if char == 'c' and next == 'h':
            if lowered:
                char = 'T'
            else:
                char = 't'
            permuted_str += char + 's'
            skipcount = 1
            continue

        if char in equivalence["input"].values:
            relation = equivalence[equivalence["input"] == char]["relation"].iloc[0]
            char = equivalence[equivalence["input"] == char]["equivalent"].iloc[0]
        if char in permutation["input"].values:
            # find the permutation of the character
            char = permutation[permutation["input"] == char]["permuted"].iloc[0]
        if relation is not None:
            char = equivalence[
                (equivalence["equivalent"] == char) & (equivalence.relation == relation)
            ]["input"].iloc[0]
        if lowered:
            char = char.upper()
        permuted_str += char
    return permuted_str


if __name__ == "__main__":
    df = pd.read_csv(sys.argv[1], sep="\t")
    df["Source"] = df["Source"].apply(permute_str)
    if "Target" in df.columns:
        df["Target"] = df["Target"].apply(permute_str)
    df.to_csv(sys.stdout, index=False, sep="\t")
