from sister_terms_similarity.test_sister_terms_in_voc import test_all_models_on_in_voc_micro_lists


def test_all_models_in_voc_micro_lists_main(model_mappings=None):
    if model_mappings is None:
        pretained_model = 'data/pretrained_embeddings/GoogleNews-vectors-negative300.bin'
        pretained_model_ft = 'data/pretrained_embeddings/cc.en.300.bin'
        models = [
            ('data/similarity_pedersen_test/fasttext_sister_terms/seed_19',
             {'fasttext': ['fasttext', pretained_model_ft]}),
            ('data/similarity_pedersen_test/sister_terms/seed_19', {'w2v': ['w2v', pretained_model]})
        ]

    similarities_function_names = ['res', 'wup', 'path']
    for root_data_path, model_mappings in models:
        root_data_path = root_data_path

        destination_dir = "results_micro_list"
        test_all_models_on_in_voc_micro_lists(model_mappings, root_data_path, destination_dir,
                                              similarities_function_names=similarities_function_names)


test_all_models_in_voc_micro_lists_main()
