def _load_spacy():
    """ Loads spacy into the global namespace. """
    if 'spacy_nlp' not in globals():
        import spacy
        try:
            global spacy_nlp
            import en_core_web_sm
            spacy_nlp = en_core_web_sm.load()
        except Exception as e:
            print("Failed to load \'en\' with exception {}. Try: python -m spacy download en_core_web_sm".format(e))
            raise

_load_spacy()

def clean(s):
    """ Cleans a string for compact output.
    :Example:
    >>> clean(\'*This string\\nneeds a good clean.--\\n\\n*\')
    \'This string needs a good clean.\'
    """
    garbage_chars = ['\n', '*', '-']
    for c in garbage_chars:
        s = s.replace(c, ' ')
    return s.strip()




def tokenize(str):
    """ Returns a list of tokens in a string (using Spacy).
    :Example:
    >>> tokenize('This is an example sentence.')
    ['this', 'is', 'an', 'example', 'sentence', '.']
    """
    #_load_spacy()
    doc = spacy_nlp(str)
    return [word.lower_ for word in doc]


def unabbreviate(action):
    """ Returns an unabbreviated version of a text action.
    :Example:
    >>> unabbreviate('nw')
    'northwest'
    >>> unabbreviate('x sewer')
    'examine sewer'
    """
    unabbrv = []
    for w in action.strip().lower().split():
        if w in defines.ABBRV_DICT:
            unabbrv.append(defines.ABBRV_DICT[w])
        else:
            unabbrv.append(w)
    return ' '.join(unabbrv)
