"""
For logging.
"""

import os
import sys
import logging

from few_shot_ner.io import create_directories


def init_root_logger(filename=None, filemode='w', level=logging.INFO,
                     format='%(asctime)s - %(name)s - %(levelname)s - %(message)s'):
    log_formatter = logging.Formatter(format)
    root_logger = logging.getLogger()
    root_logger.setLevel(level)

    console_handler = logging.StreamHandler(sys.stdout)
    console_handler.setFormatter(log_formatter)
    root_logger.addHandler(console_handler)

    if filename is not None:
        create_directories(os.path.dirname(filename))
        file_handler = logging.FileHandler(filename)
        file_handler.setFormatter(log_formatter)
        root_logger.addHandler(file_handler)

    return root_logger
