import argparse

label_tokens = [
    "?QUESTIONMARK",
    ".PERIOD",
    ",COMMA",
    "!EXCLAMATIONMARK",
    "-DASH",
    ":COLON",
    ";SEMICOLON"
]

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input", type=str, required=True, help="Path to input predictions file")
    parser.add_argument("--output", type=str, required=True, help="Path to output target file")
    args = parser.parse_args()

    with open(args.input, 'r') as f:
        text = f.read()

    tokens = text.split()
    last_token = None
    with open(args.output, 'w') as f:
        for token in tokens:
            if token in label_tokens:
                f.write(f"{last_token}\t{token}\n")
                last_token = None
            elif last_token is not None:
                f.write(f"{last_token}\tO\n")
                last_token = token
            else:
                last_token = token

        if last_token is not None:
            f.write(f"{last_token}\tO\n")