/*
 * Decompiled with CFR 0.152.
 */
package xml_parsers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXReader
extends DefaultHandler {
    protected final int kStringBuilder = 10240;
    protected StringBuilder strBuilder = null;
    protected XMLReader reader = null;

    protected void enableReader() {
        block2: {
            try {
                this.reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                this.reader.setContentHandler(this);
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block2;
                e.printStackTrace(System.err);
            }
        }
    }

    protected void disableReader() {
        this.reader = null;
    }

    public String getText(String xmlfile) {
        this.enableReader();
        this.strBuilder = new StringBuilder(10240);
        try {
            this.reader.parse(xmlfile);
            this.disableReader();
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return "";
        }
        return this.strBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(String xmlfile, String plainfile) {
        this.enableReader();
        this.strBuilder = new StringBuilder(10240);
        try {
            this.reader.parse(xmlfile);
            this.disableReader();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(plainfile))), Charset.forName("UTF8"));
            try {
                writer.append(this.strBuilder);
                writer.write("\n");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return false;
        }
        return true;
    }
}

