# -*- coding: utf-8 -*-

import pyshrg


def count_items(context: pyshrg.Context, root: pyshrg.ChartItem, visited=None):
    if visited is None:
        visited = set()
    count = 0
    for chart_item in root.all():
        if chart_item in visited:
            continue
        visited.add(chart_item)
        count += 1
        left, right = context.split_item(chart_item)
        if left:
            count += count_items(context, left, visited)
        if right:
            count += count_items(context, right, visited)
    return count


def iter_items(context, root):
    for chart_item in root.all():
        if chart_item.cfg_index == -1000:
            continue
        chart_item.cfg_index = -1000
        yield chart_item

        left, right = context.split_item(chart_item)
        if left:
            yield from iter_items(context, left)
        if right:
            yield from iter_items(context, right)
