function val = essential_costE2cost(X, costE)
% Cost evaluation at X given function handle in the Essential matrix E.
%
% function val = essential_costE2cost(X, costE)
%
% costE is the function handle for the cost function in E.
%
% See also: essential_egradE2egrad essential_ehessE2ehess

% This file is part of Manopt: www.manopt.org.
% Original author: Roberto Tron, Aug. 8, 2014
% Contributors: Bamdev Mishra, May 22, 2015.

    e3hat = [0 -1 0; 1 0 0; 0 0 0];
    
    RA = X(:,1:3,:); 
    RB = X(:,4:6,:); 
    E = multiprod(multiprod(multitransp(RA), e3hat), RB); 
    
    val = costE(E);
end
