/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.db;

import java.io.File;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import simplenlg.features.Category;
import simplenlg.lexicon.DatabaseBackedLexicon;
import simplenlg.lexicon.db.DBAccessor;
import simplenlg.lexicon.db.XMLHandler;

public class XMLAccessor
implements DBAccessor {
    private String xmlfilename = null;
    private DatabaseBackedLexicon lexicon = null;
    private XMLReader parser;

    public XMLAccessor() {
        try {
            this.parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public XMLAccessor(String filename) {
        this();
        this.xmlfilename = filename;
    }

    public XMLAccessor(File file) {
        this();
        this.xmlfilename = file.getAbsolutePath();
    }

    @Override
    public void setLexicon(DatabaseBackedLexicon lex) {
        this.lexicon = lex;
    }

    @Override
    public boolean hasLexicon() {
        return this.lexicon != null;
    }

    @Override
    public void loadData() throws Exception {
        XMLHandler handler = new XMLHandler();
        handler.setLexicon(this.lexicon);
        this.parser.setContentHandler(handler);
        this.parser.parse(this.xmlfilename);
    }

    @Override
    public void loadData(Category ... categories) throws Exception {
        for (Category cat : categories) {
            XMLHandler handler = new XMLHandler();
            handler.setCat(cat);
            handler.setLexicon(this.lexicon);
            this.parser.setContentHandler(handler);
            this.parser.parse(this.xmlfilename);
        }
    }

    @Override
    public void loadItem(Category cat, String baseform) throws Exception {
        XMLHandler handler = new XMLHandler(cat, baseform);
        handler.setLexicon(this.lexicon);
        this.parser.setContentHandler(handler);
        this.parser.parse(this.xmlfilename);
    }

    @Override
    public void loadItemByID(String id) throws Exception {
        XMLHandler handler = new XMLHandler();
        handler.setId(id);
        handler.setLexicon(this.lexicon);
        this.parser.setContentHandler(handler);
        this.parser.parse(this.xmlfilename);
    }

    @Override
    public void loadItemsByBaseform(String baseform) throws Exception {
        XMLHandler handler = new XMLHandler(baseform);
        handler.setLexicon(this.lexicon);
        this.parser.setContentHandler(handler);
        this.parser.parse(this.xmlfilename);
    }

    @Override
    public void connect() throws Exception {
    }
}

