/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.formatter;

import java.util.List;

public abstract class Formatter {
    protected static final String NEW_LINE = "\r\n";

    public String getNEW_LINE() {
        return NEW_LINE;
    }

    protected abstract String getDocStart();

    protected abstract String getDocEnd();

    protected abstract String getDocHeaderStart();

    protected abstract String getDocHeaderEnd();

    protected abstract String getSectionHeaderStart();

    protected abstract String getSectionHeaderEnd();

    protected abstract String getSubSectionHeaderStart();

    protected abstract String getSubSectionHeaderEnd();

    protected abstract String getParaStart();

    protected abstract String getParaEnd();

    protected abstract String getIndentedListStart();

    protected abstract String getIndentedListEnd();

    protected abstract String getListElementStart();

    protected abstract String getListElementEnd();

    protected abstract List<String> getAbsorbableStartMarkups();

    protected abstract List<String> getAbsorbableEndMarkups();

    public String addDocumentMarkup(String text, String header) {
        String result = text;
        if (header != null && header.length() > 0) {
            result = this.addMarkups(this.getDocHeaderStart(), header, this.getDocHeaderEnd()) + text;
        }
        return this.addMarkups(this.getDocStart(), result, this.getDocEnd());
    }

    public String addSectionMarkup(String text, String header) {
        String result = text;
        if (header != null && header.length() > 0) {
            result = this.addMarkups(this.getSectionHeaderStart(), header, this.getSectionHeaderEnd()) + text;
        }
        return result;
    }

    public String addSubSectionMarkup(String text, String header) {
        String result = text;
        if (header != null && header.length() > 0) {
            result = this.addMarkups(this.getSubSectionHeaderStart(), header, this.getSubSectionHeaderEnd()) + text;
        }
        return result;
    }

    public String addParagraphMarkup(String text) {
        return this.addMarkups(this.getParaStart(), text, this.getParaEnd());
    }

    public String addListElementMarkup(String text) {
        return this.addMarkups(this.getListElementStart(), text, this.getListElementEnd());
    }

    public String addIndentedListMarkup(String text) {
        return this.addMarkups(this.getIndentedListStart(), text, this.getIndentedListEnd());
    }

    private String addMarkups(String startMarkup, String text, String endMarkup) {
        return this.addEndMarkup(this.addStartMarkup(text, startMarkup), endMarkup);
    }

    private String addStartMarkup(String text, String markup) {
        int oldMarkupIndex;
        int markupIndex = this.getAbsorbableStartMarkups().indexOf(markup);
        if (markupIndex < 0) {
            return markup + text;
        }
        String oldMarkup = null;
        for (String possibleMarkup : this.getAbsorbableStartMarkups()) {
            if (!text.startsWith(possibleMarkup)) continue;
            oldMarkup = possibleMarkup;
            break;
        }
        if ((oldMarkupIndex = this.getAbsorbableStartMarkups().indexOf(oldMarkup)) < 0) {
            return markup + text;
        }
        if (oldMarkupIndex <= markupIndex) {
            return text;
        }
        return markup + text.substring(oldMarkup.length());
    }

    private String addEndMarkup(String text, String markup) {
        int oldMarkupIndex;
        int markupIndex = this.getAbsorbableEndMarkups().indexOf(markup);
        if (markupIndex < 0) {
            return text + markup;
        }
        String oldMarkup = null;
        for (String possibleMarkup : this.getAbsorbableEndMarkups()) {
            if (!text.endsWith(possibleMarkup)) continue;
            oldMarkup = possibleMarkup;
            break;
        }
        if ((oldMarkupIndex = this.getAbsorbableEndMarkups().indexOf(oldMarkup)) < 0) {
            return text + markup;
        }
        if (oldMarkupIndex <= markupIndex) {
            return text;
        }
        return text.substring(0, text.length() - oldMarkup.length()) + markup;
    }
}

