/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import matetools.is2.data.IEncoderPlus;
import matetools.is2.util.DB;

public final class MFB
implements IEncoderPlus {
    private static final HashMap<String, HashMap<String, Integer>> m_featureSets = new HashMap();
    private static final HashMap<String, Integer> m_featureCounters = new HashMap();
    static final HashMap<String, Integer> m_featureBits = new HashMap();
    private static int count = 0;
    public boolean stop = false;
    public static final String NONE = "<None>";
    public static int misses = 0;
    public static int good = 0;

    public int size() {
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int register(String a, String v) {
        HashMap<String, Integer> hashMap = m_featureCounters;
        synchronized (hashMap) {
            Integer i;
            HashMap<String, Integer> fs = MFB.getFeatureSet().get(a);
            if (fs == null) {
                fs = new HashMap();
                MFB.getFeatureSet().put(a, fs);
                fs.put(NONE, 0);
                this.getFeatureCounter().put(a, 1);
            }
            if ((i = fs.get(v)) == null) {
                Integer c = this.getFeatureCounter().get(a);
                fs.put(v, c);
                c = c + 1;
                this.getFeatureCounter().put(a, c);
                return c - 1;
            }
            return i;
        }
    }

    public void calculateBits() {
        int total = 0;
        for (Map.Entry<String, Integer> e : this.getFeatureCounter().entrySet()) {
            int bits = (int)Math.ceil(Math.log(e.getValue() + 1) / Math.log(2.0));
            m_featureBits.put(e.getKey(), bits);
            total += bits;
        }
    }

    public String toString() {
        StringBuffer content = new StringBuffer();
        for (Map.Entry<String, Integer> e : this.getFeatureCounter().entrySet()) {
            content.append(String.valueOf(e.getKey()) + " " + e.getValue());
            content.append(':');
            content.append(MFB.getFeatureBits(e.getKey()));
            content.append('\n');
        }
        return content.toString();
    }

    public static final short getFeatureBits(String a) {
        if (m_featureBits.get(a) == null) {
            return 0;
        }
        return (short)m_featureBits.get(a).intValue();
    }

    @Override
    public final int getValue(String t, String v) {
        if (m_featureSets.get(t) == null) {
            return -1;
        }
        Integer vi = m_featureSets.get(t).get(v);
        if (vi == null) {
            return -1;
        }
        return vi;
    }

    public static final int getValueS(String a, String v) {
        if (m_featureSets.get(a) == null) {
            return -1;
        }
        Integer vi = m_featureSets.get(a).get(v);
        if (vi == null) {
            return -1;
        }
        return vi;
    }

    public int hasValue(String a, String v) {
        Integer vi = m_featureSets.get(a).get(v);
        if (vi == null) {
            return -1;
        }
        return vi;
    }

    public static String printBits(int k) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < 31) {
            s.append((k & 1) == 1 ? (char)'1' : '0');
            k >>= 1;
            ++i;
        }
        s.reverse();
        return s.toString();
    }

    public static void writeData(DataOutputStream dos) throws IOException {
        dos.writeInt(MFB.getFeatureSet().size());
        for (Map.Entry<String, HashMap<String, Integer>> e : MFB.getFeatureSet().entrySet()) {
            dos.writeUTF(e.getKey());
            dos.writeInt(e.getValue().size());
            for (Map.Entry<String, Integer> e2 : e.getValue().entrySet()) {
                if (e2.getKey() == null) {
                    DB.println("key " + e2.getKey() + " value " + e2.getValue() + " e -key " + e.getKey());
                }
                dos.writeUTF(e2.getKey());
                dos.writeInt(e2.getValue());
            }
        }
    }

    public void read(DataInputStream din) throws IOException {
        int size = din.readInt();
        int i = 0;
        while (i < size) {
            String k = din.readUTF();
            int size2 = din.readInt();
            HashMap<String, Integer> h = new HashMap<String, Integer>();
            MFB.getFeatureSet().put(k, h);
            int j = 0;
            while (j < size2) {
                h.put(din.readUTF(), din.readInt());
                ++j;
            }
            this.getFeatureCounter().put(k, size2);
            ++i;
        }
        count = size;
        this.calculateBits();
    }

    public static void clearData() {
        MFB.getFeatureSet().clear();
        m_featureBits.clear();
        MFB.getFeatureSet().clear();
    }

    @Override
    public HashMap<String, Integer> getFeatureCounter() {
        return m_featureCounters;
    }

    public static HashMap<String, HashMap<String, Integer>> getFeatureSet() {
        return m_featureSets;
    }

    public static String[] reverse(HashMap<String, Integer> v) {
        String[] set = new String[v.size()];
        for (Map.Entry<String, Integer> e : v.entrySet()) {
            set[e.getValue().intValue()] = e.getKey();
        }
        return set;
    }
}

