/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.io.CommonReader;
import fig.basic.LogInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureFileReader
extends CommonReader {
    private String regex;

    public FeatureFileReader() {
    }

    public FeatureFileReader(String file) {
        super(file);
    }

    public FeatureFileReader(String file, String regex_) {
        super(file);
        this.regex = regex_;
    }

    public String getMatcher() {
        String line = null;
        try {
            line = this.inputReader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String result = null;
        Pattern pattern = Pattern.compile(this.regex);
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            result = matcher.group(1);
        }
        return result;
    }

    public String[] extractLine(String line) {
        assert (this.inputReader != null);
        String[] parts = line.split("\\s");
        String[] baseFeatures = parts[2].split("_");
        assert (parts.length >= 3);
        String[] tokens = new String[baseFeatures.length + 2];
        tokens[0] = parts[0];
        tokens[1] = parts[1];
        int i = 0;
        while (i < baseFeatures.length) {
            tokens[i + 2] = baseFeatures[i];
            ++i;
        }
        return tokens;
    }

    public List<String[]> readSent() {
        ArrayList<String[]> sent = new ArrayList<String[]>();
        try {
            String line;
            while ((line = this.inputReader.readLine()) != null) {
                ++this.lineNumber;
                if ((line = line.trim()).length() != 0) {
                    String[] tokFeats = this.extractLine(line);
                    sent.add(tokFeats);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            LogInfo.logs("Error happened when reading line %d", this.lineNumber);
            e.printStackTrace();
        }
        return sent;
    }

    public List<List<String[]>> readAll() {
        List<String[]> sent;
        ArrayList<List<String[]>> sents = new ArrayList<List<String[]>>();
        while ((sent = this.readSent()).size() != 0) {
            sents.add(sent);
        }
        return sents;
    }

    public static void main(String[] args) {
        FeatureFileReader reader = new FeatureFileReader("test.txt", "UUni0=([^\t]*)");
        String result = reader.getMatcher();
        System.out.println(result);
    }
}

