/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class PLayer
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CAMERAS = "cameras";
    public static final int PROPERTY_CODE_CAMERAS = 8192;
    private transient List cameras = new ArrayList();

    public List getCamerasReference() {
        return this.cameras;
    }

    public int getCameraCount() {
        if (this.cameras == null) {
            return 0;
        }
        return this.cameras.size();
    }

    public PCamera getCamera(int n) {
        return (PCamera)this.cameras.get(n);
    }

    public void addCamera(PCamera pCamera) {
        this.addCamera(this.cameras.size(), pCamera);
    }

    public void addCamera(int n, PCamera pCamera) {
        this.cameras.add(n, pCamera);
        this.invalidatePaint();
        this.firePropertyChange(8192, PROPERTY_CAMERAS, null, this.cameras);
    }

    public PCamera removeCamera(PCamera pCamera) {
        if (this.cameras.remove(pCamera)) {
            this.invalidatePaint();
            this.firePropertyChange(8192, PROPERTY_CAMERAS, null, this.cameras);
        }
        return pCamera;
    }

    public PCamera removeCamera(int n) {
        PCamera pCamera = (PCamera)this.cameras.remove(n);
        this.invalidatePaint();
        this.firePropertyChange(8192, PROPERTY_CAMERAS, null, this.cameras);
        return pCamera;
    }

    public void repaintFrom(PBounds pBounds, PNode pNode) {
        if (pNode != this) {
            this.localToParent(pBounds);
        }
        this.notifyCameras(pBounds);
        if (this.getParent() != null) {
            this.getParent().repaintFrom(pBounds, pNode);
        }
    }

    protected void notifyCameras(PBounds pBounds) {
        int n = this.getCameraCount();
        for (int i = 0; i < n; ++i) {
            PCamera pCamera = (PCamera)this.cameras.get(i);
            pCamera.repaintFromLayer(pBounds, this);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!(objectOutputStream instanceof PObjectOutputStream)) {
            throw new RuntimeException("May not serialize PLayer to a non PObjectOutputStream");
        }
        objectOutputStream.defaultWriteObject();
        int n = this.getCameraCount();
        for (int i = 0; i < n; ++i) {
            ((PObjectOutputStream)objectOutputStream).writeConditionalObject(this.cameras.get(i));
        }
        objectOutputStream.writeObject(Boolean.FALSE);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.cameras = new ArrayList();
        while (true) {
            Object object;
            if ((object = objectInputStream.readObject()) == null) {
                continue;
            }
            if (object.equals(Boolean.FALSE)) break;
            this.cameras.add(object);
        }
    }
}

