/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.extract;

import babel.prep.extract.NutchChunk;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

class PageExtMapper
extends MapReduceBase
implements Mapper<Text, Writable, Text, NutchChunk> {
    protected String m_segmentId;

    PageExtMapper() {
    }

    public void configure(JobConf job) throws IllegalArgumentException {
        int idx;
        String fileDir = job.get("map.input.file");
        String segmentsDir = job.get("pageextractor.segments.dir");
        if (fileDir == null || segmentsDir == null || (idx = fileDir.indexOf(segmentsDir)) < 0) {
            throw new IllegalArgumentException("Could not recover mapper's segment.");
        }
        String segment = fileDir.substring(idx + segmentsDir.length());
        idx = segment.startsWith(File.separator) ? 1 : 0;
        this.m_segmentId = segment.substring(idx, segment.indexOf(File.separator, idx));
    }

    public void map(Text key, Writable value, OutputCollector<Text, NutchChunk> collector, Reporter reporter) throws IOException {
        collector.collect((Object)key, (Object)new NutchChunk(this.m_segmentId, value));
    }
}

