/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.util.Distance;
import com.aliasi.util.Proximity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeightedEditDistance
implements Distance<CharSequence>,
Proximity<CharSequence> {
    @Override
    public double distance(CharSequence csIn, CharSequence csOut) {
        return -this.proximity(csIn, csOut);
    }

    @Override
    public double proximity(CharSequence csIn, CharSequence csOut) {
        return this.distance(csIn, csOut, true);
    }

    double distance(CharSequence csIn, CharSequence csOut, boolean isSimilarity) {
        if (csOut.length() == 0) {
            double sum = 0.0;
            for (int i = 0; i < csIn.length(); ++i) {
                sum += this.deleteWeight(csIn.charAt(i));
            }
            return sum;
        }
        if (csIn.length() == 0) {
            double sum = 0.0;
            for (int j = 0; j < csOut.length(); ++j) {
                sum += this.insertWeight(csOut.charAt(j));
            }
            return sum;
        }
        int xsLength = csIn.length() + 1;
        int ysLength = csOut.length() + 1;
        double[] lastSlice = new double[ysLength];
        lastSlice[0] = 0.0;
        for (int y = 1; y < ysLength; ++y) {
            lastSlice[y] = lastSlice[y - 1] + this.insertWeight(csOut.charAt(y - 1));
        }
        double[] currentSlice = new double[ysLength];
        currentSlice[0] = this.insertWeight(csOut.charAt(0));
        char cX = csIn.charAt(0);
        for (int y = 1; y < ysLength; ++y) {
            int yMinus1 = y - 1;
            char cY = csOut.charAt(yMinus1);
            double matchSubstWeight = lastSlice[yMinus1] + (cX == cY ? this.matchWeight(cX) : this.substituteWeight(cX, cY));
            double deleteWeight = lastSlice[y] + this.deleteWeight(cX);
            double insertWeight = currentSlice[yMinus1] + this.insertWeight(cY);
            currentSlice[y] = this.best(isSimilarity, matchSubstWeight, deleteWeight, insertWeight);
        }
        if (xsLength == 2) {
            return currentSlice[currentSlice.length - 1];
        }
        char cYZero = csOut.charAt(0);
        double[] twoLastSlice = new double[ysLength];
        for (int x = 2; x < xsLength; ++x) {
            char cXMinus1 = cX;
            cX = csIn.charAt(x - 1);
            double[] tmpSlice = twoLastSlice;
            twoLastSlice = lastSlice;
            lastSlice = currentSlice;
            currentSlice = tmpSlice;
            currentSlice[0] = lastSlice[0] + this.deleteWeight(cX);
            currentSlice[1] = this.best(isSimilarity, cX == cYZero ? lastSlice[0] + this.matchWeight(cX) : lastSlice[0] + this.substituteWeight(cX, cYZero), lastSlice[1] + this.deleteWeight(cX), currentSlice[0] + this.insertWeight(cYZero));
            char cY = cYZero;
            for (int y = 2; y < ysLength; ++y) {
                int yMinus1 = y - 1;
                char cYMinus1 = cY;
                cY = csOut.charAt(yMinus1);
                currentSlice[y] = this.best(isSimilarity, cX == cY ? lastSlice[yMinus1] + this.matchWeight(cX) : lastSlice[yMinus1] + this.substituteWeight(cX, cY), lastSlice[y] + this.deleteWeight(cX), currentSlice[yMinus1] + this.insertWeight(cY));
                if (cX != cYMinus1 || cY != cXMinus1) continue;
                currentSlice[y] = this.best(isSimilarity, currentSlice[y], twoLastSlice[y - 2] + this.transposeWeight(cXMinus1, cX));
            }
        }
        return currentSlice[currentSlice.length - 1];
    }

    private double best(boolean isSimilarity, double x, double y, double z) {
        return this.best(isSimilarity, x, this.best(isSimilarity, y, z));
    }

    private double best(boolean isSimilarity, double x, double y) {
        return isSimilarity ? Math.max(x, y) : Math.min(x, y);
    }

    public abstract double matchWeight(char var1);

    public abstract double deleteWeight(char var1);

    public abstract double insertWeight(char var1);

    public abstract double substituteWeight(char var1, char var2);

    public abstract double transposeWeight(char var1, char var2);
}

