/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.EuclideanDistance;
import com.aliasi.matrix.KernelFunction;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class GaussianRadialBasisKernel
implements KernelFunction,
Serializable {
    static final long serialVersionUID = -1670587197184485884L;
    private final double mNegativeRadius;

    public GaussianRadialBasisKernel(double radius) {
        if (radius <= 0.0 || Double.isInfinite(radius) || Double.isNaN(radius)) {
            String msg = "Radius must be positive and finite. Found radius=" + radius;
            throw new IllegalArgumentException(msg);
        }
        this.mNegativeRadius = -radius;
    }

    GaussianRadialBasisKernel(double negativeRadius, boolean ignore) {
        this.mNegativeRadius = negativeRadius;
    }

    public double proximity(Vector v1, Vector v2) {
        double dist = EuclideanDistance.DISTANCE.distance(v1, v2);
        return Math.exp(this.mNegativeRadius * (dist * dist));
    }

    public String toString() {
        return "GaussianRadialBasedKernel(" + -this.mNegativeRadius + ")";
    }

    Object writeReplace() {
        return new Externalizer(this.mNegativeRadius);
    }

    static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = -5223595743791099605L;
        final double mNegativeRadius;

        public Externalizer() {
            this(1.0);
        }

        public Externalizer(double negativeRadius) {
            this.mNegativeRadius = negativeRadius;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.mNegativeRadius);
        }

        public Object read(ObjectInput in) throws IOException {
            double negativeRadius = in.readDouble();
            return new GaussianRadialBasisKernel(negativeRadius, true);
        }
    }
}

