/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;
import settings.Parameters;
import symbols.Symbol;
import symbols.SymbolList;
import symbols.SymbolString;
import tsg.Label;
import tsg.ParenthesesBlockPenn;
import tsg.TSNode;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.corpora.ConstCorpus;
import tsg.kernels.AllOrderedNodeExactSubsequenceOld;
import tsg.kernels.AllOrderedNodeExactSubsequences;
import util.FileUtil;
import util.Pair;
import util.PrintProgressStatic;
import util.Utility;

public class TSNodeLabel {
    public Label label;
    public TSNodeLabel parent;
    public boolean headMarked;
    public boolean isLexical;
    public TSNodeLabel[] daughters;
    public static String dashEqualDigits = "[-=]\\d+";
    public static String nullTag = "-NONE-";
    public static Label WHNP_label = Label.getLabel("WHNP");
    public static Label startWordChar = Label.getLabel("<w>");
    public static Label endWordChar = Label.getLabel("</w>");

    protected TSNodeLabel() {
    }

    public TSNodeLabel(String s) throws Exception {
        this(s, true);
    }

    public TSNodeLabel(Label label, boolean isLexical) {
        this.label = label;
        this.isLexical = isLexical;
    }

    public TSNodeLabel(String s, boolean allTerminalsAreLexical) throws Exception {
        this(ParenthesesBlockPenn.getParenthesesBlocks(s), allTerminalsAreLexical);
    }

    public TSNodeLabel nonRecursiveCopy() {
        TSNodeLabel result = new TSNodeLabel();
        result.label = this.label;
        result.headMarked = this.headMarked;
        result.isLexical = this.isLexical;
        return result;
    }

    public TSNodeLabel clone() {
        TSNodeLabel result = new TSNodeLabel();
        result.label = this.label;
        result.headMarked = this.headMarked;
        result.isLexical = this.isLexical;
        if (this.isTerminal()) {
            return result;
        }
        int prole = this.prole();
        result.daughters = new TSNodeLabel[prole];
        int i = 0;
        while (i < this.prole()) {
            result.daughters[i] = this.daughters[i].clone();
            result.daughters[i].parent = result;
            ++i;
        }
        return result;
    }

    public boolean checkParentDaughtersConsistency() {
        if (this.isTerminal()) {
            return true;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.parent != this) {
                System.err.println(String.valueOf(d.label()) + ".parent != " + this.label());
                return false;
            }
            if (!d.checkParentDaughtersConsistency()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean checkOnlyAndAllTerminalsAreLexical() {
        boolean terminal = this.isTerminal();
        if (terminal != this.isLexical) {
            return false;
        }
        if (!terminal) {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel d = tSNodeLabelArray[n2];
                if (!d.checkOnlyAndAllTerminalsAreLexical()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public TSNodeLabel addTop() {
        if (this.label().equals("TOP")) {
            return this;
        }
        TSNodeLabel top = new TSNodeLabel();
        top.label = Label.getLabel("TOP");
        top.daughters = new TSNodeLabel[]{this};
        this.parent = top;
        return top;
    }

    private TSNodeLabel(ParenthesesBlockPenn p, boolean allTerminalsAreLexical) {
        if (p.isTerminal()) {
            this.acquireTerminalLabel(p, allTerminalsAreLexical);
        } else {
            this.acquireNonTerminalLabel(p);
            this.daughters = new TSNodeLabel[p.subBlocks.size()];
            int i = 0;
            for (ParenthesesBlockPenn pd : p.subBlocks) {
                this.daughters[i] = new TSNodeLabel(pd, allTerminalsAreLexical);
                this.daughters[i].parent = this;
                ++i;
            }
        }
    }

    protected void acquireTerminalLabel(ParenthesesBlockPenn p, boolean allTerminalsAreLexical) {
        if (allTerminalsAreLexical) {
            this.label = Label.getLabel(p.label);
            this.isLexical = true;
        } else if (p.label.indexOf("\"") == -1) {
            this.label = Label.getLabel(p.label);
        } else {
            this.label = Label.getLabel(p.label.replaceAll("\"", ""));
            this.isLexical = true;
        }
    }

    public void relabel(String newLabel) {
        this.label = Label.getLabel(newLabel);
    }

    public void replaceLabels(String oldLabel, String newLabel) {
        if (this.label().equals(oldLabel)) {
            this.label = Label.getLabel(newLabel);
        }
        if (this.daughters == null) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.replaceLabels(oldLabel, newLabel);
            ++n2;
        }
    }

    protected void acquireNonTerminalLabel(ParenthesesBlockPenn p) {
        if (p.label.endsWith("-H")) {
            this.headMarked = true;
            this.label = Label.getLabel(p.label.substring(0, p.label.length() - 2));
        } else {
            this.label = Label.getLabel(p.label);
        }
    }

    public boolean isHeadMarked() {
        return this.headMarked;
    }

    public boolean isTerminal() {
        return this.daughters == null;
    }

    public boolean isPreLexical() {
        return this.daughters.length == 1 && this.daughters[0].isLexical;
    }

    public boolean hasOnlyPrelexicalDaughters() {
        if (this.daughters == null) {
            return false;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (!d.isPreLexical()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String label() {
        return this.label.toString();
    }

    public String cfgRule() {
        StringBuilder result = new StringBuilder(this.label());
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            result.append(" ").append(d.label(false, true));
            ++n2;
        }
        return result.toString();
    }

    public String cfgRuleNoQuotes() {
        StringBuilder result = new StringBuilder(this.label());
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            result.append(" ").append(d.label(false, false));
            ++n2;
        }
        return result.toString();
    }

    public TSNodeLabel cfgRuleNode() {
        TSNodeLabel result = new TSNodeLabel();
        result.label = this.label;
        result.headMarked = this.headMarked;
        result.isLexical = this.isLexical;
        if (this.isTerminal()) {
            return result;
        }
        int prole = this.prole();
        result.daughters = new TSNodeLabel[prole];
        int i = 0;
        while (i < this.prole()) {
            result.daughters[i] = new TSNodeLabel();
            result.daughters[i].parent = result;
            result.daughters[i].label = this.label;
            result.daughters[i].headMarked = this.headMarked;
            result.daughters[i].isLexical = this.isLexical;
            ++i;
        }
        return result;
    }

    public SymbolList cfgRuleSymbol() {
        Vector<Symbol> rule = new Vector<Symbol>();
        rule.add(new SymbolString(this.label()));
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            rule.add(new SymbolString(d.label()));
            ++n2;
        }
        SymbolList result = new SymbolList(rule);
        return result;
    }

    public String compressToCFGRule() {
        StringBuilder sb = new StringBuilder(this.label());
        this.fillStringBuilderWithTerminals(sb);
        return sb.toString();
    }

    public void fillStringBuilderWithTerminals(StringBuilder sb) {
        if (this.isTerminal()) {
            sb.append(" " + this.label(false, true));
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.fillStringBuilderWithTerminals(sb);
            ++n2;
        }
    }

    public boolean isUniqueDaughter() {
        TSNodeLabel parent = this.parent;
        if (parent == null) {
            return false;
        }
        return this.parent.daughters.length == 1;
    }

    public String label(boolean printHeads, boolean printLexiconInQuotes) {
        if (this.isLexical && printLexiconInQuotes) {
            return "\"" + this.label() + "\"";
        }
        if (!printHeads || !this.headMarked) {
            return this.label();
        }
        return String.valueOf(this.label()) + "-H";
    }

    public String toString() {
        if (this.isTerminal()) {
            return this.label();
        }
        StringBuilder result = new StringBuilder("(" + this.label() + " ");
        int size = this.daughters.length;
        int i = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel p = tSNodeLabelArray[n2];
            result.append(p.toString());
            if (++i != size) {
                result.append(" ");
            }
            ++n2;
        }
        result.append(")");
        return result.toString();
    }

    public String toStringExtraParenthesis() {
        return "( " + this.toString() + ")";
    }

    public String toString(boolean printHeads, boolean printLexiconInQuotes) {
        if (this.isLexical && printLexiconInQuotes) {
            return "\"" + this.label() + "\"";
        }
        if (this.isTerminal()) {
            return this.label();
        }
        StringBuilder result = new StringBuilder("(" + this.label(printHeads, printLexiconInQuotes) + " ");
        int size = this.daughters.length;
        int i = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel p = tSNodeLabelArray[n2];
            result.append(p.toString(printHeads, printLexiconInQuotes));
            if (++i != size) {
                result.append(" ");
            }
            ++n2;
        }
        result.append(")");
        return result.toString();
    }

    public String toStringOneLevel() {
        return this.toStringOneLevel(false, false);
    }

    public String toStringOneLevel(boolean printHeads, boolean printLexiconInQuotes) {
        if (this.isLexical && printLexiconInQuotes) {
            return "\"" + this.label() + "\"";
        }
        if (this.isTerminal()) {
            return this.label();
        }
        StringBuilder result = new StringBuilder("(" + this.label(printHeads, printLexiconInQuotes) + " ");
        int size = this.daughters.length;
        int i = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel p = tSNodeLabelArray[n2];
            result.append(p.label(printHeads, printLexiconInQuotes));
            if (++i != size) {
                result.append(" ");
            }
            ++n2;
        }
        result.append(")");
        return result.toString();
    }

    public int countInternalNodes() {
        if (this.isPreLexical()) {
            return 0;
        }
        int result = 1;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countInternalNodes();
            ++n2;
        }
        return result;
    }

    public int countAllNodes() {
        int result = 1;
        if (this.isTerminal()) {
            return result;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countAllNodes();
            ++n2;
        }
        return result;
    }

    public int countLexicalNodes() {
        if (this.isLexical) {
            return 1;
        }
        if (this.isTerminal()) {
            return 0;
        }
        int result = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countLexicalNodes();
            ++n2;
        }
        return result;
    }

    public int countNonLexicalNodes() {
        if (this.isLexical) {
            return 0;
        }
        if (this.isTerminal()) {
            return 1;
        }
        int result = 1;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countNonLexicalNodes();
            ++n2;
        }
        return result;
    }

    public int countNonLexicalFronteer() {
        if (this.isLexical) {
            return 0;
        }
        if (this.isTerminal()) {
            return 1;
        }
        int result = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countNonLexicalFronteer();
            ++n2;
        }
        return result;
    }

    public int countLexicalNodesExcludingPosLabels(String[] excludePosLabels) {
        int result = 0;
        if (this.isPreLexical()) {
            return Arrays.binarySearch(excludePosLabels, this.label()) < 0 ? 1 : 0;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countLexicalNodesExcludingPosLabels(excludePosLabels);
            ++n2;
        }
        return result;
    }

    public int countLexicalNodesExcludingCatLabels(String[] excludeLexLabels) {
        int result = 0;
        if (this.isLexical) {
            return Arrays.binarySearch(excludeLexLabels, this.parent.label()) < 0 ? 1 : 0;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countLexicalNodesExcludingCatLabels(excludeLexLabels);
            ++n2;
        }
        return result;
    }

    public int countTerminalNodes() {
        if (this.isTerminal()) {
            return 1;
        }
        int result = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            result += TN.countTerminalNodes();
            ++n2;
        }
        return result;
    }

    public int countCorrectPOS(TSNodeLabel TNgold, String[] exludePOS) {
        ArrayList<TSNodeLabel> thisLex = this.collectLexicalItems();
        ArrayList<TSNodeLabel> goldLex = TNgold.collectLexicalItems();
        int result = 0;
        int i = 0;
        while (i < thisLex.size()) {
            String thisPOS = ((TSNodeLabel)thisLex.get((int)i)).parent.label();
            String goldPOS = ((TSNodeLabel)goldLex.get((int)i)).parent.label();
            if (Arrays.binarySearch(exludePOS, goldPOS) < 0 && thisPOS.equals(goldPOS)) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public ArrayList<TSNodeLabel> collectLexicalItems() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectLexicalItems(result);
        return result;
    }

    public ArrayList<String> collectLexicalWords() {
        ArrayList<TSNodeLabel> lex = this.collectLexicalItems();
        ArrayList<String> result = new ArrayList<String>(lex.size());
        for (TSNodeLabel l : lex) {
            result.add(l.label());
        }
        return result;
    }

    public ArrayList<Label> collectLexicalLabels() {
        ArrayList<TSNodeLabel> lex = this.collectLexicalItems();
        ArrayList<Label> result = new ArrayList<Label>(lex.size());
        for (TSNodeLabel l : lex) {
            result.add(l.label);
        }
        return result;
    }

    private void collectLexicalItems(List<TSNodeLabel> lexItems) {
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            if (TN.isLexical) {
                lexItems.add(TN);
            } else {
                TN.collectLexicalItems(lexItems);
            }
            ++n2;
        }
    }

    public ArrayList<TSNodeLabel> collectPreLexicalItems() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectPreLexicalItems(result);
        return result;
    }

    private void collectPreLexicalItems(List<TSNodeLabel> prelexItems) {
        if (this.isTerminal()) {
            return;
        }
        if (this.isPreLexical()) {
            prelexItems.add(this);
        } else {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel TN = tSNodeLabelArray[n2];
                TN.collectPreLexicalItems(prelexItems);
                ++n2;
            }
        }
    }

    public ArrayList<Label> collectPreLexicalLabels() {
        ArrayList<Label> result = new ArrayList<Label>();
        this.collectPreLexicalLabels(result);
        return result;
    }

    private void collectPreLexicalLabels(List<Label> prelexLabels) {
        if (this.isTerminal()) {
            return;
        }
        if (this.isPreLexical()) {
            prelexLabels.add(this.label);
        } else {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel TN = tSNodeLabelArray[n2];
                TN.collectPreLexicalLabels(prelexLabels);
                ++n2;
            }
        }
    }

    public ArrayList<TSNodeLabel> collectTerminalItems() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectTerminalItems(result);
        return result;
    }

    private void collectTerminalItems(List<TSNodeLabel> terminals) {
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            if (TN.isTerminal()) {
                terminals.add(TN);
            } else {
                TN.collectTerminalItems(terminals);
            }
            ++n2;
        }
    }

    public ArrayList<TSNodeLabel> collectConstituentNodes() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectAllNodes(result);
        ListIterator<TSNodeLabel> i = result.listIterator();
        while (i.hasNext()) {
            TSNodeLabel node = i.next();
            TSNodeLabel parent = node.parent;
            if (!node.isLexical && !node.isPreLexical() && (parent == null || parent.prole() != 1)) continue;
            i.remove();
        }
        return result;
    }

    public ArrayList<TSNodeLabel> collectInternalNodes() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectInternalNodes(result);
        return result;
    }

    private void collectInternalNodes(List<TSNodeLabel> allNodes) {
        if (this.isPreLexical()) {
            return;
        }
        allNodes.add(this);
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            TN.collectInternalNodes(allNodes);
            ++n2;
        }
    }

    public ArrayList<TSNodeLabel> collectNonLexicalNodes() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectNonLexicalNodes(result);
        return result;
    }

    private void collectNonLexicalNodes(List<TSNodeLabel> allNodes) {
        if (this.isLexical) {
            return;
        }
        allNodes.add(this);
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            TN.collectNonLexicalNodes(allNodes);
            ++n2;
        }
    }

    public ArrayList<TSNodeLabel> collectAllNodes() {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        this.collectAllNodes(result);
        return result;
    }

    private void collectAllNodes(List<TSNodeLabel> allNodes) {
        allNodes.add(this);
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel TN = tSNodeLabelArray[n2];
            TN.collectAllNodes(allNodes);
            ++n2;
        }
    }

    public boolean sameLabel(TSNodeLabel nodeB) {
        return this.isLexical == nodeB.isLexical && this.label.equals(nodeB.label);
    }

    public boolean sameLexLabels(TSNodeLabel nodeB) {
        ArrayList<TSNodeLabel> lex1 = this.collectLexicalItems();
        ArrayList<TSNodeLabel> lex2 = nodeB.collectLexicalItems();
        return lex1.equals(lex2);
    }

    public boolean sameDaughtersLabel(TSNodeLabel nodeB) {
        if (this.daughters.length != nodeB.daughters.length) {
            return false;
        }
        int i = 0;
        while (i < this.daughters.length) {
            if (!this.daughters[i].sameLabel(nodeB.daughters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean sameLabelAndDaughersLabels(TSNodeLabel nodeB) {
        if (this.isLexical != nodeB.isLexical || !this.label.equals(nodeB.label)) {
            return false;
        }
        if (this.daughters.length != nodeB.daughters.length) {
            return false;
        }
        int i = 0;
        while (i < this.daughters.length) {
            if (!this.daughters[i].sameLabel(nodeB.daughters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 31 + this.label().hashCode();
        if (!this.isTerminal()) {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel d = tSNodeLabelArray[n2];
                result = 31 * result + d.hashCode();
                ++n2;
            }
        }
        return result;
    }

    public int prole() {
        if (this.daughters == null) {
            return 0;
        }
        return this.daughters.length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TSNodeLabel) {
            TSNodeLabel anOtherNode = (TSNodeLabel)o;
            return this.equals(anOtherNode);
        }
        return false;
    }

    public boolean equals(TSNodeLabel anOtherNode) {
        if (!anOtherNode.label.equals(this.label)) {
            return false;
        }
        if (this.isTerminal() || anOtherNode.isTerminal()) {
            return this.isTerminal() == anOtherNode.isTerminal();
        }
        int thisProle = this.prole();
        if (anOtherNode.prole() != thisProle) {
            return false;
        }
        int d = 0;
        while (d < thisProle) {
            if (!anOtherNode.daughters[d].equals(this.daughters[d])) {
                return false;
            }
            ++d;
        }
        return true;
    }

    public int maxDepth() {
        if (this.isTerminal()) {
            return 0;
        }
        int maxDepth = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel t = tSNodeLabelArray[n2];
            int tDepth = t.maxDepth();
            if (tDepth > maxDepth) {
                maxDepth = tDepth;
            }
            ++n2;
        }
        return maxDepth + 1;
    }

    public int maxBranching() {
        if (this.isTerminal()) {
            return 0;
        }
        int maxBranching = this.prole();
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel t = tSNodeLabelArray[n2];
            int tBranching = t.maxBranching();
            if (tBranching > maxBranching) {
                maxBranching = tBranching;
            }
            ++n2;
        }
        return maxBranching;
    }

    public int hight() {
        int hight = 0;
        TSNodeLabel TN = this;
        while (TN.parent != null) {
            TN = TN.parent;
            ++hight;
        }
        return hight;
    }

    public void removeSemanticTags() {
        if (this.isLexical) {
            return;
        }
        if (this.label.hasSemTags()) {
            this.relabel(TSNode.removeSemanticTag(this.label()));
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel D = tSNodeLabelArray[n2];
            D.removeSemanticTags();
            ++n2;
        }
    }

    public void removeBackSlashInLexicon() {
        if (this.isTerminal()) {
            if (this.isLexical) {
                String word = this.label();
                if (word.indexOf(92) != -1) {
                    // empty if block
                }
                word = word.replaceAll("\\\\", "");
                this.relabel(word);
            }
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.removeBackSlashInLexicon();
            ++n2;
        }
    }

    public void removeHeadLabels() {
        this.headMarked = false;
        if (this.isTerminal()) {
            return;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel D = tSNodeLabelArray[n2];
            D.removeHeadLabels();
            ++n2;
        }
    }

    public void removeRedundantRules() {
        if (this.isPreLexical()) {
            return;
        }
        if (this.prole() == 1 && this.label.equals(this.daughters[0].label)) {
            TSNodeLabel[] tSNodeLabelArray = this.daughters = this.daughters[0].daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel D = tSNodeLabelArray[n2];
                D.parent = this;
                ++n2;
            }
            this.removeRedundantRules();
        } else {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n3 = 0;
            while (n3 < n) {
                TSNodeLabel D = tSNodeLabelArray[n3];
                D.removeRedundantRules();
                ++n3;
            }
        }
    }

    public void replaceAllNonTerminalLabels(String regexMatch, String replace) {
        if (this.isTerminal()) {
            return;
        }
        String labelString = this.label();
        this.relabel(labelString.replaceAll(regexMatch, replace));
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].replaceAllNonTerminalLabels(regexMatch, replace);
            ++i;
        }
    }

    public void replaceAllNonTerminalLabels(Label newLabel, Label except) {
        if (this.isTerminal()) {
            return;
        }
        if (!this.label.equals(except)) {
            this.label = newLabel;
        }
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].replaceAllNonTerminalLabels(newLabel, except);
            ++i;
        }
    }

    public void renameAllConstituentLabels(Label newLabel) {
        if (this.isLexical || this.isPreLexical()) {
            return;
        }
        this.label = newLabel;
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].renameAllConstituentLabels(newLabel);
            ++i;
        }
    }

    public boolean checkHeadCorrespondance(TSNodeLabel o) {
        int prole = this.prole();
        if (prole == 0) {
            return true;
        }
        int i = 0;
        while (i < prole) {
            TSNodeLabel d = this.daughters[i];
            TSNodeLabel dO = o.daughters[i];
            if (d.headMarked != dO.headMarked) {
                System.err.println("Not matching heads: \n\t" + this.toStringOneLevel(true, false) + "\n\t" + o.toStringOneLevel(true, false));
                return false;
            }
            if (!d.checkHeadCorrespondance(dO)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsRecursive(TSNodeLabel otherTree) {
        if (this.containsNonRecursiveFragment(otherTree)) {
            return true;
        }
        if (this.isTerminal()) {
            return false;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.containsRecursive(otherTree)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean containsNonRecursiveFragment(TSNodeLabel otherTree) {
        if (this.label.equals(otherTree.label)) {
            if (otherTree.isTerminal()) {
                return true;
            }
            if (this.isTerminal()) {
                return false;
            }
            int prole = this.prole();
            if (prole != otherTree.prole()) {
                return false;
            }
            int i = 0;
            while (i < prole) {
                TSNodeLabel thisDaughter = this.daughters[i];
                TSNodeLabel otherDaughter = otherTree.daughters[i];
                if (!thisDaughter.containsNonRecursiveFragment(otherDaughter)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int countRecursiveFragment(TSNodeLabel otherTree) {
        int count;
        int n = count = this.containsNonRecursiveFragment(otherTree) ? 1 : 0;
        if (this.isTerminal()) {
            return count;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n2 = this.daughters.length;
        int n3 = 0;
        while (n3 < n2) {
            TSNodeLabel d = tSNodeLabelArray[n3];
            count += d.countRecursiveFragment(otherTree);
            ++n3;
        }
        return count;
    }

    public BigInteger countSubTrees() {
        if (this.isLexical) {
            return BigInteger.ZERO;
        }
        int prole = this.prole();
        BigInteger result = this.daughters[0].countSubTrees().add(BigInteger.ONE);
        if (prole == 1) {
            return result;
        }
        int i = 1;
        while (i < prole) {
            BigInteger count = this.daughters[i].countSubTrees().add(BigInteger.ONE);
            result = result.multiply(count);
            ++i;
        }
        return result;
    }

    public BigInteger[] countTotalFragments() {
        if (this.isLexical) {
            return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
        }
        BigInteger[] result = new BigInteger[]{BigInteger.ONE, BigInteger.ZERO};
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            BigInteger[] countTotalFragmentsD = d.countTotalFragments();
            result[0] = result[0].multiply(countTotalFragmentsD[0].add(BigInteger.ONE));
            result[1] = result[1].add(countTotalFragmentsD[1]);
            ++n2;
        }
        result[1] = result[1].add(result[0]);
        return result;
    }

    public BigInteger[][] countTotalFragmentsDepth() {
        if (this.isPreLexical()) {
            return new BigInteger[][]{{BigInteger.ONE}, {BigInteger.ONE}};
        }
        int prole = this.prole();
        BigInteger[][][] resultDaughers = new BigInteger[prole][][];
        int[] maxDepthDaughters = new int[prole];
        int currentMaxDepth = 0;
        int d = 0;
        while (d < prole) {
            int maxDepthD;
            BigInteger[][] resultD = this.daughters[d].countTotalFragmentsDepth();
            resultDaughers[d] = resultD;
            maxDepthDaughters[d] = maxDepthD = resultD[0].length;
            if (maxDepthD > currentMaxDepth) {
                currentMaxDepth = maxDepthD;
            }
            ++d;
        }
        BigInteger[][] result = new BigInteger[2][++currentMaxDepth];
        Arrays.fill(result[0], BigInteger.ZERO);
        Arrays.fill(result[1], BigInteger.ONE);
        int iPrevious = 0;
        int i = 1;
        while (i < currentMaxDepth) {
            int d2 = 0;
            while (d2 < prole) {
                int maxDepthD = maxDepthDaughters[d2];
                boolean reachEndDepthOfDaughter = maxDepthD < i;
                BigInteger countDi = null;
                if (reachEndDepthOfDaughter) {
                    countDi = resultDaughers[d2][1][maxDepthD - 1];
                } else {
                    countDi = resultDaughers[d2][1][iPrevious];
                    result[0][iPrevious] = result[0][iPrevious].add(resultDaughers[d2][0][iPrevious]);
                }
                countDi = countDi.add(BigInteger.ONE);
                result[1][i] = result[1][i].multiply(countDi);
                ++d2;
            }
            ++iPrevious;
            ++i;
        }
        result[0][0] = result[0][0].add(BigInteger.ONE);
        i = 1;
        while (i < currentMaxDepth) {
            result[0][i] = result[0][i].add(result[1][i].subtract(result[1][i - 1]));
            ++i;
        }
        return result;
    }

    public BigInteger[][] countTotalFragmentsDepthMaxBranching(int maxBranching) {
        int i;
        if (this.isPreLexical()) {
            return new BigInteger[][]{{BigInteger.ONE}, {BigInteger.ONE}};
        }
        int prole = this.prole();
        BigInteger[][][] resultDaughers = new BigInteger[prole][][];
        int[][] maxDepthsDaughters = new int[prole][2];
        int currentMaxDepth = 0;
        int d = 0;
        while (d < prole) {
            BigInteger[][] resultD = this.daughters[d].countTotalFragmentsDepthMaxBranching(maxBranching);
            resultDaughers[d] = resultD;
            int maxDepthD0 = resultD[0].length;
            int maxDepthD1 = resultD[1].length;
            maxDepthsDaughters[d] = new int[]{maxDepthD0, maxDepthD1};
            if (maxDepthD0 > currentMaxDepth) {
                currentMaxDepth = maxDepthD0;
            }
            ++d;
        }
        if (prole > maxBranching) {
            BigInteger[][] result = new BigInteger[][]{new BigInteger[currentMaxDepth], {BigInteger.ZERO}};
            Arrays.fill(result[0], BigInteger.ZERO);
            int d2 = 0;
            while (d2 < prole) {
                i = 0;
                while (i < maxDepthsDaughters[d2][0]) {
                    result[0][i] = result[0][i].add(resultDaughers[d2][0][i]);
                    ++i;
                }
                ++d2;
            }
            return result;
        }
        BigInteger[][] result = new BigInteger[2][++currentMaxDepth];
        Arrays.fill(result[0], BigInteger.ZERO);
        Arrays.fill(result[1], BigInteger.ONE);
        int iPrevious = 0;
        i = 1;
        while (i < currentMaxDepth) {
            int d3 = 0;
            while (d3 < prole) {
                BigInteger countDi;
                int maxDepthD1 = maxDepthsDaughters[d3][1];
                int maxDepthD0 = maxDepthsDaughters[d3][0];
                BigInteger bigInteger = countDi = maxDepthD1 < i ? resultDaughers[d3][1][maxDepthD1 - 1] : resultDaughers[d3][1][iPrevious];
                if (maxDepthD0 >= i) {
                    result[0][iPrevious] = result[0][iPrevious].add(resultDaughers[d3][0][iPrevious]);
                }
                countDi = countDi.add(BigInteger.ONE);
                result[1][i] = result[1][i].multiply(countDi);
                ++d3;
            }
            ++iPrevious;
            ++i;
        }
        result[0][0] = result[0][0].add(BigInteger.ONE);
        i = 1;
        while (i < currentMaxDepth) {
            result[0][i] = result[0][i].add(result[1][i].subtract(result[1][i - 1]));
            ++i;
        }
        return result;
    }

    public boolean containsRecursivePartialFragment(TSNodeLabel partialFrag) {
        if (this.containsNonRecursivePartialFragment(partialFrag)) {
            return true;
        }
        if (this.isTerminal()) {
            return false;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.containsRecursivePartialFragment(partialFrag)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean matchNonRecursivePartialFragment(TSNodeLabel partialFrag) {
        if (this.label.equals(partialFrag.label)) {
            if (partialFrag.isTerminal()) {
                return true;
            }
            if (this.isTerminal()) {
                return false;
            }
            ArrayList<ArrayList<Pair<TSNodeLabel>>> matchedDaughtersList = AllOrderedNodeExactSubsequences.getallExactSubsequencesBackupOnSimple(this.daughters, partialFrag.daughters);
            if (matchedDaughtersList == null) {
                return false;
            }
            for (ArrayList<Pair<TSNodeLabel>> dList : matchedDaughtersList) {
                boolean allMatched = true;
                for (Pair<TSNodeLabel> p : dList) {
                    TSNodeLabel second;
                    TSNodeLabel first = p.getFirst();
                    boolean partialMatch = first.matchNonRecursivePartialFragment(second = p.getSecond());
                    if (partialMatch) continue;
                    allMatched = false;
                    break;
                }
                if (!allMatched) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsNonRecursivePartialFragment(TSNodeLabel partialFrag) {
        if (this.label.equals(partialFrag.label)) {
            if (partialFrag.isTerminal()) {
                return true;
            }
            if (this.isTerminal()) {
                return false;
            }
            ArrayList<ArrayList<Pair<TSNodeLabel>>> matchedDaughtersList = AllOrderedNodeExactSubsequenceOld.getallExactSubsequences(this.daughters, partialFrag.daughters);
            if (matchedDaughtersList == null) {
                return false;
            }
            for (ArrayList<Pair<TSNodeLabel>> dList : matchedDaughtersList) {
                boolean allMatched = true;
                for (Pair<TSNodeLabel> p : dList) {
                    if (p.getFirst().containsNonRecursivePartialFragment(p.getSecond())) continue;
                    allMatched = false;
                    break;
                }
                if (!allMatched) continue;
                return true;
            }
        }
        return false;
    }

    public long countRecursivePartialFragment(TSNodeLabel partialFrag) {
        long count = 0L;
        if (this.matchNonRecursivePartialFragment(partialFrag)) {
            ++count;
        }
        if (this.isTerminal()) {
            return count;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            count += d.countRecursivePartialFragment(partialFrag);
            ++n2;
        }
        return count;
    }

    public static ArrayList<TSNodeLabel> getTreebank(File inputFile) throws Exception {
        return TSNodeLabel.getTreebank(inputFile, FileUtil.defaultEncoding, Integer.MAX_VALUE);
    }

    public static ArrayList<TSNodeLabel> getTreebank(File inputFile, int LL) throws Exception {
        return TSNodeLabel.getTreebank(inputFile, FileUtil.defaultEncoding, LL);
    }

    public static ArrayList<TSNodeLabel> getTreebank(File inputFile, boolean allTermAreLex) throws Exception {
        return TSNodeLabel.getTreebank(inputFile, FileUtil.defaultEncoding, Integer.MAX_VALUE, allTermAreLex);
    }

    public static ArrayList<TSNodeLabel> getTreebank(File inputFile, String encoding, int LL, boolean allTermAreLex) throws Exception {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        Scanner scan = FileUtil.getScanner(inputFile, encoding);
        while (scan.hasNextLine()) {
            TSNodeLabel lineStructure;
            String line = scan.nextLine();
            if (line.equals("") || (lineStructure = new TSNodeLabel(line = line.replaceAll("\\\\", ""), allTermAreLex)).countLexicalNodes() > LL) continue;
            result.add(lineStructure);
        }
        return result;
    }

    public static ArrayList<TSNodeLabel> getTreebank(File inputFile, String encoding, int LL) throws Exception {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        Scanner scan = FileUtil.getScanner(inputFile, encoding);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            line = line.replaceAll("\\\\", "");
            TSNodeLabel lineStructure = new TSNodeLabel(line = ConstCorpus.adjustParenthesisation(line));
            if (lineStructure.countLexicalNodes() > LL) continue;
            result.add(lineStructure);
        }
        return result;
    }

    public static ArrayList<TSNodeLabel> getTreebankFirst(File inputFile, int n) throws Exception {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        Scanner scan = FileUtil.getScanner(inputFile, FileUtil.defaultEncoding);
        PrintProgressStatic.start("Reading Treebank: ");
        int i = 0;
        while (scan.hasNextLine() && i < n) {
            String line = scan.nextLine();
            if (line.equals("")) continue;
            PrintProgressStatic.next();
            TSNodeLabel lineStructure = new TSNodeLabel(line);
            result.add(lineStructure);
            ++i;
        }
        PrintProgressStatic.end();
        return result;
    }

    public static void printTreebankToFile(File outputFile, ArrayList<TSNodeLabel> constTreebank, boolean heads, boolean lexQuotes) {
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        for (TSNodeLabel t : constTreebank) {
            pw.println(t.toString(heads, lexQuotes));
        }
        pw.close();
    }

    public static void getTreebankComment(File treebankFile, ArrayList<TSNodeLabel> treebank, ArrayList<String> treebankComments) throws Exception {
        Scanner scan = FileUtil.getScanner(treebankFile, FileUtil.defaultEncoding);
        PrintProgressStatic.start("Reading Treebank: ");
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if ((line = line.trim()).equals("") || line.charAt(0) != '(') continue;
            String[] lineSplit = line.split("\t");
            PrintProgressStatic.next();
            TSNodeLabel lineStructure = new TSNodeLabel(lineSplit[0]);
            treebank.add(lineStructure);
            treebankComments.add(lineSplit.length == 1 ? null : lineSplit[1]);
        }
        PrintProgressStatic.end();
    }

    public static void getTreebankCommentFromString(String treebankString, ArrayList<TSNodeLabel> treebank, ArrayList<String> treebankComments) throws Exception {
        String[] treebankStringLines;
        PrintProgressStatic.start("Reading Treebank: ");
        String[] stringArray = treebankStringLines = treebankString.split("\n");
        int n = treebankStringLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(line = line.trim()).equals("") && line.charAt(0) == '(') {
                String[] lineSplit = line.split("\t");
                PrintProgressStatic.next();
                TSNodeLabel lineStructure = new TSNodeLabel(lineSplit[0]);
                treebank.add(lineStructure);
                treebankComments.add(lineSplit.length == 1 ? null : lineSplit[1]);
            }
            ++n2;
        }
        PrintProgressStatic.end();
    }

    public static void makeTreebankClausureUnderSubsetRelation(File inputFile, File outputFile) throws Exception {
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(inputFile);
        PrintWriter pw = FileUtil.getPrintWriter(outputFile);
        ListIterator<TSNodeLabel> i1 = treebank.listIterator();
        PrintProgressStatic.start("Making closure:");
        while (i1.hasNext()) {
            PrintProgressStatic.next();
            TSNodeLabel t1 = i1.next();
            int nextIndex = i1.previousIndex() + 1;
            ListIterator<TSNodeLabel> i2 = treebank.listIterator(nextIndex);
            boolean foundSuperSet = false;
            while (i2.hasNext()) {
                TSNodeLabel t2 = i2.next();
                if (t2.containsRecursive(t1)) {
                    foundSuperSet = true;
                    break;
                }
                if (!t1.containsRecursive(t2)) continue;
                i2.remove();
            }
            if (foundSuperSet) continue;
            pw.println(t1);
        }
        pw.close();
        PrintProgressStatic.end();
    }

    public String toFlatSentence() {
        ArrayList<TSNodeLabel> lexItems = this.collectLexicalItems();
        StringBuilder result = new StringBuilder();
        result.append(lexItems.get(0).label());
        if (lexItems.size() == 1) {
            return result.toString();
        }
        ListIterator<TSNodeLabel> i = lexItems.listIterator(1);
        while (i.hasNext()) {
            result.append(" " + i.next().label());
        }
        return result.toString();
    }

    public String[] toFlatWordArray() {
        ArrayList<TSNodeLabel> lexItems = this.collectLexicalItems();
        String[] result = new String[lexItems.size()];
        int i = 0;
        for (TSNodeLabel l : lexItems) {
            result[i] = l.label();
            ++i;
        }
        return result;
    }

    public void adjustLexicalItems(String[] sentenceWords) {
        ArrayList<TSNodeLabel> lexItems = this.collectLexicalItems();
        Iterator<TSNodeLabel> lexIter = lexItems.iterator();
        String[] stringArray = sentenceWords;
        int n = sentenceWords.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            TSNodeLabel lexNode = lexIter.next();
            lexNode.label = Label.getLabel(w);
            ++n2;
        }
    }

    public void removePreterminalWithPrefix(String prefix, int position) {
        if (this.isLexical) {
            return;
        }
        if (this.label().startsWith(prefix)) {
            TSNodeLabel lexDaughter;
            this.parent.daughters[position] = lexDaughter = this.daughters[0];
            lexDaughter.parent = this.parent;
            return;
        }
        position = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.removePreterminalWithPrefix(prefix, position);
            ++position;
            ++n2;
        }
    }

    public TSNodeLabel replaceRulesWithFragments(Hashtable<String, TSNodeLabel> ruleFragmentTable) {
        String cfgRule = this.cfgRule();
        TSNodeLabel fragment = ruleFragmentTable.get(cfgRule);
        if (fragment == null) {
            return this;
        }
        TSNodeLabel result = fragment.clone();
        ArrayList<TSNodeLabel> terminals = result.collectTerminalItems();
        Iterator<TSNodeLabel> termIter = terminals.iterator();
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            TSNodeLabel term = termIter.next();
            if (!term.isLexical) {
                TSNodeLabel subFragment = d.replaceRulesWithFragments(ruleFragmentTable);
                term.daughters = subFragment.daughters;
                TSNodeLabel[] tSNodeLabelArray2 = subFragment.daughters;
                int n3 = subFragment.daughters.length;
                int n4 = 0;
                while (n4 < n3) {
                    TSNodeLabel d1 = tSNodeLabelArray2[n4];
                    d1.parent = subFragment;
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }

    public int indexOfHeadDaughter() {
        int i = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.headMarked) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public int indexOfDaughter(TSNodeLabel d) {
        if (this.daughters == null) {
            return -1;
        }
        int i = 0;
        while (i < this.prole()) {
            if (this.daughters[i] == d) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean findLastDaughterIN() {
        if (this.isTerminal()) {
            return false;
        }
        if (this.parent != null && this.parent.label().equals("VP") && this.daughters[this.prole() - 1].label().equals("IN")) {
            return true;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.findLastDaughterIN()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean yieldsOneWord() {
        if (this.isPreLexical()) {
            return true;
        }
        if (this.prole() > 1) {
            return false;
        }
        return this.daughters[0].yieldsOneWord();
    }

    public boolean allDaughtersAreNonPreterminal() {
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.isPreLexical()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public TSNodeLabel getHeadDaughter() {
        if (this.daughters == null) {
            return null;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.headMarked) {
                return d;
            }
            ++n2;
        }
        return null;
    }

    public TSNodeLabel getPosLexHead() {
        TSNodeLabel result = this;
        while (result != null && !result.isPreLexical()) {
            result = result.getHeadDaughter();
        }
        return result;
    }

    public int countNonPreterminalDaughters() {
        if (this.daughters == null) {
            return 0;
        }
        int result = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (!d.isPreLexical()) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public TSNodeLabel nextWord() {
        TSNodeLabel rightSister;
        TSNodeLabel current = this;
        TSNodeLabel ancestor = this.parent;
        while (true) {
            if (ancestor == null) {
                return null;
            }
            rightSister = current.getRightSister();
            if (rightSister != null) break;
            current = ancestor;
            ancestor = ancestor.parent;
        }
        do {
            rightSister = rightSister.daughters[0];
        } while (!rightSister.isLexical);
        return rightSister;
    }

    public TSNodeLabel previousWord() {
        TSNodeLabel leftSister;
        TSNodeLabel current = this;
        TSNodeLabel ancestor = this.parent;
        while (true) {
            if (ancestor == null) {
                return null;
            }
            leftSister = current.getLeftSister();
            if (leftSister != null) break;
            current = ancestor;
            ancestor = ancestor.parent;
        }
        do {
            leftSister = leftSister.daughters[leftSister.prole() - 1];
        } while (!leftSister.isLexical);
        return leftSister;
    }

    public TSNodeLabel getRightSister() {
        int prole = this.parent.prole();
        if (prole == 1) {
            return null;
        }
        int lastChildIndex = prole - 1;
        TSNodeLabel[] sibling = this.parent.daughters;
        int i = 0;
        while (i < lastChildIndex) {
            TSNodeLabel n = sibling[i];
            if (n == this) {
                return sibling[i + 1];
            }
            ++i;
        }
        return null;
    }

    public TSNodeLabel getLeftSister() {
        int prole = this.parent.prole();
        if (prole == 1) {
            return null;
        }
        TSNodeLabel[] sibling = this.parent.daughters;
        TSNodeLabel previous = null;
        int i = 0;
        while (i < prole) {
            TSNodeLabel n = sibling[i];
            if (n == this) {
                return previous;
            }
            previous = n;
            ++i;
        }
        return null;
    }

    public int headCount() {
        if (this.daughters == null) {
            return 0;
        }
        int result = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.headMarked) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public void fillHeadDaughters(TSNodeLabel[] heads) {
        int i = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.headMarked) {
                heads[i++] = d;
            }
            ++n2;
        }
    }

    public boolean pruneSubTrees(String tag) {
        TSNodeLabel uniqueDaughter;
        if (this.toString().indexOf(tag) == -1) {
            return false;
        }
        if (this.label().equals(tag)) {
            return true;
        }
        if (this.isTerminal()) {
            return false;
        }
        ArrayList<TSNodeLabel> nonTraces = new ArrayList<TSNodeLabel>();
        int i = 0;
        while (i < this.daughters.length) {
            TSNodeLabel D = this.daughters[i];
            if (!D.pruneSubTrees(tag)) {
                nonTraces.add(D);
            }
            ++i;
        }
        if (nonTraces.size() == this.daughters.length) {
            return false;
        }
        if (nonTraces.isEmpty()) {
            return true;
        }
        if (nonTraces.size() == 1 && (uniqueDaughter = (TSNodeLabel)nonTraces.get(0)).sameLabel(this)) {
            TSNodeLabel[] tSNodeLabelArray = this.daughters = uniqueDaughter.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel d = tSNodeLabelArray[n2];
                d.parent = this;
                ++n2;
            }
            return false;
        }
        this.daughters = nonTraces.toArray(new TSNodeLabel[nonTraces.size()]);
        return false;
    }

    public boolean pruneSubTreesStartingWith(String tagStart) {
        TSNodeLabel uniqueDaughter;
        if (this.toString().indexOf(tagStart) == -1) {
            return false;
        }
        if (this.label().startsWith(tagStart)) {
            return true;
        }
        if (this.isTerminal()) {
            return false;
        }
        ArrayList<TSNodeLabel> nonTraces = new ArrayList<TSNodeLabel>();
        int i = 0;
        while (i < this.daughters.length) {
            TSNodeLabel D = this.daughters[i];
            if (!D.pruneSubTreesStartingWith(tagStart)) {
                nonTraces.add(D);
            }
            ++i;
        }
        if (nonTraces.size() == this.daughters.length) {
            return false;
        }
        if (nonTraces.isEmpty()) {
            return true;
        }
        if (nonTraces.size() == 1 && (uniqueDaughter = (TSNodeLabel)nonTraces.get(0)).sameLabel(this)) {
            TSNodeLabel[] tSNodeLabelArray = this.daughters = uniqueDaughter.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel d = tSNodeLabelArray[n2];
                d.parent = this;
                ++n2;
            }
            return false;
        }
        this.daughters = nonTraces.toArray(new TSNodeLabel[nonTraces.size()]);
        return false;
    }

    public TSNodeLabel pruneSubTrees(String[] removeLabels) {
        if (Arrays.binarySearch(removeLabels, this.label()) >= 0) {
            return this;
        }
        if (this.isTerminal()) {
            return null;
        }
        LinkedList<TSNodeLabel> toKeep = new LinkedList<TSNodeLabel>();
        int i = 0;
        while (i < this.daughters.length) {
            TSNodeLabel D = this.daughters[i];
            if (D.pruneSubTrees(removeLabels) == null) {
                toKeep.add(D);
            }
            ++i;
        }
        if (toKeep.size() == this.daughters.length) {
            return null;
        }
        if (toKeep.isEmpty()) {
            return this;
        }
        this.daughters = toKeep.toArray(new TSNodeLabel[toKeep.size()]);
        return null;
    }

    public TSNodeLabel pruneLex(String[] removeLex) {
        if (this.isPreLexical()) {
            if (Arrays.binarySearch(removeLex, this.daughters[0].label()) >= 0) {
                return this;
            }
            return null;
        }
        LinkedList<TSNodeLabel> toKeep = new LinkedList<TSNodeLabel>();
        int i = 0;
        while (i < this.daughters.length) {
            TSNodeLabel D = this.daughters[i];
            if (D.pruneLex(removeLex) == null) {
                toKeep.add(D);
            }
            ++i;
        }
        if (toKeep.size() == this.daughters.length) {
            return null;
        }
        if (toKeep.isEmpty()) {
            return this;
        }
        this.daughters = toKeep.toArray(new TSNodeLabel[toKeep.size()]);
        return null;
    }

    public String getYield() {
        ArrayList<TSNodeLabel> terminals = this.collectLexicalItems();
        String result = "";
        for (TSNodeLabel TN : terminals) {
            result = String.valueOf(result) + TN.label() + " ";
        }
        result = result.trim();
        return result;
    }

    public ArrayList<String> allSubTrees(int maxDepth, int maxProle) {
        Pair<ArrayList<String>> duet = this.allSubTreesB(maxDepth, maxProle);
        ArrayList<String> result = duet.getFirst();
        result.addAll((Collection<String>)duet.getSecond());
        return result;
    }

    private Pair<ArrayList<String>> allSubTreesB(int maxDepth, int maxProle) {
        Pair<ArrayList<String>> subTrees = new Pair<ArrayList<String>>(new ArrayList(), new ArrayList());
        if (this.isTerminal()) {
            return subTrees;
        }
        int prole = this.daughters.length;
        if (prole > maxProle) {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel TN = tSNodeLabelArray[n2];
                Pair<ArrayList<String>> daugherSubTreesNewOld = TN.allSubTreesB(maxDepth, maxProle);
                subTrees.getSecond().addAll((Collection<String>)daugherSubTreesNewOld.getFirst());
                subTrees.getSecond().addAll((Collection<String>)daugherSubTreesNewOld.getSecond());
                ++n2;
            }
            subTrees.getFirst().add("(" + this.cfgRule() + ")");
        } else {
            ArrayList<ArrayList<String>> daughterSubTrees = new ArrayList<ArrayList<String>>(prole);
            int[] daughterSubTreesSize = new int[prole];
            int index = 0;
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int daugherSubTreesNewOld = 0;
            while (daugherSubTreesNewOld < n) {
                TSNodeLabel TN = tSNodeLabelArray[daugherSubTreesNewOld];
                Pair<ArrayList<String>> daugherSubTreesNewOld2 = TN.allSubTreesB(maxDepth, maxProle);
                subTrees.getSecond().addAll((Collection<String>)daugherSubTreesNewOld2.getFirst());
                subTrees.getSecond().addAll((Collection<String>)daugherSubTreesNewOld2.getSecond());
                ArrayList<String> TNlist = daugherSubTreesNewOld2.getFirst();
                TNlist.add(TN.label(false, true));
                daughterSubTrees.add(TNlist);
                ListIterator<String> l = TNlist.listIterator();
                while (l.hasNext()) {
                    String sT = l.next();
                    TSNode TNsT = new TSNode(sT, false);
                    if (TNsT.maxDepth(true) != maxDepth) continue;
                    l.remove();
                }
                daughterSubTreesSize[index] = TNlist.size();
                ++index;
                ++daugherSubTreesNewOld;
            }
            int[][] combinations = Utility.combinations(daughterSubTreesSize);
            int i = 0;
            while (i < combinations.length) {
                String rule = "(" + this.label(false, false) + " ";
                int j = 0;
                while (j < prole) {
                    String sT = (String)((ArrayList)daughterSubTrees.get(j)).get(combinations[i][j]);
                    rule = String.valueOf(rule) + sT;
                    rule = String.valueOf(rule) + (j == prole - 1 ? ")" : " ");
                    ++j;
                }
                subTrees.getFirst().add(rule);
                ++i;
            }
        }
        return subTrees;
    }

    public static Hashtable<String, HashSet<String>> getLexPosTableFromTreebank(ArrayList<TSNodeLabel> treebank) {
        Hashtable<String, HashSet<String>> result = new Hashtable<String, HashSet<String>>();
        for (TSNodeLabel t : treebank) {
            ArrayList<TSNodeLabel> lex = t.collectLexicalItems();
            for (TSNodeLabel l : lex) {
                String l_label = l.label();
                HashSet<String> lStoredPos = result.get(l_label);
                if (lStoredPos == null) {
                    lStoredPos = new HashSet();
                    result.put(l_label, lStoredPos);
                }
                lStoredPos.add(l.parent.label());
            }
        }
        return result;
    }

    public static HashSet<String> getPosSetFromTreebank(ArrayList<TSNodeLabel> treebank) {
        HashSet<String> result = new HashSet<String>();
        for (TSNodeLabel t : treebank) {
            ArrayList<TSNodeLabel> lex = t.collectLexicalItems();
            for (TSNodeLabel l : lex) {
                result.add(l.parent.label());
            }
        }
        return result;
    }

    public List<String> collectTerminalStrings() {
        ArrayList<TSNodeLabel> terminals = this.collectTerminalItems();
        ArrayList<String> result = new ArrayList<String>(terminals.size());
        for (TSNodeLabel TN : terminals) {
            result.add(TN.toString(false, false));
        }
        return result;
    }

    public TSNodeLabel firstDaughter() {
        return this.daughters[0];
    }

    public TSNodeLabel lastDaughter() {
        return this.daughters[this.prole() - 1];
    }

    public TSNodeLabel getLeftmostLexicon() {
        if (this.isLexical) {
            return this;
        }
        return this.firstDaughter().getLeftmostLexicon();
    }

    public TSNodeLabel getLeftmostPreLexicon() {
        if (this.isPreLexical()) {
            return this;
        }
        return this.firstDaughter().getLeftmostPreLexicon();
    }

    public TSNodeLabel getRightmostLexicon() {
        if (!this.isLexical) {
            return this.lastDaughter().getRightmostLexicon();
        }
        return this;
    }

    public void removeCurrentNode() {
        TSNodeLabel p = this.parent;
        int position = p.indexOfDaughter(this);
        int prole = this.prole();
        int parentProle = this.parent.prole();
        int newParentProle = parentProle - 1 + prole;
        TSNodeLabel[] newDaughters = new TSNodeLabel[newParentProle];
        int oldIndex = 0;
        boolean addedOldDaughters = false;
        int i = 0;
        while (i < newParentProle) {
            if (addedOldDaughters || i < position) {
                newDaughters[i] = this.parent.daughters[oldIndex++];
            } else if (i == position) {
                ++oldIndex;
                int j = 0;
                while (j < prole) {
                    TSNodeLabel d = this.daughters[j];
                    d.parent = this.parent;
                    newDaughters[i++] = d;
                    ++j;
                }
                --i;
                addedOldDaughters = true;
            }
            ++i;
        }
        this.parent.daughters = newDaughters;
    }

    public static long countPartialFragmentInTreebank(ArrayList<TSNodeLabel> treebank, TSNodeLabel target) {
        int count = 0;
        for (TSNodeLabel t : treebank) {
            count = (int)((long)count + t.countRecursivePartialFragment(target));
        }
        return count;
    }

    public static int countFragmentInTreebank(ArrayList<TSNodeLabel> treebank, TSNodeLabel target) {
        int count = 0;
        for (TSNodeLabel t : treebank) {
            count += t.countRecursiveFragment(target);
        }
        return count;
    }

    public static void removeSemanticTags(ArrayList<TSNodeLabel> treebank) {
        for (TSNodeLabel t : treebank) {
            t.removeSemanticTags();
        }
    }

    public static void replaceLabelTreebank(ArrayList<TSNodeLabel> treebank, String oldLabel, String newLabel) {
        for (TSNodeLabel inputTree : treebank) {
            inputTree.replaceLabels(oldLabel, newLabel);
        }
    }

    public void fixCCPatterns(String[] CClabels, String[] ignoreInitialLabels) {
        if (this.isPreLexical()) {
            return;
        }
        BitSet indexesCC = this.indexDaughtersWithLabels(CClabels);
        if (indexesCC != null) {
            int prole = this.prole();
            int startIndex = 0;
            int di = 0;
            while (di < prole) {
                TSNodeLabel d = this.daughters[di];
                if (Arrays.binarySearch(ignoreInitialLabels, d.label()) < 0) {
                    startIndex = di;
                    break;
                }
                ++di;
            }
            int patternsNumber = indexesCC.cardinality() + 1;
            Vector patterns = new Vector(patternsNumber);
            int i = 0;
            while (i < patternsNumber) {
                patterns.add(new ArrayList());
                ++i;
            }
            int currentPatternIndex = 0;
            int di2 = startIndex;
            while (di2 < prole) {
                if (indexesCC.get(di2)) {
                    ++currentPatternIndex;
                } else {
                    TSNodeLabel d = this.daughters[di2];
                    ((ArrayList)patterns.get(currentPatternIndex)).add(d.label());
                }
                ++di2;
            }
            ArrayList firstPattern = (ArrayList)patterns.get(0);
            int patternSize = firstPattern.size();
            if (patternSize > 1) {
                boolean equalPatterns = true;
                int i2 = 1;
                while (i2 < patternsNumber) {
                    if (!((ArrayList)patterns.get(i2)).equals(firstPattern)) {
                        equalPatterns = false;
                        break;
                    }
                    ++i2;
                }
                if (equalPatterns) {
                    String groupsLabel = this.label();
                    String lineReport = "Building separate constituents for coordination patter: " + this.toStringOneLevel() + " ---> ";
                    int bI = startIndex - 2;
                    int i3 = 0;
                    while (i3 < patternsNumber) {
                        int eI = (bI += 2) + patternSize - 1;
                        this.groupConsecutiveDaughters(bI, eI, groupsLabel);
                        ++i3;
                    }
                    lineReport = String.valueOf(lineReport) + this.toStringOneLevel();
                    Parameters.logPrintln(lineReport);
                }
            }
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.fixCCPatterns(CClabels, ignoreInitialLabels);
            ++n2;
        }
    }

    public int countDaughtersWithLabel(String[] labels) {
        if (this.isLexical) {
            return 0;
        }
        int count = 0;
        boolean found = false;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (Arrays.binarySearch(labels, d.label()) >= 0) {
                ++count;
            }
            ++n2;
        }
        if (found) {
            ++count;
        }
        return count;
    }

    public boolean yieldNonLexicalNodeStartingWith(String prefix) {
        if (this.isLexical) {
            return false;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.label().startsWith(prefix) || d.yieldNonLexicalNodeStartingWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasDaughterStartingWith(String labelPrefix) {
        int di = 0;
        while (di < this.prole()) {
            TSNodeLabel d = this.daughters[di];
            if (d.label().startsWith(labelPrefix)) {
                return true;
            }
            ++di;
        }
        return false;
    }

    public boolean yieldPrelexicalStartingWith(String labelPrefix) {
        ArrayList<TSNodeLabel> lex = this.collectLexicalItems();
        for (TSNodeLabel l : lex) {
            if (!l.parent.label().startsWith(labelPrefix)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDaughterWithLabel(Label l) {
        int di = 0;
        while (di < this.prole()) {
            TSNodeLabel d = this.daughters[di];
            if (d.label.equals(l)) {
                return true;
            }
            ++di;
        }
        return false;
    }

    public TSNodeLabel getDaughterWithLabel(Label l) {
        int di = 0;
        while (di < this.prole()) {
            TSNodeLabel d = this.daughters[di];
            if (d.label.equals(l)) {
                return d;
            }
            ++di;
        }
        return null;
    }

    public TSNodeLabel getDaughterWithLabelStartingWith(String prefix) {
        int di = 0;
        while (di < this.prole()) {
            TSNodeLabel d = this.daughters[di];
            if (d.label().startsWith(prefix)) {
                return d;
            }
            ++di;
        }
        return null;
    }

    public BitSet indexDaughtersWithLabels(String[] labels) {
        BitSet result = new BitSet();
        int di = 0;
        while (di < this.prole()) {
            TSNodeLabel d = this.daughters[di];
            if (Arrays.binarySearch(labels, d.label()) >= 0) {
                result.set(di);
            }
            ++di;
        }
        return result.isEmpty() ? null : result;
    }

    public static int maxDepthTreebank(ArrayList<TSNodeLabel> treebank) {
        int maxDepth = -1;
        for (TSNodeLabel t : treebank) {
            int depth = t.maxDepth();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    public static int maxBranchingTreebank(ArrayList<TSNodeLabel> treebank) {
        int maxBranching = -1;
        for (TSNodeLabel t : treebank) {
            int branching = t.maxBranching();
            if (branching <= maxBranching) continue;
            maxBranching = branching;
        }
        return maxBranching;
    }

    public void groupConsecutiveDaughters(int beginIndex, int endIndex, String groupLabel) {
        int groupSize = endIndex - beginIndex + 1;
        int prole = this.prole();
        TSNodeLabel groupNode = new TSNodeLabel();
        groupNode.label = Label.getLabel(groupLabel);
        groupNode.parent = this;
        TSNodeLabel[] newGroupDaughters = new TSNodeLabel[groupSize];
        groupNode.daughters = newGroupDaughters;
        int k = 0;
        int j = beginIndex;
        while (j <= endIndex) {
            newGroupDaughters[k] = this.daughters[j];
            newGroupDaughters[k].parent = groupNode;
            ++k;
            ++j;
        }
        int newProle = prole - groupSize + 1;
        TSNodeLabel[] newDaughters = new TSNodeLabel[newProle];
        k = 0;
        int j2 = 0;
        while (j2 < prole) {
            if (j2 == beginIndex) {
                newDaughters[k++] = groupNode;
            } else if (j2 <= beginIndex || j2 > endIndex) {
                newDaughters[k++] = this.daughters[j2];
            }
            ++j2;
        }
        this.daughters = newDaughters;
    }

    public void groupConsecutiveDaughters(String[] labels, String groupLabel) {
        this.groupConsecutiveDaughters(labels, groupLabel, 0);
    }

    private void groupConsecutiveDaughters(String[] labels, String groupLabel, int startIndex) {
        int groupSize;
        TSNodeLabel d;
        if (this.isLexical) {
            return;
        }
        int beginIndex = -1;
        int endIndex = -1;
        int prole = this.prole();
        while (startIndex < prole) {
            d = this.daughters[startIndex];
            if (Arrays.binarySearch(labels, d.label()) >= 0) {
                if (beginIndex == -1) {
                    beginIndex = startIndex;
                }
                endIndex = startIndex;
            } else if (endIndex != -1) break;
            ++startIndex;
        }
        if (beginIndex != -1 && (groupSize = endIndex - beginIndex + 1) > 1 && groupSize != prole) {
            String lineReport = "Grouped nodes: " + this.toStringOneLevel() + " --> ";
            this.groupConsecutiveDaughters(beginIndex, endIndex, groupLabel);
            lineReport = String.valueOf(lineReport) + this.toStringOneLevel();
            Parameters.logPrintln(lineReport);
        }
        if (startIndex < prole) {
            this.groupConsecutiveDaughters(labels, groupLabel, startIndex);
        } else {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n2 = 0;
            while (n2 < n) {
                d = tSNodeLabelArray[n2];
                d.groupConsecutiveDaughters(labels, groupLabel, 0);
                ++n2;
            }
        }
    }

    public void removeUniqueProductions(String[] labels) {
        if (this.isLexical) {
            return;
        }
        int i = 0;
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            if (d.hasUniqueDaugher(labels)) {
                this.daughters[i] = this.daughters[i].daughters[0];
                this.daughters[i].parent = this;
            } else {
                d.removeUniqueProductions(labels);
            }
            ++i;
            ++n2;
        }
    }

    public boolean hasUniqueDaugher(String[] labels) {
        if (this.isLexical || this.label().indexOf(45) > 0) {
            return false;
        }
        if (this.prole() > 1) {
            return false;
        }
        String firstLabel = this.daughters[0].label();
        return Arrays.binarySearch(labels, firstLabel) >= 0;
    }

    public boolean hasUniquePathToLexicalItem() {
        if (this.isLexical) {
            return true;
        }
        if (this.prole() > 1) {
            return false;
        }
        return this.daughters[0].hasUniquePathToLexicalItem();
    }

    public void fixPunctInNNP() {
        if (this.isLexical) {
            return;
        }
        if ((this.label().startsWith("NP") || this.label().startsWith("NML")) && this.prole() == 2) {
            TSNodeLabel firstDaughter = this.daughters[0];
            TSNodeLabel secondDaughter = this.daughters[1];
            if (firstDaughter.label().startsWith("NNP") && secondDaughter.label().equals(".")) {
                String lineReport = "Fix dot in NNP: " + this.toStringOneLevel() + " --> ";
                TSNodeLabel term = firstDaughter.daughters[0];
                term.relabel(String.valueOf(term.label()) + ".");
                this.daughters = new TSNodeLabel[]{firstDaughter};
                String string = String.valueOf(lineReport) + this.toStringOneLevel();
            }
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.fixPunctInNNP();
            ++n2;
        }
    }

    public void makeCleanWsj() {
        this.pruneSubTrees(nullTag);
        this.replaceAllNonTerminalLabels(dashEqualDigits, "");
        this.removeRedundantRules();
    }

    public void findWHNP(int line) {
        if (this.isLexical) {
            return;
        }
        if (this.label.equals(WHNP_label) && this.prole() > 1) {
            System.out.println(String.valueOf(line) + ":" + this);
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.findWHNP(line);
            ++n2;
        }
    }

    public static void findWHNP(File inputFile) throws Exception {
        Scanner scan = FileUtil.getScanner(inputFile);
        int lineNumber = 1;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            TSNodeLabel tree = new TSNodeLabel(line);
            tree.findWHNP(lineNumber);
            ++lineNumber;
        }
    }

    public void collectNodesPos(TreeSet<String> nodeLabels, TreeSet<String> posLabels) {
        if (this.isLexical) {
            return;
        }
        if (this.isPreLexical()) {
            posLabels.add(this.label());
            return;
        }
        nodeLabels.add(this.label());
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.collectNodesPos(nodeLabels, posLabels);
            ++n2;
        }
    }

    public void markCircumstantial(String[] advSemTagSorted, String suffix) {
        if (this.isLexical || this.isPreLexical()) {
            return;
        }
        String label = this.label();
        String[] semTags = label.split("[-=]");
        if (semTags.length > 1) {
            int i = 1;
            while (i < semTags.length) {
                if (Arrays.binarySearch(advSemTagSorted, semTags[i]) >= 0) {
                    String newLabel = String.valueOf(semTags[0]) + suffix + label.substring(semTags[0].length());
                    this.relabel(newLabel);
                    break;
                }
                ++i;
            }
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.markCircumstantial(advSemTagSorted, suffix);
            ++n2;
        }
    }

    public boolean samePos(TSNodeLabel other) {
        ArrayList<TSNodeLabel> thisLex = this.collectLexicalItems();
        ArrayList<TSNodeLabel> otherLex = other.collectLexicalItems();
        if (thisLex.size() != otherLex.size()) {
            return false;
        }
        Iterator<TSNodeLabel> thisLexIter = thisLex.iterator();
        Iterator<TSNodeLabel> otherLexIter = otherLex.iterator();
        while (thisLexIter.hasNext()) {
            TSNodeLabel thisL = thisLexIter.next();
            TSNodeLabel otherL = otherLexIter.next();
            if (thisL.parent.label.equals(otherL.parent.label)) continue;
            return false;
        }
        return true;
    }

    public static void removeSemanticTagsInTreebank(ArrayList<TSNodeLabel> treebank) {
        for (TSNodeLabel t : treebank) {
            t.removeSemanticTags();
        }
    }

    public void removeNumberInLabels() {
        String newLabel;
        if (this.isTerminal()) {
            return;
        }
        String currentLabel = this.label();
        if (!currentLabel.equals(newLabel = currentLabel.replaceAll("-\\d+", "").replaceAll("=\\d+", ""))) {
            this.relabel(newLabel);
        }
        int i = 0;
        while (i < this.daughters.length) {
            this.daughters[i].removeNumberInLabels();
            ++i;
        }
    }

    public void pruneDaughter(int index) {
        TSNodeLabel[] newDaughters = new TSNodeLabel[this.daughters.length - 1];
        int i = 0;
        int j = 0;
        while (j < this.daughters.length) {
            if (j != index) {
                newDaughters[i] = this.daughters[j];
                ++i;
            }
            ++j;
        }
        this.daughters = newDaughters;
    }

    public void insertNewDaughter(TSNodeLabel daughter, int newPosition) {
        TSNodeLabel[] newDaughters = new TSNodeLabel[this.daughters.length + 1];
        int i = 0;
        int j = 0;
        while (j < newDaughters.length) {
            if (j == newPosition) {
                newDaughters[j] = daughter;
            } else {
                newDaughters[j] = this.daughters[i];
                ++i;
            }
            ++j;
        }
        daughter.parent = this;
        this.daughters = newDaughters;
    }

    public void raisePunctuation(String[] punctuationSorted) {
        ArrayList<TSNodeLabel> lexicon = this.collectLexicalItems();
        for (TSNodeLabel leaf : lexicon) {
            int newPosition;
            TSNodeLabel parentNode;
            TSNodeLabel postag = leaf.parent;
            if (Arrays.binarySearch(punctuationSorted, postag.label()) < 0 || postag.isUniqueDaughter()) continue;
            TSNodeLabel postagParent = postag.parent;
            int prole = postagParent.prole();
            int index = postagParent.indexOfDaughter(postag);
            if (index == 0) {
                parentNode = postagParent;
                while (parentNode.parent != null && parentNode == parentNode.parent.firstDaughter()) {
                    parentNode = parentNode.parent;
                }
                if (parentNode.parent == null) continue;
                postagParent.pruneDaughter(index);
                newPosition = parentNode.parent.indexOfDaughter(parentNode);
                parentNode.parent.insertNewDaughter(postag, newPosition);
                continue;
            }
            if (index != prole - 1) continue;
            parentNode = postagParent;
            while (parentNode.parent != null && parentNode == parentNode.parent.lastDaughter()) {
                parentNode = parentNode.parent;
            }
            if (parentNode.parent == null) continue;
            postagParent.pruneDaughter(index);
            newPosition = parentNode.parent.indexOfDaughter(parentNode) + 1;
            parentNode.parent.insertNewDaughter(postag, newPosition);
        }
    }

    public boolean hasSamePosTag(TSNodeLabel g) {
        ArrayList<TSNodeLabel> thisPreLex = this.collectPreLexicalItems();
        ArrayList<TSNodeLabel> gPreLex = g.collectPreLexicalItems();
        if (thisPreLex.size() != gPreLex.size()) {
            return false;
        }
        Iterator<TSNodeLabel> thisPreLexIter = thisPreLex.iterator();
        Iterator<TSNodeLabel> gPreLexIter = gPreLex.iterator();
        while (thisPreLexIter.hasNext()) {
            TSNodeLabel thisLex = thisPreLexIter.next();
            TSNodeLabel gLex = gPreLexIter.next();
            if (thisLex.label.equals(gLex.label)) continue;
            return false;
        }
        return true;
    }

    public void makeTreeCharBased() {
        ArrayList<TSNodeLabel> lex = this.collectLexicalItems();
        for (TSNodeLabel l : lex) {
            TSNodeLabel pos = l.parent;
            String word = l.label();
            char[] charArray = word.toCharArray();
            int length = charArray.length;
            TSNodeLabel[] newDaughters = new TSNodeLabel[length + 2];
            newDaughters[0] = new TSNodeLabel(startWordChar, true);
            int i = 0;
            while (i < length) {
                char c = charArray[i];
                Label lab = Label.getLabel(Character.toString(c));
                newDaughters[i + 1] = new TSNodeLabel(lab, true);
                ++i;
            }
            newDaughters[i + 1] = new TSNodeLabel(endWordChar, true);
            pos.daughters = newDaughters;
        }
    }

    public void cutLexicon() {
        ArrayList<TSNodeLabel> lex = this.collectLexicalItems();
        for (TSNodeLabel l : lex) {
            l.parent.daughters = null;
        }
    }

    public static TSNodeLabel makeRightBranchingKlein(ArrayList<TSNodeLabel> terminals, Label topNode, Label internalNodes) throws Exception {
        LinkedList<TSNodeLabel> terminalsList = new LinkedList<TSNodeLabel>(terminals);
        Iterator<TSNodeLabel> iter = terminalsList.descendingIterator();
        TSNodeLabel last = iter.next();
        TSNodeLabel parent = new TSNodeLabel(iter.hasNext() ? internalNodes : topNode, false);
        parent.daughters = new TSNodeLabel[]{last};
        last.parent = parent;
        while (iter.hasNext()) {
            TSNodeLabel previousParent = parent;
            last = iter.next();
            parent = new TSNodeLabel(iter.hasNext() ? internalNodes : topNode, false);
            parent.daughters = new TSNodeLabel[]{last, previousParent};
            last.parent = parent;
            previousParent.parent = parent;
        }
        return parent;
    }

    public static TSNodeLabel makeRightBranchingYoav(ArrayList<TSNodeLabel> terminals, Label topNode, Label internalNodes) throws Exception {
        TSNodeLabel rightBranching = TSNodeLabel.makeRightBranchingKlein(terminals, topNode, internalNodes);
        int size = terminals.size();
        if (size == 1) {
            return rightBranching;
        }
        TSNodeLabel lastLTerm = terminals.get(size - 1);
        TSNodeLabel lastLexGrandParent = lastLTerm.parent.parent;
        lastLexGrandParent.daughters[1] = lastLTerm;
        return rightBranching;
    }

    public void uncompressUnaryProductions(String unaryProductionSeparator) {
        TSNodeLabel currentNode = this;
        String currentLabel = currentNode.label();
        boolean originalIsLexical = currentNode.isLexical;
        while (currentLabel.contains(unaryProductionSeparator)) {
            int index = currentLabel.indexOf(unaryProductionSeparator);
            String label1 = currentLabel.substring(0, index);
            String label2 = currentLabel.substring(index + unaryProductionSeparator.length());
            currentNode.relabel(label1);
            currentNode.isLexical = false;
            TSNodeLabel newNode = new TSNodeLabel(Label.getLabel(label2), false);
            newNode.daughters = currentNode.daughters;
            if (!newNode.isTerminal()) {
                TSNodeLabel[] tSNodeLabelArray = newNode.daughters;
                int n = newNode.daughters.length;
                int n2 = 0;
                while (n2 < n) {
                    TSNodeLabel d = tSNodeLabelArray[n2];
                    d.parent = newNode;
                    ++n2;
                }
            }
            currentNode.daughters = new TSNodeLabel[]{newNode};
            currentNode = newNode;
            currentLabel = currentNode.label();
        }
        currentNode.isLexical = originalIsLexical;
        if (!currentNode.isTerminal()) {
            TSNodeLabel[] tSNodeLabelArray = currentNode.daughters;
            int n = currentNode.daughters.length;
            int n3 = 0;
            while (n3 < n) {
                TSNodeLabel d = tSNodeLabelArray[n3];
                d.uncompressUnaryProductions(unaryProductionSeparator);
                ++n3;
            }
        }
    }

    public void compressUnaryProductions(String unaryProductionSeparator, boolean includeLexicalItem) {
        if (this.isTerminal()) {
            return;
        }
        if (this.daughters.length == 1) {
            boolean prelexical = this.isPreLexical();
            if (!prelexical || includeLexicalItem) {
                TSNodeLabel singleDaughter = this.firstDaughter();
                String newLabel = String.valueOf(this.label()) + unaryProductionSeparator + singleDaughter.label();
                this.daughters = singleDaughter.daughters;
                this.relabel(newLabel);
                if (!this.isTerminal()) {
                    TSNodeLabel[] tSNodeLabelArray = this.daughters;
                    int n = this.daughters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TSNodeLabel d = tSNodeLabelArray[n2];
                        d.parent = this;
                        ++n2;
                    }
                }
                this.isLexical = prelexical;
                this.compressUnaryProductions(unaryProductionSeparator, includeLexicalItem);
            }
        } else {
            TSNodeLabel[] tSNodeLabelArray = this.daughters;
            int n = this.daughters.length;
            int n3 = 0;
            while (n3 < n) {
                TSNodeLabel d = tSNodeLabelArray[n3];
                d.compressUnaryProductions(unaryProductionSeparator, includeLexicalItem);
                ++n3;
            }
        }
    }

    public void unbinarizeEarly(String dotBinarizationMarker) {
        int prole = this.prole();
        if (prole == 0) {
            return;
        }
        if (prole == 2 && this.daughters[1].label().contains(dotBinarizationMarker)) {
            TSNodeLabel currentParent = this;
            ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
            do {
                TSNodeLabel leftDaughter = currentParent.firstDaughter();
                newDaughters.add(leftDaughter);
                leftDaughter.parent = this;
            } while ((currentParent = currentParent.daughters[1]).label().contains(dotBinarizationMarker));
            newDaughters.add(currentParent);
            currentParent.parent = this;
            this.daughters = newDaughters.toArray(new TSNodeLabel[newDaughters.size()]);
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.unbinarizeEarly(dotBinarizationMarker);
            ++n2;
        }
    }

    public void binarizeEarly(String dotBinarizationMarker) {
        int prole = this.prole();
        if (prole == 0) {
            return;
        }
        if (prole > 2) {
            TSNodeLabel[] originalDaughters = this.daughters;
            TSNodeLabel[] newDaughters = TSNodeLabel.getDaughterDotLabels(this.label(), originalDaughters, this, dotBinarizationMarker, 1);
            this.daughters = newDaughters;
        }
        TSNodeLabel[] tSNodeLabelArray = this.daughters;
        int n = this.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.binarizeEarly(dotBinarizationMarker);
            ++n2;
        }
    }

    private static TSNodeLabel[] getDaughterDotLabels(String parentLabelString, TSNodeLabel[] originalDaughters, TSNodeLabel parent, String dotBinarizationMarker, int dotIndex) {
        TSNodeLabel leftDaughter = originalDaughters[dotIndex - 1];
        TSNodeLabel rightDaughter = null;
        if (dotIndex + 1 == originalDaughters.length) {
            rightDaughter = originalDaughters[dotIndex];
        } else {
            StringBuilder sb = new StringBuilder(parentLabelString).append("|").append(originalDaughters[0].label());
            int i = 1;
            while (i < originalDaughters.length) {
                sb.append("_");
                if (dotIndex == i) {
                    sb.append(dotBinarizationMarker);
                    sb.append("_");
                }
                sb.append(originalDaughters[i].label());
                ++i;
            }
            rightDaughter = new TSNodeLabel(Label.getLabel(sb.toString()), false);
            rightDaughter.daughters = TSNodeLabel.getDaughterDotLabels(parentLabelString, originalDaughters, rightDaughter, dotBinarizationMarker, dotIndex + 1);
        }
        leftDaughter.parent = parent;
        rightDaughter.parent = parent;
        return new TSNodeLabel[]{leftDaughter, rightDaughter};
    }

    public static TSNodeLabel getRandomTree(String[] internalLabels, String[] lexLabels, int maxBranching, double[] branchingProb, boolean unary, double lexProb, int depth, int maxDepth) {
        if (unary && (depth == maxDepth || Math.random() < lexProb)) {
            String lexLabel = lexLabels[(int)(Math.random() * (double)lexLabels.length)];
            return new TSNodeLabel(Label.getLabel(lexLabel), true);
        }
        int prole = depth == maxDepth - 1 ? 1 : Utility.roulette(branchingProb) + 1;
        String label = internalLabels[(int)(Math.random() * (double)internalLabels.length)];
        TSNodeLabel result = new TSNodeLabel(Label.getLabel(label), false);
        TSNodeLabel[] daughters = new TSNodeLabel[prole];
        unary = prole == 1;
        int i = 0;
        while (i < prole) {
            TSNodeLabel d = TSNodeLabel.getRandomTree(internalLabels, lexLabels, maxBranching, branchingProb, unary, lexProb, depth + 1, maxDepth);
            d.parent = result;
            daughters[i] = d;
            ++i;
        }
        result.daughters = daughters;
        return result;
    }

    public static TSNodeLabel defaultWSJparse(String[] originalTestSentenceWords, String topSymbol) {
        TSNodeLabel result = new TSNodeLabel(Label.getLabel(topSymbol), false);
        TSNodeLabel sNode = new TSNodeLabel(Label.getLabel("S"), false);
        result.daughters = new TSNodeLabel[]{sNode};
        sNode.parent = result;
        sNode.daughters = new TSNodeLabel[originalTestSentenceWords.length];
        Label nnsLabel = Label.getLabel("NN");
        int i = 0;
        while (i < originalTestSentenceWords.length) {
            TSNodeLabel nnsNode = new TSNodeLabel(nnsLabel, false);
            nnsNode.parent = sNode;
            sNode.daughters[i] = nnsNode;
            Label lexLabel = Label.getLabel(originalTestSentenceWords[i]);
            TSNodeLabel lexNode = new TSNodeLabel(lexLabel, true);
            nnsNode.daughters = new TSNodeLabel[]{lexNode};
            lexNode.parent = nnsNode;
            ++i;
        }
        return result;
    }

    public void assignUniqueDaughter(TSNodeLabel firstDaughter) {
        this.daughters = new TSNodeLabel[]{firstDaughter};
        firstDaughter.parent = this;
    }

    public void assignDaughters(TSNodeLabel[] daughters) {
        this.daughters = daughters;
        TSNodeLabel[] tSNodeLabelArray = daughters;
        int n = daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.parent = this;
            ++n2;
        }
    }

    public void assignDaughters(ArrayList<TSNodeLabel> daughters) {
        this.daughters = new TSNodeLabel[daughters.size()];
        int i = 0;
        for (TSNodeLabel d : daughters) {
            d.parent = this;
            this.daughters[i] = d;
            ++i;
        }
    }

    public String toStringQtree() {
        return this.toString().replace("(", "[.").replace(")", " ]").replace("{", "\\{").replace("}", "\\}").replace("$", "\\$").replace("_", "\\_").replace("^", "\\^{}").replace("|", "$|$").replace("<", "$<$").replace(">", "$>$").replace("%", "\\%").replace("&", "\\&");
    }

    public static void getMatchingLabels() throws Exception {
        TSNodeLabelStructure t1 = new TSNodeLabelStructure("(S (NP-SBJ (NNS Analysts)) (VP (VBP say) (SBAR (S (NP-SBJ (NNP USAir)) (VP (VBZ has) (NP (JJ great) (NN promise)))))) (. .))");
        TSNodeLabelStructure t2 = new TSNodeLabelStructure("(S (NP-SBJ (PRP I)) (VP (VBP say) (SBAR (S (NP-SBJ (PRP they)) (VP (VBP are) (ADJP-PRP (JJ ready)))))) (. .))");
        System.out.print("\t");
        TSNodeLabelIndex[] tSNodeLabelIndexArray = t2.structure();
        int n = tSNodeLabelIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabelIndex nodeB = tSNodeLabelIndexArray[n2];
            System.out.print(String.valueOf(nodeB.label()) + "\t");
            ++n2;
        }
        System.out.println();
        int i = 0;
        TSNodeLabelIndex[] tSNodeLabelIndexArray2 = t1.structure();
        int n3 = tSNodeLabelIndexArray2.length;
        n = 0;
        while (n < n3) {
            TSNodeLabelIndex nodeA = tSNodeLabelIndexArray2[n];
            System.out.print(String.valueOf(nodeA.label()) + "\t");
            int j = 0;
            TSNodeLabelIndex[] tSNodeLabelIndexArray3 = t2.structure();
            int n4 = tSNodeLabelIndexArray3.length;
            int n5 = 0;
            while (n5 < n4) {
                TSNodeLabelIndex nodeB = tSNodeLabelIndexArray3[n5];
                if (nodeA.label == nodeB.label) {
                    System.out.print("X");
                }
                System.out.print("\t");
                ++j;
                ++n5;
            }
            System.out.println();
            ++i;
            ++n;
        }
    }

    public int compareTo(TSNodeLabel tree) {
        int otherProle;
        if (this.label != tree.label) {
            return this.label().compareTo(tree.label());
        }
        int thisProle = this.prole();
        if (thisProle != (otherProle = tree.prole())) {
            return thisProle < otherProle ? -1 : 1;
        }
        int i = 0;
        while (i < thisProle) {
            int cmp = this.daughters[i].compareTo(tree.daughters[i]);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public void changeLexLabels(ArrayList<Label> newLabels) {
        ArrayList<TSNodeLabel> lexLabels = this.collectLexicalItems();
        Iterator<TSNodeLabel> iterBest = lexLabels.iterator();
        Iterator<Label> iterator = newLabels.iterator();
        while (iterator.hasNext()) {
            Label nl;
            iterBest.next().label = nl = iterator.next();
        }
    }

    public boolean containsLoops() {
        ArrayList<TSNodeLabel> nodes = this.collectInternalNodes();
        for (TSNodeLabel n : nodes) {
            if (n.prole() != 1 || !n.label.equals(n.firstDaughter().label)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        TSNodeLabel t = new TSNodeLabel("(ROOT (S (NP (DT the) (@NP->_DT (JJ quick) (@NP->_DT_JJ (JJ quick) (@NP->_DT_JJ_JJ (JJ brown) (NN fox))))) (@S->_NP (VP (VBD jumped) (PP (IN over) (NP (DT the) (@NP->_DT (JJ lazy) (NN dog))))) (. .))))");
        System.out.println(t.toStringQtree());
    }
}

