import pathlib
import boto3

# question_path = pathlib.Path("MturkHTML/QualQuestions_image.xml")
question_path = pathlib.Path("MturkHTML/QualQuestions_link.xml")
answer_path = pathlib.Path("MturkHTML/QualAnswers.xml")
qual_name = 'CQ-Qualification-lnk'
endpoint_url = 'https://mturk-requester-sandbox.us-east-1.amazonaws.com'

assert question_path.exists()
assert answer_path.exists()

mturk = boto3.client('mturk',
                     region_name='us-east-1',
                     endpoint_url=endpoint_url)

with open(question_path, mode='r') as f:
    questions = f.read()

with open(answer_path, mode='r') as f:
    answers = f.read()

qual_response = mturk.create_qualification_type(
    Name=qual_name,
    Keywords='qualification, Conditions, Context',
    Description='This is a short test on Mowgli-CoreQuisite\'s instructions.',
    QualificationTypeStatus='Active',
    Test=questions,
    AnswerKey=answers,
    TestDurationInSeconds=10*60
)

print(qual_response['QualificationType']['QualificationTypeId'])