import json
import numpy as np


def evaluate(relations_predict, relations_goldstandard):
    p_relation = 0
    r_relation = 0
    predictions = relations_predict
    gold_relations = relations_goldstandard
    # predictions = [x[x.rfind('/') + 1:-1] for x in predictions]
    # gold_relations = [x[x.rfind('/') + 1:-1] for x in relations_goldstandard]
    if len(gold_relations) == 0:
        p_relation = 100
        r_relation = 100
    else:
        if len(predictions) == 0:
            return p_relation, r_relation
        p_relation = (len(set(predictions) & set(gold_relations)))*1.0 / len(set(predictions))
        r_relation = (len(set(predictions) & set(gold_relations)))*1.0 / len(gold_relations)
    return p_relation, r_relation


def evaluate2(relations_predict, relations_goldstandard):
    p_relation = 0
    r_relation = 0

    falocn_relations = relations_predict
    gold_relations = relations_goldstandard
    # falocn_relations = [x[x.rfind('/') + 1:-1] for x in relations_predict]
    # gold_relations = [x[x.rfind('/') + 1:-1] for x in relations_goldstandard]

    numberSystemRelations = len(gold_relations)
    if numberSystemRelations == 0:
        p_relation = 1
        r_relation = 1
    else:
        intersection = set(gold_relations).intersection(falocn_relations)
        if len(falocn_relations) != 0:
            p_relation = len(intersection) / len(falocn_relations)
        r_relation = len(intersection) / numberSystemRelations

    return p_relation, r_relation


if __name__ == '__main__':
    with open('./QALD9.json', 'r') as f:
        data = json.load(f)
    ps = []
    rs = []
    for item in data:
        p, r = evaluate(item['predict'], item['gold'])
        if p == 100 or r == 100:
            continue
        ps.append(p)
        rs.append(r)
    macro_p = np.mean(ps)
    macro_r = np.mean(rs)
    f1 = 2 * macro_p * macro_r / (macro_p + macro_r)
    print(macro_p, macro_r, f1)