import json
import os

def load_file(path: str, mode: str = "list-strip"):
    if not os.path.exists(path):
        return [] if not mode else ""
    with open(path, "r", encoding="utf-8", newline="\n") as f:
        if mode == "list-strip":
            data = [ii.strip() for ii in f.readlines()]
        elif mode == "str":
            data = f.read()
        elif mode == "list":
            data = list(f.readlines())
        elif mode == "json":
            data = json.loads(f.read())
        elif mode == "json-list":
            data = [json.loads(ii) for ii in f.readlines()]
    return data