import argparse
import os
import numpy as np
from collections import defaultdict

OFFSET = {'Dec': 0, 'Nov': 5, 'Oct': 2}
WEEKDAYS = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']

parser = argparse.ArgumentParser()
parser.add_argument('--logdir', type=str, required=True)
args = parser.parse_args()

all_letters_correct = 0.0
all_letters_total= 0.0
all_words_correct = 0.0
all_words_total = 0.0
num_perfect_puzzles = 0.0
num_total_puzzles = 0.0
letters_correct_weekday = {}
letters_total_weekday = {}
words_correct_weekday ={}
words_total_weekday ={}
num_perfect_puzzles_weekday = {}
num_total_puzzles_weekday = {}
ignore_names = ['Dec0320.json','Dec1620.json','Dec1720.json','Dec2220.json','Dec2320.json','Nov0520.json','Nov1220.json','Nov1820.json','Dec3120.json', 'Nov2220.json','Nov2620.json','Oct0120.json','Oct1120.json','Oct2220.json', 'Nov1920.json']
ignore_names = [i + '.txt' for i in ignore_names]
not_found_total = {}
not_found_correct = {}
for fname in os.listdir(args.logdir):
    if 'puzzle' in fname: # acpt
        continue
    #if fname in ignore_names: # themes 
    #    continue
    weekday = WEEKDAYS[(int(fname[3:5]) + OFFSET[fname[:3]]) % 7]
    not_found_count = 0.0
    file_length = len(open(os.path.join(args.logdir, fname), 'r').readlines())
    with open(os.path.join(args.logdir, fname), 'r') as rf:
        for indx, line in enumerate(rf):
            if 'not found' in line:
                not_found_count += 1
            if 'Letters Correct' in line and '%' not in line and indx==(file_length-2):
                num_total_puzzles += 1
                lc = int(line.split('|')[0].split('/')[0].split(' ')[-1])
                lt = int(line.split('|')[0].split('/')[1].strip())
                wc = int(line.split('|')[1].split('/')[0].split(' ')[-1])
                wt = int(line.split('|')[1].split('/')[1].strip())
                # Letters Correct: 100% | Words Correct: 100%
                #lc = int(line.split('%')[0].split()[-1])
                #wc = int(line.split('%')[1].split()[-1])
                if weekday not in num_perfect_puzzles_weekday:
                    num_perfect_puzzles_weekday[weekday] = 0.0
                    num_total_puzzles_weekday[weekday] = 0.0
                if float(lc) / lt == 1.0:
                    num_perfect_puzzles += 1.0
                    num_perfect_puzzles_weekday[weekday] += 1.0
                num_total_puzzles_weekday[weekday] += 1.0
                all_letters_correct += lc
                all_letters_total += lt
                all_words_correct += wc
                all_words_total += wt
                if weekday not in letters_correct_weekday:
                    letters_correct_weekday[weekday] = 0.0
                    letters_total_weekday[weekday] = 0.0
                    words_correct_weekday[weekday] = 0.0
                    words_total_weekday[weekday] = 0.0
                letters_correct_weekday[weekday] += lc
                letters_total_weekday[weekday] += lt
                words_correct_weekday[weekday] += wc
                words_total_weekday[weekday] += wt
                if not_found_count not in not_found_total:
                    not_found_total[not_found_count] = 0.0
                    not_found_correct[not_found_count] = 0.0
                not_found_total[not_found_count] += lt
                not_found_correct[not_found_count] += lc
                if not_found_count == 10.0:
                    print(fname)
                if lc != lt:
                    print('Errors present in', fname)


#print(all_words_total)
#print(all_letters_total)
print('perfect:', num_perfect_puzzles / num_total_puzzles)
print('Mean letters correct:', all_letters_correct / all_letters_total)
print('Mean words correct:', all_words_correct / all_words_total)
print()
for key in sorted(list(not_found_correct.keys())):
    print('Not found #', key, not_found_correct[key]/not_found_total[key])
print()
for wd in WEEKDAYS:
    print(wd, 'letters', letters_correct_weekday[wd] / letters_total_weekday[wd])
    print(wd, 'words', words_correct_weekday[wd] / words_total_weekday[wd])
    print(wd, 'perfect', num_perfect_puzzles_weekday[wd] / num_total_puzzles_weekday[wd])
print(num_total_puzzles)
