# Recorder Bot for the Tex Prax Project

This bot is intended to work together with a modified version of the synapse server, which can be found in the ```synapserecording``` folder. Dashboard connection requires modifying the example code presented in ```texpraxconnector```.

## Why does this bot exist?
This bot exists as mainly as a data-gathering tool and is used to record chat protocols to collect and annotate data from dialogues about problems ocurring in a production environment.
A preliminary work that focuses on identidying named entities can be found in this [paper](https://www.sciencedirect.com/science/article/pii/S2212827121008787).

## What does the bot do?
The bot automatically joins newly created rooms and private conversations (this part happens on the synapse-server side) and asks the users if they want their messages to be recorded. If the users decline or write messages without responding to the bot, it will leave the room and won't have further access to the messages sent in this room. If the users agree, the bot will store every message the users send. 

Apart from storing messages, the bot also tries to classify every new message sent into one of four categories:

- Problem
- Solution 
- Cause
- Other

The bot then presents the prediction to the users and they can decide whether this classification is correct or if it has to be changed. The bot then also stores the classification that the users decided on together with the corresponding message. 

## Teamboard Integration
We further showcase how messages can be sent to an existing dashboard to improve the tracking of errors and general knowledge management in the factory.
If enabled, the new problems are stored there as well and the corresponding solutions and causes are assigned to them automatically. Note, that this is not a requirement for the bot to work, it also stores the messages locally.

## How to start the bot?
### The OLM library
To use the bot, the OLM library is needed. It might be installed on ubuntu by using the command:

    sudo apt install libolm-dev

Depending on the Ubuntu version however, this package might either not exist or be outdated. In this case, the OLM library needs to be built from scratch. This can be done by first cloning the OLM repo:

    git clone https://gitlab.matrix.org/matrix-org/olm.git olm

And then executing the necessary build commands:

    cd olm
    cmake . -Bbuild
    make

### The python environment
After the OLM library has been successfully built/installed, the actual code for the bot can be downloaded and a new python environment can be created:

    git clone https://git.ukp.informatik.tu-darmstadt.de/stangier/recorder-bot.git recorder-bot
    cd recorder-bot

    python3 -m venv env-bot
    source env-bot/bin/activate
    pip install -r requirements.txt


### Start the bot
Once the previous steps are done, the bot is ready to be started using the following command:

    LD_LIBRARY_PATH=../olm/build/ ./env-bot/bin/python autorecorderbot_start

Please make sure to adjust the paths to the venv and OLM lib accordingly.

## How to use the bot?
### Joining rooms automatically
When the bot joins a room, it automatically sends a message to ask the users about whether it should stay or leave:

![bot_staying](https://i.imgur.com/mErlrPB.png)

If the user types anything else than one of the offered "yes" options, the bot will leave the room:

![bot_leaving](https://i.imgur.com/OaPNDVw.png)

Please also note that once the bot is staying in one room, it is currently not possible to make it leave afterwards. If the users want a new, private, room they must create a new one.

### Classifying sentences
The bot tries to classify every new message that is sent into the room. For example:

![bot_guess_1](https://i.imgur.com/bi0FVyC.png)

In this case, the bot detected sentence type 'O', which translates to 'nothing detected'. As in this case, the correct sentence type is problem, the user can correct the bot:

![bot_correction](https://i.imgur.com/EOsPhyM.png)

### Assignment of Causes and Solutions to corresponding problems
It is also possible to assign causes and solutions to the corresponding problems by replying to the problem:

![bot_add_cause](https://i.imgur.com/jOX5nyM.png)

In this case, the user replied with a cause but the bot did not detect it, so the user corrected the bot. The bot afterwards confirms, that the cause has been stored. This works in a similar fashion with solutions:

![bot_add_sol](https://i.imgur.com/Llk0Y46.png)
