function [Q, R] = orthogonalizetwice(M, x, A)
% Orthonormalizes a basis of tangent vectors twice for increased accuracy.
%
% function [orthobasis, R] = orthogonalizetwice(M, x, basis)
%
% See help for orthogonalize. This function calls that algorithm twice.
% This is useful if elements in the input basis are close to being linearly
% dependent (ill conditioned). See in code for details.
%
% See also: orthogonalize grammatrix tangentorthobasis

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, Oct. 5, 2017.
% Contributors: 
% Change log: 

    [Q1, R1] = orthogonalize(M, x, A);
    [Q , R2] = orthogonalize(M, x, Q1);

    R = R2*R1; % This is upper triangular since R1 and R2 are.

end
