/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.tag;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import matetools.is2.data.F2SF;
import matetools.is2.data.FV;
import matetools.is2.data.Instances;
import matetools.is2.data.InstancesTagger;
import matetools.is2.data.Long2Int;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.ParametersFloat;
import matetools.is2.data.PipeGen;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;
import matetools.is2.io.CONLLWriter09;
import matetools.is2.tag.ExtractorT2;
import matetools.is2.tag.MFO;
import matetools.is2.tag.Options;
import matetools.is2.tag.POS;
import matetools.is2.tools.IPipe;
import matetools.is2.tools.Tool;
import matetools.is2.tools.Train;
import matetools.is2.util.DB;
import matetools.is2.util.Evaluator;
import matetools.is2.util.OptionsSuper;

public class Tagger
implements Tool,
Train {
    public ExtractorT2 pipe;
    public ParametersFloat params;
    public Long2IntInterface li;
    public MFO mf;
    private OptionsSuper _options;

    public Tagger(Options options) {
        try {
            this.readModel(options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Tagger() {
    }

    public Tagger(String modelFileName) {
        this(new Options(new String[]{"-model", modelFileName}));
    }

    public static void main(String[] args) throws FileNotFoundException, Exception {
        long start = System.currentTimeMillis();
        Options options = new Options(args);
        Tagger tagger = new Tagger();
        if (options.train) {
            tagger.li = new Long2Int(options.hsize);
            tagger.mf = new MFO();
            tagger.pipe = new ExtractorT2(options, tagger.mf);
            InstancesTagger is = (InstancesTagger)tagger.pipe.createInstances(options.trainfile);
            tagger.params = new ParametersFloat(tagger.li.size());
            tagger.train(options, tagger.pipe, tagger.params, is);
            tagger.writeModel(options, tagger.pipe, tagger.params);
        }
        if (options.test) {
            tagger.readModel(options);
            tagger.out(options, tagger.pipe, tagger.params);
        }
        System.out.println();
        if (options.eval) {
            System.out.println("\nEVALUATION PERFORMANCE:");
            Evaluator.evaluateTagger(options.goldfile, options.outfile, options.format);
        }
        long end = System.currentTimeMillis();
        System.out.println("used time " + (float)((end - start) / 100L) / 10.0f);
    }

    @Override
    public void readModel(OptionsSuper options) {
        try {
            this.mf = new MFO();
            this.pipe = new ExtractorT2(options, this.mf);
            this._options = options;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(options.modelName)));
            zis.getNextEntry();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(zis));
            this.pipe.mf.read(dis);
            this.pipe.initValues();
            this.pipe.initFeatures();
            this.params = new ParametersFloat(0);
            this.params.read(dis);
            this.li = new Long2Int(this.params.parameters.length);
            this.pipe.read(dis);
            dis.close();
            this.pipe.types = new String[this.pipe.mf.getFeatureCounter().get("POS").intValue()];
            for (Map.Entry<String, Integer> e : this.pipe.mf.getFeatureSet().get("POS").entrySet()) {
                this.pipe.types[e.getValue().intValue()] = e.getKey();
            }
            DB.println("Loading data finished. ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void train(OptionsSuper options, IPipe pipe, ParametersFloat params, Instances is2) {
        InstancesTagger is = (InstancesTagger)is2;
        String[] wds = MFO.reverse(this.pipe.mf.getFeatureSet().get("WORD"));
        int[] pd = new int[this.pipe.types.length];
        int k = 0;
        while (k < pd.length) {
            pd[k] = k;
            ++k;
        }
        int del = 0;
        F2SF f = new F2SF(params.parameters);
        long[] vs = new long[71];
        int types = this.pipe.types.length;
        double upd = options.numIters * is.size() + 1;
        int i = 0;
        while (i < options.numIters) {
            long start = System.currentTimeMillis();
            int numInstances = is.size();
            long last = System.currentTimeMillis();
            FV pred = new FV();
            FV gold = new FV();
            int correct = 0;
            int count = 0;
            System.out.print("Iteration " + i + ": ");
            int n = 0;
            while (n < numInstances) {
                if ((n + 1) % 500 == 0) {
                    del = PipeGen.outValueErr(n + 1, count - correct, (float)correct / (float)count, del, last, upd);
                }
                int length = is.length(n);
                upd -= 1.0;
                int w = 1;
                while (w < length) {
                    double best = -1000.0;
                    int bestType = -1;
                    int[] lemmas = options.noLemmas ? new int[is.length(n)] : is.plemmas[n];
                    this.pipe.addFeatures(is, n, wds[is.forms[n][w]], w, is.gpos[n], is.forms[n], lemmas, vs);
                    int t = 0;
                    while (t < types) {
                        long p = t << ExtractorT2.s_type;
                        f.clear();
                        int k1 = 0;
                        while (vs[k1] != Integer.MIN_VALUE) {
                            if (vs[k1] > 0L) {
                                f.add(this.li.l2i(vs[k1] | p));
                            }
                            ++k1;
                        }
                        if ((double)f.score > best) {
                            bestType = t;
                            best = f.score;
                        }
                        t = (short)(t + 1);
                    }
                    ++count;
                    if (bestType == is.gpos[n][w]) {
                        ++correct;
                    } else {
                        pred.clear();
                        int k1 = 0;
                        while (vs[k1] != Integer.MIN_VALUE) {
                            if (vs[k1] > 0L) {
                                pred.add(this.li.l2i(vs[k1] | (long)(bestType << ExtractorT2.s_type)));
                            }
                            ++k1;
                        }
                        gold.clear();
                        k1 = 0;
                        while (vs[k1] != Integer.MIN_VALUE) {
                            if (vs[k1] > 0L) {
                                gold.add(this.li.l2i(vs[k1] | (long)(is.gpos[n][w] << ExtractorT2.s_type)));
                            }
                            ++k1;
                        }
                        params.update(pred, gold, (float)upd, 1.0f);
                    }
                    ++w;
                }
                ++n;
            }
            long end = System.currentTimeMillis();
            String info = "time " + (end - start);
            PipeGen.outValueErr(numInstances, count - correct, (float)correct / (float)count, del, last, upd, info);
            System.out.println();
            del = 0;
            ++i;
        }
        params.average(options.numIters * is.size());
    }

    @Override
    public void out(OptionsSuper options, IPipe pipe, ParametersFloat params) {
        try {
            long start = System.currentTimeMillis();
            CONLLReader09 depReader = new CONLLReader09(options.testfile);
            CONLLWriter09 depWriter = new CONLLWriter09(options.outfile);
            System.out.print("Processing Sentence: ");
            pipe.initValues();
            int cnt = 0;
            int del = 0;
            while (true) {
                InstancesTagger is = new InstancesTagger();
                is.init(1, this.mf);
                SentenceData09 instance = depReader.getNext(is);
                if (instance == null || instance.forms == null) break;
                is.fillChars(instance, 0, ExtractorT2._CEND);
                this.tag(is, instance);
                SentenceData09 i09 = new SentenceData09(instance);
                i09.createSemantic(instance);
                depWriter.write(i09);
                if (++cnt % 100 != 0) continue;
                del = PipeGen.outValue(cnt, del);
            }
            del = PipeGen.outValue(cnt, del);
            depWriter.finishWriting();
            float min = 1000.0f;
            float max = -1000.0f;
            long end = System.currentTimeMillis();
            System.out.println(PipeGen.getSecondsPerInstnace(cnt, end - start));
            System.out.println(PipeGen.getUsedTime(end - start));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SentenceData09 tag(SentenceData09 instance) {
        InstancesTagger is = new InstancesTagger();
        is.init(1, this.pipe.mf);
        new CONLLReader09().insert(is, instance);
        is.fillChars(instance, 0, ExtractorT2._CEND);
        this.tag(is, instance);
        return instance;
    }

    private void tag(InstancesTagger is, SentenceData09 instance) {
        short bestType;
        int length = instance.ppos.length;
        short[] pos = new short[instance.gpos.length];
        float[] sc = new float[instance.ppos.length];
        instance.ppos[0] = "<root-POS>";
        pos[0] = (short)this.pipe.mf.getValue("POS", "<root-POS>");
        int j = 1;
        while (j < length) {
            pos[j] = bestType = (short)this.pipe.fillFeatureVectorsOne(instance.forms[j], this.params, j, is, 0, pos, this.li, sc);
            instance.ppos[j] = this.pipe.types[bestType];
            ++j;
        }
        j = 1;
        while (j < length) {
            bestType = (short)this.pipe.fillFeatureVectorsOne(instance.forms[j], this.params, j, is, 0, pos, this.li, sc);
            instance.ppos[j] = this.pipe.types[bestType];
            pos[j] = bestType;
            ++j;
        }
    }

    public ArrayList<POS> tag(InstancesTagger is, int instanceIndex, int word, String wordForm) {
        return this.pipe.classify(wordForm, this.params, word, is, instanceIndex, is.pposs[instanceIndex], this.li);
    }

    public ArrayList<String> tagStrings(InstancesTagger is, int instanceIndex, int word, String wordForm) {
        ArrayList<POS> plist = this.pipe.classify(wordForm, this.params, word, is, instanceIndex, is.pposs[instanceIndex], this.li);
        String[] pos = MFO.reverse(this.pipe.mf.getFeatureSet().get("POS"));
        ArrayList postags = null;
        for (POS p : plist) {
            try {
                postags.add(pos[p.p]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return postags;
    }

    public String[] tag(String[] words, String[] lemmas) {
        String[] pposs = new String[words.length];
        try {
            this.pipe.initValues();
            int length = words.length + 1;
            InstancesTagger is = new InstancesTagger();
            is.init(1, this.pipe.mf);
            is.createInstance09(length);
            SentenceData09 instance = new SentenceData09();
            instance.forms = new String[length];
            instance.forms[0] = "<root>";
            instance.plemmas = new String[length];
            instance.plemmas[0] = "<root-LEMMA>";
            int j = 0;
            while (j < words.length) {
                instance.forms[j + 1] = words[j];
                instance.plemmas[j + 1] = lemmas[j];
                ++j;
            }
            j = 0;
            while (j < length) {
                is.setForm(0, j, instance.forms[j]);
                is.setLemma(0, j, instance.plemmas[j]);
                ++j;
            }
            instance.ppos = new String[length];
            is.fillChars(instance, 0, ExtractorT2._CEND);
            this.tag(is, instance);
            j = 0;
            while (j < words.length) {
                pposs[j] = instance.ppos[j + 1];
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pposs;
    }

    @Override
    public SentenceData09 apply(SentenceData09 snt) {
        SentenceData09 it = new SentenceData09();
        it.createWithRoot(snt);
        it = this.tag(it);
        SentenceData09 i09 = new SentenceData09(it);
        i09.createSemantic(it);
        return i09;
    }

    @Override
    public void writeModel(OptionsSuper options, IPipe pipe, ParametersFloat params) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(options.modelName)));
            zos.putNextEntry(new ZipEntry("data"));
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            this.pipe.mf.writeData(dos);
            DB.println("number of parameters " + params.parameters.length);
            dos.flush();
            params.write(dos);
            pipe.write(dos);
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

