/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.record.Receiver;
import fig.record.RecordServerInterface;
import fig.record.ResultReceiver;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class CommandProcessor {
    private RecordServerInterface server;
    private Receiver receiver;
    private boolean isClient;
    private boolean firewall;

    public CommandProcessor(RecordServerInterface server, String baseTempDir, boolean isClient, boolean firewall) {
        this.server = server;
        this.receiver = new Receiver(baseTempDir, LogInfo.stdout, LogInfo.stderr);
        this.isClient = isClient;
        this.firewall = firewall;
    }

    public CommandProcessor(RecordServerInterface server, Receiver receiver, boolean isClient, boolean firewall) {
        this.server = server;
        this.receiver = receiver;
        this.isClient = isClient;
        this.firewall = firewall;
    }

    public void processCommand(String line) {
        try {
            ResultReceiver result;
            if (this.isClient) {
                UnicastRemoteObject.exportObject(this.receiver);
            }
            if ((result = this.server.processCommand(line, this.firewall ? null : this.receiver)) != null) {
                this.receiver.addResult(result);
            }
            if (this.isClient) {
                UnicastRemoteObject.unexportObject(this.receiver, false);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void processCommandFile(String path) {
        for (String line : IOUtils.readProgramLinesHard(path)) {
            this.processCommand(line);
        }
    }

    public void processCommandFiles(List<String> paths) {
        for (String path : paths) {
            this.processCommandFile(path);
        }
    }
}

