
[ROLE]
You are expert in extracting relevant and concise information from any user query. 
---
[INPUT]
You will be given `query`. This `query` is a command for generating a python code function. 
---
[TASK]
You need to extract all relevant information from the `query` and store in structured JSON format. For completing the getting all information, extract in the form of these BUCKETS:-
[BUCKETS]
1. "task": Extract main/prime task to be performed in the function. It has be derived essence and not always word by word extracted. It can NOT be generic like find/return/give...
2. "method": Extract list of any specific method/technique/using/algorithm mentioned to get to result
3. "input_type": Extract the list of all input data types to function if explicitly mentioned
4. "input_property": Extract all list of extra conditions/parameters/properties regarding the input e.g. starting/ending point, condition/criteria applied, property of input like length, shape, size, number, largeness, order, large/small/top... These can be adjectives to input_type, numerics, or arguments associated to input for function
5. "output_type": Extract the list of all output data type returned by function if explicitly mentioned
6. "output_property": Extract all list of extra conditions/parameters/properties regarding the output e.g. odd/even, condition/criteria applied, property of input like length, shape, size, number, largeness, order... These can be adjectives to output_type, numerics, or arguments associated to output for function
7. "edge_cases": Extract the dictionary of all edge/critical condition and response if explicitly mentioned
- Each key value should be explicitly word-by-word extracted from `query`, explicitly mentioned and traceable back to the `query`. They should NOT be derive/understanding knowledge.
- Return response in JSON format template:
{"task": "...", "method": [...], "input_type": [...], "input_property": [...], "output_type": [...], "output_property": [...], "edge_cases": {...}}
---

`query`: Write a python function to give product number in words all in lowercase, of an integer with first k items of two given lists using lambda function. If any list is empty, return '-'.
`info`: {"task": "product", "method": ["lambda function"], "input_type": ["integer","list"], "input_property": ["first k", "two"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "'-'"}}
---

`query`: Write a function to return ascending sort on list.
`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": [], "output_type": [], "output_property": ["ascending"], "edge_cases": {}}
---

`query`: Write a function to find largest number from a list.
`info`: {"task": "find number", "method": [], "input_type": ["list"], "input_property": [], "output_type": [], "output_property": ["largest"], "edge_cases": {}}
---

`query`: Check if input is even.
`info`: {"task": "check even", "method": [], "input_type": [], "input_property": [], "output_type": [], "output_property": [], "edge_cases": {}}
---

`query`: Return string with words longer than 10.
`info`: {"task": "filter", "method": [], "input_type": ["string"], "input_property": [], "output_type": [], "output_property": ["longer than 10"], "edge_cases": {}}
---

`query`: {{originalNL}}
`info`: 